/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0A, Date: 26-May-2006.
 */
#include "asn1intl.h"
#include "UBL-OrderResponse-1-0.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  EarliestDateType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_OrderResponse_1_0_EarliestDateType (OSCTXT* pctxt,
   UBL_OrderResponse_1_0_EarliestDateType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EarliestDate                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_OrderResponse_1_0_EarliestDate (OSCTXT* pctxt,
   UBL_OrderResponse_1_0_EarliestDate *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_OrderResponse_1_0_EarliestDateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ValidityDurationMeasureType                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_OrderResponse_1_0_ValidityDurationMeasureType (OSCTXT* pctxt,
   UBL_OrderResponse_1_0_ValidityDurationMeasureType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode measureUnitCode */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCode, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode measureUnitCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.measureUnitCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ValidityDurationMeasure                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_OrderResponse_1_0_ValidityDurationMeasure (OSCTXT* pctxt,
   UBL_OrderResponse_1_0_ValidityDurationMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_OrderResponse_1_0_ValidityDurationMeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PackagesCountQuantityType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_OrderResponse_1_0_PackagesCountQuantityType (OSCTXT* pctxt,
   UBL_OrderResponse_1_0_PackagesCountQuantityType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode quantityUnitCode */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCode, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode quantityUnitCodeListAgencyID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCodeListAgencyID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityUnitCodeListAgencyIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode quantityUnitCodeListAgencyName */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCodeListAgencyName, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityUnitCodeListAgencyNamePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode quantityUnitCodeListID */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCodeListID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityUnitCodeListIDPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TotalPackagesCountQuantity                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_OrderResponse_1_0_TotalPackagesCountQuantity (OSCTXT* pctxt,
   UBL_OrderResponse_1_0_TotalPackagesCountQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_OrderResponse_1_0_PackagesCountQuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LineItemCountNumericType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_OrderResponse_1_0_LineItemCountNumericType (OSCTXT* pctxt,
   UBL_OrderResponse_1_0_LineItemCountNumericType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LineItemCountNumeric                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_OrderResponse_1_0_LineItemCountNumeric (OSCTXT* pctxt,
   UBL_OrderResponse_1_0_LineItemCountNumeric *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_OrderResponse_1_0_LineItemCountNumericType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OrderResponseType_orderReference_list                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_OrderResponseType_orderReference_list (OSCTXT* pctxt,
   OrderResponseType_orderReference_list *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   OrderReference* pdata;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, OrderReference, &pnode, &pdata);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_OrderReference (pdata);

      stat = asn1D_OrderReference (pctxt, 
         pdata, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OriginatorParty                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_OrderResponse_1_0_OriginatorParty (OSCTXT* pctxt,
   UBL_OrderResponse_1_0_OriginatorParty *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_PartyType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FreightForwarderParty                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_OrderResponse_1_0_FreightForwarderParty (OSCTXT* pctxt,
   UBL_OrderResponse_1_0_FreightForwarderParty *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_PartyType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DestinationCountry                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_OrderResponse_1_0_DestinationCountry (OSCTXT* pctxt,
   UBL_OrderResponse_1_0_DestinationCountry *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_CountryType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RespondedOrderLine                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RespondedOrderLine (OSCTXT* pctxt,
   RespondedOrderLine *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_OrderLineType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OrderResponseType_respondedOrderLine_list                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_OrderResponseType_respondedOrderLine_list (OSCTXT* pctxt,
   OrderResponseType_respondedOrderLine_list *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   RespondedOrderLine* pdata;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, RespondedOrderLine, &pnode, &pdata);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_RespondedOrderLine (pdata);

      stat = asn1D_RespondedOrderLine (pctxt, 
         pdata, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OrderResponseType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_OrderResponseType (OSCTXT* pctxt,
   OrderResponseType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode buyersID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_UnspecializedDatatypes_1_0_IdentifierType (pctxt, 
               &pvalue->buyersID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.buyersIDPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode sellersID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_UnspecializedDatatypes_1_0_IdentifierType (pctxt, 
               &pvalue->sellersID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sellersIDPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 2:
         /* decode copyIndicator */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CopyIndicator (pctxt, 
               &pvalue->copyIndicator, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.copyIndicatorPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode gUID */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_UnspecializedDatatypes_1_0_IdentifierType (pctxt, 
               &pvalue->gUID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.gUIDPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode issueDate */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_IssueDate (pctxt, 
               &pvalue->issueDate, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode documentStatusCode */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DocumentStatusCodeType (pctxt, 
               &pvalue->documentStatusCode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.documentStatusCodePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode note */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Note (pctxt, 
               &pvalue->note, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.notePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode transactionCurrencyCode */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CurrencyCodeType (pctxt, 
               &pvalue->transactionCurrencyCode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transactionCurrencyCodePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 8:
         /* decode pricingCurrencyCode */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CurrencyCodeType (pctxt, 
               &pvalue->pricingCurrencyCode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.pricingCurrencyCodePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 9:
         /* decode earliestDate */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_OrderResponse_1_0_EarliestDate (pctxt, 
               &pvalue->earliestDate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.earliestDatePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 10:
         /* decode expiryDate */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ExpiryDate (pctxt, 
               &pvalue->expiryDate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.expiryDatePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 11:
         /* decode validityDurationMeasure */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_OrderResponse_1_0_ValidityDurationMeasure (pctxt, 
               &pvalue->validityDurationMeasure, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.validityDurationMeasurePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 12:
         /* decode taxTotalAmount */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TaxTotalAmount (pctxt, 
               &pvalue->taxTotalAmount, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.taxTotalAmountPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 13:
         /* decode lineExtensionTotalAmount */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_LineExtensionTotalAmount (pctxt, 
               &pvalue->lineExtensionTotalAmount, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.lineExtensionTotalAmountPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 14:
         /* decode totalPackagesCountQuantity */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_OrderResponse_1_0_TotalPackagesCountQuantity (pctxt, 
               &pvalue->totalPackagesCountQuantity, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.totalPackagesCountQuantityPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 15:
         /* decode grossWeightMeasure */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_GrossWeightMeasure (pctxt, 
               &pvalue->grossWeightMeasure, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.grossWeightMeasurePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 16:
         /* decode netWeightMeasure */
         if (XD_PEEKTAG (pctxt, 0x90)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NetWeightMeasure (pctxt, 
               &pvalue->netWeightMeasure, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.netWeightMeasurePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 17:
         /* decode netNetWeightMeasure */
         if (XD_PEEKTAG (pctxt, 0x91)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NetNetWeightMeasure (pctxt, 
               &pvalue->netNetWeightMeasure, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.netNetWeightMeasurePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 18:
         /* decode grossVolumeMeasure */
         if (XD_PEEKTAG (pctxt, 0x92)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_GrossVolumeMeasure (pctxt, 
               &pvalue->grossVolumeMeasure, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.grossVolumeMeasurePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 19:
         /* decode netVolumeMeasure */
         if (XD_PEEKTAG (pctxt, 0x93)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NetVolumeMeasure (pctxt, 
               &pvalue->netVolumeMeasure, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.netVolumeMeasurePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 20:
         /* decode lineItemCountNumeric */
         if (XD_PEEKTAG (pctxt, 0x94)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_OrderResponse_1_0_LineItemCountNumeric (pctxt, 
               &pvalue->lineItemCountNumeric, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.lineItemCountNumericPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 21:
         /* decode orderReference_list */
         if (XD_PEEKTAG (pctxt, 0x95)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_OrderResponseType_orderReference_list (pctxt, 
               &pvalue->orderReference_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 22:
         /* decode buyerParty */
         if (XD_PEEKTAG (pctxt, 0x96)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_BuyerParty (pctxt, 
               &pvalue->buyerParty, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 23:
         /* decode sellerParty */
         if (XD_PEEKTAG (pctxt, 0x97)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SellerParty (pctxt, 
               &pvalue->sellerParty, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 24:
         /* decode originatorParty */
         if (XD_PEEKTAG (pctxt, 0x98)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_OrderResponse_1_0_OriginatorParty (pctxt, 
               &pvalue->originatorParty, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.originatorPartyPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 25:
         /* decode freightForwarderParty */
         if (XD_PEEKTAG (pctxt, 0x99)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_OrderResponse_1_0_FreightForwarderParty (pctxt, 
               &pvalue->freightForwarderParty, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.freightForwarderPartyPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 26:
         /* decode delivery_list */
         if (XD_PEEKTAG (pctxt, 0x9a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfDelivery (pctxt, 
               &pvalue->delivery_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 27:
         /* decode deliveryTerms */
         if (XD_PEEKTAG (pctxt, 0x9b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DeliveryTerms (pctxt, 
               &pvalue->deliveryTerms, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.deliveryTermsPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 28:
         /* decode allowanceCharge_list */
         if (XD_PEEKTAG (pctxt, 0x9c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfAllowanceCharge (pctxt, 
               &pvalue->allowanceCharge_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 29:
         /* decode salesConditions */
         if (XD_PEEKTAG (pctxt, 0x9d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SalesConditions (pctxt, 
               &pvalue->salesConditions, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.salesConditionsPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 30:
         /* decode destinationCountry */
         if (XD_PEEKTAG (pctxt, 0x9e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_OrderResponse_1_0_DestinationCountry (pctxt, 
               &pvalue->destinationCountry, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.destinationCountryPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 31:
         /* decode respondedOrderLine_list */
         if ((stat = xd_match (pctxt, TM_CTXT|TM_CONS|31, &length, XM_ADVANCE)) == 0) {
            stat = asn1D_OrderResponseType_respondedOrderLine_list (pctxt, 
               &pvalue->respondedOrderLine_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 32:
         /* decode paymentMeans */
         if ((stat = xd_match (pctxt, TM_CTXT|TM_CONS|32, &length, XM_ADVANCE)) == 0) {
            stat = asn1D_PaymentMeans (pctxt, 
               &pvalue->paymentMeans, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.paymentMeansPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         else if (stat == RTERR_IDNOTFOU) {
            stat = rtxErrReset (pctxt);
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_CONS|15):
         case (TM_CTXT|TM_CONS|16):
         case (TM_CTXT|TM_CONS|17):
         case (TM_CTXT|TM_CONS|18):
         case (TM_CTXT|TM_CONS|19):
         case (TM_CTXT|TM_CONS|20):
         case (TM_CTXT|TM_CONS|21):
         case (TM_CTXT|TM_CONS|22):
         case (TM_CTXT|TM_CONS|23):
         case (TM_CTXT|TM_CONS|24):
         case (TM_CTXT|TM_CONS|25):
         case (TM_CTXT|TM_CONS|26):
         case (TM_CTXT|TM_CONS|27):
         case (TM_CTXT|TM_CONS|28):
         case (TM_CTXT|TM_CONS|29):
         case (TM_CTXT|TM_CONS|30):
         case (TM_CTXT|TM_CONS|31):
         case (TM_CTXT|TM_CONS|32):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 7) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OrderResponse                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_OrderResponse (OSCTXT* pctxt,
   OrderResponse *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_OrderResponseType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PackagesCountQuantity                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_OrderResponse_1_0_PackagesCountQuantity (OSCTXT* pctxt,
   UBL_OrderResponse_1_0_PackagesCountQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_OrderResponse_1_0_PackagesCountQuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

