/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0A, Date: 26-May-2006.
 */
#include "asn1intl.h"
#include "UBL-Invoice-1-0.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  TaxPointDateType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TaxPointDateType (OSCTXT* pctxt,
   TaxPointDateType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TaxPointDate                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TaxPointDate (OSCTXT* pctxt,
   TaxPointDate *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TaxPointDateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LineItemCountNumericType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_Invoice_1_0_LineItemCountNumericType (OSCTXT* pctxt,
   UBL_Invoice_1_0_LineItemCountNumericType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LineItemCountNumeric                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_Invoice_1_0_LineItemCountNumeric (OSCTXT* pctxt,
   UBL_Invoice_1_0_LineItemCountNumeric *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_Invoice_1_0_LineItemCountNumericType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DespatchDocumentReference                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DespatchDocumentReference (OSCTXT* pctxt,
   DespatchDocumentReference *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DocumentReferenceType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfDespatchDocumentReference                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D__SeqOfDespatchDocumentReference (OSCTXT* pctxt,
   _SeqOfDespatchDocumentReference *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   DespatchDocumentReference* pdata;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, DespatchDocumentReference, &pnode, &pdata);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_DespatchDocumentReference (pdata);

      stat = asn1D_DespatchDocumentReference (pctxt, 
         pdata, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ReceiptDocumentReference                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ReceiptDocumentReference (OSCTXT* pctxt,
   ReceiptDocumentReference *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DocumentReferenceType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfReceiptDocumentReference                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D__SeqOfReceiptDocumentReference (OSCTXT* pctxt,
   _SeqOfReceiptDocumentReference *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ReceiptDocumentReference* pdata;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, ReceiptDocumentReference, &pnode, &pdata);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_ReceiptDocumentReference (pdata);

      stat = asn1D_ReceiptDocumentReference (pctxt, 
         pdata, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AdditionalDocumentReference                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AdditionalDocumentReference (OSCTXT* pctxt,
   AdditionalDocumentReference *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DocumentReferenceType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfAdditionalDocumentReference                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D__SeqOfAdditionalDocumentReference (OSCTXT* pctxt,
   _SeqOfAdditionalDocumentReference *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   AdditionalDocumentReference* pdata;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, AdditionalDocumentReference, &pnode, &pdata);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_AdditionalDocumentReference (pdata);

      stat = asn1D_AdditionalDocumentReference (pctxt, 
         pdata, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InvoiceType_invoiceLine_list                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_InvoiceType_invoiceLine_list (OSCTXT* pctxt,
   InvoiceType_invoiceLine_list *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   InvoiceLine* pdata;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, InvoiceLine, &pnode, &pdata);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_InvoiceLine (pdata);

      stat = asn1D_InvoiceLine (pctxt, 
         pdata, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InvoiceType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_InvoiceType (OSCTXT* pctxt,
   InvoiceType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode iD */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_UnspecializedDatatypes_1_0_IdentifierType (pctxt, 
               &pvalue->iD, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode copyIndicator */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CopyIndicator (pctxt, 
               &pvalue->copyIndicator, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.copyIndicatorPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 2:
         /* decode gUID */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_UnspecializedDatatypes_1_0_IdentifierType (pctxt, 
               &pvalue->gUID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.gUIDPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode issueDate */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_IssueDate (pctxt, 
               &pvalue->issueDate, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode invoiceTypeCode */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_UnspecializedDatatypes_1_0_CodeType (pctxt, 
               &pvalue->invoiceTypeCode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.invoiceTypeCodePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode note */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Note (pctxt, 
               &pvalue->note, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.notePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode taxPointDate */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TaxPointDate (pctxt, 
               &pvalue->taxPointDate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.taxPointDatePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode invoiceCurrencyCode */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CurrencyCodeType (pctxt, 
               &pvalue->invoiceCurrencyCode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.invoiceCurrencyCodePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 8:
         /* decode taxCurrencyCode */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CurrencyCodeType (pctxt, 
               &pvalue->taxCurrencyCode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.taxCurrencyCodePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 9:
         /* decode pricingCurrencyCode */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CurrencyCodeType (pctxt, 
               &pvalue->pricingCurrencyCode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.pricingCurrencyCodePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 10:
         /* decode lineItemCountNumeric */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_Invoice_1_0_LineItemCountNumeric (pctxt, 
               &pvalue->lineItemCountNumeric, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.lineItemCountNumericPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 11:
         /* decode orderReference_list */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfOrderReference (pctxt, 
               &pvalue->orderReference_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 12:
         /* decode despatchDocumentReference_list */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfDespatchDocumentReference (pctxt, 
               &pvalue->despatchDocumentReference_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 13:
         /* decode receiptDocumentReference_list */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfReceiptDocumentReference (pctxt, 
               &pvalue->receiptDocumentReference_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 14:
         /* decode additionalDocumentReference_list */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfAdditionalDocumentReference (pctxt, 
               &pvalue->additionalDocumentReference_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 15:
         /* decode buyerParty */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_BuyerParty (pctxt, 
               &pvalue->buyerParty, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 16:
         /* decode sellerParty */
         if (XD_PEEKTAG (pctxt, 0x90)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SellerParty (pctxt, 
               &pvalue->sellerParty, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 17:
         /* decode delivery_list */
         if (XD_PEEKTAG (pctxt, 0x91)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfDelivery (pctxt, 
               &pvalue->delivery_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 18:
         /* decode paymentMeans */
         if (XD_PEEKTAG (pctxt, 0x92)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PaymentMeans (pctxt, 
               &pvalue->paymentMeans, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.paymentMeansPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 19:
         /* decode paymentTerms_list */
         if (XD_PEEKTAG (pctxt, 0x93)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfPaymentTerms (pctxt, 
               &pvalue->paymentTerms_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 20:
         /* decode allowanceCharge_list */
         if (XD_PEEKTAG (pctxt, 0x94)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfAllowanceCharge (pctxt, 
               &pvalue->allowanceCharge_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 21:
         /* decode exchangeRate */
         if (XD_PEEKTAG (pctxt, 0x95)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ExchangeRate (pctxt, 
               &pvalue->exchangeRate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.exchangeRatePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 22:
         /* decode taxTotal_list */
         if (XD_PEEKTAG (pctxt, 0x96)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfTaxTotal (pctxt, 
               &pvalue->taxTotal_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 23:
         /* decode legalTotal */
         if (XD_PEEKTAG (pctxt, 0x97)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_LegalTotal (pctxt, 
               &pvalue->legalTotal, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 24:
         /* decode invoiceLine_list */
         if (XD_PEEKTAG (pctxt, 0x98)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_InvoiceType_invoiceLine_list (pctxt, 
               &pvalue->invoiceLine_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_CONS|15):
         case (TM_CTXT|TM_CONS|16):
         case (TM_CTXT|TM_CONS|17):
         case (TM_CTXT|TM_CONS|18):
         case (TM_CTXT|TM_CONS|19):
         case (TM_CTXT|TM_CONS|20):
         case (TM_CTXT|TM_CONS|21):
         case (TM_CTXT|TM_CONS|22):
         case (TM_CTXT|TM_CONS|23):
         case (TM_CTXT|TM_CONS|24):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 14) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Invoice                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Invoice (OSCTXT* pctxt,
   Invoice *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_InvoiceType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

