/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0A, Date: 26-May-2006.
 */
#include "asn1intl.h"
#include "UBL-DespatchAdvice-1-0.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  LineItemCountNumericType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LineItemCountNumericType (OSCTXT* pctxt,
   LineItemCountNumericType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LineItemCountNumeric                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LineItemCountNumeric (OSCTXT* pctxt,
   LineItemCountNumeric *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_LineItemCountNumericType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfOrderReference                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D__SeqOfOrderReference (OSCTXT* pctxt,
   _SeqOfOrderReference *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   OrderReference* pdata;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, OrderReference, &pnode, &pdata);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_OrderReference (pdata);

      stat = asn1D_OrderReference (pctxt, 
         pdata, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FreightForwarderParty                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_FreightForwarderParty (OSCTXT* pctxt,
   FreightForwarderParty *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_PartyType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DespatchedTransportHandlingUnit                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DespatchedTransportHandlingUnit (OSCTXT* pctxt,
   DespatchedTransportHandlingUnit *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TransportHandlingUnitType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfDespatchedTransportHandlingUnit                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D__SeqOfDespatchedTransportHandlingUnit (OSCTXT* pctxt,
   _SeqOfDespatchedTransportHandlingUnit *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   DespatchedTransportHandlingUnit* pdata;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, DespatchedTransportHandlingUnit, &pnode, &pdata);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_DespatchedTransportHandlingUnit (pdata);

      stat = asn1D_DespatchedTransportHandlingUnit (pctxt, 
         pdata, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ActualShipment                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ActualShipment (OSCTXT* pctxt,
   ActualShipment *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ShipmentType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DespatchAdviceType_despatchLine_list                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DespatchAdviceType_despatchLine_list (OSCTXT* pctxt,
   DespatchAdviceType_despatchLine_list *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   DespatchLine* pdata;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, DespatchLine, &pnode, &pdata);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_DespatchLine (pdata);

      stat = asn1D_DespatchLine (pctxt, 
         pdata, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DespatchAdviceType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DespatchAdviceType (OSCTXT* pctxt,
   DespatchAdviceType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode iD */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_UnspecializedDatatypes_1_0_IdentifierType (pctxt, 
               &pvalue->iD, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode copyIndicator */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CopyIndicator (pctxt, 
               &pvalue->copyIndicator, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.copyIndicatorPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 2:
         /* decode gUID */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_UnspecializedDatatypes_1_0_IdentifierType (pctxt, 
               &pvalue->gUID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.gUIDPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode issueDate */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_IssueDate (pctxt, 
               &pvalue->issueDate, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode documentStatusCode */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DocumentStatusCodeType (pctxt, 
               &pvalue->documentStatusCode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.documentStatusCodePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode despatchAdviceTypeCode */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UBL_UnspecializedDatatypes_1_0_CodeType (pctxt, 
               &pvalue->despatchAdviceTypeCode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.despatchAdviceTypeCodePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode note */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Note (pctxt, 
               &pvalue->note, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.notePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode lineItemCountNumeric */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_LineItemCountNumeric (pctxt, 
               &pvalue->lineItemCountNumeric, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.lineItemCountNumericPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 8:
         /* decode orderReference_list */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfOrderReference (pctxt, 
               &pvalue->orderReference_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 9:
         /* decode buyerParty */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_BuyerParty (pctxt, 
               &pvalue->buyerParty, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 10:
         /* decode sellerParty */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SellerParty (pctxt, 
               &pvalue->sellerParty, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 11:
         /* decode freightForwarderParty */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_FreightForwarderParty (pctxt, 
               &pvalue->freightForwarderParty, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.freightForwarderPartyPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 12:
         /* decode delivery_list */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfDelivery (pctxt, 
               &pvalue->delivery_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 13:
         /* decode deliveryTerms */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DeliveryTerms (pctxt, 
               &pvalue->deliveryTerms, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.deliveryTermsPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 14:
         /* decode despatchedTransportHandlingUnit_list */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfDespatchedTransportHandlingUnit (pctxt, 
               &pvalue->despatchedTransportHandlingUnit_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 15:
         /* decode actualShipment */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ActualShipment (pctxt, 
               &pvalue->actualShipment, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.actualShipmentPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 16:
         /* decode despatchLine_list */
         if (XD_PEEKTAG (pctxt, 0x90)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DespatchAdviceType_despatchLine_list (pctxt, 
               &pvalue->despatchLine_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_CONS|15):
         case (TM_CTXT|TM_CONS|16):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 8) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DespatchAdvice                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DespatchAdvice (OSCTXT* pctxt,
   DespatchAdvice *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DespatchAdviceType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

