/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0A, Date: 26-May-2006.
 */
#include "asn1intl.h"
#include "UBL-CommonBasicComponents-1-0.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  DeliveryDateTimeType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DeliveryDateTimeType (OSCTXT* pctxt,
   DeliveryDateTimeType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ActualDeliveryDateTime                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ActualDeliveryDateTime (OSCTXT* pctxt,
   ActualDeliveryDateTime *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DeliveryDateTimeType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InformationType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_InformationType (OSCTXT* pctxt,
   InformationType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AdditionalInformation                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AdditionalInformation (OSCTXT* pctxt,
   AdditionalInformation *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_InformationType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  StreetNameType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_StreetNameType (OSCTXT* pctxt,
   StreetNameType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AdditionalStreetName                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AdditionalStreetName (OSCTXT* pctxt,
   AdditionalStreetName *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_StreetNameType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AmountType                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_CommonBasicComponents_1_0_AmountType (OSCTXT* pctxt,
   UBL_CommonBasicComponents_1_0_AmountType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode amountCurrencyCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->amountCurrencyCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.amountCurrencyCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode amountCurrencyID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CurrencyCodeContentType (pctxt, 
               &pvalue->amountCurrencyID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Amount                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Amount (OSCTXT* pctxt,
   Amount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_CommonBasicComponents_1_0_AmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BackorderQuantity                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_BackorderQuantity (OSCTXT* pctxt,
   BackorderQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_QuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ReasonType                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ReasonType (OSCTXT* pctxt,
   ReasonType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BackorderReason                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_BackorderReason (OSCTXT* pctxt,
   BackorderReason *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ReasonType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BaseQuantity                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_BaseQuantity (OSCTXT* pctxt,
   BaseQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_QuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BuildingNameType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_BuildingNameType (OSCTXT* pctxt,
   BuildingNameType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BuildingName                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_BuildingName (OSCTXT* pctxt,
   BuildingName *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_BuildingNameType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BuildingNumberType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_BuildingNumberType (OSCTXT* pctxt,
   BuildingNumberType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BuildingNumber                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_BuildingNumber (OSCTXT* pctxt,
   BuildingNumber *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_BuildingNumberType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CalculationRateType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CalculationRateType (OSCTXT* pctxt,
   CalculationRateType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CalculationRate                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CalculationRate (OSCTXT* pctxt,
   CalculationRate *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_CalculationRateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CatalogueIndicator                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CatalogueIndicator (OSCTXT* pctxt,
   CatalogueIndicator *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_IndicatorType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ChargeIndicatorType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ChargeIndicatorType (OSCTXT* pctxt,
   ChargeIndicatorType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ChargeIndicator                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ChargeIndicator (OSCTXT* pctxt,
   ChargeIndicator *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ChargeIndicatorType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CityNameType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CityNameType (OSCTXT* pctxt,
   CityNameType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CityName                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CityName (OSCTXT* pctxt,
   CityName *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_CityNameType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConditionType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ConditionType (OSCTXT* pctxt,
   ConditionType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Condition                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Condition (OSCTXT* pctxt,
   Condition *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ConditionType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CopyIndicatorType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CopyIndicatorType (OSCTXT* pctxt,
   CopyIndicatorType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CopyIndicator                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CopyIndicator (OSCTXT* pctxt,
   CopyIndicator *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_CopyIndicatorType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CountrySubentityType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CountrySubentityType (OSCTXT* pctxt,
   CountrySubentityType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CountrySubentity                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CountrySubentity (OSCTXT* pctxt,
   CountrySubentity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_CountrySubentityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CurrencyBaseRateType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CurrencyBaseRateType (OSCTXT* pctxt,
   CurrencyBaseRateType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CurrencyBaseRate                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CurrencyBaseRate (OSCTXT* pctxt,
   CurrencyBaseRate *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_CurrencyBaseRateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Date (OSCTXT* pctxt,
   Date *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DateTime                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DateTime (OSCTXT* pctxt,
   DateTime *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_DateTimeType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DeliveredQuantity                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DeliveredQuantity (OSCTXT* pctxt,
   DeliveredQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_QuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DeliveryDateTime                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DeliveryDateTime (OSCTXT* pctxt,
   DeliveryDateTime *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DeliveryDateTimeType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DepartmentType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DepartmentType (OSCTXT* pctxt,
   DepartmentType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Department                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Department (OSCTXT* pctxt,
   Department *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DepartmentType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DescriptionType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DescriptionType (OSCTXT* pctxt,
   DescriptionType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Description                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Description (OSCTXT* pctxt,
   Description *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DescriptionType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DiscountPercentType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DiscountPercentType (OSCTXT* pctxt,
   DiscountPercentType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DiscountPercent                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DiscountPercent (OSCTXT* pctxt,
   DiscountPercent *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DiscountPercentType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DistrictType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DistrictType (OSCTXT* pctxt,
   DistrictType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  District                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_District (OSCTXT* pctxt,
   District *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DistrictType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PaymentDateType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PaymentDateType (OSCTXT* pctxt,
   PaymentDateType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DuePaymentDate                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DuePaymentDate (OSCTXT* pctxt,
   DuePaymentDate *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_PaymentDateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DurationMeasureType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DurationMeasureType (OSCTXT* pctxt,
   DurationMeasureType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode measureUnitCode */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCode, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode measureUnitCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.measureUnitCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DurationMeasure                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DurationMeasure (OSCTXT* pctxt,
   DurationMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DurationMeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MailType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MailType (OSCTXT* pctxt,
   MailType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ElectronicMail                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ElectronicMail (OSCTXT* pctxt,
   ElectronicMail *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_MailType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EndDateTimeType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_EndDateTimeType (OSCTXT* pctxt,
   EndDateTimeType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EndDateTime                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_EndDateTime (OSCTXT* pctxt,
   EndDateTime *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_EndDateTimeType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExemptionReason                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ExemptionReason (OSCTXT* pctxt,
   ExemptionReason *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ReasonType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExpiryDateType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ExpiryDateType (OSCTXT* pctxt,
   ExpiryDateType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExpiryDate                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ExpiryDate (OSCTXT* pctxt,
   ExpiryDate *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ExpiryDateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExtensionType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ExtensionType (OSCTXT* pctxt,
   ExtensionType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Extension                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Extension (OSCTXT* pctxt,
   Extension *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ExtensionType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExtensionAmountType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ExtensionAmountType (OSCTXT* pctxt,
   ExtensionAmountType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode amountCurrencyCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->amountCurrencyCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.amountCurrencyCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode amountCurrencyID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CurrencyCodeContentType (pctxt, 
               &pvalue->amountCurrencyID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExtensionAmount                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ExtensionAmount (OSCTXT* pctxt,
   ExtensionAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ExtensionAmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExtensionTotalAmountType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ExtensionTotalAmountType (OSCTXT* pctxt,
   ExtensionTotalAmountType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode amountCurrencyCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->amountCurrencyCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.amountCurrencyCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode amountCurrencyID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CurrencyCodeContentType (pctxt, 
               &pvalue->amountCurrencyID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExtensionTotalAmount                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ExtensionTotalAmount (OSCTXT* pctxt,
   ExtensionTotalAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ExtensionTotalAmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FloorType                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_FloorType (OSCTXT* pctxt,
   FloorType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Floor                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Floor (OSCTXT* pctxt,
   Floor *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_FloorType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VolumeMeasureType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_VolumeMeasureType (OSCTXT* pctxt,
   VolumeMeasureType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode measureUnitCode */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCode, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode measureUnitCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.measureUnitCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GrossVolumeMeasure                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_GrossVolumeMeasure (OSCTXT* pctxt,
   GrossVolumeMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_VolumeMeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  WeightMeasureType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_WeightMeasureType (OSCTXT* pctxt,
   WeightMeasureType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode measureUnitCode */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCode, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode measureUnitCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.measureUnitCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GrossWeightMeasure                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_GrossWeightMeasure (OSCTXT* pctxt,
   GrossWeightMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_WeightMeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InstructionsType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_InstructionsType (OSCTXT* pctxt,
   InstructionsType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HandlingInstructions                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_HandlingInstructions (OSCTXT* pctxt,
   HandlingInstructions *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_InstructionsType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HolderNameType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_HolderNameType (OSCTXT* pctxt,
   HolderNameType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HolderName                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_HolderName (OSCTXT* pctxt,
   HolderName *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_HolderNameType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Indicator                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Indicator (OSCTXT* pctxt,
   Indicator *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_IndicatorType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Information                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Information (OSCTXT* pctxt,
   Information *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_InformationType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InhouseMail                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_InhouseMail (OSCTXT* pctxt,
   InhouseMail *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_MailType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Instructions                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Instructions (OSCTXT* pctxt,
   Instructions *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_InstructionsType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InvoicedQuantity                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_InvoicedQuantity (OSCTXT* pctxt,
   InvoicedQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_QuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IssueDateType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_IssueDateType (OSCTXT* pctxt,
   IssueDateType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IssueDate                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_IssueDate (OSCTXT* pctxt,
   IssueDate *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_IssueDateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LatitudeDegreesMeasureType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LatitudeDegreesMeasureType (OSCTXT* pctxt,
   LatitudeDegreesMeasureType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode measureUnitCode */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCode, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode measureUnitCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.measureUnitCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LatitudeDegreesMeasure                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LatitudeDegreesMeasure (OSCTXT* pctxt,
   LatitudeDegreesMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_LatitudeDegreesMeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LatitudeMinutesMeasureType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LatitudeMinutesMeasureType (OSCTXT* pctxt,
   LatitudeMinutesMeasureType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode measureUnitCode */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCode, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode measureUnitCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.measureUnitCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LatitudeMinutesMeasure                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LatitudeMinutesMeasure (OSCTXT* pctxt,
   LatitudeMinutesMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_LatitudeMinutesMeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LineType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LineType (OSCTXT* pctxt,
   LineType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Line                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Line (OSCTXT* pctxt,
   Line *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_LineType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LineExtensionAmount                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LineExtensionAmount (OSCTXT* pctxt,
   LineExtensionAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ExtensionAmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LineExtensionTotalAmount                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LineExtensionTotalAmount (OSCTXT* pctxt,
   LineExtensionTotalAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ExtensionTotalAmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LocationType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LocationType (OSCTXT* pctxt,
   LocationType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Location                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Location (OSCTXT* pctxt,
   Location *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_LocationType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LongitudeDegreesMeasureType                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LongitudeDegreesMeasureType (OSCTXT* pctxt,
   LongitudeDegreesMeasureType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode measureUnitCode */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCode, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode measureUnitCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.measureUnitCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LongitudeDegreesMeasure                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LongitudeDegreesMeasure (OSCTXT* pctxt,
   LongitudeDegreesMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_LongitudeDegreesMeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LongitudeMinutesMeasureType                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LongitudeMinutesMeasureType (OSCTXT* pctxt,
   LongitudeMinutesMeasureType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode measureUnitCode */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCode, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode measureUnitCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.measureUnitCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LongitudeMinutesMeasure                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LongitudeMinutesMeasure (OSCTXT* pctxt,
   LongitudeMinutesMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_LongitudeMinutesMeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LossRiskType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LossRiskType (OSCTXT* pctxt,
   LossRiskType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LossRisk                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LossRisk (OSCTXT* pctxt,
   LossRisk *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_LossRiskType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Mail                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Mail (OSCTXT* pctxt,
   Mail *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_MailType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MarkAttentionIndicatorType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MarkAttentionIndicatorType (OSCTXT* pctxt,
   MarkAttentionIndicatorType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MarkAttentionIndicator                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MarkAttentionIndicator (OSCTXT* pctxt,
   MarkAttentionIndicator *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_MarkAttentionIndicatorType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MarkCareIndicatorType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MarkCareIndicatorType (OSCTXT* pctxt,
   MarkCareIndicatorType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MarkCareIndicator                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MarkCareIndicator (OSCTXT* pctxt,
   MarkCareIndicator *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_MarkCareIndicatorType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaterialIndicatorType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MaterialIndicatorType (OSCTXT* pctxt,
   MaterialIndicatorType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaterialIndicator                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MaterialIndicator (OSCTXT* pctxt,
   MaterialIndicator *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_MaterialIndicatorType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaximumAmount                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MaximumAmount (OSCTXT* pctxt,
   MaximumAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_CommonBasicComponents_1_0_AmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BackorderQuantityType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_BackorderQuantityType (OSCTXT* pctxt,
   BackorderQuantityType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode quantityUnitCode */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCode, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode quantityUnitCodeListAgencyID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCodeListAgencyID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityUnitCodeListAgencyIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode quantityUnitCodeListAgencyName */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCodeListAgencyName, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityUnitCodeListAgencyNamePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode quantityUnitCodeListID */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCodeListID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityUnitCodeListIDPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaximumBackorderQuantity                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MaximumBackorderQuantity (OSCTXT* pctxt,
   MaximumBackorderQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_BackorderQuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaximumMeasure                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MaximumMeasure (OSCTXT* pctxt,
   MaximumMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_MeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaximumQuantity                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MaximumQuantity (OSCTXT* pctxt,
   MaximumQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_QuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Measure                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Measure (OSCTXT* pctxt,
   Measure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_MeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MinimumAmount                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MinimumAmount (OSCTXT* pctxt,
   MinimumAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_CommonBasicComponents_1_0_AmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MinimumBackorderQuantity                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MinimumBackorderQuantity (OSCTXT* pctxt,
   MinimumBackorderQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_BackorderQuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MinimumMeasure                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MinimumMeasure (OSCTXT* pctxt,
   MinimumMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_MeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MinimumQuantity                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MinimumQuantity (OSCTXT* pctxt,
   MinimumQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_QuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplierFactorNumericType                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MultiplierFactorNumericType (OSCTXT* pctxt,
   MultiplierFactorNumericType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplierFactorNumeric                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MultiplierFactorNumeric (OSCTXT* pctxt,
   MultiplierFactorNumeric *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_MultiplierFactorNumericType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Name                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_CommonBasicComponents_1_0_Name (OSCTXT* pctxt,
   UBL_CommonBasicComponents_1_0_Name *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_NameType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NetNetWeightMeasure                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NetNetWeightMeasure (OSCTXT* pctxt,
   NetNetWeightMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_WeightMeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NetVolumeMeasure                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NetVolumeMeasure (OSCTXT* pctxt,
   NetVolumeMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_VolumeMeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NetWeightMeasure                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NetWeightMeasure (OSCTXT* pctxt,
   NetWeightMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_WeightMeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NoteType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NoteType (OSCTXT* pctxt,
   NoteType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Note                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Note (OSCTXT* pctxt,
   Note *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_NoteType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PackQuantityType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PackQuantityType (OSCTXT* pctxt,
   PackQuantityType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode quantityUnitCode */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCode, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode quantityUnitCodeListAgencyID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCodeListAgencyID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityUnitCodeListAgencyIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode quantityUnitCodeListAgencyName */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCodeListAgencyName, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityUnitCodeListAgencyNamePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode quantityUnitCodeListID */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCodeListID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityUnitCodeListIDPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PackQuantity                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PackQuantity (OSCTXT* pctxt,
   PackQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_PackQuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PackSizeNumericType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PackSizeNumericType (OSCTXT* pctxt,
   PackSizeNumericType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PackSizeNumeric                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PackSizeNumeric (OSCTXT* pctxt,
   PackSizeNumeric *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_PackSizeNumericType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PaidAmount                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PaidAmount (OSCTXT* pctxt,
   PaidAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_CommonBasicComponents_1_0_AmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PaymentDate                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PaymentDate (OSCTXT* pctxt,
   PaymentDate *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_PaymentDateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SurchargePercentType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SurchargePercentType (OSCTXT* pctxt,
   SurchargePercentType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PenaltySurchargePercent                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PenaltySurchargePercent (OSCTXT* pctxt,
   PenaltySurchargePercent *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_SurchargePercentType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Percent                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Percent (OSCTXT* pctxt,
   Percent *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_PercentType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PlacardEndorsementType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PlacardEndorsementType (OSCTXT* pctxt,
   PlacardEndorsementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PlacardEndorsement                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PlacardEndorsement (OSCTXT* pctxt,
   PlacardEndorsement *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_PlacardEndorsementType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PlacardNotationType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PlacardNotationType (OSCTXT* pctxt,
   PlacardNotationType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PlacardNotation                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PlacardNotation (OSCTXT* pctxt,
   PlacardNotation *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_PlacardNotationType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ZoneType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ZoneType (OSCTXT* pctxt,
   ZoneType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PostalZone                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PostalZone (OSCTXT* pctxt,
   PostalZone *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ZoneType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PostboxType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PostboxType (OSCTXT* pctxt,
   PostboxType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Postbox                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Postbox (OSCTXT* pctxt,
   Postbox *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_PostboxType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PrepaidIndicator                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PrepaidIndicator (OSCTXT* pctxt,
   PrepaidIndicator *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_IndicatorType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PriceAmountType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PriceAmountType (OSCTXT* pctxt,
   PriceAmountType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode amountCurrencyCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->amountCurrencyCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.amountCurrencyCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode amountCurrencyID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CurrencyCodeContentType (pctxt, 
               &pvalue->amountCurrencyID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PriceAmount                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PriceAmount (OSCTXT* pctxt,
   PriceAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_PriceAmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PromisedDateTime                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PromisedDateTime (OSCTXT* pctxt,
   PromisedDateTime *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_DateTimeType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quantity                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Quantity (OSCTXT* pctxt,
   Quantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_QuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Reason                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Reason (OSCTXT* pctxt,
   Reason *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ReasonType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ReceivedDate                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ReceivedDate (OSCTXT* pctxt,
   ReceivedDate *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ReceivedQuantity                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ReceivedQuantity (OSCTXT* pctxt,
   ReceivedQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_QuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RefrigerationOnIndicatorType                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RefrigerationOnIndicatorType (OSCTXT* pctxt,
   RefrigerationOnIndicatorType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RefrigerationOnIndicator                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RefrigerationOnIndicator (OSCTXT* pctxt,
   RefrigerationOnIndicator *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_RefrigerationOnIndicatorType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RegionType                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RegionType (OSCTXT* pctxt,
   RegionType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Region                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Region (OSCTXT* pctxt,
   Region *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_RegionType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RegistrationNameType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RegistrationNameType (OSCTXT* pctxt,
   RegistrationNameType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RegistrationName                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RegistrationName (OSCTXT* pctxt,
   RegistrationName *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_RegistrationNameType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RejectedQuantity                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RejectedQuantity (OSCTXT* pctxt,
   RejectedQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_QuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RelevantLocation                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RelevantLocation (OSCTXT* pctxt,
   RelevantLocation *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_LocationType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestedDeliveryDateTime                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RequestedDeliveryDateTime (OSCTXT* pctxt,
   RequestedDeliveryDateTime *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DeliveryDateTimeType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ReturnableMaterialIndicator                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ReturnableMaterialIndicator (OSCTXT* pctxt,
   ReturnableMaterialIndicator *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_MaterialIndicatorType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RoomType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RoomType (OSCTXT* pctxt,
   RoomType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Room                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Room (OSCTXT* pctxt,
   Room *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_RoomType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SequenceNumericType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SequenceNumericType (OSCTXT* pctxt,
   SequenceNumericType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SequenceNumeric                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SequenceNumeric (OSCTXT* pctxt,
   SequenceNumeric *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_SequenceNumericType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SettlementDiscountPercent                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SettlementDiscountPercent (OSCTXT* pctxt,
   SettlementDiscountPercent *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DiscountPercentType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ShortQuantity                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ShortQuantity (OSCTXT* pctxt,
   ShortQuantity *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_UnspecializedDatatypes_1_0_QuantityType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SourceCurrencyBaseRate                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SourceCurrencyBaseRate (OSCTXT* pctxt,
   SourceCurrencyBaseRate *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_CurrencyBaseRateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TermsType                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TermsType (OSCTXT* pctxt,
   TermsType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SpecialTerms                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SpecialTerms (OSCTXT* pctxt,
   SpecialTerms *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TermsType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  StartDateTimeType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_StartDateTimeType (OSCTXT* pctxt,
   StartDateTimeType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  StartDateTime                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_StartDateTime (OSCTXT* pctxt,
   StartDateTime *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_StartDateTimeType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  StreetName                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_StreetName (OSCTXT* pctxt,
   StreetName *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_StreetNameType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SurchargePercent                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SurchargePercent (OSCTXT* pctxt,
   SurchargePercent *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_SurchargePercentType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnitBaseRateType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UnitBaseRateType (OSCTXT* pctxt,
   UnitBaseRateType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TargetUnitBaseRate                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TargetUnitBaseRate (OSCTXT* pctxt,
   TargetUnitBaseRate *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UnitBaseRateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TaxableAmount                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TaxableAmount (OSCTXT* pctxt,
   TaxableAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_CommonBasicComponents_1_0_AmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TaxAmountType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TaxAmountType (OSCTXT* pctxt,
   TaxAmountType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode amountCurrencyCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->amountCurrencyCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.amountCurrencyCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode amountCurrencyID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CurrencyCodeContentType (pctxt, 
               &pvalue->amountCurrencyID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TaxAmount                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TaxAmount (OSCTXT* pctxt,
   TaxAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TaxAmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TotalAmountType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TotalAmountType (OSCTXT* pctxt,
   TotalAmountType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode amountCurrencyCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->amountCurrencyCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.amountCurrencyCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode amountCurrencyID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CurrencyCodeContentType (pctxt, 
               &pvalue->amountCurrencyID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TaxExclusiveTotalAmount                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TaxExclusiveTotalAmount (OSCTXT* pctxt,
   TaxExclusiveTotalAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TotalAmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TaxInclusiveTotalAmount                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TaxInclusiveTotalAmount (OSCTXT* pctxt,
   TaxInclusiveTotalAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TotalAmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TaxTotalAmountType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TaxTotalAmountType (OSCTXT* pctxt,
   TaxTotalAmountType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode amountCurrencyCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->amountCurrencyCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.amountCurrencyCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode amountCurrencyID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CurrencyCodeContentType (pctxt, 
               &pvalue->amountCurrencyID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TaxTotalAmount                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TaxTotalAmount (OSCTXT* pctxt,
   TaxTotalAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TaxTotalAmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TechnicalName                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TechnicalName (OSCTXT* pctxt,
   TechnicalName *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_NameType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TelefaxType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TelefaxType (OSCTXT* pctxt,
   TelefaxType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Telefax                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Telefax (OSCTXT* pctxt,
   Telefax *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TelefaxType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TelephoneType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TelephoneType (OSCTXT* pctxt,
   TelephoneType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Telephone                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Telephone (OSCTXT* pctxt,
   Telephone *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TelephoneType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Terms                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Terms (OSCTXT* pctxt,
   Terms *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TermsType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TimezoneOffsetType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TimezoneOffsetType (OSCTXT* pctxt,
   TimezoneOffsetType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TimezoneOffset                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TimezoneOffset (OSCTXT* pctxt,
   TimezoneOffset *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TimezoneOffsetType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TotalAmount                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TotalAmount (OSCTXT* pctxt,
   TotalAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TotalAmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TotalTaxAmount                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TotalTaxAmount (OSCTXT* pctxt,
   TotalTaxAmount *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TaxAmountType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnitBaseRate                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UnitBaseRate (OSCTXT* pctxt,
   UnitBaseRate *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UnitBaseRateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ValidityStartDateType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ValidityStartDateType (OSCTXT* pctxt,
   ValidityStartDateType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ValidityStartDate                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ValidityStartDate (OSCTXT* pctxt,
   ValidityStartDate *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ValidityStartDateType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ValueType                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_CommonBasicComponents_1_0_ValueType (OSCTXT* pctxt,
   UBL_CommonBasicComponents_1_0_ValueType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Value                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Value (OSCTXT* pctxt,
   Value *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_UBL_CommonBasicComponents_1_0_ValueType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VolumeMeasure                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_VolumeMeasure (OSCTXT* pctxt,
   VolumeMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_VolumeMeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  WeightMeasure                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_WeightMeasure (OSCTXT* pctxt,
   WeightMeasure *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_WeightMeasureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Zone                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Zone (OSCTXT* pctxt,
   Zone *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ZoneType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DateTimeType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_CommonBasicComponents_1_0_DateTimeType (OSCTXT* pctxt,
   UBL_CommonBasicComponents_1_0_DateTimeType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DateType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_CommonBasicComponents_1_0_DateType (OSCTXT* pctxt,
   UBL_CommonBasicComponents_1_0_DateType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IndicatorType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_CommonBasicComponents_1_0_IndicatorType (OSCTXT* pctxt,
   UBL_CommonBasicComponents_1_0_IndicatorType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MeasureType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_CommonBasicComponents_1_0_MeasureType (OSCTXT* pctxt,
   UBL_CommonBasicComponents_1_0_MeasureType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode measureUnitCode */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCode, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode measureUnitCodeListVersionID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->measureUnitCodeListVersionID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.measureUnitCodeListVersionIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NameType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_CommonBasicComponents_1_0_NameType (OSCTXT* pctxt,
   UBL_CommonBasicComponents_1_0_NameType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode languageLocaleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageLocaleID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageLocaleIDPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode languageID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languageID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languageIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PercentType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_CommonBasicComponents_1_0_PercentType (OSCTXT* pctxt,
   UBL_CommonBasicComponents_1_0_PercentType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  QuantityType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UBL_CommonBasicComponents_1_0_QuantityType (OSCTXT* pctxt,
   UBL_CommonBasicComponents_1_0_QuantityType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode quantityUnitCode */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCode, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode quantityUnitCodeListAgencyID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCodeListAgencyID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityUnitCodeListAgencyIDPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode quantityUnitCodeListAgencyName */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCodeListAgencyName, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityUnitCodeListAgencyNamePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode quantityUnitCodeListID */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->quantityUnitCodeListID, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityUnitCodeListIDPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

