/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "Xmldsig.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  CanonicalizationMethodType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CanonicalizationMethodType (OSCTXT* pctxt, 
   CanonicalizationMethodType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode algorithm */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->algorithm, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode elem_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               OSXSDAny* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->elem_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, OSXSDAny, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  if (XD_PEEKPC (pctxt)) {
                     pdata2->u.binary = rtxMemAllocType (pctxt, OSOpenType);
                     stat = xd_OpenType (pctxt, &pdata2->u.binary->data,
                        &pdata2->u.binary->numocts);
                     pdata2->t = OSXSDAny_binary;
                  } else {
                     stat = xd_utf8str (pctxt, &pdata2->
                        u.xmlText, ASN1EXPL, length);
                     pdata2->t = OSXSDAny_xmlText;
                  }
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->elem_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CanonicalizationMethodType (OSCTXT* pctxt, 
   CanonicalizationMethodType* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Algorithm"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Algorithm */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->algorithm);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CanonicalizationMethodType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CanonicalizationMethodType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { OSXSDAny* pdata1;
   OSXMLElemDescr elemDescr;
   const OSUTF8CHAR* pxmlstr;
   for (;;) {
      stat = rtXmlpGetNextElem (pctxt, &elemDescr, -1);
      if (0 != stat) break;

      stat = rtXmlpDecAnyElem (pctxt, &pxmlstr);
      if (0 != stat) break;

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      pdata1 = rtxMemAllocType (pctxt, OSXSDAny);
      if (0 == pdata1) return LOG_RTERR (pctxt, RTERR_NOMEM);

      pdata1->t = OSXSDAny_xmlText;
      pdata1->u.xmlText = pxmlstr;

      if (0 == rtxDListAppend (pctxt, &pvalue->elem_list, pdata1))
         return LOG_RTERR (pctxt, RTERR_NOMEM);
   }
   if (stat == XML_OK_EOB) stat = 0;
   else return LOG_RTERR (pctxt, stat);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CanonicalizationMethod                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CanonicalizationMethod (OSCTXT* pctxt, 
   CanonicalizationMethod *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_CanonicalizationMethodType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_CanonicalizationMethod (OSCTXT* pctxt, 
   CanonicalizationMethod* pvalue)
{
   int stat = 0;

   stat = XmlDec_CanonicalizationMethodType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HMACOutputLengthType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_HMACOutputLengthType (OSCTXT* pctxt, 
   HMACOutputLengthType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_integer (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_HMACOutputLengthType (OSCTXT* pctxt, HMACOutputLengthType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecInt (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignatureMethodType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignatureMethodType (OSCTXT* pctxt, 
   SignatureMethodType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode algorithm */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->algorithm, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode hMACOutputLength */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HMACOutputLengthType (pctxt, 
               &pvalue->hMACOutputLength, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.hMACOutputLengthPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode elem_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               OSXSDAny* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->elem_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, OSXSDAny, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  if (XD_PEEKPC (pctxt)) {
                     pdata2->u.binary = rtxMemAllocType (pctxt, OSOpenType);
                     stat = xd_OpenType (pctxt, &pdata2->u.binary->data,
                        &pdata2->u.binary->numocts);
                     pdata2->t = OSXSDAny_binary;
                  } else {
                     stat = xd_utf8str (pctxt, &pdata2->
                        u.xmlText, ASN1EXPL, length);
                     pdata2->t = OSXSDAny_xmlText;
                  }
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->elem_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SignatureMethodType (OSCTXT* pctxt, SignatureMethodType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Algorithm"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Algorithm */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->algorithm);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SignatureMethodType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SignatureMethodType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("HMACOutputLength"), 16}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 0, 1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* HMACOutputLength */
         stat = XmlDec_HMACOutputLengthType (pctxt, &pvalue->hMACOutputLength
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.hMACOutputLengthPresent = TRUE;
         break;
      }
      case 1: {
         OSXSDAny* pdata1;
         do {
            pdata1 = rtxMemAllocTypeZ (pctxt, OSXSDAny);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            /* decode xsd:any element as XML text */
            stat = rtXmlpDecAny (pctxt, &pdata1->u.xmlText);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
            pdata1->t = OSXSDAny_xmlText;

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->elem_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, rows, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == RTERR_UNEXPELEM);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignatureMethod                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignatureMethod (OSCTXT* pctxt, SignatureMethod *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_SignatureMethodType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_SignatureMethod (OSCTXT* pctxt, SignatureMethod* pvalue)
{
   int stat = 0;

   stat = XmlDec_SignatureMethodType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransformType_element                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TransformType_element (OSCTXT* pctxt, 
   TransformType_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         if (pctxt->flags & ASN1CONSTAG) {
            pvalue->u.elem.u.binary = rtxMemAllocType (pctxt, OSOpenType);
            stat = xd_OpenType (pctxt, &pvalue->u.elem.u.binary->data,
               &pvalue->u.elem.u.binary->numocts);
            pvalue->u.elem.t = OSXSDAny_binary;
         } else {
            stat = xd_utf8str (pctxt, &pvalue->u.elem.
               u.xmlText, ASN1IMPL, length);
            pvalue->u.elem.t = OSXSDAny_xmlText;
         }
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.xPath, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_TransformType_element (OSCTXT* pctxt, TransformType_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("XPath"), 5}, 0}, 1 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
   if (elemID == RTERR_UNEXPELEM) elemID = 0;
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /*  */
      /* decode xsd:any element as XML text */
      stat = rtXmlpDecAny (pctxt, &pvalue->u.elem.u.xmlText);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pvalue->u.elem.t = OSXSDAny_xmlText;

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* XPath */
      stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->u.xPath);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransformType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TransformType (OSCTXT* pctxt, TransformType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode algorithm */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->algorithm, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TransformType_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->choice_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TransformType_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TransformType_element (pdata2);

                  stat = asn1D_TransformType_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->choice_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_TransformType (OSCTXT* pctxt, TransformType* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Algorithm"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Algorithm */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->algorithm);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "TransformType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "TransformType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("XPath"), 5}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         TransformType_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TransformType_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TransformType_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_TransformType_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->choice_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Transform                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Transform (OSCTXT* pctxt, Transform *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TransformType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Transform (OSCTXT* pctxt, Transform* pvalue)
{
   int stat = 0;

   stat = XmlDec_TransformType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransformsType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TransformsType (OSCTXT* pctxt, TransformsType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode transform_list */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Transform* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->transform_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Transform, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Transform (pdata2);

                  stat = asn1D_Transform (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->transform_list, pnode);
               }

               if (!(pvalue->transform_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "TransformsType.transform_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->transform_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_TransformsType (OSCTXT* pctxt, TransformsType* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Transform"), 9}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Transform* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Transform);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Transform (pdata1);

            stat = XmlDec_Transform (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->transform_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Transforms                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Transforms (OSCTXT* pctxt, Transforms *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_TransformsType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Transforms (OSCTXT* pctxt, Transforms* pvalue)
{
   int stat = 0;

   stat = XmlDec_TransformsType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DigestMethodType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DigestMethodType (OSCTXT* pctxt, DigestMethodType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode algorithm */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->algorithm, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode elem_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               OSXSDAny* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->elem_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, OSXSDAny, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  if (XD_PEEKPC (pctxt)) {
                     pdata2->u.binary = rtxMemAllocType (pctxt, OSOpenType);
                     stat = xd_OpenType (pctxt, &pdata2->u.binary->data,
                        &pdata2->u.binary->numocts);
                     pdata2->t = OSXSDAny_binary;
                  } else {
                     stat = xd_utf8str (pctxt, &pdata2->
                        u.xmlText, ASN1EXPL, length);
                     pdata2->t = OSXSDAny_xmlText;
                  }
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->elem_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_DigestMethodType (OSCTXT* pctxt, DigestMethodType* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Algorithm"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Algorithm */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->algorithm);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "DigestMethodType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "DigestMethodType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { OSXSDAny* pdata1;
   OSXMLElemDescr elemDescr;
   const OSUTF8CHAR* pxmlstr;
   for (;;) {
      stat = rtXmlpGetNextElem (pctxt, &elemDescr, -1);
      if (0 != stat) break;

      stat = rtXmlpDecAnyElem (pctxt, &pxmlstr);
      if (0 != stat) break;

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      pdata1 = rtxMemAllocType (pctxt, OSXSDAny);
      if (0 == pdata1) return LOG_RTERR (pctxt, RTERR_NOMEM);

      pdata1->t = OSXSDAny_xmlText;
      pdata1->u.xmlText = pxmlstr;

      if (0 == rtxDListAppend (pctxt, &pvalue->elem_list, pdata1))
         return LOG_RTERR (pctxt, RTERR_NOMEM);
   }
   if (stat == XML_OK_EOB) stat = 0;
   else return LOG_RTERR (pctxt, stat);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DigestMethod                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DigestMethod (OSCTXT* pctxt, DigestMethod *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DigestMethodType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_DigestMethod (OSCTXT* pctxt, DigestMethod* pvalue)
{
   int stat = 0;

   stat = XmlDec_DigestMethodType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DigestValueType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DigestValueType (OSCTXT* pctxt, DigestValueType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_octstr (pctxt, &pvalue->data, &pvalue->numocts, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_DigestValueType (OSCTXT* pctxt, DigestValueType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynBase64Str (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DigestValue                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DigestValue (OSCTXT* pctxt, DigestValue *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DigestValueType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_DigestValue (OSCTXT* pctxt, DigestValue* pvalue)
{
   int stat = 0;

   stat = XmlDec_DigestValueType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ReferenceType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ReferenceType (OSCTXT* pctxt, ReferenceType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode type */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.typePresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode uRI */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->uRI, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.uRIPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode transforms */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Transforms (pctxt, 
               &pvalue->transforms, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transformsPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode digestMethod */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DigestMethod (pctxt, 
               &pvalue->digestMethod, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode digestValue */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DigestValue (pctxt, 
               &pvalue->digestValue, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_ReferenceType (OSCTXT* pctxt, ReferenceType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Id"), 2}, 0 },
         { {OSUTF8("Type"), 4}, 0 },
         { {OSUTF8("URI"), 3}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 1: /* Type */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.typePresent = TRUE;
            break;

         case 2: /* URI */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->uRI);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.uRIPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "ReferenceType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "ReferenceType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Transforms"), 10}, 0}, 0 },
      {{{OSUTF8("DigestMethod"), 12}, 0}, 1 },
      {{{OSUTF8("DigestValue"), 11}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 1, -1}, {3, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Transforms */
         stat = XmlDec_Transforms (pctxt, &pvalue->transforms);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.transformsPresent = TRUE;
         break;
      }
      case 1: { /* DigestMethod */
         stat = XmlDec_DigestMethod (pctxt, &pvalue->digestMethod);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* DigestValue */
         stat = XmlDec_DigestValue (pctxt, &pvalue->digestValue);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Reference                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Reference (OSCTXT* pctxt, Reference *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ReferenceType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Reference (OSCTXT* pctxt, Reference* pvalue)
{
   int stat = 0;

   stat = XmlDec_ReferenceType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignedInfoType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignedInfoType (OSCTXT* pctxt, SignedInfoType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode canonicalizationMethod */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CanonicalizationMethod (pctxt, 
               &pvalue->canonicalizationMethod, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode signatureMethod */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SignatureMethod (pctxt, 
               &pvalue->signatureMethod, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode reference_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Reference* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->reference_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Reference, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Reference (pdata2);

                  stat = asn1D_Reference (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->reference_list, pnode);
               }

               if (!(pvalue->reference_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "SignedInfoType.reference_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->reference_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SignedInfoType (OSCTXT* pctxt, SignedInfoType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Id"), 2}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SignedInfoType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SignedInfoType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("CanonicalizationMethod"), 22}, 0}, 0 },
      {{{OSUTF8("SignatureMethod"), 15}, 0}, 1 },
      {{{OSUTF8("Reference"), 9}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* CanonicalizationMethod */
         stat = XmlDec_CanonicalizationMethod (pctxt, &pvalue->
            canonicalizationMethod);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* SignatureMethod */
         stat = XmlDec_SignatureMethod (pctxt, &pvalue->signatureMethod);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: {
         Reference* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Reference);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Reference (pdata1);

            stat = XmlDec_Reference (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->reference_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 2);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignedInfo                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignedInfo (OSCTXT* pctxt, SignedInfo *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_SignedInfoType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_SignedInfo (OSCTXT* pctxt, SignedInfo* pvalue)
{
   int stat = 0;

   stat = XmlDec_SignedInfoType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignatureValueType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignatureValueType (OSCTXT* pctxt, 
   SignatureValueType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_octstr (pctxt, &pvalue->base.data, &pvalue->base.numocts, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SignatureValueType (OSCTXT* pctxt, SignatureValueType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Id"), 2}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SignatureValueType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SignatureValueType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   stat = rtXmlpDecDynBase64Str (pctxt, &pvalue->base);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignatureValue                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignatureValue (OSCTXT* pctxt, SignatureValue *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_SignatureValueType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_SignatureValue (OSCTXT* pctxt, SignatureValue* pvalue)
{
   int stat = 0;

   stat = XmlDec_SignatureValueType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeyName                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_KeyName (OSCTXT* pctxt, KeyName *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_KeyName (OSCTXT* pctxt, KeyName* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeyValueType_embed_values                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_KeyValueType_embed_values (OSCTXT* pctxt, 
   KeyValueType_embed_values *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   const OSUTF8CHAR* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      stat = xd_utf8str (pctxt, &pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      pnode->data = (void*)pdata1;
      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_KeyValueType_embed_values (OSCTXT* pctxt, 
   KeyValueType_embed_values* pvalue)
{
   int stat = 0;

   { int elemID;
   const OSUTF8CHAR* pdata1;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CryptoBinary                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CryptoBinary (OSCTXT* pctxt, CryptoBinary *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_octstr (pctxt, &pvalue->data, &pvalue->numocts, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_CryptoBinary (OSCTXT* pctxt, CryptoBinary* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynBase64Str (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DSAKeyValueType_sequence                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DSAKeyValueType_sequence (OSCTXT* pctxt, 
   DSAKeyValueType_sequence *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode p */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CryptoBinary (pctxt, 
               &pvalue->p, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode q */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CryptoBinary (pctxt, 
               &pvalue->q, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_DSAKeyValueType_sequence (OSCTXT* pctxt, 
   DSAKeyValueType_sequence* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("P"), 1}, 0}, 0 },
      {{{OSUTF8("Q"), 1}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* P */
         stat = XmlDec_CryptoBinary (pctxt, &pvalue->p);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* Q */
         stat = XmlDec_CryptoBinary (pctxt, &pvalue->q);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DSAKeyValueType_sequence_1                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DSAKeyValueType_sequence_1 (OSCTXT* pctxt, 
   DSAKeyValueType_sequence_1 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode seed */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CryptoBinary (pctxt, 
               &pvalue->seed, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode pgenCounter */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CryptoBinary (pctxt, 
               &pvalue->pgenCounter, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_DSAKeyValueType_sequence_1 (OSCTXT* pctxt, 
   DSAKeyValueType_sequence_1* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Seed"), 4}, 0}, 0 },
      {{{OSUTF8("PgenCounter"), 11}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Seed */
         stat = XmlDec_CryptoBinary (pctxt, &pvalue->seed);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* PgenCounter */
         stat = XmlDec_CryptoBinary (pctxt, &pvalue->pgenCounter);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DSAKeyValueType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DSAKeyValueType (OSCTXT* pctxt, DSAKeyValueType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode sequence */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DSAKeyValueType_sequence (pctxt, 
               &pvalue->sequence, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sequencePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode g */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CryptoBinary (pctxt, 
               &pvalue->g, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.gPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode y */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CryptoBinary (pctxt, 
               &pvalue->y, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode j */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CryptoBinary (pctxt, 
               &pvalue->j, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.jPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode sequence_1 */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DSAKeyValueType_sequence_1 (pctxt, 
               &pvalue->sequence_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sequence_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_DSAKeyValueType (OSCTXT* pctxt, DSAKeyValueType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("P"), 1}, 0}, 0 },
      {{{OSUTF8("G"), 1}, 0}, 1 },
      {{{OSUTF8("Y"), 1}, 0}, 2 },
      {{{OSUTF8("J"), 1}, 0}, 3 },
      {{{OSUTF8("Seed"), 4}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}, {3, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /*  */
         stat = XmlDec_DSAKeyValueType_sequence (pctxt, &pvalue->sequence);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.sequencePresent = TRUE;
         break;
      }
      case 1: { /* G */
         stat = XmlDec_CryptoBinary (pctxt, &pvalue->g);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.gPresent = TRUE;
         break;
      }
      case 2: { /* Y */
         stat = XmlDec_CryptoBinary (pctxt, &pvalue->y);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* J */
         stat = XmlDec_CryptoBinary (pctxt, &pvalue->j);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.jPresent = TRUE;
         break;
      }
      case 4: { /*  */
         stat = XmlDec_DSAKeyValueType_sequence_1 (pctxt, &pvalue->sequence_1
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.sequence_1Present = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DSAKeyValue                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DSAKeyValue (OSCTXT* pctxt, DSAKeyValue *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DSAKeyValueType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_DSAKeyValue (OSCTXT* pctxt, DSAKeyValue* pvalue)
{
   int stat = 0;

   stat = XmlDec_DSAKeyValueType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RSAKeyValueType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RSAKeyValueType (OSCTXT* pctxt, RSAKeyValueType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode modulus */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CryptoBinary (pctxt, 
               &pvalue->modulus, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode exponent */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CryptoBinary (pctxt, 
               &pvalue->exponent, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_RSAKeyValueType (OSCTXT* pctxt, RSAKeyValueType* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Modulus"), 7}, 0}, 0 },
      {{{OSUTF8("Exponent"), 8}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Modulus */
         stat = XmlDec_CryptoBinary (pctxt, &pvalue->modulus);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* Exponent */
         stat = XmlDec_CryptoBinary (pctxt, &pvalue->exponent);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RSAKeyValue                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RSAKeyValue (OSCTXT* pctxt, RSAKeyValue *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_RSAKeyValueType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_RSAKeyValue (OSCTXT* pctxt, RSAKeyValue* pvalue)
{
   int stat = 0;

   stat = XmlDec_RSAKeyValueType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeyValueType_choice                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_KeyValueType_choice (OSCTXT* pctxt, 
   KeyValueType_choice *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.dSAKeyValue = rtxMemAllocType (pctxt, DSAKeyValue);

         if (pvalue->u.dSAKeyValue == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_DSAKeyValue (pvalue->u.dSAKeyValue);
         stat = asn1D_DSAKeyValue (pctxt, 
            pvalue->u.dSAKeyValue, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.rSAKeyValue = rtxMemAllocType (pctxt, RSAKeyValue);

         if (pvalue->u.rSAKeyValue == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_RSAKeyValue (pvalue->u.rSAKeyValue);
         stat = asn1D_RSAKeyValue (pctxt, 
            pvalue->u.rSAKeyValue, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         if (pctxt->flags & ASN1CONSTAG) {
            pvalue->u.elem.u.binary = rtxMemAllocType (pctxt, OSOpenType);
            stat = xd_OpenType (pctxt, &pvalue->u.elem.u.binary->data,
               &pvalue->u.elem.u.binary->numocts);
            pvalue->u.elem.t = OSXSDAny_binary;
         } else {
            stat = xd_utf8str (pctxt, &pvalue->u.elem.
               u.xmlText, ASN1IMPL, length);
            pvalue->u.elem.t = OSXSDAny_xmlText;
         }
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_KeyValueType_choice (OSCTXT* pctxt, KeyValueType_choice* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("DSAKeyValue"), 11}, 0}, 0 },
      {{{OSUTF8("RSAKeyValue"), 11}, 0}, 1 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, FALSE);
   if (elemID == RTERR_UNEXPELEM) elemID = 2;
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* DSAKeyValue */
      pvalue->u.dSAKeyValue = rtxMemAllocType (pctxt, DSAKeyValue);

      if (pvalue->u.dSAKeyValue == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_DSAKeyValue (pvalue->u.dSAKeyValue);

      stat = XmlDec_DSAKeyValue (pctxt, pvalue->u.dSAKeyValue);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* RSAKeyValue */
      pvalue->u.rSAKeyValue = rtxMemAllocType (pctxt, RSAKeyValue);

      if (pvalue->u.rSAKeyValue == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_RSAKeyValue (pvalue->u.rSAKeyValue);

      stat = XmlDec_RSAKeyValue (pctxt, pvalue->u.rSAKeyValue);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /*  */
      /* decode xsd:any element as XML text */
      stat = rtXmlpDecAny (pctxt, &pvalue->u.elem.u.xmlText);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pvalue->u.elem.t = OSXSDAny_xmlText;

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeyValueType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_KeyValueType (OSCTXT* pctxt, KeyValueType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode embed_values */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_KeyValueType_embed_values (pctxt, 
               &pvalue->embed_values, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_KeyValueType_choice (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_KeyValueType (OSCTXT* pctxt, KeyValueType* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("DSAKeyValue"), 11}, 0}, 1 },
      {{{OSUTF8("RSAKeyValue"), 11}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 0, 1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         const OSUTF8CHAR* pdata1;
         do {
            rtXmlpMarkLastEventActive (pctxt);

            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->embed_values, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, rows, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_KeyValueType_choice (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeyValue                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_KeyValue (OSCTXT* pctxt, KeyValue *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_KeyValueType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_KeyValue (OSCTXT* pctxt, KeyValue* pvalue)
{
   int stat = 0;

   stat = XmlDec_KeyValueType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RetrievalMethodType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RetrievalMethodType (OSCTXT* pctxt, 
   RetrievalMethodType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode type */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.typePresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode uRI */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->uRI, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.uRIPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode transforms */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Transforms (pctxt, 
               &pvalue->transforms, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transformsPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_RetrievalMethodType (OSCTXT* pctxt, RetrievalMethodType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Type"), 4}, 0 },
         { {OSUTF8("URI"), 3}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Type */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.typePresent = TRUE;
            break;

         case 1: /* URI */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->uRI);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.uRIPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "RetrievalMethodType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "RetrievalMethodType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Transforms"), 10}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Transforms */
         stat = XmlDec_Transforms (pctxt, &pvalue->transforms);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.transformsPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RetrievalMethod                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RetrievalMethod (OSCTXT* pctxt, RetrievalMethod *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_RetrievalMethodType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_RetrievalMethod (OSCTXT* pctxt, RetrievalMethod* pvalue)
{
   int stat = 0;

   stat = XmlDec_RetrievalMethodType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  X509IssuerSerialType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_X509IssuerSerialType (OSCTXT* pctxt, 
   X509IssuerSerialType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode x509IssuerName */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->x509IssuerName, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode x509SerialNumber */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->x509SerialNumber, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_X509IssuerSerialType (OSCTXT* pctxt, X509IssuerSerialType* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("X509IssuerName"), 14}, 0}, 0 },
      {{{OSUTF8("X509SerialNumber"), 16}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* X509IssuerName */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->x509IssuerName);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* X509SerialNumber */
         stat = rtXmlpDecInt (pctxt, &pvalue->x509SerialNumber);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  X509DataType__choice1                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_X509DataType__choice1 (OSCTXT* pctxt, 
   X509DataType__choice1 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   if (tagging == ASN1EXPL) {
      if (XD_PEEKTAG (pctxt, 0xa0)) {
         stat = xd_Tag1AndLen (pctxt, &length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
      }
      else return LOG_RTERR (pctxt,
         berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));
   }

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.x509IssuerSerial
             = rtxMemAllocType (pctxt, X509IssuerSerialType);

         if (pvalue->u.x509IssuerSerial == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_X509IssuerSerialType (pvalue->u.x509IssuerSerial);
         stat = asn1D_X509IssuerSerialType (pctxt, 
            pvalue->u.x509IssuerSerial, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         pvalue->u.x509SKI = rtxMemAllocType (pctxt, ASN1DynOctStr);

         if (pvalue->u.x509SKI == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         pvalue->u.x509SKI->numocts = 0;
         pvalue->u.x509SKI->data = 0;
         stat = xd_octstr (pctxt, &pvalue->u.x509SKI->data, &pvalue->u.x509SKI->numocts, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|2):
      case (TM_CTXT|TM_CONS|2):
         stat = xd_utf8str (pctxt, &pvalue->u.x509SubjectName, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|3):
      case (TM_CTXT|TM_CONS|3):
         pvalue->u.x509Certificate = rtxMemAllocType (pctxt, ASN1DynOctStr);

         if (pvalue->u.x509Certificate == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         pvalue->u.x509Certificate->numocts = 0;
         pvalue->u.x509Certificate->data = 0;
         stat = xd_octstr (pctxt, &pvalue->u.x509Certificate->data, &pvalue->u.x509Certificate->numocts, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|4):
      case (TM_CTXT|TM_CONS|4):
         pvalue->u.x509CRL = rtxMemAllocType (pctxt, ASN1DynOctStr);

         if (pvalue->u.x509CRL == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         pvalue->u.x509CRL->numocts = 0;
         pvalue->u.x509CRL->data = 0;
         stat = xd_octstr (pctxt, &pvalue->u.x509CRL->data, &pvalue->u.x509CRL->numocts, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_CONS|5):
         if (pctxt->flags & ASN1CONSTAG) {
            pvalue->u.elem.u.binary = rtxMemAllocType (pctxt, OSOpenType);
            stat = xd_OpenType (pctxt, &pvalue->u.elem.u.binary->data,
               &pvalue->u.elem.u.binary->numocts);
            pvalue->u.elem.t = OSXSDAny_binary;
         } else {
            stat = xd_utf8str (pctxt, &pvalue->u.elem.
               u.xmlText, ASN1IMPL, length);
            pvalue->u.elem.t = OSXSDAny_xmlText;
         }
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_X509DataType__choice1 (OSCTXT* pctxt, X509DataType__choice1* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("X509IssuerSerial"), 16}, 0}, 0 },
      {{{OSUTF8("X509SKI"), 7}, 0}, 1 },
      {{{OSUTF8("X509SubjectName"), 15}, 0}, 2 },
      {{{OSUTF8("X509Certificate"), 15}, 0}, 3 },
      {{{OSUTF8("X509CRL"), 7}, 0}, 4 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 5, -1, FALSE);
   if (elemID == RTERR_UNEXPELEM) elemID = 5;
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* X509IssuerSerial */
      pvalue->u.x509IssuerSerial
          = rtxMemAllocType (pctxt, X509IssuerSerialType);

      if (pvalue->u.x509IssuerSerial == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_X509IssuerSerialType (pvalue->u.x509IssuerSerial);

      stat = XmlDec_X509IssuerSerialType (pctxt, pvalue->u.x509IssuerSerial);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* X509SKI */
      pvalue->u.x509SKI = rtxMemAllocType (pctxt, ASN1DynOctStr);

      if (pvalue->u.x509SKI == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      pvalue->u.x509SKI->numocts = 0;
      pvalue->u.x509SKI->data = 0;

      stat = rtXmlpDecDynBase64Str (pctxt, pvalue->u.x509SKI);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* X509SubjectName */
      stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->u.x509SubjectName);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* X509Certificate */
      pvalue->u.x509Certificate = rtxMemAllocType (pctxt, ASN1DynOctStr);

      if (pvalue->u.x509Certificate == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      pvalue->u.x509Certificate->numocts = 0;
      pvalue->u.x509Certificate->data = 0;

      stat = rtXmlpDecDynBase64Str (pctxt, pvalue->u.x509Certificate);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 4: { /* X509CRL */
      pvalue->u.x509CRL = rtxMemAllocType (pctxt, ASN1DynOctStr);

      if (pvalue->u.x509CRL == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      pvalue->u.x509CRL->numocts = 0;
      pvalue->u.x509CRL->data = 0;

      stat = rtXmlpDecDynBase64Str (pctxt, pvalue->u.x509CRL);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 5: { /*  */
      /* decode xsd:any element as XML text */
      stat = rtXmlpDecAny (pctxt, &pvalue->u.elem.u.xmlText);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pvalue->u.elem.t = OSXSDAny_xmlText;

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  X509DataType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_X509DataType (OSCTXT* pctxt, X509DataType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   X509DataType__choice1* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, X509DataType__choice1, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_X509DataType__choice1 (pdata1);

      stat = asn1D_X509DataType__choice1 (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (!(pvalue->count >= 1U)) {
      rtxErrAddStrParm (pctxt, "X509DataType.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

int XmlDec_X509DataType (OSCTXT* pctxt, X509DataType* pvalue)
{
   int stat = 0;

   { int elemID;
   X509DataType__choice1* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("_choice1"), 8}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* _choice1 */
         pdata1 = rtxMemAllocType (pctxt, X509DataType__choice1);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_X509DataType__choice1 (pdata1);

         stat = XmlDec_X509DataType__choice1 (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  X509Data                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_X509Data (OSCTXT* pctxt, X509Data *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_X509DataType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_X509Data (OSCTXT* pctxt, X509Data* pvalue)
{
   int stat = 0;

   stat = XmlDec_X509DataType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PGPDataType_sequence                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PGPDataType_sequence (OSCTXT* pctxt, 
   PGPDataType_sequence *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode pGPKeyID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_octstr (pctxt, &pvalue->pGPKeyID.data, &pvalue->pGPKeyID.numocts, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode pGPKeyPacket */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_octstr (pctxt, &pvalue->pGPKeyPacket.data, &pvalue->pGPKeyPacket.numocts, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.pGPKeyPacketPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode elem_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               OSXSDAny* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->elem_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, OSXSDAny, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  if (XD_PEEKPC (pctxt)) {
                     pdata2->u.binary = rtxMemAllocType (pctxt, OSOpenType);
                     stat = xd_OpenType (pctxt, &pdata2->u.binary->data,
                        &pdata2->u.binary->numocts);
                     pdata2->t = OSXSDAny_binary;
                  } else {
                     stat = xd_utf8str (pctxt, &pdata2->
                        u.xmlText, ASN1EXPL, length);
                     pdata2->t = OSXSDAny_xmlText;
                  }
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->elem_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_PGPDataType_sequence (OSCTXT* pctxt, PGPDataType_sequence* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("PGPKeyID"), 8}, 0}, 0 },
      {{{OSUTF8("PGPKeyPacket"), 12}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 0, 2}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* PGPKeyID */
         stat = rtXmlpDecDynBase64Str (pctxt, &pvalue->pGPKeyID);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* PGPKeyPacket */
         stat = rtXmlpDecDynBase64Str (pctxt, &pvalue->pGPKeyPacket);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.pGPKeyPacketPresent = TRUE;
         break;
      }
      case 2: {
         OSXSDAny* pdata1;
         do {
            pdata1 = rtxMemAllocTypeZ (pctxt, OSXSDAny);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            /* decode xsd:any element as XML text */
            stat = rtXmlpDecAny (pctxt, &pdata1->u.xmlText);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
            pdata1->t = OSXSDAny_xmlText;

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->elem_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, rows, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == RTERR_UNEXPELEM);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PGPDataType_sequence_1                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PGPDataType_sequence_1 (OSCTXT* pctxt, 
   PGPDataType_sequence_1 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode pGPKeyPacket */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_octstr (pctxt, &pvalue->pGPKeyPacket.data, &pvalue->pGPKeyPacket.numocts, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode elem_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               OSXSDAny* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->elem_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, OSXSDAny, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  if (XD_PEEKPC (pctxt)) {
                     pdata2->u.binary = rtxMemAllocType (pctxt, OSOpenType);
                     stat = xd_OpenType (pctxt, &pdata2->u.binary->data,
                        &pdata2->u.binary->numocts);
                     pdata2->t = OSXSDAny_binary;
                  } else {
                     stat = xd_utf8str (pctxt, &pdata2->
                        u.xmlText, ASN1EXPL, length);
                     pdata2->t = OSXSDAny_xmlText;
                  }
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->elem_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_PGPDataType_sequence_1 (OSCTXT* pctxt, 
   PGPDataType_sequence_1* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("PGPKeyPacket"), 12}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 0, 1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* PGPKeyPacket */
         stat = rtXmlpDecDynBase64Str (pctxt, &pvalue->pGPKeyPacket);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: {
         OSXSDAny* pdata1;
         do {
            pdata1 = rtxMemAllocTypeZ (pctxt, OSXSDAny);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            /* decode xsd:any element as XML text */
            stat = rtXmlpDecAny (pctxt, &pdata1->u.xmlText);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
            pdata1->t = OSXSDAny_xmlText;

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->elem_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, rows, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == RTERR_UNEXPELEM);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PGPDataType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PGPDataType (OSCTXT* pctxt, PGPDataType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   if (tagging == ASN1EXPL) {
      if (XD_PEEKTAG (pctxt, 0x30)) {
         stat = xd_Tag1AndLen (pctxt, &length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
      }
      else return LOG_RTERR (pctxt,
         berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));
   }

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.sequence = rtxMemAllocType (pctxt, PGPDataType_sequence);

         if (pvalue->u.sequence == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PGPDataType_sequence (pvalue->u.sequence);
         stat = asn1D_PGPDataType_sequence (pctxt, 
            pvalue->u.sequence, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.sequence_1
             = rtxMemAllocType (pctxt, PGPDataType_sequence_1);

         if (pvalue->u.sequence_1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PGPDataType_sequence_1 (pvalue->u.sequence_1);
         stat = asn1D_PGPDataType_sequence_1 (pctxt, 
            pvalue->u.sequence_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_PGPDataType (OSCTXT* pctxt, PGPDataType* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("PGPKeyID"), 8}, 0}, 0 },
      {{{OSUTF8("PGPKeyPacket"), 12}, 0}, 1 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /*  */
      pvalue->u.sequence = rtxMemAllocType (pctxt, PGPDataType_sequence);

      if (pvalue->u.sequence == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PGPDataType_sequence (pvalue->u.sequence);

      stat = XmlDec_PGPDataType_sequence (pctxt, pvalue->u.sequence);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /*  */
      pvalue->u.sequence_1 = rtxMemAllocType (pctxt, PGPDataType_sequence_1);

      if (pvalue->u.sequence_1 == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PGPDataType_sequence_1 (pvalue->u.sequence_1);

      stat = XmlDec_PGPDataType_sequence_1 (pctxt, pvalue->u.sequence_1);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PGPData                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PGPData (OSCTXT* pctxt, PGPData *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;

   stat = asn1D_PGPDataType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_PGPData (OSCTXT* pctxt, PGPData* pvalue)
{
   int stat = 0;

   stat = XmlDec_PGPDataType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SPKIDataType_element                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SPKIDataType_element (OSCTXT* pctxt, 
   SPKIDataType_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode sPKISexp */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_octstr (pctxt, &pvalue->sPKISexp.data, &pvalue->sPKISexp.numocts, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode elem */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            if (pctxt->flags & ASN1CONSTAG) {
               pvalue->elem.u.binary = rtxMemAllocType (pctxt, OSOpenType);
               stat = xd_OpenType (pctxt, &pvalue->elem.u.binary->data,
                  &pvalue->elem.u.binary->numocts);
               pvalue->elem.t = OSXSDAny_binary;
            } else {
               stat = xd_utf8str (pctxt, &pvalue->elem.
                  u.xmlText, ASN1IMPL, length);
               pvalue->elem.t = OSXSDAny_xmlText;
            }
            if (stat == 0) {
               pvalue->m.elemPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SPKIDataType_element (OSCTXT* pctxt, SPKIDataType_element* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("SPKISexp"), 8}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 0, 1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* SPKISexp */
         stat = rtXmlpDecDynBase64Str (pctxt, &pvalue->sPKISexp);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /*  */
         /* decode xsd:any element as XML text */
         stat = rtXmlpDecAny (pctxt, &pvalue->elem.u.xmlText);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         pvalue->elem.t = OSXSDAny_xmlText;

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.elemPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SPKIDataType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SPKIDataType (OSCTXT* pctxt, SPKIDataType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   SPKIDataType_element* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, SPKIDataType_element, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SPKIDataType_element (pdata1);

      stat = asn1D_SPKIDataType_element (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (!(pvalue->count >= 1U)) {
      rtxErrAddStrParm (pctxt, "SPKIDataType.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

int XmlDec_SPKIDataType (OSCTXT* pctxt, SPKIDataType* pvalue)
{
   int stat = 0;

   { int elemID;
   SPKIDataType_element* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("SPKISexp"), 8}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0:
         rtXmlpMarkLastEventActive (pctxt);

         pdata1 = rtxMemAllocType (pctxt, SPKIDataType_element);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SPKIDataType_element (pdata1);

         stat = XmlDec_SPKIDataType_element (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SPKIData                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SPKIData (OSCTXT* pctxt, SPKIData *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_SPKIDataType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_SPKIData (OSCTXT* pctxt, SPKIData* pvalue)
{
   int stat = 0;

   stat = XmlDec_SPKIDataType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MgmtData                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MgmtData (OSCTXT* pctxt, MgmtData *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_MgmtData (OSCTXT* pctxt, MgmtData* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeyInfoType_element                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_KeyInfoType_element (OSCTXT* pctxt, 
   KeyInfoType_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = asn1D_KeyName (pctxt, 
            &pvalue->u.keyName, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.keyValue = rtxMemAllocType (pctxt, KeyValue);

         if (pvalue->u.keyValue == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_KeyValue (pvalue->u.keyValue);
         stat = asn1D_KeyValue (pctxt, 
            pvalue->u.keyValue, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.retrievalMethod = rtxMemAllocType (pctxt, RetrievalMethod);

         if (pvalue->u.retrievalMethod == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_RetrievalMethod (pvalue->u.retrievalMethod);
         stat = asn1D_RetrievalMethod (pctxt, 
            pvalue->u.retrievalMethod, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.x509Data = rtxMemAllocType (pctxt, X509Data);

         if (pvalue->u.x509Data == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_X509Data (pvalue->u.x509Data);
         stat = asn1D_X509Data (pctxt, 
            pvalue->u.x509Data, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_CONS|4):
         pvalue->u.pGPData = rtxMemAllocType (pctxt, PGPData);

         if (pvalue->u.pGPData == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PGPData (pvalue->u.pGPData);
         stat = asn1D_PGPData (pctxt, 
            pvalue->u.pGPData, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_CONS|5):
         pvalue->u.sPKIData = rtxMemAllocType (pctxt, SPKIData);

         if (pvalue->u.sPKIData == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SPKIData (pvalue->u.sPKIData);
         stat = asn1D_SPKIData (pctxt, 
            pvalue->u.sPKIData, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_PRIM|6):
      case (TM_CTXT|TM_CONS|6):
         stat = asn1D_MgmtData (pctxt, 
            &pvalue->u.mgmtData, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_CONS|7):
         if (pctxt->flags & ASN1CONSTAG) {
            pvalue->u.elem.u.binary = rtxMemAllocType (pctxt, OSOpenType);
            stat = xd_OpenType (pctxt, &pvalue->u.elem.u.binary->data,
               &pvalue->u.elem.u.binary->numocts);
            pvalue->u.elem.t = OSXSDAny_binary;
         } else {
            stat = xd_utf8str (pctxt, &pvalue->u.elem.
               u.xmlText, ASN1IMPL, length);
            pvalue->u.elem.t = OSXSDAny_xmlText;
         }
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_KeyInfoType_element (OSCTXT* pctxt, KeyInfoType_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("KeyName"), 7}, 0}, 0 },
      {{{OSUTF8("KeyValue"), 8}, 0}, 1 },
      {{{OSUTF8("RetrievalMethod"), 15}, 0}, 2 },
      {{{OSUTF8("X509Data"), 8}, 0}, 3 },
      {{{OSUTF8("PGPData"), 7}, 0}, 4 },
      {{{OSUTF8("SPKIData"), 8}, 0}, 5 },
      {{{OSUTF8("MgmtData"), 8}, 0}, 6 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 7, -1, FALSE);
   if (elemID == RTERR_UNEXPELEM) elemID = 7;
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* KeyName */
      stat = XmlDec_KeyName (pctxt, &pvalue->u.keyName);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* KeyValue */
      pvalue->u.keyValue = rtxMemAllocType (pctxt, KeyValue);

      if (pvalue->u.keyValue == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_KeyValue (pvalue->u.keyValue);

      stat = XmlDec_KeyValue (pctxt, pvalue->u.keyValue);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* RetrievalMethod */
      pvalue->u.retrievalMethod = rtxMemAllocType (pctxt, RetrievalMethod);

      if (pvalue->u.retrievalMethod == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_RetrievalMethod (pvalue->u.retrievalMethod);

      stat = XmlDec_RetrievalMethod (pctxt, pvalue->u.retrievalMethod);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* X509Data */
      pvalue->u.x509Data = rtxMemAllocType (pctxt, X509Data);

      if (pvalue->u.x509Data == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_X509Data (pvalue->u.x509Data);

      stat = XmlDec_X509Data (pctxt, pvalue->u.x509Data);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 4: { /* PGPData */
      pvalue->u.pGPData = rtxMemAllocType (pctxt, PGPData);

      if (pvalue->u.pGPData == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PGPData (pvalue->u.pGPData);

      stat = XmlDec_PGPData (pctxt, pvalue->u.pGPData);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 5: { /* SPKIData */
      pvalue->u.sPKIData = rtxMemAllocType (pctxt, SPKIData);

      if (pvalue->u.sPKIData == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SPKIData (pvalue->u.sPKIData);

      stat = XmlDec_SPKIData (pctxt, pvalue->u.sPKIData);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 6: { /* MgmtData */
      stat = XmlDec_MgmtData (pctxt, &pvalue->u.mgmtData);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 7: { /*  */
      /* decode xsd:any element as XML text */
      stat = rtXmlpDecAny (pctxt, &pvalue->u.elem.u.xmlText);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pvalue->u.elem.t = OSXSDAny_xmlText;

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeyInfoType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_KeyInfoType (OSCTXT* pctxt, KeyInfoType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               KeyInfoType_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->choice_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, KeyInfoType_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_KeyInfoType_element (pdata2);

                  stat = asn1D_KeyInfoType_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->choice_list, pnode);
               }

               if (!(pvalue->choice_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "KeyInfoType.choice_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_KeyInfoType (OSCTXT* pctxt, KeyInfoType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Id"), 2}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "KeyInfoType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "KeyInfoType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("KeyName"), 7}, 0}, 0 },
      {{{OSUTF8("KeyValue"), 8}, 0}, 0 },
      {{{OSUTF8("RetrievalMethod"), 15}, 0}, 0 },
      {{{OSUTF8("X509Data"), 8}, 0}, 0 },
      {{{OSUTF8("PGPData"), 7}, 0}, 0 },
      {{{OSUTF8("SPKIData"), 8}, 0}, 0 },
      {{{OSUTF8("MgmtData"), 8}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 7, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         KeyInfoType_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, KeyInfoType_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_KeyInfoType_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_KeyInfoType_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->choice_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 7, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeyInfo                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_KeyInfo (OSCTXT* pctxt, KeyInfo *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;

   stat = asn1D_KeyInfoType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_KeyInfo (OSCTXT* pctxt, KeyInfo* pvalue)
{
   int stat = 0;

   stat = XmlDec_KeyInfoType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ObjectType                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ObjectType (OSCTXT* pctxt, ObjectType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode encoding */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->encoding, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.encodingPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode mimeType */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->mimeType, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.mimeTypePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode sequence_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               OSXSDAny* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->sequence_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  { int ilcnt = 0, length;
                  if (XD_PEEKTAG (pctxt, 0x30)) {
                     stat = xd_Tag1AndLen (pctxt, &length);
                     if (stat != 0) return LOG_RTERR (pctxt, stat);
                     else if (length == ASN_K_INDEFLEN) ilcnt++;
                  }
                  else return LOG_RTERR (pctxt,
                     berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

                  if (XD_PEEKTAG (pctxt, 0x80)) {
                     stat = xd_Tag1AndLen (pctxt, &length);
                     if (stat != 0) return LOG_RTERR (pctxt, stat);
                  }
                  else return LOG_RTERR (pctxt,
                     berErrUnexpTag(pctxt, TM_CTXT|TM_PRIM|0));

                  rtxDListAllocNodeAndData (pctxt, OSXSDAny, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  if (pctxt->flags & ASN1CONSTAG) {
                     pdata2->u.binary = rtxMemAllocType (pctxt, OSOpenType);
                     stat = xd_OpenType (pctxt, &pdata2->u.binary->data,
                        &pdata2->u.binary->numocts);
                     pdata2->t = OSXSDAny_binary;
                  } else {
                     stat = xd_utf8str (pctxt, &pdata2->
                        u.xmlText, ASN1IMPL, length);
                     pdata2->t = OSXSDAny_xmlText;
                  }
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  while (ilcnt-- > 0) {
                     if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                     else return LOG_RTERR (pctxt, ASN_E_INVLEN);
                  }}
                  rtxDListAppendNode (&pvalue->sequence_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_ObjectType (OSCTXT* pctxt, ObjectType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Encoding"), 8}, 0 },
         { {OSUTF8("Id"), 2}, 0 },
         { {OSUTF8("MimeType"), 8}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Encoding */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->encoding);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.encodingPresent = TRUE;
            break;

         case 1: /* Id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* MimeType */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->mimeType);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.mimeTypePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "ObjectType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "ObjectType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { OSXSDAny* pdata1;
   OSXMLElemDescr elemDescr;
   const OSUTF8CHAR* pxmlstr;
   for (;;) {
      stat = rtXmlpGetNextElem (pctxt, &elemDescr, -1);
      if (0 != stat) break;

      stat = rtXmlpDecAnyElem (pctxt, &pxmlstr);
      if (0 != stat) break;

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      pdata1 = rtxMemAllocType (pctxt, OSXSDAny);
      if (0 == pdata1) return LOG_RTERR (pctxt, RTERR_NOMEM);

      pdata1->t = OSXSDAny_xmlText;
      pdata1->u.xmlText = pxmlstr;

      if (0 == rtxDListAppend (pctxt, &pvalue->sequence_list, pdata1))
         return LOG_RTERR (pctxt, RTERR_NOMEM);
   }
   if (stat == XML_OK_EOB) stat = 0;
   else return LOG_RTERR (pctxt, stat);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Object                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Object (OSCTXT* pctxt, Object *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;

   stat = asn1D_ObjectType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Object (OSCTXT* pctxt, Object* pvalue)
{
   int stat = 0;

   stat = XmlDec_ObjectType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignatureType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignatureType (OSCTXT* pctxt, SignatureType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode signedInfo */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SignedInfo (pctxt, 
               &pvalue->signedInfo, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode signatureValue */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SignatureValue (pctxt, 
               &pvalue->signatureValue, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode keyInfo */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_KeyInfo (pctxt, 
               &pvalue->keyInfo, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.keyInfoPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode object_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Object* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->object_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Object, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Object (pdata2);

                  stat = asn1D_Object (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->object_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SignatureType (OSCTXT* pctxt, SignatureType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Id"), 2}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SignatureType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SignatureType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("SignedInfo"), 10}, 0}, 0 },
      {{{OSUTF8("SignatureValue"), 14}, 0}, 1 },
      {{{OSUTF8("KeyInfo"), 7}, 0}, 2 },
      {{{OSUTF8("Object"), 6}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* SignedInfo */
         stat = XmlDec_SignedInfo (pctxt, &pvalue->signedInfo);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* SignatureValue */
         stat = XmlDec_SignatureValue (pctxt, &pvalue->signatureValue);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* KeyInfo */
         stat = XmlDec_KeyInfo (pctxt, &pvalue->keyInfo);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.keyInfoPresent = TRUE;
         break;
      }
      case 3: {
         Object* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Object);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Object (pdata1);

            stat = XmlDec_Object (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->object_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Signature                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Signature (OSCTXT* pctxt, Signature *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_SignatureType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Signature (OSCTXT* pctxt, Signature* pvalue)
{
   int stat = 0;

   stat = XmlDec_SignatureType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ManifestType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ManifestType (OSCTXT* pctxt, ManifestType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode reference_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Reference* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->reference_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Reference, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Reference (pdata2);

                  stat = asn1D_Reference (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->reference_list, pnode);
               }

               if (!(pvalue->reference_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "ManifestType.reference_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->reference_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_ManifestType (OSCTXT* pctxt, ManifestType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Id"), 2}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "ManifestType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "ManifestType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Reference"), 9}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Reference* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Reference);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Reference (pdata1);

            stat = XmlDec_Reference (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->reference_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Manifest                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Manifest (OSCTXT* pctxt, Manifest *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_ManifestType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Manifest (OSCTXT* pctxt, Manifest* pvalue)
{
   int stat = 0;

   stat = XmlDec_ManifestType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignaturePropertyType_element                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignaturePropertyType_element (OSCTXT* pctxt, 
   SignaturePropertyType_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         if (pctxt->flags & ASN1CONSTAG) {
            pvalue->u.elem.u.binary = rtxMemAllocType (pctxt, OSOpenType);
            stat = xd_OpenType (pctxt, &pvalue->u.elem.u.binary->data,
               &pvalue->u.elem.u.binary->numocts);
            pvalue->u.elem.t = OSXSDAny_binary;
         } else {
            stat = xd_utf8str (pctxt, &pvalue->u.elem.
               u.xmlText, ASN1IMPL, length);
            pvalue->u.elem.t = OSXSDAny_xmlText;
         }
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_SignaturePropertyType_element (OSCTXT* pctxt, 
   SignaturePropertyType_element* pvalue)
{
   int stat = 0;

   { int elemID;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignaturePropertyType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignaturePropertyType (OSCTXT* pctxt, 
   SignaturePropertyType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode target */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->target, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               SignaturePropertyType_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->choice_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, SignaturePropertyType_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_SignaturePropertyType_element (pdata2);

                  stat = asn1D_SignaturePropertyType_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->choice_list, pnode);
               }

               if (!(pvalue->choice_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "SignaturePropertyType.choice_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SignaturePropertyType (OSCTXT* pctxt, SignaturePropertyType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Id"), 2}, 0 },
         { {OSUTF8("Target"), 6}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 1: /* Target */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->target);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SignaturePropertyType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SignaturePropertyType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;
   SignaturePropertyType_element* pdata1;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignatureProperty                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignatureProperty (OSCTXT* pctxt, SignatureProperty *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_SignaturePropertyType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_SignatureProperty (OSCTXT* pctxt, SignatureProperty* pvalue)
{
   int stat = 0;

   stat = XmlDec_SignaturePropertyType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignaturePropertiesType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignaturePropertiesType (OSCTXT* pctxt, 
   SignaturePropertiesType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode signatureProperty_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               SignatureProperty* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->signatureProperty_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, SignatureProperty, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_SignatureProperty (pdata2);

                  stat = asn1D_SignatureProperty (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->signatureProperty_list, pnode);
               }

               if (!(pvalue->signatureProperty_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "SignaturePropertiesType.signatureProperty_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->signatureProperty_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SignaturePropertiesType (OSCTXT* pctxt, 
   SignaturePropertiesType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("Id"), 2}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* Id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SignaturePropertiesType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SignaturePropertiesType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("SignatureProperty"), 17}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         SignatureProperty* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, SignatureProperty);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_SignatureProperty (pdata1);

            stat = XmlDec_SignatureProperty (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->signatureProperty_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignatureProperties                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignatureProperties (OSCTXT* pctxt, 
   SignatureProperties *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_SignaturePropertiesType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_SignatureProperties (OSCTXT* pctxt, SignatureProperties* pvalue)
{
   int stat = 0;

   stat = XmlDec_SignaturePropertiesType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Manifest_PDU (OSCTXT* pctxt, Manifest* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_Manifest (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("Manifest"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_Manifest (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlDec_SignatureProperties_PDU (OSCTXT* pctxt, SignatureProperties* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_SignatureProperties (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("SignatureProperties"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_SignatureProperties (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
