/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "XSD.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  XMLCompatibleString                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_XMLCompatibleString (OSCTXT* pctxt, 
   XSD_XMLCompatibleString *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_XMLCompatibleString (OSCTXT* pctxt, 
   XSD_XMLCompatibleString* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AnySimpleType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_AnySimpleType (OSCTXT* pctxt, XSD_AnySimpleType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_XMLCompatibleString (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_AnySimpleType (OSCTXT* pctxt, XSD_AnySimpleType* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_XMLCompatibleString (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  XMLStringWithNoCRLFHT                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_XMLStringWithNoCRLFHT (OSCTXT* pctxt, 
   XSD_XMLStringWithNoCRLFHT *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_XMLStringWithNoCRLFHT (OSCTXT* pctxt, 
   XSD_XMLStringWithNoCRLFHT* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AnyURI                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_AnyURI (OSCTXT* pctxt, XSD_AnyURI *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_XMLStringWithNoCRLFHT (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_AnyURI (OSCTXT* pctxt, XSD_AnyURI* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_XMLStringWithNoCRLFHT (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Base64Binary                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Base64Binary (OSCTXT* pctxt, XSD_Base64Binary *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_octstr (pctxt, &pvalue->data, &pvalue->numocts, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Base64Binary (OSCTXT* pctxt, XSD_Base64Binary* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynHexStr (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Boolean                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Boolean (OSCTXT* pctxt, XSD_Boolean *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_boolean (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Boolean (OSCTXT* pctxt, XSD_Boolean* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecBool (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Byte                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Byte (OSCTXT* pctxt, XSD_Byte *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_int8 (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Byte (OSCTXT* pctxt, XSD_Byte* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecInt8 (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DATE_TIME                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_DATE_TIME (OSCTXT* pctxt, XSD_DATE_TIME *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_charstr (pctxt, pvalue, tagging, (TM_UNIV|TM_PRIM|26), length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_DATE_TIME (OSCTXT* pctxt, XSD_DATE_TIME* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, (const OSUTF8CHAR**)pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Date (OSCTXT* pctxt, XSD_Date *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Date (OSCTXT* pctxt, XSD_Date* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DateTime                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_DateTime (OSCTXT* pctxt, XSD_DateTime *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_DateTime (OSCTXT* pctxt, XSD_DateTime* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Decimal                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Decimal (OSCTXT* pctxt, XSD_Decimal *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Decimal (OSCTXT* pctxt, XSD_Decimal* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDouble (pctxt, pvalue, -1, -1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Double                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Double (OSCTXT* pctxt, XSD_Double *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Double (OSCTXT* pctxt, XSD_Double* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDouble (pctxt, pvalue, -1, -1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DURATION                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_DURATION (OSCTXT* pctxt, XSD_DURATION *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_charstr (pctxt, pvalue, tagging, (TM_UNIV|TM_PRIM|26), length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_DURATION (OSCTXT* pctxt, XSD_DURATION* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, (const OSUTF8CHAR**)pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Duration                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Duration (OSCTXT* pctxt, XSD_Duration *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DURATION (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Duration (OSCTXT* pctxt, XSD_Duration* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DURATION (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  String                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_String (OSCTXT* pctxt, XSD_String *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_XMLCompatibleString (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_String (OSCTXT* pctxt, XSD_String* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_XMLCompatibleString (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NormalizedString                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_NormalizedString (OSCTXT* pctxt, 
   XSD_NormalizedString *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_String (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_NormalizedString (OSCTXT* pctxt, XSD_NormalizedString* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_String (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Token                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Token (OSCTXT* pctxt, XSD_Token *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_NormalizedString (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Token (OSCTXT* pctxt, XSD_Token* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_NormalizedString (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Name                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Name (OSCTXT* pctxt, XSD_Name *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_Token (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Name (OSCTXT* pctxt, XSD_Name* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_Token (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NCName                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_NCName (OSCTXT* pctxt, XSD_NCName *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_Name (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_NCName (OSCTXT* pctxt, XSD_NCName* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_Name (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ENTITY                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_ENTITY (OSCTXT* pctxt, XSD_ENTITY *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_NCName (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_ENTITY (OSCTXT* pctxt, XSD_ENTITY* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_NCName (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Float                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Float (OSCTXT* pctxt, XSD_Float *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Float (OSCTXT* pctxt, XSD_Float* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDouble (pctxt, pvalue, -1, -1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GDay                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_GDay (OSCTXT* pctxt, XSD_GDay *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_GDay (OSCTXT* pctxt, XSD_GDay* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GMonth                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_GMonth (OSCTXT* pctxt, XSD_GMonth *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_GMonth (OSCTXT* pctxt, XSD_GMonth* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GMonthDay                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_GMonthDay (OSCTXT* pctxt, XSD_GMonthDay *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_GMonthDay (OSCTXT* pctxt, XSD_GMonthDay* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GYear                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_GYear (OSCTXT* pctxt, XSD_GYear *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_GYear (OSCTXT* pctxt, XSD_GYear* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GYearMonth                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_GYearMonth (OSCTXT* pctxt, XSD_GYearMonth *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_GYearMonth (OSCTXT* pctxt, XSD_GYearMonth* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HexBinary                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_HexBinary (OSCTXT* pctxt, XSD_HexBinary *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_octstr (pctxt, &pvalue->data, &pvalue->numocts, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_HexBinary (OSCTXT* pctxt, XSD_HexBinary* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynHexStr (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ID                                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_ID (OSCTXT* pctxt, XSD_ID *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;

   stat = asn1D_XSD_NCName (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_ID (OSCTXT* pctxt, XSD_ID* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_NCName (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IDREF                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_IDREF (OSCTXT* pctxt, XSD_IDREF *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_NCName (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_IDREF (OSCTXT* pctxt, XSD_IDREF* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_NCName (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Int                                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Int (OSCTXT* pctxt, XSD_Int *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;

   stat = xd_integer (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Int (OSCTXT* pctxt, XSD_Int* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecInt (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Integer                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Integer (OSCTXT* pctxt, XSD_Integer *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_integer (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Integer (OSCTXT* pctxt, XSD_Integer* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecInt (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Language                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Language (OSCTXT* pctxt, XSD_Language *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_charstr (pctxt, pvalue, tagging, (TM_UNIV|TM_PRIM|26), length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Language (OSCTXT* pctxt, XSD_Language* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, (const OSUTF8CHAR**)pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Long                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Long (OSCTXT* pctxt, XSD_Long *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_int64 (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Long (OSCTXT* pctxt, XSD_Long* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecInt64 (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NegativeInteger                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_NegativeInteger (OSCTXT* pctxt, 
   XSD_NegativeInteger *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_integer (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue <= -1)) {
      rtxErrAddStrParm (pctxt, "NegativeInteger");
      rtxErrAddIntParm (pctxt, *pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

int XmlDec_XSD_NegativeInteger (OSCTXT* pctxt, XSD_NegativeInteger* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecInt (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue <= -1)) {
      rtxErrAddStrParm (pctxt, "NegativeInteger");
      rtxErrAddIntParm (pctxt, *pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NMTOKEN                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_NMTOKEN (OSCTXT* pctxt, XSD_NMTOKEN *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_Token (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_NMTOKEN (OSCTXT* pctxt, XSD_NMTOKEN* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_Token (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonNegativeInteger                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_NonNegativeInteger (OSCTXT* pctxt, 
   XSD_NonNegativeInteger *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_unsigned (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue >= 0)) {
      rtxErrAddStrParm (pctxt, "NonNegativeInteger");
      rtxErrAddUIntParm (pctxt, *pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

int XmlDec_XSD_NonNegativeInteger (OSCTXT* pctxt, 
   XSD_NonNegativeInteger* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecUInt (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue >= 0)) {
      rtxErrAddStrParm (pctxt, "NonNegativeInteger");
      rtxErrAddUIntParm (pctxt, *pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonPositiveInteger                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_NonPositiveInteger (OSCTXT* pctxt, 
   XSD_NonPositiveInteger *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_integer (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue <= 0)) {
      rtxErrAddStrParm (pctxt, "NonPositiveInteger");
      rtxErrAddIntParm (pctxt, *pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

int XmlDec_XSD_NonPositiveInteger (OSCTXT* pctxt, 
   XSD_NonPositiveInteger* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecInt (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue <= 0)) {
      rtxErrAddStrParm (pctxt, "NonPositiveInteger");
      rtxErrAddIntParm (pctxt, *pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  QName                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_QName (OSCTXT* pctxt, XSD_QName *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode uri */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_XSD_AnyURI (pctxt, 
               &pvalue->uri, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.uriPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_XSD_NCName (pctxt, 
               &pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_XSD_QName (OSCTXT* pctxt, XSD_QName* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("uri"), 3}, 0}, 0 },
      {{{OSUTF8("name"), 4}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* uri */
         stat = XmlDec_XSD_AnyURI (pctxt, &pvalue->uri);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.uriPresent = TRUE;
         break;
      }
      case 1: { /* name */
         stat = XmlDec_XSD_NCName (pctxt, &pvalue->name);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NOTATION                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_NOTATION (OSCTXT* pctxt, XSD_NOTATION *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_QName (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_NOTATION (OSCTXT* pctxt, XSD_NOTATION* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_QName (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PositiveInteger                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_PositiveInteger (OSCTXT* pctxt, 
   XSD_PositiveInteger *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_unsigned (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue >= 1)) {
      rtxErrAddStrParm (pctxt, "PositiveInteger");
      rtxErrAddUIntParm (pctxt, *pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

int XmlDec_XSD_PositiveInteger (OSCTXT* pctxt, XSD_PositiveInteger* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecUInt (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue >= 1)) {
      rtxErrAddStrParm (pctxt, "PositiveInteger");
      rtxErrAddUIntParm (pctxt, *pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Short                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Short (OSCTXT* pctxt, XSD_Short *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_int16 (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Short (OSCTXT* pctxt, XSD_Short* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecInt16 (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Time (OSCTXT* pctxt, XSD_Time *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Time (OSCTXT* pctxt, XSD_Time* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnsignedByte                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_UnsignedByte (OSCTXT* pctxt, XSD_UnsignedByte *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_uint8 (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_UnsignedByte (OSCTXT* pctxt, XSD_UnsignedByte* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecUInt8 (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnsignedInt                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_UnsignedInt (OSCTXT* pctxt, XSD_UnsignedInt *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_unsigned (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_UnsignedInt (OSCTXT* pctxt, XSD_UnsignedInt* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecUInt (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnsignedLong                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_UnsignedLong (OSCTXT* pctxt, XSD_UnsignedLong *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_uint64 (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_UnsignedLong (OSCTXT* pctxt, XSD_UnsignedLong* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecUInt64 (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnsignedShort                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_UnsignedShort (OSCTXT* pctxt, XSD_UnsignedShort *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_uint16 (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_UnsignedShort (OSCTXT* pctxt, XSD_UnsignedShort* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecUInt16 (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  XMLStringWithNoWhitespace                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_XMLStringWithNoWhitespace (OSCTXT* pctxt, 
   XSD_XMLStringWithNoWhitespace *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_XMLStringWithNoWhitespace (OSCTXT* pctxt, 
   XSD_XMLStringWithNoWhitespace* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DateOnly                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_DateOnly (OSCTXT* pctxt, XSD_DateOnly *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_DateOnly (OSCTXT* pctxt, XSD_DateOnly* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day                                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Day (OSCTXT* pctxt, XSD_Day *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Day (OSCTXT* pctxt, XSD_Day* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Month (OSCTXT* pctxt, XSD_Month *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Month (OSCTXT* pctxt, XSD_Month* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MonthDay                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_MonthDay (OSCTXT* pctxt, XSD_MonthDay *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_MonthDay (OSCTXT* pctxt, XSD_MonthDay* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Year (OSCTXT* pctxt, XSD_Year *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_Year (OSCTXT* pctxt, XSD_Year* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  YearMonth                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_YearMonth (OSCTXT* pctxt, XSD_YearMonth *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_YearMonth (OSCTXT* pctxt, XSD_YearMonth* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TimeOnly                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_TimeOnly (OSCTXT* pctxt, XSD_TimeOnly *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_XSD_TimeOnly (OSCTXT* pctxt, XSD_TimeOnly* pvalue)
{
   int stat = 0;

   stat = XmlDec_XSD_DATE_TIME (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfXSD_String                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD__SeqOfXSD_String (OSCTXT* pctxt, 
   XSD__SeqOfXSD_String *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   XSD_String pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      stat = asn1D_XSD_String (pctxt, 
         &pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      pnode->data = (void*)pdata1;
      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_XSD__SeqOfXSD_String (OSCTXT* pctxt, XSD__SeqOfXSD_String* pvalue)
{
   int stat = 0;

   { int elemID;
   XSD_String pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("String"), 6}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* String */
         stat = XmlDec_XSD_String (pctxt, &pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AnyType                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_AnyType (OSCTXT* pctxt, XSD_AnyType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode embed_values */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_XSD__SeqOfXSD_String (pctxt, 
               &pvalue->embed_values, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode attr */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_XSD__SeqOfXSD_String (pctxt, 
               &pvalue->attr, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode elem_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_XSD__SeqOfXSD_String (pctxt, 
               &pvalue->elem_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_XSD_AnyType (OSCTXT* pctxt, XSD_AnyType* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("embed-values"), 12}, 0}, 0 },
      {{{OSUTF8("attr"), 4}, 0}, 1 },
      {{{OSUTF8("elem-list"), 9}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* embed-values */
         stat = XmlDec_XSD__SeqOfXSD_String (pctxt, &pvalue->embed_values);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* attr */
         stat = XmlDec_XSD__SeqOfXSD_String (pctxt, &pvalue->attr);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* elem-list */
         stat = XmlDec_XSD__SeqOfXSD_String (pctxt, &pvalue->elem_list);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ENTITIES                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_ENTITIES (OSCTXT* pctxt, XSD_ENTITIES *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   XSD_ENTITY pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      stat = asn1D_XSD_ENTITY (pctxt, 
         &pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      pnode->data = (void*)pdata1;
      rtxDListAppendNode (pvalue, pnode);
   }

   if (!(pvalue->count >= 1)) {
      rtxErrAddStrParm (pctxt, "ENTITIES.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_XSD_ENTITIES (OSCTXT* pctxt, XSD_ENTITIES* pvalue)
{
   int stat = 0;

   { int elemID;
   XSD_ENTITY pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("ENTITY"), 6}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* ENTITY */
         stat = XmlDec_XSD_ENTITY (pctxt, &pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IDREFS                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_IDREFS (OSCTXT* pctxt, XSD_IDREFS *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   XSD_IDREF pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      stat = asn1D_XSD_IDREF (pctxt, 
         &pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      pnode->data = (void*)pdata1;
      rtxDListAppendNode (pvalue, pnode);
   }

   if (!(pvalue->count >= 1)) {
      rtxErrAddStrParm (pctxt, "IDREFS.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_XSD_IDREFS (OSCTXT* pctxt, XSD_IDREFS* pvalue)
{
   int stat = 0;

   { int elemID;
   XSD_IDREF pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("IDREF"), 5}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* IDREF */
         stat = XmlDec_XSD_IDREF (pctxt, &pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NMTOKENS                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_NMTOKENS (OSCTXT* pctxt, XSD_NMTOKENS *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   XSD_NMTOKEN pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      stat = asn1D_XSD_NMTOKEN (pctxt, 
         &pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      pnode->data = (void*)pdata1;
      rtxDListAppendNode (pvalue, pnode);
   }

   if (!(pvalue->count >= 1)) {
      rtxErrAddStrParm (pctxt, "NMTOKENS.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_XSD_NMTOKENS (OSCTXT* pctxt, XSD_NMTOKENS* pvalue)
{
   int stat = 0;

   { int elemID;
   XSD_NMTOKEN pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("NMTOKEN"), 7}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* NMTOKEN */
         stat = XmlDec_XSD_NMTOKEN (pctxt, &pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

