/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "Urn-tva-metadata-2005.h"
#include "Urn-mpeg-mpeg7-schema-2001.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  TVAIDType                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TVAIDType (OSCTXT* pctxt, TVAIDType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_TVAIDType (OSCTXT* pctxt, TVAIDType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CSAliasType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CSAliasType (OSCTXT* pctxt, CSAliasType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode alias */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->alias, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode href */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->href, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode fragmentId */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TVAIDType (pctxt, 
               &pvalue->fragmentId, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fragmentIdPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode fragmentVersion */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_uint64 (pctxt, &pvalue->fragmentVersion, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fragmentVersionPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CSAliasType (OSCTXT* pctxt, CSAliasType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("alias"), 5}, 0 },
         { {OSUTF8("href"), 4}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("fragmentId"), 10}, 0 },
         { {OSUTF8("fragmentVersion"), 15}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* alias */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->alias);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* href */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->href);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 2: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 3: /* fragmentId */
            stat = XmlDec_TVAIDType (pctxt, &pvalue->fragmentId);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fragmentIdPresent = TRUE;
            break;

         case 4: /* fragmentVersion */
            stat = rtXmlpDecUInt64 (pctxt, &pvalue->fragmentVersion);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fragmentVersionPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CSAliasType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CSAliasType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ClassificationSchemeType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Urn_tva_metadata_2005_ClassificationSchemeType (
   OSCTXT* pctxt, Urn_tva_metadata_2005_ClassificationSchemeType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode domain */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->domain);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->domain, pnode);
               }

            }
            if (stat == 0) {
               pvalue->m.domainPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode mediaTimeBase */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_XPathRefType (pctxt, 
               (XPathRefType*)&pvalue->mediaTimeBase, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.mediaTimeBasePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode mediaTimeUnit */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_MediaDurationType (pctxt, 
               (MediaDurationType*)&pvalue->mediaTimeUnit, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.mediaTimeUnitPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode timeBase */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_XPathRefType (pctxt, 
               (XPathRefType*)&pvalue->timeBase, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeBasePresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode timeUnit */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DurationType (pctxt, 
               (DurationType*)&pvalue->timeUnit, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeUnitPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode uri */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->uri, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode fragmentId */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TVAIDType (pctxt, 
               &pvalue->fragmentId, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fragmentIdPresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode fragmentVersion */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_uint64 (pctxt, &pvalue->fragmentVersion, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fragmentVersionPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Urn_tva_metadata_2005_ClassificationSchemeType (OSCTXT* pctxt, 
   Urn_tva_metadata_2005_ClassificationSchemeType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("domain"), 6}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("mediaTimeBase"), 13}, 0 },
         { {OSUTF8("mediaTimeUnit"), 13}, 0 },
         { {OSUTF8("timeBase"), 8}, 0 },
         { {OSUTF8("timeUnit"), 8}, 0 },
         { {OSUTF8("uri"), 3}, 0 },
         { {OSUTF8("fragmentId"), 10}, 0 },
         { {OSUTF8("fragmentVersion"), 15}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 9, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* domain */
            rtxDListInit (&pvalue->domain);

            stat = rtXmlpDecStrList (pctxt, &pvalue->domain);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.domainPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* mediaTimeBase */
            stat = XmlDec_XPathRefType (pctxt, &pvalue->mediaTimeBase);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.mediaTimeBasePresent = TRUE;
            break;

         case 3: /* mediaTimeUnit */
            stat = XmlDec_MediaDurationType (pctxt, &pvalue->mediaTimeUnit);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.mediaTimeUnitPresent = TRUE;
            break;

         case 4: /* timeBase */
            stat = XmlDec_XPathRefType (pctxt, &pvalue->timeBase);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeBasePresent = TRUE;
            break;

         case 5: /* timeUnit */
            stat = XmlDec_DurationType (pctxt, &pvalue->timeUnit);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeUnitPresent = TRUE;
            break;

         case 6: /* uri */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->uri);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 7: /* fragmentId */
            stat = XmlDec_TVAIDType (pctxt, &pvalue->fragmentId);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fragmentIdPresent = TRUE;
            break;

         case 8: /* fragmentVersion */
            stat = rtXmlpDecUInt64 (pctxt, &pvalue->fragmentVersion);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fragmentVersionPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Urn_tva_metadata_2005_ClassificationSchemeType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Urn_tva_metadata_2005_ClassificationSchemeType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ServiceInformationNameLengthType                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ServiceInformationNameLengthType (OSCTXT* pctxt, 
   ServiceInformationNameLengthType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_ServiceInformationNameLengthType (OSCTXT* pctxt, 
   ServiceInformationNameLengthType* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = ServiceInformationNameLengthType_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SynopsisLengthType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SynopsisLengthType (OSCTXT* pctxt, 
   SynopsisLengthType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_SynopsisLengthType (OSCTXT* pctxt, SynopsisLengthType* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = SynopsisLengthType_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TVAIDRefType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TVAIDRefType (OSCTXT* pctxt, TVAIDRefType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_TVAIDRefType (OSCTXT* pctxt, TVAIDRefType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FrameRateType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_FrameRateType (OSCTXT* pctxt, FrameRateType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_FrameRateType (OSCTXT* pctxt, FrameRateType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GenreType_type                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_GenreType_type (OSCTXT* pctxt, GenreType_type *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_GenreType_type (OSCTXT* pctxt, GenreType_type* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = GenreType_type_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeywordType_type                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_KeywordType_type (OSCTXT* pctxt, KeywordType_type *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_KeywordType_type (OSCTXT* pctxt, KeywordType_type* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = KeywordType_type_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TermNameType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TermNameType (OSCTXT* pctxt, TermNameType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode lang */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->lang, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.langPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode phoneticAlphabet */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PhoneticAlphabetType (pctxt, 
               (PhoneticAlphabetType*)&pvalue->phoneticAlphabet, ASN1IMPL, length);
            if (stat == 0) {
               if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
                  return LOG_RTERR (pctxt, RTERR_INVENUM);

               pvalue->m.phoneticAlphabetPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode phoneticTranscription */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->phoneticTranscription);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->phoneticTranscription, pnode);
               }

            }
            if (stat == 0) {
               pvalue->m.phoneticTranscriptionPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode preferred */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->preferred, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preferredPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_TermNameType (OSCTXT* pctxt, TermNameType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("lang"), 4}, 0 },
         { {OSUTF8("phoneticAlphabet"), 16}, 0 },
         { {OSUTF8("phoneticTranscription"), 21}, 0 },
         { {OSUTF8("preferred"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* lang */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->lang);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.langPresent = TRUE;
            break;

         case 1: /* phoneticAlphabet */
            stat = XmlDec_PhoneticAlphabetType (pctxt, &pvalue->
               phoneticAlphabet);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.phoneticAlphabetPresent = TRUE;
            break;

         case 2: /* phoneticTranscription */
            rtxDListInit (&pvalue->phoneticTranscription);

            stat = rtXmlpDecStrList (pctxt, &pvalue->phoneticTranscription);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.phoneticTranscriptionPresent = TRUE;
            break;

         case 3: /* preferred */
            stat = rtXmlpDecBool (pctxt, &pvalue->preferred);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preferredPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "TermNameType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "TermNameType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->base);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ControlledTermType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ControlledTermType (OSCTXT* pctxt, 
   ControlledTermType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode href */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->href = rtxMemAllocType (pctxt, TermReferenceType);

            if (pvalue->href == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TermReferenceType ((TermReferenceType*)pvalue->href);
            asn1Init_TermReferenceType ((TermReferenceType*)pvalue->href);

            stat = asn1D_TermReferenceType (pctxt, 
               (TermReferenceType*)pvalue->href, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TermNameType (pctxt, 
               &pvalue->name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 2:
         /* decode definition */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->definition = rtxMemAllocType (pctxt, TextualType);

            if (pvalue->definition == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TextualType ((TextualType*)pvalue->definition);
            asn1Init_TextualType ((TextualType*)pvalue->definition);

            stat = asn1D_TextualType (pctxt, 
               (TextualType*)pvalue->definition, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.definitionPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_ControlledTermType (OSCTXT* pctxt, ControlledTermType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("href"), 4}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* href */
            pvalue->href = rtxMemAllocType (pctxt, TermReferenceType);

            if (pvalue->href == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TermReferenceType ((TermReferenceType*)pvalue->href);

            stat = XmlDec_TermReferenceType (pctxt, pvalue->href);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "ControlledTermType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "ControlledTermType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Name"), 4}, 0}, 0 },
      {{{OSUTF8("Definition"), 10}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Name */
         stat = XmlDec_TermNameType (pctxt, &pvalue->name);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.namePresent = TRUE;
         break;
      }
      case 1: { /* Definition */
         pvalue->definition = rtxMemAllocType (pctxt, TextualType);

         if (pvalue->definition == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_TextualType ((TextualType*)pvalue->definition);

         stat = XmlDec_TextualType (pctxt, pvalue->definition);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.definitionPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ClassificationSchemeTableType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ClassificationSchemeTableType (OSCTXT* pctxt, 
   ClassificationSchemeTableType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode cSAlias_list */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CSAliasType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->cSAlias_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CSAliasType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CSAliasType (pdata2);

                  stat = asn1D_CSAliasType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->cSAlias_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode classificationScheme_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ClassificationSchemeType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->classificationScheme_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ClassificationSchemeType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ClassificationSchemeType ((ClassificationSchemeType*)pdata2);

                  stat = asn1D_ClassificationSchemeType (pctxt, 
                     (ClassificationSchemeType*)pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->classificationScheme_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_ClassificationSchemeTableType (OSCTXT* pctxt, 
   ClassificationSchemeTableType* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("CSAlias"), 7}, 0}, 0 },
      {{{OSUTF8("ClassificationScheme"), 20}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         CSAliasType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CSAliasType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CSAliasType (pdata1);

            stat = XmlDec_CSAliasType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->cSAlias_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: {
         ClassificationSchemeType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ClassificationSchemeType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ClassificationSchemeType ((ClassificationSchemeType*)
               pdata1);

            stat = XmlDec_ClassificationSchemeType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->classificationScheme_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TVAAgentType_element_personNameIDRef                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TVAAgentType_element_personNameIDRef (OSCTXT* pctxt, 
   TVAAgentType_element_personNameIDRef *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode ref */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TVAIDRefType (pctxt, 
               &pvalue->ref, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_TVAAgentType_element_personNameIDRef (OSCTXT* pctxt, 
   TVAAgentType_element_personNameIDRef* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("ref"), 3}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* ref */
            stat = XmlDec_TVAIDRefType (pctxt, &pvalue->ref);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "TVAAgentType_element_personNameIDRef");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "TVAAgentType_element_personNameIDRef");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TVAAgentType_element_organizationNameIDRef                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TVAAgentType_element_organizationNameIDRef (OSCTXT* pctxt, 
   TVAAgentType_element_organizationNameIDRef *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode ref */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TVAIDRefType (pctxt, 
               &pvalue->ref, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_TVAAgentType_element_organizationNameIDRef (OSCTXT* pctxt, 
   TVAAgentType_element_organizationNameIDRef* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("ref"), 3}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* ref */
            stat = XmlDec_TVAIDRefType (pctxt, &pvalue->ref);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "TVAAgentType_element_organizationNameIDRef");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "TVAAgentType_element_organizationNameIDRef");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TVAAgentType_element                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TVAAgentType_element (OSCTXT* pctxt, 
   TVAAgentType_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.personName = rtxMemAllocType (pctxt, PersonNameType);

         if (pvalue->u.personName == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PersonNameType ((PersonNameType*)pvalue->u.personName);
         stat = asn1D_PersonNameType (pctxt, 
            (PersonNameType*)pvalue->u.personName, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.personNameIDRef
             = rtxMemAllocType (pctxt, TVAAgentType_element_personNameIDRef);

         if (pvalue->u.personNameIDRef == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_TVAAgentType_element_personNameIDRef (pvalue->u.personNameIDRef);
         stat = asn1D_TVAAgentType_element_personNameIDRef (pctxt, 
            pvalue->u.personNameIDRef, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.organizationName = rtxMemAllocType (pctxt, TextualType);

         if (pvalue->u.organizationName == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_TextualType ((TextualType*)pvalue->u.organizationName);
         stat = asn1D_TextualType (pctxt, 
            (TextualType*)pvalue->u.organizationName, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.organizationNameIDRef
             = rtxMemAllocType (pctxt, TVAAgentType_element_organizationNameIDRef);

         if (pvalue->u.organizationNameIDRef == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_TVAAgentType_element_organizationNameIDRef (pvalue->u.organizationNameIDRef);
         stat = asn1D_TVAAgentType_element_organizationNameIDRef (pctxt, 
            pvalue->u.organizationNameIDRef, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_TVAAgentType_element (OSCTXT* pctxt, TVAAgentType_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("PersonName"), 10}, 0}, 0 },
      {{{OSUTF8("PersonNameIDRef"), 15}, 0}, 1 },
      {{{OSUTF8("OrganizationName"), 16}, 0}, 2 },
      {{{OSUTF8("OrganizationNameIDRef"), 21}, 0}, 3 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 4, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* PersonName */
      pvalue->u.personName = rtxMemAllocType (pctxt, PersonNameType);

      if (pvalue->u.personName == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PersonNameType ((PersonNameType*)pvalue->u.personName);

      stat = XmlDec_PersonNameType (pctxt, pvalue->u.personName);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* PersonNameIDRef */
      pvalue->u.personNameIDRef
          = rtxMemAllocType (pctxt, TVAAgentType_element_personNameIDRef);

      if (pvalue->u.personNameIDRef == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_TVAAgentType_element_personNameIDRef (pvalue->u.personNameIDRef
         );

      stat = XmlDec_TVAAgentType_element_personNameIDRef (pctxt, pvalue->
         u.personNameIDRef);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* OrganizationName */
      pvalue->u.organizationName = rtxMemAllocType (pctxt, TextualType);

      if (pvalue->u.organizationName == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_TextualType ((TextualType*)pvalue->u.organizationName);

      stat = XmlDec_TextualType (pctxt, pvalue->u.organizationName);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* OrganizationNameIDRef */
      pvalue->u.organizationNameIDRef
          = rtxMemAllocType (pctxt, TVAAgentType_element_organizationNameIDRef);

      if (pvalue->u.organizationNameIDRef == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_TVAAgentType_element_organizationNameIDRef (pvalue->
         u.organizationNameIDRef);

      stat = XmlDec_TVAAgentType_element_organizationNameIDRef (pctxt, pvalue->
         u.organizationNameIDRef);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TVAAgentType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TVAAgentType (OSCTXT* pctxt, TVAAgentType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   TVAAgentType_element* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, TVAAgentType_element, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_TVAAgentType_element (pdata1);

      stat = asn1D_TVAAgentType_element (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   return (stat);
}

int XmlDec_TVAAgentType (OSCTXT* pctxt, TVAAgentType* pvalue)
{
   int stat = 0;

   { int elemID;
   TVAAgentType_element* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("PersonName"), 10}, 0}, 0 },
      {{{OSUTF8("PersonNameIDRef"), 15}, 0}, 0 },
      {{{OSUTF8("OrganizationName"), 16}, 0}, 0 },
      {{{OSUTF8("OrganizationNameIDRef"), 21}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 4, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0:
         rtXmlpMarkLastEventActive (pctxt);

         pdata1 = rtxMemAllocType (pctxt, TVAAgentType_element);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_TVAAgentType_element (pdata1);

         stat = XmlDec_TVAAgentType_element (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CreditsItemType_element_personNameIDRef                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CreditsItemType_element_personNameIDRef (OSCTXT* pctxt, 
   CreditsItemType_element_personNameIDRef *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode ref */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TVAIDRefType (pctxt, 
               &pvalue->ref, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CreditsItemType_element_personNameIDRef (OSCTXT* pctxt, 
   CreditsItemType_element_personNameIDRef* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("ref"), 3}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* ref */
            stat = XmlDec_TVAIDRefType (pctxt, &pvalue->ref);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CreditsItemType_element_personNameIDRef");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CreditsItemType_element_personNameIDRef");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CreditsItemType_element_organizationNameIDRef             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CreditsItemType_element_organizationNameIDRef (OSCTXT* pctxt, 
   CreditsItemType_element_organizationNameIDRef *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode ref */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TVAIDRefType (pctxt, 
               &pvalue->ref, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CreditsItemType_element_organizationNameIDRef (OSCTXT* pctxt, 
   CreditsItemType_element_organizationNameIDRef* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("ref"), 3}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* ref */
            stat = XmlDec_TVAIDRefType (pctxt, &pvalue->ref);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CreditsItemType_element_organizationNameIDRef");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CreditsItemType_element_organizationNameIDRef");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CreditsItemType_element                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CreditsItemType_element (OSCTXT* pctxt, 
   CreditsItemType_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.personName = rtxMemAllocType (pctxt, PersonNameType);

         if (pvalue->u.personName == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PersonNameType ((PersonNameType*)pvalue->u.personName);
         stat = asn1D_PersonNameType (pctxt, 
            (PersonNameType*)pvalue->u.personName, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.personNameIDRef
             = rtxMemAllocType (pctxt, CreditsItemType_element_personNameIDRef);

         if (pvalue->u.personNameIDRef == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CreditsItemType_element_personNameIDRef (pvalue->u.personNameIDRef);
         stat = asn1D_CreditsItemType_element_personNameIDRef (pctxt, 
            pvalue->u.personNameIDRef, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.organizationName = rtxMemAllocType (pctxt, TextualType);

         if (pvalue->u.organizationName == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_TextualType ((TextualType*)pvalue->u.organizationName);
         stat = asn1D_TextualType (pctxt, 
            (TextualType*)pvalue->u.organizationName, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.organizationNameIDRef
             = rtxMemAllocType (pctxt, CreditsItemType_element_organizationNameIDRef);

         if (pvalue->u.organizationNameIDRef == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CreditsItemType_element_organizationNameIDRef (pvalue->u.organizationNameIDRef);
         stat = asn1D_CreditsItemType_element_organizationNameIDRef (pctxt, 
            pvalue->u.organizationNameIDRef, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_CreditsItemType_element (OSCTXT* pctxt, 
   CreditsItemType_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("PersonName"), 10}, 0}, 0 },
      {{{OSUTF8("PersonNameIDRef"), 15}, 0}, 1 },
      {{{OSUTF8("OrganizationName"), 16}, 0}, 2 },
      {{{OSUTF8("OrganizationNameIDRef"), 21}, 0}, 3 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 4, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* PersonName */
      pvalue->u.personName = rtxMemAllocType (pctxt, PersonNameType);

      if (pvalue->u.personName == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PersonNameType ((PersonNameType*)pvalue->u.personName);

      stat = XmlDec_PersonNameType (pctxt, pvalue->u.personName);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* PersonNameIDRef */
      pvalue->u.personNameIDRef
          = rtxMemAllocType (pctxt, CreditsItemType_element_personNameIDRef);

      if (pvalue->u.personNameIDRef == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CreditsItemType_element_personNameIDRef (pvalue->
         u.personNameIDRef);

      stat = XmlDec_CreditsItemType_element_personNameIDRef (pctxt, pvalue->
         u.personNameIDRef);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* OrganizationName */
      pvalue->u.organizationName = rtxMemAllocType (pctxt, TextualType);

      if (pvalue->u.organizationName == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_TextualType ((TextualType*)pvalue->u.organizationName);

      stat = XmlDec_TextualType (pctxt, pvalue->u.organizationName);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* OrganizationNameIDRef */
      pvalue->u.organizationNameIDRef
          = rtxMemAllocType (pctxt, CreditsItemType_element_organizationNameIDRef);

      if (pvalue->u.organizationNameIDRef == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CreditsItemType_element_organizationNameIDRef (pvalue->
         u.organizationNameIDRef);

      stat = XmlDec_CreditsItemType_element_organizationNameIDRef (pctxt, 
         pvalue->u.organizationNameIDRef);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CreditsItemType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CreditsItemType (OSCTXT* pctxt, CreditsItemType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode role */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->role = rtxMemAllocType (pctxt, TermReferenceType);

            if (pvalue->role == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TermReferenceType ((TermReferenceType*)pvalue->role);
            asn1Init_TermReferenceType ((TermReferenceType*)pvalue->role);

            stat = asn1D_TermReferenceType (pctxt, 
               (TermReferenceType*)pvalue->role, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CreditsItemType_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->choice_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CreditsItemType_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CreditsItemType_element (pdata2);

                  stat = asn1D_CreditsItemType_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->choice_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode character_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               PersonNameType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->character_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, PersonNameType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_PersonNameType ((PersonNameType*)pdata2);

                  stat = asn1D_PersonNameType (pctxt, 
                     (PersonNameType*)pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->character_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CreditsItemType (OSCTXT* pctxt, CreditsItemType* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("role"), 4}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* role */
            pvalue->role = rtxMemAllocType (pctxt, TermReferenceType);

            if (pvalue->role == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TermReferenceType ((TermReferenceType*)pvalue->role);

            stat = XmlDec_TermReferenceType (pctxt, pvalue->role);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CreditsItemType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CreditsItemType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("PersonName"), 10}, 0}, 0 },
      {{{OSUTF8("PersonNameIDRef"), 15}, 0}, 0 },
      {{{OSUTF8("OrganizationName"), 16}, 0}, 0 },
      {{{OSUTF8("OrganizationNameIDRef"), 21}, 0}, 0 },
      {{{OSUTF8("Character"), 9}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         CreditsItemType_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CreditsItemType_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CreditsItemType_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_CreditsItemType_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->choice_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 4, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: {
         PersonNameType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, PersonNameType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_PersonNameType ((PersonNameType*)pdata1);

            stat = XmlDec_PersonNameType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->character_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 4, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CreditsListType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CreditsListType (OSCTXT* pctxt, CreditsListType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   CreditsItemType* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, CreditsItemType, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CreditsItemType (pdata1);

      stat = asn1D_CreditsItemType (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   return (stat);
}

int XmlDec_CreditsListType (OSCTXT* pctxt, CreditsListType* pvalue)
{
   int stat = 0;

   { int elemID;
   CreditsItemType* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("CreditsItem"), 11}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* CreditsItem */
         pdata1 = rtxMemAllocType (pctxt, CreditsItemType);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CreditsItemType (pdata1);

         stat = XmlDec_CreditsItemType (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FlagType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_FlagType (OSCTXT* pctxt, FlagType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_FlagType (OSCTXT* pctxt, FlagType* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* value */
            stat = rtXmlpDecBool (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "FlagType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "FlagType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ServiceInformationNameType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ServiceInformationNameType (OSCTXT* pctxt, 
   ServiceInformationNameType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode lang */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->lang, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.langPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode phoneticAlphabet */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PhoneticAlphabetType (pctxt, 
               (PhoneticAlphabetType*)&pvalue->phoneticAlphabet, ASN1IMPL, length);
            if (stat == 0) {
               if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
                  return LOG_RTERR (pctxt, RTERR_INVENUM);

               pvalue->m.phoneticAlphabetPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode phoneticTranscription */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->phoneticTranscription);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->phoneticTranscription, pnode);
               }

            }
            if (stat == 0) {
               pvalue->m.phoneticTranscriptionPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode length */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ServiceInformationNameLengthType (pctxt, 
               &pvalue->length, ASN1IMPL, length);
            if (stat == 0) {
               if(pvalue->length < 0 || pvalue->length > 2)
                  return LOG_RTERR (pctxt, RTERR_INVENUM);

               pvalue->m.lengthPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_ServiceInformationNameType (OSCTXT* pctxt, 
   ServiceInformationNameType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("lang"), 4}, 0 },
         { {OSUTF8("phoneticAlphabet"), 16}, 0 },
         { {OSUTF8("phoneticTranscription"), 21}, 0 },
         { {OSUTF8("length"), 6}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* lang */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->lang);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.langPresent = TRUE;
            break;

         case 1: /* phoneticAlphabet */
            stat = XmlDec_PhoneticAlphabetType (pctxt, &pvalue->
               phoneticAlphabet);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.phoneticAlphabetPresent = TRUE;
            break;

         case 2: /* phoneticTranscription */
            rtxDListInit (&pvalue->phoneticTranscription);

            stat = rtXmlpDecStrList (pctxt, &pvalue->phoneticTranscription);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.phoneticTranscriptionPresent = TRUE;
            break;

         case 3: /* length */
            stat = XmlDec_ServiceInformationNameLengthType (pctxt, &pvalue->
               length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.lengthPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "ServiceInformationNameType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "ServiceInformationNameType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->base);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SynopsisType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SynopsisType (OSCTXT* pctxt, SynopsisType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode lang */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->lang, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.langPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode phoneticAlphabet */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PhoneticAlphabetType (pctxt, 
               (PhoneticAlphabetType*)&pvalue->phoneticAlphabet, ASN1IMPL, length);
            if (stat == 0) {
               if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
                  return LOG_RTERR (pctxt, RTERR_INVENUM);

               pvalue->m.phoneticAlphabetPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode phoneticTranscription */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->phoneticTranscription);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->phoneticTranscription, pnode);
               }

            }
            if (stat == 0) {
               pvalue->m.phoneticTranscriptionPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SynopsisType (OSCTXT* pctxt, SynopsisType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("lang"), 4}, 0 },
         { {OSUTF8("phoneticAlphabet"), 16}, 0 },
         { {OSUTF8("phoneticTranscription"), 21}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* lang */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->lang);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.langPresent = TRUE;
            break;

         case 1: /* phoneticAlphabet */
            stat = XmlDec_PhoneticAlphabetType (pctxt, &pvalue->
               phoneticAlphabet);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.phoneticAlphabetPresent = TRUE;
            break;

         case 2: /* phoneticTranscription */
            rtxDListInit (&pvalue->phoneticTranscription);

            stat = rtXmlpDecStrList (pctxt, &pvalue->phoneticTranscription);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.phoneticTranscriptionPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SynopsisType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SynopsisType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->base);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GenreType                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_GenreType (OSCTXT* pctxt, GenreType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode href */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->href = rtxMemAllocType (pctxt, TermReferenceType);

            if (pvalue->href == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TermReferenceType ((TermReferenceType*)pvalue->href);
            asn1Init_TermReferenceType ((TermReferenceType*)pvalue->href);

            stat = asn1D_TermReferenceType (pctxt, 
               (TermReferenceType*)pvalue->href, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode type */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_GenreType_type (pctxt, 
               &pvalue->type, ASN1IMPL, length);
            if (stat == 0) {
               if(pvalue->type < 0 || pvalue->type > 2)
                  return LOG_RTERR (pctxt, RTERR_INVENUM);

               pvalue->m.typePresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TermNameType (pctxt, 
               &pvalue->name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode definition */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->definition = rtxMemAllocType (pctxt, TextualType);

            if (pvalue->definition == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TextualType ((TextualType*)pvalue->definition);
            asn1Init_TextualType ((TextualType*)pvalue->definition);

            stat = asn1D_TextualType (pctxt, 
               (TextualType*)pvalue->definition, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.definitionPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_GenreType (OSCTXT* pctxt, GenreType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("href"), 4}, 0 },
         { {OSUTF8("type"), 4}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* href */
            pvalue->href = rtxMemAllocType (pctxt, TermReferenceType);

            if (pvalue->href == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TermReferenceType ((TermReferenceType*)pvalue->href);

            stat = XmlDec_TermReferenceType (pctxt, pvalue->href);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* type */
            stat = XmlDec_GenreType_type (pctxt, &pvalue->type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.typePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "GenreType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "GenreType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Name"), 4}, 0}, 0 },
      {{{OSUTF8("Definition"), 10}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Name */
         stat = XmlDec_TermNameType (pctxt, &pvalue->name);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.namePresent = TRUE;
         break;
      }
      case 1: { /* Definition */
         pvalue->definition = rtxMemAllocType (pctxt, TextualType);

         if (pvalue->definition == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_TextualType ((TextualType*)pvalue->definition);

         stat = XmlDec_TextualType (pctxt, pvalue->definition);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.definitionPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeywordType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_KeywordType (OSCTXT* pctxt, KeywordType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode lang */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->lang, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.langPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode phoneticAlphabet */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PhoneticAlphabetType (pctxt, 
               (PhoneticAlphabetType*)&pvalue->phoneticAlphabet, ASN1IMPL, length);
            if (stat == 0) {
               if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
                  return LOG_RTERR (pctxt, RTERR_INVENUM);

               pvalue->m.phoneticAlphabetPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode phoneticTranscription */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->phoneticTranscription);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->phoneticTranscription, pnode);
               }

            }
            if (stat == 0) {
               pvalue->m.phoneticTranscriptionPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode type */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_KeywordType_type (pctxt, 
               &pvalue->type, ASN1IMPL, length);
            if (stat == 0) {
               if(pvalue->type < 0 || pvalue->type > 2)
                  return LOG_RTERR (pctxt, RTERR_INVENUM);

               pvalue->m.typePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_KeywordType (OSCTXT* pctxt, KeywordType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("lang"), 4}, 0 },
         { {OSUTF8("phoneticAlphabet"), 16}, 0 },
         { {OSUTF8("phoneticTranscription"), 21}, 0 },
         { {OSUTF8("type"), 4}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* lang */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->lang);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.langPresent = TRUE;
            break;

         case 1: /* phoneticAlphabet */
            stat = XmlDec_PhoneticAlphabetType (pctxt, &pvalue->
               phoneticAlphabet);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.phoneticAlphabetPresent = TRUE;
            break;

         case 2: /* phoneticTranscription */
            rtxDListInit (&pvalue->phoneticTranscription);

            stat = rtXmlpDecStrList (pctxt, &pvalue->phoneticTranscription);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.phoneticTranscriptionPresent = TRUE;
            break;

         case 3: /* type */
            stat = XmlDec_KeywordType_type (pctxt, &pvalue->type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.typePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "KeywordType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "KeywordType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->base);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CaptionLanguageType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CaptionLanguageType (OSCTXT* pctxt, 
   CaptionLanguageType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   pvalue->closed = TRUE;
   pvalue->supplemental = FALSE;

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode closed */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->closed, ASN1IMPL, length);
            if (stat == 0) {
            }
         }
         break;

      case 1:
         /* decode supplemental */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->supplemental, ASN1IMPL, length);
            if (stat == 0) {
            }
         }
         break;

      case 2:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CaptionLanguageType (OSCTXT* pctxt, CaptionLanguageType* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("closed"), 6}, 0 },
         { {OSUTF8("supplemental"), 12}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* closed */
            stat = rtXmlpDecBool (pctxt, &pvalue->closed);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* supplemental */
            stat = rtXmlpDecBool (pctxt, &pvalue->supplemental);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CaptionLanguageType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CaptionLanguageType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->base);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignLanguageType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignLanguageType (OSCTXT* pctxt, SignLanguageType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode primary */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->primary, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.primaryPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode translation */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->translation, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.translationPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode type */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.typePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SignLanguageType (OSCTXT* pctxt, SignLanguageType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("primary"), 7}, 0 },
         { {OSUTF8("translation"), 11}, 0 },
         { {OSUTF8("type"), 4}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* primary */
            stat = rtXmlpDecBool (pctxt, &pvalue->primary);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.primaryPresent = TRUE;
            break;

         case 1: /* translation */
            stat = rtXmlpDecBool (pctxt, &pvalue->translation);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.translationPresent = TRUE;
            break;

         case 2: /* type */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.typePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SignLanguageType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SignLanguageType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->base);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BitRateType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_BitRateType (OSCTXT* pctxt, BitRateType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   pvalue->variable = FALSE;

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode average */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_uint64 (pctxt, &pvalue->average, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.averagePresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode maximum */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_uint64 (pctxt, &pvalue->maximum, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.maximumPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode minimum */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_uint64 (pctxt, &pvalue->minimum, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.minimumPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode variable */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->variable, ASN1IMPL, length);
            if (stat == 0) {
            }
         }
         break;

      case 4:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_unsigned (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat == 0) {
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_BitRateType (OSCTXT* pctxt, BitRateType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("average"), 7}, 0 },
         { {OSUTF8("maximum"), 7}, 0 },
         { {OSUTF8("minimum"), 7}, 0 },
         { {OSUTF8("variable"), 8}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* average */
            stat = rtXmlpDecUInt64 (pctxt, &pvalue->average);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.averagePresent = TRUE;
            break;

         case 1: /* maximum */
            stat = rtXmlpDecUInt64 (pctxt, &pvalue->maximum);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.maximumPresent = TRUE;
            break;

         case 2: /* minimum */
            stat = rtXmlpDecUInt64 (pctxt, &pvalue->minimum);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.minimumPresent = TRUE;
            break;

         case 3: /* variable */
            stat = rtXmlpDecBool (pctxt, &pvalue->variable);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "BitRateType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "BitRateType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   stat = rtXmlpDecUInt (pctxt, &pvalue->base);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TVAAgentType_derivations                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TVAAgentType_derivations (OSCTXT* pctxt, 
   TVAAgentType_derivations *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.tVAAgentType = rtxMemAllocType (pctxt, TVAAgentType);

         if (pvalue->u.tVAAgentType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_TVAAgentType (pvalue->u.tVAAgentType);
         stat = asn1D_TVAAgentType (pctxt, 
            pvalue->u.tVAAgentType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.creditsItemType = rtxMemAllocType (pctxt, CreditsItemType);

         if (pvalue->u.creditsItemType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CreditsItemType (pvalue->u.creditsItemType);
         stat = asn1D_CreditsItemType (pctxt, 
            pvalue->u.creditsItemType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_TVAAgentType_derivations (OSCTXT* pctxt, 
   TVAAgentType_derivations* pvalue)
{
   const OSUTF8CHAR* xsiType = 0;
   int stat = 0;

   /* decode xsi:type attribute */
   if (rtXmlpHasAttributes (pctxt)) {
      OSUINT32 i, nAttrs = 0;
      OSXMLNameFragments attrName;

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) == 0 &&
             rtXmlpDecXSITypeAttr (pctxt, &attrName, &xsiType) == 0) break;
      }
   }

   /* decode content */
   if (!OS_ISEMPTY (xsiType)) {
      xsiType = rtXmlDecQName (pctxt, xsiType, 0);
   }
   if (OS_ISEMPTY (xsiType)) {
      pvalue->t = 1;
      pvalue->u.tVAAgentType = rtxMemAllocType (pctxt, TVAAgentType);

      if (pvalue->u.tVAAgentType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_TVAAgentType (pvalue->u.tVAAgentType);

      stat = XmlDec_TVAAgentType (pctxt, pvalue->u.tVAAgentType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("TVAAgentType")))
   {
      pvalue->t = 1;
      pvalue->u.tVAAgentType = rtxMemAllocType (pctxt, TVAAgentType);

      if (pvalue->u.tVAAgentType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_TVAAgentType (pvalue->u.tVAAgentType);

      stat = XmlDec_TVAAgentType (pctxt, pvalue->u.tVAAgentType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("CreditsItemType")))
   {
      pvalue->t = 2;
      pvalue->u.creditsItemType = rtxMemAllocType (pctxt, CreditsItemType);

      if (pvalue->u.creditsItemType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CreditsItemType (pvalue->u.creditsItemType);

      stat = XmlDec_CreditsItemType (pctxt, pvalue->u.creditsItemType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ControlledTermType_derivations                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ControlledTermType_derivations (OSCTXT* pctxt, 
   ControlledTermType_derivations *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.controlledTermType
             = rtxMemAllocType (pctxt, ControlledTermType);

         if (pvalue->u.controlledTermType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_ControlledTermType (pvalue->u.controlledTermType);
         stat = asn1D_ControlledTermType (pctxt, 
            pvalue->u.controlledTermType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.genreType = rtxMemAllocType (pctxt, GenreType);

         if (pvalue->u.genreType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_GenreType (pvalue->u.genreType);
         stat = asn1D_GenreType (pctxt, 
            pvalue->u.genreType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_ControlledTermType_derivations (OSCTXT* pctxt, 
   ControlledTermType_derivations* pvalue)
{
   const OSUTF8CHAR* xsiType = 0;
   int stat = 0;

   /* decode xsi:type attribute */
   if (rtXmlpHasAttributes (pctxt)) {
      OSUINT32 i, nAttrs = 0;
      OSXMLNameFragments attrName;

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) == 0 &&
             rtXmlpDecXSITypeAttr (pctxt, &attrName, &xsiType) == 0) break;
      }
   }

   /* decode content */
   if (!OS_ISEMPTY (xsiType)) {
      xsiType = rtXmlDecQName (pctxt, xsiType, 0);
   }
   if (OS_ISEMPTY (xsiType)) {
      pvalue->t = 1;
      pvalue->u.controlledTermType
          = rtxMemAllocType (pctxt, ControlledTermType);

      if (pvalue->u.controlledTermType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_ControlledTermType (pvalue->u.controlledTermType);

      stat = XmlDec_ControlledTermType (pctxt, pvalue->u.controlledTermType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("ControlledTermType")))
   {
      pvalue->t = 1;
      pvalue->u.controlledTermType
          = rtxMemAllocType (pctxt, ControlledTermType);

      if (pvalue->u.controlledTermType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_ControlledTermType (pvalue->u.controlledTermType);

      stat = XmlDec_ControlledTermType (pctxt, pvalue->u.controlledTermType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("GenreType")))
   {
      pvalue->t = 2;
      pvalue->u.genreType = rtxMemAllocType (pctxt, GenreType);

      if (pvalue->u.genreType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_GenreType (pvalue->u.genreType);

      stat = XmlDec_GenreType (pctxt, pvalue->u.genreType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }

   return (stat);
}

int XmlDec_SynopsisLengthType_PDU (OSCTXT* pctxt, SynopsisLengthType* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("synopsisLengthType"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_SynopsisLengthType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlDec_FlagType_PDU (OSCTXT* pctxt, FlagType* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_FlagType (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("flagType"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_FlagType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
