/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "Urn-mpeg-mpeg7-schema-2001.h"
#include "Urn-tva-metadata-2005.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  MimeType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MimeType (OSCTXT* pctxt,
   MimeType pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_utf8str (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_MimeType (OSCTXT* pctxt, MimeType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PhoneType                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PhoneType (OSCTXT* pctxt,
   PhoneType pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_utf8str (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_PhoneType (OSCTXT* pctxt, PhoneType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PhoneticAlphabetType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PhoneticAlphabetType (OSCTXT* pctxt,
   PhoneticAlphabetType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_PhoneticAlphabetType (OSCTXT* pctxt, PhoneticAlphabetType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      PhoneticAlphabetType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BasicTimePointType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_BasicTimePointType (OSCTXT* pctxt,
   BasicTimePointType pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_utf8str (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_BasicTimePointType (OSCTXT* pctxt, BasicTimePointType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (!rtxMatchPattern (pctxt, value, OSUTF8("\\-?(\\d+(\\-\\d{2}(\\-\\d{2})?)?)?(T\\d{2}(:\\d{2}(:\\d{2}(:\\d+(\\.\\d{2})?)?)?)?)?(F\\d+)?((\\-|\\+)\\d{2}:\\d{2})?"))) {
      return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
         rtxErrAddStrParm (pctxt, "BasicTimePointType"),
         rtxErrAddStrParm (pctxt, (const char*)value));
   }

   stat = rtXmlEncUTF8Str (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaTimePointType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MediaTimePointType (OSCTXT* pctxt,
   MediaTimePointType pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = asn1E_BasicTimePointType (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_MediaTimePointType (OSCTXT* pctxt, MediaTimePointType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = XmlEnc_BasicTimePointType (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BasicDurationType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_BasicDurationType (OSCTXT* pctxt,
   BasicDurationType pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_utf8str (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_BasicDurationType (OSCTXT* pctxt, BasicDurationType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (!rtxMatchPattern (pctxt, value, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?(\\d{2}f)?)?(\\d+F)?((\\-|\\+)\\d{2}:\\d{2}Z)?"))) {
      return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
         rtxErrAddStrParm (pctxt, "BasicDurationType"),
         rtxErrAddStrParm (pctxt, (const char*)value));
   }

   stat = rtXmlEncUTF8Str (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaTimeOffsetType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MediaTimeOffsetType (OSCTXT* pctxt,
   MediaTimeOffsetType pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = asn1E_BasicDurationType (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_MediaTimeOffsetType (OSCTXT* pctxt, MediaTimeOffsetType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = XmlEnc_BasicDurationType (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  XPathType                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_XPathType (OSCTXT* pctxt,
   XPathType pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_utf8str (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_XPathType (OSCTXT* pctxt, XPathType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  XPathRefType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_XPathRefType (OSCTXT* pctxt,
   XPathRefType pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = asn1E_XPathType (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_XPathRefType (OSCTXT* pctxt, XPathRefType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = XmlEnc_XPathType (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaDurationType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MediaDurationType (OSCTXT* pctxt,
   MediaDurationType pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = asn1E_BasicDurationType (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_MediaDurationType (OSCTXT* pctxt, MediaDurationType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = XmlEnc_BasicDurationType (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TimePointType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TimePointType (OSCTXT* pctxt,
   TimePointType pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = asn1E_BasicTimePointType (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_TimePointType (OSCTXT* pctxt, TimePointType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = XmlEnc_BasicTimePointType (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RegionCode                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_RegionCode (OSCTXT* pctxt,
   RegionCode pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_utf8str (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_RegionCode (OSCTXT* pctxt, RegionCode value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (!rtxMatchPattern (pctxt, value, OSUTF8("[a-zA-Z]{2}(-[a-zA-Z0-9]{1,3})?"))) {
      return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
         rtxErrAddStrParm (pctxt, "RegionCode"),
         rtxErrAddStrParm (pctxt, (const char*)value));
   }

   stat = rtXmlEncUTF8Str (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  XPathSelectorType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_XPathSelectorType (OSCTXT* pctxt,
   XPathSelectorType pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = asn1E_XPathType (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_XPathSelectorType (OSCTXT* pctxt, XPathSelectorType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = XmlEnc_XPathType (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  XPathAbsoluteSelectorType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_XPathAbsoluteSelectorType (OSCTXT* pctxt,
   XPathAbsoluteSelectorType pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = asn1E_XPathSelectorType (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_XPathAbsoluteSelectorType (OSCTXT* pctxt, 
   XPathAbsoluteSelectorType value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = XmlEnc_XPathSelectorType (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DurationType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DurationType (OSCTXT* pctxt,
   DurationType pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = asn1E_BasicDurationType (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_DurationType (OSCTXT* pctxt, DurationType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = XmlEnc_BasicDurationType (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PersonNameType_type                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PersonNameType_type (OSCTXT* pctxt,
   PersonNameType_type *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_PersonNameType_type (OSCTXT* pctxt, PersonNameType_type value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      PersonNameType_type_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TermRelationQualifierType_alt                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TermRelationQualifierType_alt (OSCTXT* pctxt,
   TermRelationQualifierType_alt *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 4)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_TermRelationQualifierType_alt (OSCTXT* pctxt, 
   TermRelationQualifierType_alt value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      TermRelationQualifierType_alt_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TitleType_type_alt                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TitleType_type_alt (OSCTXT* pctxt,
   TitleType_type_alt *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 9)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_TitleType_type_alt (OSCTXT* pctxt, TitleType_type_alt value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      TitleType_type_alt_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExtendedLanguageType_type                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ExtendedLanguageType_type (OSCTXT* pctxt,
   ExtendedLanguageType_type *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_ExtendedLanguageType_type (OSCTXT* pctxt, 
   ExtendedLanguageType_type value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      ExtendedLanguageType_type_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InlineMediaType_choice                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_InlineMediaType_choice (OSCTXT* pctxt,
   InlineMediaType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            xe_octstr (pctxt, pvalue->u.mediaData16->data, pvalue->u.mediaData16->numocts, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
            xe_octstr (pctxt, pvalue->u.mediaData64->data, pvalue->u.mediaData64->numocts, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_InlineMediaType_choice (OSCTXT* pctxt, 
   InlineMediaType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode mediaData16 */

         stat = rtXmlEncHexBinary
            (pctxt, pvalue->u.mediaData16->numocts, pvalue->u.mediaData16->
               data, OSUTF8("MediaData16"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode mediaData64 */

         stat = rtXmlEncBase64Binary
            (pctxt, pvalue->u.mediaData64->numocts, pvalue->u.mediaData64->
               data, OSUTF8("MediaData64"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InlineMediaType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_InlineMediaType (OSCTXT* pctxt,
   InlineMediaType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_InlineMediaType_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode type */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_MimeType (pctxt, pvalue->type, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_InlineMediaType (OSCTXT* pctxt, InlineMediaType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" type=\""), 7);

   stat = XmlEnc_MimeType (pctxt, pvalue->type, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode choice */

   stat = XmlEnc_InlineMediaType_choice (pctxt, &pvalue->choice, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaLocatorType_choice                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MediaLocatorType_choice (OSCTXT* pctxt,
   MediaLocatorType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            xe_utf8str (pctxt, pvalue->u.mediaUri, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_InlineMediaType (pctxt, pvalue->u.inlineMedia, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_MediaLocatorType_choice (OSCTXT* pctxt, 
   MediaLocatorType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode mediaUri */

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.mediaUri
            , OSUTF8("MediaUri"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode inlineMedia */

         stat = XmlEnc_InlineMediaType (pctxt, pvalue->u.inlineMedia
            , OSUTF8("InlineMedia"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaLocatorType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MediaLocatorType (OSCTXT* pctxt,
   MediaLocatorType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode streamID */

   if (pvalue->m.streamIDPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_unsigned (pctxt, &pvalue->streamID, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_MediaLocatorType_choice (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_MediaLocatorType (OSCTXT* pctxt, MediaLocatorType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_MediaLocatorType_choice (pctxt, &pvalue->choice
         , OSUTF8(""), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode streamID */

   if (pvalue->m.streamIDPresent) {
      stat = rtXmlEncUInt (pctxt, pvalue->streamID
         , OSUTF8("StreamID"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaRelTimePointType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MediaRelTimePointType (OSCTXT* pctxt,
   MediaRelTimePointType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      xe_utf8str (pctxt, pvalue->base, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode mediaTimeBase */

   if (pvalue->m.mediaTimeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_XPathRefType (pctxt, pvalue->mediaTimeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_MediaRelTimePointType (OSCTXT* pctxt, 
   MediaRelTimePointType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.mediaTimeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "MediaRelTimePointType.mediaTimeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeBase=\""), 16);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->mediaTimeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode base */

   if (!rtxMatchPattern (pctxt, pvalue->base, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?(\\d{2}f)?)?(\\d+F)?((\\-|\\+)\\d{2}:\\d{2}Z)?"))) {
      return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
         rtxErrAddStrParm (pctxt, "MediaRelTimePointType.base"),
         rtxErrAddStrParm (pctxt, (const char*)pvalue->base));
   }

   stat = rtXmlEncUTF8Str (pctxt, pvalue->base, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaRelIncrTimePointType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MediaRelIncrTimePointType (OSCTXT* pctxt,
   MediaRelIncrTimePointType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_integer (pctxt, &pvalue->base, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode mediaTimeUnit */

   if (pvalue->m.mediaTimeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_MediaDurationType (pctxt, pvalue->mediaTimeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeBase */

   if (pvalue->m.mediaTimeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_XPathRefType (pctxt, pvalue->mediaTimeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_MediaRelIncrTimePointType (OSCTXT* pctxt, 
   MediaRelIncrTimePointType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.mediaTimeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "MediaRelIncrTimePointType.mediaTimeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeBase=\""), 16);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->mediaTimeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.mediaTimeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "MediaRelIncrTimePointType.mediaTimeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeUnit=\""), 16);

      stat = XmlEnc_MediaDurationType (pctxt, pvalue->mediaTimeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode base */

   stat = rtXmlEncIntValue (pctxt, pvalue->base);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ImageLocatorType_choice                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ImageLocatorType_choice (OSCTXT* pctxt,
   ImageLocatorType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            xe_utf8str (pctxt, pvalue->u.mediaUri, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_InlineMediaType (pctxt, pvalue->u.inlineMedia, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_ImageLocatorType_choice (OSCTXT* pctxt, 
   ImageLocatorType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode mediaUri */

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.mediaUri
            , OSUTF8("MediaUri"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode inlineMedia */

         stat = XmlEnc_InlineMediaType (pctxt, pvalue->u.inlineMedia
            , OSUTF8("InlineMedia"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ImageLocatorType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ImageLocatorType (OSCTXT* pctxt,
   ImageLocatorType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode streamID */

   if (pvalue->m.streamIDPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_unsigned (pctxt, &pvalue->streamID, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_ImageLocatorType_choice (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ImageLocatorType (OSCTXT* pctxt, ImageLocatorType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_ImageLocatorType_choice (pctxt, &pvalue->choice
         , OSUTF8(""), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode streamID */

   if (pvalue->m.streamIDPresent) {
      stat = rtXmlEncUInt (pctxt, pvalue->streamID
         , OSUTF8("StreamID"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaIncrDurationType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MediaIncrDurationType (OSCTXT* pctxt,
   MediaIncrDurationType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      xe_integer (pctxt, &pvalue->base, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode mediaTimeUnit */

   if (pvalue->m.mediaTimeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_MediaDurationType (pctxt, pvalue->mediaTimeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_MediaIncrDurationType (OSCTXT* pctxt, 
   MediaIncrDurationType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.mediaTimeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "MediaIncrDurationType.mediaTimeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeUnit=\""), 16);

      stat = XmlEnc_MediaDurationType (pctxt, pvalue->mediaTimeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode base */

   stat = rtXmlEncIntValue (pctxt, pvalue->base);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaTimeType_choice                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MediaTimeType_choice (OSCTXT* pctxt,
   MediaTimeType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            asn1E_MediaTimePointType (pctxt, pvalue->u.mediaTimePoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_MediaRelTimePointType (pctxt, pvalue->u.mediaRelTimePoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_MediaRelIncrTimePointType (pctxt, pvalue->u.mediaRelIncrTimePoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_MediaTimeType_choice (OSCTXT* pctxt, MediaTimeType_choice* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode mediaTimePoint */

         stat = XmlEnc_MediaTimePointType (pctxt, pvalue->u.mediaTimePoint
            , OSUTF8("MediaTimePoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode mediaRelTimePoint */

         stat = XmlEnc_MediaRelTimePointType (pctxt, pvalue->
            u.mediaRelTimePoint, OSUTF8("MediaRelTimePoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode mediaRelIncrTimePoint */

         stat = XmlEnc_MediaRelIncrTimePointType (pctxt, pvalue->
            u.mediaRelIncrTimePoint
            , OSUTF8("MediaRelIncrTimePoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaTimeType_choice_1                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MediaTimeType_choice_1 (OSCTXT* pctxt,
   MediaTimeType_choice_1 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            asn1E_MediaDurationType (pctxt, pvalue->u.mediaDuration, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_MediaIncrDurationType (pctxt, pvalue->u.mediaIncrDuration, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_MediaTimeType_choice_1 (OSCTXT* pctxt, 
   MediaTimeType_choice_1* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode mediaDuration */

         stat = XmlEnc_MediaDurationType (pctxt, pvalue->u.mediaDuration
            , OSUTF8("MediaDuration"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode mediaIncrDuration */

         stat = XmlEnc_MediaIncrDurationType (pctxt, pvalue->
            u.mediaIncrDuration, OSUTF8("MediaIncrDuration"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaTimeType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MediaTimeType (OSCTXT* pctxt,
   MediaTimeType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
         asn1E_MediaTimeType_choice_1 (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_MediaTimeType_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_MediaTimeType (OSCTXT* pctxt, MediaTimeType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode choice */

   stat = XmlEnc_MediaTimeType_choice (pctxt, &pvalue->choice, OSUTF8(""), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_MediaTimeType_choice_1 (pctxt, &pvalue->choice_1
         , OSUTF8(""), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TemporalSegmentLocatorType_choice                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TemporalSegmentLocatorType_choice (OSCTXT* pctxt,
   TemporalSegmentLocatorType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            xe_utf8str (pctxt, pvalue->u.mediaUri, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_InlineMediaType (pctxt, pvalue->u.inlineMedia, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_TemporalSegmentLocatorType_choice (OSCTXT* pctxt, 
   TemporalSegmentLocatorType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode mediaUri */

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.mediaUri
            , OSUTF8("MediaUri"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode inlineMedia */

         stat = XmlEnc_InlineMediaType (pctxt, pvalue->u.inlineMedia
            , OSUTF8("InlineMedia"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TemporalSegmentLocatorType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TemporalSegmentLocatorType (OSCTXT* pctxt,
   TemporalSegmentLocatorType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode streamID */

   if (pvalue->m.streamIDPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_unsigned (pctxt, &pvalue->streamID, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_TemporalSegmentLocatorType_choice (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TemporalSegmentLocatorType (OSCTXT* pctxt, 
   TemporalSegmentLocatorType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_TemporalSegmentLocatorType_choice (pctxt, &pvalue->choice
         , OSUTF8(""), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode streamID */

   if (pvalue->m.streamIDPresent) {
      stat = rtXmlEncUInt (pctxt, pvalue->streamID
         , OSUTF8("StreamID"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TitleMediaType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TitleMediaType (OSCTXT* pctxt,
   TitleMediaType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode titleAudio */

   if (pvalue->m.titleAudioPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
         asn1E_TemporalSegmentLocatorType (pctxt, &pvalue->titleAudio, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode titleVideo */

   if (pvalue->m.titleVideoPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
         asn1E_TemporalSegmentLocatorType (pctxt, &pvalue->titleVideo, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode titleImage */

   if (pvalue->m.titleImagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_ImageLocatorType (pctxt, &pvalue->titleImage, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TitleMediaType (OSCTXT* pctxt, TitleMediaType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode titleImage */

   if (pvalue->m.titleImagePresent) {
      stat = XmlEnc_ImageLocatorType (pctxt, &pvalue->titleImage
         , OSUTF8("TitleImage"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode titleVideo */

   if (pvalue->m.titleVideoPresent) {
      stat = XmlEnc_TemporalSegmentLocatorType (pctxt, &pvalue->titleVideo
         , OSUTF8("TitleVideo"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode titleAudio */

   if (pvalue->m.titleAudioPresent) {
      stat = XmlEnc_TemporalSegmentLocatorType (pctxt, &pvalue->titleAudio
         , OSUTF8("TitleAudio"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TermReferenceType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TermReferenceType (OSCTXT* pctxt,
   TermReferenceType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            xe_utf8str (pctxt, pvalue->u.alt, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
            xe_utf8str (pctxt, pvalue->u.alt_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_TermReferenceType (OSCTXT* pctxt, TermReferenceType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode alt */

         if (!rtxMatchPattern (pctxt, pvalue->u.alt, OSUTF8(":[^:]+:[^:]+"))) {
            return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
               rtxErrAddStrParm (pctxt, "TermReferenceType.u.alt"),
               rtxErrAddStrParm (pctxt, (const char*)pvalue->u.alt));
         }

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.alt, 0, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode alt_1 */

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.alt_1, 0, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TextualBaseType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TextualBaseType (OSCTXT* pctxt,
   TextualBaseType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_utf8str (pctxt, pvalue->base, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode phoneticTranscription */

   if (pvalue->m.phoneticTranscriptionPresent) {
      pnode2 = pvalue->phoneticTranscription.tail;
      while (0 != pnode2) {
         ll = xe_utf8str (pctxt, ((const OSUTF8CHAR*)pnode2->data), ASN1EXPL);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll2 += ll;

         pnode2 = pnode2->prev;
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2, ll2);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      else { ll1 += ll; ll2 = 0; }
   }
   /* encode phoneticAlphabet */

   if (pvalue->m.phoneticAlphabetPresent) {
      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_PhoneticAlphabetType (pctxt, &pvalue->phoneticAlphabet, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode lang */

   if (pvalue->m.langPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->lang, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TextualBaseType (OSCTXT* pctxt, TextualBaseType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.langPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" xml:lang=\""), 11);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->lang, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.phoneticAlphabetPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" phoneticAlphabet=\""), 19);

      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_PhoneticAlphabetType (pctxt, pvalue->phoneticAlphabet
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.phoneticTranscriptionPresent) {
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode base */

   stat = rtXmlEncUTF8Str (pctxt, pvalue->base, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NameComponentType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_NameComponentType (OSCTXT* pctxt,
   NameComponentType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
      xe_utf8str (pctxt, pvalue->base, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode phoneticTranscription */

   if (pvalue->m.phoneticTranscriptionPresent) {
      pnode2 = pvalue->phoneticTranscription.tail;
      while (0 != pnode2) {
         ll = xe_utf8str (pctxt, ((const OSUTF8CHAR*)pnode2->data), ASN1EXPL);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll2 += ll;

         pnode2 = pnode2->prev;
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      else { ll1 += ll; ll2 = 0; }
   }
   /* encode phoneticAlphabet */

   if (pvalue->m.phoneticAlphabetPresent) {
      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_PhoneticAlphabetType (pctxt, &pvalue->phoneticAlphabet, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode lang */

   if (pvalue->m.langPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->lang, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode initial */

   if (pvalue->m.initialPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->initial, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode abbrev */

   if (pvalue->m.abbrevPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->abbrev, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_NameComponentType (OSCTXT* pctxt, NameComponentType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.abbrevPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" abbrev=\""), 9);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->abbrev, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.initialPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" initial=\""), 10);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->initial, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.langPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" xml:lang=\""), 11);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->lang, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.phoneticAlphabetPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" phoneticAlphabet=\""), 19);

      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_PhoneticAlphabetType (pctxt, pvalue->phoneticAlphabet
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.phoneticTranscriptionPresent) {
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode base */

   stat = rtXmlEncUTF8Str (pctxt, pvalue->base, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PersonNameType_element                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PersonNameType_element (OSCTXT* pctxt,
   PersonNameType_element *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;
   int xx2;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_NameComponentType (pctxt, pvalue->u.givenName, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         if (!((pvalue->u.familyName_list->count >= 0 && pvalue->u.familyName_list->
            count <= 1))) {
            rtxErrAddStrParm (pctxt, "PersonNameType_element.u.familyName_list.count");
            rtxErrAddIntParm (pctxt, (int)pvalue->u.familyName_list->count);
            return LOG_RTERR (pctxt, RTERR_CONSVIO);
         }

         pnode2 = pvalue->u.familyName_list->tail;
         while (0 != pnode2) {
            ll = asn1E_NameComponentType (pctxt, ((NameComponentType*)pnode2->data), ASN1EXPL);
            if (ll < 0) return LOG_RTERR (pctxt, ll);
            ll2 += ll;

            pnode2 = pnode2->prev;
         }
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1, ll2);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         else { ll1 += ll; ll2 = 0; }
         break;

      case 3:
         if (!((pvalue->u.title_list->count >= 0 && pvalue->u.title_list->count <= 1))) {
            rtxErrAddStrParm (pctxt, "PersonNameType_element.u.title_list.count");
            rtxErrAddIntParm (pctxt, (int)pvalue->u.title_list->count);
            return LOG_RTERR (pctxt, RTERR_CONSVIO);
         }

         pnode2 = pvalue->u.title_list->tail;
         while (0 != pnode2) {
            ll = asn1E_NameComponentType (pctxt, ((NameComponentType*)pnode2->data), ASN1EXPL);
            if (ll < 0) return LOG_RTERR (pctxt, ll);
            ll2 += ll;

            pnode2 = pnode2->prev;
         }
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2, ll2);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         else { ll1 += ll; ll2 = 0; }
         break;

      case 4:
         if (!((pvalue->u.numeration_list->n >= 0 && pvalue->u.numeration_list->n <= 1
            ))) {
            rtxErrAddStrParm (pctxt, "PersonNameType_element.u.numeration_list.n");
            rtxErrAddIntParm (pctxt, (int)pvalue->u.numeration_list->n);
            return LOG_RTERR (pctxt, RTERR_CONSVIO);
         }

         for (xx2 = (pvalue->u.numeration_list->n - 1); xx2 >= 0; xx2--)
         {
            ll = xe_utf8str (pctxt, pvalue->u.numeration_list->elem[xx2], ASN1EXPL);
            if (ll < 0) return LOG_RTERR (pctxt, ll);
            ll2 += ll;
         }
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         else { ll1 += ll; ll2 = 0; }
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_PersonNameType_element (OSCTXT* pctxt, 
   PersonNameType_element* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode givenName */

         stat = XmlEnc_NameComponentType (pctxt, pvalue->u.givenName
            , OSUTF8("GivenName"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode familyName_list */

         if (!((pvalue->u.familyName_list->count >= 0 && pvalue->
            u.familyName_list->count <= 1))) {
            rtxErrAddStrParm (pctxt, "PersonNameType_element.u.familyName_list.count");
            rtxErrAddIntParm (pctxt, (int)pvalue->u.familyName_list->count);
            return LOG_RTERR (pctxt, RTERR_CONSVIO);
         }

         { const OSUTF8CHAR* savedPrefix = nsPrefix;
         nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
            "urn:mpeg:mpeg7:schema:2001"));

         { OSRTDListNode* pnode = pvalue->u.familyName_list->head;
         while (0 != pnode) {
            stat = XmlEnc_NameComponentType (pctxt, 
               ((NameComponentType*)pnode->data)
               , OSUTF8("FamilyName"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
            pnode = pnode->next;
         }}
         nsPrefix = savedPrefix;
         }

         break;

      case 3:
         /* encode title_list */

         if (!((pvalue->u.title_list->count >= 0 && pvalue->u.title_list->count
             <= 1))) {
            rtxErrAddStrParm (pctxt, "PersonNameType_element.u.title_list.count");
            rtxErrAddIntParm (pctxt, (int)pvalue->u.title_list->count);
            return LOG_RTERR (pctxt, RTERR_CONSVIO);
         }

         { const OSUTF8CHAR* savedPrefix = nsPrefix;
         nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
            "urn:mpeg:mpeg7:schema:2001"));

         { OSRTDListNode* pnode = pvalue->u.title_list->head;
         while (0 != pnode) {
            stat = XmlEnc_NameComponentType (pctxt, 
               ((NameComponentType*)pnode->data), OSUTF8("Title"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
            pnode = pnode->next;
         }}
         nsPrefix = savedPrefix;
         }

         break;

      case 4:
         /* encode numeration_list */

         if (!((pvalue->u.numeration_list->n >= 0 && pvalue->u.numeration_list
            ->n <= 1))) {
            rtxErrAddStrParm (pctxt, "PersonNameType_element.u.numeration_list.n");
            rtxErrAddIntParm (pctxt, (int)pvalue->u.numeration_list->n);
            return LOG_RTERR (pctxt, RTERR_CONSVIO);
         }

         { const OSUTF8CHAR* savedPrefix = nsPrefix;
         nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
            "urn:mpeg:mpeg7:schema:2001"));

         { OSUINT32 xx1;
         for (xx1 = 0; xx1 < pvalue->u.numeration_list->n; xx1++) {
            stat = rtXmlEncUTF8Str (pctxt, pvalue->u.numeration_list->elem[xx1]
               , OSUTF8("Numeration"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }}
         nsPrefix = savedPrefix;
         }

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PersonNameType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PersonNameType (OSCTXT* pctxt,
   PersonNameType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode choice_list */

   if (pvalue->m.choice_listPresent) {
      pnode2 = pvalue->choice_list.tail;
      while (0 != pnode2) {
         ll = asn1E_PersonNameType_element (pctxt, ((PersonNameType_element*)pnode2->data), ASN1EXPL);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll2 += ll;

         pnode2 = pnode2->prev;
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      else { ll1 += ll; ll2 = 0; }
   }
   /* encode type */

   if (pvalue->m.typePresent) {
      if(pvalue->type < 0 || pvalue->type > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_PersonNameType_type (pctxt, &pvalue->type, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode lang */

   if (pvalue->m.langPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->lang, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode dateTo */

   if (pvalue->m.dateToPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_TimePointType (pctxt, pvalue->dateTo, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode dateFrom */

   if (pvalue->m.dateFromPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_TimePointType (pctxt, pvalue->dateFrom, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_PersonNameType (OSCTXT* pctxt, PersonNameType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.dateFromPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->dateFrom, OSUTF8("(\\-?\\d+(\\-\\d{2}(\\-\\d{2})?)?)?(T\\d{2}(:\\d{2}(:\\d{2}(:\\d+)?)?)?)?(F\\d+)?((\\-|\\+)\\d{2}:\\d{2})?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "PersonNameType.dateFrom"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->dateFrom));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" dateFrom=\""), 11);

      stat = XmlEnc_TimePointType (pctxt, pvalue->dateFrom, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.dateToPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->dateTo, OSUTF8("(\\-?\\d+(\\-\\d{2}(\\-\\d{2})?)?)?(T\\d{2}(:\\d{2}(:\\d{2}(:\\d+)?)?)?)?(F\\d+)?((\\-|\\+)\\d{2}:\\d{2})?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "PersonNameType.dateTo"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->dateTo));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" dateTo=\""), 9);

      stat = XmlEnc_TimePointType (pctxt, pvalue->dateTo, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.langPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" xml:lang=\""), 11);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->lang, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.typePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" type=\""), 7);

      if(pvalue->type < 0 || pvalue->type > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_PersonNameType_type (pctxt, pvalue->type, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode choice_list */

   if (pvalue->m.choice_listPresent) {
      { const OSUTF8CHAR* savedPrefix = nsPrefix;
      nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
         "urn:mpeg:mpeg7:schema:2001"));

      { OSRTDListNode* pnode = pvalue->choice_list.head;
      while (0 != pnode) {
         stat = XmlEnc_PersonNameType_element (pctxt, 
            ((PersonNameType_element*)pnode->data), 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         pnode = pnode->next;
      }}
      nsPrefix = savedPrefix;
      }

   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TextualType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TextualType (OSCTXT* pctxt,
   TextualType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_utf8str (pctxt, pvalue->base, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode phoneticTranscription */

   if (pvalue->m.phoneticTranscriptionPresent) {
      pnode2 = pvalue->phoneticTranscription.tail;
      while (0 != pnode2) {
         ll = xe_utf8str (pctxt, ((const OSUTF8CHAR*)pnode2->data), ASN1EXPL);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll2 += ll;

         pnode2 = pnode2->prev;
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2, ll2);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      else { ll1 += ll; ll2 = 0; }
   }
   /* encode phoneticAlphabet */

   if (pvalue->m.phoneticAlphabetPresent) {
      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_PhoneticAlphabetType (pctxt, &pvalue->phoneticAlphabet, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode lang */

   if (pvalue->m.langPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->lang, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TextualType (OSCTXT* pctxt, TextualType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.langPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" xml:lang=\""), 11);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->lang, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.phoneticAlphabetPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" phoneticAlphabet=\""), 19);

      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_PhoneticAlphabetType (pctxt, pvalue->phoneticAlphabet
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.phoneticTranscriptionPresent) {
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode base */

   stat = rtXmlEncUTF8Str (pctxt, pvalue->base, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InlineTermDefinitionType_name                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_InlineTermDefinitionType_name (OSCTXT* pctxt,
   InlineTermDefinitionType_name *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_utf8str (pctxt, pvalue->base, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode preferred */

   if (pvalue->m.preferredPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_boolean (pctxt, &pvalue->preferred, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode phoneticTranscription */

   if (pvalue->m.phoneticTranscriptionPresent) {
      pnode2 = pvalue->phoneticTranscription.tail;
      while (0 != pnode2) {
         ll = xe_utf8str (pctxt, ((const OSUTF8CHAR*)pnode2->data), ASN1EXPL);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll2 += ll;

         pnode2 = pnode2->prev;
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2, ll2);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      else { ll1 += ll; ll2 = 0; }
   }
   /* encode phoneticAlphabet */

   if (pvalue->m.phoneticAlphabetPresent) {
      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_PhoneticAlphabetType (pctxt, &pvalue->phoneticAlphabet, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode lang */

   if (pvalue->m.langPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->lang, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_InlineTermDefinitionType_name (OSCTXT* pctxt, 
   InlineTermDefinitionType_name* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.langPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" xml:lang=\""), 11);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->lang, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.phoneticAlphabetPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" phoneticAlphabet=\""), 19);

      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_PhoneticAlphabetType (pctxt, pvalue->phoneticAlphabet
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.phoneticTranscriptionPresent) {
   }

   if (pvalue->m.preferredPresent) {
      stat = rtXmlEncBoolAttr (pctxt, pvalue->preferred
         , OSUTF8("preferred"), 9);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode base */

   stat = rtXmlEncUTF8Str (pctxt, pvalue->base, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InlineTermDefinitionType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_InlineTermDefinitionType (OSCTXT* pctxt,
   InlineTermDefinitionType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode definition_list */

   pnode2 = pvalue->definition_list.tail;
   while (0 != pnode2) {
      ll = asn1E_TextualType (pctxt, ((TextualType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode name_list */

   pnode2 = pvalue->name_list.tail;
   while (0 != pnode2) {
      ll = asn1E_InlineTermDefinitionType_name (pctxt, ((InlineTermDefinitionType_name*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_InlineTermDefinitionType (OSCTXT* pctxt, 
   InlineTermDefinitionType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode name_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   { OSRTDListNode* pnode = pvalue->name_list.head;
   while (0 != pnode) {
      stat = XmlEnc_InlineTermDefinitionType_name (pctxt, 
         ((InlineTermDefinitionType_name*)pnode->data)
         , OSUTF8("Name"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   /* encode definition_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   { OSRTDListNode* pnode = pvalue->definition_list.head;
   while (0 != pnode) {
      stat = XmlEnc_TextualType (pctxt, ((TextualType*)pnode->data)
         , OSUTF8("Definition"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ControlledTermUseType_name                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ControlledTermUseType_name (OSCTXT* pctxt,
   ControlledTermUseType_name *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_utf8str (pctxt, pvalue->base, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode preferred */

   if (pvalue->m.preferredPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_boolean (pctxt, &pvalue->preferred, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode phoneticTranscription */

   if (pvalue->m.phoneticTranscriptionPresent) {
      pnode2 = pvalue->phoneticTranscription.tail;
      while (0 != pnode2) {
         ll = xe_utf8str (pctxt, ((const OSUTF8CHAR*)pnode2->data), ASN1EXPL);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll2 += ll;

         pnode2 = pnode2->prev;
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2, ll2);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      else { ll1 += ll; ll2 = 0; }
   }
   /* encode phoneticAlphabet */

   if (pvalue->m.phoneticAlphabetPresent) {
      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_PhoneticAlphabetType (pctxt, &pvalue->phoneticAlphabet, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode lang */

   if (pvalue->m.langPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->lang, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ControlledTermUseType_name (OSCTXT* pctxt, 
   ControlledTermUseType_name* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.langPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" xml:lang=\""), 11);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->lang, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.phoneticAlphabetPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" phoneticAlphabet=\""), 19);

      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_PhoneticAlphabetType (pctxt, pvalue->phoneticAlphabet
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.phoneticTranscriptionPresent) {
   }

   if (pvalue->m.preferredPresent) {
      stat = rtXmlEncBoolAttr (pctxt, pvalue->preferred
         , OSUTF8("preferred"), 9);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode base */

   stat = rtXmlEncUTF8Str (pctxt, pvalue->base, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ControlledTermUseType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ControlledTermUseType (OSCTXT* pctxt,
   ControlledTermUseType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode definition_list */

   pnode2 = pvalue->definition_list.tail;
   while (0 != pnode2) {
      ll = asn1E_TextualType (pctxt, ((TextualType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode name_list */

   pnode2 = pvalue->name_list.tail;
   while (0 != pnode2) {
      ll = asn1E_ControlledTermUseType_name (pctxt, ((ControlledTermUseType_name*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode href */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_TermReferenceType (pctxt, &pvalue->href, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ControlledTermUseType (OSCTXT* pctxt, 
   ControlledTermUseType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" href=\""), 7);

   stat = XmlEnc_TermReferenceType (pctxt, &pvalue->href, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode name_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   { OSRTDListNode* pnode = pvalue->name_list.head;
   while (0 != pnode) {
      stat = XmlEnc_ControlledTermUseType_name (pctxt, 
         ((ControlledTermUseType_name*)pnode->data)
         , OSUTF8("Name"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   /* encode definition_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   { OSRTDListNode* pnode = pvalue->definition_list.head;
   while (0 != pnode) {
      stat = XmlEnc_TextualType (pctxt, ((TextualType*)pnode->data)
         , OSUTF8("Definition"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ParentalGuidanceType_choice                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ParentalGuidanceType_choice (OSCTXT* pctxt,
   ParentalGuidanceType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_ControlledTermUseType (pctxt, pvalue->u.parentalRating, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
            xe_unsigned (pctxt, &pvalue->u.minimumAge, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_ParentalGuidanceType_choice (OSCTXT* pctxt, 
   ParentalGuidanceType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode parentalRating */

         stat = XmlEnc_ControlledTermUseType (pctxt, pvalue->u.parentalRating
            , OSUTF8("ParentalRating"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode minimumAge */

         stat = rtXmlEncUInt (pctxt, pvalue->u.minimumAge
            , OSUTF8("MinimumAge"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ParentalGuidanceType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ParentalGuidanceType (OSCTXT* pctxt,
   ParentalGuidanceType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode region_list */

   pnode2 = pvalue->region_list.tail;
   while (0 != pnode2) {
      ll = asn1E_RegionCode (pctxt, ((RegionCode)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_ParentalGuidanceType_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ParentalGuidanceType (OSCTXT* pctxt, ParentalGuidanceType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode choice */

   stat = XmlEnc_ParentalGuidanceType_choice (pctxt, &pvalue->choice
      , OSUTF8(""), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode region_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   { OSRTDListNode* pnode = pvalue->region_list.head;
   while (0 != pnode) {
      stat = XmlEnc_RegionCode (pctxt, ((RegionCode)pnode->data)
         , OSUTF8("Region"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ReferenceType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MPEG7_ReferenceType (OSCTXT* pctxt,
   MPEG7_ReferenceType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode xpath */

   if (pvalue->m.xpathPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_XPathRefType (pctxt, pvalue->xpath, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode idref */

   if (pvalue->m.idrefPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->idref, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode href */

   if (pvalue->m.hrefPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->href, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_MPEG7_ReferenceType (OSCTXT* pctxt, MPEG7_ReferenceType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.hrefPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" href=\""), 7);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->href, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idrefPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" idref=\""), 8);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->idref, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.xpathPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->xpath, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "ReferenceType.xpath"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->xpath));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" xpath=\""), 8);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->xpath, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TermRelationQualifierType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TermRelationQualifierType (OSCTXT* pctxt,
   TermRelationQualifierType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         if(pvalue->u.alt < 0 || pvalue->u.alt > 4)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            asn1E_TermRelationQualifierType_alt (pctxt, &pvalue->u.alt, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
            xe_utf8str (pctxt, pvalue->u.alt_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
            xe_utf8str (pctxt, pvalue->u.alt_2, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_TermRelationQualifierType (OSCTXT* pctxt, 
   TermRelationQualifierType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode alt */

         if(pvalue->u.alt < 0 || pvalue->u.alt > 4)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_TermRelationQualifierType_alt (pctxt, pvalue->u.alt
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode alt_1 */

         if (!rtxMatchPattern (pctxt, pvalue->u.alt_1, OSUTF8(":[^:]+:[^:]+"))) {
            return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
               rtxErrAddStrParm (pctxt, "TermRelationQualifierType.u.alt_1"),
               rtxErrAddStrParm (pctxt, (const char*)pvalue->u.alt_1));
         }

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.alt_1, 0, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode alt_2 */

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.alt_2, 0, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TitleType_type                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TitleType_type (OSCTXT* pctxt,
   TitleType_type *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         if(pvalue->u.alt < 0 || pvalue->u.alt > 9)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            asn1E_TitleType_type_alt (pctxt, &pvalue->u.alt, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
            xe_utf8str (pctxt, pvalue->u.alt_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
            xe_utf8str (pctxt, pvalue->u.alt_2, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_TitleType_type (OSCTXT* pctxt, TitleType_type* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode alt */

         if(pvalue->u.alt < 0 || pvalue->u.alt > 9)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_TitleType_type_alt (pctxt, pvalue->u.alt, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode alt_1 */

         if (!rtxMatchPattern (pctxt, pvalue->u.alt_1, OSUTF8(":[^:]+:[^:]+"))) {
            return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
               rtxErrAddStrParm (pctxt, "TitleType_type.u.alt_1"),
               rtxErrAddStrParm (pctxt, (const char*)pvalue->u.alt_1));
         }

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.alt_1, 0, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode alt_2 */

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.alt_2, 0, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TitleType                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TitleType (OSCTXT* pctxt,
   TitleType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_utf8str (pctxt, pvalue->base, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode type */

   if (pvalue->m.typePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_TitleType_type (pctxt, &pvalue->type, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode phoneticTranscription */

   if (pvalue->m.phoneticTranscriptionPresent) {
      pnode2 = pvalue->phoneticTranscription.tail;
      while (0 != pnode2) {
         ll = xe_utf8str (pctxt, ((const OSUTF8CHAR*)pnode2->data), ASN1EXPL);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll2 += ll;

         pnode2 = pnode2->prev;
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2, ll2);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      else { ll1 += ll; ll2 = 0; }
   }
   /* encode phoneticAlphabet */

   if (pvalue->m.phoneticAlphabetPresent) {
      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_PhoneticAlphabetType (pctxt, &pvalue->phoneticAlphabet, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode lang */

   if (pvalue->m.langPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->lang, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TitleType (OSCTXT* pctxt, TitleType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.langPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" xml:lang=\""), 11);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->lang, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.phoneticAlphabetPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" phoneticAlphabet=\""), 19);

      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_PhoneticAlphabetType (pctxt, pvalue->phoneticAlphabet
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.phoneticTranscriptionPresent) {
   }

   if (pvalue->m.typePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" type=\""), 7);

      stat = XmlEnc_TitleType_type (pctxt, &pvalue->type, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode base */

   stat = rtXmlEncUTF8Str (pctxt, pvalue->base, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExtendedLanguageType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ExtendedLanguageType (OSCTXT* pctxt,
   ExtendedLanguageType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_utf8str (pctxt, pvalue->base, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode type */

   if (pvalue->m.typePresent) {
      if(pvalue->type < 0 || pvalue->type > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_ExtendedLanguageType_type (pctxt, &pvalue->type, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode supplemental */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      xe_boolean (pctxt, &pvalue->supplemental, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ExtendedLanguageType (OSCTXT* pctxt, ExtendedLanguageType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   stat = rtXmlEncBoolAttr (pctxt, pvalue->supplemental
      , OSUTF8("supplemental"), 12);

   if (pvalue->m.typePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" type=\""), 7);

      if(pvalue->type < 0 || pvalue->type > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_ExtendedLanguageType_type (pctxt, pvalue->type, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode base */

   stat = rtXmlEncUTF8Str (pctxt, pvalue->base, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HeaderType                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_HeaderType (OSCTXT* pctxt,
   HeaderType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_HeaderType (OSCTXT* pctxt, HeaderType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ClassificationSchemeAliasType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ClassificationSchemeAliasType (OSCTXT* pctxt,
   ClassificationSchemeAliasType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode href */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      xe_utf8str (pctxt, pvalue->href, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode alias */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      xe_utf8str (pctxt, pvalue->alias, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ClassificationSchemeAliasType (OSCTXT* pctxt, 
   ClassificationSchemeAliasType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" alias=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->alias, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" href=\""), 7);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->href, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ClassificationSchemeAliasType_derivations                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ClassificationSchemeAliasType_derivations (OSCTXT* pctxt,
   ClassificationSchemeAliasType_derivations *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_ClassificationSchemeAliasType (pctxt, pvalue->u.classificationSchemeAliasType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_CSAliasType (pctxt, (CSAliasType*)pvalue->u.cSAliasType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_ClassificationSchemeAliasType_derivations (OSCTXT* pctxt, 
   ClassificationSchemeAliasType_derivations* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode classificationSchemeAliasType */

         stat = XmlEnc_ClassificationSchemeAliasType (pctxt, pvalue->
            u.classificationSchemeAliasType, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode cSAliasType */

         stat = XmlEnc_CSAliasType (pctxt, pvalue->u.cSAliasType
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HeaderType_derivations                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_HeaderType_derivations (OSCTXT* pctxt,
   HeaderType_derivations *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_ClassificationSchemeAliasType_derivations (pctxt, pvalue->u.classificationSchemeAliasType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_HeaderType_derivations (OSCTXT* pctxt, 
   HeaderType_derivations* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode classificationSchemeAliasType */

         stat = XmlEnc_ClassificationSchemeAliasType_derivations (pctxt, pvalue
            ->u.classificationSchemeAliasType, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DSType                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DSType (OSCTXT* pctxt,
   DSType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode header_list */

   pnode2 = pvalue->header_list.tail;
   while (0 != pnode2) {
      ll = asn1E_HeaderType_derivations (pctxt, ((HeaderType_derivations*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeUnit */

   if (pvalue->m.timeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_DurationType (pctxt, pvalue->timeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeBase */

   if (pvalue->m.timeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_XPathRefType (pctxt, pvalue->timeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeUnit */

   if (pvalue->m.mediaTimeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_MediaDurationType (pctxt, pvalue->mediaTimeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeBase */

   if (pvalue->m.mediaTimeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_XPathRefType (pctxt, pvalue->mediaTimeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_DSType (OSCTXT* pctxt, DSType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mediaTimeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "DSType.mediaTimeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeBase=\""), 16);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->mediaTimeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.mediaTimeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "DSType.mediaTimeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeUnit=\""), 16);

      stat = XmlEnc_MediaDurationType (pctxt, pvalue->mediaTimeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "DSType.timeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeBase=\""), 11);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->timeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?((\\-|\\+)\\d{2}:\\d{2}Z)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "DSType.timeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeUnit=\""), 11);

      stat = XmlEnc_DurationType (pctxt, pvalue->timeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode header_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   { OSRTDListNode* pnode = pvalue->header_list.head;
   while (0 != pnode) {
      stat = XmlEnc_HeaderType_derivations (pctxt, 
         ((HeaderType_derivations*)pnode->data), OSUTF8("Header"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ClassificationSchemeBaseType                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ClassificationSchemeBaseType (OSCTXT* pctxt,
   ClassificationSchemeBaseType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode import_list */

   pnode2 = pvalue->import_list.tail;
   while (0 != pnode2) {
      ll = asn1E_MPEG7_ReferenceType (pctxt, ((MPEG7_ReferenceType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode uri */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
      xe_utf8str (pctxt, pvalue->uri, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeUnit */

   if (pvalue->m.timeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_DurationType (pctxt, pvalue->timeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeBase */

   if (pvalue->m.timeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_XPathRefType (pctxt, pvalue->timeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeUnit */

   if (pvalue->m.mediaTimeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_MediaDurationType (pctxt, pvalue->mediaTimeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeBase */

   if (pvalue->m.mediaTimeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_XPathRefType (pctxt, pvalue->mediaTimeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode domain */

   if (pvalue->m.domainPresent) {
      pnode2 = pvalue->domain.tail;
      while (0 != pnode2) {
         ll = xe_utf8str (pctxt, ((const OSUTF8CHAR*)pnode2->data), ASN1EXPL);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll2 += ll;

         pnode2 = pnode2->prev;
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      else { ll1 += ll; ll2 = 0; }
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ClassificationSchemeBaseType (OSCTXT* pctxt, 
   ClassificationSchemeBaseType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.domainPresent) {
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mediaTimeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "ClassificationSchemeBaseType.mediaTimeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeBase=\""), 16);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->mediaTimeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.mediaTimeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "ClassificationSchemeBaseType.mediaTimeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeUnit=\""), 16);

      stat = XmlEnc_MediaDurationType (pctxt, pvalue->mediaTimeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "ClassificationSchemeBaseType.timeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeBase=\""), 11);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->timeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?((\\-|\\+)\\d{2}:\\d{2}Z)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "ClassificationSchemeBaseType.timeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeUnit=\""), 11);

      stat = XmlEnc_DurationType (pctxt, pvalue->timeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" uri=\""), 6);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->uri, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode import_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   { OSRTDListNode* pnode = pvalue->import_list.head;
   while (0 != pnode) {
      stat = XmlEnc_MPEG7_ReferenceType (pctxt, 
         ((MPEG7_ReferenceType*)pnode->data), OSUTF8("Import"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TermDefinitionBaseType_name                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TermDefinitionBaseType_name (OSCTXT* pctxt,
   TermDefinitionBaseType_name *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_utf8str (pctxt, pvalue->base, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode preferred */

   if (pvalue->m.preferredPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_boolean (pctxt, &pvalue->preferred, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode phoneticTranscription */

   if (pvalue->m.phoneticTranscriptionPresent) {
      pnode2 = pvalue->phoneticTranscription.tail;
      while (0 != pnode2) {
         ll = xe_utf8str (pctxt, ((const OSUTF8CHAR*)pnode2->data), ASN1EXPL);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll2 += ll;

         pnode2 = pnode2->prev;
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2, ll2);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      else { ll1 += ll; ll2 = 0; }
   }
   /* encode phoneticAlphabet */

   if (pvalue->m.phoneticAlphabetPresent) {
      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_PhoneticAlphabetType (pctxt, &pvalue->phoneticAlphabet, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode lang */

   if (pvalue->m.langPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->lang, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TermDefinitionBaseType_name (OSCTXT* pctxt, 
   TermDefinitionBaseType_name* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.langPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" xml:lang=\""), 11);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->lang, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.phoneticAlphabetPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" phoneticAlphabet=\""), 19);

      if(pvalue->phoneticAlphabet < 0 || pvalue->phoneticAlphabet > 3)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_PhoneticAlphabetType (pctxt, pvalue->phoneticAlphabet
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.phoneticTranscriptionPresent) {
   }

   if (pvalue->m.preferredPresent) {
      stat = rtXmlEncBoolAttr (pctxt, pvalue->preferred
         , OSUTF8("preferred"), 9);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode base */

   stat = rtXmlEncUTF8Str (pctxt, pvalue->base, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TermDefinitionBaseType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TermDefinitionBaseType (OSCTXT* pctxt,
   TermDefinitionBaseType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode definition_list */

   pnode2 = pvalue->definition_list.tail;
   while (0 != pnode2) {
      ll = asn1E_TextualType (pctxt, ((TextualType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode name_list */

   pnode2 = pvalue->name_list.tail;
   while (0 != pnode2) {
      ll = asn1E_TermDefinitionBaseType_name (pctxt, ((TermDefinitionBaseType_name*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeUnit */

   if (pvalue->m.timeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_DurationType (pctxt, pvalue->timeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeBase */

   if (pvalue->m.timeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_XPathRefType (pctxt, pvalue->timeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode termID */

   if (pvalue->m.termIDPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->termID, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeUnit */

   if (pvalue->m.mediaTimeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_MediaDurationType (pctxt, pvalue->mediaTimeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeBase */

   if (pvalue->m.mediaTimeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_XPathRefType (pctxt, pvalue->mediaTimeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TermDefinitionBaseType (OSCTXT* pctxt, 
   TermDefinitionBaseType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mediaTimeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionBaseType.mediaTimeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeBase=\""), 16);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->mediaTimeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.mediaTimeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionBaseType.mediaTimeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeUnit=\""), 16);

      stat = XmlEnc_MediaDurationType (pctxt, pvalue->mediaTimeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.termIDPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" termID=\""), 9);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->termID, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionBaseType.timeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeBase=\""), 11);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->timeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?((\\-|\\+)\\d{2}:\\d{2}Z)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionBaseType.timeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeUnit=\""), 11);

      stat = XmlEnc_DurationType (pctxt, pvalue->timeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode name_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   { OSRTDListNode* pnode = pvalue->name_list.head;
   while (0 != pnode) {
      stat = XmlEnc_TermDefinitionBaseType_name (pctxt, 
         ((TermDefinitionBaseType_name*)pnode->data)
         , OSUTF8("Name"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   /* encode definition_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   { OSRTDListNode* pnode = pvalue->definition_list.head;
   while (0 != pnode) {
      stat = XmlEnc_TextualType (pctxt, ((TextualType*)pnode->data)
         , OSUTF8("Definition"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TermDefinitionType_term                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TermDefinitionType_term (OSCTXT* pctxt,
   TermDefinitionType_term *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeUnit */

   if (pvalue->m.timeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_DurationType (pctxt, pvalue->timeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeBase */

   if (pvalue->m.timeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_XPathRefType (pctxt, pvalue->timeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode termID */

   if (pvalue->m.termIDPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->termID, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode relation */

   if (pvalue->m.relationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_TermRelationQualifierType (pctxt, &pvalue->relation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeUnit */

   if (pvalue->m.mediaTimeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_MediaDurationType (pctxt, pvalue->mediaTimeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeBase */

   if (pvalue->m.mediaTimeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_XPathRefType (pctxt, pvalue->mediaTimeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TermDefinitionType_term (OSCTXT* pctxt, 
   TermDefinitionType_term* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mediaTimeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionType_term.mediaTimeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeBase=\""), 16);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->mediaTimeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.mediaTimeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionType_term.mediaTimeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeUnit=\""), 16);

      stat = XmlEnc_MediaDurationType (pctxt, pvalue->mediaTimeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.relationPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" relation=\""), 11);

      stat = XmlEnc_TermRelationQualifierType (pctxt, &pvalue->relation
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.termIDPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" termID=\""), 9);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->termID, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionType_term.timeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeBase=\""), 11);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->timeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?((\\-|\\+)\\d{2}:\\d{2}Z)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionType_term.timeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeUnit=\""), 11);

      stat = XmlEnc_DurationType (pctxt, pvalue->timeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TermDefinitionType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TermDefinitionType (OSCTXT* pctxt,
   TermDefinitionType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode term_list */

   pnode2 = pvalue->term_list.tail;
   while (0 != pnode2) {
      ll = asn1E_TermDefinitionType_term (pctxt, ((TermDefinitionType_term*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeUnit */

   if (pvalue->m.timeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_DurationType (pctxt, pvalue->timeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeBase */

   if (pvalue->m.timeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_XPathRefType (pctxt, pvalue->timeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode termID */

   if (pvalue->m.termIDPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->termID, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeUnit */

   if (pvalue->m.mediaTimeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_MediaDurationType (pctxt, pvalue->mediaTimeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeBase */

   if (pvalue->m.mediaTimeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_XPathRefType (pctxt, pvalue->mediaTimeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TermDefinitionType (OSCTXT* pctxt, TermDefinitionType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mediaTimeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionType.mediaTimeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeBase=\""), 16);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->mediaTimeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.mediaTimeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionType.mediaTimeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeUnit=\""), 16);

      stat = XmlEnc_MediaDurationType (pctxt, pvalue->mediaTimeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.termIDPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" termID=\""), 9);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->termID, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionType.timeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeBase=\""), 11);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->timeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?((\\-|\\+)\\d{2}:\\d{2}Z)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionType.timeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeUnit=\""), 11);

      stat = XmlEnc_DurationType (pctxt, pvalue->timeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode term_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   { OSRTDListNode* pnode = pvalue->term_list.head;
   while (0 != pnode) {
      stat = XmlEnc_TermDefinitionType_term (pctxt, 
         ((TermDefinitionType_term*)pnode->data), OSUTF8("Term"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TermDefinitionType_derivations_termDefinitionType_2_Term  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TermDefinitionType_derivations_termDefinitionType_2_Term (OSCTXT* pctxt,
   TermDefinitionType_derivations_termDefinitionType_2_Term *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeUnit */

   if (pvalue->m.timeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_DurationType (pctxt, pvalue->timeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeBase */

   if (pvalue->m.timeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_XPathRefType (pctxt, pvalue->timeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode termID */

   if (pvalue->m.termIDPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->termID, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode relation */

   if (pvalue->m.relationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_TermRelationQualifierType (pctxt, &pvalue->relation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeUnit */

   if (pvalue->m.mediaTimeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_MediaDurationType (pctxt, pvalue->mediaTimeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeBase */

   if (pvalue->m.mediaTimeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_XPathRefType (pctxt, pvalue->mediaTimeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TermDefinitionType_derivations_termDefinitionType_2_Term 
   (OSCTXT* pctxt, 
   TermDefinitionType_derivations_termDefinitionType_2_Term* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mediaTimeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionType_derivations_termDefinitionType_2_Term.mediaTimeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeBase=\""), 16);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->mediaTimeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.mediaTimeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionType_derivations_termDefinitionType_2_Term.mediaTimeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeUnit=\""), 16);

      stat = XmlEnc_MediaDurationType (pctxt, pvalue->mediaTimeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.relationPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" relation=\""), 11);

      stat = XmlEnc_TermRelationQualifierType (pctxt, &pvalue->relation
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.termIDPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" termID=\""), 9);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->termID, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionType_derivations_termDefinitionType_2_Term.timeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeBase=\""), 11);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->timeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?((\\-|\\+)\\d{2}:\\d{2}Z)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "TermDefinitionType_derivations_termDefinitionType_2_Term.timeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeUnit=\""), 11);

      stat = XmlEnc_DurationType (pctxt, pvalue->timeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TermDefinitionType_derivations                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TermDefinitionType_derivations (OSCTXT* pctxt,
   TermDefinitionType_derivations *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_TermDefinitionType (pctxt, pvalue->u.termDefinitionType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_TermDefinitionType_derivations_termDefinitionType_2_Term (pctxt, pvalue->u.termDefinitionType_2_Term, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_TermDefinitionType_derivations (OSCTXT* pctxt, 
   TermDefinitionType_derivations* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode termDefinitionType */

         stat = XmlEnc_TermDefinitionType (pctxt, pvalue->u.termDefinitionType
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode termDefinitionType_2_Term */

         stat = XmlEnc_TermDefinitionType_derivations_termDefinitionType_2_Term (pctxt
            , pvalue->u.termDefinitionType_2_Term, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ClassificationSchemeType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ClassificationSchemeType (OSCTXT* pctxt,
   ClassificationSchemeType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode term_list */

   if (!(pvalue->term_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "ClassificationSchemeType.term_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->term_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->term_list.tail;
   while (0 != pnode2) {
      ll = asn1E_TermDefinitionType_derivations (pctxt, ((TermDefinitionType_derivations*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode uri */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
      xe_utf8str (pctxt, pvalue->uri, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeUnit */

   if (pvalue->m.timeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_DurationType (pctxt, pvalue->timeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeBase */

   if (pvalue->m.timeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_XPathRefType (pctxt, pvalue->timeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeUnit */

   if (pvalue->m.mediaTimeUnitPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_MediaDurationType (pctxt, pvalue->mediaTimeUnit, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mediaTimeBase */

   if (pvalue->m.mediaTimeBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_XPathRefType (pctxt, pvalue->mediaTimeBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode domain */

   if (pvalue->m.domainPresent) {
      pnode2 = pvalue->domain.tail;
      while (0 != pnode2) {
         ll = xe_utf8str (pctxt, ((const OSUTF8CHAR*)pnode2->data), ASN1EXPL);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll2 += ll;

         pnode2 = pnode2->prev;
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      else { ll1 += ll; ll2 = 0; }
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ClassificationSchemeType (OSCTXT* pctxt, 
   ClassificationSchemeType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.domainPresent) {
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mediaTimeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "ClassificationSchemeType.mediaTimeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeBase=\""), 16);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->mediaTimeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.mediaTimeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->mediaTimeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "ClassificationSchemeType.mediaTimeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->mediaTimeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" mediaTimeUnit=\""), 16);

      stat = XmlEnc_MediaDurationType (pctxt, pvalue->mediaTimeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeBasePresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeBase, OSUTF8("/?((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.|(\\.\\.))/)*((((child::)?((\\i\\c*:)?(\\i\\c*)(\\[\\d+\\])?))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "ClassificationSchemeType.timeBase"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeBase));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeBase=\""), 11);

      stat = XmlEnc_XPathRefType (pctxt, pvalue->timeBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeUnitPresent) {
      if (!rtxMatchPattern (pctxt, pvalue->timeUnit, OSUTF8("\\-?P(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?(\\d+N)?)?(\\d+F)?((\\-|\\+)\\d{2}:\\d{2}Z)?"))) {
         return LOG_RTERRNEW2 (pctxt, RTERR_PATMATCH,
            rtxErrAddStrParm (pctxt, "ClassificationSchemeType.timeUnit"),
            rtxErrAddStrParm (pctxt, (const char*)pvalue->timeUnit));
      }

      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeUnit=\""), 11);

      stat = XmlEnc_DurationType (pctxt, pvalue->timeUnit, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" uri=\""), 6);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->uri, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   /* encode term_list */

   if (!(pvalue->term_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "ClassificationSchemeType.term_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->term_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   { OSRTDListNode* pnode = pvalue->term_list.head;
   while (0 != pnode) {
      stat = XmlEnc_TermDefinitionType_derivations (pctxt, 
         ((TermDefinitionType_derivations*)pnode->data)
         , OSUTF8("Term"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaLocatorType_derivations                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MediaLocatorType_derivations (OSCTXT* pctxt,
   MediaLocatorType_derivations *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_MediaLocatorType (pctxt, pvalue->u.mediaLocatorType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_ImageLocatorType (pctxt, pvalue->u.imageLocatorType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_TemporalSegmentLocatorType (pctxt, pvalue->u.temporalSegmentLocatorType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_MediaLocatorType_derivations (OSCTXT* pctxt, 
   MediaLocatorType_derivations* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode mediaLocatorType */

         stat = XmlEnc_MediaLocatorType (pctxt, pvalue->u.mediaLocatorType
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode imageLocatorType */

         stat = XmlEnc_ImageLocatorType (pctxt, pvalue->u.imageLocatorType
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode temporalSegmentLocatorType */

         stat = XmlEnc_TemporalSegmentLocatorType (pctxt, pvalue->
            u.temporalSegmentLocatorType, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InlineTermDefinitionType_derivations                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_InlineTermDefinitionType_derivations (OSCTXT* pctxt,
   InlineTermDefinitionType_derivations *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_ControlledTermUseType (pctxt, pvalue->u.controlledTermUseType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_InlineTermDefinitionType_derivations (OSCTXT* pctxt, 
   InlineTermDefinitionType_derivations* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode controlledTermUseType */

         stat = XmlEnc_ControlledTermUseType (pctxt, pvalue->
            u.controlledTermUseType, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ClassificationSchemeType_derivations                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ClassificationSchemeType_derivations (OSCTXT* pctxt,
   ClassificationSchemeType_derivations *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_Urn_tva_metadata_2005_ClassificationSchemeType (pctxt, (Urn_tva_metadata_2005_ClassificationSchemeType*)pvalue->u.classificationSchemeType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_Urn_tva_metadata_2005_ClassificationSchemeType (pctxt, (Urn_tva_metadata_2005_ClassificationSchemeType*)pvalue->u.classificationSchemeType_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_ClassificationSchemeType_derivations (OSCTXT* pctxt, 
   ClassificationSchemeType_derivations* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode classificationSchemeType */

         stat = XmlEnc_Urn_tva_metadata_2005_ClassificationSchemeType (pctxt, 
            pvalue->u.classificationSchemeType, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode classificationSchemeType_1 */

         stat = XmlEnc_Urn_tva_metadata_2005_ClassificationSchemeType (pctxt, 
            pvalue->u.classificationSchemeType_1, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ClassificationSchemeBaseType_derivations                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ClassificationSchemeBaseType_derivations (OSCTXT* pctxt,
   ClassificationSchemeBaseType_derivations *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_ClassificationSchemeType_derivations (pctxt, pvalue->u.classificationSchemeType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_ClassificationSchemeBaseType_derivations (OSCTXT* pctxt, 
   ClassificationSchemeBaseType_derivations* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode classificationSchemeType */

         stat = XmlEnc_ClassificationSchemeType_derivations (pctxt, pvalue->
            u.classificationSchemeType, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TermDefinitionBaseType_derivations                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TermDefinitionBaseType_derivations (OSCTXT* pctxt,
   TermDefinitionBaseType_derivations *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_TermDefinitionType_derivations (pctxt, pvalue->u.termDefinitionType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_TermDefinitionBaseType_derivations (OSCTXT* pctxt, 
   TermDefinitionBaseType_derivations* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode termDefinitionType */

         stat = XmlEnc_TermDefinitionType_derivations (pctxt, pvalue->
            u.termDefinitionType, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DSType_derivations                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DSType_derivations (OSCTXT* pctxt,
   DSType_derivations *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_ClassificationSchemeBaseType_derivations (pctxt, pvalue->u.classificationSchemeBaseType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_TermDefinitionBaseType_derivations (pctxt, pvalue->u.termDefinitionBaseType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_DSType_derivations (OSCTXT* pctxt, DSType_derivations* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode classificationSchemeBaseType */

         stat = XmlEnc_ClassificationSchemeBaseType_derivations (pctxt, pvalue
            ->u.classificationSchemeBaseType, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode termDefinitionBaseType */

         stat = XmlEnc_TermDefinitionBaseType_derivations (pctxt, pvalue->
            u.termDefinitionBaseType, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Mpeg7BaseType_derivations                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Mpeg7BaseType_derivations (OSCTXT* pctxt,
   Mpeg7BaseType_derivations *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_DSType_derivations (pctxt, pvalue->u.dSType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_HeaderType_derivations (pctxt, pvalue->u.headerType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_Mpeg7BaseType_derivations (OSCTXT* pctxt, 
   Mpeg7BaseType_derivations* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   switch (pvalue->t)
   {
      case 1:
         /* encode dSType */

         stat = XmlEnc_DSType_derivations (pctxt, pvalue->u.dSType
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode headerType */

         stat = XmlEnc_HeaderType_derivations (pctxt, pvalue->u.headerType
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   return (stat);
}

int XmlEnc_PhoneType_PDU (OSCTXT* pctxt, PhoneType value)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("mpeg7"), 
      OSUTF8("urn:mpeg:mpeg7:schema:2001"), FALSE);

   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("phoneType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_PhoneType (pctxt, value, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("phoneType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_MediaTimeOffsetType_PDU (OSCTXT* pctxt, MediaTimeOffsetType value)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("mpeg7"), 
      OSUTF8("urn:mpeg:mpeg7:schema:2001"), FALSE);

   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("mediaTimeOffsetType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_MediaTimeOffsetType (pctxt, value, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("mediaTimeOffsetType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_XPathAbsoluteSelectorType_PDU (OSCTXT* pctxt, XPathAbsoluteSelectorType value)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("mpeg7"), 
      OSUTF8("urn:mpeg:mpeg7:schema:2001"), FALSE);

   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("xPathAbsoluteSelectorType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_XPathAbsoluteSelectorType (pctxt, value, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("xPathAbsoluteSelectorType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_MediaTimeType_PDU (OSCTXT* pctxt, MediaTimeType* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("mpeg7"), 
      OSUTF8("urn:mpeg:mpeg7:schema:2001"), FALSE);

   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("mediaTimeType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_MediaTimeType (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("mediaTimeType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_InlineTermDefinitionType_PDU (OSCTXT* pctxt, InlineTermDefinitionType* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("mpeg7"), 
      OSUTF8("urn:mpeg:mpeg7:schema:2001"), FALSE);

   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("inlineTermDefinitionType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_InlineTermDefinitionType (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("inlineTermDefinitionType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_HeaderType_PDU (OSCTXT* pctxt, HeaderType* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("mpeg7"), 
      OSUTF8("urn:mpeg:mpeg7:schema:2001"), FALSE);

   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("headerType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_HeaderType (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("headerType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_DSType_PDU (OSCTXT* pctxt, DSType* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("mpeg7"), 
      OSUTF8("urn:mpeg:mpeg7:schema:2001"), FALSE);

   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("dSType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_DSType (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("dSType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_ClassificationSchemeBaseType_PDU (OSCTXT* pctxt, ClassificationSchemeBaseType* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("mpeg7"), 
      OSUTF8("urn:mpeg:mpeg7:schema:2001"), FALSE);

   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("classificationSchemeBaseType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_ClassificationSchemeBaseType (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("classificationSchemeBaseType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_TermDefinitionBaseType_PDU (OSCTXT* pctxt, TermDefinitionBaseType* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("mpeg7"), 
      OSUTF8("urn:mpeg:mpeg7:schema:2001"), FALSE);

   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8("urn:mpeg:mpeg7:schema:2001"));

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("termDefinitionBaseType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_TermDefinitionBaseType (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("termDefinitionBaseType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
