/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "Urn-dvb-ipdc-esg-2005.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  ESGIDRefType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ESGIDRefType (OSCTXT* pctxt, CBMS_ESGIDRefType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode iDRef */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->iDRef, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.iDRefPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ESGIDRefType (OSCTXT* pctxt, CBMS_ESGIDRefType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("IDRef"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* IDRef */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->iDRef);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.iDRefPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_ESGIDRefType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_ESGIDRefType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AcquisitionRefType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_AcquisitionRefType (OSCTXT* pctxt, 
   CBMS_AcquisitionRefType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode iDRef */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->iDRef, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.iDRefPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode label_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TextualType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->label_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TextualType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TextualType (pdata2);

                  stat = asn1D_TextualType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->label_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_AcquisitionRefType (OSCTXT* pctxt, 
   CBMS_AcquisitionRefType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("IDRef"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* IDRef */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->iDRef);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.iDRefPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_AcquisitionRefType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_AcquisitionRefType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Label"), 5}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         TextualType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TextualType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TextualType (pdata1);

            stat = XmlDec_TextualType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->label_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ServiceRefType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ServiceRefType (OSCTXT* pctxt, 
   CBMS_ServiceRefType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode iDRef */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->iDRef, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.iDRefPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode serviceNumber */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_uint16 (pctxt, &pvalue->serviceNumber, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.serviceNumberPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ServiceRefType (OSCTXT* pctxt, CBMS_ServiceRefType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("IDRef"), 5}, 0 },
         { {OSUTF8("serviceNumber"), 13}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* IDRef */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->iDRef);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.iDRefPresent = TRUE;
            break;

         case 1: /* serviceNumber */
            stat = rtXmlpDecUInt16 (pctxt, &pvalue->serviceNumber);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.serviceNumberPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_ServiceRefType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_ServiceRefType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ESGIDRefType_derivations                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ESGIDRefType_derivations (OSCTXT* pctxt, 
   CBMS_ESGIDRefType_derivations *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.eSGIDRefType = rtxMemAllocType (pctxt, CBMS_ESGIDRefType);

         if (pvalue->u.eSGIDRefType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_ESGIDRefType (pvalue->u.eSGIDRefType);
         stat = asn1D_CBMS_ESGIDRefType (pctxt, 
            pvalue->u.eSGIDRefType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.acquisitionRefType
             = rtxMemAllocType (pctxt, CBMS_AcquisitionRefType);

         if (pvalue->u.acquisitionRefType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_AcquisitionRefType (pvalue->u.acquisitionRefType);
         stat = asn1D_CBMS_AcquisitionRefType (pctxt, 
            pvalue->u.acquisitionRefType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.serviceRefType
             = rtxMemAllocType (pctxt, CBMS_ServiceRefType);

         if (pvalue->u.serviceRefType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_ServiceRefType (pvalue->u.serviceRefType);
         stat = asn1D_CBMS_ServiceRefType (pctxt, 
            pvalue->u.serviceRefType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_CBMS_ESGIDRefType_derivations (OSCTXT* pctxt, 
   CBMS_ESGIDRefType_derivations* pvalue)
{
   const OSUTF8CHAR* xsiType = 0;
   int stat = 0;

   /* decode xsi:type attribute */
   if (rtXmlpHasAttributes (pctxt)) {
      OSUINT32 i, nAttrs = 0;
      OSXMLNameFragments attrName;

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) == 0 &&
             rtXmlpDecXSITypeAttr (pctxt, &attrName, &xsiType) == 0) break;
      }
   }

   /* decode content */
   if (!OS_ISEMPTY (xsiType)) {
      xsiType = rtXmlDecQName (pctxt, xsiType, 0);
   }
   if (OS_ISEMPTY (xsiType)) {
      pvalue->t = 1;
      pvalue->u.eSGIDRefType = rtxMemAllocType (pctxt, CBMS_ESGIDRefType);

      if (pvalue->u.eSGIDRefType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_ESGIDRefType (pvalue->u.eSGIDRefType);

      stat = XmlDec_CBMS_ESGIDRefType (pctxt, pvalue->u.eSGIDRefType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("ESGIDRefType")))
   {
      pvalue->t = 1;
      pvalue->u.eSGIDRefType = rtxMemAllocType (pctxt, CBMS_ESGIDRefType);

      if (pvalue->u.eSGIDRefType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_ESGIDRefType (pvalue->u.eSGIDRefType);

      stat = XmlDec_CBMS_ESGIDRefType (pctxt, pvalue->u.eSGIDRefType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("AcquisitionRefType")))
   {
      pvalue->t = 2;
      pvalue->u.acquisitionRefType
          = rtxMemAllocType (pctxt, CBMS_AcquisitionRefType);

      if (pvalue->u.acquisitionRefType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_AcquisitionRefType (pvalue->u.acquisitionRefType);

      stat = XmlDec_CBMS_AcquisitionRefType (pctxt, pvalue->
         u.acquisitionRefType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("ServiceRefType")))
   {
      pvalue->t = 3;
      pvalue->u.serviceRefType = rtxMemAllocType (pctxt, CBMS_ServiceRefType);

      if (pvalue->u.serviceRefType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_ServiceRefType (pvalue->u.serviceRefType);

      stat = XmlDec_CBMS_ServiceRefType (pctxt, pvalue->u.serviceRefType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RelatedMaterialType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_RelatedMaterialType (OSCTXT* pctxt, 
   CBMS_RelatedMaterialType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode howRelated */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ControlledTermType_derivations (pctxt, 
               &pvalue->howRelated, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.howRelatedPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode mediaLocator */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_MediaLocatorType_derivations (pctxt, 
               &pvalue->mediaLocator, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode promotionalText_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TextualType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->promotionalText_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TextualType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TextualType (pdata2);

                  stat = asn1D_TextualType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->promotionalText_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode promotionalMedia_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TitleMediaType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->promotionalMedia_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TitleMediaType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TitleMediaType (pdata2);

                  stat = asn1D_TitleMediaType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->promotionalMedia_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_RelatedMaterialType (OSCTXT* pctxt, 
   CBMS_RelatedMaterialType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("HowRelated"), 10}, 0}, 0 },
      {{{OSUTF8("MediaLocator"), 12}, 0}, 1 },
      {{{OSUTF8("PromotionalText"), 15}, 0}, 2 },
      {{{OSUTF8("PromotionalMedia"), 16}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* HowRelated */
         stat = XmlDec_ControlledTermType_derivations (pctxt, &pvalue->
            howRelated);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.howRelatedPresent = TRUE;
         break;
      }
      case 1: { /* MediaLocator */
         stat = XmlDec_MediaLocatorType_derivations (pctxt, &pvalue->
            mediaLocator);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: {
         TextualType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TextualType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TextualType (pdata1);

            stat = XmlDec_TextualType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->promotionalText_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 2);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 3: {
         TitleMediaType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TitleMediaType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TitleMediaType (pdata1);

            stat = XmlDec_TitleMediaType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->promotionalMedia_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PrivateDataType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_PrivateDataType (OSCTXT* pctxt, 
   CBMS_PrivateDataType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   if (tagging == ASN1EXPL && length == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_PrivateDataType (OSCTXT* pctxt, CBMS_PrivateDataType* pvalue)
{
   int stat = 0;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ContentType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ContentType (OSCTXT* pctxt, CBMS_ContentType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode contentID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->contentID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode title_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TitleType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->title_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TitleType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TitleType (pdata2);

                  stat = asn1D_TitleType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->title_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode mediaTitle_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TitleMediaType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->mediaTitle_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TitleMediaType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TitleMediaType (pdata2);

                  stat = asn1D_TitleMediaType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->mediaTitle_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode serviceRef_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_ESGIDRefType_derivations* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->serviceRef_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_ESGIDRefType_derivations, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_ESGIDRefType_derivations (pdata2);

                  stat = asn1D_CBMS_ESGIDRefType_derivations (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->serviceRef_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode synopsis_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               SynopsisType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->synopsis_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, SynopsisType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_SynopsisType (pdata2);

                  stat = asn1D_SynopsisType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->synopsis_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode keyword_list */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               KeywordType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->keyword_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, KeywordType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_KeywordType (pdata2);

                  stat = asn1D_KeywordType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->keyword_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode genre_list */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               GenreType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->genre_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, GenreType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_GenreType (pdata2);

                  stat = asn1D_GenreType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->genre_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode contentType_list */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ControlledTermType_derivations* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->contentType_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ControlledTermType_derivations, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ControlledTermType_derivations (pdata2);

                  stat = asn1D_ControlledTermType_derivations (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->contentType_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode parentalGuidance_list */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ParentalGuidanceType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->parentalGuidance_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ParentalGuidanceType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ParentalGuidanceType (pdata2);

                  stat = asn1D_ParentalGuidanceType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->parentalGuidance_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 9:
         /* decode language_list */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ExtendedLanguageType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->language_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ExtendedLanguageType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ExtendedLanguageType (pdata2);

                  stat = asn1D_ExtendedLanguageType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->language_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 10:
         /* decode captionLanguage_list */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CaptionLanguageType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->captionLanguage_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CaptionLanguageType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CaptionLanguageType (pdata2);

                  stat = asn1D_CaptionLanguageType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->captionLanguage_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 11:
         /* decode signLanguage_list */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               SignLanguageType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->signLanguage_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, SignLanguageType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_SignLanguageType (pdata2);

                  stat = asn1D_SignLanguageType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->signLanguage_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 12:
         /* decode creditsList */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CreditsListType (pctxt, 
               &pvalue->creditsList, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.creditsListPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 13:
         /* decode relatedMaterial_list */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_RelatedMaterialType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->relatedMaterial_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_RelatedMaterialType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_RelatedMaterialType (pdata2);

                  stat = asn1D_CBMS_RelatedMaterialType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->relatedMaterial_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 14:
         /* decode duration */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->duration, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.durationPresent = TRUE;
            }
         }
         break;

      case 15:
         /* decode privateData_list */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_PrivateDataType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->privateData_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_PrivateDataType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_PrivateDataType (pdata2);

                  stat = asn1D_CBMS_PrivateDataType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->privateData_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_PRIM|14):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_CONS|15):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 14) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ContentType (OSCTXT* pctxt, CBMS_ContentType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("contentID"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* contentID */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->contentID);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_ContentType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_ContentType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Title"), 5}, 0}, 0 },
      {{{OSUTF8("MediaTitle"), 10}, 0}, 1 },
      {{{OSUTF8("ServiceRef"), 10}, 0}, 2 },
      {{{OSUTF8("Synopsis"), 8}, 0}, 3 },
      {{{OSUTF8("Keyword"), 7}, 0}, 4 },
      {{{OSUTF8("Genre"), 5}, 0}, 5 },
      {{{OSUTF8("ContentType"), 11}, 0}, 6 },
      {{{OSUTF8("ParentalGuidance"), 16}, 0}, 7 },
      {{{OSUTF8("Language"), 8}, 0}, 8 },
      {{{OSUTF8("CaptionLanguage"), 15}, 0}, 9 },
      {{{OSUTF8("SignLanguage"), 12}, 0}, 10 },
      {{{OSUTF8("CreditsList"), 11}, 0}, 11 },
      {{{OSUTF8("RelatedMaterial"), 15}, 0}, 12 },
      {{{OSUTF8("Duration"), 8}, 0}, 13 },
      {{{OSUTF8("PrivateData"), 11}, 0}, 14 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 15, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 15; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         TitleType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TitleType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TitleType (pdata1);

            stat = XmlDec_TitleType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->title_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: {
         TitleMediaType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TitleMediaType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TitleMediaType (pdata1);

            stat = XmlDec_TitleMediaType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->mediaTitle_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 2: {
         CBMS_ESGIDRefType_derivations* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_ESGIDRefType_derivations);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_ESGIDRefType_derivations (pdata1);

            stat = XmlDec_CBMS_ESGIDRefType_derivations (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->serviceRef_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 2);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 3: {
         SynopsisType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, SynopsisType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_SynopsisType (pdata1);

            stat = XmlDec_SynopsisType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->synopsis_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 4: {
         KeywordType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, KeywordType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_KeywordType (pdata1);

            stat = XmlDec_KeywordType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->keyword_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 4, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 4);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 5: {
         GenreType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, GenreType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_GenreType (pdata1);

            stat = XmlDec_GenreType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->genre_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 5, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 5);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 6: {
         ControlledTermType_derivations* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ControlledTermType_derivations);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ControlledTermType_derivations (pdata1);

            stat = XmlDec_ControlledTermType_derivations (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->contentType_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 6, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 6);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 7: {
         ParentalGuidanceType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ParentalGuidanceType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ParentalGuidanceType (pdata1);

            stat = XmlDec_ParentalGuidanceType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->parentalGuidance_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 7, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 7);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 8: {
         ExtendedLanguageType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ExtendedLanguageType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ExtendedLanguageType (pdata1);

            stat = XmlDec_ExtendedLanguageType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->language_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 8, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 8);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 9: {
         CaptionLanguageType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CaptionLanguageType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CaptionLanguageType (pdata1);

            stat = XmlDec_CaptionLanguageType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->captionLanguage_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 9, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 9);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 10: {
         SignLanguageType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, SignLanguageType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_SignLanguageType (pdata1);

            stat = XmlDec_SignLanguageType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->signLanguage_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 10, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 10);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 11: { /* CreditsList */
         stat = XmlDec_CreditsListType (pctxt, &pvalue->creditsList);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.creditsListPresent = TRUE;
         break;
      }
      case 12: {
         CBMS_RelatedMaterialType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_RelatedMaterialType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_RelatedMaterialType (pdata1);

            stat = XmlDec_CBMS_RelatedMaterialType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->relatedMaterial_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 12, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 12);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 13: { /* Duration */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->duration);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.durationPresent = TRUE;
         break;
      }
      case 14: {
         CBMS_PrivateDataType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_PrivateDataType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_PrivateDataType (pdata1);

            stat = XmlDec_CBMS_PrivateDataType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->privateData_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 14, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 14);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ContentTableType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ContentTableType (OSCTXT* pctxt, 
   CBMS_ContentTableType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   CBMS_ContentType* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, CBMS_ContentType, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_ContentType (pdata1);

      stat = asn1D_CBMS_ContentType (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   return (stat);
}

int XmlDec_CBMS_ContentTableType (OSCTXT* pctxt, CBMS_ContentTableType* pvalue)
{
   int stat = 0;

   { int elemID;
   CBMS_ContentType* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Content"), 7}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* Content */
         pdata1 = rtxMemAllocType (pctxt, CBMS_ContentType);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_ContentType (pdata1);

         stat = XmlDec_CBMS_ContentType (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ScheduleEventType_element_element                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ScheduleEventType_element_element (OSCTXT* pctxt, 
   CBMS_ScheduleEventType_element_element *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode acquisitionRef */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_AcquisitionRefType (pctxt, 
               &pvalue->acquisitionRef, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.acquisitionRefPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode contentLocation */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->contentLocation, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.contentLocationPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ScheduleEventType_element_element (OSCTXT* pctxt, 
   CBMS_ScheduleEventType_element_element* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("AcquisitionRef"), 14}, 0}, 0 },
      {{{OSUTF8("ContentLocation"), 15}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* AcquisitionRef */
         stat = XmlDec_CBMS_AcquisitionRefType (pctxt, &pvalue->acquisitionRef
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.acquisitionRefPresent = TRUE;
         break;
      }
      case 1: { /* ContentLocation */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->contentLocation);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.contentLocationPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ScheduleEventType_element                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ScheduleEventType_element (OSCTXT* pctxt, 
   CBMS_ScheduleEventType_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode contentFragmentRef */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_ESGIDRefType_derivations (pctxt, 
               &pvalue->contentFragmentRef, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.contentFragmentRefPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode sequence_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_ScheduleEventType_element_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->sequence_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_ScheduleEventType_element_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_ScheduleEventType_element_element (pdata2);

                  stat = asn1D_CBMS_ScheduleEventType_element_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->sequence_list, pnode);
               }

            }
            if (stat == 0) {
               pvalue->m.sequence_listPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ScheduleEventType_element (OSCTXT* pctxt, 
   CBMS_ScheduleEventType_element* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("ContentFragmentRef"), 18}, 0}, 0 },
      {{{OSUTF8("AcquisitionRef"), 14}, 0}, 1 },
      {{{OSUTF8("ContentLocation"), 15}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* ContentFragmentRef */
         stat = XmlDec_CBMS_ESGIDRefType_derivations (pctxt, &pvalue->
            contentFragmentRef);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.contentFragmentRefPresent = TRUE;
         break;
      }
      case 1: {
         CBMS_ScheduleEventType_element_element* pdata1;
         do {
            pdata1
                = rtxMemAllocType (pctxt, CBMS_ScheduleEventType_element_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_ScheduleEventType_element_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_CBMS_ScheduleEventType_element_element (pctxt, pdata1
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->sequence_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 2, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;

         pvalue->m.sequence_listPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ScheduleEventType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ScheduleEventType (OSCTXT* pctxt, 
   CBMS_ScheduleEventType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode clearToAir */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->clearToAir, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.clearToAirPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode freeToAir */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->freeToAir, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.freeToAirPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode live */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->live, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.livePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode repeat */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->repeat, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.repeatPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode scheduleId */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->scheduleId, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.scheduleIdPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode publishedStartTime */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_charstr (pctxt, &pvalue->publishedStartTime, ASN1IMPL, 
               (TM_UNIV|TM_PRIM|26), length);
            if (stat == 0) {
               pvalue->m.publishedStartTimePresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode publishedEndTime */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_charstr (pctxt, &pvalue->publishedEndTime, ASN1IMPL, 
               (TM_UNIV|TM_PRIM|26), length);
            if (stat == 0) {
               pvalue->m.publishedEndTimePresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode serviceRef */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_ESGIDRefType_derivations (pctxt, 
               &pvalue->serviceRef, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode sequence_list */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_ScheduleEventType_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->sequence_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_ScheduleEventType_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_ScheduleEventType_element (pdata2);

                  stat = asn1D_CBMS_ScheduleEventType_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->sequence_list, pnode);
               }

            }
            if (stat == 0) {
               pvalue->m.sequence_listPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ScheduleEventType (OSCTXT* pctxt, 
   CBMS_ScheduleEventType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("clearToAir"), 10}, 0 },
         { {OSUTF8("freeToAir"), 9}, 0 },
         { {OSUTF8("live"), 4}, 0 },
         { {OSUTF8("repeat"), 6}, 0 },
         { {OSUTF8("scheduleId"), 10}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* clearToAir */
            stat = rtXmlpDecBool (pctxt, &pvalue->clearToAir);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.clearToAirPresent = TRUE;
            break;

         case 1: /* freeToAir */
            stat = rtXmlpDecBool (pctxt, &pvalue->freeToAir);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.freeToAirPresent = TRUE;
            break;

         case 2: /* live */
            stat = rtXmlpDecBool (pctxt, &pvalue->live);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.livePresent = TRUE;
            break;

         case 3: /* repeat */
            stat = rtXmlpDecBool (pctxt, &pvalue->repeat);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.repeatPresent = TRUE;
            break;

         case 4: /* scheduleId */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->scheduleId);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.scheduleIdPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_ScheduleEventType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_ScheduleEventType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("PublishedStartTime"), 18}, 0}, 0 },
      {{{OSUTF8("PublishedEndTime"), 16}, 0}, 1 },
      {{{OSUTF8("ServiceRef"), 10}, 0}, 2 },
      {{{OSUTF8("ContentFragmentRef"), 18}, 0}, 3 },
      {{{OSUTF8("AcquisitionRef"), 14}, 0}, 3 },
      {{{OSUTF8("ContentLocation"), 15}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}, {3, 3, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* PublishedStartTime */
         stat = rtXmlpDecDynUTF8Str (pctxt, (const OSUTF8CHAR**)&pvalue->
            publishedStartTime);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.publishedStartTimePresent = TRUE;
         break;
      }
      case 1: { /* PublishedEndTime */
         stat = rtXmlpDecDynUTF8Str (pctxt, (const OSUTF8CHAR**)&pvalue->
            publishedEndTime);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.publishedEndTimePresent = TRUE;
         break;
      }
      case 2: { /* ServiceRef */
         stat = XmlDec_CBMS_ESGIDRefType_derivations (pctxt, &pvalue->
            serviceRef);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: {
         CBMS_ScheduleEventType_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_ScheduleEventType_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_ScheduleEventType_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_CBMS_ScheduleEventType_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->sequence_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 3, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;

         pvalue->m.sequence_listPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ScheduleEventTableType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ScheduleEventTableType (OSCTXT* pctxt, 
   CBMS_ScheduleEventTableType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   CBMS_ScheduleEventType* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, CBMS_ScheduleEventType, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_ScheduleEventType (pdata1);

      stat = asn1D_CBMS_ScheduleEventType (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   return (stat);
}

int XmlDec_CBMS_ScheduleEventTableType (OSCTXT* pctxt, 
   CBMS_ScheduleEventTableType* pvalue)
{
   int stat = 0;

   { int elemID;
   CBMS_ScheduleEventType* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("ScheduleEvent"), 13}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* ScheduleEvent */
         pdata1 = rtxMemAllocType (pctxt, CBMS_ScheduleEventType);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_ScheduleEventType (pdata1);

         stat = XmlDec_CBMS_ScheduleEventType (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ProviderType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ProviderType (OSCTXT* pctxt, CBMS_ProviderType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode providerURI */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->providerURI, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.providerURIPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode providerName_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TextualType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->providerName_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TextualType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TextualType (pdata2);

                  stat = asn1D_TextualType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->providerName_list, pnode);
               }

               if (!(pvalue->providerName_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "ProviderType.providerName_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->providerName_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode providerLogo */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TitleMediaType (pctxt, 
               &pvalue->providerLogo, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.providerLogoPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode providerInformationURL */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->providerInformationURL, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.providerInformationURLPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ProviderType (OSCTXT* pctxt, CBMS_ProviderType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("ProviderURI"), 11}, 0}, 0 },
      {{{OSUTF8("ProviderName"), 12}, 0}, 1 },
      {{{OSUTF8("ProviderLogo"), 12}, 0}, 2 },
      {{{OSUTF8("ProviderInformationURL"), 22}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* ProviderURI */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->providerURI);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.providerURIPresent = TRUE;
         break;
      }
      case 1: {
         TextualType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TextualType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TextualType (pdata1);

            stat = XmlDec_TextualType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->providerName_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 2: { /* ProviderLogo */
         stat = XmlDec_TitleMediaType (pctxt, &pvalue->providerLogo);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.providerLogoPresent = TRUE;
         break;
      }
      case 3: { /* ProviderInformationURL */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->providerInformationURL);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.providerInformationURLPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ServiceType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ServiceType (OSCTXT* pctxt, CBMS_ServiceType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode clearToAir */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->clearToAir, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.clearToAirPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode freeToAir */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->freeToAir, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.freeToAirPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode serviceID */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->serviceID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode serviceName_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ServiceInformationNameType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->serviceName_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ServiceInformationNameType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ServiceInformationNameType (pdata2);

                  stat = asn1D_ServiceInformationNameType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->serviceName_list, pnode);
               }

               if (!(pvalue->serviceName_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "ServiceType.serviceName_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->serviceName_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode serviceNumber */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_uint16 (pctxt, &pvalue->serviceNumber, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.serviceNumberPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode serviceLogo_list */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TitleMediaType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->serviceLogo_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TitleMediaType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TitleMediaType (pdata2);

                  stat = asn1D_TitleMediaType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->serviceLogo_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode serviceDescription_list */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               SynopsisType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->serviceDescription_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, SynopsisType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_SynopsisType (pdata2);

                  stat = asn1D_SynopsisType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->serviceDescription_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode serviceGenre_list */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               GenreType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->serviceGenre_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, GenreType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_GenreType (pdata2);

                  stat = asn1D_GenreType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->serviceGenre_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode serviceType_list */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ControlledTermType_derivations* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->serviceType_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ControlledTermType_derivations, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ControlledTermType_derivations (pdata2);

                  stat = asn1D_ControlledTermType_derivations (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->serviceType_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 9:
         /* decode parentalGuidance_list */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ParentalGuidanceType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->parentalGuidance_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ParentalGuidanceType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ParentalGuidanceType (pdata2);

                  stat = asn1D_ParentalGuidanceType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->parentalGuidance_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 10:
         /* decode serviceLanguage */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->serviceLanguage, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.serviceLanguagePresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode serviceProvider */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_ProviderType (pctxt, 
               &pvalue->serviceProvider, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.serviceProviderPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 12:
         /* decode acquisitionRef_list */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_AcquisitionRefType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->acquisitionRef_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_AcquisitionRefType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_AcquisitionRefType (pdata2);

                  stat = asn1D_CBMS_AcquisitionRefType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->acquisitionRef_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 13:
         /* decode relatedMaterial_list */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_RelatedMaterialType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->relatedMaterial_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_RelatedMaterialType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_RelatedMaterialType (pdata2);

                  stat = asn1D_CBMS_RelatedMaterialType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->relatedMaterial_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 14:
         /* decode privateData_list */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_PrivateDataType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->privateData_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_PrivateDataType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_PrivateDataType (pdata2);

                  stat = asn1D_CBMS_PrivateDataType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->privateData_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_CONS|14):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 10) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ServiceType (OSCTXT* pctxt, CBMS_ServiceType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("clearToAir"), 10}, 0 },
         { {OSUTF8("freeToAir"), 9}, 0 },
         { {OSUTF8("serviceID"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* clearToAir */
            stat = rtXmlpDecBool (pctxt, &pvalue->clearToAir);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.clearToAirPresent = TRUE;
            break;

         case 1: /* freeToAir */
            stat = rtXmlpDecBool (pctxt, &pvalue->freeToAir);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.freeToAirPresent = TRUE;
            break;

         case 2: /* serviceID */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->serviceID);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_ServiceType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_ServiceType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("ServiceName"), 11}, 0}, 0 },
      {{{OSUTF8("ServiceNumber"), 13}, 0}, 1 },
      {{{OSUTF8("ServiceLogo"), 11}, 0}, 2 },
      {{{OSUTF8("ServiceDescription"), 18}, 0}, 3 },
      {{{OSUTF8("ServiceGenre"), 12}, 0}, 4 },
      {{{OSUTF8("ServiceType"), 11}, 0}, 5 },
      {{{OSUTF8("ParentalGuidance"), 16}, 0}, 6 },
      {{{OSUTF8("ServiceLanguage"), 15}, 0}, 7 },
      {{{OSUTF8("ServiceProvider"), 15}, 0}, 8 },
      {{{OSUTF8("AcquisitionRef"), 14}, 0}, 9 },
      {{{OSUTF8("RelatedMaterial"), 15}, 0}, 10 },
      {{{OSUTF8("PrivateData"), 11}, 0}, 11 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 12, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 12; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         ServiceInformationNameType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ServiceInformationNameType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ServiceInformationNameType (pdata1);

            stat = XmlDec_ServiceInformationNameType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->serviceName_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: { /* ServiceNumber */
         stat = rtXmlpDecUInt16 (pctxt, &pvalue->serviceNumber);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.serviceNumberPresent = TRUE;
         break;
      }
      case 2: {
         TitleMediaType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TitleMediaType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TitleMediaType (pdata1);

            stat = XmlDec_TitleMediaType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->serviceLogo_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 2);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 3: {
         SynopsisType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, SynopsisType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_SynopsisType (pdata1);

            stat = XmlDec_SynopsisType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->serviceDescription_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 4: {
         GenreType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, GenreType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_GenreType (pdata1);

            stat = XmlDec_GenreType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->serviceGenre_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 4, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 4);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 5: {
         ControlledTermType_derivations* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ControlledTermType_derivations);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ControlledTermType_derivations (pdata1);

            stat = XmlDec_ControlledTermType_derivations (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->serviceType_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 5, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 5);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 6: {
         ParentalGuidanceType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ParentalGuidanceType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ParentalGuidanceType (pdata1);

            stat = XmlDec_ParentalGuidanceType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->parentalGuidance_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 6, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 6);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 7: { /* ServiceLanguage */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->serviceLanguage);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.serviceLanguagePresent = TRUE;
         break;
      }
      case 8: { /* ServiceProvider */
         stat = XmlDec_CBMS_ProviderType (pctxt, &pvalue->serviceProvider);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.serviceProviderPresent = TRUE;
         break;
      }
      case 9: {
         CBMS_AcquisitionRefType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_AcquisitionRefType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_AcquisitionRefType (pdata1);

            stat = XmlDec_CBMS_AcquisitionRefType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->acquisitionRef_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 9, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 9);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 10: {
         CBMS_RelatedMaterialType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_RelatedMaterialType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_RelatedMaterialType (pdata1);

            stat = XmlDec_CBMS_RelatedMaterialType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->relatedMaterial_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 10, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 10);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 11: {
         CBMS_PrivateDataType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_PrivateDataType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_PrivateDataType (pdata1);

            stat = XmlDec_CBMS_PrivateDataType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->privateData_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 11, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 11);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ServiceTableType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ServiceTableType (OSCTXT* pctxt, 
   CBMS_ServiceTableType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   CBMS_ServiceType* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, CBMS_ServiceType, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_ServiceType (pdata1);

      stat = asn1D_CBMS_ServiceType (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   return (stat);
}

int XmlDec_CBMS_ServiceTableType (OSCTXT* pctxt, CBMS_ServiceTableType* pvalue)
{
   int stat = 0;

   { int elemID;
   CBMS_ServiceType* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Service"), 7}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* Service */
         pdata1 = rtxMemAllocType (pctxt, CBMS_ServiceType);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_ServiceType (pdata1);

         stat = XmlDec_CBMS_ServiceType (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ServiceBundleType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ServiceBundleType (OSCTXT* pctxt, 
   CBMS_ServiceBundleType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode serviceBundleID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->serviceBundleID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode serviceBundleName_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TextualType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->serviceBundleName_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TextualType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TextualType (pdata2);

                  stat = asn1D_TextualType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->serviceBundleName_list, pnode);
               }

               if (!(pvalue->serviceBundleName_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "ServiceBundleType.serviceBundleName_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->serviceBundleName_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode serviceBundleProvider */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_ProviderType (pctxt, 
               &pvalue->serviceBundleProvider, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.serviceBundleProviderPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode serviceBundleMediaTitle */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TitleMediaType (pctxt, 
               &pvalue->serviceBundleMediaTitle, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.serviceBundleMediaTitlePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode serviceBundleDescription_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TextualType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->serviceBundleDescription_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TextualType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TextualType (pdata2);

                  stat = asn1D_TextualType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->serviceBundleDescription_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode serviceBundleGenre_list */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               GenreType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->serviceBundleGenre_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, GenreType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_GenreType (pdata2);

                  stat = asn1D_GenreType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->serviceBundleGenre_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode serviceRef_list */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_ServiceRefType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->serviceRef_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_ServiceRefType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_ServiceRefType (pdata2);

                  stat = asn1D_CBMS_ServiceRefType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->serviceRef_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode parentalGuidance_list */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ParentalGuidanceType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->parentalGuidance_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ParentalGuidanceType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ParentalGuidanceType (pdata2);

                  stat = asn1D_ParentalGuidanceType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->parentalGuidance_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode relatedMaterial_list */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_RelatedMaterialType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->relatedMaterial_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_RelatedMaterialType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_RelatedMaterialType (pdata2);

                  stat = asn1D_CBMS_RelatedMaterialType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->relatedMaterial_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 7) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ServiceBundleType (OSCTXT* pctxt, 
   CBMS_ServiceBundleType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("serviceBundleID"), 15}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* serviceBundleID */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->serviceBundleID);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_ServiceBundleType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_ServiceBundleType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("ServiceBundleName"), 17}, 0}, 0 },
      {{{OSUTF8("ServiceBundleProvider"), 21}, 0}, 1 },
      {{{OSUTF8("ServiceBundleMediaTitle"), 23}, 0}, 2 },
      {{{OSUTF8("ServiceBundleDescription"), 24}, 0}, 3 },
      {{{OSUTF8("ServiceBundleGenre"), 18}, 0}, 4 },
      {{{OSUTF8("ServiceRef"), 10}, 0}, 5 },
      {{{OSUTF8("ParentalGuidance"), 16}, 0}, 6 },
      {{{OSUTF8("RelatedMaterial"), 15}, 0}, 7 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 8, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 8; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         TextualType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TextualType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TextualType (pdata1);

            stat = XmlDec_TextualType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->serviceBundleName_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: { /* ServiceBundleProvider */
         stat = XmlDec_CBMS_ProviderType (pctxt, &pvalue->serviceBundleProvider
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.serviceBundleProviderPresent = TRUE;
         break;
      }
      case 2: { /* ServiceBundleMediaTitle */
         stat = XmlDec_TitleMediaType (pctxt, &pvalue->serviceBundleMediaTitle
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.serviceBundleMediaTitlePresent = TRUE;
         break;
      }
      case 3: {
         TextualType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TextualType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TextualType (pdata1);

            stat = XmlDec_TextualType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->serviceBundleDescription_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 4: {
         GenreType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, GenreType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_GenreType (pdata1);

            stat = XmlDec_GenreType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->serviceBundleGenre_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 4, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 4);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 5: {
         CBMS_ServiceRefType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_ServiceRefType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_ServiceRefType (pdata1);

            stat = XmlDec_CBMS_ServiceRefType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->serviceRef_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 5, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 5);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 6: {
         ParentalGuidanceType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ParentalGuidanceType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ParentalGuidanceType (pdata1);

            stat = XmlDec_ParentalGuidanceType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->parentalGuidance_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 6, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 6);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 7: {
         CBMS_RelatedMaterialType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_RelatedMaterialType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_RelatedMaterialType (pdata1);

            stat = XmlDec_CBMS_RelatedMaterialType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->relatedMaterial_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 7, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 7);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ServiceBundleTableType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ServiceBundleTableType (OSCTXT* pctxt, 
   CBMS_ServiceBundleTableType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   CBMS_ServiceBundleType* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, CBMS_ServiceBundleType, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_ServiceBundleType (pdata1);

      stat = asn1D_CBMS_ServiceBundleType (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   return (stat);
}

int XmlDec_CBMS_ServiceBundleTableType (OSCTXT* pctxt, 
   CBMS_ServiceBundleTableType* pvalue)
{
   int stat = 0;

   { int elemID;
   CBMS_ServiceBundleType* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("ServiceBundle"), 13}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* ServiceBundle */
         pdata1 = rtxMemAllocType (pctxt, CBMS_ServiceBundleType);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_ServiceBundleType (pdata1);

         stat = XmlDec_CBMS_ServiceBundleType (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CurrencyCodeType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_CurrencyCodeType (OSCTXT* pctxt, 
   CBMS_CurrencyCodeType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_CBMS_CurrencyCodeType (OSCTXT* pctxt, CBMS_CurrencyCodeType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PurchaseType_price                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_PurchaseType_price (OSCTXT* pctxt, 
   CBMS_PurchaseType_price *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode currency */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_CurrencyCodeType (pctxt, 
               &pvalue->currency, ASN1IMPL, length);
            if (stat == 0) {
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode base */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->base, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_PurchaseType_price (OSCTXT* pctxt, 
   CBMS_PurchaseType_price* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("currency"), 8}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* currency */
            stat = XmlDec_CBMS_CurrencyCodeType (pctxt, &pvalue->currency);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_PurchaseType_price");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_PurchaseType_price");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   stat = rtXmlpDecDouble (pctxt, &pvalue->base, -1, -1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsageConstraintsType_quantityRange                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_UsageConstraintsType_quantityRange (OSCTXT* pctxt, 
   CBMS_UsageConstraintsType_quantityRange *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode max */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_unsigned (pctxt, &pvalue->max, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.maxPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode min */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_unsigned (pctxt, &pvalue->min, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.minPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_UsageConstraintsType_quantityRange (OSCTXT* pctxt, 
   CBMS_UsageConstraintsType_quantityRange* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("max"), 3}, 0 },
         { {OSUTF8("min"), 3}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* max */
            stat = rtXmlpDecUInt (pctxt, &pvalue->max);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.maxPresent = TRUE;
            break;

         case 1: /* min */
            stat = rtXmlpDecUInt (pctxt, &pvalue->min);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.minPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_UsageConstraintsType_quantityRange");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_UsageConstraintsType_quantityRange");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsageConstraintsType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_UsageConstraintsType (OSCTXT* pctxt, 
   CBMS_UsageConstraintsType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode purchaseType */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ControlledTermType_derivations (pctxt, 
               &pvalue->purchaseType, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.purchaseTypePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode quantityUnit */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ControlledTermType_derivations (pctxt, 
               &pvalue->quantityUnit, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityUnitPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 2:
         /* decode quantityRange */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_UsageConstraintsType_quantityRange (pctxt, 
               &pvalue->quantityRange, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.quantityRangePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_UsageConstraintsType (OSCTXT* pctxt, 
   CBMS_UsageConstraintsType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("PurchaseType"), 12}, 0}, 0 },
      {{{OSUTF8("QuantityUnit"), 12}, 0}, 1 },
      {{{OSUTF8("QuantityRange"), 13}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* PurchaseType */
         stat = XmlDec_ControlledTermType_derivations (pctxt, &pvalue->
            purchaseType);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.purchaseTypePresent = TRUE;
         break;
      }
      case 1: { /* QuantityUnit */
         stat = XmlDec_ControlledTermType_derivations (pctxt, &pvalue->
            quantityUnit);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.quantityUnitPresent = TRUE;
         break;
      }
      case 2: { /* QuantityRange */
         stat = XmlDec_CBMS_UsageConstraintsType_quantityRange (pctxt, &pvalue
            ->quantityRange);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.quantityRangePresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PurchaseDataType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_PurchaseDataType (OSCTXT* pctxt, 
   CBMS_PurchaseDataType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode data */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->data, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_PurchaseDataType (OSCTXT* pctxt, CBMS_PurchaseDataType* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Data"), 4}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Data */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->data);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PurchaseDataBaseType_derivations                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_PurchaseDataBaseType_derivations (OSCTXT* pctxt, 
   CBMS_PurchaseDataBaseType_derivations *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.purchaseDataType
             = rtxMemAllocType (pctxt, CBMS_PurchaseDataType);

         if (pvalue->u.purchaseDataType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_PurchaseDataType (pvalue->u.purchaseDataType);
         stat = asn1D_CBMS_PurchaseDataType (pctxt, 
            pvalue->u.purchaseDataType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_CBMS_PurchaseDataBaseType_derivations (OSCTXT* pctxt, 
   CBMS_PurchaseDataBaseType_derivations* pvalue)
{
   const OSUTF8CHAR* xsiType = 0;
   int stat = 0;

   /* decode xsi:type attribute */
   if (rtXmlpHasAttributes (pctxt)) {
      OSUINT32 i, nAttrs = 0;
      OSXMLNameFragments attrName;

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) == 0 &&
             rtXmlpDecXSITypeAttr (pctxt, &attrName, &xsiType) == 0) break;
      }
   }

   /* decode content */
   if (!OS_ISEMPTY (xsiType)) {
      xsiType = rtXmlDecQName (pctxt, xsiType, 0);
   }
   if (OS_ISEMPTY (xsiType)) {
      pvalue->t = 1;
      pvalue->u.purchaseDataType
          = rtxMemAllocType (pctxt, CBMS_PurchaseDataType);

      if (pvalue->u.purchaseDataType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_PurchaseDataType (pvalue->u.purchaseDataType);

      stat = XmlDec_CBMS_PurchaseDataType (pctxt, pvalue->u.purchaseDataType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("PurchaseDataType")))
   {
      pvalue->t = 1;
      pvalue->u.purchaseDataType
          = rtxMemAllocType (pctxt, CBMS_PurchaseDataType);

      if (pvalue->u.purchaseDataType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_PurchaseDataType (pvalue->u.purchaseDataType);

      stat = XmlDec_CBMS_PurchaseDataType (pctxt, pvalue->u.purchaseDataType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PurchaseRequestType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_PurchaseRequestType (OSCTXT* pctxt, 
   CBMS_PurchaseRequestType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode dRMSystem */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->dRMSystem, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode purchaseData */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_PurchaseDataBaseType_derivations (pctxt, 
               &pvalue->purchaseData, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.purchaseDataPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 2:
         /* decode purchaseChannelIDRef */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_ESGIDRefType_derivations (pctxt, 
               &pvalue->purchaseChannelIDRef, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.purchaseChannelIDRefPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_PurchaseRequestType (OSCTXT* pctxt, 
   CBMS_PurchaseRequestType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("DRMSystem"), 9}, 0}, 0 },
      {{{OSUTF8("PurchaseData"), 12}, 0}, 1 },
      {{{OSUTF8("PurchaseChannelIDRef"), 20}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* DRMSystem */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->dRMSystem);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* PurchaseData */
         stat = XmlDec_CBMS_PurchaseDataBaseType_derivations (pctxt, &pvalue->
            purchaseData);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.purchaseDataPresent = TRUE;
         break;
      }
      case 2: { /* PurchaseChannelIDRef */
         stat = XmlDec_CBMS_ESGIDRefType_derivations (pctxt, &pvalue->
            purchaseChannelIDRef);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.purchaseChannelIDRefPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PurchaseType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_PurchaseType (OSCTXT* pctxt, CBMS_PurchaseType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode end */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_charstr (pctxt, &pvalue->end, ASN1IMPL, 
               (TM_UNIV|TM_PRIM|26), length);
            if (stat == 0) {
               pvalue->m.endPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode purchaseId */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->purchaseId, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.purchaseIdPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode start */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_charstr (pctxt, &pvalue->start, ASN1IMPL, 
               (TM_UNIV|TM_PRIM|26), length);
            if (stat == 0) {
               pvalue->m.startPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode serviceBundleRef */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_ESGIDRefType_derivations (pctxt, 
               &pvalue->serviceBundleRef, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.serviceBundleRefPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode price_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_PurchaseType_price* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->price_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_PurchaseType_price, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_PurchaseType_price (pdata2);

                  stat = asn1D_CBMS_PurchaseType_price (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->price_list, pnode);
               }

               if (!(pvalue->price_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "PurchaseType.price_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->price_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode usageConstraints_list */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_UsageConstraintsType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->usageConstraints_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_UsageConstraintsType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_UsageConstraintsType (pdata2);

                  stat = asn1D_CBMS_UsageConstraintsType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->usageConstraints_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode description_list */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TextualType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->description_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TextualType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TextualType (pdata2);

                  stat = asn1D_TextualType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->description_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode purchaseRequest_list */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_PurchaseRequestType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->purchaseRequest_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_PurchaseRequestType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_PurchaseRequestType (pdata2);

                  stat = asn1D_CBMS_PurchaseRequestType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->purchaseRequest_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode mediaTitle_list */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TitleMediaType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->mediaTitle_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TitleMediaType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TitleMediaType (pdata2);

                  stat = asn1D_TitleMediaType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->mediaTitle_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 5) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_PurchaseType (OSCTXT* pctxt, CBMS_PurchaseType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("end"), 3}, 0 },
         { {OSUTF8("purchaseId"), 10}, 0 },
         { {OSUTF8("start"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* end */
            stat = rtXmlpDecDynUTF8Str (pctxt, (const OSUTF8CHAR**)&pvalue->end
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.endPresent = TRUE;
            break;

         case 1: /* purchaseId */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->purchaseId);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.purchaseIdPresent = TRUE;
            break;

         case 2: /* start */
            stat = rtXmlpDecDynUTF8Str (pctxt, (const OSUTF8CHAR**)&pvalue->
               start);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.startPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_PurchaseType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_PurchaseType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("ServiceBundleRef"), 16}, 0}, 0 },
      {{{OSUTF8("Price"), 5}, 0}, 1 },
      {{{OSUTF8("UsageConstraints"), 16}, 0}, 2 },
      {{{OSUTF8("Description"), 11}, 0}, 3 },
      {{{OSUTF8("PurchaseRequest"), 15}, 0}, 4 },
      {{{OSUTF8("MediaTitle"), 10}, 0}, 5 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 6, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 6; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* ServiceBundleRef */
         stat = XmlDec_CBMS_ESGIDRefType_derivations (pctxt, &pvalue->
            serviceBundleRef);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.serviceBundleRefPresent = TRUE;
         break;
      }
      case 1: {
         CBMS_PurchaseType_price* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_PurchaseType_price);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_PurchaseType_price (pdata1);

            stat = XmlDec_CBMS_PurchaseType_price (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->price_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 2: {
         CBMS_UsageConstraintsType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_UsageConstraintsType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_UsageConstraintsType (pdata1);

            stat = XmlDec_CBMS_UsageConstraintsType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->usageConstraints_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 2);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 3: {
         TextualType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TextualType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TextualType (pdata1);

            stat = XmlDec_TextualType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->description_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 4: {
         CBMS_PurchaseRequestType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_PurchaseRequestType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_PurchaseRequestType (pdata1);

            stat = XmlDec_CBMS_PurchaseRequestType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->purchaseRequest_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 4, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 4);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 5: {
         TitleMediaType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TitleMediaType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TitleMediaType (pdata1);

            stat = XmlDec_TitleMediaType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->mediaTitle_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 5, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 5);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PurchaseTableType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_PurchaseTableType (OSCTXT* pctxt, 
   CBMS_PurchaseTableType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   CBMS_PurchaseType* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, CBMS_PurchaseType, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_PurchaseType (pdata1);

      stat = asn1D_CBMS_PurchaseType (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   return (stat);
}

int XmlDec_CBMS_PurchaseTableType (OSCTXT* pctxt, 
   CBMS_PurchaseTableType* pvalue)
{
   int stat = 0;

   { int elemID;
   CBMS_PurchaseType* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Purchase"), 8}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* Purchase */
         pdata1 = rtxMemAllocType (pctxt, CBMS_PurchaseType);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_PurchaseType (pdata1);

         stat = XmlDec_CBMS_PurchaseType (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PurchaseChannelType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_PurchaseChannelType (OSCTXT* pctxt, 
   CBMS_PurchaseChannelType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode purchaseChannelID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->purchaseChannelID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode name_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TextualType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->name_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TextualType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TextualType (pdata2);

                  stat = asn1D_TextualType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->name_list, pnode);
               }

               if (!(pvalue->name_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "PurchaseChannelType.name_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->name_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode description_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TextualType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->description_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TextualType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TextualType (pdata2);

                  stat = asn1D_TextualType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->description_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode portalURL */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->portalURL, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.portalURLPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode contactInfo_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->contactInfo_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->contactInfo_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode mediaTitle_list */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               TitleMediaType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->mediaTitle_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, TitleMediaType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_TitleMediaType (pdata2);

                  stat = asn1D_TitleMediaType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->mediaTitle_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode privateData_list */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_PrivateDataType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->privateData_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_PrivateDataType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_PrivateDataType (pdata2);

                  stat = asn1D_CBMS_PrivateDataType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->privateData_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 6) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_PurchaseChannelType (OSCTXT* pctxt, 
   CBMS_PurchaseChannelType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("purchaseChannelID"), 17}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* purchaseChannelID */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->purchaseChannelID);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_PurchaseChannelType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_PurchaseChannelType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Name"), 4}, 0}, 0 },
      {{{OSUTF8("Description"), 11}, 0}, 1 },
      {{{OSUTF8("PortalURL"), 9}, 0}, 2 },
      {{{OSUTF8("ContactInfo"), 11}, 0}, 3 },
      {{{OSUTF8("MediaTitle"), 10}, 0}, 4 },
      {{{OSUTF8("PrivateData"), 11}, 0}, 5 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 6, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 6; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         TextualType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TextualType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TextualType (pdata1);

            stat = XmlDec_TextualType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->name_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: {
         TextualType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TextualType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TextualType (pdata1);

            stat = XmlDec_TextualType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->description_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 2: { /* PortalURL */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->portalURL);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.portalURLPresent = TRUE;
         break;
      }
      case 3: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->contactInfo_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 4: {
         TitleMediaType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, TitleMediaType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_TitleMediaType (pdata1);

            stat = XmlDec_TitleMediaType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->mediaTitle_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 4, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 4);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 5: {
         CBMS_PrivateDataType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_PrivateDataType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_PrivateDataType (pdata1);

            stat = XmlDec_CBMS_PrivateDataType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->privateData_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 5, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 5);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PurchaseChannelTableType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_PurchaseChannelTableType (OSCTXT* pctxt, 
   CBMS_PurchaseChannelTableType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   CBMS_PurchaseChannelType* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, CBMS_PurchaseChannelType, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_PurchaseChannelType (pdata1);

      stat = asn1D_CBMS_PurchaseChannelType (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   return (stat);
}

int XmlDec_CBMS_PurchaseChannelTableType (OSCTXT* pctxt, 
   CBMS_PurchaseChannelTableType* pvalue)
{
   int stat = 0;

   { int elemID;
   CBMS_PurchaseChannelType* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("PurchaseChannel"), 15}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* PurchaseChannel */
         pdata1 = rtxMemAllocType (pctxt, CBMS_PurchaseChannelType);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_PurchaseChannelType (pdata1);

         stat = XmlDec_CBMS_PurchaseChannelType (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VideoCodecCharacteristicType                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_VideoCodecCharacteristicType (OSCTXT* pctxt, 
   CBMS_VideoCodecCharacteristicType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode codec */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ControlledTermType_derivations (pctxt, 
               &pvalue->codec, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.codecPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode profileLevelIndication */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ControlledTermType_derivations (pctxt, 
               &pvalue->profileLevelIndication, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.profileLevelIndicationPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_VideoCodecCharacteristicType (OSCTXT* pctxt, 
   CBMS_VideoCodecCharacteristicType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Codec"), 5}, 0}, 0 },
      {{{OSUTF8("ProfileLevelIndication"), 22}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Codec */
         stat = XmlDec_ControlledTermType_derivations (pctxt, &pvalue->codec);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.codecPresent = TRUE;
         break;
      }
      case 1: { /* ProfileLevelIndication */
         stat = XmlDec_ControlledTermType_derivations (pctxt, &pvalue->
            profileLevelIndication);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.profileLevelIndicationPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VideoComponentType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_VideoComponentType (OSCTXT* pctxt, 
   CBMS_VideoComponentType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode purpose */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->purpose, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.purposePresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode bandwidth */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_BitRateType (pctxt, 
               &pvalue->bandwidth, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.bandwidthPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 2:
         /* decode codecCharacteristic */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_VideoCodecCharacteristicType (pctxt, 
               &pvalue->codecCharacteristic, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.codecCharacteristicPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode frameRate */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_FrameRateType (pctxt, 
               &pvalue->frameRate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.frameRatePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode openCaptionLanguage */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->openCaptionLanguage, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.openCaptionLanguagePresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode signLanguage */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SignLanguageType (pctxt, 
               &pvalue->signLanguage, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.signLanguagePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_VideoComponentType (OSCTXT* pctxt, 
   CBMS_VideoComponentType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("purpose"), 7}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* purpose */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->purpose);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.purposePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_VideoComponentType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_VideoComponentType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Bandwidth"), 9}, 0}, 0 },
      {{{OSUTF8("CodecCharacteristic"), 19}, 0}, 1 },
      {{{OSUTF8("FrameRate"), 9}, 0}, 2 },
      {{{OSUTF8("OpenCaptionLanguage"), 19}, 0}, 3 },
      {{{OSUTF8("SignLanguage"), 12}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Bandwidth */
         stat = XmlDec_BitRateType (pctxt, &pvalue->bandwidth);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.bandwidthPresent = TRUE;
         break;
      }
      case 1: { /* CodecCharacteristic */
         stat = XmlDec_CBMS_VideoCodecCharacteristicType (pctxt, &pvalue->
            codecCharacteristic);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.codecCharacteristicPresent = TRUE;
         break;
      }
      case 2: { /* FrameRate */
         stat = XmlDec_FrameRateType (pctxt, &pvalue->frameRate);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.frameRatePresent = TRUE;
         break;
      }
      case 3: { /* OpenCaptionLanguage */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->openCaptionLanguage);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.openCaptionLanguagePresent = TRUE;
         break;
      }
      case 4: { /* SignLanguage */
         stat = XmlDec_SignLanguageType (pctxt, &pvalue->signLanguage);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.signLanguagePresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AudioComponentType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_AudioComponentType (OSCTXT* pctxt, 
   CBMS_AudioComponentType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode purpose */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->purpose, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.purposePresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode bandwidth */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_BitRateType (pctxt, 
               &pvalue->bandwidth, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.bandwidthPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 2:
         /* decode codec */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ControlledTermType_derivations (pctxt, 
               &pvalue->codec, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.codecPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode mode */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ControlledTermType_derivations (pctxt, 
               &pvalue->mode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.modePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode language_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ExtendedLanguageType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->language_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ExtendedLanguageType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ExtendedLanguageType (pdata2);

                  stat = asn1D_ExtendedLanguageType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->language_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_AudioComponentType (OSCTXT* pctxt, 
   CBMS_AudioComponentType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("purpose"), 7}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* purpose */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->purpose);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.purposePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_AudioComponentType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_AudioComponentType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Bandwidth"), 9}, 0}, 0 },
      {{{OSUTF8("Codec"), 5}, 0}, 1 },
      {{{OSUTF8("Mode"), 4}, 0}, 2 },
      {{{OSUTF8("Language"), 8}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Bandwidth */
         stat = XmlDec_BitRateType (pctxt, &pvalue->bandwidth);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.bandwidthPresent = TRUE;
         break;
      }
      case 1: { /* Codec */
         stat = XmlDec_ControlledTermType_derivations (pctxt, &pvalue->codec);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.codecPresent = TRUE;
         break;
      }
      case 2: { /* Mode */
         stat = XmlDec_ControlledTermType_derivations (pctxt, &pvalue->mode);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.modePresent = TRUE;
         break;
      }
      case 3: {
         ExtendedLanguageType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ExtendedLanguageType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ExtendedLanguageType (pdata1);

            stat = XmlDec_ExtendedLanguageType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->language_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FileDownloadComponentType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_FileDownloadComponentType (OSCTXT* pctxt, 
   CBMS_FileDownloadComponentType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode purpose */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->purpose, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.purposePresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode bandwidth */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_BitRateType (pctxt, 
               &pvalue->bandwidth, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.bandwidthPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 2:
         /* decode fileFormat_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->fileFormat_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->fileFormat_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode storage */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_unsigned (pctxt, &pvalue->storage, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.storagePresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_FileDownloadComponentType (OSCTXT* pctxt, 
   CBMS_FileDownloadComponentType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("purpose"), 7}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* purpose */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->purpose);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.purposePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_FileDownloadComponentType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_FileDownloadComponentType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Bandwidth"), 9}, 0}, 0 },
      {{{OSUTF8("FileFormat"), 10}, 0}, 1 },
      {{{OSUTF8("Storage"), 7}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Bandwidth */
         stat = XmlDec_BitRateType (pctxt, &pvalue->bandwidth);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.bandwidthPresent = TRUE;
         break;
      }
      case 1: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->fileFormat_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 2: { /* Storage */
         stat = rtXmlpDecUInt (pctxt, &pvalue->storage);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.storagePresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ComponentCharacteristicType_derivations                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ComponentCharacteristicType_derivations (OSCTXT* pctxt, 
   CBMS_ComponentCharacteristicType_derivations *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.videoComponentType
             = rtxMemAllocType (pctxt, CBMS_VideoComponentType);

         if (pvalue->u.videoComponentType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_VideoComponentType (pvalue->u.videoComponentType);
         stat = asn1D_CBMS_VideoComponentType (pctxt, 
            pvalue->u.videoComponentType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.audioComponentType
             = rtxMemAllocType (pctxt, CBMS_AudioComponentType);

         if (pvalue->u.audioComponentType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_AudioComponentType (pvalue->u.audioComponentType);
         stat = asn1D_CBMS_AudioComponentType (pctxt, 
            pvalue->u.audioComponentType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.fileDownloadComponentType
             = rtxMemAllocType (pctxt, CBMS_FileDownloadComponentType);

         if (pvalue->u.fileDownloadComponentType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_FileDownloadComponentType (pvalue->u.fileDownloadComponentType);
         stat = asn1D_CBMS_FileDownloadComponentType (pctxt, 
            pvalue->u.fileDownloadComponentType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_CBMS_ComponentCharacteristicType_derivations (OSCTXT* pctxt, 
   CBMS_ComponentCharacteristicType_derivations* pvalue)
{
   const OSUTF8CHAR* xsiType = 0;
   int stat = 0;

   /* decode xsi:type attribute */
   if (rtXmlpHasAttributes (pctxt)) {
      OSUINT32 i, nAttrs = 0;
      OSXMLNameFragments attrName;

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) == 0 &&
             rtXmlpDecXSITypeAttr (pctxt, &attrName, &xsiType) == 0) break;
      }
   }

   /* decode content */
   if (!OS_ISEMPTY (xsiType)) {
      xsiType = rtXmlDecQName (pctxt, xsiType, 0);
   }
   if (OS_ISEMPTY (xsiType)) {
      pvalue->t = 1;
      pvalue->u.videoComponentType
          = rtxMemAllocType (pctxt, CBMS_VideoComponentType);

      if (pvalue->u.videoComponentType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_VideoComponentType (pvalue->u.videoComponentType);

      stat = XmlDec_CBMS_VideoComponentType (pctxt, pvalue->
         u.videoComponentType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("VideoComponentType")))
   {
      pvalue->t = 1;
      pvalue->u.videoComponentType
          = rtxMemAllocType (pctxt, CBMS_VideoComponentType);

      if (pvalue->u.videoComponentType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_VideoComponentType (pvalue->u.videoComponentType);

      stat = XmlDec_CBMS_VideoComponentType (pctxt, pvalue->
         u.videoComponentType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("AudioComponentType")))
   {
      pvalue->t = 2;
      pvalue->u.audioComponentType
          = rtxMemAllocType (pctxt, CBMS_AudioComponentType);

      if (pvalue->u.audioComponentType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_AudioComponentType (pvalue->u.audioComponentType);

      stat = XmlDec_CBMS_AudioComponentType (pctxt, pvalue->
         u.audioComponentType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("FileDownloadComponentType")))
   {
      pvalue->t = 3;
      pvalue->u.fileDownloadComponentType
          = rtxMemAllocType (pctxt, CBMS_FileDownloadComponentType);

      if (pvalue->u.fileDownloadComponentType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_FileDownloadComponentType (pvalue->
         u.fileDownloadComponentType);

      stat = XmlDec_CBMS_FileDownloadComponentType (pctxt, pvalue->
         u.fileDownloadComponentType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SDPType                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_SDPType (OSCTXT* pctxt, CBMS_SDPType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_CBMS_SDPType (OSCTXT* pctxt, CBMS_SDPType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InlinedSDPType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_InlinedSDPType (OSCTXT* pctxt, 
   CBMS_InlinedSDPType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode sDP */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_SDPType (pctxt, 
               &pvalue->sDP, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode associatedDeliveryProcedure */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->associatedDeliveryProcedure, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.associatedDeliveryProcedurePresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_InlinedSDPType (OSCTXT* pctxt, CBMS_InlinedSDPType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("SDP"), 3}, 0}, 0 },
      {{{OSUTF8("AssociatedDeliveryProcedure"), 27}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* SDP */
         stat = XmlDec_CBMS_SDPType (pctxt, &pvalue->sDP);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* AssociatedDeliveryProcedure */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            associatedDeliveryProcedure);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.associatedDeliveryProcedurePresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SDPRefType                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_SDPRefType (OSCTXT* pctxt, CBMS_SDPRefType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode sDPStream */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_SDPType (pctxt, 
               &pvalue->sDPStream, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode sDPURI */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->sDPURI, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode associatedDeliveryProcedure */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->associatedDeliveryProcedure, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.associatedDeliveryProcedurePresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_SDPRefType (OSCTXT* pctxt, CBMS_SDPRefType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("SDPStream"), 9}, 0}, 0 },
      {{{OSUTF8("SDPURI"), 6}, 0}, 1 },
      {{{OSUTF8("AssociatedDeliveryProcedure"), 27}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* SDPStream */
         stat = XmlDec_CBMS_SDPType (pctxt, &pvalue->sDPStream);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* SDPURI */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->sDPURI);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* AssociatedDeliveryProcedure */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            associatedDeliveryProcedure);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.associatedDeliveryProcedurePresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SessionDescriptionBaseType_derivations                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_SessionDescriptionBaseType_derivations (OSCTXT* pctxt, 
   CBMS_SessionDescriptionBaseType_derivations *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.inlinedSDPType
             = rtxMemAllocType (pctxt, CBMS_InlinedSDPType);

         if (pvalue->u.inlinedSDPType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_InlinedSDPType (pvalue->u.inlinedSDPType);
         stat = asn1D_CBMS_InlinedSDPType (pctxt, 
            pvalue->u.inlinedSDPType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.sDPRefType = rtxMemAllocType (pctxt, CBMS_SDPRefType);

         if (pvalue->u.sDPRefType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_SDPRefType (pvalue->u.sDPRefType);
         stat = asn1D_CBMS_SDPRefType (pctxt, 
            pvalue->u.sDPRefType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_CBMS_SessionDescriptionBaseType_derivations (OSCTXT* pctxt, 
   CBMS_SessionDescriptionBaseType_derivations* pvalue)
{
   const OSUTF8CHAR* xsiType = 0;
   int stat = 0;

   /* decode xsi:type attribute */
   if (rtXmlpHasAttributes (pctxt)) {
      OSUINT32 i, nAttrs = 0;
      OSXMLNameFragments attrName;

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) == 0 &&
             rtXmlpDecXSITypeAttr (pctxt, &attrName, &xsiType) == 0) break;
      }
   }

   /* decode content */
   if (!OS_ISEMPTY (xsiType)) {
      xsiType = rtXmlDecQName (pctxt, xsiType, 0);
   }
   if (OS_ISEMPTY (xsiType)) {
      pvalue->t = 1;
      pvalue->u.inlinedSDPType = rtxMemAllocType (pctxt, CBMS_InlinedSDPType);

      if (pvalue->u.inlinedSDPType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_InlinedSDPType (pvalue->u.inlinedSDPType);

      stat = XmlDec_CBMS_InlinedSDPType (pctxt, pvalue->u.inlinedSDPType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("InlinedSDPType")))
   {
      pvalue->t = 1;
      pvalue->u.inlinedSDPType = rtxMemAllocType (pctxt, CBMS_InlinedSDPType);

      if (pvalue->u.inlinedSDPType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_InlinedSDPType (pvalue->u.inlinedSDPType);

      stat = XmlDec_CBMS_InlinedSDPType (pctxt, pvalue->u.inlinedSDPType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("SDPRefType")))
   {
      pvalue->t = 2;
      pvalue->u.sDPRefType = rtxMemAllocType (pctxt, CBMS_SDPRefType);

      if (pvalue->u.sDPRefType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_SDPRefType (pvalue->u.sDPRefType);

      stat = XmlDec_CBMS_SDPRefType (pctxt, pvalue->u.sDPRefType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ComponentDescriptionType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ComponentDescriptionType (OSCTXT* pctxt, 
   CBMS_ComponentDescriptionType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode componentCharacteristic_list */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_ComponentCharacteristicType_derivations* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->componentCharacteristic_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_ComponentCharacteristicType_derivations, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_ComponentCharacteristicType_derivations (pdata2);

                  stat = asn1D_CBMS_ComponentCharacteristicType_derivations (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->componentCharacteristic_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode sessionDescription */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_SessionDescriptionBaseType_derivations (pctxt, 
               &pvalue->sessionDescription, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ComponentDescriptionType (OSCTXT* pctxt, 
   CBMS_ComponentDescriptionType* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("ComponentCharacteristic"), 23}, 0}, 0 },
      {{{OSUTF8("SessionDescription"), 18}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         CBMS_ComponentCharacteristicType_derivations* pdata1;
         do {
            pdata1
                = rtxMemAllocType (pctxt, CBMS_ComponentCharacteristicType_derivations);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_ComponentCharacteristicType_derivations (pdata1);

            stat = XmlDec_CBMS_ComponentCharacteristicType_derivations (pctxt, 
               pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->componentCharacteristic_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: { /* SessionDescription */
         stat = XmlDec_CBMS_SessionDescriptionBaseType_derivations (pctxt, &
            pvalue->sessionDescription);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ZappingSupportType_element_choice                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ZappingSupportType_element_choice (OSCTXT* pctxt, 
   CBMS_ZappingSupportType_element_choice *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.mediaLocator
             = rtxMemAllocType (pctxt, MediaLocatorType_derivations);

         if (pvalue->u.mediaLocator == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_MediaLocatorType_derivations (pvalue->u.mediaLocator);
         stat = asn1D_MediaLocatorType_derivations (pctxt, 
            pvalue->u.mediaLocator, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.zappingSDP_list = rtxMemAllocType (pctxt, OSRTDList);

         if (pvalue->u.zappingSDP_list == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         rtxDListFastInit (pvalue->u.zappingSDP_list);
         /* decode inline SEQUENCE OF type */
         {
            int stat = 0;
            CBMS_SessionDescriptionBaseType_derivations* pdata2;
            OSRTDListNode* pnode;
            ASN1CCB ccb;

            /* decode SEQUENCE OF or SET OF */

            rtxDListInit (pvalue->u.zappingSDP_list);

            ccb.len = length;
            ccb.ptr = OSRTBUFPTR(pctxt);

            while (!XD_CHKEND (pctxt, &ccb))
            {
               if (pvalue->u.zappingSDP_list->count >= 1) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

               rtxDListAllocNodeAndData (pctxt, CBMS_SessionDescriptionBaseType_derivations, &pnode, &pdata2);

               if (pnode == NULL)
                  return LOG_RTERR (pctxt, RTERR_NOMEM);

               asn1Init_CBMS_SessionDescriptionBaseType_derivations (pdata2);

               stat = asn1D_CBMS_SessionDescriptionBaseType_derivations (pctxt, 
                  pdata2, ASN1EXPL, length);
               if (stat != 0) return LOG_RTERR (pctxt, stat);

               rtxDListAppendNode (pvalue->u.zappingSDP_list, pnode);
            }

            if (!((pvalue->u.zappingSDP_list->count >= 0 && pvalue->u.zappingSDP_list
               ->count <= 1))) {
               rtxErrAddStrParm (pctxt, "ZappingSupportType_element_choice.u.zappingSDP_list.count");
               rtxErrAddIntParm (pctxt, (int)pvalue->u.zappingSDP_list->count);
               return LOG_RTERR (pctxt, RTERR_CONSVIO);
            }

         }
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_CBMS_ZappingSupportType_element_choice (OSCTXT* pctxt, 
   CBMS_ZappingSupportType_element_choice* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("MediaLocator"), 12}, 0}, 0 },
      {{{OSUTF8("ZappingSDP"), 10}, 0}, 1 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* MediaLocator */
      pvalue->u.mediaLocator
          = rtxMemAllocType (pctxt, MediaLocatorType_derivations);

      if (pvalue->u.mediaLocator == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_MediaLocatorType_derivations (pvalue->u.mediaLocator);

      stat = XmlDec_MediaLocatorType_derivations (pctxt, pvalue->u.mediaLocator
         );
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: {
      CBMS_SessionDescriptionBaseType_derivations* pdata1;

      pvalue->u.zappingSDP_list = rtxMemAllocType (pctxt, OSRTDList);
      rtxDListInit (pvalue->u.zappingSDP_list);

      do {
         pdata1
             = rtxMemAllocType (pctxt, CBMS_SessionDescriptionBaseType_derivations);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_SessionDescriptionBaseType_derivations (pdata1);

         stat = XmlDec_CBMS_SessionDescriptionBaseType_derivations (pctxt, 
            pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue->u.zappingSDP_list, (void*)pdata1);

         stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
         if (stat < 0 && stat != RTERR_UNEXPELEM)
            return LOG_RTERR (pctxt, stat);
      }
      while (stat == 1);

      rtXmlpMarkLastEventActive (pctxt);
      stat = 0;
      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ZappingSupportType_element                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ZappingSupportType_element (OSCTXT* pctxt, 
   CBMS_ZappingSupportType_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode type_list */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ControlledTermType_derivations* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->type_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ControlledTermType_derivations, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ControlledTermType_derivations (pdata2);

                  stat = asn1D_ControlledTermType_derivations (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->type_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_ZappingSupportType_element_choice (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choicePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ZappingSupportType_element (OSCTXT* pctxt, 
   CBMS_ZappingSupportType_element* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Type"), 4}, 0}, 0 },
      {{{OSUTF8("MediaLocator"), 12}, 0}, 1 },
      {{{OSUTF8("ZappingSDP"), 10}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         ControlledTermType_derivations* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ControlledTermType_derivations);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ControlledTermType_derivations (pdata1);

            stat = XmlDec_ControlledTermType_derivations (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->type_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: { /*  */
         stat = XmlDec_CBMS_ZappingSupportType_element_choice (pctxt, &pvalue->
            choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choicePresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ZappingSupportType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ZappingSupportType (OSCTXT* pctxt, 
   CBMS_ZappingSupportType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   CBMS_ZappingSupportType_element* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, CBMS_ZappingSupportType_element, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_ZappingSupportType_element (pdata1);

      stat = asn1D_CBMS_ZappingSupportType_element (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   return (stat);
}

int XmlDec_CBMS_ZappingSupportType (OSCTXT* pctxt, 
   CBMS_ZappingSupportType* pvalue)
{
   int stat = 0;

   { int elemID;
   CBMS_ZappingSupportType_element* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Type"), 4}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0:
         rtXmlpMarkLastEventActive (pctxt);

         pdata1 = rtxMemAllocType (pctxt, CBMS_ZappingSupportType_element);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_ZappingSupportType_element (pdata1);

         stat = XmlDec_CBMS_ZappingSupportType_element (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeyStreamType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_KeyStreamType (OSCTXT* pctxt, 
   CBMS_KeyStreamType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode cBMSKMSId */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_uint16 (pctxt, &pvalue->cBMSKMSId, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode iPDCOperatorID */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->iPDCOperatorID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_KeyStreamType (OSCTXT* pctxt, CBMS_KeyStreamType* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("CBMSKMSId"), 9}, 0 },
         { {OSUTF8("IPDCOperatorID"), 14}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* CBMSKMSId */
            stat = rtXmlpDecUInt16 (pctxt, &pvalue->cBMSKMSId);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* IPDCOperatorID */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->iPDCOperatorID);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_KeyStreamType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_KeyStreamType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeyStreamBaseType_derivations                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_KeyStreamBaseType_derivations (OSCTXT* pctxt, 
   CBMS_KeyStreamBaseType_derivations *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.keyStreamType
             = rtxMemAllocType (pctxt, CBMS_KeyStreamType);

         if (pvalue->u.keyStreamType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_KeyStreamType (pvalue->u.keyStreamType);
         stat = asn1D_CBMS_KeyStreamType (pctxt, 
            pvalue->u.keyStreamType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_CBMS_KeyStreamBaseType_derivations (OSCTXT* pctxt, 
   CBMS_KeyStreamBaseType_derivations* pvalue)
{
   const OSUTF8CHAR* xsiType = 0;
   int stat = 0;

   /* decode xsi:type attribute */
   if (rtXmlpHasAttributes (pctxt)) {
      OSUINT32 i, nAttrs = 0;
      OSXMLNameFragments attrName;

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) == 0 &&
             rtXmlpDecXSITypeAttr (pctxt, &attrName, &xsiType) == 0) break;
      }
   }

   /* decode content */
   if (!OS_ISEMPTY (xsiType)) {
      xsiType = rtXmlDecQName (pctxt, xsiType, 0);
   }
   if (OS_ISEMPTY (xsiType)) {
      pvalue->t = 1;
      pvalue->u.keyStreamType = rtxMemAllocType (pctxt, CBMS_KeyStreamType);

      if (pvalue->u.keyStreamType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_KeyStreamType (pvalue->u.keyStreamType);

      stat = XmlDec_CBMS_KeyStreamType (pctxt, pvalue->u.keyStreamType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("KeyStreamType")))
   {
      pvalue->t = 1;
      pvalue->u.keyStreamType = rtxMemAllocType (pctxt, CBMS_KeyStreamType);

      if (pvalue->u.keyStreamType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_KeyStreamType (pvalue->u.keyStreamType);

      stat = XmlDec_CBMS_KeyStreamType (pctxt, pvalue->u.keyStreamType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AcquisitionType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_AcquisitionType (OSCTXT* pctxt, 
   CBMS_AcquisitionType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode acquisitionID */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->acquisitionID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode contentMimeType */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_MimeType (pctxt, 
               &pvalue->contentMimeType, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode componentDescription_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_ComponentDescriptionType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->componentDescription_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_ComponentDescriptionType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_ComponentDescriptionType (pdata2);

                  stat = asn1D_CBMS_ComponentDescriptionType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->componentDescription_list, pnode);
               }

               if (!(pvalue->componentDescription_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "AcquisitionType.componentDescription_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->componentDescription_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode zappingSupport */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_ZappingSupportType (pctxt, 
               &pvalue->zappingSupport, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.zappingSupportPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode keyStream_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               CBMS_KeyStreamBaseType_derivations* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->keyStream_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, CBMS_KeyStreamBaseType_derivations, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_CBMS_KeyStreamBaseType_derivations (pdata2);

                  stat = asn1D_CBMS_KeyStreamBaseType_derivations (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->keyStream_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 4) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_AcquisitionType (OSCTXT* pctxt, CBMS_AcquisitionType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("acquisitionID"), 13}, 0 },
         { {OSUTF8("contentMimeType"), 15}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* acquisitionID */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->acquisitionID);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* contentMimeType */
            stat = XmlDec_MimeType (pctxt, &pvalue->contentMimeType);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_AcquisitionType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_AcquisitionType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("ComponentDescription"), 20}, 0}, 0 },
      {{{OSUTF8("ZappingSupport"), 14}, 0}, 1 },
      {{{OSUTF8("KeyStream"), 9}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         CBMS_ComponentDescriptionType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, CBMS_ComponentDescriptionType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_ComponentDescriptionType (pdata1);

            stat = XmlDec_CBMS_ComponentDescriptionType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->componentDescription_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: { /* ZappingSupport */
         stat = XmlDec_CBMS_ZappingSupportType (pctxt, &pvalue->zappingSupport
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.zappingSupportPresent = TRUE;
         break;
      }
      case 2: {
         CBMS_KeyStreamBaseType_derivations* pdata1;
         do {
            pdata1
                = rtxMemAllocType (pctxt, CBMS_KeyStreamBaseType_derivations);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_CBMS_KeyStreamBaseType_derivations (pdata1);

            stat = XmlDec_CBMS_KeyStreamBaseType_derivations (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->keyStream_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 2);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AcquisitionTableType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_AcquisitionTableType (OSCTXT* pctxt, 
   CBMS_AcquisitionTableType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   CBMS_AcquisitionType* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, CBMS_AcquisitionType, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CBMS_AcquisitionType (pdata1);

      stat = asn1D_CBMS_AcquisitionType (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   return (stat);
}

int XmlDec_CBMS_AcquisitionTableType (OSCTXT* pctxt, 
   CBMS_AcquisitionTableType* pvalue)
{
   int stat = 0;

   { int elemID;
   CBMS_AcquisitionType* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Acquisition"), 11}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* Acquisition */
         pdata1 = rtxMemAllocType (pctxt, CBMS_AcquisitionType);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CBMS_AcquisitionType (pdata1);

         stat = XmlDec_CBMS_AcquisitionType (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ESGType                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ESGType (OSCTXT* pctxt, CBMS_ESGType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode contentTable */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_ContentTableType (pctxt, 
               &pvalue->contentTable, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.contentTablePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode scheduleEventTable */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_ScheduleEventTableType (pctxt, 
               &pvalue->scheduleEventTable, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.scheduleEventTablePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 2:
         /* decode serviceTable */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_ServiceTableType (pctxt, 
               &pvalue->serviceTable, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.serviceTablePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode serviceBundleTable */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_ServiceBundleTableType (pctxt, 
               &pvalue->serviceBundleTable, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.serviceBundleTablePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode purchaseTable */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_PurchaseTableType (pctxt, 
               &pvalue->purchaseTable, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.purchaseTablePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode purchaseChannelTable */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_PurchaseChannelTableType (pctxt, 
               &pvalue->purchaseChannelTable, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.purchaseChannelTablePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode acquisitionTable */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_AcquisitionTableType (pctxt, 
               &pvalue->acquisitionTable, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.acquisitionTablePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ESGType (OSCTXT* pctxt, CBMS_ESGType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("ContentTable"), 12}, 0}, 0 },
      {{{OSUTF8("ScheduleEventTable"), 18}, 0}, 1 },
      {{{OSUTF8("ServiceTable"), 12}, 0}, 2 },
      {{{OSUTF8("ServiceBundleTable"), 18}, 0}, 3 },
      {{{OSUTF8("PurchaseTable"), 13}, 0}, 4 },
      {{{OSUTF8("PurchaseChannelTable"), 20}, 0}, 5 },
      {{{OSUTF8("AcquisitionTable"), 16}, 0}, 6 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 7, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 7; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* ContentTable */
         stat = XmlDec_CBMS_ContentTableType (pctxt, &pvalue->contentTable);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.contentTablePresent = TRUE;
         break;
      }
      case 1: { /* ScheduleEventTable */
         stat = XmlDec_CBMS_ScheduleEventTableType (pctxt, &pvalue->
            scheduleEventTable);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.scheduleEventTablePresent = TRUE;
         break;
      }
      case 2: { /* ServiceTable */
         stat = XmlDec_CBMS_ServiceTableType (pctxt, &pvalue->serviceTable);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.serviceTablePresent = TRUE;
         break;
      }
      case 3: { /* ServiceBundleTable */
         stat = XmlDec_CBMS_ServiceBundleTableType (pctxt, &pvalue->
            serviceBundleTable);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.serviceBundleTablePresent = TRUE;
         break;
      }
      case 4: { /* PurchaseTable */
         stat = XmlDec_CBMS_PurchaseTableType (pctxt, &pvalue->purchaseTable);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.purchaseTablePresent = TRUE;
         break;
      }
      case 5: { /* PurchaseChannelTable */
         stat = XmlDec_CBMS_PurchaseChannelTableType (pctxt, &pvalue->
            purchaseChannelTable);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.purchaseChannelTablePresent = TRUE;
         break;
      }
      case 6: { /* AcquisitionTable */
         stat = XmlDec_CBMS_AcquisitionTableType (pctxt, &pvalue->
            acquisitionTable);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.acquisitionTablePresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ESGMainType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ESGMainType (OSCTXT* pctxt, CBMS_ESGMainType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode publicationTime */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_charstr (pctxt, &pvalue->publicationTime, ASN1IMPL, 
               (TM_UNIV|TM_PRIM|26), length);
            if (stat == 0) {
               pvalue->m.publicationTimePresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode publisher */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->publisher, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.publisherPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode rightsOwner */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->rightsOwner, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.rightsOwnerPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode lang */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->lang, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.langPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode copyrightNotice */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->copyrightNotice, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.copyrightNoticePresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode classificationSchemeTable */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ClassificationSchemeTableType (pctxt, 
               &pvalue->classificationSchemeTable, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.classificationSchemeTablePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode eSG */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CBMS_ESGType (pctxt, 
               &pvalue->eSG, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.eSGPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ESGMainType (OSCTXT* pctxt, CBMS_ESGMainType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("publicationTime"), 15}, 0 },
         { {OSUTF8("publisher"), 9}, 0 },
         { {OSUTF8("rightsOwner"), 11}, 0 },
         { {OSUTF8("lang"), 4}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* publicationTime */
            stat = rtXmlpDecDynUTF8Str (pctxt, (const OSUTF8CHAR**)&pvalue->
               publicationTime);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.publicationTimePresent = TRUE;
            break;

         case 1: /* publisher */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->publisher);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.publisherPresent = TRUE;
            break;

         case 2: /* rightsOwner */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->rightsOwner);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.rightsOwnerPresent = TRUE;
            break;

         case 3: /* lang */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->lang);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.langPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_ESGMainType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_ESGMainType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("CopyrightNotice"), 15}, 0}, 0 },
      {{{OSUTF8("ClassificationSchemeTable"), 25}, 0}, 1 },
      {{{OSUTF8("ESG"), 3}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* CopyrightNotice */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->copyrightNotice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.copyrightNoticePresent = TRUE;
         break;
      }
      case 1: { /* ClassificationSchemeTable */
         stat = XmlDec_ClassificationSchemeTableType (pctxt, &pvalue->
            classificationSchemeTable);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.classificationSchemeTablePresent = TRUE;
         break;
      }
      case 2: { /* ESG */
         stat = XmlDec_CBMS_ESGType (pctxt, &pvalue->eSG);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.eSGPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ESGMain                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ESGMain (OSCTXT* pctxt, CBMS_ESGMain *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_CBMS_ESGMainType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_CBMS_ESGMain (OSCTXT* pctxt, CBMS_ESGMain* pvalue)
{
   int stat = 0;

   stat = XmlDec_CBMS_ESGMainType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PurchaseDataBaseType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_PurchaseDataBaseType (OSCTXT* pctxt, 
   CBMS_PurchaseDataBaseType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   if (tagging == ASN1EXPL && length == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_PurchaseDataBaseType (OSCTXT* pctxt, 
   CBMS_PurchaseDataBaseType* pvalue)
{
   int stat = 0;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ComponentCharacteristicType                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_ComponentCharacteristicType (OSCTXT* pctxt, 
   CBMS_ComponentCharacteristicType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode purpose */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->purpose, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.purposePresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode bandwidth */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_BitRateType (pctxt, 
               &pvalue->bandwidth, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.bandwidthPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_ComponentCharacteristicType (OSCTXT* pctxt, 
   CBMS_ComponentCharacteristicType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("purpose"), 7}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* purpose */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->purpose);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.purposePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CBMS_ComponentCharacteristicType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CBMS_ComponentCharacteristicType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Bandwidth"), 9}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Bandwidth */
         stat = XmlDec_BitRateType (pctxt, &pvalue->bandwidth);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.bandwidthPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SessionDescriptionBaseType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_SessionDescriptionBaseType (OSCTXT* pctxt, 
   CBMS_SessionDescriptionBaseType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   if (tagging == ASN1EXPL && length == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_SessionDescriptionBaseType (OSCTXT* pctxt, 
   CBMS_SessionDescriptionBaseType* pvalue)
{
   int stat = 0;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeyStreamBaseType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CBMS_KeyStreamBaseType (OSCTXT* pctxt, 
   CBMS_KeyStreamBaseType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   if (tagging == ASN1EXPL && length == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CBMS_KeyStreamBaseType (OSCTXT* pctxt, 
   CBMS_KeyStreamBaseType* pvalue)
{
   int stat = 0;

   return (stat);
}

int XmlDec_CBMS_ESGMain_PDU (OSCTXT* pctxt, CBMS_ESGMain* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_CBMS_ESGMain (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("ESGMain"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_CBMS_ESGMain (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlDec_CBMS_PurchaseDataBaseType_PDU (OSCTXT* pctxt, CBMS_PurchaseDataBaseType* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_CBMS_PurchaseDataBaseType (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("purchaseDataBaseType"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_CBMS_PurchaseDataBaseType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlDec_CBMS_ComponentCharacteristicType_PDU (OSCTXT* pctxt, CBMS_ComponentCharacteristicType* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_CBMS_ComponentCharacteristicType (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("componentCharacteristicType"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_CBMS_ComponentCharacteristicType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlDec_CBMS_SessionDescriptionBaseType_PDU (OSCTXT* pctxt, CBMS_SessionDescriptionBaseType* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_CBMS_SessionDescriptionBaseType (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("sessionDescriptionBaseType"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_CBMS_SessionDescriptionBaseType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlDec_CBMS_KeyStreamBaseType_PDU (OSCTXT* pctxt, CBMS_KeyStreamBaseType* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_CBMS_KeyStreamBaseType (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("keyStreamBaseType"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_CBMS_KeyStreamBaseType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
