/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "Urn-GoogleSearch.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  DirectoryCategory                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DirectoryCategory (OSCTXT* pctxt, DirectoryCategory *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode _order */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               int xx2;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               xx2 = 0;
               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  if (xx2 >= 2) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

                  { int length;
                  if (XD_PEEKTAG (pctxt, 0xa)) {
                     stat = xd_Tag1AndLen (pctxt, &length);
                     if (stat != 0) return LOG_RTERR (pctxt, stat);
                  }
                  else return LOG_RTERR (pctxt,
                     berErrUnexpTag(pctxt, TM_UNIV|TM_PRIM|10));

                  stat = xd_uint8 (pctxt, &pvalue->_order.elem[xx2], ASN1IMPL, length);
                  if (stat == 0) {
                     if (!((pvalue->_order.elem[xx2] <= OSUINTCONST(1)))) {
                        rtxErrAddStrParm (pctxt, "DirectoryCategory._order.elem[xx2]");
                        rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx2]);
                        return LOG_RTERR (pctxt, RTERR_CONSVIO);
                     }

                  }
                  else return LOG_RTERR (pctxt, stat);

                  }
                  xx2++;
               }
               pvalue->_order.n = xx2;

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode fullViewableName */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->fullViewableName, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode specialEncoding */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->specialEncoding, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_DirectoryCategory (OSCTXT* pctxt, DirectoryCategory* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("fullViewableName"), 16}, 0}, 0 },
      {{{OSUTF8("specialEncoding"), 15}, 0}, 1 }
   } ;
   pvalue->_order.n = 0;

   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, TRUE);
      if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: { /* fullViewableName */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->fullViewableName);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* specialEncoding */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->specialEncoding);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      pvalue->_order.elem[pvalue->_order.n++] = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ResultElement                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ResultElement (OSCTXT* pctxt, ResultElement *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode _order */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               int xx2;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               xx2 = 0;
               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  if (xx2 >= 9) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

                  { int length;
                  if (XD_PEEKTAG (pctxt, 0xa)) {
                     stat = xd_Tag1AndLen (pctxt, &length);
                     if (stat != 0) return LOG_RTERR (pctxt, stat);
                  }
                  else return LOG_RTERR (pctxt,
                     berErrUnexpTag(pctxt, TM_UNIV|TM_PRIM|10));

                  stat = xd_uint8 (pctxt, &pvalue->_order.elem[xx2], ASN1IMPL, length);
                  if (stat == 0) {
                     if (!((pvalue->_order.elem[xx2] <= OSUINTCONST(8)))) {
                        rtxErrAddStrParm (pctxt, "ResultElement._order.elem[xx2]");
                        rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx2]);
                        return LOG_RTERR (pctxt, RTERR_CONSVIO);
                     }

                  }
                  else return LOG_RTERR (pctxt, stat);

                  }
                  xx2++;
               }
               pvalue->_order.n = xx2;

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode summary */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->summary, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode uRL */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->uRL, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode snippet */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->snippet, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode title */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->title, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode cachedSize */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->cachedSize, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode relatedInformationPresent */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->relatedInformationPresent, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode hostName */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->hostName, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode directoryCategory */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DirectoryCategory (pctxt, 
               &pvalue->directoryCategory, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 9:
         /* decode directoryTitle */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->directoryTitle, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 10) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_ResultElement (OSCTXT* pctxt, ResultElement* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("summary"), 7}, 0}, 0 },
      {{{OSUTF8("URL"), 3}, 0}, 1 },
      {{{OSUTF8("snippet"), 7}, 0}, 2 },
      {{{OSUTF8("title"), 5}, 0}, 3 },
      {{{OSUTF8("cachedSize"), 10}, 0}, 4 },
      {{{OSUTF8("relatedInformationPresent"), 25}, 0}, 5 },
      {{{OSUTF8("hostName"), 8}, 0}, 6 },
      {{{OSUTF8("directoryCategory"), 17}, 0}, 7 },
      {{{OSUTF8("directoryTitle"), 14}, 0}, 8 }
   } ;
   pvalue->_order.n = 0;

   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 9, -1, TRUE);
      if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: { /* summary */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->summary);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* URL */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->uRL);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* snippet */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->snippet);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* title */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->title);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* cachedSize */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->cachedSize);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 5: { /* relatedInformationPresent */
         stat = rtXmlpDecBool (pctxt, &pvalue->relatedInformationPresent);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 6: { /* hostName */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->hostName);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 7: { /* directoryCategory */
         stat = XmlDec_DirectoryCategory (pctxt, &pvalue->directoryCategory);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 8: { /* directoryTitle */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->directoryTitle);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      pvalue->_order.elem[pvalue->_order.n++] = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ResultElementArray                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ResultElementArray (OSCTXT* pctxt, 
   ResultElementArray *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ResultElement* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, ResultElement, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_ResultElement (pdata1);

      stat = asn1D_ResultElement (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (!(pvalue->count >= 1U)) {
      rtxErrAddStrParm (pctxt, "ResultElementArray.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

int XmlDec_ResultElementArray (OSCTXT* pctxt, ResultElementArray* pvalue)
{
   int stat = 0;

   { int elemID;
   ResultElement* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("item"), 4}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* item */
         pdata1 = rtxMemAllocType (pctxt, ResultElement);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_ResultElement (pdata1);

         stat = XmlDec_ResultElement (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DirectoryCategoryArray                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DirectoryCategoryArray (OSCTXT* pctxt, 
   DirectoryCategoryArray *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   DirectoryCategory* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, DirectoryCategory, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_DirectoryCategory (pdata1);

      stat = asn1D_DirectoryCategory (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (!(pvalue->count >= 1U)) {
      rtxErrAddStrParm (pctxt, "DirectoryCategoryArray.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

int XmlDec_DirectoryCategoryArray (OSCTXT* pctxt, 
   DirectoryCategoryArray* pvalue)
{
   int stat = 0;

   { int elemID;
   DirectoryCategory* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("item"), 4}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* item */
         pdata1 = rtxMemAllocType (pctxt, DirectoryCategory);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_DirectoryCategory (pdata1);

         stat = XmlDec_DirectoryCategory (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GoogleSearchResult                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_GoogleSearchResult (OSCTXT* pctxt, 
   GoogleSearchResult *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode _order */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               int xx2;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               xx2 = 0;
               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  if (xx2 >= 11) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

                  { int length;
                  if (XD_PEEKTAG (pctxt, 0xa)) {
                     stat = xd_Tag1AndLen (pctxt, &length);
                     if (stat != 0) return LOG_RTERR (pctxt, stat);
                  }
                  else return LOG_RTERR (pctxt,
                     berErrUnexpTag(pctxt, TM_UNIV|TM_PRIM|10));

                  stat = xd_uint8 (pctxt, &pvalue->_order.elem[xx2], ASN1IMPL, length);
                  if (stat == 0) {
                     if (!((pvalue->_order.elem[xx2] <= OSUINTCONST(10)))) {
                        rtxErrAddStrParm (pctxt, "GoogleSearchResult._order.elem[xx2]");
                        rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx2]);
                        return LOG_RTERR (pctxt, RTERR_CONSVIO);
                     }

                  }
                  else return LOG_RTERR (pctxt, stat);

                  }
                  xx2++;
               }
               pvalue->_order.n = xx2;

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode documentFiltering */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->documentFiltering, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode searchComments */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->searchComments, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode estimatedTotalResultsCount */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->estimatedTotalResultsCount, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode estimateIsExact */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->estimateIsExact, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode resultElements */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ResultElementArray (pctxt, 
               &pvalue->resultElements, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode searchQuery */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->searchQuery, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode startIndex */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->startIndex, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode endIndex */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->endIndex, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 9:
         /* decode searchTips */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->searchTips, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 10:
         /* decode directoryCategories */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DirectoryCategoryArray (pctxt, 
               &pvalue->directoryCategories, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 11:
         /* decode searchTime */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->searchTime, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_PRIM|11):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 12) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_GoogleSearchResult (OSCTXT* pctxt, GoogleSearchResult* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("documentFiltering"), 17}, 0}, 0 },
      {{{OSUTF8("searchComments"), 14}, 0}, 1 },
      {{{OSUTF8("estimatedTotalResultsCount"), 26}, 0}, 2 },
      {{{OSUTF8("estimateIsExact"), 15}, 0}, 3 },
      {{{OSUTF8("resultElements"), 14}, 0}, 4 },
      {{{OSUTF8("searchQuery"), 11}, 0}, 5 },
      {{{OSUTF8("startIndex"), 10}, 0}, 6 },
      {{{OSUTF8("endIndex"), 8}, 0}, 7 },
      {{{OSUTF8("searchTips"), 10}, 0}, 8 },
      {{{OSUTF8("directoryCategories"), 19}, 0}, 9 },
      {{{OSUTF8("searchTime"), 10}, 0}, 10 }
   } ;
   pvalue->_order.n = 0;

   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 11, -1, TRUE);
      if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: { /* documentFiltering */
         stat = rtXmlpDecBool (pctxt, &pvalue->documentFiltering);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* searchComments */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->searchComments);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* estimatedTotalResultsCount */
         stat = rtXmlpDecInt (pctxt, &pvalue->estimatedTotalResultsCount);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* estimateIsExact */
         stat = rtXmlpDecBool (pctxt, &pvalue->estimateIsExact);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* resultElements */
         stat = XmlDec_ResultElementArray (pctxt, &pvalue->resultElements);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 5: { /* searchQuery */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->searchQuery);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 6: { /* startIndex */
         stat = rtXmlpDecInt (pctxt, &pvalue->startIndex);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 7: { /* endIndex */
         stat = rtXmlpDecInt (pctxt, &pvalue->endIndex);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 8: { /* searchTips */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->searchTips);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 9: { /* directoryCategories */
         stat = XmlDec_DirectoryCategoryArray (pctxt, &pvalue->
            directoryCategories);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 10: { /* searchTime */
         stat = rtXmlpDecDouble (pctxt, &pvalue->searchTime, -1, -1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      pvalue->_order.elem[pvalue->_order.n++] = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DoGoogleSearchResponse                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DoGoogleSearchResponse (OSCTXT* pctxt, 
   DoGoogleSearchResponse *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode encodingStyle */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_EncodingStyle (pctxt, 
               &pvalue->encodingStyle, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.encodingStylePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode return_ */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_GoogleSearchResult (pctxt, 
               &pvalue->return_, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_DoGoogleSearchResponse (OSCTXT* pctxt, 
   DoGoogleSearchResponse* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("encodingStyle"), 13}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* encodingStyle */
            rtxDListInit (&pvalue->encodingStyle);

            stat = rtXmlpDecStrList (pctxt, &pvalue->encodingStyle);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.encodingStylePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "DoGoogleSearchResponse");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "DoGoogleSearchResponse");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("return"), 6}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* return */
         stat = XmlDec_GoogleSearchResult (pctxt, &pvalue->return_);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

int XmlDec_DoGoogleSearchResponse_PDU (OSCTXT* pctxt, DoGoogleSearchResponse* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_DoGoogleSearchResponse (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("doGoogleSearchResponse"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_DoGoogleSearchResponse (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
