/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "Sm-common.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  StateType                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_StateType (OSCTXT* pctxt,
   StateType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 48)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_StateType (OSCTXT* pctxt, StateType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      StateType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NoteType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_NoteType (OSCTXT* pctxt,
   NoteType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = asn1E_CCT_TextType (pctxt, pvalue, ASN1IMPL);
   if (ll < 0) return LOG_RTERR (pctxt, ll);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll);
   if (ll < 0) return LOG_RTERR (pctxt, ll);

   if (tagging == ASN1EXPL) {
      ll = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
   }
   ll0 += ll;

   return (ll0);
}

int XmlEnc_NoteType (OSCTXT* pctxt, NoteType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (elemName != 0) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   stat = XmlEnc_CCT_TextType (pctxt, pvalue, OSUTF8("Text"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  QuoteType                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_QuoteType (OSCTXT* pctxt,
   QuoteType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode issueDateTime */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_CCT_DateTimeType (pctxt, &pvalue->issueDateTime, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode identifier */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_CCT_IdentifierType (pctxt, &pvalue->identifier, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_QuoteType (OSCTXT* pctxt, QuoteType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode identifier */

   stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->identifier
      , OSUTF8("Identifier"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode issueDateTime */

   stat = XmlEnc_CCT_DateTimeType (pctxt, &pvalue->issueDateTime
      , OSUTF8("IssueDateTime"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PeriodType                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PeriodType (OSCTXT* pctxt,
   PeriodType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode endDateTime */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_CCT_DateTimeType (pctxt, &pvalue->endDateTime, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode startDateTime */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_CCT_DateTimeType (pctxt, &pvalue->startDateTime, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_PeriodType (OSCTXT* pctxt, PeriodType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode startDateTime */

   stat = XmlEnc_CCT_DateTimeType (pctxt, &pvalue->startDateTime
      , OSUTF8("StartDateTime"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode endDateTime */

   stat = XmlEnc_CCT_DateTimeType (pctxt, &pvalue->endDateTime
      , OSUTF8("EndDateTime"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ContractType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ContractType (OSCTXT* pctxt,
   ContractType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode validityPeriod */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_PeriodType (pctxt, &pvalue->validityPeriod, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode identifier */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_CCT_IdentifierType (pctxt, &pvalue->identifier, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ContractType (OSCTXT* pctxt, ContractType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode identifier */

   stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->identifier
      , OSUTF8("Identifier"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode validityPeriod */

   stat = XmlEnc_PeriodType (pctxt, &pvalue->validityPeriod
      , OSUTF8("ValidityPeriod"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LanguageType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_LanguageType (OSCTXT* pctxt,
   LanguageType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode name */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_CCT_TextType (pctxt, &pvalue->name, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode identificationCode */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_CCT_CodeType (pctxt, &pvalue->identificationCode, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_LanguageType (OSCTXT* pctxt, LanguageType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode identificationCode */

   stat = XmlEnc_CCT_CodeType (pctxt, &pvalue->identificationCode
      , OSUTF8("IdentificationCode"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode name */

   stat = XmlEnc_CCT_TextType (pctxt, &pvalue->name, OSUTF8("Name"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AddressType_sequence                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AddressType_sequence (OSCTXT* pctxt,
   AddressType_sequence *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode roomID */

   if (pvalue->m.roomIDPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
         asn1E_CCT_IdentifierType (pctxt, &pvalue->roomID, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode houseID */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_CCT_IdentifierType (pctxt, &pvalue->houseID, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode street */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_CCT_TextType (pctxt, &pvalue->street, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AddressType_sequence (OSCTXT* pctxt, AddressType_sequence* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode street */

   stat = XmlEnc_CCT_TextType (pctxt, &pvalue->street, OSUTF8("Street"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode houseID */

   stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->houseID
      , OSUTF8("HouseID"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode roomID */

   if (pvalue->m.roomIDPresent) {
      stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->roomID
         , OSUTF8("RoomID"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AddressType_choice                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AddressType_choice (OSCTXT* pctxt,
   AddressType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_CCT_IdentifierType (pctxt, pvalue->u.postboxID, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_AddressType_sequence (pctxt, pvalue->u.sequence, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_AddressType_choice (OSCTXT* pctxt, AddressType_choice* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   switch (pvalue->t)
   {
      case 1:
         /* encode postboxID */

         stat = XmlEnc_CCT_IdentifierType (pctxt, pvalue->u.postboxID
            , OSUTF8("PostboxID"), 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode sequence */

         stat = XmlEnc_AddressType_sequence (pctxt, pvalue->u.sequence
            , OSUTF8(""), 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AddressType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AddressType (OSCTXT* pctxt,
   AddressType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode countryIdentificationCode */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
      asn1E_CCT_CodeType (pctxt, &pvalue->countryIdentificationCode, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode stateName */

   if(pvalue->stateName < 0 || pvalue->stateName > 48)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_StateType (pctxt, &pvalue->stateName, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode postalZoneID */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
      asn1E_CCT_IdentifierType (pctxt, &pvalue->postalZoneID, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode cityName */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_CCT_TextType (pctxt, &pvalue->cityName, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_AddressType_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AddressType (OSCTXT* pctxt, AddressType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode choice */

   stat = XmlEnc_AddressType_choice (pctxt, &pvalue->choice, OSUTF8(""), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode cityName */

   stat = XmlEnc_CCT_TextType (pctxt, &pvalue->cityName
      , OSUTF8("CityName"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode postalZoneID */

   stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->postalZoneID
      , OSUTF8("PostalZoneID"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode stateName */

   if(pvalue->stateName < 0 || pvalue->stateName > 48)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_StateType (pctxt, pvalue->stateName, OSUTF8("StateName"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode countryIdentificationCode */

   stat = XmlEnc_CCT_CodeType (pctxt, &pvalue->countryIdentificationCode
      , OSUTF8("CountryIdentificationCode"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommunicationType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_CommunicationType (OSCTXT* pctxt,
   CommunicationType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode channelID */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_CCT_IdentifierType (pctxt, &pvalue->channelID, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_CCT_TextType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_CommunicationType (OSCTXT* pctxt, CommunicationType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode value */

   stat = XmlEnc_CCT_TextType (pctxt, &pvalue->value, OSUTF8("Value"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode channelID */

   stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->channelID
      , OSUTF8("ChannelID"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ContactType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ContactType (OSCTXT* pctxt,
   ContactType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode communication_list */

   if (!(pvalue->communication_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "ContactType.communication_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->communication_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->communication_list.tail;
   while (0 != pnode2) {
      ll = asn1E_CommunicationType (pctxt, ((CommunicationType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode name */

   if (pvalue->m.namePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_CCT_TextType (pctxt, &pvalue->name, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ContactType (OSCTXT* pctxt, ContactType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode name */

   if (pvalue->m.namePresent) {
      stat = XmlEnc_CCT_TextType (pctxt, &pvalue->name, OSUTF8("Name"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode communication_list */

   if (!(pvalue->communication_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "ContactType.communication_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->communication_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   { OSRTDListNode* pnode = pvalue->communication_list.head;
   while (0 != pnode) {
      stat = XmlEnc_CommunicationType (pctxt, ((CommunicationType*)pnode->data)
         , OSUTF8("Communication"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PartyType                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PartyType (OSCTXT* pctxt,
   PartyType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode contact */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_ContactType (pctxt, &pvalue->contact, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode address */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
      asn1E_AddressType (pctxt, &pvalue->address, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode name */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_CCT_TextType (pctxt, &pvalue->name, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode partyID */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_CCT_IdentifierType (pctxt, &pvalue->partyID, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_PartyType (OSCTXT* pctxt, PartyType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode partyID */

   stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->partyID
      , OSUTF8("PartyID"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode name */

   stat = XmlEnc_CCT_TextType (pctxt, &pvalue->name, OSUTF8("Name"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode address */

   stat = XmlEnc_AddressType (pctxt, &pvalue->address, OSUTF8("Address"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode contact */

   stat = XmlEnc_ContactType (pctxt, &pvalue->contact, OSUTF8("Contact"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ShipmentType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ShipmentType (OSCTXT* pctxt,
   ShipmentType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode instructions */

   if (pvalue->m.instructionsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_CCT_TextType (pctxt, &pvalue->instructions, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode serviceLevelID */

   if (pvalue->m.serviceLevelIDPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_CCT_IdentifierType (pctxt, &pvalue->serviceLevelID, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode carrierID */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
      asn1E_CCT_IdentifierType (pctxt, &pvalue->carrierID, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode transportModeID */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_CCT_IdentifierType (pctxt, &pvalue->transportModeID, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode shipDate */

   if (pvalue->m.shipDatePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_CCT_DateTimeType (pctxt, &pvalue->shipDate, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ShipmentType (OSCTXT* pctxt, ShipmentType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode shipDate */

   if (pvalue->m.shipDatePresent) {
      stat = XmlEnc_CCT_DateTimeType (pctxt, &pvalue->shipDate
         , OSUTF8("ShipDate"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode transportModeID */

   stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->transportModeID
      , OSUTF8("TransportModeID"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode carrierID */

   stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->carrierID
      , OSUTF8("CarrierID"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode serviceLevelID */

   if (pvalue->m.serviceLevelIDPresent) {
      stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->serviceLevelID
         , OSUTF8("ServiceLevelID"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode instructions */

   if (pvalue->m.instructionsPresent) {
      stat = XmlEnc_CCT_TextType (pctxt, &pvalue->instructions
         , OSUTF8("Instructions"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FinancialInstitutionType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_FinancialInstitutionType (OSCTXT* pctxt,
   FinancialInstitutionType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode address */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
      asn1E_AddressType (pctxt, &pvalue->address, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode name */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_CCT_TextType (pctxt, &pvalue->name, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode identifier */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_CCT_IdentifierType (pctxt, &pvalue->identifier, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_FinancialInstitutionType (OSCTXT* pctxt, 
   FinancialInstitutionType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode identifier */

   stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->identifier
      , OSUTF8("Identifier"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode name */

   stat = XmlEnc_CCT_TextType (pctxt, &pvalue->name, OSUTF8("Name"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode address */

   stat = XmlEnc_AddressType (pctxt, &pvalue->address, OSUTF8("Address"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FinancialAccountType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_FinancialAccountType (OSCTXT* pctxt,
   FinancialAccountType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode accountName */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_CCT_TextType (pctxt, &pvalue->accountName, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode typeID */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
      asn1E_CCT_IdentifierType (pctxt, &pvalue->typeID, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode financialInstitution */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_FinancialInstitutionType (pctxt, &pvalue->financialInstitution, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode identifier */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_CCT_IdentifierType (pctxt, &pvalue->identifier, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_FinancialAccountType (OSCTXT* pctxt, FinancialAccountType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode identifier */

   stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->identifier
      , OSUTF8("Identifier"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode financialInstitution */

   stat = XmlEnc_FinancialInstitutionType (pctxt, &pvalue->financialInstitution
      , OSUTF8("FinancialInstitution"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode typeID */

   stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->typeID
      , OSUTF8("TypeID"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode accountName */

   stat = XmlEnc_CCT_TextType (pctxt, &pvalue->accountName
      , OSUTF8("AccountName"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PaymentMeansType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PaymentMeansType (OSCTXT* pctxt,
   PaymentMeansType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode payeeFinancialAccount */

   if (pvalue->m.payeeFinancialAccountPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
         asn1E_FinancialAccountType (pctxt, &pvalue->payeeFinancialAccount, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode payerFinancialAccount */

   if (pvalue->m.payerFinancialAccountPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
         asn1E_FinancialAccountType (pctxt, &pvalue->payerFinancialAccount, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode paymentDate */

   if (pvalue->m.paymentDatePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_CCT_DateType (pctxt, &pvalue->paymentDate, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_PaymentMeansType (OSCTXT* pctxt, PaymentMeansType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode paymentDate */

   if (pvalue->m.paymentDatePresent) {
      stat = XmlEnc_CCT_DateType (pctxt, &pvalue->paymentDate
         , OSUTF8("PaymentDate"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode payerFinancialAccount */

   if (pvalue->m.payerFinancialAccountPresent) {
      stat = XmlEnc_FinancialAccountType (pctxt, &pvalue->payerFinancialAccount
         , OSUTF8("PayerFinancialAccount"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode payeeFinancialAccount */

   if (pvalue->m.payeeFinancialAccountPresent) {
      stat = XmlEnc_FinancialAccountType (pctxt, &pvalue->payeeFinancialAccount
         , OSUTF8("PayeeFinancialAccount"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PricingVariationType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PricingVariationType (OSCTXT* pctxt,
   PricingVariationType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode lumpSumAmount */

   if (pvalue->m.lumpSumAmountPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_CCT_AmountType (pctxt, &pvalue->lumpSumAmount, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode rate */

   if (pvalue->m.ratePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_CCT_NumericType (pctxt, &pvalue->rate, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode validityPeriod */

   if (pvalue->m.validityPeriodPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_PeriodType (pctxt, &pvalue->validityPeriod, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode conditionID */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
      asn1E_CCT_IdentifierType (pctxt, &pvalue->conditionID, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode service */

   if (pvalue->m.servicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
         asn1E_CCT_TextType (pctxt, &pvalue->service, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode serviceID */

   if (pvalue->m.serviceIDPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_CCT_IdentifierType (pctxt, &pvalue->serviceID, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_PricingVariationType (OSCTXT* pctxt, PricingVariationType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode serviceID */

   if (pvalue->m.serviceIDPresent) {
      stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->serviceID
         , OSUTF8("ServiceID"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode service */

   if (pvalue->m.servicePresent) {
      stat = XmlEnc_CCT_TextType (pctxt, &pvalue->service
         , OSUTF8("Service"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode conditionID */

   stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->conditionID
      , OSUTF8("ConditionID"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode validityPeriod */

   if (pvalue->m.validityPeriodPresent) {
      stat = XmlEnc_PeriodType (pctxt, &pvalue->validityPeriod
         , OSUTF8("ValidityPeriod"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode rate */

   if (pvalue->m.ratePresent) {
      stat = XmlEnc_CCT_NumericType (pctxt, &pvalue->rate, OSUTF8("Rate"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode lumpSumAmount */

   if (pvalue->m.lumpSumAmountPresent) {
      stat = XmlEnc_CCT_AmountType (pctxt, &pvalue->lumpSumAmount
         , OSUTF8("LumpSumAmount"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PricingType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PricingType (OSCTXT* pctxt,
   PricingType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode netUnitPriceAmount */

   if (pvalue->m.netUnitPriceAmountPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
         asn1E_CCT_AmountType (pctxt, &pvalue->netUnitPriceAmount, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode grossUnitPriceAmount */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_CCT_AmountType (pctxt, &pvalue->grossUnitPriceAmount, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_PricingType (OSCTXT* pctxt, PricingType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode grossUnitPriceAmount */

   stat = XmlEnc_CCT_AmountType (pctxt, &pvalue->grossUnitPriceAmount
      , OSUTF8("GrossUnitPriceAmount"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode netUnitPriceAmount */

   if (pvalue->m.netUnitPriceAmountPresent) {
      stat = XmlEnc_CCT_AmountType (pctxt, &pvalue->netUnitPriceAmount
         , OSUTF8("NetUnitPriceAmount"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ItemType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ItemType (OSCTXT* pctxt,
   ItemType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode quantity */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
      asn1E_CCT_QuantityType (pctxt, &pvalue->quantity, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
         asn1E_CCT_TextType (pctxt, &pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode standardItemIdentifier */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_CCT_IdentifierType (pctxt, &pvalue->standardItemIdentifier, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ItemType (OSCTXT* pctxt, ItemType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode standardItemIdentifier */

   stat = XmlEnc_CCT_IdentifierType (pctxt, &pvalue->standardItemIdentifier
      , OSUTF8("StandardItemIdentifier"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      stat = XmlEnc_CCT_TextType (pctxt, &pvalue->description
         , OSUTF8("Description"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode quantity */

   stat = XmlEnc_CCT_QuantityType (pctxt, &pvalue->quantity
      , OSUTF8("Quantity"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TaxAmountType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TaxAmountType (OSCTXT* pctxt,
   TaxAmountType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode taxAmount */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_CCT_AmountType (pctxt, &pvalue->taxAmount, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode taxableAmount */

   if (pvalue->m.taxableAmountPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_CCT_AmountType (pctxt, &pvalue->taxableAmount, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TaxAmountType (OSCTXT* pctxt, TaxAmountType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode taxableAmount */

   if (pvalue->m.taxableAmountPresent) {
      stat = XmlEnc_CCT_AmountType (pctxt, &pvalue->taxableAmount
         , OSUTF8("TaxableAmount"), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode taxAmount */

   stat = XmlEnc_CCT_AmountType (pctxt, &pvalue->taxAmount
      , OSUTF8("TaxAmount"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TaxType                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TaxType (OSCTXT* pctxt,
   TaxType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode taxAmount */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
      asn1E_TaxAmountType (pctxt, &pvalue->taxAmount, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode ratePercent */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_CCT_NumericType (pctxt, &pvalue->ratePercent, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode typeCode */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_CCT_CodeType (pctxt, &pvalue->typeCode, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TaxType (OSCTXT* pctxt, TaxType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "http://www.sun.com/schema/spidermarkexpress/sm-common"));

   /* encode typeCode */

   stat = XmlEnc_CCT_CodeType (pctxt, &pvalue->typeCode
      , OSUTF8("TypeCode"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode ratePercent */

   stat = XmlEnc_CCT_NumericType (pctxt, &pvalue->ratePercent
      , OSUTF8("RatePercent"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode taxAmount */

   stat = XmlEnc_TaxAmountType (pctxt, &pvalue->taxAmount
      , OSUTF8("TaxAmount"), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlEnc_QuoteType_PDU (OSCTXT* pctxt, QuoteType* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("cct"), 
      OSUTF8("urn:oasis:names:tc:ubl:CommonLeafTypes:1.0:0.65"), FALSE);

   rtXmlNSSetNamespace (pctxt, OSUTF8("jxb"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb"), FALSE);

   rtXmlNSSetNamespace (pctxt, 0, 
      OSUTF8("http://www.sun.com/schema/spidermarkexpress/sm-common"), FALSE);

   nsPrefix = rtXmlNSGetPrefix (pctxt, 
      OSUTF8("http://www.sun.com/schema/spidermarkexpress/sm-common"));

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("quoteType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_QuoteType (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("quoteType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_ContractType_PDU (OSCTXT* pctxt, ContractType* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("cct"), 
      OSUTF8("urn:oasis:names:tc:ubl:CommonLeafTypes:1.0:0.65"), FALSE);

   rtXmlNSSetNamespace (pctxt, OSUTF8("jxb"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb"), FALSE);

   rtXmlNSSetNamespace (pctxt, 0, 
      OSUTF8("http://www.sun.com/schema/spidermarkexpress/sm-common"), FALSE);

   nsPrefix = rtXmlNSGetPrefix (pctxt, 
      OSUTF8("http://www.sun.com/schema/spidermarkexpress/sm-common"));

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("contractType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_ContractType (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("contractType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
