/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "Ns9.h"
#include "Ns12.h"
#include "Ns10.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  Animate                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Animate (OSCTXT* pctxt, Animate *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode formula */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->formula, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.formulaPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode sub_item */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->sub_item, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sub_itemPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode accumulate */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Accumulate (pctxt, 
               &pvalue->accumulate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.accumulatePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode additive */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Additive (pctxt, 
               &pvalue->additive, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.additivePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode attributeName */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_AttributeName (pctxt, 
               &pvalue->attributeName, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode by */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_By (pctxt, 
               &pvalue->by, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.byPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode calcMode */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_CalcMode (pctxt, 
               &pvalue->calcMode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.calcModePresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode fill */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Fill (pctxt, 
               &pvalue->fill, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fillPresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode from */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_From (pctxt, 
               &pvalue->from, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fromPresent = TRUE;
            }
         }
         break;

      case 9:
         /* decode keySplines */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_KeySplines (pctxt, 
               &pvalue->keySplines, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.keySplinesPresent = TRUE;
            }
         }
         break;

      case 10:
         /* decode keyTimes */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_KeyTimes (pctxt, 
               &pvalue->keyTimes, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.keyTimesPresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode repeatCount */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_RepeatCount (pctxt, 
               &pvalue->repeatCount, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.repeatCountPresent = TRUE;
            }
         }
         break;

      case 12:
         /* decode repeatDur */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_RepeatDur (pctxt, 
               &pvalue->repeatDur, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.repeatDurPresent = TRUE;
            }
         }
         break;

      case 13:
         /* decode targetElement */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_TargetElement (pctxt, 
               &pvalue->targetElement, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.targetElementPresent = TRUE;
            }
         }
         break;

      case 14:
         /* decode to */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_To (pctxt, 
               &pvalue->to, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.toPresent = TRUE;
            }
         }
         break;

      case 15:
         /* decode values */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Values (pctxt, 
               &pvalue->values, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.valuesPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_PRIM|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_PRIM|13):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_PRIM|14):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_PRIM|15):
         case (TM_CTXT|TM_CONS|15):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Animate (OSCTXT* pctxt, Animate* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("formula"), 7}, 0 },
         { {OSUTF8("sub-item"), 8}, 0 },
         { {OSUTF8("accumulate"), 10}, 0 },
         { {OSUTF8("additive"), 8}, 0 },
         { {OSUTF8("attributeName"), 13}, 0 },
         { {OSUTF8("by"), 2}, 0 },
         { {OSUTF8("calcMode"), 8}, 0 },
         { {OSUTF8("fill"), 4}, 0 },
         { {OSUTF8("from"), 4}, 0 },
         { {OSUTF8("keySplines"), 10}, 0 },
         { {OSUTF8("keyTimes"), 8}, 0 },
         { {OSUTF8("repeatCount"), 11}, 0 },
         { {OSUTF8("repeatDur"), 9}, 0 },
         { {OSUTF8("targetElement"), 13}, 0 },
         { {OSUTF8("to"), 2}, 0 },
         { {OSUTF8("values"), 6}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 16, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* formula */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->formula);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.formulaPresent = TRUE;
            break;

         case 1: /* sub-item */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->sub_item);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.sub_itemPresent = TRUE;
            break;

         case 2: /* accumulate */
            stat = XmlDec_Ns11_Accumulate (pctxt, &pvalue->accumulate);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.accumulatePresent = TRUE;
            break;

         case 3: /* additive */
            stat = XmlDec_Ns11_Additive (pctxt, &pvalue->additive);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.additivePresent = TRUE;
            break;

         case 4: /* attributeName */
            stat = XmlDec_Ns11_AttributeName (pctxt, &pvalue->attributeName);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 5: /* by */
            stat = XmlDec_Ns11_By (pctxt, &pvalue->by);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.byPresent = TRUE;
            break;

         case 6: /* calcMode */
            stat = XmlDec_Ns11_CalcMode (pctxt, &pvalue->calcMode);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.calcModePresent = TRUE;
            break;

         case 7: /* fill */
            stat = XmlDec_Ns11_Fill (pctxt, &pvalue->fill);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fillPresent = TRUE;
            break;

         case 8: /* from */
            stat = XmlDec_Ns11_From (pctxt, &pvalue->from);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fromPresent = TRUE;
            break;

         case 9: /* keySplines */
            stat = XmlDec_Ns11_KeySplines (pctxt, &pvalue->keySplines);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.keySplinesPresent = TRUE;
            break;

         case 10: /* keyTimes */
            stat = XmlDec_Ns11_KeyTimes (pctxt, &pvalue->keyTimes);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.keyTimesPresent = TRUE;
            break;

         case 11: /* repeatCount */
            stat = XmlDec_Ns11_RepeatCount (pctxt, &pvalue->repeatCount);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.repeatCountPresent = TRUE;
            break;

         case 12: /* repeatDur */
            stat = XmlDec_Ns11_RepeatDur (pctxt, &pvalue->repeatDur);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.repeatDurPresent = TRUE;
            break;

         case 13: /* targetElement */
            stat = XmlDec_Ns11_TargetElement (pctxt, &pvalue->targetElement);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.targetElementPresent = TRUE;
            break;

         case 14: /* to */
            stat = XmlDec_Ns11_To (pctxt, &pvalue->to);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.toPresent = TRUE;
            break;

         case 15: /* values */
            stat = XmlDec_Ns11_Values (pctxt, &pvalue->values);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.valuesPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Animate");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Animate");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Set                                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Set (OSCTXT* pctxt, Set *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode sub_item */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->sub_item, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sub_itemPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode accumulate */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Accumulate (pctxt, 
               &pvalue->accumulate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.accumulatePresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode additive */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Additive (pctxt, 
               &pvalue->additive, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.additivePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode attributeName */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_AttributeName (pctxt, 
               &pvalue->attributeName, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode fill */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Fill (pctxt, 
               &pvalue->fill, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fillPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode targetElement */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_TargetElement (pctxt, 
               &pvalue->targetElement, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.targetElementPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode to */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_To (pctxt, 
               &pvalue->to, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.toPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Set (OSCTXT* pctxt, Set* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("sub-item"), 8}, 0 },
         { {OSUTF8("accumulate"), 10}, 0 },
         { {OSUTF8("additive"), 8}, 0 },
         { {OSUTF8("attributeName"), 13}, 0 },
         { {OSUTF8("fill"), 4}, 0 },
         { {OSUTF8("targetElement"), 13}, 0 },
         { {OSUTF8("to"), 2}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 7, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* sub-item */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->sub_item);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.sub_itemPresent = TRUE;
            break;

         case 1: /* accumulate */
            stat = XmlDec_Ns11_Accumulate (pctxt, &pvalue->accumulate);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.accumulatePresent = TRUE;
            break;

         case 2: /* additive */
            stat = XmlDec_Ns11_Additive (pctxt, &pvalue->additive);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.additivePresent = TRUE;
            break;

         case 3: /* attributeName */
            stat = XmlDec_Ns11_AttributeName (pctxt, &pvalue->attributeName);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 4: /* fill */
            stat = XmlDec_Ns11_Fill (pctxt, &pvalue->fill);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fillPresent = TRUE;
            break;

         case 5: /* targetElement */
            stat = XmlDec_Ns11_TargetElement (pctxt, &pvalue->targetElement);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.targetElementPresent = TRUE;
            break;

         case 6: /* to */
            stat = XmlDec_Ns11_To (pctxt, &pvalue->to);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.toPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Set");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Set");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AnimateMotion                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AnimateMotion (OSCTXT* pctxt, AnimateMotion *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode formula */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->formula, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.formulaPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode sub_item */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->sub_item, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sub_itemPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode accumulate */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Accumulate (pctxt, 
               &pvalue->accumulate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.accumulatePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode additive */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Additive (pctxt, 
               &pvalue->additive, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.additivePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode attributeName */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_AttributeName (pctxt, 
               &pvalue->attributeName, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode by */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_By (pctxt, 
               &pvalue->by, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.byPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode calcMode */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_CalcMode (pctxt, 
               &pvalue->calcMode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.calcModePresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode fill */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Fill (pctxt, 
               &pvalue->fill, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fillPresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode from */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_From (pctxt, 
               &pvalue->from, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fromPresent = TRUE;
            }
         }
         break;

      case 9:
         /* decode keySplines */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_KeySplines (pctxt, 
               &pvalue->keySplines, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.keySplinesPresent = TRUE;
            }
         }
         break;

      case 10:
         /* decode keyTimes */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_KeyTimes (pctxt, 
               &pvalue->keyTimes, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.keyTimesPresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode targetElement */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_TargetElement (pctxt, 
               &pvalue->targetElement, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.targetElementPresent = TRUE;
            }
         }
         break;

      case 12:
         /* decode to */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_To (pctxt, 
               &pvalue->to, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.toPresent = TRUE;
            }
         }
         break;

      case 13:
         /* decode values */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Values (pctxt, 
               &pvalue->values, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.valuesPresent = TRUE;
            }
         }
         break;

      case 14:
         /* decode origin */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Origin (pctxt, 
               (Origin*)&pvalue->origin, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.originPresent = TRUE;
            }
         }
         break;

      case 15:
         /* decode path */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns12_Path (pctxt, 
               (Ns12_Path*)&pvalue->path, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.pathPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_PRIM|11):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_PRIM|13):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_PRIM|14):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_PRIM|15):
         case (TM_CTXT|TM_CONS|15):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AnimateMotion (OSCTXT* pctxt, AnimateMotion* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("formula"), 7}, 0 },
         { {OSUTF8("sub-item"), 8}, 0 },
         { {OSUTF8("accumulate"), 10}, 0 },
         { {OSUTF8("additive"), 8}, 0 },
         { {OSUTF8("attributeName"), 13}, 0 },
         { {OSUTF8("by"), 2}, 0 },
         { {OSUTF8("calcMode"), 8}, 0 },
         { {OSUTF8("fill"), 4}, 0 },
         { {OSUTF8("from"), 4}, 0 },
         { {OSUTF8("keySplines"), 10}, 0 },
         { {OSUTF8("keyTimes"), 8}, 0 },
         { {OSUTF8("targetElement"), 13}, 0 },
         { {OSUTF8("to"), 2}, 0 },
         { {OSUTF8("values"), 6}, 0 },
         { {OSUTF8("origin"), 6}, 0 },
         { {OSUTF8("path"), 4}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 16, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* formula */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->formula);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.formulaPresent = TRUE;
            break;

         case 1: /* sub-item */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->sub_item);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.sub_itemPresent = TRUE;
            break;

         case 2: /* accumulate */
            stat = XmlDec_Ns11_Accumulate (pctxt, &pvalue->accumulate);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.accumulatePresent = TRUE;
            break;

         case 3: /* additive */
            stat = XmlDec_Ns11_Additive (pctxt, &pvalue->additive);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.additivePresent = TRUE;
            break;

         case 4: /* attributeName */
            stat = XmlDec_Ns11_AttributeName (pctxt, &pvalue->attributeName);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 5: /* by */
            stat = XmlDec_Ns11_By (pctxt, &pvalue->by);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.byPresent = TRUE;
            break;

         case 6: /* calcMode */
            stat = XmlDec_Ns11_CalcMode (pctxt, &pvalue->calcMode);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.calcModePresent = TRUE;
            break;

         case 7: /* fill */
            stat = XmlDec_Ns11_Fill (pctxt, &pvalue->fill);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fillPresent = TRUE;
            break;

         case 8: /* from */
            stat = XmlDec_Ns11_From (pctxt, &pvalue->from);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fromPresent = TRUE;
            break;

         case 9: /* keySplines */
            stat = XmlDec_Ns11_KeySplines (pctxt, &pvalue->keySplines);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.keySplinesPresent = TRUE;
            break;

         case 10: /* keyTimes */
            stat = XmlDec_Ns11_KeyTimes (pctxt, &pvalue->keyTimes);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.keyTimesPresent = TRUE;
            break;

         case 11: /* targetElement */
            stat = XmlDec_Ns11_TargetElement (pctxt, &pvalue->targetElement);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.targetElementPresent = TRUE;
            break;

         case 12: /* to */
            stat = XmlDec_Ns11_To (pctxt, &pvalue->to);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.toPresent = TRUE;
            break;

         case 13: /* values */
            stat = XmlDec_Ns11_Values (pctxt, &pvalue->values);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.valuesPresent = TRUE;
            break;

         case 14: /* origin */
            stat = XmlDec_Origin (pctxt, &pvalue->origin);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.originPresent = TRUE;
            break;

         case 15: /* path */
            stat = XmlDec_Ns12_Path (pctxt, &pvalue->path);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.pathPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "AnimateMotion");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "AnimateMotion");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AnimateColor_color_interpolation                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AnimateColor_color_interpolation (OSCTXT* pctxt, 
   AnimateColor_color_interpolation *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_AnimateColor_color_interpolation (OSCTXT* pctxt, 
   AnimateColor_color_interpolation* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = AnimateColor_color_interpolation_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AnimateColor_color_interpolation_direction                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AnimateColor_color_interpolation_direction (OSCTXT* pctxt, 
   AnimateColor_color_interpolation_direction *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_AnimateColor_color_interpolation_direction (OSCTXT* pctxt, 
   AnimateColor_color_interpolation_direction* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = AnimateColor_color_interpolation_direction_ToEnum (pctxt, strval, 
      pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AnimateColor                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AnimateColor (OSCTXT* pctxt, AnimateColor *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode color_interpolation */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AnimateColor_color_interpolation (pctxt, 
               &pvalue->color_interpolation, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.color_interpolationPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode color_interpolation_direction */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AnimateColor_color_interpolation_direction (pctxt, 
               &pvalue->color_interpolation_direction, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.color_interpolation_directionPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode formula */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->formula, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.formulaPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode sub_item */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->sub_item, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sub_itemPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode accumulate */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Accumulate (pctxt, 
               &pvalue->accumulate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.accumulatePresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode additive */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Additive (pctxt, 
               &pvalue->additive, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.additivePresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode attributeName */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_AttributeName (pctxt, 
               &pvalue->attributeName, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode by */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_By (pctxt, 
               &pvalue->by, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.byPresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode calcMode */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_CalcMode (pctxt, 
               &pvalue->calcMode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.calcModePresent = TRUE;
            }
         }
         break;

      case 9:
         /* decode fill */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Fill (pctxt, 
               &pvalue->fill, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fillPresent = TRUE;
            }
         }
         break;

      case 10:
         /* decode from */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_From (pctxt, 
               &pvalue->from, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fromPresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode keySplines */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_KeySplines (pctxt, 
               &pvalue->keySplines, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.keySplinesPresent = TRUE;
            }
         }
         break;

      case 12:
         /* decode keyTimes */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_KeyTimes (pctxt, 
               &pvalue->keyTimes, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.keyTimesPresent = TRUE;
            }
         }
         break;

      case 13:
         /* decode targetElement */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_TargetElement (pctxt, 
               &pvalue->targetElement, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.targetElementPresent = TRUE;
            }
         }
         break;

      case 14:
         /* decode to */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_To (pctxt, 
               &pvalue->to, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.toPresent = TRUE;
            }
         }
         break;

      case 15:
         /* decode values */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Values (pctxt, 
               &pvalue->values, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.valuesPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_PRIM|11):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_PRIM|13):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_PRIM|14):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_PRIM|15):
         case (TM_CTXT|TM_CONS|15):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AnimateColor (OSCTXT* pctxt, AnimateColor* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("color-interpolation"), 19}, 0 },
         { {OSUTF8("color-interpolation-direction"), 29}, 0 },
         { {OSUTF8("formula"), 7}, 0 },
         { {OSUTF8("sub-item"), 8}, 0 },
         { {OSUTF8("accumulate"), 10}, 0 },
         { {OSUTF8("additive"), 8}, 0 },
         { {OSUTF8("attributeName"), 13}, 0 },
         { {OSUTF8("by"), 2}, 0 },
         { {OSUTF8("calcMode"), 8}, 0 },
         { {OSUTF8("fill"), 4}, 0 },
         { {OSUTF8("from"), 4}, 0 },
         { {OSUTF8("keySplines"), 10}, 0 },
         { {OSUTF8("keyTimes"), 8}, 0 },
         { {OSUTF8("targetElement"), 13}, 0 },
         { {OSUTF8("to"), 2}, 0 },
         { {OSUTF8("values"), 6}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 16, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* color-interpolation */
            stat = XmlDec_AnimateColor_color_interpolation (pctxt, &pvalue->
               color_interpolation);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.color_interpolationPresent = TRUE;
            break;

         case 1: /* color-interpolation-direction */
            stat = XmlDec_AnimateColor_color_interpolation_direction (pctxt, &
               pvalue->color_interpolation_direction);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.color_interpolation_directionPresent = TRUE;
            break;

         case 2: /* formula */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->formula);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.formulaPresent = TRUE;
            break;

         case 3: /* sub-item */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->sub_item);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.sub_itemPresent = TRUE;
            break;

         case 4: /* accumulate */
            stat = XmlDec_Ns11_Accumulate (pctxt, &pvalue->accumulate);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.accumulatePresent = TRUE;
            break;

         case 5: /* additive */
            stat = XmlDec_Ns11_Additive (pctxt, &pvalue->additive);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.additivePresent = TRUE;
            break;

         case 6: /* attributeName */
            stat = XmlDec_Ns11_AttributeName (pctxt, &pvalue->attributeName);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 7: /* by */
            stat = XmlDec_Ns11_By (pctxt, &pvalue->by);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.byPresent = TRUE;
            break;

         case 8: /* calcMode */
            stat = XmlDec_Ns11_CalcMode (pctxt, &pvalue->calcMode);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.calcModePresent = TRUE;
            break;

         case 9: /* fill */
            stat = XmlDec_Ns11_Fill (pctxt, &pvalue->fill);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fillPresent = TRUE;
            break;

         case 10: /* from */
            stat = XmlDec_Ns11_From (pctxt, &pvalue->from);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fromPresent = TRUE;
            break;

         case 11: /* keySplines */
            stat = XmlDec_Ns11_KeySplines (pctxt, &pvalue->keySplines);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.keySplinesPresent = TRUE;
            break;

         case 12: /* keyTimes */
            stat = XmlDec_Ns11_KeyTimes (pctxt, &pvalue->keyTimes);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.keyTimesPresent = TRUE;
            break;

         case 13: /* targetElement */
            stat = XmlDec_Ns11_TargetElement (pctxt, &pvalue->targetElement);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.targetElementPresent = TRUE;
            break;

         case 14: /* to */
            stat = XmlDec_Ns11_To (pctxt, &pvalue->to);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.toPresent = TRUE;
            break;

         case 15: /* values */
            stat = XmlDec_Ns11_Values (pctxt, &pvalue->values);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.valuesPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "AnimateColor");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "AnimateColor");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AnimateTransform                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AnimateTransform (OSCTXT* pctxt, AnimateTransform *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode formula */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->formula, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.formulaPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode sub_item */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->sub_item, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sub_itemPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode accumulate */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Accumulate (pctxt, 
               &pvalue->accumulate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.accumulatePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode additive */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Additive (pctxt, 
               &pvalue->additive, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.additivePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode attributeName */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_AttributeName (pctxt, 
               &pvalue->attributeName, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode by */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_By (pctxt, 
               &pvalue->by, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.byPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode fill */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Fill (pctxt, 
               &pvalue->fill, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fillPresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode from */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_From (pctxt, 
               &pvalue->from, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fromPresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode targetElement */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_TargetElement (pctxt, 
               &pvalue->targetElement, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.targetElementPresent = TRUE;
            }
         }
         break;

      case 9:
         /* decode to */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_To (pctxt, 
               &pvalue->to, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.toPresent = TRUE;
            }
         }
         break;

      case 10:
         /* decode values */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Values (pctxt, 
               &pvalue->values, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.valuesPresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode type */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns12_Type (pctxt, 
               (Ns12_Type*)&pvalue->type, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_PRIM|11):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AnimateTransform (OSCTXT* pctxt, AnimateTransform* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("formula"), 7}, 0 },
         { {OSUTF8("sub-item"), 8}, 0 },
         { {OSUTF8("accumulate"), 10}, 0 },
         { {OSUTF8("additive"), 8}, 0 },
         { {OSUTF8("attributeName"), 13}, 0 },
         { {OSUTF8("by"), 2}, 0 },
         { {OSUTF8("fill"), 4}, 0 },
         { {OSUTF8("from"), 4}, 0 },
         { {OSUTF8("targetElement"), 13}, 0 },
         { {OSUTF8("to"), 2}, 0 },
         { {OSUTF8("values"), 6}, 0 },
         { {OSUTF8("type"), 4}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 12, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* formula */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->formula);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.formulaPresent = TRUE;
            break;

         case 1: /* sub-item */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->sub_item);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.sub_itemPresent = TRUE;
            break;

         case 2: /* accumulate */
            stat = XmlDec_Ns11_Accumulate (pctxt, &pvalue->accumulate);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.accumulatePresent = TRUE;
            break;

         case 3: /* additive */
            stat = XmlDec_Ns11_Additive (pctxt, &pvalue->additive);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.additivePresent = TRUE;
            break;

         case 4: /* attributeName */
            stat = XmlDec_Ns11_AttributeName (pctxt, &pvalue->attributeName);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 5: /* by */
            stat = XmlDec_Ns11_By (pctxt, &pvalue->by);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.byPresent = TRUE;
            break;

         case 6: /* fill */
            stat = XmlDec_Ns11_Fill (pctxt, &pvalue->fill);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fillPresent = TRUE;
            break;

         case 7: /* from */
            stat = XmlDec_Ns11_From (pctxt, &pvalue->from);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fromPresent = TRUE;
            break;

         case 8: /* targetElement */
            stat = XmlDec_Ns11_TargetElement (pctxt, &pvalue->targetElement);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.targetElementPresent = TRUE;
            break;

         case 9: /* to */
            stat = XmlDec_Ns11_To (pctxt, &pvalue->to);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.toPresent = TRUE;
            break;

         case 10: /* values */
            stat = XmlDec_Ns11_Values (pctxt, &pvalue->values);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.valuesPresent = TRUE;
            break;

         case 11: /* type */
            stat = XmlDec_Ns12_Type (pctxt, &pvalue->type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "AnimateTransform");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "AnimateTransform");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransitionFilter                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TransitionFilter (OSCTXT* pctxt, TransitionFilter *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode formula */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->formula, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.formulaPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode sub_item */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->sub_item, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sub_itemPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode accumulate */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Accumulate (pctxt, 
               &pvalue->accumulate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.accumulatePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode additive */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Additive (pctxt, 
               &pvalue->additive, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.additivePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode by */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_By (pctxt, 
               &pvalue->by, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.byPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode calcMode */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_CalcMode (pctxt, 
               &pvalue->calcMode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.calcModePresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode direction */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Direction (pctxt, 
               &pvalue->direction, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.directionPresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode fadeColor */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_FadeColor (pctxt, 
               &pvalue->fadeColor, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fadeColorPresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode fill */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Fill (pctxt, 
               &pvalue->fill, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fillPresent = TRUE;
            }
         }
         break;

      case 9:
         /* decode from */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_From (pctxt, 
               &pvalue->from, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fromPresent = TRUE;
            }
         }
         break;

      case 10:
         /* decode mode */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Mode (pctxt, 
               &pvalue->mode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.modePresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode subtype */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Subtype (pctxt, 
               &pvalue->subtype, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.subtypePresent = TRUE;
            }
         }
         break;

      case 12:
         /* decode targetElement */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_TargetElement (pctxt, 
               &pvalue->targetElement, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.targetElementPresent = TRUE;
            }
         }
         break;

      case 13:
         /* decode to */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_To (pctxt, 
               &pvalue->to, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.toPresent = TRUE;
            }
         }
         break;

      case 14:
         /* decode type */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Type (pctxt, 
               &pvalue->type, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 15:
         /* decode values */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Values (pctxt, 
               &pvalue->values, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.valuesPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_PRIM|11):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_PRIM|13):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_PRIM|14):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_PRIM|15):
         case (TM_CTXT|TM_CONS|15):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_TransitionFilter (OSCTXT* pctxt, TransitionFilter* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("formula"), 7}, 0 },
         { {OSUTF8("sub-item"), 8}, 0 },
         { {OSUTF8("accumulate"), 10}, 0 },
         { {OSUTF8("additive"), 8}, 0 },
         { {OSUTF8("by"), 2}, 0 },
         { {OSUTF8("calcMode"), 8}, 0 },
         { {OSUTF8("direction"), 9}, 0 },
         { {OSUTF8("fadeColor"), 9}, 0 },
         { {OSUTF8("fill"), 4}, 0 },
         { {OSUTF8("from"), 4}, 0 },
         { {OSUTF8("mode"), 4}, 0 },
         { {OSUTF8("subtype"), 7}, 0 },
         { {OSUTF8("targetElement"), 13}, 0 },
         { {OSUTF8("to"), 2}, 0 },
         { {OSUTF8("type"), 4}, 0 },
         { {OSUTF8("values"), 6}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 16, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* formula */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->formula);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.formulaPresent = TRUE;
            break;

         case 1: /* sub-item */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->sub_item);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.sub_itemPresent = TRUE;
            break;

         case 2: /* accumulate */
            stat = XmlDec_Ns11_Accumulate (pctxt, &pvalue->accumulate);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.accumulatePresent = TRUE;
            break;

         case 3: /* additive */
            stat = XmlDec_Ns11_Additive (pctxt, &pvalue->additive);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.additivePresent = TRUE;
            break;

         case 4: /* by */
            stat = XmlDec_Ns11_By (pctxt, &pvalue->by);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.byPresent = TRUE;
            break;

         case 5: /* calcMode */
            stat = XmlDec_Ns11_CalcMode (pctxt, &pvalue->calcMode);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.calcModePresent = TRUE;
            break;

         case 6: /* direction */
            stat = XmlDec_Ns11_Direction (pctxt, &pvalue->direction);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.directionPresent = TRUE;
            break;

         case 7: /* fadeColor */
            stat = XmlDec_Ns11_FadeColor (pctxt, &pvalue->fadeColor);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fadeColorPresent = TRUE;
            break;

         case 8: /* fill */
            stat = XmlDec_Ns11_Fill (pctxt, &pvalue->fill);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fillPresent = TRUE;
            break;

         case 9: /* from */
            stat = XmlDec_Ns11_From (pctxt, &pvalue->from);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fromPresent = TRUE;
            break;

         case 10: /* mode */
            stat = XmlDec_Ns11_Mode (pctxt, &pvalue->mode);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.modePresent = TRUE;
            break;

         case 11: /* subtype */
            stat = XmlDec_Ns11_Subtype (pctxt, &pvalue->subtype);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.subtypePresent = TRUE;
            break;

         case 12: /* targetElement */
            stat = XmlDec_Ns11_TargetElement (pctxt, &pvalue->targetElement);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.targetElementPresent = TRUE;
            break;

         case 13: /* to */
            stat = XmlDec_Ns11_To (pctxt, &pvalue->to);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.toPresent = TRUE;
            break;

         case 14: /* type */
            stat = XmlDec_Ns11_Type (pctxt, &pvalue->type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 15: /* values */
            stat = XmlDec_Ns11_Values (pctxt, &pvalue->values);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.valuesPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "TransitionFilter");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "TransitionFilter");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Seq                                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Seq (OSCTXT* pctxt, Seq *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode group_id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Group_id (pctxt, 
               (Ns10_Group_id*)&pvalue->group_id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.group_idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode master_element */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Master_element (pctxt, 
               (Ns10_Master_element*)&pvalue->master_element, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.master_elementPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode node_type */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Node_type (pctxt, 
               (Ns10_Node_type*)&pvalue->node_type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.node_typePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode preset_class */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_class (pctxt, 
               (Ns10_Preset_class*)&pvalue->preset_class, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_classPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode preset_id */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_id (pctxt, 
               (Ns10_Preset_id*)&pvalue->preset_id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_idPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode preset_sub_type */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_sub_type (pctxt, 
               (Ns10_Preset_sub_type*)&pvalue->preset_sub_type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_sub_typePresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode accelerate */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Accelerate (pctxt, 
               &pvalue->accelerate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.acceleratePresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode autoReverse */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_AutoReverse (pctxt, 
               &pvalue->autoReverse, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.autoReversePresent = TRUE;
            }
         }
         break;

      case 9:
         /* decode begin */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Begin (pctxt, 
               &pvalue->begin, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.beginPresent = TRUE;
            }
         }
         break;

      case 10:
         /* decode decelerate */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Decelerate (pctxt, 
               &pvalue->decelerate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.deceleratePresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode dur */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Dur (pctxt, 
               &pvalue->dur, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.durPresent = TRUE;
            }
         }
         break;

      case 12:
         /* decode end */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_End (pctxt, 
               &pvalue->end, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.endPresent = TRUE;
            }
         }
         break;

      case 13:
         /* decode endsync */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Endsync (pctxt, 
               &pvalue->endsync, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.endsyncPresent = TRUE;
            }
         }
         break;

      case 14:
         /* decode fill */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Fill (pctxt, 
               &pvalue->fill, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fillPresent = TRUE;
            }
         }
         break;

      case 15:
         /* decode fillDefault */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_FillDefault (pctxt, 
               &pvalue->fillDefault, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fillDefaultPresent = TRUE;
            }
         }
         break;

      case 16:
         /* decode repeatCount */
         if (XD_PEEKTAG (pctxt, 0x90)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_RepeatCount (pctxt, 
               &pvalue->repeatCount, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.repeatCountPresent = TRUE;
            }
         }
         break;

      case 17:
         /* decode repeatDur */
         if (XD_PEEKTAG (pctxt, 0x91)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_RepeatDur (pctxt, 
               &pvalue->repeatDur, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.repeatDurPresent = TRUE;
            }
         }
         break;

      case 18:
         /* decode restart */
         if (XD_PEEKTAG (pctxt, 0x92)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Restart (pctxt, 
               &pvalue->restart, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.restartPresent = TRUE;
            }
         }
         break;

      case 19:
         /* decode restartDefault */
         if (XD_PEEKTAG (pctxt, 0x93)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_RestartDefault (pctxt, 
               &pvalue->restartDefault, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.restartDefaultPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_PRIM|11):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_PRIM|13):
         case (TM_CTXT|TM_PRIM|14):
         case (TM_CTXT|TM_PRIM|15):
         case (TM_CTXT|TM_PRIM|16):
         case (TM_CTXT|TM_PRIM|17):
         case (TM_CTXT|TM_CONS|17):
         case (TM_CTXT|TM_PRIM|18):
         case (TM_CTXT|TM_PRIM|19):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Seq (OSCTXT* pctxt, Seq* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("group-id"), 8}, 0 },
         { {OSUTF8("master-element"), 14}, 0 },
         { {OSUTF8("node-type"), 9}, 0 },
         { {OSUTF8("preset-class"), 12}, 0 },
         { {OSUTF8("preset-id"), 9}, 0 },
         { {OSUTF8("preset-sub-type"), 15}, 0 },
         { {OSUTF8("accelerate"), 10}, 0 },
         { {OSUTF8("autoReverse"), 11}, 0 },
         { {OSUTF8("begin"), 5}, 0 },
         { {OSUTF8("decelerate"), 10}, 0 },
         { {OSUTF8("dur"), 3}, 0 },
         { {OSUTF8("end"), 3}, 0 },
         { {OSUTF8("endsync"), 7}, 0 },
         { {OSUTF8("fill"), 4}, 0 },
         { {OSUTF8("fillDefault"), 11}, 0 },
         { {OSUTF8("repeatCount"), 11}, 0 },
         { {OSUTF8("repeatDur"), 9}, 0 },
         { {OSUTF8("restart"), 7}, 0 },
         { {OSUTF8("restartDefault"), 14}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 20, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 1: /* group-id */
            stat = XmlDec_Ns10_Group_id (pctxt, &pvalue->group_id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.group_idPresent = TRUE;
            break;

         case 2: /* master-element */
            stat = XmlDec_Ns10_Master_element (pctxt, &pvalue->master_element
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.master_elementPresent = TRUE;
            break;

         case 3: /* node-type */
            stat = XmlDec_Ns10_Node_type (pctxt, &pvalue->node_type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.node_typePresent = TRUE;
            break;

         case 4: /* preset-class */
            stat = XmlDec_Ns10_Preset_class (pctxt, &pvalue->preset_class);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_classPresent = TRUE;
            break;

         case 5: /* preset-id */
            stat = XmlDec_Ns10_Preset_id (pctxt, &pvalue->preset_id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_idPresent = TRUE;
            break;

         case 6: /* preset-sub-type */
            stat = XmlDec_Ns10_Preset_sub_type (pctxt, &pvalue->preset_sub_type
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_sub_typePresent = TRUE;
            break;

         case 7: /* accelerate */
            stat = XmlDec_Ns11_Accelerate (pctxt, &pvalue->accelerate);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.acceleratePresent = TRUE;
            break;

         case 8: /* autoReverse */
            stat = XmlDec_Ns11_AutoReverse (pctxt, &pvalue->autoReverse);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.autoReversePresent = TRUE;
            break;

         case 9: /* begin */
            stat = XmlDec_Ns11_Begin (pctxt, &pvalue->begin);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.beginPresent = TRUE;
            break;

         case 10: /* decelerate */
            stat = XmlDec_Ns11_Decelerate (pctxt, &pvalue->decelerate);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.deceleratePresent = TRUE;
            break;

         case 11: /* dur */
            stat = XmlDec_Ns11_Dur (pctxt, &pvalue->dur);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.durPresent = TRUE;
            break;

         case 12: /* end */
            stat = XmlDec_Ns11_End (pctxt, &pvalue->end);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.endPresent = TRUE;
            break;

         case 13: /* endsync */
            stat = XmlDec_Ns11_Endsync (pctxt, &pvalue->endsync);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.endsyncPresent = TRUE;
            break;

         case 14: /* fill */
            stat = XmlDec_Ns11_Fill (pctxt, &pvalue->fill);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fillPresent = TRUE;
            break;

         case 15: /* fillDefault */
            stat = XmlDec_Ns11_FillDefault (pctxt, &pvalue->fillDefault);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fillDefaultPresent = TRUE;
            break;

         case 16: /* repeatCount */
            stat = XmlDec_Ns11_RepeatCount (pctxt, &pvalue->repeatCount);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.repeatCountPresent = TRUE;
            break;

         case 17: /* repeatDur */
            stat = XmlDec_Ns11_RepeatDur (pctxt, &pvalue->repeatDur);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.repeatDurPresent = TRUE;
            break;

         case 18: /* restart */
            stat = XmlDec_Ns11_Restart (pctxt, &pvalue->restart);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.restartPresent = TRUE;
            break;

         case 19: /* restartDefault */
            stat = XmlDec_Ns11_RestartDefault (pctxt, &pvalue->restartDefault
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.restartDefaultPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Seq");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Seq");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Audio                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Audio (OSCTXT* pctxt, Audio *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode href */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Xlink_Href (pctxt, 
               &pvalue->href, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.hrefPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode audio_level */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->audio_level, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.audio_levelPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode group_id */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Group_id (pctxt, 
               (Ns10_Group_id*)&pvalue->group_id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.group_idPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode master_element */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Master_element (pctxt, 
               (Ns10_Master_element*)&pvalue->master_element, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.master_elementPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode node_type */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Node_type (pctxt, 
               (Ns10_Node_type*)&pvalue->node_type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.node_typePresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode preset_class */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_class (pctxt, 
               (Ns10_Preset_class*)&pvalue->preset_class, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_classPresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode preset_id */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_id (pctxt, 
               (Ns10_Preset_id*)&pvalue->preset_id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_idPresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode preset_sub_type */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_sub_type (pctxt, 
               (Ns10_Preset_sub_type*)&pvalue->preset_sub_type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_sub_typePresent = TRUE;
            }
         }
         break;

      case 9:
         /* decode begin */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Begin (pctxt, 
               &pvalue->begin, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.beginPresent = TRUE;
            }
         }
         break;

      case 10:
         /* decode dur */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Dur (pctxt, 
               &pvalue->dur, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.durPresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode end */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_End (pctxt, 
               &pvalue->end, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.endPresent = TRUE;
            }
         }
         break;

      case 12:
         /* decode repeatCount */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_RepeatCount (pctxt, 
               &pvalue->repeatCount, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.repeatCountPresent = TRUE;
            }
         }
         break;

      case 13:
         /* decode repeatDur */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_RepeatDur (pctxt, 
               &pvalue->repeatDur, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.repeatDurPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_PRIM|11):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_PRIM|13):
         case (TM_CTXT|TM_CONS|13):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Audio (OSCTXT* pctxt, Audio* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("href"), 4}, 0 },
         { {OSUTF8("audio-level"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("group-id"), 8}, 0 },
         { {OSUTF8("master-element"), 14}, 0 },
         { {OSUTF8("node-type"), 9}, 0 },
         { {OSUTF8("preset-class"), 12}, 0 },
         { {OSUTF8("preset-id"), 9}, 0 },
         { {OSUTF8("preset-sub-type"), 15}, 0 },
         { {OSUTF8("begin"), 5}, 0 },
         { {OSUTF8("dur"), 3}, 0 },
         { {OSUTF8("end"), 3}, 0 },
         { {OSUTF8("repeatCount"), 11}, 0 },
         { {OSUTF8("repeatDur"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 14, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* href */
            stat = XmlDec_Xlink_Href (pctxt, &pvalue->href);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.hrefPresent = TRUE;
            break;

         case 1: /* audio-level */
            stat = rtXmlpDecDouble (pctxt, &pvalue->audio_level, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.audio_levelPresent = TRUE;
            break;

         case 2: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 3: /* group-id */
            stat = XmlDec_Ns10_Group_id (pctxt, &pvalue->group_id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.group_idPresent = TRUE;
            break;

         case 4: /* master-element */
            stat = XmlDec_Ns10_Master_element (pctxt, &pvalue->master_element
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.master_elementPresent = TRUE;
            break;

         case 5: /* node-type */
            stat = XmlDec_Ns10_Node_type (pctxt, &pvalue->node_type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.node_typePresent = TRUE;
            break;

         case 6: /* preset-class */
            stat = XmlDec_Ns10_Preset_class (pctxt, &pvalue->preset_class);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_classPresent = TRUE;
            break;

         case 7: /* preset-id */
            stat = XmlDec_Ns10_Preset_id (pctxt, &pvalue->preset_id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_idPresent = TRUE;
            break;

         case 8: /* preset-sub-type */
            stat = XmlDec_Ns10_Preset_sub_type (pctxt, &pvalue->preset_sub_type
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_sub_typePresent = TRUE;
            break;

         case 9: /* begin */
            stat = XmlDec_Ns11_Begin (pctxt, &pvalue->begin);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.beginPresent = TRUE;
            break;

         case 10: /* dur */
            stat = XmlDec_Ns11_Dur (pctxt, &pvalue->dur);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.durPresent = TRUE;
            break;

         case 11: /* end */
            stat = XmlDec_Ns11_End (pctxt, &pvalue->end);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.endPresent = TRUE;
            break;

         case 12: /* repeatCount */
            stat = XmlDec_Ns11_RepeatCount (pctxt, &pvalue->repeatCount);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.repeatCountPresent = TRUE;
            break;

         case 13: /* repeatDur */
            stat = XmlDec_Ns11_RepeatDur (pctxt, &pvalue->repeatDur);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.repeatDurPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Audio");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Audio");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Param                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Param (OSCTXT* pctxt, Param *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Param (OSCTXT* pctxt, Param* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* name */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* value */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Param");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Param");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Command                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Command (OSCTXT* pctxt, Command *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode command */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->command, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode sub_item */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->sub_item, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sub_itemPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode group_id */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Group_id (pctxt, 
               (Ns10_Group_id*)&pvalue->group_id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.group_idPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode master_element */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Master_element (pctxt, 
               (Ns10_Master_element*)&pvalue->master_element, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.master_elementPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode node_type */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Node_type (pctxt, 
               (Ns10_Node_type*)&pvalue->node_type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.node_typePresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode preset_class */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_class (pctxt, 
               (Ns10_Preset_class*)&pvalue->preset_class, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_classPresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode preset_id */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_id (pctxt, 
               (Ns10_Preset_id*)&pvalue->preset_id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_idPresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode preset_sub_type */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_sub_type (pctxt, 
               (Ns10_Preset_sub_type*)&pvalue->preset_sub_type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_sub_typePresent = TRUE;
            }
         }
         break;

      case 9:
         /* decode begin */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Begin (pctxt, 
               &pvalue->begin, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.beginPresent = TRUE;
            }
         }
         break;

      case 10:
         /* decode end */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_End (pctxt, 
               &pvalue->end, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.endPresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode targetElement */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_TargetElement (pctxt, 
               &pvalue->targetElement, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.targetElementPresent = TRUE;
            }
         }
         break;

      case 12:
         /* decode param_list */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Param* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->param_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Param, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Param (pdata2);

                  stat = asn1D_Param (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->param_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_PRIM|11):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_CONS|12):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Command (OSCTXT* pctxt, Command* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("command"), 7}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("sub-item"), 8}, 0 },
         { {OSUTF8("group-id"), 8}, 0 },
         { {OSUTF8("master-element"), 14}, 0 },
         { {OSUTF8("node-type"), 9}, 0 },
         { {OSUTF8("preset-class"), 12}, 0 },
         { {OSUTF8("preset-id"), 9}, 0 },
         { {OSUTF8("preset-sub-type"), 15}, 0 },
         { {OSUTF8("begin"), 5}, 0 },
         { {OSUTF8("end"), 3}, 0 },
         { {OSUTF8("targetElement"), 13}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 12, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* command */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->command);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* sub-item */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->sub_item);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.sub_itemPresent = TRUE;
            break;

         case 3: /* group-id */
            stat = XmlDec_Ns10_Group_id (pctxt, &pvalue->group_id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.group_idPresent = TRUE;
            break;

         case 4: /* master-element */
            stat = XmlDec_Ns10_Master_element (pctxt, &pvalue->master_element
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.master_elementPresent = TRUE;
            break;

         case 5: /* node-type */
            stat = XmlDec_Ns10_Node_type (pctxt, &pvalue->node_type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.node_typePresent = TRUE;
            break;

         case 6: /* preset-class */
            stat = XmlDec_Ns10_Preset_class (pctxt, &pvalue->preset_class);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_classPresent = TRUE;
            break;

         case 7: /* preset-id */
            stat = XmlDec_Ns10_Preset_id (pctxt, &pvalue->preset_id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_idPresent = TRUE;
            break;

         case 8: /* preset-sub-type */
            stat = XmlDec_Ns10_Preset_sub_type (pctxt, &pvalue->preset_sub_type
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_sub_typePresent = TRUE;
            break;

         case 9: /* begin */
            stat = XmlDec_Ns11_Begin (pctxt, &pvalue->begin);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.beginPresent = TRUE;
            break;

         case 10: /* end */
            stat = XmlDec_Ns11_End (pctxt, &pvalue->end);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.endPresent = TRUE;
            break;

         case 11: /* targetElement */
            stat = XmlDec_Ns11_TargetElement (pctxt, &pvalue->targetElement);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.targetElementPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Command");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Command");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("param"), 5}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Param* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Param);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Param (pdata1);

            stat = XmlDec_Param (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->param_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Iterate_element                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Iterate_element (OSCTXT* pctxt, Iterate_element *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.animate = rtxMemAllocType (pctxt, Animate);

         if (pvalue->u.animate == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Animate (pvalue->u.animate);
         stat = asn1D_Animate (pctxt, 
            pvalue->u.animate, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.set = rtxMemAllocType (pctxt, Set);

         if (pvalue->u.set == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Set (pvalue->u.set);
         stat = asn1D_Set (pctxt, 
            pvalue->u.set, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.animateMotion = rtxMemAllocType (pctxt, AnimateMotion);

         if (pvalue->u.animateMotion == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_AnimateMotion (pvalue->u.animateMotion);
         stat = asn1D_AnimateMotion (pctxt, 
            pvalue->u.animateMotion, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.animateColor = rtxMemAllocType (pctxt, AnimateColor);

         if (pvalue->u.animateColor == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_AnimateColor (pvalue->u.animateColor);
         stat = asn1D_AnimateColor (pctxt, 
            pvalue->u.animateColor, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_CONS|4):
         pvalue->u.animateTransform
             = rtxMemAllocType (pctxt, AnimateTransform);

         if (pvalue->u.animateTransform == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_AnimateTransform (pvalue->u.animateTransform);
         stat = asn1D_AnimateTransform (pctxt, 
            pvalue->u.animateTransform, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_CONS|5):
         pvalue->u.transitionFilter
             = rtxMemAllocType (pctxt, TransitionFilter);

         if (pvalue->u.transitionFilter == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_TransitionFilter (pvalue->u.transitionFilter);
         stat = asn1D_TransitionFilter (pctxt, 
            pvalue->u.transitionFilter, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_CONS|6):
         pvalue->u.par = rtxMemAllocType (pctxt, Par);

         if (pvalue->u.par == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Par ((Par*)pvalue->u.par);
         stat = asn1D_Par (pctxt, 
            (Par*)pvalue->u.par, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_CONS|7):
         pvalue->u.seq = rtxMemAllocType (pctxt, Seq);

         if (pvalue->u.seq == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Seq (pvalue->u.seq);
         stat = asn1D_Seq (pctxt, 
            pvalue->u.seq, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_CONS|8):
         pvalue->u.iterate = rtxMemAllocType (pctxt, Iterate);

         if (pvalue->u.iterate == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Iterate ((Iterate*)pvalue->u.iterate);
         stat = asn1D_Iterate (pctxt, 
            (Iterate*)pvalue->u.iterate, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      case (TM_CTXT|TM_CONS|9):
         pvalue->u.audio = rtxMemAllocType (pctxt, Audio);

         if (pvalue->u.audio == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Audio (pvalue->u.audio);
         stat = asn1D_Audio (pctxt, 
            pvalue->u.audio, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 10;
         break;

      case (TM_CTXT|TM_CONS|10):
         pvalue->u.command = rtxMemAllocType (pctxt, Command);

         if (pvalue->u.command == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Command (pvalue->u.command);
         stat = asn1D_Command (pctxt, 
            pvalue->u.command, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 11;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Iterate_element (OSCTXT* pctxt, Iterate_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("animate"), 7}, 0}, 0 },
      {{{OSUTF8("set"), 3}, 0}, 1 },
      {{{OSUTF8("animateMotion"), 13}, 0}, 2 },
      {{{OSUTF8("animateColor"), 12}, 0}, 3 },
      {{{OSUTF8("animateTransform"), 16}, 0}, 4 },
      {{{OSUTF8("transitionFilter"), 16}, 0}, 5 },
      {{{OSUTF8("par"), 3}, 0}, 6 },
      {{{OSUTF8("seq"), 3}, 0}, 7 },
      {{{OSUTF8("iterate"), 7}, 0}, 8 },
      {{{OSUTF8("audio"), 5}, 0}, 9 },
      {{{OSUTF8("command"), 7}, 0}, 10 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 11, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* animate */
      pvalue->u.animate = rtxMemAllocType (pctxt, Animate);

      if (pvalue->u.animate == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Animate (pvalue->u.animate);

      stat = XmlDec_Animate (pctxt, pvalue->u.animate);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* set */
      pvalue->u.set = rtxMemAllocType (pctxt, Set);

      if (pvalue->u.set == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Set (pvalue->u.set);

      stat = XmlDec_Set (pctxt, pvalue->u.set);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* animateMotion */
      pvalue->u.animateMotion = rtxMemAllocType (pctxt, AnimateMotion);

      if (pvalue->u.animateMotion == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_AnimateMotion (pvalue->u.animateMotion);

      stat = XmlDec_AnimateMotion (pctxt, pvalue->u.animateMotion);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* animateColor */
      pvalue->u.animateColor = rtxMemAllocType (pctxt, AnimateColor);

      if (pvalue->u.animateColor == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_AnimateColor (pvalue->u.animateColor);

      stat = XmlDec_AnimateColor (pctxt, pvalue->u.animateColor);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 4: { /* animateTransform */
      pvalue->u.animateTransform = rtxMemAllocType (pctxt, AnimateTransform);

      if (pvalue->u.animateTransform == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_AnimateTransform (pvalue->u.animateTransform);

      stat = XmlDec_AnimateTransform (pctxt, pvalue->u.animateTransform);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 5: { /* transitionFilter */
      pvalue->u.transitionFilter = rtxMemAllocType (pctxt, TransitionFilter);

      if (pvalue->u.transitionFilter == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_TransitionFilter (pvalue->u.transitionFilter);

      stat = XmlDec_TransitionFilter (pctxt, pvalue->u.transitionFilter);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 6: { /* par */
      pvalue->u.par = rtxMemAllocType (pctxt, Par);

      if (pvalue->u.par == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Par ((Par*)pvalue->u.par);

      stat = XmlDec_Par (pctxt, pvalue->u.par);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 7: { /* seq */
      pvalue->u.seq = rtxMemAllocType (pctxt, Seq);

      if (pvalue->u.seq == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Seq (pvalue->u.seq);

      stat = XmlDec_Seq (pctxt, pvalue->u.seq);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 8: { /* iterate */
      pvalue->u.iterate = rtxMemAllocType (pctxt, Iterate);

      if (pvalue->u.iterate == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Iterate ((Iterate*)pvalue->u.iterate);

      stat = XmlDec_Iterate (pctxt, pvalue->u.iterate);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 9: { /* audio */
      pvalue->u.audio = rtxMemAllocType (pctxt, Audio);

      if (pvalue->u.audio == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Audio (pvalue->u.audio);

      stat = XmlDec_Audio (pctxt, pvalue->u.audio);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 10: { /* command */
      pvalue->u.command = rtxMemAllocType (pctxt, Command);

      if (pvalue->u.command == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Command (pvalue->u.command);

      stat = XmlDec_Command (pctxt, pvalue->u.command);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Iterate                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Iterate (OSCTXT* pctxt, Iterate *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode iterate_interval */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->iterate_interval, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.iterate_intervalPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode iterate_type */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->iterate_type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.iterate_typePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode group_id */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Group_id (pctxt, 
               (Ns10_Group_id*)&pvalue->group_id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.group_idPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode master_element */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Master_element (pctxt, 
               (Ns10_Master_element*)&pvalue->master_element, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.master_elementPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode node_type */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Node_type (pctxt, 
               (Ns10_Node_type*)&pvalue->node_type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.node_typePresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode preset_class */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_class (pctxt, 
               (Ns10_Preset_class*)&pvalue->preset_class, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_classPresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode preset_id */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_id (pctxt, 
               (Ns10_Preset_id*)&pvalue->preset_id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_idPresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode preset_sub_type */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_sub_type (pctxt, 
               (Ns10_Preset_sub_type*)&pvalue->preset_sub_type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_sub_typePresent = TRUE;
            }
         }
         break;

      case 9:
         /* decode accelerate */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Accelerate (pctxt, 
               &pvalue->accelerate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.acceleratePresent = TRUE;
            }
         }
         break;

      case 10:
         /* decode autoReverse */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_AutoReverse (pctxt, 
               &pvalue->autoReverse, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.autoReversePresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode begin */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Begin (pctxt, 
               &pvalue->begin, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.beginPresent = TRUE;
            }
         }
         break;

      case 12:
         /* decode decelerate */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Decelerate (pctxt, 
               &pvalue->decelerate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.deceleratePresent = TRUE;
            }
         }
         break;

      case 13:
         /* decode dur */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Dur (pctxt, 
               &pvalue->dur, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.durPresent = TRUE;
            }
         }
         break;

      case 14:
         /* decode end */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_End (pctxt, 
               &pvalue->end, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.endPresent = TRUE;
            }
         }
         break;

      case 15:
         /* decode endsync */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Endsync (pctxt, 
               &pvalue->endsync, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.endsyncPresent = TRUE;
            }
         }
         break;

      case 16:
         /* decode fill */
         if (XD_PEEKTAG (pctxt, 0x90)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Fill (pctxt, 
               &pvalue->fill, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fillPresent = TRUE;
            }
         }
         break;

      case 17:
         /* decode fillDefault */
         if (XD_PEEKTAG (pctxt, 0x91)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_FillDefault (pctxt, 
               &pvalue->fillDefault, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fillDefaultPresent = TRUE;
            }
         }
         break;

      case 18:
         /* decode repeatCount */
         if (XD_PEEKTAG (pctxt, 0x92)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_RepeatCount (pctxt, 
               &pvalue->repeatCount, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.repeatCountPresent = TRUE;
            }
         }
         break;

      case 19:
         /* decode repeatDur */
         if (XD_PEEKTAG (pctxt, 0x93)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_RepeatDur (pctxt, 
               &pvalue->repeatDur, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.repeatDurPresent = TRUE;
            }
         }
         break;

      case 20:
         /* decode restart */
         if (XD_PEEKTAG (pctxt, 0x94)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Restart (pctxt, 
               &pvalue->restart, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.restartPresent = TRUE;
            }
         }
         break;

      case 21:
         /* decode restartDefault */
         if (XD_PEEKTAG (pctxt, 0x95)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_RestartDefault (pctxt, 
               &pvalue->restartDefault, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.restartDefaultPresent = TRUE;
            }
         }
         break;

      case 22:
         /* decode targetElement */
         if (XD_PEEKTAG (pctxt, 0x96)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_TargetElement (pctxt, 
               &pvalue->targetElement, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.targetElementPresent = TRUE;
            }
         }
         break;

      case 23:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x97)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Iterate_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->choice_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Iterate_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Iterate_element (pdata2);

                  stat = asn1D_Iterate_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->choice_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_PRIM|11):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_PRIM|13):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_PRIM|14):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_PRIM|15):
         case (TM_CTXT|TM_PRIM|16):
         case (TM_CTXT|TM_PRIM|17):
         case (TM_CTXT|TM_PRIM|18):
         case (TM_CTXT|TM_PRIM|19):
         case (TM_CTXT|TM_CONS|19):
         case (TM_CTXT|TM_PRIM|20):
         case (TM_CTXT|TM_PRIM|21):
         case (TM_CTXT|TM_PRIM|22):
         case (TM_CTXT|TM_CONS|22):
         case (TM_CTXT|TM_CONS|23):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Iterate (OSCTXT* pctxt, Iterate* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("iterate-interval"), 16}, 0 },
         { {OSUTF8("iterate-type"), 12}, 0 },
         { {OSUTF8("group-id"), 8}, 0 },
         { {OSUTF8("master-element"), 14}, 0 },
         { {OSUTF8("node-type"), 9}, 0 },
         { {OSUTF8("preset-class"), 12}, 0 },
         { {OSUTF8("preset-id"), 9}, 0 },
         { {OSUTF8("preset-sub-type"), 15}, 0 },
         { {OSUTF8("accelerate"), 10}, 0 },
         { {OSUTF8("autoReverse"), 11}, 0 },
         { {OSUTF8("begin"), 5}, 0 },
         { {OSUTF8("decelerate"), 10}, 0 },
         { {OSUTF8("dur"), 3}, 0 },
         { {OSUTF8("end"), 3}, 0 },
         { {OSUTF8("endsync"), 7}, 0 },
         { {OSUTF8("fill"), 4}, 0 },
         { {OSUTF8("fillDefault"), 11}, 0 },
         { {OSUTF8("repeatCount"), 11}, 0 },
         { {OSUTF8("repeatDur"), 9}, 0 },
         { {OSUTF8("restart"), 7}, 0 },
         { {OSUTF8("restartDefault"), 14}, 0 },
         { {OSUTF8("targetElement"), 13}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 23, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 1: /* iterate-interval */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->iterate_interval);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.iterate_intervalPresent = TRUE;
            break;

         case 2: /* iterate-type */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->iterate_type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.iterate_typePresent = TRUE;
            break;

         case 3: /* group-id */
            stat = XmlDec_Ns10_Group_id (pctxt, &pvalue->group_id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.group_idPresent = TRUE;
            break;

         case 4: /* master-element */
            stat = XmlDec_Ns10_Master_element (pctxt, &pvalue->master_element
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.master_elementPresent = TRUE;
            break;

         case 5: /* node-type */
            stat = XmlDec_Ns10_Node_type (pctxt, &pvalue->node_type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.node_typePresent = TRUE;
            break;

         case 6: /* preset-class */
            stat = XmlDec_Ns10_Preset_class (pctxt, &pvalue->preset_class);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_classPresent = TRUE;
            break;

         case 7: /* preset-id */
            stat = XmlDec_Ns10_Preset_id (pctxt, &pvalue->preset_id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_idPresent = TRUE;
            break;

         case 8: /* preset-sub-type */
            stat = XmlDec_Ns10_Preset_sub_type (pctxt, &pvalue->preset_sub_type
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_sub_typePresent = TRUE;
            break;

         case 9: /* accelerate */
            stat = XmlDec_Ns11_Accelerate (pctxt, &pvalue->accelerate);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.acceleratePresent = TRUE;
            break;

         case 10: /* autoReverse */
            stat = XmlDec_Ns11_AutoReverse (pctxt, &pvalue->autoReverse);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.autoReversePresent = TRUE;
            break;

         case 11: /* begin */
            stat = XmlDec_Ns11_Begin (pctxt, &pvalue->begin);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.beginPresent = TRUE;
            break;

         case 12: /* decelerate */
            stat = XmlDec_Ns11_Decelerate (pctxt, &pvalue->decelerate);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.deceleratePresent = TRUE;
            break;

         case 13: /* dur */
            stat = XmlDec_Ns11_Dur (pctxt, &pvalue->dur);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.durPresent = TRUE;
            break;

         case 14: /* end */
            stat = XmlDec_Ns11_End (pctxt, &pvalue->end);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.endPresent = TRUE;
            break;

         case 15: /* endsync */
            stat = XmlDec_Ns11_Endsync (pctxt, &pvalue->endsync);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.endsyncPresent = TRUE;
            break;

         case 16: /* fill */
            stat = XmlDec_Ns11_Fill (pctxt, &pvalue->fill);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fillPresent = TRUE;
            break;

         case 17: /* fillDefault */
            stat = XmlDec_Ns11_FillDefault (pctxt, &pvalue->fillDefault);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fillDefaultPresent = TRUE;
            break;

         case 18: /* repeatCount */
            stat = XmlDec_Ns11_RepeatCount (pctxt, &pvalue->repeatCount);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.repeatCountPresent = TRUE;
            break;

         case 19: /* repeatDur */
            stat = XmlDec_Ns11_RepeatDur (pctxt, &pvalue->repeatDur);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.repeatDurPresent = TRUE;
            break;

         case 20: /* restart */
            stat = XmlDec_Ns11_Restart (pctxt, &pvalue->restart);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.restartPresent = TRUE;
            break;

         case 21: /* restartDefault */
            stat = XmlDec_Ns11_RestartDefault (pctxt, &pvalue->restartDefault
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.restartDefaultPresent = TRUE;
            break;

         case 22: /* targetElement */
            stat = XmlDec_Ns11_TargetElement (pctxt, &pvalue->targetElement);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.targetElementPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Iterate");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Iterate");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("animate"), 7}, 0}, 0 },
      {{{OSUTF8("set"), 3}, 0}, 0 },
      {{{OSUTF8("animateMotion"), 13}, 0}, 0 },
      {{{OSUTF8("animateColor"), 12}, 0}, 0 },
      {{{OSUTF8("animateTransform"), 16}, 0}, 0 },
      {{{OSUTF8("transitionFilter"), 16}, 0}, 0 },
      {{{OSUTF8("par"), 3}, 0}, 0 },
      {{{OSUTF8("seq"), 3}, 0}, 0 },
      {{{OSUTF8("iterate"), 7}, 0}, 0 },
      {{{OSUTF8("audio"), 5}, 0}, 0 },
      {{{OSUTF8("command"), 7}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 11, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Iterate_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Iterate_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Iterate_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_Iterate_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->choice_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 11, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Par_element                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Par_element (OSCTXT* pctxt, Par_element *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.animate = rtxMemAllocType (pctxt, Animate);

         if (pvalue->u.animate == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Animate (pvalue->u.animate);
         stat = asn1D_Animate (pctxt, 
            pvalue->u.animate, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.set = rtxMemAllocType (pctxt, Set);

         if (pvalue->u.set == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Set (pvalue->u.set);
         stat = asn1D_Set (pctxt, 
            pvalue->u.set, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.animateMotion = rtxMemAllocType (pctxt, AnimateMotion);

         if (pvalue->u.animateMotion == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_AnimateMotion (pvalue->u.animateMotion);
         stat = asn1D_AnimateMotion (pctxt, 
            pvalue->u.animateMotion, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.animateColor = rtxMemAllocType (pctxt, AnimateColor);

         if (pvalue->u.animateColor == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_AnimateColor (pvalue->u.animateColor);
         stat = asn1D_AnimateColor (pctxt, 
            pvalue->u.animateColor, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_CONS|4):
         pvalue->u.animateTransform
             = rtxMemAllocType (pctxt, AnimateTransform);

         if (pvalue->u.animateTransform == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_AnimateTransform (pvalue->u.animateTransform);
         stat = asn1D_AnimateTransform (pctxt, 
            pvalue->u.animateTransform, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_CONS|5):
         pvalue->u.transitionFilter
             = rtxMemAllocType (pctxt, TransitionFilter);

         if (pvalue->u.transitionFilter == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_TransitionFilter (pvalue->u.transitionFilter);
         stat = asn1D_TransitionFilter (pctxt, 
            pvalue->u.transitionFilter, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_CONS|6):
         pvalue->u.par = rtxMemAllocType (pctxt, Par);

         if (pvalue->u.par == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Par ((Par*)pvalue->u.par);
         stat = asn1D_Par (pctxt, 
            (Par*)pvalue->u.par, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_CONS|7):
         pvalue->u.seq = rtxMemAllocType (pctxt, Seq);

         if (pvalue->u.seq == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Seq (pvalue->u.seq);
         stat = asn1D_Seq (pctxt, 
            pvalue->u.seq, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_CONS|8):
         pvalue->u.iterate = rtxMemAllocType (pctxt, Iterate);

         if (pvalue->u.iterate == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Iterate (pvalue->u.iterate);
         stat = asn1D_Iterate (pctxt, 
            pvalue->u.iterate, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      case (TM_CTXT|TM_CONS|9):
         pvalue->u.audio = rtxMemAllocType (pctxt, Audio);

         if (pvalue->u.audio == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Audio (pvalue->u.audio);
         stat = asn1D_Audio (pctxt, 
            pvalue->u.audio, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 10;
         break;

      case (TM_CTXT|TM_CONS|10):
         pvalue->u.command = rtxMemAllocType (pctxt, Command);

         if (pvalue->u.command == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Command (pvalue->u.command);
         stat = asn1D_Command (pctxt, 
            pvalue->u.command, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 11;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Par_element (OSCTXT* pctxt, Par_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("animate"), 7}, 0}, 0 },
      {{{OSUTF8("set"), 3}, 0}, 1 },
      {{{OSUTF8("animateMotion"), 13}, 0}, 2 },
      {{{OSUTF8("animateColor"), 12}, 0}, 3 },
      {{{OSUTF8("animateTransform"), 16}, 0}, 4 },
      {{{OSUTF8("transitionFilter"), 16}, 0}, 5 },
      {{{OSUTF8("par"), 3}, 0}, 6 },
      {{{OSUTF8("seq"), 3}, 0}, 7 },
      {{{OSUTF8("iterate"), 7}, 0}, 8 },
      {{{OSUTF8("audio"), 5}, 0}, 9 },
      {{{OSUTF8("command"), 7}, 0}, 10 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 11, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* animate */
      pvalue->u.animate = rtxMemAllocType (pctxt, Animate);

      if (pvalue->u.animate == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Animate (pvalue->u.animate);

      stat = XmlDec_Animate (pctxt, pvalue->u.animate);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* set */
      pvalue->u.set = rtxMemAllocType (pctxt, Set);

      if (pvalue->u.set == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Set (pvalue->u.set);

      stat = XmlDec_Set (pctxt, pvalue->u.set);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* animateMotion */
      pvalue->u.animateMotion = rtxMemAllocType (pctxt, AnimateMotion);

      if (pvalue->u.animateMotion == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_AnimateMotion (pvalue->u.animateMotion);

      stat = XmlDec_AnimateMotion (pctxt, pvalue->u.animateMotion);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* animateColor */
      pvalue->u.animateColor = rtxMemAllocType (pctxt, AnimateColor);

      if (pvalue->u.animateColor == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_AnimateColor (pvalue->u.animateColor);

      stat = XmlDec_AnimateColor (pctxt, pvalue->u.animateColor);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 4: { /* animateTransform */
      pvalue->u.animateTransform = rtxMemAllocType (pctxt, AnimateTransform);

      if (pvalue->u.animateTransform == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_AnimateTransform (pvalue->u.animateTransform);

      stat = XmlDec_AnimateTransform (pctxt, pvalue->u.animateTransform);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 5: { /* transitionFilter */
      pvalue->u.transitionFilter = rtxMemAllocType (pctxt, TransitionFilter);

      if (pvalue->u.transitionFilter == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_TransitionFilter (pvalue->u.transitionFilter);

      stat = XmlDec_TransitionFilter (pctxt, pvalue->u.transitionFilter);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 6: { /* par */
      pvalue->u.par = rtxMemAllocType (pctxt, Par);

      if (pvalue->u.par == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Par ((Par*)pvalue->u.par);

      stat = XmlDec_Par (pctxt, pvalue->u.par);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 7: { /* seq */
      pvalue->u.seq = rtxMemAllocType (pctxt, Seq);

      if (pvalue->u.seq == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Seq (pvalue->u.seq);

      stat = XmlDec_Seq (pctxt, pvalue->u.seq);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 8: { /* iterate */
      pvalue->u.iterate = rtxMemAllocType (pctxt, Iterate);

      if (pvalue->u.iterate == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Iterate (pvalue->u.iterate);

      stat = XmlDec_Iterate (pctxt, pvalue->u.iterate);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 9: { /* audio */
      pvalue->u.audio = rtxMemAllocType (pctxt, Audio);

      if (pvalue->u.audio == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Audio (pvalue->u.audio);

      stat = XmlDec_Audio (pctxt, pvalue->u.audio);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 10: { /* command */
      pvalue->u.command = rtxMemAllocType (pctxt, Command);

      if (pvalue->u.command == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Command (pvalue->u.command);

      stat = XmlDec_Command (pctxt, pvalue->u.command);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Par                                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Par (OSCTXT* pctxt, Par *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode group_id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Group_id (pctxt, 
               (Ns10_Group_id*)&pvalue->group_id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.group_idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode master_element */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Master_element (pctxt, 
               (Ns10_Master_element*)&pvalue->master_element, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.master_elementPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode node_type */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Node_type (pctxt, 
               (Ns10_Node_type*)&pvalue->node_type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.node_typePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode preset_class */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_class (pctxt, 
               (Ns10_Preset_class*)&pvalue->preset_class, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_classPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode preset_id */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_id (pctxt, 
               (Ns10_Preset_id*)&pvalue->preset_id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_idPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode preset_sub_type */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns10_Preset_sub_type (pctxt, 
               (Ns10_Preset_sub_type*)&pvalue->preset_sub_type, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.preset_sub_typePresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode accelerate */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Accelerate (pctxt, 
               &pvalue->accelerate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.acceleratePresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode autoReverse */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_AutoReverse (pctxt, 
               &pvalue->autoReverse, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.autoReversePresent = TRUE;
            }
         }
         break;

      case 9:
         /* decode begin */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Begin (pctxt, 
               &pvalue->begin, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.beginPresent = TRUE;
            }
         }
         break;

      case 10:
         /* decode decelerate */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Decelerate (pctxt, 
               &pvalue->decelerate, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.deceleratePresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode dur */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Dur (pctxt, 
               &pvalue->dur, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.durPresent = TRUE;
            }
         }
         break;

      case 12:
         /* decode end */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_End (pctxt, 
               &pvalue->end, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.endPresent = TRUE;
            }
         }
         break;

      case 13:
         /* decode endsync */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Endsync (pctxt, 
               &pvalue->endsync, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.endsyncPresent = TRUE;
            }
         }
         break;

      case 14:
         /* decode fill */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Fill (pctxt, 
               &pvalue->fill, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fillPresent = TRUE;
            }
         }
         break;

      case 15:
         /* decode fillDefault */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_FillDefault (pctxt, 
               &pvalue->fillDefault, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fillDefaultPresent = TRUE;
            }
         }
         break;

      case 16:
         /* decode repeatCount */
         if (XD_PEEKTAG (pctxt, 0x90)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_RepeatCount (pctxt, 
               &pvalue->repeatCount, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.repeatCountPresent = TRUE;
            }
         }
         break;

      case 17:
         /* decode repeatDur */
         if (XD_PEEKTAG (pctxt, 0x91)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_RepeatDur (pctxt, 
               &pvalue->repeatDur, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.repeatDurPresent = TRUE;
            }
         }
         break;

      case 18:
         /* decode restart */
         if (XD_PEEKTAG (pctxt, 0x92)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_Restart (pctxt, 
               &pvalue->restart, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.restartPresent = TRUE;
            }
         }
         break;

      case 19:
         /* decode restartDefault */
         if (XD_PEEKTAG (pctxt, 0x93)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns11_RestartDefault (pctxt, 
               &pvalue->restartDefault, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.restartDefaultPresent = TRUE;
            }
         }
         break;

      case 20:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x94)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Par_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->choice_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Par_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Par_element (pdata2);

                  stat = asn1D_Par_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->choice_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_PRIM|11):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_PRIM|13):
         case (TM_CTXT|TM_PRIM|14):
         case (TM_CTXT|TM_PRIM|15):
         case (TM_CTXT|TM_PRIM|16):
         case (TM_CTXT|TM_PRIM|17):
         case (TM_CTXT|TM_CONS|17):
         case (TM_CTXT|TM_PRIM|18):
         case (TM_CTXT|TM_PRIM|19):
         case (TM_CTXT|TM_CONS|20):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Par (OSCTXT* pctxt, Par* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("group-id"), 8}, 0 },
         { {OSUTF8("master-element"), 14}, 0 },
         { {OSUTF8("node-type"), 9}, 0 },
         { {OSUTF8("preset-class"), 12}, 0 },
         { {OSUTF8("preset-id"), 9}, 0 },
         { {OSUTF8("preset-sub-type"), 15}, 0 },
         { {OSUTF8("accelerate"), 10}, 0 },
         { {OSUTF8("autoReverse"), 11}, 0 },
         { {OSUTF8("begin"), 5}, 0 },
         { {OSUTF8("decelerate"), 10}, 0 },
         { {OSUTF8("dur"), 3}, 0 },
         { {OSUTF8("end"), 3}, 0 },
         { {OSUTF8("endsync"), 7}, 0 },
         { {OSUTF8("fill"), 4}, 0 },
         { {OSUTF8("fillDefault"), 11}, 0 },
         { {OSUTF8("repeatCount"), 11}, 0 },
         { {OSUTF8("repeatDur"), 9}, 0 },
         { {OSUTF8("restart"), 7}, 0 },
         { {OSUTF8("restartDefault"), 14}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 20, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 1: /* group-id */
            stat = XmlDec_Ns10_Group_id (pctxt, &pvalue->group_id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.group_idPresent = TRUE;
            break;

         case 2: /* master-element */
            stat = XmlDec_Ns10_Master_element (pctxt, &pvalue->master_element
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.master_elementPresent = TRUE;
            break;

         case 3: /* node-type */
            stat = XmlDec_Ns10_Node_type (pctxt, &pvalue->node_type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.node_typePresent = TRUE;
            break;

         case 4: /* preset-class */
            stat = XmlDec_Ns10_Preset_class (pctxt, &pvalue->preset_class);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_classPresent = TRUE;
            break;

         case 5: /* preset-id */
            stat = XmlDec_Ns10_Preset_id (pctxt, &pvalue->preset_id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_idPresent = TRUE;
            break;

         case 6: /* preset-sub-type */
            stat = XmlDec_Ns10_Preset_sub_type (pctxt, &pvalue->preset_sub_type
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.preset_sub_typePresent = TRUE;
            break;

         case 7: /* accelerate */
            stat = XmlDec_Ns11_Accelerate (pctxt, &pvalue->accelerate);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.acceleratePresent = TRUE;
            break;

         case 8: /* autoReverse */
            stat = XmlDec_Ns11_AutoReverse (pctxt, &pvalue->autoReverse);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.autoReversePresent = TRUE;
            break;

         case 9: /* begin */
            stat = XmlDec_Ns11_Begin (pctxt, &pvalue->begin);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.beginPresent = TRUE;
            break;

         case 10: /* decelerate */
            stat = XmlDec_Ns11_Decelerate (pctxt, &pvalue->decelerate);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.deceleratePresent = TRUE;
            break;

         case 11: /* dur */
            stat = XmlDec_Ns11_Dur (pctxt, &pvalue->dur);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.durPresent = TRUE;
            break;

         case 12: /* end */
            stat = XmlDec_Ns11_End (pctxt, &pvalue->end);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.endPresent = TRUE;
            break;

         case 13: /* endsync */
            stat = XmlDec_Ns11_Endsync (pctxt, &pvalue->endsync);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.endsyncPresent = TRUE;
            break;

         case 14: /* fill */
            stat = XmlDec_Ns11_Fill (pctxt, &pvalue->fill);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fillPresent = TRUE;
            break;

         case 15: /* fillDefault */
            stat = XmlDec_Ns11_FillDefault (pctxt, &pvalue->fillDefault);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.fillDefaultPresent = TRUE;
            break;

         case 16: /* repeatCount */
            stat = XmlDec_Ns11_RepeatCount (pctxt, &pvalue->repeatCount);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.repeatCountPresent = TRUE;
            break;

         case 17: /* repeatDur */
            stat = XmlDec_Ns11_RepeatDur (pctxt, &pvalue->repeatDur);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.repeatDurPresent = TRUE;
            break;

         case 18: /* restart */
            stat = XmlDec_Ns11_Restart (pctxt, &pvalue->restart);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.restartPresent = TRUE;
            break;

         case 19: /* restartDefault */
            stat = XmlDec_Ns11_RestartDefault (pctxt, &pvalue->restartDefault
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.restartDefaultPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Par");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Par");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("animate"), 7}, 0}, 0 },
      {{{OSUTF8("set"), 3}, 0}, 0 },
      {{{OSUTF8("animateMotion"), 13}, 0}, 0 },
      {{{OSUTF8("animateColor"), 12}, 0}, 0 },
      {{{OSUTF8("animateTransform"), 16}, 0}, 0 },
      {{{OSUTF8("transitionFilter"), 16}, 0}, 0 },
      {{{OSUTF8("par"), 3}, 0}, 0 },
      {{{OSUTF8("seq"), 3}, 0}, 0 },
      {{{OSUTF8("iterate"), 7}, 0}, 0 },
      {{{OSUTF8("audio"), 5}, 0}, 0 },
      {{{OSUTF8("command"), 7}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 11, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Par_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Par_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Par_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_Par_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->choice_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 11, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

