/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "Ns5.h"
#include "Odf.h"
#include "Ns15.h"
#include "Ns8.h"
#include "Ns7.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  Chart_style_name                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Chart_style_name (OSCTXT* pctxt, Chart_style_name *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Chart_style_name (OSCTXT* pctxt, Chart_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Title_style_name                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Title_style_name (OSCTXT* pctxt, Title_style_name *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Title_style_name (OSCTXT* pctxt, Title_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Title                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Ns5_Title (OSCTXT* pctxt, Ns5_Title *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Title_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode x */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->x, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.xPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode y */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->y, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.yPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode cell_range */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Cell_range (pctxt, 
               (Cell_range*)&pvalue->cell_range, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.cell_rangePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode p */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->p = rtxMemAllocType (pctxt, Odf_P);

            if (pvalue->p == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Odf_P ((Odf_P*)pvalue->p);
            asn1Init_Odf_P ((Odf_P*)pvalue->p);

            stat = asn1D_Odf_P (pctxt, 
               (Odf_P*)pvalue->p, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.pPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Ns5_Title (OSCTXT* pctxt, Ns5_Title* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("style-name"), 10}, 0 },
         { {OSUTF8("x"), 1}, 0 },
         { {OSUTF8("y"), 1}, 0 },
         { {OSUTF8("cell-range"), 10}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* style-name */
            stat = XmlDec_Title_style_name (pctxt, &pvalue->style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         case 1: /* x */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->x);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.xPresent = TRUE;
            break;

         case 2: /* y */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->y);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.yPresent = TRUE;
            break;

         case 3: /* cell-range */
            stat = XmlDec_Cell_range (pctxt, &pvalue->cell_range);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.cell_rangePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Ns5_Title");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Ns5_Title");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("p"), 1}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* p */
         pvalue->p = rtxMemAllocType (pctxt, Odf_P);

         if (pvalue->p == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Odf_P ((Odf_P*)pvalue->p);

         stat = XmlDec_Odf_P (pctxt, pvalue->p);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.pPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Subtitle_style_name                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Subtitle_style_name (OSCTXT* pctxt, 
   Subtitle_style_name *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Subtitle_style_name (OSCTXT* pctxt, Subtitle_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Subtitle                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Subtitle (OSCTXT* pctxt, Subtitle *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Subtitle_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode x */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->x, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.xPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode y */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->y, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.yPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode cell_range */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Cell_range (pctxt, 
               (Cell_range*)&pvalue->cell_range, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.cell_rangePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode p */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->p = rtxMemAllocType (pctxt, Odf_P);

            if (pvalue->p == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Odf_P ((Odf_P*)pvalue->p);
            asn1Init_Odf_P ((Odf_P*)pvalue->p);

            stat = asn1D_Odf_P (pctxt, 
               (Odf_P*)pvalue->p, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.pPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Subtitle (OSCTXT* pctxt, Subtitle* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("style-name"), 10}, 0 },
         { {OSUTF8("x"), 1}, 0 },
         { {OSUTF8("y"), 1}, 0 },
         { {OSUTF8("cell-range"), 10}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* style-name */
            stat = XmlDec_Subtitle_style_name (pctxt, &pvalue->style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         case 1: /* x */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->x);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.xPresent = TRUE;
            break;

         case 2: /* y */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->y);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.yPresent = TRUE;
            break;

         case 3: /* cell-range */
            stat = XmlDec_Cell_range (pctxt, &pvalue->cell_range);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.cell_rangePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Subtitle");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Subtitle");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("p"), 1}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* p */
         pvalue->p = rtxMemAllocType (pctxt, Odf_P);

         if (pvalue->p == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Odf_P ((Odf_P*)pvalue->p);

         stat = XmlDec_Odf_P (pctxt, pvalue->p);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.pPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Footer_style_name                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Footer_style_name (OSCTXT* pctxt, Footer_style_name *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Footer_style_name (OSCTXT* pctxt, Footer_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Footer                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Footer (OSCTXT* pctxt, Footer *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Footer_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode x */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->x, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.xPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode y */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->y, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.yPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode cell_range */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Cell_range (pctxt, 
               (Cell_range*)&pvalue->cell_range, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.cell_rangePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode p */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->p = rtxMemAllocType (pctxt, Odf_P);

            if (pvalue->p == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Odf_P ((Odf_P*)pvalue->p);
            asn1Init_Odf_P ((Odf_P*)pvalue->p);

            stat = asn1D_Odf_P (pctxt, 
               (Odf_P*)pvalue->p, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.pPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Footer (OSCTXT* pctxt, Footer* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("style-name"), 10}, 0 },
         { {OSUTF8("x"), 1}, 0 },
         { {OSUTF8("y"), 1}, 0 },
         { {OSUTF8("cell-range"), 10}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* style-name */
            stat = XmlDec_Footer_style_name (pctxt, &pvalue->style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         case 1: /* x */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->x);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.xPresent = TRUE;
            break;

         case 2: /* y */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->y);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.yPresent = TRUE;
            break;

         case 3: /* cell-range */
            stat = XmlDec_Cell_range (pctxt, &pvalue->cell_range);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.cell_rangePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Footer");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Footer");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("p"), 1}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* p */
         pvalue->p = rtxMemAllocType (pctxt, Odf_P);

         if (pvalue->p == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Odf_P ((Odf_P*)pvalue->p);

         stat = XmlDec_Odf_P (pctxt, pvalue->p);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.pPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Legend_legend_align                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Legend_legend_align (OSCTXT* pctxt, 
   Legend_legend_align *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Legend_legend_align (OSCTXT* pctxt, Legend_legend_align* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Legend_legend_align_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Legend_legend_position                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Legend_legend_position (OSCTXT* pctxt, 
   Legend_legend_position *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Legend_legend_position (OSCTXT* pctxt, 
   Legend_legend_position* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Legend_legend_position_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Legend_style_name                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Legend_style_name (OSCTXT* pctxt, Legend_style_name *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Legend_style_name (OSCTXT* pctxt, Legend_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Legend                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Legend (OSCTXT* pctxt, Legend *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode legend_align */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Legend_legend_align (pctxt, 
               &pvalue->legend_align, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.legend_alignPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode legend_position */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Legend_legend_position (pctxt, 
               &pvalue->legend_position, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.legend_positionPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Legend_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode legend_expansion */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Legend_expansion (pctxt, 
               (Ns8_Legend_expansion*)&pvalue->legend_expansion, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.legend_expansionPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode legend_expansion_aspect_ratio */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Legend_expansion_aspect_ratio (pctxt, 
               (Ns8_Legend_expansion_aspect_ratio*)&pvalue->legend_expansion_aspect_ratio, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.legend_expansion_aspect_ratioPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode x */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->x, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.xPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode y */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->y, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.yPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Legend (OSCTXT* pctxt, Legend* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("legend-align"), 12}, 0 },
         { {OSUTF8("legend-position"), 15}, 0 },
         { {OSUTF8("style-name"), 10}, 0 },
         { {OSUTF8("legend-expansion"), 16}, 0 },
         { {OSUTF8("legend-expansion-aspect-ratio"), 29}, 0 },
         { {OSUTF8("x"), 1}, 0 },
         { {OSUTF8("y"), 1}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 7, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* legend-align */
            stat = XmlDec_Legend_legend_align (pctxt, &pvalue->legend_align);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.legend_alignPresent = TRUE;
            break;

         case 1: /* legend-position */
            stat = XmlDec_Legend_legend_position (pctxt, &pvalue->
               legend_position);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.legend_positionPresent = TRUE;
            break;

         case 2: /* style-name */
            stat = XmlDec_Legend_style_name (pctxt, &pvalue->style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         case 3: /* legend-expansion */
            stat = XmlDec_Ns8_Legend_expansion (pctxt, &pvalue->
               legend_expansion);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.legend_expansionPresent = TRUE;
            break;

         case 4: /* legend-expansion-aspect-ratio */
            stat = XmlDec_Ns8_Legend_expansion_aspect_ratio (pctxt, &pvalue->
               legend_expansion_aspect_ratio);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.legend_expansion_aspect_ratioPresent = TRUE;
            break;

         case 5: /* x */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->x);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.xPresent = TRUE;
            break;

         case 6: /* y */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->y);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.yPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Legend");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Legend");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Plot_area_data_source_has_labels                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Plot_area_data_source_has_labels (OSCTXT* pctxt, 
   Plot_area_data_source_has_labels *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Plot_area_data_source_has_labels (OSCTXT* pctxt, 
   Plot_area_data_source_has_labels* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Plot_area_data_source_has_labels_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Plot_area_style_name                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Plot_area_style_name (OSCTXT* pctxt, 
   Plot_area_style_name *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Plot_area_style_name (OSCTXT* pctxt, Plot_area_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Axis_dimension                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Axis_dimension (OSCTXT* pctxt, Axis_dimension *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Axis_dimension (OSCTXT* pctxt, Axis_dimension* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Axis_dimension_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Axis_style_name                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Axis_style_name (OSCTXT* pctxt, Axis_style_name *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Axis_style_name (OSCTXT* pctxt, Axis_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Categories                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Categories (OSCTXT* pctxt, Categories *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode cell_range_address */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Cell_range_address (pctxt, 
               (Cell_range_address*)&pvalue->cell_range_address, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.cell_range_addressPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Categories (OSCTXT* pctxt, Categories* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("cell-range-address"), 18}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* cell-range-address */
            stat = XmlDec_Cell_range_address (pctxt, &pvalue->
               cell_range_address);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.cell_range_addressPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Categories");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Categories");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Grid_class_                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Grid_class_ (OSCTXT* pctxt, Grid_class_ *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Grid_class_ (OSCTXT* pctxt, Grid_class_* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Grid_class__ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Grid_style_name                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Grid_style_name (OSCTXT* pctxt, Grid_style_name *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Grid_style_name (OSCTXT* pctxt, Grid_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Grid                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Grid (OSCTXT* pctxt, Grid *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode class_ */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Grid_class_ (pctxt, 
               &pvalue->class_, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.class_Present = TRUE;
            }
         }
         break;

      case 1:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Grid_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Grid (OSCTXT* pctxt, Grid* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("class"), 5}, 0 },
         { {OSUTF8("style-name"), 10}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* class */
            stat = XmlDec_Grid_class_ (pctxt, &pvalue->class_);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.class_Present = TRUE;
            break;

         case 1: /* style-name */
            stat = XmlDec_Grid_style_name (pctxt, &pvalue->style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Grid");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Grid");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Axis                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Axis (OSCTXT* pctxt, Axis *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode dimension */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Axis_dimension (pctxt, 
               &pvalue->dimension, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.namePresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Axis_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 3:
         /* decode title */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns5_Title (pctxt, 
               &pvalue->title, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.titlePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode categories */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Categories (pctxt, 
               &pvalue->categories, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.categoriesPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode grid_list */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Grid* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->grid_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Grid, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Grid (pdata2);

                  stat = asn1D_Grid (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->grid_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Axis (OSCTXT* pctxt, Axis* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("dimension"), 9}, 0 },
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("style-name"), 10}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* dimension */
            stat = XmlDec_Axis_dimension (pctxt, &pvalue->dimension);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* name */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.namePresent = TRUE;
            break;

         case 2: /* style-name */
            stat = XmlDec_Axis_style_name (pctxt, &pvalue->style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Axis");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Axis");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("title"), 5}, 0}, 0 },
      {{{OSUTF8("categories"), 10}, 0}, 1 },
      {{{OSUTF8("grid"), 4}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* title */
         stat = XmlDec_Ns5_Title (pctxt, &pvalue->title);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.titlePresent = TRUE;
         break;
      }
      case 1: { /* categories */
         stat = XmlDec_Categories (pctxt, &pvalue->categories);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.categoriesPresent = TRUE;
         break;
      }
      case 2: {
         Grid* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Grid);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Grid (pdata1);

            stat = XmlDec_Grid (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->grid_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 2);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Series_style_name                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Series_style_name (OSCTXT* pctxt, Series_style_name *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Series_style_name (OSCTXT* pctxt, Series_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Domain                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Domain (OSCTXT* pctxt, Domain *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode cell_range_address */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Cell_range_address (pctxt, 
               (Cell_range_address*)&pvalue->cell_range_address, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.cell_range_addressPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Domain (OSCTXT* pctxt, Domain* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("cell-range-address"), 18}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* cell-range-address */
            stat = XmlDec_Cell_range_address (pctxt, &pvalue->
               cell_range_address);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.cell_range_addressPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Domain");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Domain");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Mean_value_style_name                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Mean_value_style_name (OSCTXT* pctxt, 
   Mean_value_style_name *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Mean_value_style_name (OSCTXT* pctxt, Mean_value_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Mean_value                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Mean_value (OSCTXT* pctxt, Mean_value *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Mean_value_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Mean_value (OSCTXT* pctxt, Mean_value* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("style-name"), 10}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* style-name */
            stat = XmlDec_Mean_value_style_name (pctxt, &pvalue->style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Mean_value");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Mean_value");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Regression_curve_style_name                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Regression_curve_style_name (OSCTXT* pctxt, 
   Regression_curve_style_name *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Regression_curve_style_name (OSCTXT* pctxt, 
   Regression_curve_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Regression_curve                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Regression_curve (OSCTXT* pctxt, Regression_curve *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Regression_curve_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Regression_curve (OSCTXT* pctxt, Regression_curve* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("style-name"), 10}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* style-name */
            stat = XmlDec_Regression_curve_style_name (pctxt, &pvalue->
               style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Regression_curve");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Regression_curve");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Error_indicator_style_name                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Error_indicator_style_name (OSCTXT* pctxt, 
   Error_indicator_style_name *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Error_indicator_style_name (OSCTXT* pctxt, 
   Error_indicator_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Error_indicator                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Error_indicator (OSCTXT* pctxt, Error_indicator *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Error_indicator_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Error_indicator (OSCTXT* pctxt, Error_indicator* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("style-name"), 10}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* style-name */
            stat = XmlDec_Error_indicator_style_name (pctxt, &pvalue->
               style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Error_indicator");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Error_indicator");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Data_point_style_name                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Data_point_style_name (OSCTXT* pctxt, 
   Data_point_style_name *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Data_point_style_name (OSCTXT* pctxt, Data_point_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Data_point                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Data_point (OSCTXT* pctxt, Data_point *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode repeated */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_unsigned (pctxt, &pvalue->repeated, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.repeatedPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Data_point_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Data_point (OSCTXT* pctxt, Data_point* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("repeated"), 8}, 0 },
         { {OSUTF8("style-name"), 10}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* repeated */
            stat = rtXmlpDecUInt (pctxt, &pvalue->repeated);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.repeatedPresent = TRUE;
            break;

         case 1: /* style-name */
            stat = XmlDec_Data_point_style_name (pctxt, &pvalue->style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Data_point");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Data_point");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Series                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Series (OSCTXT* pctxt, Series *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode attached_axis */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->attached_axis, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.attached_axisPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode class_ */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->class_, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.class_Present = TRUE;
            }
         }
         break;

      case 2:
         /* decode label_cell_address */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->label_cell_address, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.label_cell_addressPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Series_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode values_cell_range_address */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->values_cell_range_address, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.values_cell_range_addressPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode domain_list */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Domain* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->domain_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Domain, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Domain (pdata2);

                  stat = asn1D_Domain (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->domain_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode mean_value */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Mean_value (pctxt, 
               &pvalue->mean_value, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.mean_valuePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode regression_curve */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Regression_curve (pctxt, 
               &pvalue->regression_curve, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.regression_curvePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 8:
         /* decode error_indicator */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Error_indicator (pctxt, 
               &pvalue->error_indicator, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.error_indicatorPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 9:
         /* decode data_point_list */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Data_point* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->data_point_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Data_point, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Data_point (pdata2);

                  stat = asn1D_Data_point (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->data_point_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_CONS|9):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Series (OSCTXT* pctxt, Series* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("attached-axis"), 13}, 0 },
         { {OSUTF8("class"), 5}, 0 },
         { {OSUTF8("label-cell-address"), 18}, 0 },
         { {OSUTF8("style-name"), 10}, 0 },
         { {OSUTF8("values-cell-range-address"), 25}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* attached-axis */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->attached_axis);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.attached_axisPresent = TRUE;
            break;

         case 1: /* class */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->class_);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.class_Present = TRUE;
            break;

         case 2: /* label-cell-address */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->label_cell_address);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.label_cell_addressPresent = TRUE;
            break;

         case 3: /* style-name */
            stat = XmlDec_Series_style_name (pctxt, &pvalue->style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         case 4: /* values-cell-range-address */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
               values_cell_range_address);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.values_cell_range_addressPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Series");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Series");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("domain"), 6}, 0}, 0 },
      {{{OSUTF8("mean-value"), 10}, 0}, 1 },
      {{{OSUTF8("regression-curve"), 16}, 0}, 2 },
      {{{OSUTF8("error-indicator"), 15}, 0}, 3 },
      {{{OSUTF8("data-point"), 10}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Domain* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Domain);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Domain (pdata1);

            stat = XmlDec_Domain (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->domain_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: { /* mean-value */
         stat = XmlDec_Mean_value (pctxt, &pvalue->mean_value);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.mean_valuePresent = TRUE;
         break;
      }
      case 2: { /* regression-curve */
         stat = XmlDec_Regression_curve (pctxt, &pvalue->regression_curve);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.regression_curvePresent = TRUE;
         break;
      }
      case 3: { /* error-indicator */
         stat = XmlDec_Error_indicator (pctxt, &pvalue->error_indicator);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.error_indicatorPresent = TRUE;
         break;
      }
      case 4: {
         Data_point* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Data_point);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Data_point (pdata1);

            stat = XmlDec_Data_point (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->data_point_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 4, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 4);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Stock_gain_marker_style_name                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Stock_gain_marker_style_name (OSCTXT* pctxt, 
   Stock_gain_marker_style_name *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Stock_gain_marker_style_name (OSCTXT* pctxt, 
   Stock_gain_marker_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Stock_gain_marker                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Stock_gain_marker (OSCTXT* pctxt, Stock_gain_marker *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Stock_gain_marker_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Stock_gain_marker (OSCTXT* pctxt, Stock_gain_marker* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("style-name"), 10}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* style-name */
            stat = XmlDec_Stock_gain_marker_style_name (pctxt, &pvalue->
               style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Stock_gain_marker");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Stock_gain_marker");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Stock_loss_marker_style_name                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Stock_loss_marker_style_name (OSCTXT* pctxt, 
   Stock_loss_marker_style_name *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Stock_loss_marker_style_name (OSCTXT* pctxt, 
   Stock_loss_marker_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Stock_loss_marker                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Stock_loss_marker (OSCTXT* pctxt, Stock_loss_marker *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Stock_loss_marker_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Stock_loss_marker (OSCTXT* pctxt, Stock_loss_marker* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("style-name"), 10}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* style-name */
            stat = XmlDec_Stock_loss_marker_style_name (pctxt, &pvalue->
               style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Stock_loss_marker");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Stock_loss_marker");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Stock_range_line_style_name                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Stock_range_line_style_name (OSCTXT* pctxt, 
   Stock_range_line_style_name *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Stock_range_line_style_name (OSCTXT* pctxt, 
   Stock_range_line_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Stock_range_line                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Stock_range_line (OSCTXT* pctxt, Stock_range_line *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Stock_range_line_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Stock_range_line (OSCTXT* pctxt, Stock_range_line* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("style-name"), 10}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* style-name */
            stat = XmlDec_Stock_range_line_style_name (pctxt, &pvalue->
               style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Stock_range_line");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Stock_range_line");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Wall_style_name                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Wall_style_name (OSCTXT* pctxt, Wall_style_name *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Wall_style_name (OSCTXT* pctxt, Wall_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Wall                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Wall (OSCTXT* pctxt, Wall *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Wall_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode width */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->width, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.widthPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Wall (OSCTXT* pctxt, Wall* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("style-name"), 10}, 0 },
         { {OSUTF8("width"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* style-name */
            stat = XmlDec_Wall_style_name (pctxt, &pvalue->style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         case 1: /* width */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->width);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.widthPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Wall");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Wall");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Floor_style_name                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Floor_style_name (OSCTXT* pctxt, Floor_style_name *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
      case (TM_CTXT|TM_CONS|1):
         stat = xd_utf8str (pctxt, &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         ccb.len = 0;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Floor_style_name (OSCTXT* pctxt, Floor_style_name* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      pvalue->u.alt_1 = pdata1;
      pvalue->t = 2;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Floor                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Floor (OSCTXT* pctxt, Floor *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Floor_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode width */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->width, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.widthPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Floor (OSCTXT* pctxt, Floor* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("style-name"), 10}, 0 },
         { {OSUTF8("width"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* style-name */
            stat = XmlDec_Floor_style_name (pctxt, &pvalue->style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         case 1: /* width */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->width);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.widthPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Floor");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Floor");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Plot_area                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Plot_area (OSCTXT* pctxt, Plot_area *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode data_source_has_labels */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Plot_area_data_source_has_labels (pctxt, 
               &pvalue->data_source_has_labels, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.data_source_has_labelsPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Plot_area_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 2:
         /* decode ambient_color */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns7_Ambient_color (pctxt, 
               (Ns7_Ambient_color*)&pvalue->ambient_color, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.ambient_colorPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode distance */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns7_Distance (pctxt, 
               (Ns7_Distance*)&pvalue->distance, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.distancePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode focal_length */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns7_Focal_length (pctxt, 
               (Ns7_Focal_length*)&pvalue->focal_length, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.focal_lengthPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode lighting_mode */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns7_Lighting_mode (pctxt, 
               (Ns7_Lighting_mode*)&pvalue->lighting_mode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.lighting_modePresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode projection */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns7_Projection (pctxt, 
               (Ns7_Projection*)&pvalue->projection, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.projectionPresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode shade_mode */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns7_Shade_mode (pctxt, 
               (Ns7_Shade_mode*)&pvalue->shade_mode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.shade_modePresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode shadow_slant */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns7_Shadow_slant (pctxt, 
               (Ns7_Shadow_slant*)&pvalue->shadow_slant, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.shadow_slantPresent = TRUE;
            }
         }
         break;

      case 9:
         /* decode transform */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns7_Transform (pctxt, 
               (Ns7_Transform*)&pvalue->transform, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transformPresent = TRUE;
            }
         }
         break;

      case 10:
         /* decode vpn */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns7_Vpn (pctxt, 
               (Ns7_Vpn*)&pvalue->vpn, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.vpnPresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode vrp */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns7_Vrp (pctxt, 
               (Ns7_Vrp*)&pvalue->vrp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.vrpPresent = TRUE;
            }
         }
         break;

      case 12:
         /* decode vup */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns7_Vup (pctxt, 
               (Ns7_Vup*)&pvalue->vup, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.vupPresent = TRUE;
            }
         }
         break;

      case 13:
         /* decode height */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->height, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.heightPresent = TRUE;
            }
         }
         break;

      case 14:
         /* decode width */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->width, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.widthPresent = TRUE;
            }
         }
         break;

      case 15:
         /* decode x */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->x, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.xPresent = TRUE;
            }
         }
         break;

      case 16:
         /* decode y */
         if (XD_PEEKTAG (pctxt, 0x90)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->y, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.yPresent = TRUE;
            }
         }
         break;

      case 17:
         /* decode cell_range_address */
         if (XD_PEEKTAG (pctxt, 0x91)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Cell_range_address (pctxt, 
               (Cell_range_address*)&pvalue->cell_range_address, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.cell_range_addressPresent = TRUE;
            }
         }
         break;

      case 18:
         /* decode light_list */
         if (XD_PEEKTAG (pctxt, 0x92)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Ns7_Light* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->light_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Ns7_Light, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Ns7_Light ((Ns7_Light*)pdata2);

                  stat = asn1D_Ns7_Light (pctxt, 
                     (Ns7_Light*)pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->light_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 19:
         /* decode axis_list */
         if (XD_PEEKTAG (pctxt, 0x93)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Axis* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->axis_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Axis, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Axis (pdata2);

                  stat = asn1D_Axis (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->axis_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 20:
         /* decode series_list */
         if (XD_PEEKTAG (pctxt, 0x94)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Series* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->series_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Series, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Series (pdata2);

                  stat = asn1D_Series (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->series_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 21:
         /* decode stock_gain_marker */
         if (XD_PEEKTAG (pctxt, 0x95)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Stock_gain_marker (pctxt, 
               &pvalue->stock_gain_marker, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.stock_gain_markerPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 22:
         /* decode stock_loss_marker */
         if (XD_PEEKTAG (pctxt, 0x96)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Stock_loss_marker (pctxt, 
               &pvalue->stock_loss_marker, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.stock_loss_markerPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 23:
         /* decode stock_range_line */
         if (XD_PEEKTAG (pctxt, 0x97)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Stock_range_line (pctxt, 
               &pvalue->stock_range_line, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.stock_range_linePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 24:
         /* decode wall */
         if (XD_PEEKTAG (pctxt, 0x98)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Wall (pctxt, 
               &pvalue->wall, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.wallPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 25:
         /* decode floor */
         if (XD_PEEKTAG (pctxt, 0x99)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Floor (pctxt, 
               &pvalue->floor, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.floorPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_PRIM|11):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_PRIM|13):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_PRIM|14):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_PRIM|15):
         case (TM_CTXT|TM_CONS|15):
         case (TM_CTXT|TM_PRIM|16):
         case (TM_CTXT|TM_CONS|16):
         case (TM_CTXT|TM_PRIM|17):
         case (TM_CTXT|TM_CONS|17):
         case (TM_CTXT|TM_CONS|18):
         case (TM_CTXT|TM_CONS|19):
         case (TM_CTXT|TM_CONS|20):
         case (TM_CTXT|TM_CONS|21):
         case (TM_CTXT|TM_CONS|22):
         case (TM_CTXT|TM_CONS|23):
         case (TM_CTXT|TM_CONS|24):
         case (TM_CTXT|TM_CONS|25):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Plot_area (OSCTXT* pctxt, Plot_area* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("data-source-has-labels"), 22}, 0 },
         { {OSUTF8("style-name"), 10}, 0 },
         { {OSUTF8("ambient-color"), 13}, 0 },
         { {OSUTF8("distance"), 8}, 0 },
         { {OSUTF8("focal-length"), 12}, 0 },
         { {OSUTF8("lighting-mode"), 13}, 0 },
         { {OSUTF8("projection"), 10}, 0 },
         { {OSUTF8("shade-mode"), 10}, 0 },
         { {OSUTF8("shadow-slant"), 12}, 0 },
         { {OSUTF8("transform"), 9}, 0 },
         { {OSUTF8("vpn"), 3}, 0 },
         { {OSUTF8("vrp"), 3}, 0 },
         { {OSUTF8("vup"), 3}, 0 },
         { {OSUTF8("height"), 6}, 0 },
         { {OSUTF8("width"), 5}, 0 },
         { {OSUTF8("x"), 1}, 0 },
         { {OSUTF8("y"), 1}, 0 },
         { {OSUTF8("cell-range-address"), 18}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 18, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* data-source-has-labels */
            stat = XmlDec_Plot_area_data_source_has_labels (pctxt, &pvalue->
               data_source_has_labels);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.data_source_has_labelsPresent = TRUE;
            break;

         case 1: /* style-name */
            stat = XmlDec_Plot_area_style_name (pctxt, &pvalue->style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         case 2: /* ambient-color */
            stat = XmlDec_Ns7_Ambient_color (pctxt, &pvalue->ambient_color);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.ambient_colorPresent = TRUE;
            break;

         case 3: /* distance */
            stat = XmlDec_Ns7_Distance (pctxt, &pvalue->distance);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.distancePresent = TRUE;
            break;

         case 4: /* focal-length */
            stat = XmlDec_Ns7_Focal_length (pctxt, &pvalue->focal_length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.focal_lengthPresent = TRUE;
            break;

         case 5: /* lighting-mode */
            stat = XmlDec_Ns7_Lighting_mode (pctxt, &pvalue->lighting_mode);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.lighting_modePresent = TRUE;
            break;

         case 6: /* projection */
            stat = XmlDec_Ns7_Projection (pctxt, &pvalue->projection);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.projectionPresent = TRUE;
            break;

         case 7: /* shade-mode */
            stat = XmlDec_Ns7_Shade_mode (pctxt, &pvalue->shade_mode);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.shade_modePresent = TRUE;
            break;

         case 8: /* shadow-slant */
            stat = XmlDec_Ns7_Shadow_slant (pctxt, &pvalue->shadow_slant);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.shadow_slantPresent = TRUE;
            break;

         case 9: /* transform */
            stat = XmlDec_Ns7_Transform (pctxt, &pvalue->transform);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transformPresent = TRUE;
            break;

         case 10: /* vpn */
            stat = XmlDec_Ns7_Vpn (pctxt, &pvalue->vpn);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.vpnPresent = TRUE;
            break;

         case 11: /* vrp */
            stat = XmlDec_Ns7_Vrp (pctxt, &pvalue->vrp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.vrpPresent = TRUE;
            break;

         case 12: /* vup */
            stat = XmlDec_Ns7_Vup (pctxt, &pvalue->vup);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.vupPresent = TRUE;
            break;

         case 13: /* height */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->height);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.heightPresent = TRUE;
            break;

         case 14: /* width */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->width);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.widthPresent = TRUE;
            break;

         case 15: /* x */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->x);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.xPresent = TRUE;
            break;

         case 16: /* y */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->y);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.yPresent = TRUE;
            break;

         case 17: /* cell-range-address */
            stat = XmlDec_Cell_range_address (pctxt, &pvalue->
               cell_range_address);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.cell_range_addressPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Plot_area");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Plot_area");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("light"), 5}, 0}, 0 },
      {{{OSUTF8("axis"), 4}, 0}, 1 },
      {{{OSUTF8("series"), 6}, 0}, 2 },
      {{{OSUTF8("stock-gain-marker"), 17}, 0}, 3 },
      {{{OSUTF8("stock-loss-marker"), 17}, 0}, 4 },
      {{{OSUTF8("stock-range-line"), 16}, 0}, 5 },
      {{{OSUTF8("wall"), 4}, 0}, 6 },
      {{{OSUTF8("floor"), 5}, 0}, 7 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 8, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 8; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Ns7_Light* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Ns7_Light);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns7_Light ((Ns7_Light*)pdata1);

            stat = XmlDec_Ns7_Light (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->light_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: {
         Axis* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Axis);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Axis (pdata1);

            stat = XmlDec_Axis (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->axis_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 2: {
         Series* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Series);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Series (pdata1);

            stat = XmlDec_Series (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->series_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 2);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 3: { /* stock-gain-marker */
         stat = XmlDec_Stock_gain_marker (pctxt, &pvalue->stock_gain_marker);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.stock_gain_markerPresent = TRUE;
         break;
      }
      case 4: { /* stock-loss-marker */
         stat = XmlDec_Stock_loss_marker (pctxt, &pvalue->stock_loss_marker);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.stock_loss_markerPresent = TRUE;
         break;
      }
      case 5: { /* stock-range-line */
         stat = XmlDec_Stock_range_line (pctxt, &pvalue->stock_range_line);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.stock_range_linePresent = TRUE;
         break;
      }
      case 6: { /* wall */
         stat = XmlDec_Wall (pctxt, &pvalue->wall);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.wallPresent = TRUE;
         break;
      }
      case 7: { /* floor */
         stat = XmlDec_Floor (pctxt, &pvalue->floor);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.floorPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Chart                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Chart (OSCTXT* pctxt, Chart *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode class_ */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->class_, ASN1IMPL, length);
            if (stat == 0) {
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode column_mapping */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->column_mapping, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.column_mappingPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode row_mapping */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->row_mapping, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.row_mappingPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode style_name */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Chart_style_name (pctxt, 
               &pvalue->style_name, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.style_namePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode height */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->height, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.heightPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode width */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->width, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.widthPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode title */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns5_Title (pctxt, 
               &pvalue->title, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.titlePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode subtitle */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Subtitle (pctxt, 
               &pvalue->subtitle, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.subtitlePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 8:
         /* decode footer */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Footer (pctxt, 
               &pvalue->footer, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.footerPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 9:
         /* decode legend */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Legend (pctxt, 
               &pvalue->legend, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.legendPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 10:
         /* decode plot_area */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Plot_area (pctxt, 
               &pvalue->plot_area, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 11:
         /* decode table */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->table = rtxMemAllocType (pctxt, Table);

            if (pvalue->table == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Table ((Table*)pvalue->table);
            asn1Init_Table ((Table*)pvalue->table);

            stat = asn1D_Table (pctxt, 
               (Table*)pvalue->table, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.tablePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_CONS|11):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Chart (OSCTXT* pctxt, Chart* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("class"), 5}, 0 },
         { {OSUTF8("column-mapping"), 14}, 0 },
         { {OSUTF8("row-mapping"), 11}, 0 },
         { {OSUTF8("style-name"), 10}, 0 },
         { {OSUTF8("height"), 6}, 0 },
         { {OSUTF8("width"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 6, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* class */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->class_);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* column-mapping */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->column_mapping);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.column_mappingPresent = TRUE;
            break;

         case 2: /* row-mapping */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->row_mapping);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.row_mappingPresent = TRUE;
            break;

         case 3: /* style-name */
            stat = XmlDec_Chart_style_name (pctxt, &pvalue->style_name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.style_namePresent = TRUE;
            break;

         case 4: /* height */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->height);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.heightPresent = TRUE;
            break;

         case 5: /* width */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->width);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.widthPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Chart");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Chart");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("title"), 5}, 0}, 0 },
      {{{OSUTF8("subtitle"), 8}, 0}, 1 },
      {{{OSUTF8("footer"), 6}, 0}, 2 },
      {{{OSUTF8("legend"), 6}, 0}, 3 },
      {{{OSUTF8("plot-area"), 9}, 0}, 4 },
      {{{OSUTF8("table"), 5}, 0}, 5 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 5, -1}, {5, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 6; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* title */
         stat = XmlDec_Ns5_Title (pctxt, &pvalue->title);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.titlePresent = TRUE;
         break;
      }
      case 1: { /* subtitle */
         stat = XmlDec_Subtitle (pctxt, &pvalue->subtitle);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.subtitlePresent = TRUE;
         break;
      }
      case 2: { /* footer */
         stat = XmlDec_Footer (pctxt, &pvalue->footer);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.footerPresent = TRUE;
         break;
      }
      case 3: { /* legend */
         stat = XmlDec_Legend (pctxt, &pvalue->legend);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.legendPresent = TRUE;
         break;
      }
      case 4: { /* plot-area */
         stat = XmlDec_Plot_area (pctxt, &pvalue->plot_area);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 5: { /* table */
         pvalue->table = rtxMemAllocType (pctxt, Table);

         if (pvalue->table == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Table ((Table*)pvalue->table);

         stat = XmlDec_Table (pctxt, pvalue->table);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.tablePresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

