/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "Ns14.h"
#include "Ns8.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  Number_style_transliteration_style                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Number_style_transliteration_style (OSCTXT* pctxt,
   Number_style_transliteration_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Number_style_transliteration_style (OSCTXT* pctxt, 
   Number_style_transliteration_style value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Number_style_transliteration_style_ToString (value)
         , elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Text                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Text (OSCTXT* pctxt,
   Text pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_utf8str (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Text (OSCTXT* pctxt, Text value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Number_grouping                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Number_grouping (OSCTXT* pctxt,
   Number_grouping *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Number_grouping (OSCTXT* pctxt, Number_grouping value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Number_grouping_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Embedded_text                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Embedded_text (OSCTXT* pctxt,
   Embedded_text *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode position */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      xe_integer (pctxt, &pvalue->position, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Embedded_text (OSCTXT* pctxt, Embedded_text* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   stat = rtXmlEncIntAttr
      (pctxt, pvalue->position, OSUTF8("ns14:position"), 13);

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Number                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Ns14_Number (OSCTXT* pctxt,
   Ns14_Number *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode embedded_text_list */

   pnode2 = pvalue->embedded_text_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Embedded_text (pctxt, ((Embedded_text*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode min_integer_digits */

   if (pvalue->m.min_integer_digitsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_integer (pctxt, &pvalue->min_integer_digits, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode grouping */

   if (pvalue->m.groupingPresent) {
      if(pvalue->grouping < 0 || pvalue->grouping > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_Number_grouping (pctxt, &pvalue->grouping, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode display_factor */

   if (pvalue->m.display_factorPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_real (pctxt, &pvalue->display_factor, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode decimal_replacement */

   if (pvalue->m.decimal_replacementPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->decimal_replacement, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode decimal_places */

   if (pvalue->m.decimal_placesPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_integer (pctxt, &pvalue->decimal_places, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Ns14_Number (OSCTXT* pctxt, Ns14_Number* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.decimal_placesPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->decimal_places, OSUTF8("ns14:decimal-places"), 19);
   }

   if (pvalue->m.decimal_replacementPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:decimal-replacement=\""), 27);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->decimal_replacement, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.display_factorPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:display-factor=\""), 22);

      stat = rtXmlEncDouble (pctxt, pvalue->display_factor, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.groupingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:grouping=\""), 16);

      if(pvalue->grouping < 0 || pvalue->grouping > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Number_grouping (pctxt, pvalue->grouping, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.min_integer_digitsPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->min_integer_digits
            , OSUTF8("ns14:min-integer-digits"), 23);
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode embedded_text_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   { OSRTDListNode* pnode = pvalue->embedded_text_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Embedded_text (pctxt, ((Embedded_text*)pnode->data)
         , OSUTF8("embedded-text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Scientific_number_grouping                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Scientific_number_grouping (OSCTXT* pctxt,
   Scientific_number_grouping *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Scientific_number_grouping (OSCTXT* pctxt, 
   Scientific_number_grouping value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Scientific_number_grouping_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Scientific_number                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Scientific_number (OSCTXT* pctxt,
   Scientific_number *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode min_integer_digits */

   if (pvalue->m.min_integer_digitsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_integer (pctxt, &pvalue->min_integer_digits, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode min_exponent_digits */

   if (pvalue->m.min_exponent_digitsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_integer (pctxt, &pvalue->min_exponent_digits, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode grouping */

   if (pvalue->m.groupingPresent) {
      if(pvalue->grouping < 0 || pvalue->grouping > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Scientific_number_grouping (pctxt, &pvalue->grouping, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode decimal_places */

   if (pvalue->m.decimal_placesPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_integer (pctxt, &pvalue->decimal_places, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Scientific_number (OSCTXT* pctxt, Scientific_number* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.decimal_placesPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->decimal_places, OSUTF8("ns14:decimal-places"), 19);
   }

   if (pvalue->m.groupingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:grouping=\""), 16);

      if(pvalue->grouping < 0 || pvalue->grouping > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Scientific_number_grouping (pctxt, pvalue->grouping
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.min_exponent_digitsPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->min_exponent_digits
            , OSUTF8("ns14:min-exponent-digits"), 24);
   }

   if (pvalue->m.min_integer_digitsPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->min_integer_digits
            , OSUTF8("ns14:min-integer-digits"), 23);
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Fraction_grouping                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Fraction_grouping (OSCTXT* pctxt,
   Fraction_grouping *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Fraction_grouping (OSCTXT* pctxt, Fraction_grouping value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Fraction_grouping_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Fraction                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Fraction (OSCTXT* pctxt,
   Fraction *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode min_numerator_digits */

   if (pvalue->m.min_numerator_digitsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_integer (pctxt, &pvalue->min_numerator_digits, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode min_integer_digits */

   if (pvalue->m.min_integer_digitsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_integer (pctxt, &pvalue->min_integer_digits, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode min_denominator_digits */

   if (pvalue->m.min_denominator_digitsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_integer (pctxt, &pvalue->min_denominator_digits, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode grouping */

   if (pvalue->m.groupingPresent) {
      if(pvalue->grouping < 0 || pvalue->grouping > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Fraction_grouping (pctxt, &pvalue->grouping, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode denominator_value */

   if (pvalue->m.denominator_valuePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_integer (pctxt, &pvalue->denominator_value, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Fraction (OSCTXT* pctxt, Fraction* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.denominator_valuePresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->denominator_value
            , OSUTF8("ns14:denominator-value"), 22);
   }

   if (pvalue->m.groupingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:grouping=\""), 16);

      if(pvalue->grouping < 0 || pvalue->grouping > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Fraction_grouping (pctxt, pvalue->grouping, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.min_denominator_digitsPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->min_denominator_digits
            , OSUTF8("ns14:min-denominator-digits"), 27);
   }

   if (pvalue->m.min_integer_digitsPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->min_integer_digits
            , OSUTF8("ns14:min-integer-digits"), 23);
   }

   if (pvalue->m.min_numerator_digitsPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->min_numerator_digits
            , OSUTF8("ns14:min-numerator-digits"), 25);
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Number_style_sequence_choice                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Number_style_sequence_choice (OSCTXT* pctxt,
   Number_style_sequence_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_Ns14_Number (pctxt, pvalue->u.number, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_Scientific_number (pctxt, pvalue->u.scientific_number, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_Fraction (pctxt, pvalue->u.fraction, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_Number_style_sequence_choice (OSCTXT* pctxt, 
   Number_style_sequence_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   switch (pvalue->t)
   {
      case 1:
         /* encode number */

         stat = XmlEnc_Ns14_Number (pctxt, pvalue->u.number
            , OSUTF8("number"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode scientific_number */

         stat = XmlEnc_Scientific_number (pctxt, pvalue->u.scientific_number
            , OSUTF8("scientific-number"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode fraction */

         stat = XmlEnc_Fraction (pctxt, pvalue->u.fraction
            , OSUTF8("fraction"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Number_style_sequence                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Number_style_sequence (OSCTXT* pctxt,
   Number_style_sequence *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_Number_style_sequence_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Number_style_sequence (OSCTXT* pctxt, 
   Number_style_sequence* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode choice */

   stat = XmlEnc_Number_style_sequence_choice (pctxt, &pvalue->choice
      , OSUTF8(""), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Number_style                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Number_style (OSCTXT* pctxt,
   Number_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode map_list */

   pnode2 = pvalue->map_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Ns8_Map (pctxt, (Ns8_Map*)((Ns8_Map*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode sequence */

   if (pvalue->m.sequencePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
         asn1E_Number_style_sequence (pctxt, &pvalue->sequence, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      if (pvalue->text_properties == NULL) {
         rtxErrAddStrParm (pctxt, "pvalue->text_properties");
         return LOG_RTERR (pctxt, RTERR_NULLPTR);
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
         asn1E_Ns8_Text_properties (pctxt, (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode volatile_ */

   if (pvalue->m.volatile_Present) {
      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         asn1E_Ns8_Volatile (pctxt, (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode name */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
      asn1E_Ns8_Name (pctxt, (Ns8_Name)pvalue->name, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode transliteration_style */

   if (pvalue->m.transliteration_stylePresent) {
      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_Number_style_transliteration_style (pctxt, &pvalue->transliteration_style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_language */

   if (pvalue->m.transliteration_languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_utf8str (pctxt, pvalue->transliteration_language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_format */

   if (pvalue->m.transliteration_formatPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->transliteration_format, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_country */

   if (pvalue->m.transliteration_countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->transliteration_country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode title */

   if (pvalue->m.titlePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->title, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode language */

   if (pvalue->m.languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode country */

   if (pvalue->m.countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Number_style (OSCTXT* pctxt, Number_style* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:country=\""), 15);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:language=\""), 16);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.titlePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:title=\""), 13);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->title, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-country=\""), 31);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_formatPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-format=\""), 30);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_format, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-language=\""), 32);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-style=\""), 29);

      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style
          > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Number_style_transliteration_style (pctxt, pvalue->
         transliteration_style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:name=\""), 11);

   stat = XmlEnc_Ns8_Name (pctxt, pvalue->name, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.volatile_Present) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:volatile=\""), 15);

      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Ns8_Volatile (pctxt, pvalue->volatile_, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      stat = XmlEnc_Ns8_Text_properties (pctxt, pvalue->text_properties
         , OSUTF8("text-properties"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode sequence */

   if (pvalue->m.sequencePresent) {
      stat = XmlEnc_Number_style_sequence (pctxt, &pvalue->sequence
         , OSUTF8(""), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode map_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   { OSRTDListNode* pnode = pvalue->map_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Ns8_Map (pctxt, ((Ns8_Map*)pnode->data)
         , OSUTF8("map"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_automatic_order                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Currency_style_automatic_order (OSCTXT* pctxt,
   Currency_style_automatic_order *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Currency_style_automatic_order (OSCTXT* pctxt, 
   Currency_style_automatic_order value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Currency_style_automatic_order_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_transliteration_style                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Currency_style_transliteration_style (OSCTXT* pctxt,
   Currency_style_transliteration_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Currency_style_transliteration_style (OSCTXT* pctxt, 
   Currency_style_transliteration_style value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Currency_style_transliteration_style_ToString (value)
         , elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_symbol                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Currency_symbol (OSCTXT* pctxt,
   Currency_symbol *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode language */

   if (pvalue->m.languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode country */

   if (pvalue->m.countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Currency_symbol (OSCTXT* pctxt, Currency_symbol* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:country=\""), 15);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:language=\""), 16);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_sequence_sequence                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Currency_style_sequence_sequence (OSCTXT* pctxt,
   Currency_style_sequence_sequence *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode currency_symbol */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_Currency_symbol (pctxt, &pvalue->currency_symbol, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Currency_style_sequence_sequence (OSCTXT* pctxt, 
   Currency_style_sequence_sequence* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode currency_symbol */

   stat = XmlEnc_Currency_symbol (pctxt, &pvalue->currency_symbol
      , OSUTF8("currency-symbol"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_sequence                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Currency_style_sequence (OSCTXT* pctxt,
   Currency_style_sequence *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode sequence */

   if (pvalue->m.sequencePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
         asn1E_Currency_style_sequence_sequence (pctxt, &pvalue->sequence, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode number */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_Ns14_Number (pctxt, &pvalue->number, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Currency_style_sequence (OSCTXT* pctxt, 
   Currency_style_sequence* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode number */

   stat = XmlEnc_Ns14_Number (pctxt, &pvalue->number
      , OSUTF8("number"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode sequence */

   if (pvalue->m.sequencePresent) {
      stat = XmlEnc_Currency_style_sequence_sequence (pctxt, &pvalue->sequence
         , OSUTF8(""), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_sequence_1_sequence                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Currency_style_sequence_1_sequence (OSCTXT* pctxt,
   Currency_style_sequence_1_sequence *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode number */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_Ns14_Number (pctxt, &pvalue->number, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Currency_style_sequence_1_sequence (OSCTXT* pctxt, 
   Currency_style_sequence_1_sequence* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode number */

   stat = XmlEnc_Ns14_Number (pctxt, &pvalue->number
      , OSUTF8("number"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_sequence_1                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Currency_style_sequence_1 (OSCTXT* pctxt,
   Currency_style_sequence_1 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode sequence */

   if (pvalue->m.sequencePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
         asn1E_Currency_style_sequence_1_sequence (pctxt, &pvalue->sequence, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode currency_symbol */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_Currency_symbol (pctxt, &pvalue->currency_symbol, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Currency_style_sequence_1 (OSCTXT* pctxt, 
   Currency_style_sequence_1* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode currency_symbol */

   stat = XmlEnc_Currency_symbol (pctxt, &pvalue->currency_symbol
      , OSUTF8("currency-symbol"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode sequence */

   if (pvalue->m.sequencePresent) {
      stat = XmlEnc_Currency_style_sequence_1_sequence (pctxt, &pvalue->
         sequence, OSUTF8(""), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_choice                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Currency_style_choice (OSCTXT* pctxt,
   Currency_style_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_Currency_style_sequence (pctxt, pvalue->u.sequence, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_Currency_style_sequence_1 (pctxt, pvalue->u.sequence_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_Currency_style_choice (OSCTXT* pctxt, 
   Currency_style_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   switch (pvalue->t)
   {
      case 1:
         /* encode sequence */

         stat = XmlEnc_Currency_style_sequence (pctxt, pvalue->u.sequence
            , OSUTF8(""), 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode sequence_1 */

         stat = XmlEnc_Currency_style_sequence_1 (pctxt, pvalue->u.sequence_1
            , OSUTF8(""), 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Currency_style (OSCTXT* pctxt,
   Currency_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode map_list */

   pnode2 = pvalue->map_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Ns8_Map (pctxt, (Ns8_Map*)((Ns8_Map*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|13, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12,
         asn1E_Currency_style_choice (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|11,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      if (pvalue->text_properties == NULL) {
         rtxErrAddStrParm (pctxt, "pvalue->text_properties");
         return LOG_RTERR (pctxt, RTERR_NULLPTR);
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
         asn1E_Ns8_Text_properties (pctxt, (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode volatile_ */

   if (pvalue->m.volatile_Present) {
      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
         asn1E_Ns8_Volatile (pctxt, (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode name */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
      asn1E_Ns8_Name (pctxt, (Ns8_Name)pvalue->name, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode transliteration_style */

   if (pvalue->m.transliteration_stylePresent) {
      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         asn1E_Currency_style_transliteration_style (pctxt, &pvalue->transliteration_style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_language */

   if (pvalue->m.transliteration_languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         xe_utf8str (pctxt, pvalue->transliteration_language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_format */

   if (pvalue->m.transliteration_formatPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_utf8str (pctxt, pvalue->transliteration_format, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_country */

   if (pvalue->m.transliteration_countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->transliteration_country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode title */

   if (pvalue->m.titlePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->title, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode language */

   if (pvalue->m.languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode country */

   if (pvalue->m.countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode automatic_order */

   if (pvalue->m.automatic_orderPresent) {
      if(pvalue->automatic_order < 0 || pvalue->automatic_order > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Currency_style_automatic_order (pctxt, &pvalue->automatic_order, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Currency_style (OSCTXT* pctxt, Currency_style* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.automatic_orderPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:automatic-order=\""), 23);

      if(pvalue->automatic_order < 0 || pvalue->automatic_order > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Currency_style_automatic_order (pctxt, pvalue->
         automatic_order, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:country=\""), 15);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:language=\""), 16);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.titlePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:title=\""), 13);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->title, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-country=\""), 31);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_formatPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-format=\""), 30);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_format, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-language=\""), 32);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-style=\""), 29);

      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style
          > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Currency_style_transliteration_style (pctxt, pvalue->
         transliteration_style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:name=\""), 11);

   stat = XmlEnc_Ns8_Name (pctxt, pvalue->name, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.volatile_Present) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:volatile=\""), 15);

      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Ns8_Volatile (pctxt, pvalue->volatile_, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      stat = XmlEnc_Ns8_Text_properties (pctxt, pvalue->text_properties
         , OSUTF8("text-properties"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_Currency_style_choice (pctxt, &pvalue->choice
         , OSUTF8(""), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode map_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   { OSRTDListNode* pnode = pvalue->map_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Ns8_Map (pctxt, ((Ns8_Map*)pnode->data)
         , OSUTF8("map"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Percentage_style_transliteration_style                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Percentage_style_transliteration_style (OSCTXT* pctxt,
   Percentage_style_transliteration_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Percentage_style_transliteration_style (OSCTXT* pctxt, 
   Percentage_style_transliteration_style value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Percentage_style_transliteration_style_ToString (value)
         , elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Percentage_style_sequence                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Percentage_style_sequence (OSCTXT* pctxt,
   Percentage_style_sequence *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode number */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_Ns14_Number (pctxt, &pvalue->number, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Percentage_style_sequence (OSCTXT* pctxt, 
   Percentage_style_sequence* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode number */

   stat = XmlEnc_Ns14_Number (pctxt, &pvalue->number
      , OSUTF8("number"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Percentage_style                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Percentage_style (OSCTXT* pctxt,
   Percentage_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode map_list */

   pnode2 = pvalue->map_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Ns8_Map (pctxt, (Ns8_Map*)((Ns8_Map*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode sequence */

   if (pvalue->m.sequencePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
         asn1E_Percentage_style_sequence (pctxt, &pvalue->sequence, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      if (pvalue->text_properties == NULL) {
         rtxErrAddStrParm (pctxt, "pvalue->text_properties");
         return LOG_RTERR (pctxt, RTERR_NULLPTR);
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
         asn1E_Ns8_Text_properties (pctxt, (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode volatile_ */

   if (pvalue->m.volatile_Present) {
      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         asn1E_Ns8_Volatile (pctxt, (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode name */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
      asn1E_Ns8_Name (pctxt, (Ns8_Name)pvalue->name, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode transliteration_style */

   if (pvalue->m.transliteration_stylePresent) {
      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_Percentage_style_transliteration_style (pctxt, &pvalue->transliteration_style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_language */

   if (pvalue->m.transliteration_languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_utf8str (pctxt, pvalue->transliteration_language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_format */

   if (pvalue->m.transliteration_formatPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->transliteration_format, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_country */

   if (pvalue->m.transliteration_countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->transliteration_country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode title */

   if (pvalue->m.titlePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->title, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode language */

   if (pvalue->m.languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode country */

   if (pvalue->m.countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Percentage_style (OSCTXT* pctxt, Percentage_style* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:country=\""), 15);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:language=\""), 16);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.titlePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:title=\""), 13);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->title, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-country=\""), 31);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_formatPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-format=\""), 30);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_format, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-language=\""), 32);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-style=\""), 29);

      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style
          > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Percentage_style_transliteration_style (pctxt, pvalue->
         transliteration_style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:name=\""), 11);

   stat = XmlEnc_Ns8_Name (pctxt, pvalue->name, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.volatile_Present) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:volatile=\""), 15);

      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Ns8_Volatile (pctxt, pvalue->volatile_, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      stat = XmlEnc_Ns8_Text_properties (pctxt, pvalue->text_properties
         , OSUTF8("text-properties"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode sequence */

   if (pvalue->m.sequencePresent) {
      stat = XmlEnc_Percentage_style_sequence (pctxt, &pvalue->sequence
         , OSUTF8(""), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode map_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   { OSRTDListNode* pnode = pvalue->map_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Ns8_Map (pctxt, ((Ns8_Map*)pnode->data)
         , OSUTF8("map"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date_style_automatic_order                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Date_style_automatic_order (OSCTXT* pctxt,
   Date_style_automatic_order *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Date_style_automatic_order (OSCTXT* pctxt, 
   Date_style_automatic_order value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Date_style_automatic_order_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date_style_format_source                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Date_style_format_source (OSCTXT* pctxt,
   Date_style_format_source *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Date_style_format_source (OSCTXT* pctxt, 
   Date_style_format_source value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Date_style_format_source_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date_style_transliteration_style                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Date_style_transliteration_style (OSCTXT* pctxt,
   Date_style_transliteration_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Date_style_transliteration_style (OSCTXT* pctxt, 
   Date_style_transliteration_style value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Date_style_transliteration_style_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_1                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_calendar_alt_1 (OSCTXT* pctxt,
   Day_calendar_alt_1 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_calendar_alt_1 (OSCTXT* pctxt, Day_calendar_alt_1 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_calendar_alt_1_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_2                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_calendar_alt_2 (OSCTXT* pctxt,
   Day_calendar_alt_2 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_calendar_alt_2 (OSCTXT* pctxt, Day_calendar_alt_2 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_calendar_alt_2_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_3                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_calendar_alt_3 (OSCTXT* pctxt,
   Day_calendar_alt_3 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_calendar_alt_3 (OSCTXT* pctxt, Day_calendar_alt_3 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_calendar_alt_3_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_4                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_calendar_alt_4 (OSCTXT* pctxt,
   Day_calendar_alt_4 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_calendar_alt_4 (OSCTXT* pctxt, Day_calendar_alt_4 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_calendar_alt_4_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_5                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_calendar_alt_5 (OSCTXT* pctxt,
   Day_calendar_alt_5 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_calendar_alt_5 (OSCTXT* pctxt, Day_calendar_alt_5 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_calendar_alt_5_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_6                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_calendar_alt_6 (OSCTXT* pctxt,
   Day_calendar_alt_6 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_calendar_alt_6 (OSCTXT* pctxt, Day_calendar_alt_6 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_calendar_alt_6_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_7                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_calendar_alt_7 (OSCTXT* pctxt,
   Day_calendar_alt_7 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_calendar_alt_7 (OSCTXT* pctxt, Day_calendar_alt_7 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_calendar_alt_7_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_8                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_calendar_alt_8 (OSCTXT* pctxt,
   Day_calendar_alt_8 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_calendar_alt_8 (OSCTXT* pctxt, Day_calendar_alt_8 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_calendar_alt_8_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_calendar (OSCTXT* pctxt,
   Day_calendar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            xe_utf8str (pctxt, pvalue->u.alt, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
            asn1E_Day_calendar_alt_1 (pctxt, &pvalue->u.alt_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
            asn1E_Day_calendar_alt_2 (pctxt, &pvalue->u.alt_2, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
            asn1E_Day_calendar_alt_3 (pctxt, &pvalue->u.alt_3, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
            asn1E_Day_calendar_alt_4 (pctxt, &pvalue->u.alt_4, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
            asn1E_Day_calendar_alt_5 (pctxt, &pvalue->u.alt_5, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
            asn1E_Day_calendar_alt_6 (pctxt, &pvalue->u.alt_6, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
            asn1E_Day_calendar_alt_7 (pctxt, &pvalue->u.alt_7, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
            asn1E_Day_calendar_alt_8 (pctxt, &pvalue->u.alt_8, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_Day_calendar (OSCTXT* pctxt, Day_calendar* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   switch (pvalue->t)
   {
      case 1:
         /* encode alt */

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.alt, 0, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode alt_1 */

         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_calendar_alt_1 (pctxt, pvalue->u.alt_1
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode alt_2 */

         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_calendar_alt_2 (pctxt, pvalue->u.alt_2
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode alt_3 */

         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_calendar_alt_3 (pctxt, pvalue->u.alt_3
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode alt_4 */

         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_calendar_alt_4 (pctxt, pvalue->u.alt_4
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode alt_5 */

         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_calendar_alt_5 (pctxt, pvalue->u.alt_5
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode alt_6 */

         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_calendar_alt_6 (pctxt, pvalue->u.alt_6
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode alt_7 */

         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_calendar_alt_7 (pctxt, pvalue->u.alt_7
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode alt_8 */

         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_calendar_alt_8 (pctxt, pvalue->u.alt_8
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_style                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_style (OSCTXT* pctxt,
   Day_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_style (OSCTXT* pctxt, Day_style value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_style_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day                                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Ns14_Day (OSCTXT* pctxt,
   Ns14_Day *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode style */

   if (pvalue->m.stylePresent) {
      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Day_style (pctxt, &pvalue->style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode calendar */

   if (pvalue->m.calendarPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_Day_calendar (pctxt, &pvalue->calendar, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Ns14_Day (OSCTXT* pctxt, Ns14_Day* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.calendarPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:calendar=\""), 16);

      stat = XmlEnc_Day_calendar (pctxt, &pvalue->calendar, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:style=\""), 13);

      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Day_style (pctxt, pvalue->style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_1                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Month_calendar_alt_1 (OSCTXT* pctxt,
   Month_calendar_alt_1 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Month_calendar_alt_1 (OSCTXT* pctxt, Month_calendar_alt_1 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Month_calendar_alt_1_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_2                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Month_calendar_alt_2 (OSCTXT* pctxt,
   Month_calendar_alt_2 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Month_calendar_alt_2 (OSCTXT* pctxt, Month_calendar_alt_2 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Month_calendar_alt_2_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_3                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Month_calendar_alt_3 (OSCTXT* pctxt,
   Month_calendar_alt_3 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Month_calendar_alt_3 (OSCTXT* pctxt, Month_calendar_alt_3 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Month_calendar_alt_3_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_4                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Month_calendar_alt_4 (OSCTXT* pctxt,
   Month_calendar_alt_4 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Month_calendar_alt_4 (OSCTXT* pctxt, Month_calendar_alt_4 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Month_calendar_alt_4_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_5                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Month_calendar_alt_5 (OSCTXT* pctxt,
   Month_calendar_alt_5 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Month_calendar_alt_5 (OSCTXT* pctxt, Month_calendar_alt_5 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Month_calendar_alt_5_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_6                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Month_calendar_alt_6 (OSCTXT* pctxt,
   Month_calendar_alt_6 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Month_calendar_alt_6 (OSCTXT* pctxt, Month_calendar_alt_6 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Month_calendar_alt_6_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_7                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Month_calendar_alt_7 (OSCTXT* pctxt,
   Month_calendar_alt_7 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Month_calendar_alt_7 (OSCTXT* pctxt, Month_calendar_alt_7 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Month_calendar_alt_7_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_8                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Month_calendar_alt_8 (OSCTXT* pctxt,
   Month_calendar_alt_8 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Month_calendar_alt_8 (OSCTXT* pctxt, Month_calendar_alt_8 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Month_calendar_alt_8_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Month_calendar (OSCTXT* pctxt,
   Month_calendar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            xe_utf8str (pctxt, pvalue->u.alt, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
            asn1E_Month_calendar_alt_1 (pctxt, &pvalue->u.alt_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
            asn1E_Month_calendar_alt_2 (pctxt, &pvalue->u.alt_2, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
            asn1E_Month_calendar_alt_3 (pctxt, &pvalue->u.alt_3, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
            asn1E_Month_calendar_alt_4 (pctxt, &pvalue->u.alt_4, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
            asn1E_Month_calendar_alt_5 (pctxt, &pvalue->u.alt_5, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
            asn1E_Month_calendar_alt_6 (pctxt, &pvalue->u.alt_6, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
            asn1E_Month_calendar_alt_7 (pctxt, &pvalue->u.alt_7, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
            asn1E_Month_calendar_alt_8 (pctxt, &pvalue->u.alt_8, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_Month_calendar (OSCTXT* pctxt, Month_calendar* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   switch (pvalue->t)
   {
      case 1:
         /* encode alt */

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.alt, 0, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode alt_1 */

         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Month_calendar_alt_1 (pctxt, pvalue->u.alt_1
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode alt_2 */

         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Month_calendar_alt_2 (pctxt, pvalue->u.alt_2
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode alt_3 */

         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Month_calendar_alt_3 (pctxt, pvalue->u.alt_3
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode alt_4 */

         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Month_calendar_alt_4 (pctxt, pvalue->u.alt_4
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode alt_5 */

         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Month_calendar_alt_5 (pctxt, pvalue->u.alt_5
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode alt_6 */

         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Month_calendar_alt_6 (pctxt, pvalue->u.alt_6
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode alt_7 */

         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Month_calendar_alt_7 (pctxt, pvalue->u.alt_7
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode alt_8 */

         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Month_calendar_alt_8 (pctxt, pvalue->u.alt_8
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_possessive_form                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Month_possessive_form (OSCTXT* pctxt,
   Month_possessive_form *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Month_possessive_form (OSCTXT* pctxt, Month_possessive_form value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Month_possessive_form_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_style                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Month_style (OSCTXT* pctxt,
   Month_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Month_style (OSCTXT* pctxt, Month_style value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Month_style_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_textual                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Month_textual (OSCTXT* pctxt,
   Month_textual *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Month_textual (OSCTXT* pctxt, Month_textual value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Month_textual_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Ns14_Month (OSCTXT* pctxt,
   Ns14_Month *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode textual */

   if (pvalue->m.textualPresent) {
      if(pvalue->textual < 0 || pvalue->textual > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_Month_textual (pctxt, &pvalue->textual, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode style */

   if (pvalue->m.stylePresent) {
      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_Month_style (pctxt, &pvalue->style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode possessive_form */

   if (pvalue->m.possessive_formPresent) {
      if(pvalue->possessive_form < 0 || pvalue->possessive_form > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Month_possessive_form (pctxt, &pvalue->possessive_form, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode calendar */

   if (pvalue->m.calendarPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_Month_calendar (pctxt, &pvalue->calendar, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Ns14_Month (OSCTXT* pctxt, Ns14_Month* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.calendarPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:calendar=\""), 16);

      stat = XmlEnc_Month_calendar (pctxt, &pvalue->calendar, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.possessive_formPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:possessive-form=\""), 23);

      if(pvalue->possessive_form < 0 || pvalue->possessive_form > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Month_possessive_form (pctxt, pvalue->possessive_form
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:style=\""), 13);

      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Month_style (pctxt, pvalue->style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.textualPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:textual=\""), 15);

      if(pvalue->textual < 0 || pvalue->textual > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Month_textual (pctxt, pvalue->textual, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_1                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Year_calendar_alt_1 (OSCTXT* pctxt,
   Year_calendar_alt_1 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Year_calendar_alt_1 (OSCTXT* pctxt, Year_calendar_alt_1 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Year_calendar_alt_1_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_2                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Year_calendar_alt_2 (OSCTXT* pctxt,
   Year_calendar_alt_2 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Year_calendar_alt_2 (OSCTXT* pctxt, Year_calendar_alt_2 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Year_calendar_alt_2_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_3                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Year_calendar_alt_3 (OSCTXT* pctxt,
   Year_calendar_alt_3 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Year_calendar_alt_3 (OSCTXT* pctxt, Year_calendar_alt_3 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Year_calendar_alt_3_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_4                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Year_calendar_alt_4 (OSCTXT* pctxt,
   Year_calendar_alt_4 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Year_calendar_alt_4 (OSCTXT* pctxt, Year_calendar_alt_4 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Year_calendar_alt_4_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_5                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Year_calendar_alt_5 (OSCTXT* pctxt,
   Year_calendar_alt_5 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Year_calendar_alt_5 (OSCTXT* pctxt, Year_calendar_alt_5 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Year_calendar_alt_5_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_6                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Year_calendar_alt_6 (OSCTXT* pctxt,
   Year_calendar_alt_6 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Year_calendar_alt_6 (OSCTXT* pctxt, Year_calendar_alt_6 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Year_calendar_alt_6_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_7                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Year_calendar_alt_7 (OSCTXT* pctxt,
   Year_calendar_alt_7 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Year_calendar_alt_7 (OSCTXT* pctxt, Year_calendar_alt_7 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Year_calendar_alt_7_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_8                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Year_calendar_alt_8 (OSCTXT* pctxt,
   Year_calendar_alt_8 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Year_calendar_alt_8 (OSCTXT* pctxt, Year_calendar_alt_8 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Year_calendar_alt_8_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Year_calendar (OSCTXT* pctxt,
   Year_calendar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            xe_utf8str (pctxt, pvalue->u.alt, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
            asn1E_Year_calendar_alt_1 (pctxt, &pvalue->u.alt_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
            asn1E_Year_calendar_alt_2 (pctxt, &pvalue->u.alt_2, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
            asn1E_Year_calendar_alt_3 (pctxt, &pvalue->u.alt_3, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
            asn1E_Year_calendar_alt_4 (pctxt, &pvalue->u.alt_4, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
            asn1E_Year_calendar_alt_5 (pctxt, &pvalue->u.alt_5, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
            asn1E_Year_calendar_alt_6 (pctxt, &pvalue->u.alt_6, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
            asn1E_Year_calendar_alt_7 (pctxt, &pvalue->u.alt_7, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
            asn1E_Year_calendar_alt_8 (pctxt, &pvalue->u.alt_8, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_Year_calendar (OSCTXT* pctxt, Year_calendar* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   switch (pvalue->t)
   {
      case 1:
         /* encode alt */

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.alt, 0, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode alt_1 */

         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Year_calendar_alt_1 (pctxt, pvalue->u.alt_1
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode alt_2 */

         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Year_calendar_alt_2 (pctxt, pvalue->u.alt_2
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode alt_3 */

         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Year_calendar_alt_3 (pctxt, pvalue->u.alt_3
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode alt_4 */

         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Year_calendar_alt_4 (pctxt, pvalue->u.alt_4
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode alt_5 */

         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Year_calendar_alt_5 (pctxt, pvalue->u.alt_5
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode alt_6 */

         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Year_calendar_alt_6 (pctxt, pvalue->u.alt_6
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode alt_7 */

         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Year_calendar_alt_7 (pctxt, pvalue->u.alt_7
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode alt_8 */

         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Year_calendar_alt_8 (pctxt, pvalue->u.alt_8
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_style                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Year_style (OSCTXT* pctxt,
   Year_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Year_style (OSCTXT* pctxt, Year_style value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Year_style_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Ns14_Year (OSCTXT* pctxt,
   Ns14_Year *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode style */

   if (pvalue->m.stylePresent) {
      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Year_style (pctxt, &pvalue->style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode calendar */

   if (pvalue->m.calendarPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_Year_calendar (pctxt, &pvalue->calendar, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Ns14_Year (OSCTXT* pctxt, Ns14_Year* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.calendarPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:calendar=\""), 16);

      stat = XmlEnc_Year_calendar (pctxt, &pvalue->calendar, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:style=\""), 13);

      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Year_style (pctxt, pvalue->style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_1                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Era_calendar_alt_1 (OSCTXT* pctxt,
   Era_calendar_alt_1 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Era_calendar_alt_1 (OSCTXT* pctxt, Era_calendar_alt_1 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Era_calendar_alt_1_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_2                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Era_calendar_alt_2 (OSCTXT* pctxt,
   Era_calendar_alt_2 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Era_calendar_alt_2 (OSCTXT* pctxt, Era_calendar_alt_2 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Era_calendar_alt_2_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_3                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Era_calendar_alt_3 (OSCTXT* pctxt,
   Era_calendar_alt_3 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Era_calendar_alt_3 (OSCTXT* pctxt, Era_calendar_alt_3 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Era_calendar_alt_3_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_4                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Era_calendar_alt_4 (OSCTXT* pctxt,
   Era_calendar_alt_4 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Era_calendar_alt_4 (OSCTXT* pctxt, Era_calendar_alt_4 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Era_calendar_alt_4_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_5                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Era_calendar_alt_5 (OSCTXT* pctxt,
   Era_calendar_alt_5 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Era_calendar_alt_5 (OSCTXT* pctxt, Era_calendar_alt_5 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Era_calendar_alt_5_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_6                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Era_calendar_alt_6 (OSCTXT* pctxt,
   Era_calendar_alt_6 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Era_calendar_alt_6 (OSCTXT* pctxt, Era_calendar_alt_6 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Era_calendar_alt_6_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_7                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Era_calendar_alt_7 (OSCTXT* pctxt,
   Era_calendar_alt_7 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Era_calendar_alt_7 (OSCTXT* pctxt, Era_calendar_alt_7 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Era_calendar_alt_7_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_8                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Era_calendar_alt_8 (OSCTXT* pctxt,
   Era_calendar_alt_8 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Era_calendar_alt_8 (OSCTXT* pctxt, Era_calendar_alt_8 value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Era_calendar_alt_8_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Era_calendar (OSCTXT* pctxt,
   Era_calendar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            xe_utf8str (pctxt, pvalue->u.alt, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
            asn1E_Era_calendar_alt_1 (pctxt, &pvalue->u.alt_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
            asn1E_Era_calendar_alt_2 (pctxt, &pvalue->u.alt_2, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
            asn1E_Era_calendar_alt_3 (pctxt, &pvalue->u.alt_3, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
            asn1E_Era_calendar_alt_4 (pctxt, &pvalue->u.alt_4, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
            asn1E_Era_calendar_alt_5 (pctxt, &pvalue->u.alt_5, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
            asn1E_Era_calendar_alt_6 (pctxt, &pvalue->u.alt_6, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
            asn1E_Era_calendar_alt_7 (pctxt, &pvalue->u.alt_7, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
            asn1E_Era_calendar_alt_8 (pctxt, &pvalue->u.alt_8, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_Era_calendar (OSCTXT* pctxt, Era_calendar* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   switch (pvalue->t)
   {
      case 1:
         /* encode alt */

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.alt, 0, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode alt_1 */

         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Era_calendar_alt_1 (pctxt, pvalue->u.alt_1
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode alt_2 */

         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Era_calendar_alt_2 (pctxt, pvalue->u.alt_2
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode alt_3 */

         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Era_calendar_alt_3 (pctxt, pvalue->u.alt_3
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode alt_4 */

         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Era_calendar_alt_4 (pctxt, pvalue->u.alt_4
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode alt_5 */

         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Era_calendar_alt_5 (pctxt, pvalue->u.alt_5
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode alt_6 */

         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Era_calendar_alt_6 (pctxt, pvalue->u.alt_6
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode alt_7 */

         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Era_calendar_alt_7 (pctxt, pvalue->u.alt_7
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode alt_8 */

         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Era_calendar_alt_8 (pctxt, pvalue->u.alt_8
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_style                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Era_style (OSCTXT* pctxt,
   Era_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Era_style (OSCTXT* pctxt, Era_style value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Era_style_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era                                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Era (OSCTXT* pctxt,
   Era *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode style */

   if (pvalue->m.stylePresent) {
      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Era_style (pctxt, &pvalue->style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode calendar */

   if (pvalue->m.calendarPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_Era_calendar (pctxt, &pvalue->calendar, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Era (OSCTXT* pctxt, Era* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.calendarPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:calendar=\""), 16);

      stat = XmlEnc_Era_calendar (pctxt, &pvalue->calendar, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:style=\""), 13);

      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Era_style (pctxt, pvalue->style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_1                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_of_week_calendar_alt_1 (OSCTXT* pctxt,
   Day_of_week_calendar_alt_1 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_of_week_calendar_alt_1 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_1 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_of_week_calendar_alt_1_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_2                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_of_week_calendar_alt_2 (OSCTXT* pctxt,
   Day_of_week_calendar_alt_2 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_of_week_calendar_alt_2 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_2 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_of_week_calendar_alt_2_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_3                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_of_week_calendar_alt_3 (OSCTXT* pctxt,
   Day_of_week_calendar_alt_3 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_of_week_calendar_alt_3 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_3 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_of_week_calendar_alt_3_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_4                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_of_week_calendar_alt_4 (OSCTXT* pctxt,
   Day_of_week_calendar_alt_4 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_of_week_calendar_alt_4 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_4 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_of_week_calendar_alt_4_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_5                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_of_week_calendar_alt_5 (OSCTXT* pctxt,
   Day_of_week_calendar_alt_5 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_of_week_calendar_alt_5 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_5 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_of_week_calendar_alt_5_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_6                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_of_week_calendar_alt_6 (OSCTXT* pctxt,
   Day_of_week_calendar_alt_6 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_of_week_calendar_alt_6 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_6 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_of_week_calendar_alt_6_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_7                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_of_week_calendar_alt_7 (OSCTXT* pctxt,
   Day_of_week_calendar_alt_7 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_of_week_calendar_alt_7 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_7 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_of_week_calendar_alt_7_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_8                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_of_week_calendar_alt_8 (OSCTXT* pctxt,
   Day_of_week_calendar_alt_8 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_of_week_calendar_alt_8 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_8 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_of_week_calendar_alt_8_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_of_week_calendar (OSCTXT* pctxt,
   Day_of_week_calendar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            xe_utf8str (pctxt, pvalue->u.alt, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
            asn1E_Day_of_week_calendar_alt_1 (pctxt, &pvalue->u.alt_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
            asn1E_Day_of_week_calendar_alt_2 (pctxt, &pvalue->u.alt_2, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
            asn1E_Day_of_week_calendar_alt_3 (pctxt, &pvalue->u.alt_3, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
            asn1E_Day_of_week_calendar_alt_4 (pctxt, &pvalue->u.alt_4, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
            asn1E_Day_of_week_calendar_alt_5 (pctxt, &pvalue->u.alt_5, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
            asn1E_Day_of_week_calendar_alt_6 (pctxt, &pvalue->u.alt_6, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
            asn1E_Day_of_week_calendar_alt_7 (pctxt, &pvalue->u.alt_7, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
            asn1E_Day_of_week_calendar_alt_8 (pctxt, &pvalue->u.alt_8, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_Day_of_week_calendar (OSCTXT* pctxt, Day_of_week_calendar* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   switch (pvalue->t)
   {
      case 1:
         /* encode alt */

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.alt, 0, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode alt_1 */

         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_of_week_calendar_alt_1 (pctxt, pvalue->u.alt_1
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode alt_2 */

         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_of_week_calendar_alt_2 (pctxt, pvalue->u.alt_2
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode alt_3 */

         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_of_week_calendar_alt_3 (pctxt, pvalue->u.alt_3
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode alt_4 */

         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_of_week_calendar_alt_4 (pctxt, pvalue->u.alt_4
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode alt_5 */

         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_of_week_calendar_alt_5 (pctxt, pvalue->u.alt_5
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode alt_6 */

         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_of_week_calendar_alt_6 (pctxt, pvalue->u.alt_6
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode alt_7 */

         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_of_week_calendar_alt_7 (pctxt, pvalue->u.alt_7
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode alt_8 */

         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Day_of_week_calendar_alt_8 (pctxt, pvalue->u.alt_8
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_style                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_of_week_style (OSCTXT* pctxt,
   Day_of_week_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Day_of_week_style (OSCTXT* pctxt, Day_of_week_style value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Day_of_week_style_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Day_of_week (OSCTXT* pctxt,
   Day_of_week *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode style */

   if (pvalue->m.stylePresent) {
      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Day_of_week_style (pctxt, &pvalue->style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode calendar */

   if (pvalue->m.calendarPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_Day_of_week_calendar (pctxt, &pvalue->calendar, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Day_of_week (OSCTXT* pctxt, Day_of_week* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.calendarPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:calendar=\""), 16);

      stat = XmlEnc_Day_of_week_calendar (pctxt, &pvalue->calendar, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:style=\""), 13);

      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Day_of_week_style (pctxt, pvalue->style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_1                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Week_of_year_calendar_alt_1 (OSCTXT* pctxt,
   Week_of_year_calendar_alt_1 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Week_of_year_calendar_alt_1 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_1 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Week_of_year_calendar_alt_1_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_2                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Week_of_year_calendar_alt_2 (OSCTXT* pctxt,
   Week_of_year_calendar_alt_2 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Week_of_year_calendar_alt_2 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_2 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Week_of_year_calendar_alt_2_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_3                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Week_of_year_calendar_alt_3 (OSCTXT* pctxt,
   Week_of_year_calendar_alt_3 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Week_of_year_calendar_alt_3 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_3 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Week_of_year_calendar_alt_3_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_4                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Week_of_year_calendar_alt_4 (OSCTXT* pctxt,
   Week_of_year_calendar_alt_4 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Week_of_year_calendar_alt_4 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_4 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Week_of_year_calendar_alt_4_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_5                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Week_of_year_calendar_alt_5 (OSCTXT* pctxt,
   Week_of_year_calendar_alt_5 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Week_of_year_calendar_alt_5 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_5 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Week_of_year_calendar_alt_5_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_6                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Week_of_year_calendar_alt_6 (OSCTXT* pctxt,
   Week_of_year_calendar_alt_6 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Week_of_year_calendar_alt_6 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_6 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Week_of_year_calendar_alt_6_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_7                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Week_of_year_calendar_alt_7 (OSCTXT* pctxt,
   Week_of_year_calendar_alt_7 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Week_of_year_calendar_alt_7 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_7 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Week_of_year_calendar_alt_7_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_8                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Week_of_year_calendar_alt_8 (OSCTXT* pctxt,
   Week_of_year_calendar_alt_8 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Week_of_year_calendar_alt_8 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_8 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Week_of_year_calendar_alt_8_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Week_of_year_calendar (OSCTXT* pctxt,
   Week_of_year_calendar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            xe_utf8str (pctxt, pvalue->u.alt, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
            asn1E_Week_of_year_calendar_alt_1 (pctxt, &pvalue->u.alt_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
            asn1E_Week_of_year_calendar_alt_2 (pctxt, &pvalue->u.alt_2, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
            asn1E_Week_of_year_calendar_alt_3 (pctxt, &pvalue->u.alt_3, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
            asn1E_Week_of_year_calendar_alt_4 (pctxt, &pvalue->u.alt_4, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
            asn1E_Week_of_year_calendar_alt_5 (pctxt, &pvalue->u.alt_5, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
            asn1E_Week_of_year_calendar_alt_6 (pctxt, &pvalue->u.alt_6, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
            asn1E_Week_of_year_calendar_alt_7 (pctxt, &pvalue->u.alt_7, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
            asn1E_Week_of_year_calendar_alt_8 (pctxt, &pvalue->u.alt_8, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_Week_of_year_calendar (OSCTXT* pctxt, 
   Week_of_year_calendar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   switch (pvalue->t)
   {
      case 1:
         /* encode alt */

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.alt, 0, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode alt_1 */

         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Week_of_year_calendar_alt_1 (pctxt, pvalue->u.alt_1
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode alt_2 */

         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Week_of_year_calendar_alt_2 (pctxt, pvalue->u.alt_2
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode alt_3 */

         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Week_of_year_calendar_alt_3 (pctxt, pvalue->u.alt_3
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode alt_4 */

         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Week_of_year_calendar_alt_4 (pctxt, pvalue->u.alt_4
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode alt_5 */

         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Week_of_year_calendar_alt_5 (pctxt, pvalue->u.alt_5
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode alt_6 */

         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Week_of_year_calendar_alt_6 (pctxt, pvalue->u.alt_6
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode alt_7 */

         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Week_of_year_calendar_alt_7 (pctxt, pvalue->u.alt_7
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode alt_8 */

         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Week_of_year_calendar_alt_8 (pctxt, pvalue->u.alt_8
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Week_of_year (OSCTXT* pctxt,
   Week_of_year *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode calendar */

   if (pvalue->m.calendarPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_Week_of_year_calendar (pctxt, &pvalue->calendar, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Week_of_year (OSCTXT* pctxt, Week_of_year* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.calendarPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:calendar=\""), 16);

      stat = XmlEnc_Week_of_year_calendar (pctxt, &pvalue->calendar, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_1                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Quarter_calendar_alt_1 (OSCTXT* pctxt,
   Quarter_calendar_alt_1 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Quarter_calendar_alt_1 (OSCTXT* pctxt, 
   Quarter_calendar_alt_1 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Quarter_calendar_alt_1_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_2                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Quarter_calendar_alt_2 (OSCTXT* pctxt,
   Quarter_calendar_alt_2 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Quarter_calendar_alt_2 (OSCTXT* pctxt, 
   Quarter_calendar_alt_2 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Quarter_calendar_alt_2_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_3                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Quarter_calendar_alt_3 (OSCTXT* pctxt,
   Quarter_calendar_alt_3 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Quarter_calendar_alt_3 (OSCTXT* pctxt, 
   Quarter_calendar_alt_3 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Quarter_calendar_alt_3_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_4                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Quarter_calendar_alt_4 (OSCTXT* pctxt,
   Quarter_calendar_alt_4 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Quarter_calendar_alt_4 (OSCTXT* pctxt, 
   Quarter_calendar_alt_4 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Quarter_calendar_alt_4_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_5                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Quarter_calendar_alt_5 (OSCTXT* pctxt,
   Quarter_calendar_alt_5 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Quarter_calendar_alt_5 (OSCTXT* pctxt, 
   Quarter_calendar_alt_5 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Quarter_calendar_alt_5_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_6                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Quarter_calendar_alt_6 (OSCTXT* pctxt,
   Quarter_calendar_alt_6 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Quarter_calendar_alt_6 (OSCTXT* pctxt, 
   Quarter_calendar_alt_6 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Quarter_calendar_alt_6_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_7                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Quarter_calendar_alt_7 (OSCTXT* pctxt,
   Quarter_calendar_alt_7 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Quarter_calendar_alt_7 (OSCTXT* pctxt, 
   Quarter_calendar_alt_7 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Quarter_calendar_alt_7_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_8                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Quarter_calendar_alt_8 (OSCTXT* pctxt,
   Quarter_calendar_alt_8 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Quarter_calendar_alt_8 (OSCTXT* pctxt, 
   Quarter_calendar_alt_8 value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Quarter_calendar_alt_8_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Quarter_calendar (OSCTXT* pctxt,
   Quarter_calendar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
            xe_utf8str (pctxt, pvalue->u.alt, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
            asn1E_Quarter_calendar_alt_1 (pctxt, &pvalue->u.alt_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
            asn1E_Quarter_calendar_alt_2 (pctxt, &pvalue->u.alt_2, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
            asn1E_Quarter_calendar_alt_3 (pctxt, &pvalue->u.alt_3, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
            asn1E_Quarter_calendar_alt_4 (pctxt, &pvalue->u.alt_4, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
            asn1E_Quarter_calendar_alt_5 (pctxt, &pvalue->u.alt_5, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
            asn1E_Quarter_calendar_alt_6 (pctxt, &pvalue->u.alt_6, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
            asn1E_Quarter_calendar_alt_7 (pctxt, &pvalue->u.alt_7, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
            asn1E_Quarter_calendar_alt_8 (pctxt, &pvalue->u.alt_8, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_Quarter_calendar (OSCTXT* pctxt, Quarter_calendar* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   switch (pvalue->t)
   {
      case 1:
         /* encode alt */

         stat = rtXmlEncUTF8Str (pctxt, pvalue->u.alt, 0, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode alt_1 */

         if(pvalue->u.alt_1 < 0 || pvalue->u.alt_1 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Quarter_calendar_alt_1 (pctxt, pvalue->u.alt_1
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode alt_2 */

         if(pvalue->u.alt_2 < 0 || pvalue->u.alt_2 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Quarter_calendar_alt_2 (pctxt, pvalue->u.alt_2
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode alt_3 */

         if(pvalue->u.alt_3 < 0 || pvalue->u.alt_3 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Quarter_calendar_alt_3 (pctxt, pvalue->u.alt_3
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode alt_4 */

         if(pvalue->u.alt_4 < 0 || pvalue->u.alt_4 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Quarter_calendar_alt_4 (pctxt, pvalue->u.alt_4
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode alt_5 */

         if(pvalue->u.alt_5 < 0 || pvalue->u.alt_5 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Quarter_calendar_alt_5 (pctxt, pvalue->u.alt_5
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode alt_6 */

         if(pvalue->u.alt_6 < 0 || pvalue->u.alt_6 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Quarter_calendar_alt_6 (pctxt, pvalue->u.alt_6
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode alt_7 */

         if(pvalue->u.alt_7 < 0 || pvalue->u.alt_7 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Quarter_calendar_alt_7 (pctxt, pvalue->u.alt_7
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode alt_8 */

         if(pvalue->u.alt_8 < 0 || pvalue->u.alt_8 > 0)
            return LOG_RTERR (pctxt, RTERR_INVENUM);

         stat = XmlEnc_Quarter_calendar_alt_8 (pctxt, pvalue->u.alt_8
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_style                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Quarter_style (OSCTXT* pctxt,
   Quarter_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Quarter_style (OSCTXT* pctxt, Quarter_style value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Quarter_style_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Quarter (OSCTXT* pctxt,
   Quarter *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode style */

   if (pvalue->m.stylePresent) {
      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Quarter_style (pctxt, &pvalue->style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode calendar */

   if (pvalue->m.calendarPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_Quarter_calendar (pctxt, &pvalue->calendar, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Quarter (OSCTXT* pctxt, Quarter* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.calendarPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:calendar=\""), 16);

      stat = XmlEnc_Quarter_calendar (pctxt, &pvalue->calendar, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:style=\""), 13);

      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Quarter_style (pctxt, pvalue->style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Hours_style                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Hours_style (OSCTXT* pctxt,
   Hours_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Hours_style (OSCTXT* pctxt, Hours_style value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Hours_style_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Hours                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Hours (OSCTXT* pctxt,
   Hours *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode style */

   if (pvalue->m.stylePresent) {
      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Hours_style (pctxt, &pvalue->style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Hours (OSCTXT* pctxt, Hours* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:style=\""), 13);

      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Hours_style (pctxt, pvalue->style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Am_pm                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Am_pm (OSCTXT* pctxt,
   Am_pm *pvalue, ASN1TagType tagging)
{
   int ll0 = 0;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Am_pm (OSCTXT* pctxt, Am_pm* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Minutes_style                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Minutes_style (OSCTXT* pctxt,
   Minutes_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Minutes_style (OSCTXT* pctxt, Minutes_style value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Minutes_style_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Minutes                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Minutes (OSCTXT* pctxt,
   Minutes *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode style */

   if (pvalue->m.stylePresent) {
      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Minutes_style (pctxt, &pvalue->style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Minutes (OSCTXT* pctxt, Minutes* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:style=\""), 13);

      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Minutes_style (pctxt, pvalue->style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Seconds_style                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Seconds_style (OSCTXT* pctxt,
   Seconds_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Seconds_style (OSCTXT* pctxt, Seconds_style value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Seconds_style_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Seconds                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Seconds (OSCTXT* pctxt,
   Seconds *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode style */

   if (pvalue->m.stylePresent) {
      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Seconds_style (pctxt, &pvalue->style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode decimal_places */

   if (pvalue->m.decimal_placesPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_integer (pctxt, &pvalue->decimal_places, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Seconds (OSCTXT* pctxt, Seconds* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.decimal_placesPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->decimal_places, OSUTF8("ns14:decimal-places"), 19);
   }

   if (pvalue->m.stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:style=\""), 13);

      if(pvalue->style < 0 || pvalue->style > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Seconds_style (pctxt, pvalue->style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date_style_element_choice                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Date_style_element_choice (OSCTXT* pctxt,
   Date_style_element_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_Ns14_Day (pctxt, pvalue->u.day, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_Ns14_Month (pctxt, pvalue->u.month, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_Ns14_Year (pctxt, pvalue->u.year, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_Era (pctxt, pvalue->u.era, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_Day_of_week (pctxt, pvalue->u.day_of_week, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
            asn1E_Week_of_year (pctxt, pvalue->u.week_of_year, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
            asn1E_Quarter (pctxt, pvalue->u.quarter, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
            asn1E_Hours (pctxt, pvalue->u.hours, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
            asn1E_Am_pm (pctxt, pvalue->u.am_pm, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 10:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
            asn1E_Minutes (pctxt, pvalue->u.minutes, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 11:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
            asn1E_Seconds (pctxt, pvalue->u.seconds, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_Date_style_element_choice (OSCTXT* pctxt, 
   Date_style_element_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   switch (pvalue->t)
   {
      case 1:
         /* encode day */

         stat = XmlEnc_Ns14_Day (pctxt, pvalue->u.day
            , OSUTF8("day"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode month */

         stat = XmlEnc_Ns14_Month (pctxt, pvalue->u.month
            , OSUTF8("month"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode year */

         stat = XmlEnc_Ns14_Year (pctxt, pvalue->u.year
            , OSUTF8("year"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode era */

         stat = XmlEnc_Era (pctxt, pvalue->u.era, OSUTF8("era"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode day_of_week */

         stat = XmlEnc_Day_of_week (pctxt, pvalue->u.day_of_week
            , OSUTF8("day-of-week"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode week_of_year */

         stat = XmlEnc_Week_of_year (pctxt, pvalue->u.week_of_year
            , OSUTF8("week-of-year"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode quarter */

         stat = XmlEnc_Quarter (pctxt, pvalue->u.quarter
            , OSUTF8("quarter"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode hours */

         stat = XmlEnc_Hours (pctxt, pvalue->u.hours
            , OSUTF8("hours"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode am_pm */

         stat = XmlEnc_Am_pm (pctxt, pvalue->u.am_pm
            , OSUTF8("am-pm"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 10:
         /* encode minutes */

         stat = XmlEnc_Minutes (pctxt, pvalue->u.minutes
            , OSUTF8("minutes"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 11:
         /* encode seconds */

         stat = XmlEnc_Seconds (pctxt, pvalue->u.seconds
            , OSUTF8("seconds"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date_style_element                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Date_style_element (OSCTXT* pctxt,
   Date_style_element *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_Date_style_element_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Date_style_element (OSCTXT* pctxt, Date_style_element* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode choice */

   stat = XmlEnc_Date_style_element_choice (pctxt, &pvalue->choice
      , OSUTF8(""), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date_style                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Date_style (OSCTXT* pctxt,
   Date_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode map_list */

   pnode2 = pvalue->map_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Ns8_Map (pctxt, (Ns8_Map*)((Ns8_Map*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|14, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode sequence_list */

   pnode2 = pvalue->sequence_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Date_style_element (pctxt, ((Date_style_element*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|13, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|12,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      if (pvalue->text_properties == NULL) {
         rtxErrAddStrParm (pctxt, "pvalue->text_properties");
         return LOG_RTERR (pctxt, RTERR_NULLPTR);
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
         asn1E_Ns8_Text_properties (pctxt, (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode volatile_ */

   if (pvalue->m.volatile_Present) {
      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
         asn1E_Ns8_Volatile (pctxt, (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode name */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
      asn1E_Ns8_Name (pctxt, (Ns8_Name)pvalue->name, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode transliteration_style */

   if (pvalue->m.transliteration_stylePresent) {
      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         asn1E_Date_style_transliteration_style (pctxt, &pvalue->transliteration_style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_language */

   if (pvalue->m.transliteration_languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         xe_utf8str (pctxt, pvalue->transliteration_language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_format */

   if (pvalue->m.transliteration_formatPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         xe_utf8str (pctxt, pvalue->transliteration_format, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_country */

   if (pvalue->m.transliteration_countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_utf8str (pctxt, pvalue->transliteration_country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode title */

   if (pvalue->m.titlePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->title, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode language */

   if (pvalue->m.languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode format_source */

   if (pvalue->m.format_sourcePresent) {
      if(pvalue->format_source < 0 || pvalue->format_source > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_Date_style_format_source (pctxt, &pvalue->format_source, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode country */

   if (pvalue->m.countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode automatic_order */

   if (pvalue->m.automatic_orderPresent) {
      if(pvalue->automatic_order < 0 || pvalue->automatic_order > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Date_style_automatic_order (pctxt, &pvalue->automatic_order, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Date_style (OSCTXT* pctxt, Date_style* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.automatic_orderPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:automatic-order=\""), 23);

      if(pvalue->automatic_order < 0 || pvalue->automatic_order > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Date_style_automatic_order (pctxt, pvalue->automatic_order
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:country=\""), 15);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.format_sourcePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:format-source=\""), 21);

      if(pvalue->format_source < 0 || pvalue->format_source > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Date_style_format_source (pctxt, pvalue->format_source
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:language=\""), 16);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.titlePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:title=\""), 13);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->title, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-country=\""), 31);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_formatPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-format=\""), 30);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_format, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-language=\""), 32);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-style=\""), 29);

      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style
          > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Date_style_transliteration_style (pctxt, pvalue->
         transliteration_style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:name=\""), 11);

   stat = XmlEnc_Ns8_Name (pctxt, pvalue->name, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.volatile_Present) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:volatile=\""), 15);

      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Ns8_Volatile (pctxt, pvalue->volatile_, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      stat = XmlEnc_Ns8_Text_properties (pctxt, pvalue->text_properties
         , OSUTF8("text-properties"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode sequence_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   { OSRTDListNode* pnode = pvalue->sequence_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Date_style_element (pctxt, 
         ((Date_style_element*)pnode->data), 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   /* encode map_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   { OSRTDListNode* pnode = pvalue->map_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Ns8_Map (pctxt, ((Ns8_Map*)pnode->data)
         , OSUTF8("map"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time_style_format_source                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Time_style_format_source (OSCTXT* pctxt,
   Time_style_format_source *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Time_style_format_source (OSCTXT* pctxt, 
   Time_style_format_source value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Time_style_format_source_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time_style_transliteration_style                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Time_style_transliteration_style (OSCTXT* pctxt,
   Time_style_transliteration_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Time_style_transliteration_style (OSCTXT* pctxt, 
   Time_style_transliteration_style value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Time_style_transliteration_style_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time_style_truncate_on_overflow                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Time_style_truncate_on_overflow (OSCTXT* pctxt,
   Time_style_truncate_on_overflow *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Time_style_truncate_on_overflow (OSCTXT* pctxt, 
   Time_style_truncate_on_overflow value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Time_style_truncate_on_overflow_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time_style_element_choice                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Time_style_element_choice (OSCTXT* pctxt,
   Time_style_element_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_Hours (pctxt, pvalue->u.hours, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_Am_pm (pctxt, pvalue->u.am_pm, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_Minutes (pctxt, pvalue->u.minutes, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_Seconds (pctxt, pvalue->u.seconds, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_Time_style_element_choice (OSCTXT* pctxt, 
   Time_style_element_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   switch (pvalue->t)
   {
      case 1:
         /* encode hours */

         stat = XmlEnc_Hours (pctxt, pvalue->u.hours
            , OSUTF8("hours"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode am_pm */

         stat = XmlEnc_Am_pm (pctxt, pvalue->u.am_pm
            , OSUTF8("am-pm"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode minutes */

         stat = XmlEnc_Minutes (pctxt, pvalue->u.minutes
            , OSUTF8("minutes"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode seconds */

         stat = XmlEnc_Seconds (pctxt, pvalue->u.seconds
            , OSUTF8("seconds"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time_style_element                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Time_style_element (OSCTXT* pctxt,
   Time_style_element *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_Time_style_element_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Time_style_element (OSCTXT* pctxt, Time_style_element* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode choice */

   stat = XmlEnc_Time_style_element_choice (pctxt, &pvalue->choice
      , OSUTF8(""), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time_style                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Time_style (OSCTXT* pctxt,
   Time_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode map_list */

   pnode2 = pvalue->map_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Ns8_Map (pctxt, (Ns8_Map*)((Ns8_Map*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|14, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode sequence_list */

   pnode2 = pvalue->sequence_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Time_style_element (pctxt, ((Time_style_element*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|13, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|12,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      if (pvalue->text_properties == NULL) {
         rtxErrAddStrParm (pctxt, "pvalue->text_properties");
         return LOG_RTERR (pctxt, RTERR_NULLPTR);
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
         asn1E_Ns8_Text_properties (pctxt, (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode volatile_ */

   if (pvalue->m.volatile_Present) {
      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
         asn1E_Ns8_Volatile (pctxt, (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode name */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
      asn1E_Ns8_Name (pctxt, (Ns8_Name)pvalue->name, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode truncate_on_overflow */

   if (pvalue->m.truncate_on_overflowPresent) {
      if(pvalue->truncate_on_overflow < 0 || pvalue->truncate_on_overflow > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         asn1E_Time_style_truncate_on_overflow (pctxt, &pvalue->truncate_on_overflow, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_style */

   if (pvalue->m.transliteration_stylePresent) {
      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         asn1E_Time_style_transliteration_style (pctxt, &pvalue->transliteration_style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_language */

   if (pvalue->m.transliteration_languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         xe_utf8str (pctxt, pvalue->transliteration_language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_format */

   if (pvalue->m.transliteration_formatPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_utf8str (pctxt, pvalue->transliteration_format, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_country */

   if (pvalue->m.transliteration_countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->transliteration_country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode title */

   if (pvalue->m.titlePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->title, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode language */

   if (pvalue->m.languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode format_source */

   if (pvalue->m.format_sourcePresent) {
      if(pvalue->format_source < 0 || pvalue->format_source > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Time_style_format_source (pctxt, &pvalue->format_source, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode country */

   if (pvalue->m.countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Time_style (OSCTXT* pctxt, Time_style* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:country=\""), 15);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.format_sourcePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:format-source=\""), 21);

      if(pvalue->format_source < 0 || pvalue->format_source > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Time_style_format_source (pctxt, pvalue->format_source
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:language=\""), 16);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.titlePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:title=\""), 13);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->title, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-country=\""), 31);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_formatPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-format=\""), 30);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_format, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-language=\""), 32);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-style=\""), 29);

      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style
          > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Time_style_transliteration_style (pctxt, pvalue->
         transliteration_style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.truncate_on_overflowPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:truncate-on-overflow=\""), 28);

      if(pvalue->truncate_on_overflow < 0 || pvalue->truncate_on_overflow > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Time_style_truncate_on_overflow (pctxt, pvalue->
         truncate_on_overflow, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:name=\""), 11);

   stat = XmlEnc_Ns8_Name (pctxt, pvalue->name, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.volatile_Present) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:volatile=\""), 15);

      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Ns8_Volatile (pctxt, pvalue->volatile_, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      stat = XmlEnc_Ns8_Text_properties (pctxt, pvalue->text_properties
         , OSUTF8("text-properties"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode sequence_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   { OSRTDListNode* pnode = pvalue->sequence_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Time_style_element (pctxt, 
         ((Time_style_element*)pnode->data), 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   /* encode map_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   { OSRTDListNode* pnode = pvalue->map_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Ns8_Map (pctxt, ((Ns8_Map*)pnode->data)
         , OSUTF8("map"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Boolean_style_transliteration_style                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Boolean_style_transliteration_style (OSCTXT* pctxt,
   Boolean_style_transliteration_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Boolean_style_transliteration_style (OSCTXT* pctxt, 
   Boolean_style_transliteration_style value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Boolean_style_transliteration_style_ToString (value)
         , elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Boolean                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Ns14_Boolean (OSCTXT* pctxt,
   Ns14_Boolean *pvalue, ASN1TagType tagging)
{
   int ll0 = 0;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Ns14_Boolean (OSCTXT* pctxt, Ns14_Boolean* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Boolean_style_sequence                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Boolean_style_sequence (OSCTXT* pctxt,
   Boolean_style_sequence *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode boolean_ */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_Ns14_Boolean (pctxt, &pvalue->boolean_, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Boolean_style_sequence (OSCTXT* pctxt, 
   Boolean_style_sequence* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode boolean_ */

   stat = XmlEnc_Ns14_Boolean (pctxt, &pvalue->boolean_
      , OSUTF8("boolean"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Boolean_style                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Boolean_style (OSCTXT* pctxt,
   Boolean_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode map_list */

   pnode2 = pvalue->map_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Ns8_Map (pctxt, (Ns8_Map*)((Ns8_Map*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode sequence */

   if (pvalue->m.sequencePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
         asn1E_Boolean_style_sequence (pctxt, &pvalue->sequence, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      if (pvalue->text_properties == NULL) {
         rtxErrAddStrParm (pctxt, "pvalue->text_properties");
         return LOG_RTERR (pctxt, RTERR_NULLPTR);
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
         asn1E_Ns8_Text_properties (pctxt, (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode volatile_ */

   if (pvalue->m.volatile_Present) {
      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         asn1E_Ns8_Volatile (pctxt, (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode name */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
      asn1E_Ns8_Name (pctxt, (Ns8_Name)pvalue->name, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode transliteration_style */

   if (pvalue->m.transliteration_stylePresent) {
      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_Boolean_style_transliteration_style (pctxt, &pvalue->transliteration_style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_language */

   if (pvalue->m.transliteration_languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_utf8str (pctxt, pvalue->transliteration_language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_format */

   if (pvalue->m.transliteration_formatPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->transliteration_format, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_country */

   if (pvalue->m.transliteration_countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->transliteration_country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode title */

   if (pvalue->m.titlePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->title, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode language */

   if (pvalue->m.languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode country */

   if (pvalue->m.countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Boolean_style (OSCTXT* pctxt, Boolean_style* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:country=\""), 15);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:language=\""), 16);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.titlePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:title=\""), 13);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->title, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-country=\""), 31);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_formatPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-format=\""), 30);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_format, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-language=\""), 32);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-style=\""), 29);

      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style
          > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Boolean_style_transliteration_style (pctxt, pvalue->
         transliteration_style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:name=\""), 11);

   stat = XmlEnc_Ns8_Name (pctxt, pvalue->name, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.volatile_Present) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:volatile=\""), 15);

      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Ns8_Volatile (pctxt, pvalue->volatile_, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      stat = XmlEnc_Ns8_Text_properties (pctxt, pvalue->text_properties
         , OSUTF8("text-properties"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode sequence */

   if (pvalue->m.sequencePresent) {
      stat = XmlEnc_Boolean_style_sequence (pctxt, &pvalue->sequence
         , OSUTF8(""), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode map_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   { OSRTDListNode* pnode = pvalue->map_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Ns8_Map (pctxt, ((Ns8_Map*)pnode->data)
         , OSUTF8("map"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Text_style_transliteration_style                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Text_style_transliteration_style (OSCTXT* pctxt,
   Text_style_transliteration_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Text_style_transliteration_style (OSCTXT* pctxt, 
   Text_style_transliteration_style value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Text_style_transliteration_style_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Text_content                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Text_content (OSCTXT* pctxt,
   Text_content *pvalue, ASN1TagType tagging)
{
   int ll0 = 0;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Text_content (OSCTXT* pctxt, Text_content* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Text_style_element                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Text_style_element (OSCTXT* pctxt,
   Text_style_element *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text_content */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_Text_content (pctxt, &pvalue->text_content, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Text_style_element (OSCTXT* pctxt, Text_style_element* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode text_content */

   stat = XmlEnc_Text_content (pctxt, &pvalue->text_content
      , OSUTF8("text-content"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Text_style                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Text_style (OSCTXT* pctxt,
   Text_style *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode map_list */

   pnode2 = pvalue->map_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Ns8_Map (pctxt, (Ns8_Map*)((Ns8_Map*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode sequence_list */

   pnode2 = pvalue->sequence_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Text_style_element (pctxt, ((Text_style_element*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode text */

   if (pvalue->m.textPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
         asn1E_Text (pctxt, pvalue->text, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      if (pvalue->text_properties == NULL) {
         rtxErrAddStrParm (pctxt, "pvalue->text_properties");
         return LOG_RTERR (pctxt, RTERR_NULLPTR);
      }
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
         asn1E_Ns8_Text_properties (pctxt, (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode volatile_ */

   if (pvalue->m.volatile_Present) {
      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         asn1E_Ns8_Volatile (pctxt, (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode name */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
      asn1E_Ns8_Name (pctxt, (Ns8_Name)pvalue->name, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode transliteration_style */

   if (pvalue->m.transliteration_stylePresent) {
      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_Text_style_transliteration_style (pctxt, &pvalue->transliteration_style, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_language */

   if (pvalue->m.transliteration_languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_utf8str (pctxt, pvalue->transliteration_language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_format */

   if (pvalue->m.transliteration_formatPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->transliteration_format, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode transliteration_country */

   if (pvalue->m.transliteration_countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->transliteration_country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode title */

   if (pvalue->m.titlePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->title, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode language */

   if (pvalue->m.languagePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->language, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode country */

   if (pvalue->m.countryPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->country, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Text_style (OSCTXT* pctxt, Text_style* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:country=\""), 15);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:language=\""), 16);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.titlePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:title=\""), 13);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->title, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_countryPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-country=\""), 31);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_country, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_formatPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-format=\""), 30);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_format, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_languagePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-language=\""), 32);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->transliteration_language, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.transliteration_stylePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns14:transliteration-style=\""), 29);

      if(pvalue->transliteration_style < 0 || pvalue->transliteration_style
          > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Text_style_transliteration_style (pctxt, pvalue->
         transliteration_style, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:name=\""), 11);

   stat = XmlEnc_Ns8_Name (pctxt, pvalue->name, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.volatile_Present) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" ns8:volatile=\""), 15);

      if(pvalue->volatile_ < 0 || pvalue->volatile_ > 1)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Ns8_Volatile (pctxt, pvalue->volatile_, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   /* encode text_properties */

   if (pvalue->m.text_propertiesPresent) {
      stat = XmlEnc_Ns8_Text_properties (pctxt, pvalue->text_properties
         , OSUTF8("text-properties"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode text */

   if (pvalue->m.textPresent) {
      stat = XmlEnc_Text (pctxt, pvalue->text, OSUTF8("text"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode sequence_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   { OSRTDListNode* pnode = pvalue->sequence_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Text_style_element (pctxt, 
         ((Text_style_element*)pnode->data), 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   /* encode map_list */

   { const OSUTF8CHAR* savedPrefix = nsPrefix;
   nsPrefix = rtXmlNSGetPrefix (pctxt, OSUTF8(
      "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"));

   { OSRTDListNode* pnode = pvalue->map_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Ns8_Map (pctxt, ((Ns8_Map*)pnode->data)
         , OSUTF8("map"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   nsPrefix = savedPrefix;
   }

   nsPrefix = savedPrefix;
   }

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

