/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "Ns14.h"
#include "Ns8.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  Number_style_transliteration_style                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Number_style_transliteration_style (OSCTXT* pctxt, 
   Number_style_transliteration_style *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Number_style_transliteration_style (OSCTXT* pctxt, 
   Number_style_transliteration_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Number_style_transliteration_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Text                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Text (OSCTXT* pctxt, Text *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Text (OSCTXT* pctxt, Text* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDynUTF8Str (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Number_grouping                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Number_grouping (OSCTXT* pctxt, Number_grouping *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Number_grouping (OSCTXT* pctxt, Number_grouping* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Number_grouping_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Embedded_text                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Embedded_text (OSCTXT* pctxt, Embedded_text *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode position */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->position, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Embedded_text (OSCTXT* pctxt, Embedded_text* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("position"), 8}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* position */
            stat = rtXmlpDecInt (pctxt, &pvalue->position);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Embedded_text");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Embedded_text");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Number                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Ns14_Number (OSCTXT* pctxt, Ns14_Number *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode decimal_places */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->decimal_places, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.decimal_placesPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode decimal_replacement */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->decimal_replacement, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.decimal_replacementPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode display_factor */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->display_factor, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.display_factorPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode grouping */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Number_grouping (pctxt, 
               &pvalue->grouping, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.groupingPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode min_integer_digits */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->min_integer_digits, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.min_integer_digitsPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode embedded_text_list */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Embedded_text* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->embedded_text_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Embedded_text, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Embedded_text (pdata2);

                  stat = asn1D_Embedded_text (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->embedded_text_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Ns14_Number (OSCTXT* pctxt, Ns14_Number* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("decimal-places"), 14}, 0 },
         { {OSUTF8("decimal-replacement"), 19}, 0 },
         { {OSUTF8("display-factor"), 14}, 0 },
         { {OSUTF8("grouping"), 8}, 0 },
         { {OSUTF8("min-integer-digits"), 18}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* decimal-places */
            stat = rtXmlpDecInt (pctxt, &pvalue->decimal_places);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.decimal_placesPresent = TRUE;
            break;

         case 1: /* decimal-replacement */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->decimal_replacement);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.decimal_replacementPresent = TRUE;
            break;

         case 2: /* display-factor */
            stat = rtXmlpDecDouble (pctxt, &pvalue->display_factor, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.display_factorPresent = TRUE;
            break;

         case 3: /* grouping */
            stat = XmlDec_Number_grouping (pctxt, &pvalue->grouping);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.groupingPresent = TRUE;
            break;

         case 4: /* min-integer-digits */
            stat = rtXmlpDecInt (pctxt, &pvalue->min_integer_digits);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.min_integer_digitsPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Ns14_Number");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Ns14_Number");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("embedded-text"), 13}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Embedded_text* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Embedded_text);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Embedded_text (pdata1);

            stat = XmlDec_Embedded_text (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->embedded_text_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Scientific_number_grouping                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Scientific_number_grouping (OSCTXT* pctxt, 
   Scientific_number_grouping *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Scientific_number_grouping (OSCTXT* pctxt, 
   Scientific_number_grouping* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Scientific_number_grouping_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Scientific_number                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Scientific_number (OSCTXT* pctxt, Scientific_number *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode decimal_places */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->decimal_places, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.decimal_placesPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode grouping */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Scientific_number_grouping (pctxt, 
               &pvalue->grouping, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.groupingPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode min_exponent_digits */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->min_exponent_digits, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.min_exponent_digitsPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode min_integer_digits */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->min_integer_digits, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.min_integer_digitsPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Scientific_number (OSCTXT* pctxt, Scientific_number* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("decimal-places"), 14}, 0 },
         { {OSUTF8("grouping"), 8}, 0 },
         { {OSUTF8("min-exponent-digits"), 19}, 0 },
         { {OSUTF8("min-integer-digits"), 18}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* decimal-places */
            stat = rtXmlpDecInt (pctxt, &pvalue->decimal_places);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.decimal_placesPresent = TRUE;
            break;

         case 1: /* grouping */
            stat = XmlDec_Scientific_number_grouping (pctxt, &pvalue->grouping
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.groupingPresent = TRUE;
            break;

         case 2: /* min-exponent-digits */
            stat = rtXmlpDecInt (pctxt, &pvalue->min_exponent_digits);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.min_exponent_digitsPresent = TRUE;
            break;

         case 3: /* min-integer-digits */
            stat = rtXmlpDecInt (pctxt, &pvalue->min_integer_digits);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.min_integer_digitsPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Scientific_number");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Scientific_number");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Fraction_grouping                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Fraction_grouping (OSCTXT* pctxt, Fraction_grouping *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Fraction_grouping (OSCTXT* pctxt, Fraction_grouping* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Fraction_grouping_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Fraction                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Fraction (OSCTXT* pctxt, Fraction *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode denominator_value */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->denominator_value, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.denominator_valuePresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode grouping */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Fraction_grouping (pctxt, 
               &pvalue->grouping, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.groupingPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode min_denominator_digits */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->min_denominator_digits, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.min_denominator_digitsPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode min_integer_digits */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->min_integer_digits, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.min_integer_digitsPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode min_numerator_digits */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->min_numerator_digits, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.min_numerator_digitsPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Fraction (OSCTXT* pctxt, Fraction* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("denominator-value"), 17}, 0 },
         { {OSUTF8("grouping"), 8}, 0 },
         { {OSUTF8("min-denominator-digits"), 22}, 0 },
         { {OSUTF8("min-integer-digits"), 18}, 0 },
         { {OSUTF8("min-numerator-digits"), 20}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* denominator-value */
            stat = rtXmlpDecInt (pctxt, &pvalue->denominator_value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.denominator_valuePresent = TRUE;
            break;

         case 1: /* grouping */
            stat = XmlDec_Fraction_grouping (pctxt, &pvalue->grouping);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.groupingPresent = TRUE;
            break;

         case 2: /* min-denominator-digits */
            stat = rtXmlpDecInt (pctxt, &pvalue->min_denominator_digits);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.min_denominator_digitsPresent = TRUE;
            break;

         case 3: /* min-integer-digits */
            stat = rtXmlpDecInt (pctxt, &pvalue->min_integer_digits);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.min_integer_digitsPresent = TRUE;
            break;

         case 4: /* min-numerator-digits */
            stat = rtXmlpDecInt (pctxt, &pvalue->min_numerator_digits);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.min_numerator_digitsPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Fraction");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Fraction");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Number_style_sequence_choice                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Number_style_sequence_choice (OSCTXT* pctxt, 
   Number_style_sequence_choice *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.number = rtxMemAllocType (pctxt, Ns14_Number);

         if (pvalue->u.number == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Ns14_Number (pvalue->u.number);
         stat = asn1D_Ns14_Number (pctxt, 
            pvalue->u.number, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.scientific_number
             = rtxMemAllocType (pctxt, Scientific_number);

         if (pvalue->u.scientific_number == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Scientific_number (pvalue->u.scientific_number);
         stat = asn1D_Scientific_number (pctxt, 
            pvalue->u.scientific_number, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.fraction = rtxMemAllocType (pctxt, Fraction);

         if (pvalue->u.fraction == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Fraction (pvalue->u.fraction);
         stat = asn1D_Fraction (pctxt, 
            pvalue->u.fraction, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Number_style_sequence_choice (OSCTXT* pctxt, 
   Number_style_sequence_choice* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("number"), 6}, 0}, 0 },
      {{{OSUTF8("scientific-number"), 17}, 0}, 1 },
      {{{OSUTF8("fraction"), 8}, 0}, 2 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 3, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* number */
      pvalue->u.number = rtxMemAllocType (pctxt, Ns14_Number);

      if (pvalue->u.number == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Ns14_Number (pvalue->u.number);

      stat = XmlDec_Ns14_Number (pctxt, pvalue->u.number);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* scientific-number */
      pvalue->u.scientific_number
          = rtxMemAllocType (pctxt, Scientific_number);

      if (pvalue->u.scientific_number == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Scientific_number (pvalue->u.scientific_number);

      stat = XmlDec_Scientific_number (pctxt, pvalue->u.scientific_number);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* fraction */
      pvalue->u.fraction = rtxMemAllocType (pctxt, Fraction);

      if (pvalue->u.fraction == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Fraction (pvalue->u.fraction);

      stat = XmlDec_Fraction (pctxt, pvalue->u.fraction);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Number_style_sequence                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Number_style_sequence (OSCTXT* pctxt, 
   Number_style_sequence *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Number_style_sequence_choice (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Number_style_sequence (OSCTXT* pctxt, Number_style_sequence* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("number"), 6}, 0}, 0 },
      {{{OSUTF8("scientific-number"), 17}, 0}, 0 },
      {{{OSUTF8("fraction"), 8}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}, {3, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /*  */
         stat = XmlDec_Number_style_sequence_choice (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Number_style                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Number_style (OSCTXT* pctxt, Number_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode country */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.countryPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode language */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languagePresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode title */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->title, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.titlePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode transliteration_country */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_countryPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode transliteration_format */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_format, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_formatPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode transliteration_language */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_languagePresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode transliteration_style */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Number_style_transliteration_style (pctxt, 
               &pvalue->transliteration_style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_stylePresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Name (pctxt, 
               (Ns8_Name*)&pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode volatile_ */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Volatile (pctxt, 
               (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.volatile_Present = TRUE;
            }
         }
         break;

      case 9:
         /* decode text_properties */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->text_properties
                = rtxMemAllocType (pctxt, Ns8_Text_properties);

            if (pvalue->text_properties == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);
            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);

            stat = asn1D_Ns8_Text_properties (pctxt, 
               (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.text_propertiesPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 10:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode sequence */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Number_style_sequence (pctxt, 
               &pvalue->sequence, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sequencePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 12:
         /* decode map_list */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Ns8_Map* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->map_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Ns8_Map, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Ns8_Map ((Ns8_Map*)pdata2);

                  stat = asn1D_Ns8_Map (pctxt, 
                     (Ns8_Map*)pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->map_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_CONS|12):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Number_style (OSCTXT* pctxt, Number_style* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("country"), 7}, 0 },
         { {OSUTF8("language"), 8}, 0 },
         { {OSUTF8("title"), 5}, 0 },
         { {OSUTF8("transliteration-country"), 23}, 0 },
         { {OSUTF8("transliteration-format"), 22}, 0 },
         { {OSUTF8("transliteration-language"), 24}, 0 },
         { {OSUTF8("transliteration-style"), 21}, 0 },
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("volatile"), 8}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 9, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->country);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.countryPresent = TRUE;
            break;

         case 1: /* language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.languagePresent = TRUE;
            break;

         case 2: /* title */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->title);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.titlePresent = TRUE;
            break;

         case 3: /* transliteration-country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_country
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_countryPresent = TRUE;
            break;

         case 4: /* transliteration-format */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_format
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_formatPresent = TRUE;
            break;

         case 5: /* transliteration-language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
               transliteration_language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_languagePresent = TRUE;
            break;

         case 6: /* transliteration-style */
            stat = XmlDec_Number_style_transliteration_style (pctxt, &pvalue->
               transliteration_style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_stylePresent = TRUE;
            break;

         case 7: /* name */
            stat = XmlDec_Ns8_Name (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 8: /* volatile */
            stat = XmlDec_Ns8_Volatile (pctxt, &pvalue->volatile_);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.volatile_Present = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Number_style");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Number_style");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("text-properties"), 15}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 },
      {{{OSUTF8("number"), 6}, 0}, 2 },
      {{{OSUTF8("scientific-number"), 17}, 0}, 2 },
      {{{OSUTF8("fraction"), 8}, 0}, 2 },
      {{{OSUTF8("map"), 3}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 6, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* text-properties */
         pvalue->text_properties
             = rtxMemAllocType (pctxt, Ns8_Text_properties);

         if (pvalue->text_properties == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->
            text_properties);

         stat = XmlDec_Ns8_Text_properties (pctxt, pvalue->text_properties);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.text_propertiesPresent = TRUE;
         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      case 2: { /*  */
         stat = XmlDec_Number_style_sequence (pctxt, &pvalue->sequence);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.sequencePresent = TRUE;
         break;
      }
      case 3: {
         Ns8_Map* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Ns8_Map);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Map ((Ns8_Map*)pdata1);

            stat = XmlDec_Ns8_Map (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->map_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 5, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_automatic_order                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Currency_style_automatic_order (OSCTXT* pctxt, 
   Currency_style_automatic_order *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Currency_style_automatic_order (OSCTXT* pctxt, 
   Currency_style_automatic_order* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Currency_style_automatic_order_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_transliteration_style                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Currency_style_transliteration_style (OSCTXT* pctxt, 
   Currency_style_transliteration_style *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Currency_style_transliteration_style (OSCTXT* pctxt, 
   Currency_style_transliteration_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Currency_style_transliteration_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_symbol                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Currency_symbol (OSCTXT* pctxt, Currency_symbol *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode country */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.countryPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode language */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languagePresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Currency_symbol (OSCTXT* pctxt, Currency_symbol* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("country"), 7}, 0 },
         { {OSUTF8("language"), 8}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->country);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.countryPresent = TRUE;
            break;

         case 1: /* language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.languagePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Currency_symbol");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Currency_symbol");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_sequence_sequence                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Currency_style_sequence_sequence (OSCTXT* pctxt, 
   Currency_style_sequence_sequence *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode currency_symbol */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Currency_symbol (pctxt, 
               &pvalue->currency_symbol, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Currency_style_sequence_sequence (OSCTXT* pctxt, 
   Currency_style_sequence_sequence* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("currency-symbol"), 15}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* currency-symbol */
         stat = XmlDec_Currency_symbol (pctxt, &pvalue->currency_symbol);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_sequence                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Currency_style_sequence (OSCTXT* pctxt, 
   Currency_style_sequence *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode number */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns14_Number (pctxt, 
               &pvalue->number, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode sequence */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Currency_style_sequence_sequence (pctxt, 
               &pvalue->sequence, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sequencePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Currency_style_sequence (OSCTXT* pctxt, 
   Currency_style_sequence* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("number"), 6}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 },
      {{{OSUTF8("currency-symbol"), 15}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* number */
         stat = XmlDec_Ns14_Number (pctxt, &pvalue->number);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      case 2: { /*  */
         stat = XmlDec_Currency_style_sequence_sequence (pctxt, &pvalue->
            sequence);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.sequencePresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_sequence_1_sequence                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Currency_style_sequence_1_sequence (OSCTXT* pctxt, 
   Currency_style_sequence_1_sequence *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode number */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns14_Number (pctxt, 
               &pvalue->number, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Currency_style_sequence_1_sequence (OSCTXT* pctxt, 
   Currency_style_sequence_1_sequence* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("number"), 6}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* number */
         stat = XmlDec_Ns14_Number (pctxt, &pvalue->number);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_sequence_1                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Currency_style_sequence_1 (OSCTXT* pctxt, 
   Currency_style_sequence_1 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode currency_symbol */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Currency_symbol (pctxt, 
               &pvalue->currency_symbol, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode sequence */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Currency_style_sequence_1_sequence (pctxt, 
               &pvalue->sequence, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sequencePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Currency_style_sequence_1 (OSCTXT* pctxt, 
   Currency_style_sequence_1* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("currency-symbol"), 15}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 },
      {{{OSUTF8("number"), 6}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* currency-symbol */
         stat = XmlDec_Currency_symbol (pctxt, &pvalue->currency_symbol);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      case 2: { /*  */
         stat = XmlDec_Currency_style_sequence_1_sequence (pctxt, &pvalue->
            sequence);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.sequencePresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style_choice                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Currency_style_choice (OSCTXT* pctxt, 
   Currency_style_choice *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.sequence
             = rtxMemAllocType (pctxt, Currency_style_sequence);

         if (pvalue->u.sequence == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Currency_style_sequence (pvalue->u.sequence);
         stat = asn1D_Currency_style_sequence (pctxt, 
            pvalue->u.sequence, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.sequence_1
             = rtxMemAllocType (pctxt, Currency_style_sequence_1);

         if (pvalue->u.sequence_1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Currency_style_sequence_1 (pvalue->u.sequence_1);
         stat = asn1D_Currency_style_sequence_1 (pctxt, 
            pvalue->u.sequence_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Currency_style_choice (OSCTXT* pctxt, Currency_style_choice* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("number"), 6}, 0}, 0 },
      {{{OSUTF8("currency-symbol"), 15}, 0}, 1 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /*  */
      pvalue->u.sequence = rtxMemAllocType (pctxt, Currency_style_sequence);

      if (pvalue->u.sequence == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Currency_style_sequence (pvalue->u.sequence);

      stat = XmlDec_Currency_style_sequence (pctxt, pvalue->u.sequence);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /*  */
      pvalue->u.sequence_1
          = rtxMemAllocType (pctxt, Currency_style_sequence_1);

      if (pvalue->u.sequence_1 == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Currency_style_sequence_1 (pvalue->u.sequence_1);

      stat = XmlDec_Currency_style_sequence_1 (pctxt, pvalue->u.sequence_1);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Currency_style                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Currency_style (OSCTXT* pctxt, Currency_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode automatic_order */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Currency_style_automatic_order (pctxt, 
               &pvalue->automatic_order, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.automatic_orderPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode country */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.countryPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode language */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languagePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode title */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->title, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.titlePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode transliteration_country */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_countryPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode transliteration_format */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_format, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_formatPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode transliteration_language */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_languagePresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode transliteration_style */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Currency_style_transliteration_style (pctxt, 
               &pvalue->transliteration_style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_stylePresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Name (pctxt, 
               (Ns8_Name*)&pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 9:
         /* decode volatile_ */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Volatile (pctxt, 
               (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.volatile_Present = TRUE;
            }
         }
         break;

      case 10:
         /* decode text_properties */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->text_properties
                = rtxMemAllocType (pctxt, Ns8_Text_properties);

            if (pvalue->text_properties == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);
            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);

            stat = asn1D_Ns8_Text_properties (pctxt, 
               (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.text_propertiesPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 11:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      case 12:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Currency_style_choice (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choicePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 13:
         /* decode map_list */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Ns8_Map* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->map_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Ns8_Map, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Ns8_Map ((Ns8_Map*)pdata2);

                  stat = asn1D_Ns8_Map (pctxt, 
                     (Ns8_Map*)pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->map_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_PRIM|11):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_CONS|13):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Currency_style (OSCTXT* pctxt, Currency_style* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("automatic-order"), 15}, 0 },
         { {OSUTF8("country"), 7}, 0 },
         { {OSUTF8("language"), 8}, 0 },
         { {OSUTF8("title"), 5}, 0 },
         { {OSUTF8("transliteration-country"), 23}, 0 },
         { {OSUTF8("transliteration-format"), 22}, 0 },
         { {OSUTF8("transliteration-language"), 24}, 0 },
         { {OSUTF8("transliteration-style"), 21}, 0 },
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("volatile"), 8}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 10, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* automatic-order */
            stat = XmlDec_Currency_style_automatic_order (pctxt, &pvalue->
               automatic_order);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.automatic_orderPresent = TRUE;
            break;

         case 1: /* country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->country);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.countryPresent = TRUE;
            break;

         case 2: /* language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.languagePresent = TRUE;
            break;

         case 3: /* title */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->title);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.titlePresent = TRUE;
            break;

         case 4: /* transliteration-country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_country
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_countryPresent = TRUE;
            break;

         case 5: /* transliteration-format */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_format
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_formatPresent = TRUE;
            break;

         case 6: /* transliteration-language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
               transliteration_language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_languagePresent = TRUE;
            break;

         case 7: /* transliteration-style */
            stat = XmlDec_Currency_style_transliteration_style (pctxt, &pvalue
               ->transliteration_style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_stylePresent = TRUE;
            break;

         case 8: /* name */
            stat = XmlDec_Ns8_Name (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 9: /* volatile */
            stat = XmlDec_Ns8_Volatile (pctxt, &pvalue->volatile_);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.volatile_Present = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Currency_style");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Currency_style");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("text-properties"), 15}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 },
      {{{OSUTF8("number"), 6}, 0}, 2 },
      {{{OSUTF8("currency-symbol"), 15}, 0}, 2 },
      {{{OSUTF8("map"), 3}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* text-properties */
         pvalue->text_properties
             = rtxMemAllocType (pctxt, Ns8_Text_properties);

         if (pvalue->text_properties == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->
            text_properties);

         stat = XmlDec_Ns8_Text_properties (pctxt, pvalue->text_properties);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.text_propertiesPresent = TRUE;
         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      case 2: { /*  */
         stat = XmlDec_Currency_style_choice (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choicePresent = TRUE;
         break;
      }
      case 3: {
         Ns8_Map* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Ns8_Map);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Map ((Ns8_Map*)pdata1);

            stat = XmlDec_Ns8_Map (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->map_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 4, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Percentage_style_transliteration_style                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Percentage_style_transliteration_style (OSCTXT* pctxt, 
   Percentage_style_transliteration_style *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Percentage_style_transliteration_style (OSCTXT* pctxt, 
   Percentage_style_transliteration_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Percentage_style_transliteration_style_ToEnum (pctxt, strval, pvalue
      );
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Percentage_style_sequence                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Percentage_style_sequence (OSCTXT* pctxt, 
   Percentage_style_sequence *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode number */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns14_Number (pctxt, 
               &pvalue->number, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Percentage_style_sequence (OSCTXT* pctxt, 
   Percentage_style_sequence* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("number"), 6}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* number */
         stat = XmlDec_Ns14_Number (pctxt, &pvalue->number);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Percentage_style                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Percentage_style (OSCTXT* pctxt, Percentage_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode country */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.countryPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode language */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languagePresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode title */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->title, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.titlePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode transliteration_country */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_countryPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode transliteration_format */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_format, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_formatPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode transliteration_language */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_languagePresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode transliteration_style */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Percentage_style_transliteration_style (pctxt, 
               &pvalue->transliteration_style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_stylePresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Name (pctxt, 
               (Ns8_Name*)&pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode volatile_ */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Volatile (pctxt, 
               (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.volatile_Present = TRUE;
            }
         }
         break;

      case 9:
         /* decode text_properties */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->text_properties
                = rtxMemAllocType (pctxt, Ns8_Text_properties);

            if (pvalue->text_properties == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);
            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);

            stat = asn1D_Ns8_Text_properties (pctxt, 
               (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.text_propertiesPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 10:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode sequence */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Percentage_style_sequence (pctxt, 
               &pvalue->sequence, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sequencePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 12:
         /* decode map_list */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Ns8_Map* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->map_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Ns8_Map, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Ns8_Map ((Ns8_Map*)pdata2);

                  stat = asn1D_Ns8_Map (pctxt, 
                     (Ns8_Map*)pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->map_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_CONS|12):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Percentage_style (OSCTXT* pctxt, Percentage_style* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("country"), 7}, 0 },
         { {OSUTF8("language"), 8}, 0 },
         { {OSUTF8("title"), 5}, 0 },
         { {OSUTF8("transliteration-country"), 23}, 0 },
         { {OSUTF8("transliteration-format"), 22}, 0 },
         { {OSUTF8("transliteration-language"), 24}, 0 },
         { {OSUTF8("transliteration-style"), 21}, 0 },
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("volatile"), 8}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 9, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->country);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.countryPresent = TRUE;
            break;

         case 1: /* language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.languagePresent = TRUE;
            break;

         case 2: /* title */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->title);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.titlePresent = TRUE;
            break;

         case 3: /* transliteration-country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_country
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_countryPresent = TRUE;
            break;

         case 4: /* transliteration-format */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_format
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_formatPresent = TRUE;
            break;

         case 5: /* transliteration-language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
               transliteration_language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_languagePresent = TRUE;
            break;

         case 6: /* transliteration-style */
            stat = XmlDec_Percentage_style_transliteration_style (pctxt, &
               pvalue->transliteration_style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_stylePresent = TRUE;
            break;

         case 7: /* name */
            stat = XmlDec_Ns8_Name (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 8: /* volatile */
            stat = XmlDec_Ns8_Volatile (pctxt, &pvalue->volatile_);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.volatile_Present = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Percentage_style");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Percentage_style");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("text-properties"), 15}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 },
      {{{OSUTF8("number"), 6}, 0}, 2 },
      {{{OSUTF8("map"), 3}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* text-properties */
         pvalue->text_properties
             = rtxMemAllocType (pctxt, Ns8_Text_properties);

         if (pvalue->text_properties == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->
            text_properties);

         stat = XmlDec_Ns8_Text_properties (pctxt, pvalue->text_properties);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.text_propertiesPresent = TRUE;
         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      case 2: { /*  */
         stat = XmlDec_Percentage_style_sequence (pctxt, &pvalue->sequence);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.sequencePresent = TRUE;
         break;
      }
      case 3: {
         Ns8_Map* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Ns8_Map);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Map ((Ns8_Map*)pdata1);

            stat = XmlDec_Ns8_Map (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->map_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date_style_automatic_order                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Date_style_automatic_order (OSCTXT* pctxt, 
   Date_style_automatic_order *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Date_style_automatic_order (OSCTXT* pctxt, 
   Date_style_automatic_order* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Date_style_automatic_order_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date_style_format_source                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Date_style_format_source (OSCTXT* pctxt, 
   Date_style_format_source *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Date_style_format_source (OSCTXT* pctxt, 
   Date_style_format_source* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Date_style_format_source_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date_style_transliteration_style                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Date_style_transliteration_style (OSCTXT* pctxt, 
   Date_style_transliteration_style *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Date_style_transliteration_style (OSCTXT* pctxt, 
   Date_style_transliteration_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Date_style_transliteration_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_1                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_calendar_alt_1 (OSCTXT* pctxt, 
   Day_calendar_alt_1 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_calendar_alt_1 (OSCTXT* pctxt, Day_calendar_alt_1* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_calendar_alt_1_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_2                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_calendar_alt_2 (OSCTXT* pctxt, 
   Day_calendar_alt_2 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_calendar_alt_2 (OSCTXT* pctxt, Day_calendar_alt_2* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_calendar_alt_2_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_3                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_calendar_alt_3 (OSCTXT* pctxt, 
   Day_calendar_alt_3 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_calendar_alt_3 (OSCTXT* pctxt, Day_calendar_alt_3* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_calendar_alt_3_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_4                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_calendar_alt_4 (OSCTXT* pctxt, 
   Day_calendar_alt_4 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_calendar_alt_4 (OSCTXT* pctxt, Day_calendar_alt_4* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_calendar_alt_4_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_5                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_calendar_alt_5 (OSCTXT* pctxt, 
   Day_calendar_alt_5 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_calendar_alt_5 (OSCTXT* pctxt, Day_calendar_alt_5* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_calendar_alt_5_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_6                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_calendar_alt_6 (OSCTXT* pctxt, 
   Day_calendar_alt_6 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_calendar_alt_6 (OSCTXT* pctxt, Day_calendar_alt_6* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_calendar_alt_6_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_7                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_calendar_alt_7 (OSCTXT* pctxt, 
   Day_calendar_alt_7 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_calendar_alt_7 (OSCTXT* pctxt, Day_calendar_alt_7* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_calendar_alt_7_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar_alt_8                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_calendar_alt_8 (OSCTXT* pctxt, 
   Day_calendar_alt_8 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_calendar_alt_8 (OSCTXT* pctxt, Day_calendar_alt_8* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_calendar_alt_8_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_calendar                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_calendar (OSCTXT* pctxt, Day_calendar *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
         stat = asn1D_Day_calendar_alt_1 (pctxt, 
            &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_PRIM|2):
         stat = asn1D_Day_calendar_alt_2 (pctxt, 
            &pvalue->u.alt_2, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_PRIM|3):
         stat = asn1D_Day_calendar_alt_3 (pctxt, 
            &pvalue->u.alt_3, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_PRIM|4):
         stat = asn1D_Day_calendar_alt_4 (pctxt, 
            &pvalue->u.alt_4, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_PRIM|5):
         stat = asn1D_Day_calendar_alt_5 (pctxt, 
            &pvalue->u.alt_5, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_PRIM|6):
         stat = asn1D_Day_calendar_alt_6 (pctxt, 
            &pvalue->u.alt_6, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_PRIM|7):
         stat = asn1D_Day_calendar_alt_7 (pctxt, 
            &pvalue->u.alt_7, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_PRIM|8):
         stat = asn1D_Day_calendar_alt_8 (pctxt, 
            &pvalue->u.alt_8, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Day_calendar (OSCTXT* pctxt, Day_calendar* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      stat = Day_calendar_alt_1_ToEnum (pctxt, pdata1, &pvalue->u.alt_1);
      if (stat == 0) pvalue->t = 2;
   }
   if (pvalue->t == 0) {
      stat = Day_calendar_alt_2_ToEnum (pctxt, pdata1, &pvalue->u.alt_2);
      if (stat == 0) pvalue->t = 3;
   }
   if (pvalue->t == 0) {
      stat = Day_calendar_alt_3_ToEnum (pctxt, pdata1, &pvalue->u.alt_3);
      if (stat == 0) pvalue->t = 4;
   }
   if (pvalue->t == 0) {
      stat = Day_calendar_alt_4_ToEnum (pctxt, pdata1, &pvalue->u.alt_4);
      if (stat == 0) pvalue->t = 5;
   }
   if (pvalue->t == 0) {
      stat = Day_calendar_alt_5_ToEnum (pctxt, pdata1, &pvalue->u.alt_5);
      if (stat == 0) pvalue->t = 6;
   }
   if (pvalue->t == 0) {
      stat = Day_calendar_alt_6_ToEnum (pctxt, pdata1, &pvalue->u.alt_6);
      if (stat == 0) pvalue->t = 7;
   }
   if (pvalue->t == 0) {
      stat = Day_calendar_alt_7_ToEnum (pctxt, pdata1, &pvalue->u.alt_7);
      if (stat == 0) pvalue->t = 8;
   }
   if (pvalue->t == 0) {
      stat = Day_calendar_alt_8_ToEnum (pctxt, pdata1, &pvalue->u.alt_8);
      if (stat == 0) pvalue->t = 9;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_style                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_style (OSCTXT* pctxt, Day_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_style (OSCTXT* pctxt, Day_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day                                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Ns14_Day (OSCTXT* pctxt, Ns14_Day *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode calendar */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Day_calendar (pctxt, 
               &pvalue->calendar, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.calendarPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode style */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Day_style (pctxt, 
               &pvalue->style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.stylePresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Ns14_Day (OSCTXT* pctxt, Ns14_Day* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("calendar"), 8}, 0 },
         { {OSUTF8("style"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* calendar */
            stat = XmlDec_Day_calendar (pctxt, &pvalue->calendar);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.calendarPresent = TRUE;
            break;

         case 1: /* style */
            stat = XmlDec_Day_style (pctxt, &pvalue->style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.stylePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Ns14_Day");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Ns14_Day");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_1                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Month_calendar_alt_1 (OSCTXT* pctxt, 
   Month_calendar_alt_1 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Month_calendar_alt_1 (OSCTXT* pctxt, Month_calendar_alt_1* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Month_calendar_alt_1_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_2                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Month_calendar_alt_2 (OSCTXT* pctxt, 
   Month_calendar_alt_2 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Month_calendar_alt_2 (OSCTXT* pctxt, Month_calendar_alt_2* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Month_calendar_alt_2_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_3                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Month_calendar_alt_3 (OSCTXT* pctxt, 
   Month_calendar_alt_3 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Month_calendar_alt_3 (OSCTXT* pctxt, Month_calendar_alt_3* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Month_calendar_alt_3_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_4                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Month_calendar_alt_4 (OSCTXT* pctxt, 
   Month_calendar_alt_4 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Month_calendar_alt_4 (OSCTXT* pctxt, Month_calendar_alt_4* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Month_calendar_alt_4_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_5                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Month_calendar_alt_5 (OSCTXT* pctxt, 
   Month_calendar_alt_5 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Month_calendar_alt_5 (OSCTXT* pctxt, Month_calendar_alt_5* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Month_calendar_alt_5_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_6                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Month_calendar_alt_6 (OSCTXT* pctxt, 
   Month_calendar_alt_6 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Month_calendar_alt_6 (OSCTXT* pctxt, Month_calendar_alt_6* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Month_calendar_alt_6_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_7                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Month_calendar_alt_7 (OSCTXT* pctxt, 
   Month_calendar_alt_7 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Month_calendar_alt_7 (OSCTXT* pctxt, Month_calendar_alt_7* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Month_calendar_alt_7_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar_alt_8                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Month_calendar_alt_8 (OSCTXT* pctxt, 
   Month_calendar_alt_8 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Month_calendar_alt_8 (OSCTXT* pctxt, Month_calendar_alt_8* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Month_calendar_alt_8_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_calendar                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Month_calendar (OSCTXT* pctxt, Month_calendar *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
         stat = asn1D_Month_calendar_alt_1 (pctxt, 
            &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_PRIM|2):
         stat = asn1D_Month_calendar_alt_2 (pctxt, 
            &pvalue->u.alt_2, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_PRIM|3):
         stat = asn1D_Month_calendar_alt_3 (pctxt, 
            &pvalue->u.alt_3, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_PRIM|4):
         stat = asn1D_Month_calendar_alt_4 (pctxt, 
            &pvalue->u.alt_4, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_PRIM|5):
         stat = asn1D_Month_calendar_alt_5 (pctxt, 
            &pvalue->u.alt_5, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_PRIM|6):
         stat = asn1D_Month_calendar_alt_6 (pctxt, 
            &pvalue->u.alt_6, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_PRIM|7):
         stat = asn1D_Month_calendar_alt_7 (pctxt, 
            &pvalue->u.alt_7, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_PRIM|8):
         stat = asn1D_Month_calendar_alt_8 (pctxt, 
            &pvalue->u.alt_8, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Month_calendar (OSCTXT* pctxt, Month_calendar* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      stat = Month_calendar_alt_1_ToEnum (pctxt, pdata1, &pvalue->u.alt_1);
      if (stat == 0) pvalue->t = 2;
   }
   if (pvalue->t == 0) {
      stat = Month_calendar_alt_2_ToEnum (pctxt, pdata1, &pvalue->u.alt_2);
      if (stat == 0) pvalue->t = 3;
   }
   if (pvalue->t == 0) {
      stat = Month_calendar_alt_3_ToEnum (pctxt, pdata1, &pvalue->u.alt_3);
      if (stat == 0) pvalue->t = 4;
   }
   if (pvalue->t == 0) {
      stat = Month_calendar_alt_4_ToEnum (pctxt, pdata1, &pvalue->u.alt_4);
      if (stat == 0) pvalue->t = 5;
   }
   if (pvalue->t == 0) {
      stat = Month_calendar_alt_5_ToEnum (pctxt, pdata1, &pvalue->u.alt_5);
      if (stat == 0) pvalue->t = 6;
   }
   if (pvalue->t == 0) {
      stat = Month_calendar_alt_6_ToEnum (pctxt, pdata1, &pvalue->u.alt_6);
      if (stat == 0) pvalue->t = 7;
   }
   if (pvalue->t == 0) {
      stat = Month_calendar_alt_7_ToEnum (pctxt, pdata1, &pvalue->u.alt_7);
      if (stat == 0) pvalue->t = 8;
   }
   if (pvalue->t == 0) {
      stat = Month_calendar_alt_8_ToEnum (pctxt, pdata1, &pvalue->u.alt_8);
      if (stat == 0) pvalue->t = 9;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_possessive_form                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Month_possessive_form (OSCTXT* pctxt, 
   Month_possessive_form *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Month_possessive_form (OSCTXT* pctxt, Month_possessive_form* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Month_possessive_form_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_style                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Month_style (OSCTXT* pctxt, Month_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Month_style (OSCTXT* pctxt, Month_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Month_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month_textual                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Month_textual (OSCTXT* pctxt, Month_textual *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Month_textual (OSCTXT* pctxt, Month_textual* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Month_textual_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Ns14_Month (OSCTXT* pctxt, Ns14_Month *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode calendar */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Month_calendar (pctxt, 
               &pvalue->calendar, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.calendarPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode possessive_form */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Month_possessive_form (pctxt, 
               &pvalue->possessive_form, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.possessive_formPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode style */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Month_style (pctxt, 
               &pvalue->style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.stylePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode textual */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Month_textual (pctxt, 
               &pvalue->textual, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textualPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Ns14_Month (OSCTXT* pctxt, Ns14_Month* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("calendar"), 8}, 0 },
         { {OSUTF8("possessive-form"), 15}, 0 },
         { {OSUTF8("style"), 5}, 0 },
         { {OSUTF8("textual"), 7}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* calendar */
            stat = XmlDec_Month_calendar (pctxt, &pvalue->calendar);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.calendarPresent = TRUE;
            break;

         case 1: /* possessive-form */
            stat = XmlDec_Month_possessive_form (pctxt, &pvalue->
               possessive_form);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.possessive_formPresent = TRUE;
            break;

         case 2: /* style */
            stat = XmlDec_Month_style (pctxt, &pvalue->style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.stylePresent = TRUE;
            break;

         case 3: /* textual */
            stat = XmlDec_Month_textual (pctxt, &pvalue->textual);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.textualPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Ns14_Month");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Ns14_Month");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_1                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Year_calendar_alt_1 (OSCTXT* pctxt, 
   Year_calendar_alt_1 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Year_calendar_alt_1 (OSCTXT* pctxt, Year_calendar_alt_1* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Year_calendar_alt_1_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_2                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Year_calendar_alt_2 (OSCTXT* pctxt, 
   Year_calendar_alt_2 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Year_calendar_alt_2 (OSCTXT* pctxt, Year_calendar_alt_2* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Year_calendar_alt_2_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_3                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Year_calendar_alt_3 (OSCTXT* pctxt, 
   Year_calendar_alt_3 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Year_calendar_alt_3 (OSCTXT* pctxt, Year_calendar_alt_3* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Year_calendar_alt_3_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_4                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Year_calendar_alt_4 (OSCTXT* pctxt, 
   Year_calendar_alt_4 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Year_calendar_alt_4 (OSCTXT* pctxt, Year_calendar_alt_4* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Year_calendar_alt_4_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_5                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Year_calendar_alt_5 (OSCTXT* pctxt, 
   Year_calendar_alt_5 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Year_calendar_alt_5 (OSCTXT* pctxt, Year_calendar_alt_5* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Year_calendar_alt_5_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_6                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Year_calendar_alt_6 (OSCTXT* pctxt, 
   Year_calendar_alt_6 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Year_calendar_alt_6 (OSCTXT* pctxt, Year_calendar_alt_6* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Year_calendar_alt_6_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_7                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Year_calendar_alt_7 (OSCTXT* pctxt, 
   Year_calendar_alt_7 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Year_calendar_alt_7 (OSCTXT* pctxt, Year_calendar_alt_7* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Year_calendar_alt_7_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar_alt_8                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Year_calendar_alt_8 (OSCTXT* pctxt, 
   Year_calendar_alt_8 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Year_calendar_alt_8 (OSCTXT* pctxt, Year_calendar_alt_8* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Year_calendar_alt_8_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_calendar                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Year_calendar (OSCTXT* pctxt, Year_calendar *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
         stat = asn1D_Year_calendar_alt_1 (pctxt, 
            &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_PRIM|2):
         stat = asn1D_Year_calendar_alt_2 (pctxt, 
            &pvalue->u.alt_2, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_PRIM|3):
         stat = asn1D_Year_calendar_alt_3 (pctxt, 
            &pvalue->u.alt_3, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_PRIM|4):
         stat = asn1D_Year_calendar_alt_4 (pctxt, 
            &pvalue->u.alt_4, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_PRIM|5):
         stat = asn1D_Year_calendar_alt_5 (pctxt, 
            &pvalue->u.alt_5, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_PRIM|6):
         stat = asn1D_Year_calendar_alt_6 (pctxt, 
            &pvalue->u.alt_6, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_PRIM|7):
         stat = asn1D_Year_calendar_alt_7 (pctxt, 
            &pvalue->u.alt_7, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_PRIM|8):
         stat = asn1D_Year_calendar_alt_8 (pctxt, 
            &pvalue->u.alt_8, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Year_calendar (OSCTXT* pctxt, Year_calendar* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      stat = Year_calendar_alt_1_ToEnum (pctxt, pdata1, &pvalue->u.alt_1);
      if (stat == 0) pvalue->t = 2;
   }
   if (pvalue->t == 0) {
      stat = Year_calendar_alt_2_ToEnum (pctxt, pdata1, &pvalue->u.alt_2);
      if (stat == 0) pvalue->t = 3;
   }
   if (pvalue->t == 0) {
      stat = Year_calendar_alt_3_ToEnum (pctxt, pdata1, &pvalue->u.alt_3);
      if (stat == 0) pvalue->t = 4;
   }
   if (pvalue->t == 0) {
      stat = Year_calendar_alt_4_ToEnum (pctxt, pdata1, &pvalue->u.alt_4);
      if (stat == 0) pvalue->t = 5;
   }
   if (pvalue->t == 0) {
      stat = Year_calendar_alt_5_ToEnum (pctxt, pdata1, &pvalue->u.alt_5);
      if (stat == 0) pvalue->t = 6;
   }
   if (pvalue->t == 0) {
      stat = Year_calendar_alt_6_ToEnum (pctxt, pdata1, &pvalue->u.alt_6);
      if (stat == 0) pvalue->t = 7;
   }
   if (pvalue->t == 0) {
      stat = Year_calendar_alt_7_ToEnum (pctxt, pdata1, &pvalue->u.alt_7);
      if (stat == 0) pvalue->t = 8;
   }
   if (pvalue->t == 0) {
      stat = Year_calendar_alt_8_ToEnum (pctxt, pdata1, &pvalue->u.alt_8);
      if (stat == 0) pvalue->t = 9;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year_style                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Year_style (OSCTXT* pctxt, Year_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Year_style (OSCTXT* pctxt, Year_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Year_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Ns14_Year (OSCTXT* pctxt, Ns14_Year *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode calendar */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Year_calendar (pctxt, 
               &pvalue->calendar, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.calendarPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode style */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Year_style (pctxt, 
               &pvalue->style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.stylePresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Ns14_Year (OSCTXT* pctxt, Ns14_Year* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("calendar"), 8}, 0 },
         { {OSUTF8("style"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* calendar */
            stat = XmlDec_Year_calendar (pctxt, &pvalue->calendar);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.calendarPresent = TRUE;
            break;

         case 1: /* style */
            stat = XmlDec_Year_style (pctxt, &pvalue->style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.stylePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Ns14_Year");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Ns14_Year");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_1                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Era_calendar_alt_1 (OSCTXT* pctxt, 
   Era_calendar_alt_1 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Era_calendar_alt_1 (OSCTXT* pctxt, Era_calendar_alt_1* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Era_calendar_alt_1_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_2                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Era_calendar_alt_2 (OSCTXT* pctxt, 
   Era_calendar_alt_2 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Era_calendar_alt_2 (OSCTXT* pctxt, Era_calendar_alt_2* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Era_calendar_alt_2_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_3                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Era_calendar_alt_3 (OSCTXT* pctxt, 
   Era_calendar_alt_3 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Era_calendar_alt_3 (OSCTXT* pctxt, Era_calendar_alt_3* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Era_calendar_alt_3_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_4                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Era_calendar_alt_4 (OSCTXT* pctxt, 
   Era_calendar_alt_4 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Era_calendar_alt_4 (OSCTXT* pctxt, Era_calendar_alt_4* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Era_calendar_alt_4_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_5                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Era_calendar_alt_5 (OSCTXT* pctxt, 
   Era_calendar_alt_5 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Era_calendar_alt_5 (OSCTXT* pctxt, Era_calendar_alt_5* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Era_calendar_alt_5_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_6                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Era_calendar_alt_6 (OSCTXT* pctxt, 
   Era_calendar_alt_6 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Era_calendar_alt_6 (OSCTXT* pctxt, Era_calendar_alt_6* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Era_calendar_alt_6_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_7                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Era_calendar_alt_7 (OSCTXT* pctxt, 
   Era_calendar_alt_7 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Era_calendar_alt_7 (OSCTXT* pctxt, Era_calendar_alt_7* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Era_calendar_alt_7_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar_alt_8                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Era_calendar_alt_8 (OSCTXT* pctxt, 
   Era_calendar_alt_8 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Era_calendar_alt_8 (OSCTXT* pctxt, Era_calendar_alt_8* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Era_calendar_alt_8_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_calendar                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Era_calendar (OSCTXT* pctxt, Era_calendar *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
         stat = asn1D_Era_calendar_alt_1 (pctxt, 
            &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_PRIM|2):
         stat = asn1D_Era_calendar_alt_2 (pctxt, 
            &pvalue->u.alt_2, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_PRIM|3):
         stat = asn1D_Era_calendar_alt_3 (pctxt, 
            &pvalue->u.alt_3, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_PRIM|4):
         stat = asn1D_Era_calendar_alt_4 (pctxt, 
            &pvalue->u.alt_4, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_PRIM|5):
         stat = asn1D_Era_calendar_alt_5 (pctxt, 
            &pvalue->u.alt_5, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_PRIM|6):
         stat = asn1D_Era_calendar_alt_6 (pctxt, 
            &pvalue->u.alt_6, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_PRIM|7):
         stat = asn1D_Era_calendar_alt_7 (pctxt, 
            &pvalue->u.alt_7, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_PRIM|8):
         stat = asn1D_Era_calendar_alt_8 (pctxt, 
            &pvalue->u.alt_8, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Era_calendar (OSCTXT* pctxt, Era_calendar* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      stat = Era_calendar_alt_1_ToEnum (pctxt, pdata1, &pvalue->u.alt_1);
      if (stat == 0) pvalue->t = 2;
   }
   if (pvalue->t == 0) {
      stat = Era_calendar_alt_2_ToEnum (pctxt, pdata1, &pvalue->u.alt_2);
      if (stat == 0) pvalue->t = 3;
   }
   if (pvalue->t == 0) {
      stat = Era_calendar_alt_3_ToEnum (pctxt, pdata1, &pvalue->u.alt_3);
      if (stat == 0) pvalue->t = 4;
   }
   if (pvalue->t == 0) {
      stat = Era_calendar_alt_4_ToEnum (pctxt, pdata1, &pvalue->u.alt_4);
      if (stat == 0) pvalue->t = 5;
   }
   if (pvalue->t == 0) {
      stat = Era_calendar_alt_5_ToEnum (pctxt, pdata1, &pvalue->u.alt_5);
      if (stat == 0) pvalue->t = 6;
   }
   if (pvalue->t == 0) {
      stat = Era_calendar_alt_6_ToEnum (pctxt, pdata1, &pvalue->u.alt_6);
      if (stat == 0) pvalue->t = 7;
   }
   if (pvalue->t == 0) {
      stat = Era_calendar_alt_7_ToEnum (pctxt, pdata1, &pvalue->u.alt_7);
      if (stat == 0) pvalue->t = 8;
   }
   if (pvalue->t == 0) {
      stat = Era_calendar_alt_8_ToEnum (pctxt, pdata1, &pvalue->u.alt_8);
      if (stat == 0) pvalue->t = 9;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era_style                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Era_style (OSCTXT* pctxt, Era_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Era_style (OSCTXT* pctxt, Era_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Era_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Era                                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Era (OSCTXT* pctxt, Era *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode calendar */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Era_calendar (pctxt, 
               &pvalue->calendar, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.calendarPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode style */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Era_style (pctxt, 
               &pvalue->style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.stylePresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Era (OSCTXT* pctxt, Era* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("calendar"), 8}, 0 },
         { {OSUTF8("style"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* calendar */
            stat = XmlDec_Era_calendar (pctxt, &pvalue->calendar);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.calendarPresent = TRUE;
            break;

         case 1: /* style */
            stat = XmlDec_Era_style (pctxt, &pvalue->style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.stylePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Era");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Era");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_1                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_of_week_calendar_alt_1 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_1 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_of_week_calendar_alt_1 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_1* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_of_week_calendar_alt_1_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_2                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_of_week_calendar_alt_2 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_2 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_of_week_calendar_alt_2 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_2* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_of_week_calendar_alt_2_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_3                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_of_week_calendar_alt_3 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_3 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_of_week_calendar_alt_3 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_3* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_of_week_calendar_alt_3_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_4                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_of_week_calendar_alt_4 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_4 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_of_week_calendar_alt_4 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_4* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_of_week_calendar_alt_4_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_5                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_of_week_calendar_alt_5 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_5 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_of_week_calendar_alt_5 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_5* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_of_week_calendar_alt_5_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_6                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_of_week_calendar_alt_6 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_6 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_of_week_calendar_alt_6 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_6* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_of_week_calendar_alt_6_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_7                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_of_week_calendar_alt_7 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_7 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_of_week_calendar_alt_7 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_7* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_of_week_calendar_alt_7_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar_alt_8                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_of_week_calendar_alt_8 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_8 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_of_week_calendar_alt_8 (OSCTXT* pctxt, 
   Day_of_week_calendar_alt_8* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_of_week_calendar_alt_8_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_calendar                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_of_week_calendar (OSCTXT* pctxt, 
   Day_of_week_calendar *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
         stat = asn1D_Day_of_week_calendar_alt_1 (pctxt, 
            &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_PRIM|2):
         stat = asn1D_Day_of_week_calendar_alt_2 (pctxt, 
            &pvalue->u.alt_2, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_PRIM|3):
         stat = asn1D_Day_of_week_calendar_alt_3 (pctxt, 
            &pvalue->u.alt_3, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_PRIM|4):
         stat = asn1D_Day_of_week_calendar_alt_4 (pctxt, 
            &pvalue->u.alt_4, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_PRIM|5):
         stat = asn1D_Day_of_week_calendar_alt_5 (pctxt, 
            &pvalue->u.alt_5, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_PRIM|6):
         stat = asn1D_Day_of_week_calendar_alt_6 (pctxt, 
            &pvalue->u.alt_6, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_PRIM|7):
         stat = asn1D_Day_of_week_calendar_alt_7 (pctxt, 
            &pvalue->u.alt_7, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_PRIM|8):
         stat = asn1D_Day_of_week_calendar_alt_8 (pctxt, 
            &pvalue->u.alt_8, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Day_of_week_calendar (OSCTXT* pctxt, Day_of_week_calendar* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      stat = Day_of_week_calendar_alt_1_ToEnum (pctxt, pdata1, &pvalue->u.alt_1
         );
      if (stat == 0) pvalue->t = 2;
   }
   if (pvalue->t == 0) {
      stat = Day_of_week_calendar_alt_2_ToEnum (pctxt, pdata1, &pvalue->u.alt_2
         );
      if (stat == 0) pvalue->t = 3;
   }
   if (pvalue->t == 0) {
      stat = Day_of_week_calendar_alt_3_ToEnum (pctxt, pdata1, &pvalue->u.alt_3
         );
      if (stat == 0) pvalue->t = 4;
   }
   if (pvalue->t == 0) {
      stat = Day_of_week_calendar_alt_4_ToEnum (pctxt, pdata1, &pvalue->u.alt_4
         );
      if (stat == 0) pvalue->t = 5;
   }
   if (pvalue->t == 0) {
      stat = Day_of_week_calendar_alt_5_ToEnum (pctxt, pdata1, &pvalue->u.alt_5
         );
      if (stat == 0) pvalue->t = 6;
   }
   if (pvalue->t == 0) {
      stat = Day_of_week_calendar_alt_6_ToEnum (pctxt, pdata1, &pvalue->u.alt_6
         );
      if (stat == 0) pvalue->t = 7;
   }
   if (pvalue->t == 0) {
      stat = Day_of_week_calendar_alt_7_ToEnum (pctxt, pdata1, &pvalue->u.alt_7
         );
      if (stat == 0) pvalue->t = 8;
   }
   if (pvalue->t == 0) {
      stat = Day_of_week_calendar_alt_8_ToEnum (pctxt, pdata1, &pvalue->u.alt_8
         );
      if (stat == 0) pvalue->t = 9;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week_style                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_of_week_style (OSCTXT* pctxt, Day_of_week_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Day_of_week_style (OSCTXT* pctxt, Day_of_week_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Day_of_week_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day_of_week                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day_of_week (OSCTXT* pctxt, Day_of_week *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode calendar */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Day_of_week_calendar (pctxt, 
               &pvalue->calendar, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.calendarPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode style */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Day_of_week_style (pctxt, 
               &pvalue->style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.stylePresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Day_of_week (OSCTXT* pctxt, Day_of_week* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("calendar"), 8}, 0 },
         { {OSUTF8("style"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* calendar */
            stat = XmlDec_Day_of_week_calendar (pctxt, &pvalue->calendar);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.calendarPresent = TRUE;
            break;

         case 1: /* style */
            stat = XmlDec_Day_of_week_style (pctxt, &pvalue->style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.stylePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Day_of_week");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Day_of_week");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_1                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Week_of_year_calendar_alt_1 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_1 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Week_of_year_calendar_alt_1 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_1* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Week_of_year_calendar_alt_1_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_2                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Week_of_year_calendar_alt_2 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_2 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Week_of_year_calendar_alt_2 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_2* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Week_of_year_calendar_alt_2_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_3                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Week_of_year_calendar_alt_3 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_3 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Week_of_year_calendar_alt_3 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_3* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Week_of_year_calendar_alt_3_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_4                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Week_of_year_calendar_alt_4 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_4 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Week_of_year_calendar_alt_4 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_4* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Week_of_year_calendar_alt_4_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_5                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Week_of_year_calendar_alt_5 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_5 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Week_of_year_calendar_alt_5 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_5* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Week_of_year_calendar_alt_5_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_6                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Week_of_year_calendar_alt_6 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_6 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Week_of_year_calendar_alt_6 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_6* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Week_of_year_calendar_alt_6_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_7                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Week_of_year_calendar_alt_7 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_7 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Week_of_year_calendar_alt_7 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_7* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Week_of_year_calendar_alt_7_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar_alt_8                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Week_of_year_calendar_alt_8 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_8 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Week_of_year_calendar_alt_8 (OSCTXT* pctxt, 
   Week_of_year_calendar_alt_8* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Week_of_year_calendar_alt_8_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year_calendar                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Week_of_year_calendar (OSCTXT* pctxt, 
   Week_of_year_calendar *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
         stat = asn1D_Week_of_year_calendar_alt_1 (pctxt, 
            &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_PRIM|2):
         stat = asn1D_Week_of_year_calendar_alt_2 (pctxt, 
            &pvalue->u.alt_2, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_PRIM|3):
         stat = asn1D_Week_of_year_calendar_alt_3 (pctxt, 
            &pvalue->u.alt_3, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_PRIM|4):
         stat = asn1D_Week_of_year_calendar_alt_4 (pctxt, 
            &pvalue->u.alt_4, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_PRIM|5):
         stat = asn1D_Week_of_year_calendar_alt_5 (pctxt, 
            &pvalue->u.alt_5, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_PRIM|6):
         stat = asn1D_Week_of_year_calendar_alt_6 (pctxt, 
            &pvalue->u.alt_6, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_PRIM|7):
         stat = asn1D_Week_of_year_calendar_alt_7 (pctxt, 
            &pvalue->u.alt_7, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_PRIM|8):
         stat = asn1D_Week_of_year_calendar_alt_8 (pctxt, 
            &pvalue->u.alt_8, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Week_of_year_calendar (OSCTXT* pctxt, Week_of_year_calendar* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      stat = Week_of_year_calendar_alt_1_ToEnum (pctxt, pdata1, &pvalue->
         u.alt_1);
      if (stat == 0) pvalue->t = 2;
   }
   if (pvalue->t == 0) {
      stat = Week_of_year_calendar_alt_2_ToEnum (pctxt, pdata1, &pvalue->
         u.alt_2);
      if (stat == 0) pvalue->t = 3;
   }
   if (pvalue->t == 0) {
      stat = Week_of_year_calendar_alt_3_ToEnum (pctxt, pdata1, &pvalue->
         u.alt_3);
      if (stat == 0) pvalue->t = 4;
   }
   if (pvalue->t == 0) {
      stat = Week_of_year_calendar_alt_4_ToEnum (pctxt, pdata1, &pvalue->
         u.alt_4);
      if (stat == 0) pvalue->t = 5;
   }
   if (pvalue->t == 0) {
      stat = Week_of_year_calendar_alt_5_ToEnum (pctxt, pdata1, &pvalue->
         u.alt_5);
      if (stat == 0) pvalue->t = 6;
   }
   if (pvalue->t == 0) {
      stat = Week_of_year_calendar_alt_6_ToEnum (pctxt, pdata1, &pvalue->
         u.alt_6);
      if (stat == 0) pvalue->t = 7;
   }
   if (pvalue->t == 0) {
      stat = Week_of_year_calendar_alt_7_ToEnum (pctxt, pdata1, &pvalue->
         u.alt_7);
      if (stat == 0) pvalue->t = 8;
   }
   if (pvalue->t == 0) {
      stat = Week_of_year_calendar_alt_8_ToEnum (pctxt, pdata1, &pvalue->
         u.alt_8);
      if (stat == 0) pvalue->t = 9;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Week_of_year                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Week_of_year (OSCTXT* pctxt, Week_of_year *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode calendar */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Week_of_year_calendar (pctxt, 
               &pvalue->calendar, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.calendarPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Week_of_year (OSCTXT* pctxt, Week_of_year* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("calendar"), 8}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* calendar */
            stat = XmlDec_Week_of_year_calendar (pctxt, &pvalue->calendar);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.calendarPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Week_of_year");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Week_of_year");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_1                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Quarter_calendar_alt_1 (OSCTXT* pctxt, 
   Quarter_calendar_alt_1 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Quarter_calendar_alt_1 (OSCTXT* pctxt, 
   Quarter_calendar_alt_1* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Quarter_calendar_alt_1_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_2                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Quarter_calendar_alt_2 (OSCTXT* pctxt, 
   Quarter_calendar_alt_2 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Quarter_calendar_alt_2 (OSCTXT* pctxt, 
   Quarter_calendar_alt_2* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Quarter_calendar_alt_2_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_3                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Quarter_calendar_alt_3 (OSCTXT* pctxt, 
   Quarter_calendar_alt_3 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Quarter_calendar_alt_3 (OSCTXT* pctxt, 
   Quarter_calendar_alt_3* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Quarter_calendar_alt_3_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_4                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Quarter_calendar_alt_4 (OSCTXT* pctxt, 
   Quarter_calendar_alt_4 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Quarter_calendar_alt_4 (OSCTXT* pctxt, 
   Quarter_calendar_alt_4* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Quarter_calendar_alt_4_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_5                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Quarter_calendar_alt_5 (OSCTXT* pctxt, 
   Quarter_calendar_alt_5 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Quarter_calendar_alt_5 (OSCTXT* pctxt, 
   Quarter_calendar_alt_5* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Quarter_calendar_alt_5_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_6                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Quarter_calendar_alt_6 (OSCTXT* pctxt, 
   Quarter_calendar_alt_6 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Quarter_calendar_alt_6 (OSCTXT* pctxt, 
   Quarter_calendar_alt_6* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Quarter_calendar_alt_6_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_7                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Quarter_calendar_alt_7 (OSCTXT* pctxt, 
   Quarter_calendar_alt_7 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Quarter_calendar_alt_7 (OSCTXT* pctxt, 
   Quarter_calendar_alt_7* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Quarter_calendar_alt_7_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar_alt_8                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Quarter_calendar_alt_8 (OSCTXT* pctxt, 
   Quarter_calendar_alt_8 *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Quarter_calendar_alt_8 (OSCTXT* pctxt, 
   Quarter_calendar_alt_8* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Quarter_calendar_alt_8_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_calendar                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Quarter_calendar (OSCTXT* pctxt, Quarter_calendar *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_PRIM|0):
      case (TM_CTXT|TM_CONS|0):
         stat = xd_utf8str (pctxt, &pvalue->u.alt, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         ccb.len = 0;
         break;

      case (TM_CTXT|TM_PRIM|1):
         stat = asn1D_Quarter_calendar_alt_1 (pctxt, 
            &pvalue->u.alt_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_PRIM|2):
         stat = asn1D_Quarter_calendar_alt_2 (pctxt, 
            &pvalue->u.alt_2, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_PRIM|3):
         stat = asn1D_Quarter_calendar_alt_3 (pctxt, 
            &pvalue->u.alt_3, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_PRIM|4):
         stat = asn1D_Quarter_calendar_alt_4 (pctxt, 
            &pvalue->u.alt_4, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_PRIM|5):
         stat = asn1D_Quarter_calendar_alt_5 (pctxt, 
            &pvalue->u.alt_5, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_PRIM|6):
         stat = asn1D_Quarter_calendar_alt_6 (pctxt, 
            &pvalue->u.alt_6, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_PRIM|7):
         stat = asn1D_Quarter_calendar_alt_7 (pctxt, 
            &pvalue->u.alt_7, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_PRIM|8):
         stat = asn1D_Quarter_calendar_alt_8 (pctxt, 
            &pvalue->u.alt_8, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Quarter_calendar (OSCTXT* pctxt, Quarter_calendar* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* pdata1;

   stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->t = 0;
   if (pvalue->t == 0) {
      pvalue->u.alt = pdata1;
      pvalue->t = 1;
   }
   if (pvalue->t == 0) {
      stat = Quarter_calendar_alt_1_ToEnum (pctxt, pdata1, &pvalue->u.alt_1);
      if (stat == 0) pvalue->t = 2;
   }
   if (pvalue->t == 0) {
      stat = Quarter_calendar_alt_2_ToEnum (pctxt, pdata1, &pvalue->u.alt_2);
      if (stat == 0) pvalue->t = 3;
   }
   if (pvalue->t == 0) {
      stat = Quarter_calendar_alt_3_ToEnum (pctxt, pdata1, &pvalue->u.alt_3);
      if (stat == 0) pvalue->t = 4;
   }
   if (pvalue->t == 0) {
      stat = Quarter_calendar_alt_4_ToEnum (pctxt, pdata1, &pvalue->u.alt_4);
      if (stat == 0) pvalue->t = 5;
   }
   if (pvalue->t == 0) {
      stat = Quarter_calendar_alt_5_ToEnum (pctxt, pdata1, &pvalue->u.alt_5);
      if (stat == 0) pvalue->t = 6;
   }
   if (pvalue->t == 0) {
      stat = Quarter_calendar_alt_6_ToEnum (pctxt, pdata1, &pvalue->u.alt_6);
      if (stat == 0) pvalue->t = 7;
   }
   if (pvalue->t == 0) {
      stat = Quarter_calendar_alt_7_ToEnum (pctxt, pdata1, &pvalue->u.alt_7);
      if (stat == 0) pvalue->t = 8;
   }
   if (pvalue->t == 0) {
      stat = Quarter_calendar_alt_8_ToEnum (pctxt, pdata1, &pvalue->u.alt_8);
      if (stat == 0) pvalue->t = 9;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter_style                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Quarter_style (OSCTXT* pctxt, Quarter_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Quarter_style (OSCTXT* pctxt, Quarter_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Quarter_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Quarter                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Quarter (OSCTXT* pctxt, Quarter *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode calendar */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Quarter_calendar (pctxt, 
               &pvalue->calendar, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.calendarPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 1:
         /* decode style */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Quarter_style (pctxt, 
               &pvalue->style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.stylePresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Quarter (OSCTXT* pctxt, Quarter* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("calendar"), 8}, 0 },
         { {OSUTF8("style"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* calendar */
            stat = XmlDec_Quarter_calendar (pctxt, &pvalue->calendar);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.calendarPresent = TRUE;
            break;

         case 1: /* style */
            stat = XmlDec_Quarter_style (pctxt, &pvalue->style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.stylePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Quarter");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Quarter");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Hours_style                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Hours_style (OSCTXT* pctxt, Hours_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Hours_style (OSCTXT* pctxt, Hours_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Hours_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Hours                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Hours (OSCTXT* pctxt, Hours *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode style */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Hours_style (pctxt, 
               &pvalue->style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.stylePresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Hours (OSCTXT* pctxt, Hours* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("style"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* style */
            stat = XmlDec_Hours_style (pctxt, &pvalue->style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.stylePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Hours");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Hours");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Am_pm                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Am_pm (OSCTXT* pctxt, Am_pm *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   if (tagging == ASN1EXPL && length == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Am_pm (OSCTXT* pctxt, Am_pm* pvalue)
{
   int stat = 0;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Minutes_style                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Minutes_style (OSCTXT* pctxt, Minutes_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Minutes_style (OSCTXT* pctxt, Minutes_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Minutes_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Minutes                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Minutes (OSCTXT* pctxt, Minutes *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode style */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Minutes_style (pctxt, 
               &pvalue->style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.stylePresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Minutes (OSCTXT* pctxt, Minutes* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("style"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* style */
            stat = XmlDec_Minutes_style (pctxt, &pvalue->style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.stylePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Minutes");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Minutes");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Seconds_style                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Seconds_style (OSCTXT* pctxt, Seconds_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Seconds_style (OSCTXT* pctxt, Seconds_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Seconds_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Seconds                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Seconds (OSCTXT* pctxt, Seconds *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode decimal_places */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->decimal_places, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.decimal_placesPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode style */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Seconds_style (pctxt, 
               &pvalue->style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.stylePresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Seconds (OSCTXT* pctxt, Seconds* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("decimal-places"), 14}, 0 },
         { {OSUTF8("style"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* decimal-places */
            stat = rtXmlpDecInt (pctxt, &pvalue->decimal_places);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.decimal_placesPresent = TRUE;
            break;

         case 1: /* style */
            stat = XmlDec_Seconds_style (pctxt, &pvalue->style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.stylePresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Seconds");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Seconds");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date_style_element_choice                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Date_style_element_choice (OSCTXT* pctxt, 
   Date_style_element_choice *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.day = rtxMemAllocType (pctxt, Ns14_Day);

         if (pvalue->u.day == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Ns14_Day (pvalue->u.day);
         stat = asn1D_Ns14_Day (pctxt, 
            pvalue->u.day, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.month = rtxMemAllocType (pctxt, Ns14_Month);

         if (pvalue->u.month == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Ns14_Month (pvalue->u.month);
         stat = asn1D_Ns14_Month (pctxt, 
            pvalue->u.month, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.year = rtxMemAllocType (pctxt, Ns14_Year);

         if (pvalue->u.year == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Ns14_Year (pvalue->u.year);
         stat = asn1D_Ns14_Year (pctxt, 
            pvalue->u.year, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.era = rtxMemAllocType (pctxt, Era);

         if (pvalue->u.era == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Era (pvalue->u.era);
         stat = asn1D_Era (pctxt, 
            pvalue->u.era, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_CONS|4):
         pvalue->u.day_of_week = rtxMemAllocType (pctxt, Day_of_week);

         if (pvalue->u.day_of_week == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Day_of_week (pvalue->u.day_of_week);
         stat = asn1D_Day_of_week (pctxt, 
            pvalue->u.day_of_week, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_CONS|5):
         pvalue->u.week_of_year = rtxMemAllocType (pctxt, Week_of_year);

         if (pvalue->u.week_of_year == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Week_of_year (pvalue->u.week_of_year);
         stat = asn1D_Week_of_year (pctxt, 
            pvalue->u.week_of_year, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_CONS|6):
         pvalue->u.quarter = rtxMemAllocType (pctxt, Quarter);

         if (pvalue->u.quarter == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Quarter (pvalue->u.quarter);
         stat = asn1D_Quarter (pctxt, 
            pvalue->u.quarter, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_CONS|7):
         pvalue->u.hours = rtxMemAllocType (pctxt, Hours);

         if (pvalue->u.hours == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Hours (pvalue->u.hours);
         stat = asn1D_Hours (pctxt, 
            pvalue->u.hours, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_CONS|8):
         pvalue->u.am_pm = rtxMemAllocType (pctxt, Am_pm);

         if (pvalue->u.am_pm == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Am_pm (pvalue->u.am_pm);
         stat = asn1D_Am_pm (pctxt, 
            pvalue->u.am_pm, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      case (TM_CTXT|TM_CONS|9):
         pvalue->u.minutes = rtxMemAllocType (pctxt, Minutes);

         if (pvalue->u.minutes == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Minutes (pvalue->u.minutes);
         stat = asn1D_Minutes (pctxt, 
            pvalue->u.minutes, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 10;
         break;

      case (TM_CTXT|TM_CONS|10):
         pvalue->u.seconds = rtxMemAllocType (pctxt, Seconds);

         if (pvalue->u.seconds == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Seconds (pvalue->u.seconds);
         stat = asn1D_Seconds (pctxt, 
            pvalue->u.seconds, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 11;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Date_style_element_choice (OSCTXT* pctxt, 
   Date_style_element_choice* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("day"), 3}, 0}, 0 },
      {{{OSUTF8("month"), 5}, 0}, 1 },
      {{{OSUTF8("year"), 4}, 0}, 2 },
      {{{OSUTF8("era"), 3}, 0}, 3 },
      {{{OSUTF8("day-of-week"), 11}, 0}, 4 },
      {{{OSUTF8("week-of-year"), 12}, 0}, 5 },
      {{{OSUTF8("quarter"), 7}, 0}, 6 },
      {{{OSUTF8("hours"), 5}, 0}, 7 },
      {{{OSUTF8("am-pm"), 5}, 0}, 8 },
      {{{OSUTF8("minutes"), 7}, 0}, 9 },
      {{{OSUTF8("seconds"), 7}, 0}, 10 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 11, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* day */
      pvalue->u.day = rtxMemAllocType (pctxt, Ns14_Day);

      if (pvalue->u.day == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Ns14_Day (pvalue->u.day);

      stat = XmlDec_Ns14_Day (pctxt, pvalue->u.day);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* month */
      pvalue->u.month = rtxMemAllocType (pctxt, Ns14_Month);

      if (pvalue->u.month == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Ns14_Month (pvalue->u.month);

      stat = XmlDec_Ns14_Month (pctxt, pvalue->u.month);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* year */
      pvalue->u.year = rtxMemAllocType (pctxt, Ns14_Year);

      if (pvalue->u.year == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Ns14_Year (pvalue->u.year);

      stat = XmlDec_Ns14_Year (pctxt, pvalue->u.year);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* era */
      pvalue->u.era = rtxMemAllocType (pctxt, Era);

      if (pvalue->u.era == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Era (pvalue->u.era);

      stat = XmlDec_Era (pctxt, pvalue->u.era);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 4: { /* day-of-week */
      pvalue->u.day_of_week = rtxMemAllocType (pctxt, Day_of_week);

      if (pvalue->u.day_of_week == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Day_of_week (pvalue->u.day_of_week);

      stat = XmlDec_Day_of_week (pctxt, pvalue->u.day_of_week);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 5: { /* week-of-year */
      pvalue->u.week_of_year = rtxMemAllocType (pctxt, Week_of_year);

      if (pvalue->u.week_of_year == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Week_of_year (pvalue->u.week_of_year);

      stat = XmlDec_Week_of_year (pctxt, pvalue->u.week_of_year);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 6: { /* quarter */
      pvalue->u.quarter = rtxMemAllocType (pctxt, Quarter);

      if (pvalue->u.quarter == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Quarter (pvalue->u.quarter);

      stat = XmlDec_Quarter (pctxt, pvalue->u.quarter);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 7: { /* hours */
      pvalue->u.hours = rtxMemAllocType (pctxt, Hours);

      if (pvalue->u.hours == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Hours (pvalue->u.hours);

      stat = XmlDec_Hours (pctxt, pvalue->u.hours);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 8: { /* am-pm */
      pvalue->u.am_pm = rtxMemAllocType (pctxt, Am_pm);

      if (pvalue->u.am_pm == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Am_pm (pvalue->u.am_pm);

      stat = XmlDec_Am_pm (pctxt, pvalue->u.am_pm);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 9: { /* minutes */
      pvalue->u.minutes = rtxMemAllocType (pctxt, Minutes);

      if (pvalue->u.minutes == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Minutes (pvalue->u.minutes);

      stat = XmlDec_Minutes (pctxt, pvalue->u.minutes);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 10: { /* seconds */
      pvalue->u.seconds = rtxMemAllocType (pctxt, Seconds);

      if (pvalue->u.seconds == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Seconds (pvalue->u.seconds);

      stat = XmlDec_Seconds (pctxt, pvalue->u.seconds);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date_style_element                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Date_style_element (OSCTXT* pctxt, 
   Date_style_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Date_style_element_choice (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Date_style_element (OSCTXT* pctxt, Date_style_element* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("day"), 3}, 0}, 0 },
      {{{OSUTF8("month"), 5}, 0}, 0 },
      {{{OSUTF8("year"), 4}, 0}, 0 },
      {{{OSUTF8("era"), 3}, 0}, 0 },
      {{{OSUTF8("day-of-week"), 11}, 0}, 0 },
      {{{OSUTF8("week-of-year"), 12}, 0}, 0 },
      {{{OSUTF8("quarter"), 7}, 0}, 0 },
      {{{OSUTF8("hours"), 5}, 0}, 0 },
      {{{OSUTF8("am-pm"), 5}, 0}, 0 },
      {{{OSUTF8("minutes"), 7}, 0}, 0 },
      {{{OSUTF8("seconds"), 7}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 11, -1}, {11, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /*  */
         stat = XmlDec_Date_style_element_choice (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date_style                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Date_style (OSCTXT* pctxt, Date_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode automatic_order */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Date_style_automatic_order (pctxt, 
               &pvalue->automatic_order, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.automatic_orderPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode country */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.countryPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode format_source */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Date_style_format_source (pctxt, 
               &pvalue->format_source, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.format_sourcePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode language */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languagePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode title */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->title, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.titlePresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode transliteration_country */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_countryPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode transliteration_format */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_format, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_formatPresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode transliteration_language */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_languagePresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode transliteration_style */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Date_style_transliteration_style (pctxt, 
               &pvalue->transliteration_style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_stylePresent = TRUE;
            }
         }
         break;

      case 9:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Name (pctxt, 
               (Ns8_Name*)&pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 10:
         /* decode volatile_ */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Volatile (pctxt, 
               (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.volatile_Present = TRUE;
            }
         }
         break;

      case 11:
         /* decode text_properties */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->text_properties
                = rtxMemAllocType (pctxt, Ns8_Text_properties);

            if (pvalue->text_properties == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);
            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);

            stat = asn1D_Ns8_Text_properties (pctxt, 
               (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.text_propertiesPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 12:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      case 13:
         /* decode sequence_list */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Date_style_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->sequence_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Date_style_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Date_style_element (pdata2);

                  stat = asn1D_Date_style_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->sequence_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 14:
         /* decode map_list */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Ns8_Map* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->map_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Ns8_Map, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Ns8_Map ((Ns8_Map*)pdata2);

                  stat = asn1D_Ns8_Map (pctxt, 
                     (Ns8_Map*)pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->map_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_CONS|14):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Date_style (OSCTXT* pctxt, Date_style* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("automatic-order"), 15}, 0 },
         { {OSUTF8("country"), 7}, 0 },
         { {OSUTF8("format-source"), 13}, 0 },
         { {OSUTF8("language"), 8}, 0 },
         { {OSUTF8("title"), 5}, 0 },
         { {OSUTF8("transliteration-country"), 23}, 0 },
         { {OSUTF8("transliteration-format"), 22}, 0 },
         { {OSUTF8("transliteration-language"), 24}, 0 },
         { {OSUTF8("transliteration-style"), 21}, 0 },
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("volatile"), 8}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 11, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* automatic-order */
            stat = XmlDec_Date_style_automatic_order (pctxt, &pvalue->
               automatic_order);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.automatic_orderPresent = TRUE;
            break;

         case 1: /* country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->country);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.countryPresent = TRUE;
            break;

         case 2: /* format-source */
            stat = XmlDec_Date_style_format_source (pctxt, &pvalue->
               format_source);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.format_sourcePresent = TRUE;
            break;

         case 3: /* language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.languagePresent = TRUE;
            break;

         case 4: /* title */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->title);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.titlePresent = TRUE;
            break;

         case 5: /* transliteration-country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_country
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_countryPresent = TRUE;
            break;

         case 6: /* transliteration-format */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_format
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_formatPresent = TRUE;
            break;

         case 7: /* transliteration-language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
               transliteration_language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_languagePresent = TRUE;
            break;

         case 8: /* transliteration-style */
            stat = XmlDec_Date_style_transliteration_style (pctxt, &pvalue->
               transliteration_style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_stylePresent = TRUE;
            break;

         case 9: /* name */
            stat = XmlDec_Ns8_Name (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 10: /* volatile */
            stat = XmlDec_Ns8_Volatile (pctxt, &pvalue->volatile_);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.volatile_Present = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Date_style");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Date_style");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("text-properties"), 15}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 },
      {{{OSUTF8("day"), 3}, 0}, 2 },
      {{{OSUTF8("month"), 5}, 0}, 2 },
      {{{OSUTF8("year"), 4}, 0}, 2 },
      {{{OSUTF8("era"), 3}, 0}, 2 },
      {{{OSUTF8("day-of-week"), 11}, 0}, 2 },
      {{{OSUTF8("week-of-year"), 12}, 0}, 2 },
      {{{OSUTF8("quarter"), 7}, 0}, 2 },
      {{{OSUTF8("hours"), 5}, 0}, 2 },
      {{{OSUTF8("am-pm"), 5}, 0}, 2 },
      {{{OSUTF8("minutes"), 7}, 0}, 2 },
      {{{OSUTF8("seconds"), 7}, 0}, 2 },
      {{{OSUTF8("map"), 3}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 14, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* text-properties */
         pvalue->text_properties
             = rtxMemAllocType (pctxt, Ns8_Text_properties);

         if (pvalue->text_properties == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->
            text_properties);

         stat = XmlDec_Ns8_Text_properties (pctxt, pvalue->text_properties);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.text_propertiesPresent = TRUE;
         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      case 2: {
         Date_style_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Date_style_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Date_style_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_Date_style_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->sequence_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, 11, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 2);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 3: {
         Ns8_Map* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Ns8_Map);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Map ((Ns8_Map*)pdata1);

            stat = XmlDec_Ns8_Map (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->map_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 13, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time_style_format_source                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Time_style_format_source (OSCTXT* pctxt, 
   Time_style_format_source *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Time_style_format_source (OSCTXT* pctxt, 
   Time_style_format_source* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Time_style_format_source_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time_style_transliteration_style                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Time_style_transliteration_style (OSCTXT* pctxt, 
   Time_style_transliteration_style *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Time_style_transliteration_style (OSCTXT* pctxt, 
   Time_style_transliteration_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Time_style_transliteration_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time_style_truncate_on_overflow                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Time_style_truncate_on_overflow (OSCTXT* pctxt, 
   Time_style_truncate_on_overflow *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Time_style_truncate_on_overflow (OSCTXT* pctxt, 
   Time_style_truncate_on_overflow* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Time_style_truncate_on_overflow_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time_style_element_choice                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Time_style_element_choice (OSCTXT* pctxt, 
   Time_style_element_choice *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.hours = rtxMemAllocType (pctxt, Hours);

         if (pvalue->u.hours == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Hours (pvalue->u.hours);
         stat = asn1D_Hours (pctxt, 
            pvalue->u.hours, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.am_pm = rtxMemAllocType (pctxt, Am_pm);

         if (pvalue->u.am_pm == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Am_pm (pvalue->u.am_pm);
         stat = asn1D_Am_pm (pctxt, 
            pvalue->u.am_pm, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.minutes = rtxMemAllocType (pctxt, Minutes);

         if (pvalue->u.minutes == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Minutes (pvalue->u.minutes);
         stat = asn1D_Minutes (pctxt, 
            pvalue->u.minutes, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.seconds = rtxMemAllocType (pctxt, Seconds);

         if (pvalue->u.seconds == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Seconds (pvalue->u.seconds);
         stat = asn1D_Seconds (pctxt, 
            pvalue->u.seconds, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Time_style_element_choice (OSCTXT* pctxt, 
   Time_style_element_choice* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("hours"), 5}, 0}, 0 },
      {{{OSUTF8("am-pm"), 5}, 0}, 1 },
      {{{OSUTF8("minutes"), 7}, 0}, 2 },
      {{{OSUTF8("seconds"), 7}, 0}, 3 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 4, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* hours */
      pvalue->u.hours = rtxMemAllocType (pctxt, Hours);

      if (pvalue->u.hours == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Hours (pvalue->u.hours);

      stat = XmlDec_Hours (pctxt, pvalue->u.hours);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* am-pm */
      pvalue->u.am_pm = rtxMemAllocType (pctxt, Am_pm);

      if (pvalue->u.am_pm == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Am_pm (pvalue->u.am_pm);

      stat = XmlDec_Am_pm (pctxt, pvalue->u.am_pm);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* minutes */
      pvalue->u.minutes = rtxMemAllocType (pctxt, Minutes);

      if (pvalue->u.minutes == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Minutes (pvalue->u.minutes);

      stat = XmlDec_Minutes (pctxt, pvalue->u.minutes);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* seconds */
      pvalue->u.seconds = rtxMemAllocType (pctxt, Seconds);

      if (pvalue->u.seconds == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Seconds (pvalue->u.seconds);

      stat = XmlDec_Seconds (pctxt, pvalue->u.seconds);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time_style_element                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Time_style_element (OSCTXT* pctxt, 
   Time_style_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Time_style_element_choice (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Time_style_element (OSCTXT* pctxt, Time_style_element* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("hours"), 5}, 0}, 0 },
      {{{OSUTF8("am-pm"), 5}, 0}, 0 },
      {{{OSUTF8("minutes"), 7}, 0}, 0 },
      {{{OSUTF8("seconds"), 7}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}, {4, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /*  */
         stat = XmlDec_Time_style_element_choice (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time_style                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Time_style (OSCTXT* pctxt, Time_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode country */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.countryPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode format_source */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Time_style_format_source (pctxt, 
               &pvalue->format_source, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.format_sourcePresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode language */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languagePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode title */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->title, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.titlePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode transliteration_country */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_countryPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode transliteration_format */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_format, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_formatPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode transliteration_language */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_languagePresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode transliteration_style */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Time_style_transliteration_style (pctxt, 
               &pvalue->transliteration_style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_stylePresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode truncate_on_overflow */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Time_style_truncate_on_overflow (pctxt, 
               &pvalue->truncate_on_overflow, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.truncate_on_overflowPresent = TRUE;
            }
         }
         break;

      case 9:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Name (pctxt, 
               (Ns8_Name*)&pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 10:
         /* decode volatile_ */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Volatile (pctxt, 
               (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.volatile_Present = TRUE;
            }
         }
         break;

      case 11:
         /* decode text_properties */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->text_properties
                = rtxMemAllocType (pctxt, Ns8_Text_properties);

            if (pvalue->text_properties == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);
            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);

            stat = asn1D_Ns8_Text_properties (pctxt, 
               (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.text_propertiesPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 12:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      case 13:
         /* decode sequence_list */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Time_style_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->sequence_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Time_style_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Time_style_element (pdata2);

                  stat = asn1D_Time_style_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->sequence_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 14:
         /* decode map_list */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Ns8_Map* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->map_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Ns8_Map, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Ns8_Map ((Ns8_Map*)pdata2);

                  stat = asn1D_Ns8_Map (pctxt, 
                     (Ns8_Map*)pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->map_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_CONS|14):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Time_style (OSCTXT* pctxt, Time_style* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("country"), 7}, 0 },
         { {OSUTF8("format-source"), 13}, 0 },
         { {OSUTF8("language"), 8}, 0 },
         { {OSUTF8("title"), 5}, 0 },
         { {OSUTF8("transliteration-country"), 23}, 0 },
         { {OSUTF8("transliteration-format"), 22}, 0 },
         { {OSUTF8("transliteration-language"), 24}, 0 },
         { {OSUTF8("transliteration-style"), 21}, 0 },
         { {OSUTF8("truncate-on-overflow"), 20}, 0 },
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("volatile"), 8}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 11, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->country);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.countryPresent = TRUE;
            break;

         case 1: /* format-source */
            stat = XmlDec_Time_style_format_source (pctxt, &pvalue->
               format_source);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.format_sourcePresent = TRUE;
            break;

         case 2: /* language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.languagePresent = TRUE;
            break;

         case 3: /* title */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->title);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.titlePresent = TRUE;
            break;

         case 4: /* transliteration-country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_country
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_countryPresent = TRUE;
            break;

         case 5: /* transliteration-format */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_format
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_formatPresent = TRUE;
            break;

         case 6: /* transliteration-language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
               transliteration_language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_languagePresent = TRUE;
            break;

         case 7: /* transliteration-style */
            stat = XmlDec_Time_style_transliteration_style (pctxt, &pvalue->
               transliteration_style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_stylePresent = TRUE;
            break;

         case 8: /* truncate-on-overflow */
            stat = XmlDec_Time_style_truncate_on_overflow (pctxt, &pvalue->
               truncate_on_overflow);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.truncate_on_overflowPresent = TRUE;
            break;

         case 9: /* name */
            stat = XmlDec_Ns8_Name (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 10: /* volatile */
            stat = XmlDec_Ns8_Volatile (pctxt, &pvalue->volatile_);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.volatile_Present = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Time_style");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Time_style");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("text-properties"), 15}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 },
      {{{OSUTF8("hours"), 5}, 0}, 2 },
      {{{OSUTF8("am-pm"), 5}, 0}, 2 },
      {{{OSUTF8("minutes"), 7}, 0}, 2 },
      {{{OSUTF8("seconds"), 7}, 0}, 2 },
      {{{OSUTF8("map"), 3}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 7, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* text-properties */
         pvalue->text_properties
             = rtxMemAllocType (pctxt, Ns8_Text_properties);

         if (pvalue->text_properties == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->
            text_properties);

         stat = XmlDec_Ns8_Text_properties (pctxt, pvalue->text_properties);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.text_propertiesPresent = TRUE;
         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      case 2: {
         Time_style_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Time_style_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Time_style_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_Time_style_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->sequence_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, 4, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 2);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 3: {
         Ns8_Map* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Ns8_Map);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Map ((Ns8_Map*)pdata1);

            stat = XmlDec_Ns8_Map (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->map_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 6, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Boolean_style_transliteration_style                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Boolean_style_transliteration_style (OSCTXT* pctxt, 
   Boolean_style_transliteration_style *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Boolean_style_transliteration_style (OSCTXT* pctxt, 
   Boolean_style_transliteration_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Boolean_style_transliteration_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Boolean                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Ns14_Boolean (OSCTXT* pctxt, Ns14_Boolean *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   if (tagging == ASN1EXPL && length == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Ns14_Boolean (OSCTXT* pctxt, Ns14_Boolean* pvalue)
{
   int stat = 0;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Boolean_style_sequence                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Boolean_style_sequence (OSCTXT* pctxt, 
   Boolean_style_sequence *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode boolean_ */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns14_Boolean (pctxt, 
               &pvalue->boolean_, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Boolean_style_sequence (OSCTXT* pctxt, 
   Boolean_style_sequence* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("boolean"), 7}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* boolean */
         stat = XmlDec_Ns14_Boolean (pctxt, &pvalue->boolean_);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Boolean_style                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Boolean_style (OSCTXT* pctxt, Boolean_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode country */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.countryPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode language */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languagePresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode title */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->title, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.titlePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode transliteration_country */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_countryPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode transliteration_format */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_format, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_formatPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode transliteration_language */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_languagePresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode transliteration_style */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Boolean_style_transliteration_style (pctxt, 
               &pvalue->transliteration_style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_stylePresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Name (pctxt, 
               (Ns8_Name*)&pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode volatile_ */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Volatile (pctxt, 
               (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.volatile_Present = TRUE;
            }
         }
         break;

      case 9:
         /* decode text_properties */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->text_properties
                = rtxMemAllocType (pctxt, Ns8_Text_properties);

            if (pvalue->text_properties == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);
            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);

            stat = asn1D_Ns8_Text_properties (pctxt, 
               (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.text_propertiesPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 10:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode sequence */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Boolean_style_sequence (pctxt, 
               &pvalue->sequence, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.sequencePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 12:
         /* decode map_list */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Ns8_Map* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->map_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Ns8_Map, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Ns8_Map ((Ns8_Map*)pdata2);

                  stat = asn1D_Ns8_Map (pctxt, 
                     (Ns8_Map*)pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->map_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_CONS|12):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Boolean_style (OSCTXT* pctxt, Boolean_style* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("country"), 7}, 0 },
         { {OSUTF8("language"), 8}, 0 },
         { {OSUTF8("title"), 5}, 0 },
         { {OSUTF8("transliteration-country"), 23}, 0 },
         { {OSUTF8("transliteration-format"), 22}, 0 },
         { {OSUTF8("transliteration-language"), 24}, 0 },
         { {OSUTF8("transliteration-style"), 21}, 0 },
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("volatile"), 8}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 9, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->country);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.countryPresent = TRUE;
            break;

         case 1: /* language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.languagePresent = TRUE;
            break;

         case 2: /* title */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->title);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.titlePresent = TRUE;
            break;

         case 3: /* transliteration-country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_country
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_countryPresent = TRUE;
            break;

         case 4: /* transliteration-format */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_format
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_formatPresent = TRUE;
            break;

         case 5: /* transliteration-language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
               transliteration_language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_languagePresent = TRUE;
            break;

         case 6: /* transliteration-style */
            stat = XmlDec_Boolean_style_transliteration_style (pctxt, &pvalue->
               transliteration_style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_stylePresent = TRUE;
            break;

         case 7: /* name */
            stat = XmlDec_Ns8_Name (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 8: /* volatile */
            stat = XmlDec_Ns8_Volatile (pctxt, &pvalue->volatile_);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.volatile_Present = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Boolean_style");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Boolean_style");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("text-properties"), 15}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 },
      {{{OSUTF8("boolean"), 7}, 0}, 2 },
      {{{OSUTF8("map"), 3}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* text-properties */
         pvalue->text_properties
             = rtxMemAllocType (pctxt, Ns8_Text_properties);

         if (pvalue->text_properties == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->
            text_properties);

         stat = XmlDec_Ns8_Text_properties (pctxt, pvalue->text_properties);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.text_propertiesPresent = TRUE;
         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      case 2: { /*  */
         stat = XmlDec_Boolean_style_sequence (pctxt, &pvalue->sequence);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.sequencePresent = TRUE;
         break;
      }
      case 3: {
         Ns8_Map* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Ns8_Map);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Map ((Ns8_Map*)pdata1);

            stat = XmlDec_Ns8_Map (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->map_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Text_style_transliteration_style                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Text_style_transliteration_style (OSCTXT* pctxt, 
   Text_style_transliteration_style *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Text_style_transliteration_style (OSCTXT* pctxt, 
   Text_style_transliteration_style* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = Text_style_transliteration_style_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Text_content                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Text_content (OSCTXT* pctxt, Text_content *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   if (tagging == ASN1EXPL && length == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Text_content (OSCTXT* pctxt, Text_content* pvalue)
{
   int stat = 0;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Text_style_element                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Text_style_element (OSCTXT* pctxt, 
   Text_style_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode text_content */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text_content (pctxt, 
               &pvalue->text_content, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Text_style_element (OSCTXT* pctxt, Text_style_element* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("text-content"), 12}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* text-content */
         stat = XmlDec_Text_content (pctxt, &pvalue->text_content);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Text_style                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Text_style (OSCTXT* pctxt, Text_style *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode country */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.countryPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode language */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.languagePresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode title */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->title, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.titlePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode transliteration_country */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_country, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_countryPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode transliteration_format */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_format, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_formatPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode transliteration_language */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->transliteration_language, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_languagePresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode transliteration_style */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text_style_transliteration_style (pctxt, 
               &pvalue->transliteration_style, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.transliteration_stylePresent = TRUE;
            }
         }
         break;

      case 7:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Name (pctxt, 
               (Ns8_Name*)&pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode volatile_ */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Ns8_Volatile (pctxt, 
               (Ns8_Volatile*)&pvalue->volatile_, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.volatile_Present = TRUE;
            }
         }
         break;

      case 9:
         /* decode text_properties */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->text_properties
                = rtxMemAllocType (pctxt, Ns8_Text_properties);

            if (pvalue->text_properties == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);
            asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->text_properties);

            stat = asn1D_Ns8_Text_properties (pctxt, 
               (Ns8_Text_properties*)pvalue->text_properties, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.text_propertiesPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 10:
         /* decode text */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Text (pctxt, 
               &pvalue->text, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.textPresent = TRUE;
            }
         }
         break;

      case 11:
         /* decode sequence_list */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Text_style_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->sequence_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Text_style_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Text_style_element (pdata2);

                  stat = asn1D_Text_style_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->sequence_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 12:
         /* decode map_list */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Ns8_Map* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->map_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Ns8_Map, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Ns8_Map ((Ns8_Map*)pdata2);

                  stat = asn1D_Ns8_Map (pctxt, 
                     (Ns8_Map*)pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->map_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_CONS|12):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Text_style (OSCTXT* pctxt, Text_style* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("country"), 7}, 0 },
         { {OSUTF8("language"), 8}, 0 },
         { {OSUTF8("title"), 5}, 0 },
         { {OSUTF8("transliteration-country"), 23}, 0 },
         { {OSUTF8("transliteration-format"), 22}, 0 },
         { {OSUTF8("transliteration-language"), 24}, 0 },
         { {OSUTF8("transliteration-style"), 21}, 0 },
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("volatile"), 8}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 9, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->country);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.countryPresent = TRUE;
            break;

         case 1: /* language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.languagePresent = TRUE;
            break;

         case 2: /* title */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->title);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.titlePresent = TRUE;
            break;

         case 3: /* transliteration-country */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_country
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_countryPresent = TRUE;
            break;

         case 4: /* transliteration-format */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->transliteration_format
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_formatPresent = TRUE;
            break;

         case 5: /* transliteration-language */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
               transliteration_language);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_languagePresent = TRUE;
            break;

         case 6: /* transliteration-style */
            stat = XmlDec_Text_style_transliteration_style (pctxt, &pvalue->
               transliteration_style);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.transliteration_stylePresent = TRUE;
            break;

         case 7: /* name */
            stat = XmlDec_Ns8_Name (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 8: /* volatile */
            stat = XmlDec_Ns8_Volatile (pctxt, &pvalue->volatile_);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.volatile_Present = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Text_style");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Text_style");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("text-properties"), 15}, 0}, 0 },
      {{{OSUTF8("text"), 4}, 0}, 1 },
      {{{OSUTF8("text-content"), 12}, 0}, 2 },
      {{{OSUTF8("map"), 3}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* text-properties */
         pvalue->text_properties
             = rtxMemAllocType (pctxt, Ns8_Text_properties);

         if (pvalue->text_properties == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Ns8_Text_properties ((Ns8_Text_properties*)pvalue->
            text_properties);

         stat = XmlDec_Ns8_Text_properties (pctxt, pvalue->text_properties);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.text_propertiesPresent = TRUE;
         break;
      }
      case 1: { /* text */
         stat = XmlDec_Text (pctxt, &pvalue->text);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.textPresent = TRUE;
         break;
      }
      case 2: {
         Text_style_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Text_style_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Text_style_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_Text_style_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->sequence_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 2);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 3: {
         Ns8_Map* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Ns8_Map);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Ns8_Map ((Ns8_Map*)pdata1);

            stat = XmlDec_Ns8_Map (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->map_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

