/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "HepRep.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  Point                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Point (OSCTXT* pctxt, Point *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode x */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->x, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode y */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->y, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode z */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->z, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Point (OSCTXT* pctxt, Point* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("x"), 1}, 0 },
         { {OSUTF8("y"), 1}, 0 },
         { {OSUTF8("z"), 1}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* x */
            stat = rtXmlpDecDouble (pctxt, &pvalue->x, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* y */
            stat = rtXmlpDecDouble (pctxt, &pvalue->y, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 2: /* z */
            stat = rtXmlpDecDouble (pctxt, &pvalue->z, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Point");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Point");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Primitive                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Primitive (OSCTXT* pctxt, Primitive *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode point_list */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Point* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->point_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Point, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Point (pdata2);

                  stat = asn1D_Point (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->point_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Primitive (OSCTXT* pctxt, Primitive* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("point"), 5}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Point* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Point);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Point (pdata1);

            stat = XmlDec_Point (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->point_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Type_element                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Type_element (OSCTXT* pctxt, Type_element *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.instance = rtxMemAllocType (pctxt, Instance);

         if (pvalue->u.instance == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Instance ((Instance*)pvalue->u.instance);
         stat = asn1D_Instance (pctxt, 
            (Instance*)pvalue->u.instance, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.type = rtxMemAllocType (pctxt, Type);

         if (pvalue->u.type == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Type ((Type*)pvalue->u.type);
         stat = asn1D_Type (pctxt, 
            (Type*)pvalue->u.type, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.primitive = rtxMemAllocType (pctxt, Primitive);

         if (pvalue->u.primitive == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Primitive (pvalue->u.primitive);
         stat = asn1D_Primitive (pctxt, 
            pvalue->u.primitive, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.point = rtxMemAllocType (pctxt, Point);

         if (pvalue->u.point == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Point (pvalue->u.point);
         stat = asn1D_Point (pctxt, 
            pvalue->u.point, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Type_element (OSCTXT* pctxt, Type_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("instance"), 8}, 0}, 0 },
      {{{OSUTF8("type"), 4}, 0}, 1 },
      {{{OSUTF8("primitive"), 9}, 0}, 2 },
      {{{OSUTF8("point"), 5}, 0}, 3 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 4, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* instance */
      pvalue->u.instance = rtxMemAllocType (pctxt, Instance);

      if (pvalue->u.instance == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Instance ((Instance*)pvalue->u.instance);

      stat = XmlDec_Instance (pctxt, pvalue->u.instance);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* type */
      pvalue->u.type = rtxMemAllocType (pctxt, Type);

      if (pvalue->u.type == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Type ((Type*)pvalue->u.type);

      stat = XmlDec_Type (pctxt, pvalue->u.type);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* primitive */
      pvalue->u.primitive = rtxMemAllocType (pctxt, Primitive);

      if (pvalue->u.primitive == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Primitive (pvalue->u.primitive);

      stat = XmlDec_Primitive (pctxt, pvalue->u.primitive);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* point */
      pvalue->u.point = rtxMemAllocType (pctxt, Point);

      if (pvalue->u.point == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Point (pvalue->u.point);

      stat = XmlDec_Point (pctxt, pvalue->u.point);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfType_element                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D__SeqOfType_element (OSCTXT* pctxt, 
   _SeqOfType_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   Type_element* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, Type_element, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Type_element (pdata1);

      stat = asn1D_Type_element (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec__SeqOfType_element (OSCTXT* pctxt, _SeqOfType_element* pvalue)
{
   int stat = 0;

   { int elemID;
   Type_element* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("instance"), 8}, 0}, 0 },
      {{{OSUTF8("type"), 4}, 0}, 0 },
      {{{OSUTF8("primitive"), 9}, 0}, 0 },
      {{{OSUTF8("point"), 5}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 4, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0:
         rtXmlpMarkLastEventActive (pctxt);

         pdata1 = rtxMemAllocType (pctxt, Type_element);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Type_element (pdata1);

         stat = XmlDec_Type_element (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Type                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Type (OSCTXT* pctxt, Type *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode version */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->version, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.versionPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfType_element (pctxt, 
               &pvalue->choice_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Type (OSCTXT* pctxt, Type* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("version"), 7}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* name */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* version */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->version);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.versionPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Type");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Type");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("instance"), 8}, 0}, 0 },
      {{{OSUTF8("type"), 4}, 0}, 0 },
      {{{OSUTF8("primitive"), 9}, 0}, 0 },
      {{{OSUTF8("point"), 5}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}, {4, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Type_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Type_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Type_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_Type_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->choice_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 4, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Instance_element                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Instance_element (OSCTXT* pctxt, Instance_element *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.type = rtxMemAllocType (pctxt, Type);

         if (pvalue->u.type == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Type (pvalue->u.type);
         stat = asn1D_Type (pctxt, 
            pvalue->u.type, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.primitive = rtxMemAllocType (pctxt, Primitive);

         if (pvalue->u.primitive == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Primitive (pvalue->u.primitive);
         stat = asn1D_Primitive (pctxt, 
            pvalue->u.primitive, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.point = rtxMemAllocType (pctxt, Point);

         if (pvalue->u.point == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Point (pvalue->u.point);
         stat = asn1D_Point (pctxt, 
            pvalue->u.point, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Instance_element (OSCTXT* pctxt, Instance_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("type"), 4}, 0}, 0 },
      {{{OSUTF8("primitive"), 9}, 0}, 1 },
      {{{OSUTF8("point"), 5}, 0}, 2 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 3, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* type */
      pvalue->u.type = rtxMemAllocType (pctxt, Type);

      if (pvalue->u.type == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Type (pvalue->u.type);

      stat = XmlDec_Type (pctxt, pvalue->u.type);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* primitive */
      pvalue->u.primitive = rtxMemAllocType (pctxt, Primitive);

      if (pvalue->u.primitive == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Primitive (pvalue->u.primitive);

      stat = XmlDec_Primitive (pctxt, pvalue->u.primitive);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* point */
      pvalue->u.point = rtxMemAllocType (pctxt, Point);

      if (pvalue->u.point == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Point (pvalue->u.point);

      stat = XmlDec_Point (pctxt, pvalue->u.point);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfInstance_element                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D__SeqOfInstance_element (OSCTXT* pctxt, 
   _SeqOfInstance_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   Instance_element* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, Instance_element, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Instance_element (pdata1);

      stat = asn1D_Instance_element (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec__SeqOfInstance_element (OSCTXT* pctxt, 
   _SeqOfInstance_element* pvalue)
{
   int stat = 0;

   { int elemID;
   Instance_element* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("type"), 4}, 0}, 0 },
      {{{OSUTF8("primitive"), 9}, 0}, 0 },
      {{{OSUTF8("point"), 5}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 3, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0:
         rtXmlpMarkLastEventActive (pctxt);

         pdata1 = rtxMemAllocType (pctxt, Instance_element);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Instance_element (pdata1);

         stat = XmlDec_Instance_element (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Instance                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Instance (OSCTXT* pctxt, Instance *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfInstance_element (pctxt, 
               &pvalue->choice_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Instance (OSCTXT* pctxt, Instance* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("type"), 4}, 0}, 0 },
      {{{OSUTF8("primitive"), 9}, 0}, 0 },
      {{{OSUTF8("point"), 5}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}, {3, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Instance_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Instance_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Instance_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_Instance_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->choice_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 3, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Attribute_derivations_type_element                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Attribute_derivations_type_element (OSCTXT* pctxt, 
   Attribute_derivations_type_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.instance = rtxMemAllocType (pctxt, Instance);

         if (pvalue->u.instance == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Instance (pvalue->u.instance);
         stat = asn1D_Instance (pctxt, 
            pvalue->u.instance, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.type = rtxMemAllocType (pctxt, Type);

         if (pvalue->u.type == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Type (pvalue->u.type);
         stat = asn1D_Type (pctxt, 
            pvalue->u.type, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.primitive = rtxMemAllocType (pctxt, Primitive);

         if (pvalue->u.primitive == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Primitive (pvalue->u.primitive);
         stat = asn1D_Primitive (pctxt, 
            pvalue->u.primitive, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.point = rtxMemAllocType (pctxt, Point);

         if (pvalue->u.point == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Point (pvalue->u.point);
         stat = asn1D_Point (pctxt, 
            pvalue->u.point, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Attribute_derivations_type_element (OSCTXT* pctxt, 
   Attribute_derivations_type_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("instance"), 8}, 0}, 0 },
      {{{OSUTF8("type"), 4}, 0}, 1 },
      {{{OSUTF8("primitive"), 9}, 0}, 2 },
      {{{OSUTF8("point"), 5}, 0}, 3 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 4, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* instance */
      pvalue->u.instance = rtxMemAllocType (pctxt, Instance);

      if (pvalue->u.instance == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Instance (pvalue->u.instance);

      stat = XmlDec_Instance (pctxt, pvalue->u.instance);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* type */
      pvalue->u.type = rtxMemAllocType (pctxt, Type);

      if (pvalue->u.type == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Type (pvalue->u.type);

      stat = XmlDec_Type (pctxt, pvalue->u.type);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* primitive */
      pvalue->u.primitive = rtxMemAllocType (pctxt, Primitive);

      if (pvalue->u.primitive == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Primitive (pvalue->u.primitive);

      stat = XmlDec_Primitive (pctxt, pvalue->u.primitive);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* point */
      pvalue->u.point = rtxMemAllocType (pctxt, Point);

      if (pvalue->u.point == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Point (pvalue->u.point);

      stat = XmlDec_Point (pctxt, pvalue->u.point);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfAttribute_derivations_type_element                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D__SeqOfAttribute_derivations_type_element (OSCTXT* pctxt, 
   _SeqOfAttribute_derivations_type_element *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   Attribute_derivations_type_element* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, Attribute_derivations_type_element, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Attribute_derivations_type_element (pdata1);

      stat = asn1D_Attribute_derivations_type_element (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec__SeqOfAttribute_derivations_type_element (OSCTXT* pctxt, 
   _SeqOfAttribute_derivations_type_element* pvalue)
{
   int stat = 0;

   { int elemID;
   Attribute_derivations_type_element* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("instance"), 8}, 0}, 0 },
      {{{OSUTF8("type"), 4}, 0}, 0 },
      {{{OSUTF8("primitive"), 9}, 0}, 0 },
      {{{OSUTF8("point"), 5}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 4, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0:
         rtXmlpMarkLastEventActive (pctxt);

         pdata1 = rtxMemAllocType (pctxt, Attribute_derivations_type_element);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Attribute_derivations_type_element (pdata1);

         stat = XmlDec_Attribute_derivations_type_element (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Attribute_derivations_type                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Attribute_derivations_type (OSCTXT* pctxt, 
   Attribute_derivations_type *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode version */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->version, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.versionPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfAttribute_derivations_type_element (pctxt, 
               &pvalue->choice_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Attribute_derivations_type (OSCTXT* pctxt, 
   Attribute_derivations_type* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("version"), 7}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 2, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* name */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* version */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->version);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.versionPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Attribute_derivations_type");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Attribute_derivations_type");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("instance"), 8}, 0}, 0 },
      {{{OSUTF8("type"), 4}, 0}, 0 },
      {{{OSUTF8("primitive"), 9}, 0}, 0 },
      {{{OSUTF8("point"), 5}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}, {4, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Attribute_derivations_type_element* pdata1;
         do {
            pdata1
                = rtxMemAllocType (pctxt, Attribute_derivations_type_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Attribute_derivations_type_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_Attribute_derivations_type_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->choice_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 4, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Attribute_derivations_instance_element                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Attribute_derivations_instance_element (OSCTXT* pctxt, 
   Attribute_derivations_instance_element *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.type = rtxMemAllocType (pctxt, Type);

         if (pvalue->u.type == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Type (pvalue->u.type);
         stat = asn1D_Type (pctxt, 
            pvalue->u.type, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.primitive = rtxMemAllocType (pctxt, Primitive);

         if (pvalue->u.primitive == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Primitive (pvalue->u.primitive);
         stat = asn1D_Primitive (pctxt, 
            pvalue->u.primitive, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.point = rtxMemAllocType (pctxt, Point);

         if (pvalue->u.point == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Point (pvalue->u.point);
         stat = asn1D_Point (pctxt, 
            pvalue->u.point, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Attribute_derivations_instance_element (OSCTXT* pctxt, 
   Attribute_derivations_instance_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("type"), 4}, 0}, 0 },
      {{{OSUTF8("primitive"), 9}, 0}, 1 },
      {{{OSUTF8("point"), 5}, 0}, 2 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 3, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* type */
      pvalue->u.type = rtxMemAllocType (pctxt, Type);

      if (pvalue->u.type == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Type (pvalue->u.type);

      stat = XmlDec_Type (pctxt, pvalue->u.type);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* primitive */
      pvalue->u.primitive = rtxMemAllocType (pctxt, Primitive);

      if (pvalue->u.primitive == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Primitive (pvalue->u.primitive);

      stat = XmlDec_Primitive (pctxt, pvalue->u.primitive);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* point */
      pvalue->u.point = rtxMemAllocType (pctxt, Point);

      if (pvalue->u.point == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Point (pvalue->u.point);

      stat = XmlDec_Point (pctxt, pvalue->u.point);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfAttribute_derivations_instance_element              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D__SeqOfAttribute_derivations_instance_element (OSCTXT* pctxt, 
   _SeqOfAttribute_derivations_instance_element *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   Attribute_derivations_instance_element* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, Attribute_derivations_instance_element, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Attribute_derivations_instance_element (pdata1);

      stat = asn1D_Attribute_derivations_instance_element (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec__SeqOfAttribute_derivations_instance_element (OSCTXT* pctxt, 
   _SeqOfAttribute_derivations_instance_element* pvalue)
{
   int stat = 0;

   { int elemID;
   Attribute_derivations_instance_element* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("type"), 4}, 0}, 0 },
      {{{OSUTF8("primitive"), 9}, 0}, 0 },
      {{{OSUTF8("point"), 5}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 3, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0:
         rtXmlpMarkLastEventActive (pctxt);

         pdata1
             = rtxMemAllocType (pctxt, Attribute_derivations_instance_element);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Attribute_derivations_instance_element (pdata1);

         stat = XmlDec_Attribute_derivations_instance_element (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Attribute_derivations_instance                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Attribute_derivations_instance (OSCTXT* pctxt, 
   Attribute_derivations_instance *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfAttribute_derivations_instance_element (pctxt, 
               &pvalue->choice_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Attribute_derivations_instance (OSCTXT* pctxt, 
   Attribute_derivations_instance* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("type"), 4}, 0}, 0 },
      {{{OSUTF8("primitive"), 9}, 0}, 0 },
      {{{OSUTF8("point"), 5}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}, {3, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Attribute_derivations_instance_element* pdata1;
         do {
            pdata1
                = rtxMemAllocType (pctxt, Attribute_derivations_instance_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Attribute_derivations_instance_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_Attribute_derivations_instance_element (pctxt, pdata1
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->choice_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 3, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Attribute_derivations_primitive                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Attribute_derivations_primitive (OSCTXT* pctxt, 
   Attribute_derivations_primitive *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode point_list */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Point* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->point_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Point, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Point (pdata2);

                  stat = asn1D_Point (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->point_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Attribute_derivations_primitive (OSCTXT* pctxt, 
   Attribute_derivations_primitive* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("point"), 5}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Point* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Point);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Point (pdata1);

            stat = XmlDec_Point (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->point_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Attribute_derivations_point                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Attribute_derivations_point (OSCTXT* pctxt, 
   Attribute_derivations_point *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode x */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->x, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode y */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->y, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode z */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->z, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Attribute_derivations_point (OSCTXT* pctxt, 
   Attribute_derivations_point* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("x"), 1}, 0 },
         { {OSUTF8("y"), 1}, 0 },
         { {OSUTF8("z"), 1}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* x */
            stat = rtXmlpDecDouble (pctxt, &pvalue->x, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* y */
            stat = rtXmlpDecDouble (pctxt, &pvalue->y, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 2: /* z */
            stat = rtXmlpDecDouble (pctxt, &pvalue->z, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Attribute_derivations_point");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Attribute_derivations_point");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Attribute_derivations_heprep                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Attribute_derivations_heprep (OSCTXT* pctxt, 
   Attribute_derivations_heprep *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode type_list */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Type* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->type_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Type, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Type (pdata2);

                  stat = asn1D_Type (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->type_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Attribute_derivations_heprep (OSCTXT* pctxt, 
   Attribute_derivations_heprep* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("type"), 4}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Type* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Type);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Type (pdata1);

            stat = XmlDec_Type (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->type_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Attribute_derivations                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Attribute_derivations (OSCTXT* pctxt, 
   Attribute_derivations *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.type = rtxMemAllocType (pctxt, Attribute_derivations_type);

         if (pvalue->u.type == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Attribute_derivations_type (pvalue->u.type);
         stat = asn1D_Attribute_derivations_type (pctxt, 
            pvalue->u.type, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.instance
             = rtxMemAllocType (pctxt, Attribute_derivations_instance);

         if (pvalue->u.instance == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Attribute_derivations_instance (pvalue->u.instance);
         stat = asn1D_Attribute_derivations_instance (pctxt, 
            pvalue->u.instance, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.primitive
             = rtxMemAllocType (pctxt, Attribute_derivations_primitive);

         if (pvalue->u.primitive == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Attribute_derivations_primitive (pvalue->u.primitive);
         stat = asn1D_Attribute_derivations_primitive (pctxt, 
            pvalue->u.primitive, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.point
             = rtxMemAllocType (pctxt, Attribute_derivations_point);

         if (pvalue->u.point == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Attribute_derivations_point (pvalue->u.point);
         stat = asn1D_Attribute_derivations_point (pctxt, 
            pvalue->u.point, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_CONS|4):
         pvalue->u.heprep
             = rtxMemAllocType (pctxt, Attribute_derivations_heprep);

         if (pvalue->u.heprep == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Attribute_derivations_heprep (pvalue->u.heprep);
         stat = asn1D_Attribute_derivations_heprep (pctxt, 
            pvalue->u.heprep, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Attribute_derivations (OSCTXT* pctxt, Attribute_derivations* pvalue)
{
   const OSUTF8CHAR* xsiType = 0;
   int stat = 0;

   /* decode xsi:type attribute */
   if (rtXmlpHasAttributes (pctxt)) {
      OSUINT32 i, nAttrs = 0;
      OSXMLNameFragments attrName;

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) == 0 &&
             rtXmlpDecXSITypeAttr (pctxt, &attrName, &xsiType) == 0) break;
      }
   }

   /* decode content */
   if (!OS_ISEMPTY (xsiType)) {
      xsiType = rtXmlDecQName (pctxt, xsiType, 0);
   }
   if (OS_ISEMPTY (xsiType)) {
      pvalue->t = 1;
      pvalue->u.type = rtxMemAllocType (pctxt, Attribute_derivations_type);

      if (pvalue->u.type == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Attribute_derivations_type (pvalue->u.type);

      stat = XmlDec_Attribute_derivations_type (pctxt, pvalue->u.type);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("_type")))
   {
      pvalue->t = 1;
      pvalue->u.type = rtxMemAllocType (pctxt, Attribute_derivations_type);

      if (pvalue->u.type == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Attribute_derivations_type (pvalue->u.type);

      stat = XmlDec_Attribute_derivations_type (pctxt, pvalue->u.type);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("_instance")))
   {
      pvalue->t = 2;
      pvalue->u.instance
          = rtxMemAllocType (pctxt, Attribute_derivations_instance);

      if (pvalue->u.instance == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Attribute_derivations_instance (pvalue->u.instance);

      stat = XmlDec_Attribute_derivations_instance (pctxt, pvalue->u.instance
         );
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("_primitive")))
   {
      pvalue->t = 3;
      pvalue->u.primitive
          = rtxMemAllocType (pctxt, Attribute_derivations_primitive);

      if (pvalue->u.primitive == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Attribute_derivations_primitive (pvalue->u.primitive);

      stat = XmlDec_Attribute_derivations_primitive (pctxt, pvalue->u.primitive
         );
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("_point")))
   {
      pvalue->t = 4;
      pvalue->u.point = rtxMemAllocType (pctxt, Attribute_derivations_point);

      if (pvalue->u.point == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Attribute_derivations_point (pvalue->u.point);

      stat = XmlDec_Attribute_derivations_point (pctxt, pvalue->u.point);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("_heprep")))
   {
      pvalue->t = 5;
      pvalue->u.heprep
          = rtxMemAllocType (pctxt, Attribute_derivations_heprep);

      if (pvalue->u.heprep == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Attribute_derivations_heprep (pvalue->u.heprep);

      stat = XmlDec_Attribute_derivations_heprep (pctxt, pvalue->u.heprep);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Attribute                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Attribute (OSCTXT* pctxt, Attribute *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_Attribute_derivations (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_Attribute (OSCTXT* pctxt, Attribute* pvalue)
{
   int stat = 0;

   stat = XmlDec_Attribute_derivations (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Heprep                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Heprep (OSCTXT* pctxt, Heprep *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode type_list */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Type* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->type_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, Type, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Type (pdata2);

                  stat = asn1D_Type (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->type_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Heprep (OSCTXT* pctxt, Heprep* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("type"), 4}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         Type* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, Type);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_Type (pdata1);

            stat = XmlDec_Type (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->type_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Attribute_1_element_attdef                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Attribute_1_element_attdef (OSCTXT* pctxt, 
   Attribute_1_element_attdef *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode desc */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->desc, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode extra */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->extra, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.extraPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode type */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->type, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Attribute_1_element_attdef (OSCTXT* pctxt, 
   Attribute_1_element_attdef* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("desc"), 4}, 0 },
         { {OSUTF8("extra"), 5}, 0 },
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("type"), 4}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* desc */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->desc);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descPresent = TRUE;
            break;

         case 1: /* extra */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->extra);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.extraPresent = TRUE;
            break;

         case 2: /* name */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 3: /* type */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Attribute_1_element_attdef");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Attribute_1_element_attdef");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Attribute_1_element_attvalue                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Attribute_1_element_attvalue (OSCTXT* pctxt, 
   Attribute_1_element_attvalue *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode showLabel */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->showLabel, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.showLabelPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Attribute_1_element_attvalue (OSCTXT* pctxt, 
   Attribute_1_element_attvalue* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("showLabel"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* name */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* showLabel */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->showLabel);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.showLabelPresent = TRUE;
            break;

         case 2: /* value */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "Attribute_1_element_attvalue");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "Attribute_1_element_attvalue");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Attribute_1_element                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Attribute_1_element (OSCTXT* pctxt, 
   Attribute_1_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.attdef
             = rtxMemAllocType (pctxt, Attribute_1_element_attdef);

         if (pvalue->u.attdef == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Attribute_1_element_attdef (pvalue->u.attdef);
         stat = asn1D_Attribute_1_element_attdef (pctxt, 
            pvalue->u.attdef, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.attvalue
             = rtxMemAllocType (pctxt, Attribute_1_element_attvalue);

         if (pvalue->u.attvalue == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Attribute_1_element_attvalue (pvalue->u.attvalue);
         stat = asn1D_Attribute_1_element_attvalue (pctxt, 
            pvalue->u.attvalue, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_Attribute_1_element (OSCTXT* pctxt, Attribute_1_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("attdef"), 6}, 0}, 0 },
      {{{OSUTF8("attvalue"), 8}, 0}, 1 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* attdef */
      pvalue->u.attdef = rtxMemAllocType (pctxt, Attribute_1_element_attdef);

      if (pvalue->u.attdef == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Attribute_1_element_attdef (pvalue->u.attdef);

      stat = XmlDec_Attribute_1_element_attdef (pctxt, pvalue->u.attdef);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* attvalue */
      pvalue->u.attvalue
          = rtxMemAllocType (pctxt, Attribute_1_element_attvalue);

      if (pvalue->u.attvalue == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Attribute_1_element_attvalue (pvalue->u.attvalue);

      stat = XmlDec_Attribute_1_element_attvalue (pctxt, pvalue->u.attvalue);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Attribute_1                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Attribute_1 (OSCTXT* pctxt, Attribute_1 *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   Attribute_1_element* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, Attribute_1_element, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Attribute_1_element (pdata1);

      stat = asn1D_Attribute_1_element (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   return (stat);
}

int XmlDec_Attribute_1 (OSCTXT* pctxt, Attribute_1* pvalue)
{
   int stat = 0;

   { int elemID;
   Attribute_1_element* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("attdef"), 6}, 0}, 0 },
      {{{OSUTF8("attvalue"), 8}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0:
         rtXmlpMarkLastEventActive (pctxt);

         pdata1 = rtxMemAllocType (pctxt, Attribute_1_element);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Attribute_1_element (pdata1);

         stat = XmlDec_Attribute_1_element (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

int XmlDec_Attribute_PDU (OSCTXT* pctxt, Attribute* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_Attribute (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("attribute"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_Attribute (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlDec_Heprep_PDU (OSCTXT* pctxt, Heprep* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_Heprep (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("heprep"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_Heprep (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlDec_Attribute_1_PDU (OSCTXT* pctxt, Attribute_1* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_Attribute_1 (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("attribute-1"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_Attribute_1 (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
