/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "Gaml100.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  Collectdate                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Collectdate (OSCTXT* pctxt,
   Collectdate pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_charstr (pctxt, pvalue, tagging, TM_UNIV|TM_PRIM|26);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Collectdate (OSCTXT* pctxt, Collectdate value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt, (const OSUTF8CHAR*)value
      , elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Group                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Group (OSCTXT* pctxt,
   Group pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_utf8str (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Group (OSCTXT* pctxt, Group value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Name                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Gaml100_Name (OSCTXT* pctxt,
   Gaml100_Name pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_utf8str (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Gaml100_Name (OSCTXT* pctxt, Gaml100_Name value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Label                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Label (OSCTXT* pctxt,
   Label pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_utf8str (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Label (OSCTXT* pctxt, Label value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Linkref                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Linkref (OSCTXT* pctxt,
   Linkref pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_utf8str (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Linkref (OSCTXT* pctxt, Linkref value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Units                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Units (OSCTXT* pctxt,
   Units *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 62)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Units (OSCTXT* pctxt, Units value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Units_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Linkid                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Linkid (OSCTXT* pctxt,
   Linkid pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_utf8str (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Linkid (OSCTXT* pctxt, Linkid value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Valueorder                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Valueorder (OSCTXT* pctxt,
   Valueorder *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Valueorder (OSCTXT* pctxt, Valueorder value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Valueorder_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Technique                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Technique (OSCTXT* pctxt,
   Technique *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 14)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Technique (OSCTXT* pctxt, Technique value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Technique_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GAML_integrity_algorithm                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_GAML_integrity_algorithm (OSCTXT* pctxt,
   GAML_integrity_algorithm *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_GAML_integrity_algorithm (OSCTXT* pctxt, 
   GAML_integrity_algorithm value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      GAML_integrity_algorithm_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Values_byteorder                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Values_byteorder (OSCTXT* pctxt,
   Values_byteorder *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Values_byteorder (OSCTXT* pctxt, Values_byteorder value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Values_byteorder_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Values_format                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Values_format (OSCTXT* pctxt,
   Values_format *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_Values_format (OSCTXT* pctxt, Values_format value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      Values_format_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GAML_integrity                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_GAML_integrity (OSCTXT* pctxt,
   GAML_integrity *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      xe_octstr (pctxt, pvalue->base.data, pvalue->base.numocts, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode algorithm */

   if(pvalue->algorithm < 0 || pvalue->algorithm > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_GAML_integrity_algorithm (pctxt, &pvalue->algorithm, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_GAML_integrity (OSCTXT* pctxt, GAML_integrity* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" algorithm=\""), 12);

   if(pvalue->algorithm < 0 || pvalue->algorithm > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_GAML_integrity_algorithm (pctxt, pvalue->algorithm, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   /* encode base */

   stat = rtXmlEncHexBinary
      (pctxt, pvalue->base.numocts, pvalue->base.data, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Parameter                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Parameter (OSCTXT* pctxt,
   Parameter *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_utf8str (pctxt, pvalue->base, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode name */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_Gaml100_Name (pctxt, pvalue->name, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode label */

   if (pvalue->m.labelPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Label (pctxt, pvalue->label, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode group */

   if (pvalue->m.groupPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Group (pctxt, pvalue->group, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Parameter (OSCTXT* pctxt, Parameter* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.groupPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" group=\""), 8);

      stat = XmlEnc_Group (pctxt, pvalue->group, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.labelPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" label=\""), 8);

      stat = XmlEnc_Label (pctxt, pvalue->label, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" name=\""), 7);

   stat = XmlEnc_Gaml100_Name (pctxt, pvalue->name, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   /* encode base */

   stat = rtXmlEncUTF8Str (pctxt, pvalue->base, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Link                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Link (OSCTXT* pctxt,
   Link *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode linkref */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_Linkref (pctxt, pvalue->linkref, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Link (OSCTXT* pctxt, Link* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" linkref=\""), 10);

   stat = XmlEnc_Linkref (pctxt, pvalue->linkref, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Values                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Values (OSCTXT* pctxt,
   Values *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode base */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_octstr (pctxt, pvalue->base.data, pvalue->base.numocts, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode numvalues */

   if (pvalue->m.numvaluesPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_unsigned (pctxt, &pvalue->numvalues, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode format */

   if(pvalue->format < 0 || pvalue->format > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      asn1E_Values_format (pctxt, &pvalue->format, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode byteorder */

   if(pvalue->byteorder < 0 || pvalue->byteorder > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_Values_byteorder (pctxt, &pvalue->byteorder, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Values (OSCTXT* pctxt, Values* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" byteorder=\""), 12);

   if(pvalue->byteorder < 0 || pvalue->byteorder > 0)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_Values_byteorder (pctxt, pvalue->byteorder, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" format=\""), 9);

   if(pvalue->format < 0 || pvalue->format > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_Values_format (pctxt, pvalue->format, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.numvaluesPresent) {
      stat = rtXmlEncUIntAttr
         (pctxt, pvalue->numvalues, OSUTF8("numvalues"), 9);
   }

   /* encode base */

   stat = rtXmlEncBase64Binary
      (pctxt, pvalue->base.numocts, pvalue->base.data, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Coordinates                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Coordinates (OSCTXT* pctxt,
   Coordinates *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode values */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
      asn1E_Values (pctxt, &pvalue->values, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode parameter_list */

   pnode2 = pvalue->parameter_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Parameter (pctxt, ((Parameter*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode link_list */

   pnode2 = pvalue->link_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Link (pctxt, ((Link*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode valueorder */

   if (pvalue->m.valueorderPresent) {
      if(pvalue->valueorder < 0 || pvalue->valueorder > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_Valueorder (pctxt, &pvalue->valueorder, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode units */

   if(pvalue->units < 0 || pvalue->units > 62)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_Units (pctxt, &pvalue->units, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode linkid */

   if (pvalue->m.linkidPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Linkid (pctxt, pvalue->linkid, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode label */

   if (pvalue->m.labelPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Label (pctxt, pvalue->label, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Coordinates (OSCTXT* pctxt, Coordinates* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.labelPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" label=\""), 8);

      stat = XmlEnc_Label (pctxt, pvalue->label, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.linkidPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" linkid=\""), 9);

      stat = XmlEnc_Linkid (pctxt, pvalue->linkid, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" units=\""), 8);

   if(pvalue->units < 0 || pvalue->units > 62)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_Units (pctxt, pvalue->units, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.valueorderPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" valueorder=\""), 13);

      if(pvalue->valueorder < 0 || pvalue->valueorder > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Valueorder (pctxt, pvalue->valueorder, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode link_list */

   { OSRTDListNode* pnode = pvalue->link_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Link (pctxt, ((Link*)pnode->data)
         , OSUTF8("link"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode parameter_list */

   { OSRTDListNode* pnode = pvalue->parameter_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Parameter (pctxt, ((Parameter*)pnode->data)
         , OSUTF8("parameter"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode values */

   stat = XmlEnc_Values (pctxt, &pvalue->values, OSUTF8("values"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AltXdata                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AltXdata (OSCTXT* pctxt,
   AltXdata *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode values */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
      asn1E_Values (pctxt, &pvalue->values, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode parameter_list */

   pnode2 = pvalue->parameter_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Parameter (pctxt, ((Parameter*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode link_list */

   pnode2 = pvalue->link_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Link (pctxt, ((Link*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode valueorder */

   if (pvalue->m.valueorderPresent) {
      if(pvalue->valueorder < 0 || pvalue->valueorder > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_Valueorder (pctxt, &pvalue->valueorder, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode units */

   if(pvalue->units < 0 || pvalue->units > 62)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_Units (pctxt, &pvalue->units, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode linkid */

   if (pvalue->m.linkidPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Linkid (pctxt, pvalue->linkid, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode label */

   if (pvalue->m.labelPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Label (pctxt, pvalue->label, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AltXdata (OSCTXT* pctxt, AltXdata* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.labelPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" label=\""), 8);

      stat = XmlEnc_Label (pctxt, pvalue->label, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.linkidPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" linkid=\""), 9);

      stat = XmlEnc_Linkid (pctxt, pvalue->linkid, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" units=\""), 8);

   if(pvalue->units < 0 || pvalue->units > 62)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_Units (pctxt, pvalue->units, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.valueorderPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" valueorder=\""), 13);

      if(pvalue->valueorder < 0 || pvalue->valueorder > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Valueorder (pctxt, pvalue->valueorder, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode link_list */

   { OSRTDListNode* pnode = pvalue->link_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Link (pctxt, ((Link*)pnode->data)
         , OSUTF8("link"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode parameter_list */

   { OSRTDListNode* pnode = pvalue->parameter_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Parameter (pctxt, ((Parameter*)pnode->data)
         , OSUTF8("parameter"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode values */

   stat = XmlEnc_Values (pctxt, &pvalue->values, OSUTF8("values"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Peaktable_peak_baseline_basecurve_baseXdata               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Peaktable_peak_baseline_basecurve_baseXdata (OSCTXT* pctxt,
   Peaktable_peak_baseline_basecurve_baseXdata *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode values */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_Values (pctxt, &pvalue->values, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Peaktable_peak_baseline_basecurve_baseXdata (OSCTXT* pctxt, 
   Peaktable_peak_baseline_basecurve_baseXdata* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* encode values */

   stat = XmlEnc_Values (pctxt, &pvalue->values, OSUTF8("values"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Peaktable_peak_baseline_basecurve_baseYdata               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Peaktable_peak_baseline_basecurve_baseYdata (OSCTXT* pctxt,
   Peaktable_peak_baseline_basecurve_baseYdata *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode values */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_Values (pctxt, &pvalue->values, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Peaktable_peak_baseline_basecurve_baseYdata (OSCTXT* pctxt, 
   Peaktable_peak_baseline_basecurve_baseYdata* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* encode values */

   stat = XmlEnc_Values (pctxt, &pvalue->values, OSUTF8("values"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Peaktable_peak_baseline_basecurve                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Peaktable_peak_baseline_basecurve (OSCTXT* pctxt,
   Peaktable_peak_baseline_basecurve *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode baseYdata */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_Peaktable_peak_baseline_basecurve_baseYdata (pctxt, &pvalue->baseYdata, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode baseXdata */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
      asn1E_Peaktable_peak_baseline_basecurve_baseXdata (pctxt, &pvalue->baseXdata, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Peaktable_peak_baseline_basecurve (OSCTXT* pctxt, 
   Peaktable_peak_baseline_basecurve* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* encode baseXdata */

   stat = XmlEnc_Peaktable_peak_baseline_basecurve_baseXdata (pctxt, &pvalue->
      baseXdata, OSUTF8("baseXdata"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode baseYdata */

   stat = XmlEnc_Peaktable_peak_baseline_basecurve_baseYdata (pctxt, &pvalue->
      baseYdata, OSUTF8("baseYdata"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Peaktable_peak_baseline                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Peaktable_peak_baseline (OSCTXT* pctxt,
   Peaktable_peak_baseline *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode basecurve */

   if (pvalue->m.basecurvePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_Peaktable_peak_baseline_basecurve (pctxt, &pvalue->basecurve, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode endYvalue */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_real (pctxt, &pvalue->endYvalue, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode endXvalue */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_real (pctxt, &pvalue->endXvalue, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode startYvalue */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_real (pctxt, &pvalue->startYvalue, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode startXvalue */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      xe_real (pctxt, &pvalue->startXvalue, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode parameter_list */

   pnode2 = pvalue->parameter_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Parameter (pctxt, ((Parameter*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Peaktable_peak_baseline (OSCTXT* pctxt, 
   Peaktable_peak_baseline* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* encode parameter_list */

   { OSRTDListNode* pnode = pvalue->parameter_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Parameter (pctxt, ((Parameter*)pnode->data)
         , OSUTF8("parameter"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode startXvalue */

   stat = rtXmlEncDouble (pctxt, pvalue->startXvalue
      , OSUTF8("startXvalue"), nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode startYvalue */

   stat = rtXmlEncDouble (pctxt, pvalue->startYvalue
      , OSUTF8("startYvalue"), nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode endXvalue */

   stat = rtXmlEncDouble (pctxt, pvalue->endXvalue
      , OSUTF8("endXvalue"), nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode endYvalue */

   stat = rtXmlEncDouble (pctxt, pvalue->endYvalue
      , OSUTF8("endYvalue"), nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode basecurve */

   if (pvalue->m.basecurvePresent) {
      stat = XmlEnc_Peaktable_peak_baseline_basecurve (pctxt, &pvalue->
         basecurve, OSUTF8("basecurve"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Peaktable_peak                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Peaktable_peak (OSCTXT* pctxt,
   Peaktable_peak *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode baseline */

   if (pvalue->m.baselinePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_Peaktable_peak_baseline (pctxt, &pvalue->baseline, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode peakYvalue */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
      xe_real (pctxt, &pvalue->peakYvalue, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode peakXvalue */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_real (pctxt, &pvalue->peakXvalue, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode parameter_list */

   pnode2 = pvalue->parameter_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Parameter (pctxt, ((Parameter*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode number */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_unsigned (pctxt, &pvalue->number, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode name */

   if (pvalue->m.namePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Gaml100_Name (pctxt, pvalue->name, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode group */

   if (pvalue->m.groupPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Group (pctxt, pvalue->group, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Peaktable_peak (OSCTXT* pctxt, Peaktable_peak* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.groupPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" group=\""), 8);

      stat = XmlEnc_Group (pctxt, pvalue->group, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.namePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" name=\""), 7);

      stat = XmlEnc_Gaml100_Name (pctxt, pvalue->name, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   stat = rtXmlEncUIntAttr
      (pctxt, pvalue->number, OSUTF8("number"), 6);

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode parameter_list */

   { OSRTDListNode* pnode = pvalue->parameter_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Parameter (pctxt, ((Parameter*)pnode->data)
         , OSUTF8("parameter"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode peakXvalue */

   stat = rtXmlEncDouble (pctxt, pvalue->peakXvalue
      , OSUTF8("peakXvalue"), nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode peakYvalue */

   stat = rtXmlEncDouble (pctxt, pvalue->peakYvalue
      , OSUTF8("peakYvalue"), nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode baseline */

   if (pvalue->m.baselinePresent) {
      stat = XmlEnc_Peaktable_peak_baseline (pctxt, &pvalue->baseline
         , OSUTF8("baseline"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Peaktable                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Peaktable (OSCTXT* pctxt,
   Peaktable *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode peak_list */

   if (!(pvalue->peak_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "Peaktable.peak_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->peak_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->peak_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Peaktable_peak (pctxt, ((Peaktable_peak*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode parameter_list */

   pnode2 = pvalue->parameter_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Parameter (pctxt, ((Parameter*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode name */

   if (pvalue->m.namePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Gaml100_Name (pctxt, pvalue->name, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Peaktable (OSCTXT* pctxt, Peaktable* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.namePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" name=\""), 7);

      stat = XmlEnc_Gaml100_Name (pctxt, pvalue->name, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode parameter_list */

   { OSRTDListNode* pnode = pvalue->parameter_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Parameter (pctxt, ((Parameter*)pnode->data)
         , OSUTF8("parameter"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode peak_list */

   if (!(pvalue->peak_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "Peaktable.peak_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->peak_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->peak_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Peaktable_peak (pctxt, ((Peaktable_peak*)pnode->data)
         , OSUTF8("peak"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Ydata                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Ydata (OSCTXT* pctxt,
   Ydata *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode peaktable_list */

   pnode2 = pvalue->peaktable_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Peaktable (pctxt, ((Peaktable*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode values */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_Values (pctxt, &pvalue->values, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode parameter_list */

   pnode2 = pvalue->parameter_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Parameter (pctxt, ((Parameter*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode units */

   if(pvalue->units < 0 || pvalue->units > 62)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      asn1E_Units (pctxt, &pvalue->units, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode label */

   if (pvalue->m.labelPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Label (pctxt, pvalue->label, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Ydata (OSCTXT* pctxt, Ydata* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.labelPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" label=\""), 8);

      stat = XmlEnc_Label (pctxt, pvalue->label, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" units=\""), 8);

   if(pvalue->units < 0 || pvalue->units > 62)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_Units (pctxt, pvalue->units, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode parameter_list */

   { OSRTDListNode* pnode = pvalue->parameter_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Parameter (pctxt, ((Parameter*)pnode->data)
         , OSUTF8("parameter"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode values */

   stat = XmlEnc_Values (pctxt, &pvalue->values, OSUTF8("values"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode peaktable_list */

   { OSRTDListNode* pnode = pvalue->peaktable_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Peaktable (pctxt, ((Peaktable*)pnode->data)
         , OSUTF8("peaktable"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Xdata                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Xdata (OSCTXT* pctxt,
   Xdata *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode ydata_list */

   if (!(pvalue->ydata_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "Xdata.ydata_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->ydata_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->ydata_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Ydata (pctxt, ((Ydata*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode altXdata_list */

   pnode2 = pvalue->altXdata_list.tail;
   while (0 != pnode2) {
      ll = asn1E_AltXdata (pctxt, ((AltXdata*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode values */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
      asn1E_Values (pctxt, &pvalue->values, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode parameter_list */

   pnode2 = pvalue->parameter_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Parameter (pctxt, ((Parameter*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode link_list */

   pnode2 = pvalue->link_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Link (pctxt, ((Link*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode valueorder */

   if (pvalue->m.valueorderPresent) {
      if(pvalue->valueorder < 0 || pvalue->valueorder > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_Valueorder (pctxt, &pvalue->valueorder, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode units */

   if(pvalue->units < 0 || pvalue->units > 62)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_Units (pctxt, &pvalue->units, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode linkid */

   if (pvalue->m.linkidPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Linkid (pctxt, pvalue->linkid, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode label */

   if (pvalue->m.labelPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Label (pctxt, pvalue->label, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Xdata (OSCTXT* pctxt, Xdata* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.labelPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" label=\""), 8);

      stat = XmlEnc_Label (pctxt, pvalue->label, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.linkidPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" linkid=\""), 9);

      stat = XmlEnc_Linkid (pctxt, pvalue->linkid, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" units=\""), 8);

   if(pvalue->units < 0 || pvalue->units > 62)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_Units (pctxt, pvalue->units, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.valueorderPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" valueorder=\""), 13);

      if(pvalue->valueorder < 0 || pvalue->valueorder > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_Valueorder (pctxt, pvalue->valueorder, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode link_list */

   { OSRTDListNode* pnode = pvalue->link_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Link (pctxt, ((Link*)pnode->data)
         , OSUTF8("link"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode parameter_list */

   { OSRTDListNode* pnode = pvalue->parameter_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Parameter (pctxt, ((Parameter*)pnode->data)
         , OSUTF8("parameter"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode values */

   stat = XmlEnc_Values (pctxt, &pvalue->values, OSUTF8("values"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode altXdata_list */

   { OSRTDListNode* pnode = pvalue->altXdata_list.head;
   while (0 != pnode) {
      stat = XmlEnc_AltXdata (pctxt, ((AltXdata*)pnode->data)
         , OSUTF8("altXdata"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode ydata_list */

   if (!(pvalue->ydata_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "Xdata.ydata_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->ydata_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->ydata_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Ydata (pctxt, ((Ydata*)pnode->data)
         , OSUTF8("Ydata"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Trace                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Trace (OSCTXT* pctxt,
   Trace *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode xdata_list */

   pnode2 = pvalue->xdata_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Xdata (pctxt, ((Xdata*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode coordinates_list */

   pnode2 = pvalue->coordinates_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Coordinates (pctxt, ((Coordinates*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode parameter_list */

   pnode2 = pvalue->parameter_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Parameter (pctxt, ((Parameter*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode technique */

   if(pvalue->technique < 0 || pvalue->technique > 14)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      asn1E_Technique (pctxt, &pvalue->technique, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode name */

   if (pvalue->m.namePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Gaml100_Name (pctxt, pvalue->name, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Trace (OSCTXT* pctxt, Trace* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.namePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" name=\""), 7);

      stat = XmlEnc_Gaml100_Name (pctxt, pvalue->name, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" technique=\""), 12);

   if(pvalue->technique < 0 || pvalue->technique > 14)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_Technique (pctxt, pvalue->technique, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode parameter_list */

   { OSRTDListNode* pnode = pvalue->parameter_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Parameter (pctxt, ((Parameter*)pnode->data)
         , OSUTF8("parameter"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode coordinates_list */

   { OSRTDListNode* pnode = pvalue->coordinates_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Coordinates (pctxt, ((Coordinates*)pnode->data)
         , OSUTF8("coordinates"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode xdata_list */

   { OSRTDListNode* pnode = pvalue->xdata_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Xdata (pctxt, ((Xdata*)pnode->data)
         , OSUTF8("Xdata"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Experiment                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_Experiment (OSCTXT* pctxt,
   Experiment *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode trace_list */

   if (!(pvalue->trace_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "Experiment.trace_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->trace_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->trace_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Trace (pctxt, ((Trace*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode parameter_list */

   pnode2 = pvalue->parameter_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Parameter (pctxt, ((Parameter*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode collectdate */

   if (pvalue->m.collectdatePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_Collectdate (pctxt, pvalue->collectdate, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode name */

   if (pvalue->m.namePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Gaml100_Name (pctxt, pvalue->name, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_Experiment (OSCTXT* pctxt, Experiment* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.namePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" name=\""), 7);

      stat = XmlEnc_Gaml100_Name (pctxt, pvalue->name, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode collectdate */

   if (pvalue->m.collectdatePresent) {
      stat = XmlEnc_Collectdate (pctxt, pvalue->collectdate
         , OSUTF8("collectdate"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode parameter_list */

   { OSRTDListNode* pnode = pvalue->parameter_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Parameter (pctxt, ((Parameter*)pnode->data)
         , OSUTF8("parameter"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode trace_list */

   if (!(pvalue->trace_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "Experiment.trace_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->trace_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->trace_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Trace (pctxt, ((Trace*)pnode->data)
         , OSUTF8("trace"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GAML                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_GAML (OSCTXT* pctxt,
   GAML *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode experiment_list */

   if (!(pvalue->experiment_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "GAML.experiment_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->experiment_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->experiment_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Experiment (pctxt, ((Experiment*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode parameter_list */

   pnode2 = pvalue->parameter_list.tail;
   while (0 != pnode2) {
      ll = asn1E_Parameter (pctxt, ((Parameter*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode integrity */

   if (pvalue->m.integrityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
         asn1E_GAML_integrity (pctxt, &pvalue->integrity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode version */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      xe_utf8str (pctxt, pvalue->version, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode name */

   if (pvalue->m.namePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_Gaml100_Name (pctxt, pvalue->name, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_GAML (OSCTXT* pctxt, GAML* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.namePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" name=\""), 7);

      stat = XmlEnc_Gaml100_Name (pctxt, pvalue->name, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" version=\""), 10);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->version, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode integrity */

   if (pvalue->m.integrityPresent) {
      stat = XmlEnc_GAML_integrity (pctxt, &pvalue->integrity
         , OSUTF8("integrity"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode parameter_list */

   { OSRTDListNode* pnode = pvalue->parameter_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Parameter (pctxt, ((Parameter*)pnode->data)
         , OSUTF8("parameter"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode experiment_list */

   if (!(pvalue->experiment_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "GAML.experiment_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->experiment_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->experiment_list.head;
   while (0 != pnode) {
      stat = XmlEnc_Experiment (pctxt, ((Experiment*)pnode->data)
         , OSUTF8("experiment"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlEnc_GAML_PDU (OSCTXT* pctxt, GAML* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("GAML"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_GAML (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("GAML"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
