/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "Factbook.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  Factbook_record_geography_area                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_geography_area (OSCTXT* pctxt, 
   Factbook_record_geography_area *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode total */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->total, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode land */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->land, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode water */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->water, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode area_comparison */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->area_comparison, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 4) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_geography_area (OSCTXT* pctxt, 
   Factbook_record_geography_area* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("total"), 5}, 0}, 0 },
      {{{OSUTF8("land"), 4}, 0}, 1 },
      {{{OSUTF8("water"), 5}, 0}, 2 },
      {{{OSUTF8("area_comparison"), 15}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 0, -1}
      };

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* total */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->total);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* land */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->land);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* water */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->water);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* area_comparison */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->area_comparison);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_geography_maritime_claims                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_geography_maritime_claims (OSCTXT* pctxt, 
   Factbook_record_geography_maritime_claims *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode note */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->note, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode contiguous_zone */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->contiguous_zone, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode continental_shelf */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->continental_shelf, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode exclusive_economic_zone */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->exclusive_economic_zone, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode territorial_sea */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->territorial_sea, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 5) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_geography_maritime_claims (OSCTXT* pctxt, 
   Factbook_record_geography_maritime_claims* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("note"), 4}, 0}, 0 },
      {{{OSUTF8("contiguous_zone"), 15}, 0}, 1 },
      {{{OSUTF8("continental_shelf"), 17}, 0}, 2 },
      {{{OSUTF8("exclusive_economic_zone"), 23}, 0}, 3 },
      {{{OSUTF8("territorial_sea"), 15}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}
      , {5, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* note */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->note);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* contiguous_zone */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->contiguous_zone);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* continental_shelf */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->continental_shelf);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* exclusive_economic_zone */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->exclusive_economic_zone);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* territorial_sea */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->territorial_sea);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_geography_elevation_extremes              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_geography_elevation_extremes (OSCTXT* pctxt, 
   Factbook_record_geography_elevation_extremes *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode lowest_point */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->lowest_point, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode highest_point */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->highest_point, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_geography_elevation_extremes (OSCTXT* pctxt, 
   Factbook_record_geography_elevation_extremes* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("lowest_point"), 12}, 0}, 0 },
      {{{OSUTF8("highest_point"), 13}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* lowest_point */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->lowest_point);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* highest_point */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->highest_point);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_geography_land_use                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_geography_land_use (OSCTXT* pctxt, 
   Factbook_record_geography_land_use *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode arable_land_list */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->arable_land_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->arable_land_list, pnode);
               }

               if (!(pvalue->arable_land_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_geography_land_use.arable_land_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->arable_land_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode permanent_crops_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->permanent_crops_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->permanent_crops_list, pnode);
               }

               if (!(pvalue->permanent_crops_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_geography_land_use.permanent_crops_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->permanent_crops_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode permanent_pastures_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->permanent_pastures_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->permanent_pastures_list, pnode);
               }

               if (!(pvalue->permanent_pastures_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_geography_land_use.permanent_pastures_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->permanent_pastures_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode forests_and_woodlands_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->forests_and_woodlands_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->forests_and_woodlands_list, pnode);
               }

               if (!(pvalue->forests_and_woodlands_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_geography_land_use.forests_and_woodlands_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->forests_and_woodlands_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode other_land_uses_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->other_land_uses_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->other_land_uses_list, pnode);
               }

               if (!(pvalue->other_land_uses_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_geography_land_use.other_land_uses_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->other_land_uses_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 5) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_geography_land_use (OSCTXT* pctxt, 
   Factbook_record_geography_land_use* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("arable_land"), 11}, 0}, 0 },
      {{{OSUTF8("permanent_crops"), 15}, 0}, 1 },
      {{{OSUTF8("permanent_pastures"), 18}, 0}, 2 },
      {{{OSUTF8("forests_and_woodlands"), 21}, 0}, 3 },
      {{{OSUTF8("other_land_uses"), 15}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->arable_land_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->permanent_crops_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 2: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->permanent_pastures_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 2);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 3: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->forests_and_woodlands_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 4: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->other_land_uses_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 4, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 4);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_geography_international_environment_agre  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_geography_international_environment_agreements (
   OSCTXT* pctxt, 
   Factbook_record_geography_international_environment_agreements *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode party_to */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->party_to, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode signed_but_not_ratified */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->signed_but_not_ratified, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_geography_international_environment_agreements 
   (OSCTXT* pctxt, 
   Factbook_record_geography_international_environment_agreements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("party_to"), 8}, 0}, 0 },
      {{{OSUTF8("signed_but_not_ratified"), 23}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* party_to */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->party_to);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* signed_but_not_ratified */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->signed_but_not_ratified);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_geography                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_geography (OSCTXT* pctxt, 
   Factbook_record_geography *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode location */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->location, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode geographic_coordinates */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->geographic_coordinates, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode map_references */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->map_references, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode area */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_geography_area (pctxt, 
               &pvalue->area, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode land_boundaries */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->land_boundaries, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode border_countries */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->border_countries, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode coastline */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->coastline, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode maritime_claims */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_geography_maritime_claims (pctxt, 
               &pvalue->maritime_claims, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode climate */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->climate, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 9:
         /* decode terrain */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->terrain, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 10:
         /* decode elevation_extremes */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_geography_elevation_extremes (pctxt, 
               &pvalue->elevation_extremes, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 11:
         /* decode natural_resources_list */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->natural_resources_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->natural_resources_list, pnode);
               }

               if (!(pvalue->natural_resources_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_geography.natural_resources_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->natural_resources_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 12:
         /* decode land_use */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_geography_land_use (pctxt, 
               &pvalue->land_use, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 13:
         /* decode irrigated_land_list */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->irrigated_land_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->irrigated_land_list, pnode);
               }

               if (!(pvalue->irrigated_land_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_geography.irrigated_land_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->irrigated_land_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 14:
         /* decode natural_hazards */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->natural_hazards, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 15:
         /* decode current_environment_issues */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->current_environment_issues, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 16:
         /* decode international_environment_agreements */
         if (XD_PEEKTAG (pctxt, 0x90)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_geography_international_environment_agreements (pctxt, 
               &pvalue->international_environment_agreements, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 17:
         /* decode geography_note */
         if (XD_PEEKTAG (pctxt, 0x91)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->geography_note, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_PRIM|14):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_PRIM|15):
         case (TM_CTXT|TM_CONS|15):
         case (TM_CTXT|TM_CONS|16):
         case (TM_CTXT|TM_PRIM|17):
         case (TM_CTXT|TM_CONS|17):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 18) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_geography (OSCTXT* pctxt, 
   Factbook_record_geography* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("location"), 8}, 0}, 0 },
      {{{OSUTF8("geographic_coordinates"), 22}, 0}, 1 },
      {{{OSUTF8("map_references"), 14}, 0}, 2 },
      {{{OSUTF8("area"), 4}, 0}, 3 },
      {{{OSUTF8("land_boundaries"), 15}, 0}, 4 },
      {{{OSUTF8("border_countries"), 16}, 0}, 5 },
      {{{OSUTF8("coastline"), 9}, 0}, 6 },
      {{{OSUTF8("maritime_claims"), 15}, 0}, 7 },
      {{{OSUTF8("climate"), 7}, 0}, 8 },
      {{{OSUTF8("terrain"), 7}, 0}, 9 },
      {{{OSUTF8("elevation_extremes"), 18}, 0}, 10 },
      {{{OSUTF8("natural_resources"), 17}, 0}, 11 },
      {{{OSUTF8("land_use"), 8}, 0}, 12 },
      {{{OSUTF8("irrigated_land"), 14}, 0}, 13 },
      {{{OSUTF8("natural_hazards"), 15}, 0}, 14 },
      {{{OSUTF8("current_environment_issues"), 26}, 0}, 15 },
      {{{OSUTF8("international_environment_agreements"), 36}, 0}, 16 },
      {{{OSUTF8("geography_note"), 14}, 0}, 17 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}
      , {5, 1, -1}, {6, 1, -1}, {7, 1, -1}, {8, 1, -1}, {9, 1, -1}, {10, 1, -1}
      , {11, 2, -1}, {13, 2, -1}, {15, 1, -1}, {16, 1, -1}, {17, 1, -1}
      , {18, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 18; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* location */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->location);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* geographic_coordinates */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->geographic_coordinates);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* map_references */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->map_references);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* area */
         stat = XmlDec_Factbook_record_geography_area (pctxt, &pvalue->area);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* land_boundaries */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->land_boundaries);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 5: { /* border_countries */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->border_countries);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 6: { /* coastline */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->coastline);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 7: { /* maritime_claims */
         stat = XmlDec_Factbook_record_geography_maritime_claims (pctxt, &
            pvalue->maritime_claims);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 8: { /* climate */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->climate);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 9: { /* terrain */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->terrain);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 10: { /* elevation_extremes */
         stat = XmlDec_Factbook_record_geography_elevation_extremes (pctxt, &
            pvalue->elevation_extremes);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 11: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->natural_resources_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 11, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 11);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 12: { /* land_use */
         stat = XmlDec_Factbook_record_geography_land_use (pctxt, &pvalue->
            land_use);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 13: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->irrigated_land_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 13, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 13);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 14: { /* natural_hazards */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->natural_hazards);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 15: { /* current_environment_issues */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->current_environment_issues
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 16: { /* international_environment_agreements */
         stat = XmlDec_Factbook_record_geography_international_environment_agreements 
            (pctxt, &pvalue->international_environment_agreements);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 17: { /* geography_note */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->geography_note);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_people_age_structure_element              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_people_age_structure_element (OSCTXT* pctxt, 
   Factbook_record_people_age_structure_element *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode years_0_to_14 */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->years_0_to_14, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode years_15_to_64 */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->years_15_to_64, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode years_65_and_over */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->years_65_and_over, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_people_age_structure_element (OSCTXT* pctxt, 
   Factbook_record_people_age_structure_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("years-0_to_14"), 13}, 0}, 0 },
      {{{OSUTF8("years-15_to_64"), 14}, 0}, 1 },
      {{{OSUTF8("years-65_and_over"), 17}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* years-0_to_14 */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->years_0_to_14);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* years-15_to_64 */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->years_15_to_64);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* years-65_and_over */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->years_65_and_over);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_people_sex_ratio_element                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_people_sex_ratio_element (OSCTXT* pctxt, 
   Factbook_record_people_sex_ratio_element *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode at_birth */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->at_birth, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode under_15_years */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->under_15_years, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode years_15_to_64 */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->years_15_to_64, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode years_65_and_over */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->years_65_and_over, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode total_population */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->total_population, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 5) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_people_sex_ratio_element (OSCTXT* pctxt, 
   Factbook_record_people_sex_ratio_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("at_birth"), 8}, 0}, 0 },
      {{{OSUTF8("under_15_years"), 14}, 0}, 1 },
      {{{OSUTF8("years-15_to_64"), 14}, 0}, 2 },
      {{{OSUTF8("years-65_and_over"), 17}, 0}, 3 },
      {{{OSUTF8("total_population"), 16}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}
      , {5, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* at_birth */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->at_birth);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* under_15_years */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->under_15_years);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* years-15_to_64 */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->years_15_to_64);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* years-65_and_over */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->years_65_and_over);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* total_population */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->total_population);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_people_life_expectancy_at_birth_element   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_people_life_expectancy_at_birth_element (
   OSCTXT* pctxt, 
   Factbook_record_people_life_expectancy_at_birth_element *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode total_population */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->total_population, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode male */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->male, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode female */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->female, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_people_life_expectancy_at_birth_element 
   (OSCTXT* pctxt, 
   Factbook_record_people_life_expectancy_at_birth_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("total_population"), 16}, 0}, 0 },
      {{{OSUTF8("male"), 4}, 0}, 1 },
      {{{OSUTF8("female"), 6}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* total_population */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->total_population);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* male */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->male);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* female */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->female);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_people_nationality                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_people_nationality (OSCTXT* pctxt, 
   Factbook_record_people_nationality *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode noun */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->noun, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode adjective */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->adjective, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_people_nationality (OSCTXT* pctxt, 
   Factbook_record_people_nationality* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("noun"), 4}, 0}, 0 },
      {{{OSUTF8("adjective"), 9}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* noun */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->noun);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* adjective */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->adjective);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_people_literacy_element                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_people_literacy_element (OSCTXT* pctxt, 
   Factbook_record_people_literacy_element *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode definition */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->definition, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode total_population */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->total_population, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode male */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->male, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode female */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->female, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 4) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_people_literacy_element (OSCTXT* pctxt, 
   Factbook_record_people_literacy_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("definition"), 10}, 0}, 0 },
      {{{OSUTF8("total_population"), 16}, 0}, 1 },
      {{{OSUTF8("male"), 4}, 0}, 2 },
      {{{OSUTF8("female"), 6}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 0, -1}
      };

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* definition */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->definition);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* total_population */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->total_population);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* male */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->male);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* female */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->female);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_people                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_people (OSCTXT* pctxt, 
   Factbook_record_people *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode population */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->population, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode age_structure */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            { int ilcnt = 0, length;
            tagging = ASN1IMPL;
            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Factbook_record_people_age_structure_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               if (XD_PEEKTAG (pctxt, 0xa0)) {
                  stat = xd_Tag1AndLen (pctxt, &length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);
               }
               else return LOG_RTERR (pctxt,
                  berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->age_structure);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  if (pvalue->age_structure.count >= 1) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

                  rtxDListAllocNodeAndData (pctxt, Factbook_record_people_age_structure_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Factbook_record_people_age_structure_element (pdata2);

                  stat = asn1D_Factbook_record_people_age_structure_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->age_structure, pnode);
               }

               if (!((pvalue->age_structure.count >= 0 && pvalue->age_structure.count
                   <= 1))) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_people.age_structure.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->age_structure.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;

            while (ilcnt-- > 0) {
               if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
               else return LOG_RTERR (pctxt, ASN_E_INVLEN);
            }}
         }
         break;

      case 2:
         /* decode population_growth_rate */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->population_growth_rate, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode birth_rate */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->birth_rate, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode death_rate */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->death_rate, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode net_migration_rate */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->net_migration_rate, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode sex_ratio */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            { int ilcnt = 0, length;
            tagging = ASN1IMPL;
            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Factbook_record_people_sex_ratio_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               if (XD_PEEKTAG (pctxt, 0xa0)) {
                  stat = xd_Tag1AndLen (pctxt, &length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);
               }
               else return LOG_RTERR (pctxt,
                  berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->sex_ratio);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  if (pvalue->sex_ratio.count >= 1) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

                  rtxDListAllocNodeAndData (pctxt, Factbook_record_people_sex_ratio_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Factbook_record_people_sex_ratio_element (pdata2);

                  stat = asn1D_Factbook_record_people_sex_ratio_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->sex_ratio, pnode);
               }

               if (!((pvalue->sex_ratio.count >= 0 && pvalue->sex_ratio.count <= 1))) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_people.sex_ratio.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->sex_ratio.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;

            while (ilcnt-- > 0) {
               if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
               else return LOG_RTERR (pctxt, ASN_E_INVLEN);
            }}
         }
         break;

      case 7:
         /* decode infant_mortality_rate */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->infant_mortality_rate, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode life_expectancy_at_birth */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            { int ilcnt = 0, length;
            tagging = ASN1IMPL;
            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Factbook_record_people_life_expectancy_at_birth_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               if (XD_PEEKTAG (pctxt, 0xa0)) {
                  stat = xd_Tag1AndLen (pctxt, &length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);
               }
               else return LOG_RTERR (pctxt,
                  berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->life_expectancy_at_birth);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  if (pvalue->life_expectancy_at_birth.count >= 1) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

                  rtxDListAllocNodeAndData (pctxt, Factbook_record_people_life_expectancy_at_birth_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Factbook_record_people_life_expectancy_at_birth_element (pdata2);

                  stat = asn1D_Factbook_record_people_life_expectancy_at_birth_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->life_expectancy_at_birth, pnode);
               }

               if (!((pvalue->life_expectancy_at_birth.count >= 0 && pvalue->
                  life_expectancy_at_birth.count <= 1))) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_people.life_expectancy_at_birth.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->life_expectancy_at_birth.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;

            while (ilcnt-- > 0) {
               if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
               else return LOG_RTERR (pctxt, ASN_E_INVLEN);
            }}
         }
         break;

      case 9:
         /* decode total_fertility_rate */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->total_fertility_rate, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 10:
         /* decode hIV_AIDS_adult_prevalence_rate */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->hIV_AIDS_adult_prevalence_rate, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 11:
         /* decode hIV_AIDS_people_living_with_HIV_AIDS */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->hIV_AIDS_people_living_with_HIV_AIDS, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 12:
         /* decode hIV_AIDS_deaths */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->hIV_AIDS_deaths, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 13:
         /* decode nationality */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_people_nationality (pctxt, 
               &pvalue->nationality, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 14:
         /* decode ethnic_groups */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->ethnic_groups, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 15:
         /* decode religions */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->religions, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 16:
         /* decode languages */
         if (XD_PEEKTAG (pctxt, 0x90)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->languages, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 17:
         /* decode literacy */
         if (XD_PEEKTAG (pctxt, 0x91)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            { int ilcnt = 0, length;
            tagging = ASN1IMPL;
            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Factbook_record_people_literacy_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               if (XD_PEEKTAG (pctxt, 0xa0)) {
                  stat = xd_Tag1AndLen (pctxt, &length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);
               }
               else return LOG_RTERR (pctxt,
                  berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->literacy);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  if (pvalue->literacy.count >= 1) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

                  rtxDListAllocNodeAndData (pctxt, Factbook_record_people_literacy_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Factbook_record_people_literacy_element (pdata2);

                  stat = asn1D_Factbook_record_people_literacy_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->literacy, pnode);
               }

               if (!((pvalue->literacy.count >= 0 && pvalue->literacy.count <= 1))) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_people.literacy.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->literacy.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;

            while (ilcnt-- > 0) {
               if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
               else return LOG_RTERR (pctxt, ASN_E_INVLEN);
            }}
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_PRIM|11):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_PRIM|14):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_PRIM|15):
         case (TM_CTXT|TM_CONS|15):
         case (TM_CTXT|TM_PRIM|16):
         case (TM_CTXT|TM_CONS|16):
         case (TM_CTXT|TM_CONS|17):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 18) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_people (OSCTXT* pctxt, 
   Factbook_record_people* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("population"), 10}, 0}, 0 },
      {{{OSUTF8("age_structure"), 13}, 0}, 1 },
      {{{OSUTF8("population_growth_rate"), 22}, 0}, 2 },
      {{{OSUTF8("birth_rate"), 10}, 0}, 3 },
      {{{OSUTF8("death_rate"), 10}, 0}, 4 },
      {{{OSUTF8("net_migration_rate"), 18}, 0}, 5 },
      {{{OSUTF8("sex_ratio"), 9}, 0}, 6 },
      {{{OSUTF8("infant_mortality_rate"), 21}, 0}, 7 },
      {{{OSUTF8("life_expectancy_at_birth"), 24}, 0}, 8 },
      {{{OSUTF8("total_fertility_rate"), 20}, 0}, 9 },
      {{{OSUTF8("HIV_AIDS-adult_prevalence_rate"), 30}, 0}, 10 },
      {{{OSUTF8("HIV_AIDS-people_living_with_HIV_AIDS"), 36}, 0}, 11 },
      {{{OSUTF8("HIV_AIDS-deaths"), 15}, 0}, 12 },
      {{{OSUTF8("nationality"), 11}, 0}, 13 },
      {{{OSUTF8("ethnic_groups"), 13}, 0}, 14 },
      {{{OSUTF8("religions"), 9}, 0}, 15 },
      {{{OSUTF8("languages"), 9}, 0}, 16 },
      {{{OSUTF8("literacy"), 8}, 0}, 17 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 2, -1}, {3, 1, -1}, {4, 1, -1}, {5, 1, -1}
      , {6, 2, -1}, {8, 2, -1}, {10, 1, -1}, {11, 1, -1}, {12, 1, -1}
      , {13, 1, -1}, {14, 1, -1}, {15, 1, -1}, {16, 1, -1}, {17, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 18; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* population */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->population);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* age_structure */
         { int elemID;
         Factbook_record_people_age_structure_element* pdata1;

         static const OSXMLElemIDRec elemtab[] = {
            {{{OSUTF8("years-0_to_14"), 13}, 0}, 0 }
         } ;

         rtxDListInit (&pvalue->age_structure);
         for (;;) {
            elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
            if (elemID < 0 || elemID == XML_OK_EOB) break;

            switch (elemID) {
            case 0:
               rtXmlpMarkLastEventActive (pctxt);

               pdata1
                   = rtxMemAllocType (pctxt, Factbook_record_people_age_structure_element);

               if (pdata1 == NULL)
                  return LOG_RTERR (pctxt, RTERR_NOMEM);

               asn1Init_Factbook_record_people_age_structure_element (pdata1);

               stat = XmlDec_Factbook_record_people_age_structure_element 
                  (pctxt, pdata1);
               if (stat != 0) return LOG_RTERR (pctxt, stat);

               rtxDListAppend (pctxt, &pvalue->age_structure, (void*)pdata1);
               break;

            }
         }

         if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
            stat = 0;
         }
         else return LOG_RTERR (pctxt, elemID);
         }

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* population_growth_rate */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->population_growth_rate);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* birth_rate */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->birth_rate);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* death_rate */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->death_rate);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 5: { /* net_migration_rate */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->net_migration_rate);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 6: { /* sex_ratio */
         { int elemID;
         Factbook_record_people_sex_ratio_element* pdata1;

         static const OSXMLElemIDRec elemtab[] = {
            {{{OSUTF8("at_birth"), 8}, 0}, 0 }
         } ;

         rtxDListInit (&pvalue->sex_ratio);
         for (;;) {
            elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
            if (elemID < 0 || elemID == XML_OK_EOB) break;

            switch (elemID) {
            case 0:
               rtXmlpMarkLastEventActive (pctxt);

               pdata1
                   = rtxMemAllocType (pctxt, Factbook_record_people_sex_ratio_element);

               if (pdata1 == NULL)
                  return LOG_RTERR (pctxt, RTERR_NOMEM);

               asn1Init_Factbook_record_people_sex_ratio_element (pdata1);

               stat = XmlDec_Factbook_record_people_sex_ratio_element (pctxt, 
                  pdata1);
               if (stat != 0) return LOG_RTERR (pctxt, stat);

               rtxDListAppend (pctxt, &pvalue->sex_ratio, (void*)pdata1);
               break;

            }
         }

         if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
            stat = 0;
         }
         else return LOG_RTERR (pctxt, elemID);
         }

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 7: { /* infant_mortality_rate */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->infant_mortality_rate);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 8: { /* life_expectancy_at_birth */
         { int elemID;
         Factbook_record_people_life_expectancy_at_birth_element* pdata1;

         static const OSXMLElemIDRec elemtab[] = {
            {{{OSUTF8("total_population"), 16}, 0}, 0 }
         } ;

         rtxDListInit (&pvalue->life_expectancy_at_birth);
         for (;;) {
            elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
            if (elemID < 0 || elemID == XML_OK_EOB) break;

            switch (elemID) {
            case 0:
               rtXmlpMarkLastEventActive (pctxt);

               pdata1
                   = rtxMemAllocType (pctxt, Factbook_record_people_life_expectancy_at_birth_element);

               if (pdata1 == NULL)
                  return LOG_RTERR (pctxt, RTERR_NOMEM);

               asn1Init_Factbook_record_people_life_expectancy_at_birth_element (
                  pdata1);

               stat = XmlDec_Factbook_record_people_life_expectancy_at_birth_element 
                  (pctxt, pdata1);
               if (stat != 0) return LOG_RTERR (pctxt, stat);

               rtxDListAppend (pctxt, &pvalue->life_expectancy_at_birth
                  , (void*)pdata1);
               break;

            }
         }

         if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
            stat = 0;
         }
         else return LOG_RTERR (pctxt, elemID);
         }

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 9: { /* total_fertility_rate */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->total_fertility_rate);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 10: { /* HIV_AIDS-adult_prevalence_rate */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            hIV_AIDS_adult_prevalence_rate);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 11: { /* HIV_AIDS-people_living_with_HIV_AIDS */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            hIV_AIDS_people_living_with_HIV_AIDS);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 12: { /* HIV_AIDS-deaths */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->hIV_AIDS_deaths);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 13: { /* nationality */
         stat = XmlDec_Factbook_record_people_nationality (pctxt, &pvalue->
            nationality);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 14: { /* ethnic_groups */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->ethnic_groups);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 15: { /* religions */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->religions);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 16: { /* languages */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->languages);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 17: { /* literacy */
         { int elemID;
         Factbook_record_people_literacy_element* pdata1;

         static const OSXMLElemIDRec elemtab[] = {
            {{{OSUTF8("definition"), 10}, 0}, 0 }
         } ;

         rtxDListInit (&pvalue->literacy);
         for (;;) {
            elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
            if (elemID < 0 || elemID == XML_OK_EOB) break;

            switch (elemID) {
            case 0:
               rtXmlpMarkLastEventActive (pctxt);

               pdata1
                   = rtxMemAllocType (pctxt, Factbook_record_people_literacy_element);

               if (pdata1 == NULL)
                  return LOG_RTERR (pctxt, RTERR_NOMEM);

               asn1Init_Factbook_record_people_literacy_element (pdata1);

               stat = XmlDec_Factbook_record_people_literacy_element (pctxt, 
                  pdata1);
               if (stat != 0) return LOG_RTERR (pctxt, stat);

               rtxDListAppend (pctxt, &pvalue->literacy, (void*)pdata1);
               break;

            }
         }

         if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
            stat = 0;
         }
         else return LOG_RTERR (pctxt, elemID);
         }

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_government_country_name                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_government_country_name (OSCTXT* pctxt, 
   Factbook_record_government_country_name *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode conventional_long_form */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->conventional_long_form, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode conventional_short_form_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->conventional_short_form_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->conventional_short_form_list, pnode);
               }

               if (!(pvalue->conventional_short_form_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_government_country_name.conventional_short_form_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->conventional_short_form_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode local_long_form_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->local_long_form_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->local_long_form_list, pnode);
               }

               if (!(pvalue->local_long_form_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_government_country_name.local_long_form_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->local_long_form_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode local_short_form_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->local_short_form_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->local_short_form_list, pnode);
               }

               if (!(pvalue->local_short_form_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_government_country_name.local_short_form_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->local_short_form_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode former_name_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->former_name_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->former_name_list, pnode);
               }

               if (!(pvalue->former_name_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_government_country_name.former_name_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->former_name_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 5) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_government_country_name (OSCTXT* pctxt, 
   Factbook_record_government_country_name* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("conventional_long_form"), 22}, 0}, 0 },
      {{{OSUTF8("conventional_short_form"), 23}, 0}, 1 },
      {{{OSUTF8("local_long_form"), 15}, 0}, 2 },
      {{{OSUTF8("local_short_form"), 16}, 0}, 3 },
      {{{OSUTF8("former_name"), 11}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 4, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* conventional_long_form */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->conventional_long_form);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->conventional_short_form_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 2: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->local_long_form_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 2, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 2);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 3: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->local_short_form_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 4: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->former_name_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 4, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 4);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_government_executive_branch               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_government_executive_branch (OSCTXT* pctxt, 
   Factbook_record_government_executive_branch *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode note_list */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->note_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->note_list, pnode);
               }

               if (!(pvalue->note_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_government_executive_branch.note_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->note_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode chief_of_state */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->chief_of_state, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode head_of_government */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->head_of_government, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode cabinet */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->cabinet, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode elections */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->elections, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.electionsPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode election_results */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->election_results, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.election_resultsPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 4) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_government_executive_branch (OSCTXT* pctxt, 
   Factbook_record_government_executive_branch* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("note"), 4}, 0}, 0 },
      {{{OSUTF8("chief_of_state"), 14}, 0}, 1 },
      {{{OSUTF8("head_of_government"), 18}, 0}, 2 },
      {{{OSUTF8("cabinet"), 7}, 0}, 3 },
      {{{OSUTF8("elections"), 9}, 0}, 4 },
      {{{OSUTF8("election_results"), 16}, 0}, 5 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 1, -1}, {3, 1, -1}, {4, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 6; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->note_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: { /* chief_of_state */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->chief_of_state);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* head_of_government */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->head_of_government);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* cabinet */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->cabinet);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* elections */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->elections);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.electionsPresent = TRUE;
         break;
      }
      case 5: { /* election_results */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->election_results);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.election_resultsPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_government_legislative_branch             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_government_legislative_branch (OSCTXT* pctxt, 
   Factbook_record_government_legislative_branch *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode note */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->note, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode elections */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->elections, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.electionsPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode election_results */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->election_results, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.election_resultsPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_government_legislative_branch (OSCTXT* pctxt, 
   Factbook_record_government_legislative_branch* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("note"), 4}, 0}, 0 },
      {{{OSUTF8("elections"), 9}, 0}, 1 },
      {{{OSUTF8("election_results"), 16}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* note */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->note);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* elections */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->elections);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.electionsPresent = TRUE;
         break;
      }
      case 2: { /* election_results */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->election_results);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.election_resultsPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_government_diplomatic_representation_in_  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_government_diplomatic_representation_in_the_US_element (
   OSCTXT* pctxt, 
   Factbook_record_government_diplomatic_representation_in_the_US_element *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode chief_of_mission */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->chief_of_mission, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.chief_of_missionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode chancery */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->chancery, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.chanceryPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode telephone */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->telephone, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.telephonePresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode fAX */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->fAX, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fAXPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode consulate_general */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->consulate_general, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.consulate_generalPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_government_diplomatic_representation_in_the_US_element 
   (OSCTXT* pctxt, 
   Factbook_record_government_diplomatic_representation_in_the_US_element* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("chief_of_mission"), 16}, 0}, 0 },
      {{{OSUTF8("chancery"), 8}, 0}, 1 },
      {{{OSUTF8("telephone"), 9}, 0}, 2 },
      {{{OSUTF8("FAX"), 3}, 0}, 3 },
      {{{OSUTF8("consulate_general"), 17}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* chief_of_mission */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->chief_of_mission);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.chief_of_missionPresent = TRUE;
         break;
      }
      case 1: { /* chancery */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->chancery);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.chanceryPresent = TRUE;
         break;
      }
      case 2: { /* telephone */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->telephone);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.telephonePresent = TRUE;
         break;
      }
      case 3: { /* FAX */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->fAX);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.fAXPresent = TRUE;
         break;
      }
      case 4: { /* consulate_general */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->consulate_general);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.consulate_generalPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_government_diplomatic_representation_fro  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_government_diplomatic_representation_from_the_US_element (
   OSCTXT* pctxt, 
   Factbook_record_government_diplomatic_representation_from_the_US_element *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode chief_of_mission */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->chief_of_mission, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.chief_of_missionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode embassy */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->embassy, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.embassyPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode mailing_address */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->mailing_address, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.mailing_addressPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode telephone */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->telephone, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.telephonePresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode fAX */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->fAX, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.fAXPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode consulate_general */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->consulate_general, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.consulate_generalPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_government_diplomatic_representation_from_the_US_element 
   (OSCTXT* pctxt, 
   Factbook_record_government_diplomatic_representation_from_the_US_element* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("chief_of_mission"), 16}, 0}, 0 },
      {{{OSUTF8("embassy"), 7}, 0}, 1 },
      {{{OSUTF8("mailing_address"), 15}, 0}, 2 },
      {{{OSUTF8("telephone"), 9}, 0}, 3 },
      {{{OSUTF8("FAX"), 3}, 0}, 4 },
      {{{OSUTF8("consulate_general"), 17}, 0}, 5 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 6, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 6; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* chief_of_mission */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->chief_of_mission);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.chief_of_missionPresent = TRUE;
         break;
      }
      case 1: { /* embassy */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->embassy);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.embassyPresent = TRUE;
         break;
      }
      case 2: { /* mailing_address */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->mailing_address);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.mailing_addressPresent = TRUE;
         break;
      }
      case 3: { /* telephone */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->telephone);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.telephonePresent = TRUE;
         break;
      }
      case 4: { /* FAX */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->fAX);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.fAXPresent = TRUE;
         break;
      }
      case 5: { /* consulate_general */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->consulate_general);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.consulate_generalPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_government                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_government (OSCTXT* pctxt, 
   Factbook_record_government *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode country_name */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_government_country_name (pctxt, 
               &pvalue->country_name, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode dependency_status_list */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               const OSUTF8CHAR* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->dependency_status_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  pnode = rtxMemAllocTypeZ (pctxt, OSRTDListNode);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  stat = xd_utf8str (pctxt, &pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  pnode->data = (void*)pdata2;
                  rtxDListAppendNode (&pvalue->dependency_status_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode government_type */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->government_type, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode capital */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->capital, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode administrative_divisions */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->administrative_divisions, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode independence */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->independence, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode national_holiday */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->national_holiday, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode constitution */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->constitution, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode legal_system */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->legal_system, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 9:
         /* decode suffrage */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->suffrage, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 10:
         /* decode executive_branch */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_government_executive_branch (pctxt, 
               &pvalue->executive_branch, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 11:
         /* decode legislative_branch */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_government_legislative_branch (pctxt, 
               &pvalue->legislative_branch, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 12:
         /* decode judicial_branch */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->judicial_branch, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 13:
         /* decode political_parties_and_leaders */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->political_parties_and_leaders, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 14:
         /* decode political_pressure_groups_and_leaders */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->political_pressure_groups_and_leaders, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 15:
         /* decode international_organization_participation */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->international_organization_participation, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 16:
         /* decode diplomatic_representation_in_the_US */
         if (XD_PEEKTAG (pctxt, 0x90)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            { int ilcnt = 0, length;
            tagging = ASN1IMPL;
            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Factbook_record_government_diplomatic_representation_in_the_US_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               if (XD_PEEKTAG (pctxt, 0xa0)) {
                  stat = xd_Tag1AndLen (pctxt, &length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);
               }
               else return LOG_RTERR (pctxt,
                  berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->diplomatic_representation_in_the_US);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  if (pvalue->diplomatic_representation_in_the_US.count >= 1) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

                  rtxDListAllocNodeAndData (pctxt, Factbook_record_government_diplomatic_representation_in_the_US_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Factbook_record_government_diplomatic_representation_in_the_US_element (pdata2);

                  stat = asn1D_Factbook_record_government_diplomatic_representation_in_the_US_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->diplomatic_representation_in_the_US, pnode);
               }

               if (!((pvalue->diplomatic_representation_in_the_US.count >= 0 && pvalue
                  ->diplomatic_representation_in_the_US.count <= 1))) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_government.diplomatic_representation_in_the_US.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->diplomatic_representation_in_the_US.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;

            while (ilcnt-- > 0) {
               if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
               else return LOG_RTERR (pctxt, ASN_E_INVLEN);
            }}
         }
         break;

      case 17:
         /* decode diplomatic_representation_from_the_US */
         if (XD_PEEKTAG (pctxt, 0x91)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            { int ilcnt = 0, length;
            tagging = ASN1IMPL;
            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Factbook_record_government_diplomatic_representation_from_the_US_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               if (XD_PEEKTAG (pctxt, 0xa0)) {
                  stat = xd_Tag1AndLen (pctxt, &length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);
               }
               else return LOG_RTERR (pctxt,
                  berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->diplomatic_representation_from_the_US);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  if (pvalue->diplomatic_representation_from_the_US.count >= 1) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

                  rtxDListAllocNodeAndData (pctxt, Factbook_record_government_diplomatic_representation_from_the_US_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Factbook_record_government_diplomatic_representation_from_the_US_element (pdata2);

                  stat = asn1D_Factbook_record_government_diplomatic_representation_from_the_US_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->diplomatic_representation_from_the_US, pnode);
               }

               if (!((pvalue->diplomatic_representation_from_the_US.count >= 0 && 
                  pvalue->diplomatic_representation_from_the_US.count <= 1))) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_government.diplomatic_representation_from_the_US.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->diplomatic_representation_from_the_US.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;

            while (ilcnt-- > 0) {
               if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
               else return LOG_RTERR (pctxt, ASN_E_INVLEN);
            }}
         }
         break;

      case 18:
         /* decode flag_description */
         if (XD_PEEKTAG (pctxt, 0x92)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->flag_description, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_PRIM|13):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_PRIM|14):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_PRIM|15):
         case (TM_CTXT|TM_CONS|15):
         case (TM_CTXT|TM_CONS|16):
         case (TM_CTXT|TM_CONS|17):
         case (TM_CTXT|TM_PRIM|18):
         case (TM_CTXT|TM_CONS|18):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 19) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_government (OSCTXT* pctxt, 
   Factbook_record_government* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("country_name"), 12}, 0}, 0 },
      {{{OSUTF8("dependency_status"), 17}, 0}, 1 },
      {{{OSUTF8("government_type"), 15}, 0}, 2 },
      {{{OSUTF8("capital"), 7}, 0}, 3 },
      {{{OSUTF8("administrative_divisions"), 24}, 0}, 4 },
      {{{OSUTF8("independence"), 12}, 0}, 5 },
      {{{OSUTF8("national_holiday"), 16}, 0}, 6 },
      {{{OSUTF8("constitution"), 12}, 0}, 7 },
      {{{OSUTF8("legal_system"), 12}, 0}, 8 },
      {{{OSUTF8("suffrage"), 8}, 0}, 9 },
      {{{OSUTF8("executive_branch"), 16}, 0}, 10 },
      {{{OSUTF8("legislative_branch"), 18}, 0}, 11 },
      {{{OSUTF8("judicial_branch"), 15}, 0}, 12 },
      {{{OSUTF8("political_parties_and_leaders"), 29}, 0}, 13 },
      {{{OSUTF8("political_pressure_groups_and_leaders"), 37}, 0}, 14 },
      {{{OSUTF8("international_organization_participation"), 40}, 0}, 15 },
      {{{OSUTF8("diplomatic_representation_in_the_US"), 35}, 0}, 16 },
      {{{OSUTF8("diplomatic_representation_from_the_US"), 37}, 0}, 17 },
      {{{OSUTF8("flag_description"), 16}, 0}, 18 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 2, -1}, {3, 1, -1}, {4, 1, -1}, {5, 1, -1}
      , {6, 1, -1}, {7, 1, -1}, {8, 1, -1}, {9, 1, -1}, {10, 1, -1}
      , {11, 1, -1}, {12, 1, -1}, {13, 1, -1}, {14, 1, -1}, {15, 1, -1}
      , {16, 3, -1}, {19, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 19; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* country_name */
         stat = XmlDec_Factbook_record_government_country_name (pctxt, &pvalue
            ->country_name);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: {
         const OSUTF8CHAR* pdata1;
         do {
            stat = rtXmlpDecDynUTF8Str (pctxt, &pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->dependency_status_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 2: { /* government_type */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->government_type);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* capital */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->capital);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* administrative_divisions */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->administrative_divisions
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 5: { /* independence */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->independence);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 6: { /* national_holiday */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->national_holiday);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 7: { /* constitution */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->constitution);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 8: { /* legal_system */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->legal_system);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 9: { /* suffrage */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->suffrage);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 10: { /* executive_branch */
         stat = XmlDec_Factbook_record_government_executive_branch (pctxt, &
            pvalue->executive_branch);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 11: { /* legislative_branch */
         stat = XmlDec_Factbook_record_government_legislative_branch (pctxt, &
            pvalue->legislative_branch);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 12: { /* judicial_branch */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->judicial_branch);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 13: { /* political_parties_and_leaders */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            political_parties_and_leaders);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 14: { /* political_pressure_groups_and_leaders */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            political_pressure_groups_and_leaders);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 15: { /* international_organization_participation */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            international_organization_participation);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 16: { /* diplomatic_representation_in_the_US */
         { int elemID;
         Factbook_record_government_diplomatic_representation_in_the_US_element* pdata1;

         static const OSXMLElemIDRec elemtab[] = {
            {{{OSUTF8("chief_of_mission"), 16}, 0}, 0 },
            {{{OSUTF8("chancery"), 8}, 0}, 0 },
            {{{OSUTF8("telephone"), 9}, 0}, 0 },
            {{{OSUTF8("FAX"), 3}, 0}, 0 },
            {{{OSUTF8("consulate_general"), 17}, 0}, 0 }
         } ;

         rtxDListInit (&pvalue->diplomatic_representation_in_the_US);
         for (;;) {
            elemID = rtXmlpGetNextElemID (pctxt, elemtab, 5, -1, FALSE);
            if (elemID < 0 || elemID == XML_OK_EOB) break;

            switch (elemID) {
            case 0:
               rtXmlpMarkLastEventActive (pctxt);

               pdata1
                   = rtxMemAllocType (pctxt, Factbook_record_government_diplomatic_representation_in_the_US_element);

               if (pdata1 == NULL)
                  return LOG_RTERR (pctxt, RTERR_NOMEM);

               asn1Init_Factbook_record_government_diplomatic_representation_in_the_US_element (
                  pdata1);

               stat = XmlDec_Factbook_record_government_diplomatic_representation_in_the_US_element 
                  (pctxt, pdata1);
               if (stat != 0) return LOG_RTERR (pctxt, stat);

               rtxDListAppend (pctxt, &pvalue->
                  diplomatic_representation_in_the_US, (void*)pdata1);
               break;

            }
         }

         if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
            stat = 0;
         }
         else return LOG_RTERR (pctxt, elemID);
         }

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 17: { /* diplomatic_representation_from_the_US */
         { int elemID;
         Factbook_record_government_diplomatic_representation_from_the_US_element* pdata1;

         static const OSXMLElemIDRec elemtab[] = {
            {{{OSUTF8("chief_of_mission"), 16}, 0}, 0 },
            {{{OSUTF8("embassy"), 7}, 0}, 0 },
            {{{OSUTF8("mailing_address"), 15}, 0}, 0 },
            {{{OSUTF8("telephone"), 9}, 0}, 0 },
            {{{OSUTF8("FAX"), 3}, 0}, 0 },
            {{{OSUTF8("consulate_general"), 17}, 0}, 0 }
         } ;

         rtxDListInit (&pvalue->diplomatic_representation_from_the_US);
         for (;;) {
            elemID = rtXmlpGetNextElemID (pctxt, elemtab, 6, -1, FALSE);
            if (elemID < 0 || elemID == XML_OK_EOB) break;

            switch (elemID) {
            case 0:
               rtXmlpMarkLastEventActive (pctxt);

               pdata1
                   = rtxMemAllocType (pctxt, Factbook_record_government_diplomatic_representation_from_the_US_element);

               if (pdata1 == NULL)
                  return LOG_RTERR (pctxt, RTERR_NOMEM);

               asn1Init_Factbook_record_government_diplomatic_representation_from_the_US_element (
                  pdata1);

               stat = XmlDec_Factbook_record_government_diplomatic_representation_from_the_US_element 
                  (pctxt, pdata1);
               if (stat != 0) return LOG_RTERR (pctxt, stat);

               rtxDListAppend (pctxt, &pvalue->
                  diplomatic_representation_from_the_US, (void*)pdata1);
               break;

            }
         }

         if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
            stat = 0;
         }
         else return LOG_RTERR (pctxt, elemID);
         }

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 18: { /* flag_description */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->flag_description);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_economy_composition_by_sector             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_economy_composition_by_sector (OSCTXT* pctxt, 
   Factbook_record_economy_composition_by_sector *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode agriculture */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->agriculture, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode industry */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->industry, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode services */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->services, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_economy_composition_by_sector (OSCTXT* pctxt, 
   Factbook_record_economy_composition_by_sector* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("agriculture"), 11}, 0}, 0 },
      {{{OSUTF8("industry"), 8}, 0}, 1 },
      {{{OSUTF8("services"), 8}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* agriculture */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->agriculture);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* industry */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->industry);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* services */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->services);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_economy_household_income_or_consumption_  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_economy_household_income_or_consumption_by_percentage_share (
   OSCTXT* pctxt, 
   Factbook_record_economy_household_income_or_consumption_by_percentage_share *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode lowest_10_percent */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->lowest_10_percent, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode highest_10_percent */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->highest_10_percent, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_economy_household_income_or_consumption_by_percentage_share 
   (OSCTXT* pctxt, 
   Factbook_record_economy_household_income_or_consumption_by_percentage_share* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("lowest_10_percent"), 17}, 0}, 0 },
      {{{OSUTF8("highest_10_percent"), 18}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* lowest_10_percent */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->lowest_10_percent);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* highest_10_percent */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->highest_10_percent);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_economy_budget                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_economy_budget (OSCTXT* pctxt, 
   Factbook_record_economy_budget *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode revenues */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->revenues, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode expenditures */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->expenditures, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_economy_budget (OSCTXT* pctxt, 
   Factbook_record_economy_budget* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("revenues"), 8}, 0}, 0 },
      {{{OSUTF8("expenditures"), 12}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* revenues */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->revenues);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* expenditures */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->expenditures);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_economy_electricity_production_by_source  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_economy_electricity_production_by_source (
   OSCTXT* pctxt, 
   Factbook_record_economy_electricity_production_by_source *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode fossil_fuel */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->fossil_fuel, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode hydro */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->hydro, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode nuclear */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->nuclear, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode other */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->other, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.otherPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_economy_electricity_production_by_source 
   (OSCTXT* pctxt, 
   Factbook_record_economy_electricity_production_by_source* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("fossil_fuel"), 11}, 0}, 0 },
      {{{OSUTF8("hydro"), 5}, 0}, 1 },
      {{{OSUTF8("nuclear"), 7}, 0}, 2 },
      {{{OSUTF8("other"), 5}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* fossil_fuel */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->fossil_fuel);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* hydro */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->hydro);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* nuclear */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->nuclear);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* other */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->other);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.otherPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_economy                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_economy (OSCTXT* pctxt, 
   Factbook_record_economy *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode economy_overview */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->economy_overview, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode gDP */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->gDP, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode gDP_real_growth_rate */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->gDP_real_growth_rate, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode gDP_per_capita */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->gDP_per_capita, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode composition_by_sector */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_economy_composition_by_sector (pctxt, 
               &pvalue->composition_by_sector, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode population_below_poverty_line */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->population_below_poverty_line, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode household_income_or_consumption_by_percentage_share */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_economy_household_income_or_consumption_by_percentage_share (pctxt, 
               &pvalue->household_income_or_consumption_by_percentage_share, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode inflation_rate_consumer_prices */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->inflation_rate_consumer_prices, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode labor_force */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->labor_force, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 9:
         /* decode labor_force_by_occupation */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->labor_force_by_occupation, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 10:
         /* decode unemployment_rate */
         if (XD_PEEKTAG (pctxt, 0x8a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->unemployment_rate, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 11:
         /* decode budget */
         if (XD_PEEKTAG (pctxt, 0x8b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_economy_budget (pctxt, 
               &pvalue->budget, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 12:
         /* decode industries */
         if (XD_PEEKTAG (pctxt, 0x8c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->industries, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 13:
         /* decode industrial_production_growth_rate */
         if (XD_PEEKTAG (pctxt, 0x8d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->industrial_production_growth_rate, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 14:
         /* decode electricity_production */
         if (XD_PEEKTAG (pctxt, 0x8e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->electricity_production, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 15:
         /* decode electricity_production_by_source */
         if (XD_PEEKTAG (pctxt, 0x8f)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_economy_electricity_production_by_source (pctxt, 
               &pvalue->electricity_production_by_source, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 16:
         /* decode electricity_consumption */
         if (XD_PEEKTAG (pctxt, 0x90)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->electricity_consumption, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 17:
         /* decode electricity_exports */
         if (XD_PEEKTAG (pctxt, 0x91)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->electricity_exports, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 18:
         /* decode electricity_imports */
         if (XD_PEEKTAG (pctxt, 0x92)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->electricity_imports, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 19:
         /* decode agriculture_products */
         if (XD_PEEKTAG (pctxt, 0x93)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->agriculture_products, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 20:
         /* decode exports */
         if (XD_PEEKTAG (pctxt, 0x94)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->exports, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 21:
         /* decode export_commodities */
         if (XD_PEEKTAG (pctxt, 0x95)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->export_commodities, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 22:
         /* decode export_partners */
         if (XD_PEEKTAG (pctxt, 0x96)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->export_partners, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 23:
         /* decode imports */
         if (XD_PEEKTAG (pctxt, 0x97)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->imports, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 24:
         /* decode import_commodities */
         if (XD_PEEKTAG (pctxt, 0x98)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->import_commodities, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 25:
         /* decode import_partners */
         if (XD_PEEKTAG (pctxt, 0x99)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->import_partners, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 26:
         /* decode external_dept */
         if (XD_PEEKTAG (pctxt, 0x9a)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->external_dept, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 27:
         /* decode external_aid_recipient */
         if (XD_PEEKTAG (pctxt, 0x9b)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->external_aid_recipient, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 28:
         /* decode currency */
         if (XD_PEEKTAG (pctxt, 0x9c)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->currency, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 29:
         /* decode currency_code */
         if (XD_PEEKTAG (pctxt, 0x9d)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->currency_code, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 30:
         /* decode exchange_rates */
         if (XD_PEEKTAG (pctxt, 0x9e)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->exchange_rates, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 31:
         /* decode fiscal_year */
         if ((stat = xd_match (pctxt, TM_CTXT|TM_PRIM|31, &length, XM_ADVANCE)) == 0) {
            stat = xd_utf8str (pctxt, &pvalue->fiscal_year, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
         case (TM_CTXT|TM_PRIM|10):
         case (TM_CTXT|TM_CONS|10):
         case (TM_CTXT|TM_CONS|11):
         case (TM_CTXT|TM_PRIM|12):
         case (TM_CTXT|TM_CONS|12):
         case (TM_CTXT|TM_PRIM|13):
         case (TM_CTXT|TM_CONS|13):
         case (TM_CTXT|TM_PRIM|14):
         case (TM_CTXT|TM_CONS|14):
         case (TM_CTXT|TM_CONS|15):
         case (TM_CTXT|TM_PRIM|16):
         case (TM_CTXT|TM_CONS|16):
         case (TM_CTXT|TM_PRIM|17):
         case (TM_CTXT|TM_CONS|17):
         case (TM_CTXT|TM_PRIM|18):
         case (TM_CTXT|TM_CONS|18):
         case (TM_CTXT|TM_PRIM|19):
         case (TM_CTXT|TM_CONS|19):
         case (TM_CTXT|TM_PRIM|20):
         case (TM_CTXT|TM_CONS|20):
         case (TM_CTXT|TM_PRIM|21):
         case (TM_CTXT|TM_CONS|21):
         case (TM_CTXT|TM_PRIM|22):
         case (TM_CTXT|TM_CONS|22):
         case (TM_CTXT|TM_PRIM|23):
         case (TM_CTXT|TM_CONS|23):
         case (TM_CTXT|TM_PRIM|24):
         case (TM_CTXT|TM_CONS|24):
         case (TM_CTXT|TM_PRIM|25):
         case (TM_CTXT|TM_CONS|25):
         case (TM_CTXT|TM_PRIM|26):
         case (TM_CTXT|TM_CONS|26):
         case (TM_CTXT|TM_PRIM|27):
         case (TM_CTXT|TM_CONS|27):
         case (TM_CTXT|TM_PRIM|28):
         case (TM_CTXT|TM_CONS|28):
         case (TM_CTXT|TM_PRIM|29):
         case (TM_CTXT|TM_CONS|29):
         case (TM_CTXT|TM_PRIM|30):
         case (TM_CTXT|TM_CONS|30):
         case (TM_CTXT|TM_PRIM|31):
         case (TM_CTXT|TM_CONS|31):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 32) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_economy (OSCTXT* pctxt, 
   Factbook_record_economy* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("economy_overview"), 16}, 0}, 0 },
      {{{OSUTF8("GDP"), 3}, 0}, 1 },
      {{{OSUTF8("GDP_real_growth_rate"), 20}, 0}, 2 },
      {{{OSUTF8("GDP_per_capita"), 14}, 0}, 3 },
      {{{OSUTF8("composition_by_sector"), 21}, 0}, 4 },
      {{{OSUTF8("population_below_poverty_line"), 29}, 0}, 5 },
      {{{OSUTF8("household_income_or_consumption_by_percentage_share"), 51}, 
         0}, 6 },
      {{{OSUTF8("inflation_rate_consumer_prices"), 30}, 0}, 7 },
      {{{OSUTF8("labor_force"), 11}, 0}, 8 },
      {{{OSUTF8("labor_force_by_occupation"), 25}, 0}, 9 },
      {{{OSUTF8("unemployment_rate"), 17}, 0}, 10 },
      {{{OSUTF8("budget"), 6}, 0}, 11 },
      {{{OSUTF8("industries"), 10}, 0}, 12 },
      {{{OSUTF8("industrial_production_growth_rate"), 33}, 0}, 13 },
      {{{OSUTF8("electricity_production"), 22}, 0}, 14 },
      {{{OSUTF8("electricity_production_by_source"), 32}, 0}, 15 },
      {{{OSUTF8("electricity_consumption"), 23}, 0}, 16 },
      {{{OSUTF8("electricity_exports"), 19}, 0}, 17 },
      {{{OSUTF8("electricity_imports"), 19}, 0}, 18 },
      {{{OSUTF8("agriculture_products"), 20}, 0}, 19 },
      {{{OSUTF8("exports"), 7}, 0}, 20 },
      {{{OSUTF8("export_commodities"), 18}, 0}, 21 },
      {{{OSUTF8("export_partners"), 15}, 0}, 22 },
      {{{OSUTF8("imports"), 7}, 0}, 23 },
      {{{OSUTF8("import_commodities"), 18}, 0}, 24 },
      {{{OSUTF8("import_partners"), 15}, 0}, 25 },
      {{{OSUTF8("external_dept"), 13}, 0}, 26 },
      {{{OSUTF8("external_aid_recipient"), 22}, 0}, 27 },
      {{{OSUTF8("currency"), 8}, 0}, 28 },
      {{{OSUTF8("currency_code"), 13}, 0}, 29 },
      {{{OSUTF8("exchange_rates"), 14}, 0}, 30 },
      {{{OSUTF8("fiscal_year"), 11}, 0}, 31 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}
      , {5, 1, -1}, {6, 1, -1}, {7, 1, -1}, {8, 1, -1}, {9, 1, -1}, {10, 1, -1}
      , {11, 1, -1}, {12, 1, -1}, {13, 1, -1}, {14, 1, -1}, {15, 1, -1}
      , {16, 1, -1}, {17, 1, -1}, {18, 1, -1}, {19, 1, -1}, {20, 1, -1}
      , {21, 1, -1}, {22, 1, -1}, {23, 1, -1}, {24, 1, -1}, {25, 1, -1}
      , {26, 1, -1}, {27, 1, -1}, {28, 1, -1}, {29, 1, -1}, {30, 1, -1}
      , {31, 1, -1}, {32, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 32; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* economy_overview */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->economy_overview);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* GDP */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->gDP);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* GDP_real_growth_rate */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->gDP_real_growth_rate);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* GDP_per_capita */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->gDP_per_capita);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* composition_by_sector */
         stat = XmlDec_Factbook_record_economy_composition_by_sector (pctxt, &
            pvalue->composition_by_sector);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 5: { /* population_below_poverty_line */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            population_below_poverty_line);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 6: { /* household_income_or_consumption_by_percentage_share */
         stat = XmlDec_Factbook_record_economy_household_income_or_consumption_by_percentage_share 
            (pctxt, &pvalue->
            household_income_or_consumption_by_percentage_share);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 7: { /* inflation_rate_consumer_prices */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            inflation_rate_consumer_prices);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 8: { /* labor_force */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->labor_force);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 9: { /* labor_force_by_occupation */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->labor_force_by_occupation
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 10: { /* unemployment_rate */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->unemployment_rate);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 11: { /* budget */
         stat = XmlDec_Factbook_record_economy_budget (pctxt, &pvalue->budget
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 12: { /* industries */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->industries);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 13: { /* industrial_production_growth_rate */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            industrial_production_growth_rate);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 14: { /* electricity_production */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->electricity_production);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 15: { /* electricity_production_by_source */
         stat = XmlDec_Factbook_record_economy_electricity_production_by_source 
            (pctxt, &pvalue->electricity_production_by_source);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 16: { /* electricity_consumption */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->electricity_consumption);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 17: { /* electricity_exports */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->electricity_exports);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 18: { /* electricity_imports */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->electricity_imports);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 19: { /* agriculture_products */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->agriculture_products);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 20: { /* exports */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->exports);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 21: { /* export_commodities */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->export_commodities);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 22: { /* export_partners */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->export_partners);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 23: { /* imports */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->imports);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 24: { /* import_commodities */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->import_commodities);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 25: { /* import_partners */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->import_partners);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 26: { /* external_dept */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->external_dept);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 27: { /* external_aid_recipient */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->external_aid_recipient);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 28: { /* currency */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->currency);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 29: { /* currency_code */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->currency_code);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 30: { /* exchange_rates */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->exchange_rates);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 31: { /* fiscal_year */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->fiscal_year);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_communications_telephone_system_element   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_communications_telephone_system_element (
   OSCTXT* pctxt, 
   Factbook_record_communications_telephone_system_element *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode general_assessment */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->general_assessment, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode domestic */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->domestic, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode international */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->international, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_communications_telephone_system_element 
   (OSCTXT* pctxt, 
   Factbook_record_communications_telephone_system_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("general_assessment"), 18}, 0}, 0 },
      {{{OSUTF8("domestic"), 8}, 0}, 1 },
      {{{OSUTF8("international"), 13}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* general_assessment */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->general_assessment);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* domestic */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->domestic);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* international */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->international);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_communications                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_communications (OSCTXT* pctxt, 
   Factbook_record_communications *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode telephones_main_lines_in_use */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->telephones_main_lines_in_use, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode telephones_mobile_cellular */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->telephones_mobile_cellular, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode telephone_system */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            { int ilcnt = 0, length;
            tagging = ASN1IMPL;
            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Factbook_record_communications_telephone_system_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               if (XD_PEEKTAG (pctxt, 0xa0)) {
                  stat = xd_Tag1AndLen (pctxt, &length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);
               }
               else return LOG_RTERR (pctxt,
                  berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->telephone_system);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  if (pvalue->telephone_system.count >= 1) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

                  rtxDListAllocNodeAndData (pctxt, Factbook_record_communications_telephone_system_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Factbook_record_communications_telephone_system_element (pdata2);

                  stat = asn1D_Factbook_record_communications_telephone_system_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->telephone_system, pnode);
               }

               if (!((pvalue->telephone_system.count >= 0 && pvalue->telephone_system.
                  count <= 1))) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_communications.telephone_system.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->telephone_system.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;

            while (ilcnt-- > 0) {
               if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
               else return LOG_RTERR (pctxt, ASN_E_INVLEN);
            }}
         }
         break;

      case 3:
         /* decode radio_broadcast_stations */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->radio_broadcast_stations, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode radios */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->radios, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode television_broadcast_stations */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->television_broadcast_stations, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode televisions */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->televisions, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode internet_country_code */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->internet_country_code, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode internet_service_providers */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->internet_service_providers, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 9:
         /* decode internet_users */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->internet_users, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_PRIM|8):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 10) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_communications (OSCTXT* pctxt, 
   Factbook_record_communications* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("telephones_main_lines_in_use"), 28}, 0}, 0 },
      {{{OSUTF8("telephones_mobile_cellular"), 26}, 0}, 1 },
      {{{OSUTF8("telephone_system"), 16}, 0}, 2 },
      {{{OSUTF8("radio_broadcast_stations"), 24}, 0}, 3 },
      {{{OSUTF8("radios"), 6}, 0}, 4 },
      {{{OSUTF8("television_broadcast_stations"), 29}, 0}, 5 },
      {{{OSUTF8("televisions"), 11}, 0}, 6 },
      {{{OSUTF8("internet_country_code"), 21}, 0}, 7 },
      {{{OSUTF8("internet_service_providers"), 26}, 0}, 8 },
      {{{OSUTF8("internet_users"), 14}, 0}, 9 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 2, -1}, {4, 1, -1}, {5, 1, -1}
      , {6, 1, -1}, {7, 1, -1}, {8, 1, -1}, {9, 1, -1}, {10, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 10; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* telephones_main_lines_in_use */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            telephones_main_lines_in_use);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* telephones_mobile_cellular */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->telephones_mobile_cellular
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* telephone_system */
         { int elemID;
         Factbook_record_communications_telephone_system_element* pdata1;

         static const OSXMLElemIDRec elemtab[] = {
            {{{OSUTF8("general_assessment"), 18}, 0}, 0 }
         } ;

         rtxDListInit (&pvalue->telephone_system);
         for (;;) {
            elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
            if (elemID < 0 || elemID == XML_OK_EOB) break;

            switch (elemID) {
            case 0:
               rtXmlpMarkLastEventActive (pctxt);

               pdata1
                   = rtxMemAllocType (pctxt, Factbook_record_communications_telephone_system_element);

               if (pdata1 == NULL)
                  return LOG_RTERR (pctxt, RTERR_NOMEM);

               asn1Init_Factbook_record_communications_telephone_system_element (
                  pdata1);

               stat = XmlDec_Factbook_record_communications_telephone_system_element 
                  (pctxt, pdata1);
               if (stat != 0) return LOG_RTERR (pctxt, stat);

               rtxDListAppend (pctxt, &pvalue->telephone_system
                  , (void*)pdata1);
               break;

            }
         }

         if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
            stat = 0;
         }
         else return LOG_RTERR (pctxt, elemID);
         }

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* radio_broadcast_stations */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->radio_broadcast_stations
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* radios */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->radios);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 5: { /* television_broadcast_stations */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            television_broadcast_stations);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 6: { /* televisions */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->televisions);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 7: { /* internet_country_code */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->internet_country_code);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 8: { /* internet_service_providers */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->internet_service_providers
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 9: { /* internet_users */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->internet_users);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_transportation_railways                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_transportation_railways (OSCTXT* pctxt, 
   Factbook_record_transportation_railways *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode total */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->total, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode standard_gauge */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->standard_gauge, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode narrow_gauge */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->narrow_gauge, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_transportation_railways (OSCTXT* pctxt, 
   Factbook_record_transportation_railways* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("total"), 5}, 0}, 0 },
      {{{OSUTF8("standard_gauge"), 14}, 0}, 1 },
      {{{OSUTF8("narrow_gauge"), 12}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* total */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->total);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* standard_gauge */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->standard_gauge);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* narrow_gauge */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->narrow_gauge);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_transportation_highways                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_transportation_highways (OSCTXT* pctxt, 
   Factbook_record_transportation_highways *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode total */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->total, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode paved */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->paved, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode unpaved */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->unpaved, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_transportation_highways (OSCTXT* pctxt, 
   Factbook_record_transportation_highways* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("total"), 5}, 0}, 0 },
      {{{OSUTF8("paved"), 5}, 0}, 1 },
      {{{OSUTF8("unpaved"), 7}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* total */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->total);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* paved */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->paved);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* unpaved */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->unpaved);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_transportation_merchant_marine            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_transportation_merchant_marine (
   OSCTXT* pctxt, Factbook_record_transportation_merchant_marine *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode total */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->total, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode ships_by_type */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->ships_by_type, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_transportation_merchant_marine (OSCTXT* pctxt, 
   Factbook_record_transportation_merchant_marine* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("total"), 5}, 0}, 0 },
      {{{OSUTF8("ships_by_type"), 13}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* total */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->total);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* ships_by_type */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->ships_by_type);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_transportation_airports_with_paved_runwa  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_transportation_airports_with_paved_runways_element (
   OSCTXT* pctxt, 
   Factbook_record_transportation_airports_with_paved_runways_element *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode total */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->total, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode length_over_3047_meters */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->length_over_3047_meters, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.length_over_3047_metersPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode length_2438_to_3047_meters */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->length_2438_to_3047_meters, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.length_2438_to_3047_metersPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode length_1524_to_2437_meters */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->length_1524_to_2437_meters, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.length_1524_to_2437_metersPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode length_914_to_1523_meters */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->length_914_to_1523_meters, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.length_914_to_1523_metersPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode length_under_914_meters */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->length_under_914_meters, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.length_under_914_metersPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_transportation_airports_with_paved_runways_element 
   (OSCTXT* pctxt, 
   Factbook_record_transportation_airports_with_paved_runways_element* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("total"), 5}, 0}, 0 },
      {{{OSUTF8("length_over_3047_meters"), 23}, 0}, 1 },
      {{{OSUTF8("length_2438__to_3047_meters"), 27}, 0}, 2 },
      {{{OSUTF8("length_1524__to_2437_meters"), 27}, 0}, 3 },
      {{{OSUTF8("length_914__to_1523_meters"), 26}, 0}, 4 },
      {{{OSUTF8("length_under_914_meters"), 23}, 0}, 5 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 6; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* total */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->total);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* length_over_3047_meters */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->length_over_3047_meters);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.length_over_3047_metersPresent = TRUE;
         break;
      }
      case 2: { /* length_2438__to_3047_meters */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->length_2438_to_3047_meters
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.length_2438_to_3047_metersPresent = TRUE;
         break;
      }
      case 3: { /* length_1524__to_2437_meters */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->length_1524_to_2437_meters
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.length_1524_to_2437_metersPresent = TRUE;
         break;
      }
      case 4: { /* length_914__to_1523_meters */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->length_914_to_1523_meters
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.length_914_to_1523_metersPresent = TRUE;
         break;
      }
      case 5: { /* length_under_914_meters */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->length_under_914_meters);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.length_under_914_metersPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_transportation_airports_with_unpaved_run  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_transportation_airports_with_unpaved_runways_element (
   OSCTXT* pctxt, 
   Factbook_record_transportation_airports_with_unpaved_runways_element *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode total */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->total, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode length_over_3047_meters */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_uint8 (pctxt, &pvalue->length_over_3047_meters, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.length_over_3047_metersPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode length_2438_to_3047_meters */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_uint8 (pctxt, &pvalue->length_2438_to_3047_meters, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.length_2438_to_3047_metersPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode length_1524_to_2437_meters */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->length_1524_to_2437_meters, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.length_1524_to_2437_metersPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode length_914_to_1523_meters */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->length_914_to_1523_meters, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.length_914_to_1523_metersPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode length_under_914_meters */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->length_under_914_meters, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.length_under_914_metersPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_transportation_airports_with_unpaved_runways_element 
   (OSCTXT* pctxt, 
   Factbook_record_transportation_airports_with_unpaved_runways_element* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("total"), 5}, 0}, 0 },
      {{{OSUTF8("length_over_3047_meters"), 23}, 0}, 1 },
      {{{OSUTF8("length_2438__to_3047_meters"), 27}, 0}, 2 },
      {{{OSUTF8("length_1524__to_2437_meters"), 27}, 0}, 3 },
      {{{OSUTF8("length_914__to_1523_meters"), 26}, 0}, 4 },
      {{{OSUTF8("length_under_914_meters"), 23}, 0}, 5 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 6; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* total */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->total);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* length_over_3047_meters */
         stat = rtXmlpDecUInt8 (pctxt, &pvalue->length_over_3047_meters);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.length_over_3047_metersPresent = TRUE;
         break;
      }
      case 2: { /* length_2438__to_3047_meters */
         stat = rtXmlpDecUInt8 (pctxt, &pvalue->length_2438_to_3047_meters);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.length_2438_to_3047_metersPresent = TRUE;
         break;
      }
      case 3: { /* length_1524__to_2437_meters */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->length_1524_to_2437_meters
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.length_1524_to_2437_metersPresent = TRUE;
         break;
      }
      case 4: { /* length_914__to_1523_meters */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->length_914_to_1523_meters
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.length_914_to_1523_metersPresent = TRUE;
         break;
      }
      case 5: { /* length_under_914_meters */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->length_under_914_meters);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.length_under_914_metersPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_transportation                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_transportation (OSCTXT* pctxt, 
   Factbook_record_transportation *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode railways */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_transportation_railways (pctxt, 
               &pvalue->railways, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode highways */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_transportation_highways (pctxt, 
               &pvalue->highways, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode waterways */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->waterways, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode pipelines */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->pipelines, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode ports_and_harbors */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->ports_and_harbors, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode merchant_marine */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_transportation_merchant_marine (pctxt, 
               &pvalue->merchant_marine, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode airports */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->airports, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode airports_with_paved_runways */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            { int ilcnt = 0, length;
            tagging = ASN1IMPL;
            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Factbook_record_transportation_airports_with_paved_runways_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               if (XD_PEEKTAG (pctxt, 0xa0)) {
                  stat = xd_Tag1AndLen (pctxt, &length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);
               }
               else return LOG_RTERR (pctxt,
                  berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->airports_with_paved_runways);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  if (pvalue->airports_with_paved_runways.count >= 1) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

                  rtxDListAllocNodeAndData (pctxt, Factbook_record_transportation_airports_with_paved_runways_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Factbook_record_transportation_airports_with_paved_runways_element (pdata2);

                  stat = asn1D_Factbook_record_transportation_airports_with_paved_runways_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->airports_with_paved_runways, pnode);
               }

               if (!((pvalue->airports_with_paved_runways.count >= 0 && pvalue->
                  airports_with_paved_runways.count <= 1))) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_transportation.airports_with_paved_runways.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->airports_with_paved_runways.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;

            while (ilcnt-- > 0) {
               if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
               else return LOG_RTERR (pctxt, ASN_E_INVLEN);
            }}
         }
         break;

      case 8:
         /* decode airports_with_unpaved_runways */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            { int ilcnt = 0, length;
            tagging = ASN1IMPL;
            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Factbook_record_transportation_airports_with_unpaved_runways_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               if (XD_PEEKTAG (pctxt, 0xa0)) {
                  stat = xd_Tag1AndLen (pctxt, &length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);
               }
               else return LOG_RTERR (pctxt,
                  berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->airports_with_unpaved_runways);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  if (pvalue->airports_with_unpaved_runways.count >= 1) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

                  rtxDListAllocNodeAndData (pctxt, Factbook_record_transportation_airports_with_unpaved_runways_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Factbook_record_transportation_airports_with_unpaved_runways_element (pdata2);

                  stat = asn1D_Factbook_record_transportation_airports_with_unpaved_runways_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->airports_with_unpaved_runways, pnode);
               }

               if (!((pvalue->airports_with_unpaved_runways.count >= 0 && pvalue->
                  airports_with_unpaved_runways.count <= 1))) {
                  rtxErrAddStrParm (pctxt, "Factbook_record_transportation.airports_with_unpaved_runways.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->airports_with_unpaved_runways.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;

            while (ilcnt-- > 0) {
               if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
               else return LOG_RTERR (pctxt, ASN_E_INVLEN);
            }}
         }
         break;

      case 9:
         /* decode heliports */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->heliports, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_PRIM|9):
         case (TM_CTXT|TM_CONS|9):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 10) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_transportation (OSCTXT* pctxt, 
   Factbook_record_transportation* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("railways"), 8}, 0}, 0 },
      {{{OSUTF8("highways"), 8}, 0}, 1 },
      {{{OSUTF8("waterways"), 9}, 0}, 2 },
      {{{OSUTF8("pipelines"), 9}, 0}, 3 },
      {{{OSUTF8("ports_and_harbors"), 17}, 0}, 4 },
      {{{OSUTF8("merchant_marine"), 15}, 0}, 5 },
      {{{OSUTF8("airports"), 8}, 0}, 6 },
      {{{OSUTF8("airports_with_paved_runways"), 27}, 0}, 7 },
      {{{OSUTF8("airports_with_unpaved_runways"), 29}, 0}, 8 },
      {{{OSUTF8("heliports"), 9}, 0}, 9 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}
      , {5, 1, -1}, {6, 1, -1}, {7, 3, -1}, {10, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 10; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* railways */
         stat = XmlDec_Factbook_record_transportation_railways (pctxt, &pvalue
            ->railways);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* highways */
         stat = XmlDec_Factbook_record_transportation_highways (pctxt, &pvalue
            ->highways);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* waterways */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->waterways);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* pipelines */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->pipelines);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* ports_and_harbors */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->ports_and_harbors);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 5: { /* merchant_marine */
         stat = XmlDec_Factbook_record_transportation_merchant_marine (pctxt, &
            pvalue->merchant_marine);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 6: { /* airports */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->airports);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 7: { /* airports_with_paved_runways */
         { int elemID;
         Factbook_record_transportation_airports_with_paved_runways_element* pdata1;

         static const OSXMLElemIDRec elemtab[] = {
            {{{OSUTF8("total"), 5}, 0}, 0 }
         } ;

         rtxDListInit (&pvalue->airports_with_paved_runways);
         for (;;) {
            elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
            if (elemID < 0 || elemID == XML_OK_EOB) break;

            switch (elemID) {
            case 0:
               rtXmlpMarkLastEventActive (pctxt);

               pdata1
                   = rtxMemAllocType (pctxt, Factbook_record_transportation_airports_with_paved_runways_element);

               if (pdata1 == NULL)
                  return LOG_RTERR (pctxt, RTERR_NOMEM);

               asn1Init_Factbook_record_transportation_airports_with_paved_runways_element (
                  pdata1);

               stat = XmlDec_Factbook_record_transportation_airports_with_paved_runways_element 
                  (pctxt, pdata1);
               if (stat != 0) return LOG_RTERR (pctxt, stat);

               rtxDListAppend (pctxt, &pvalue->airports_with_paved_runways
                  , (void*)pdata1);
               break;

            }
         }

         if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
            stat = 0;
         }
         else return LOG_RTERR (pctxt, elemID);
         }

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 8: { /* airports_with_unpaved_runways */
         { int elemID;
         Factbook_record_transportation_airports_with_unpaved_runways_element* pdata1;

         static const OSXMLElemIDRec elemtab[] = {
            {{{OSUTF8("total"), 5}, 0}, 0 }
         } ;

         rtxDListInit (&pvalue->airports_with_unpaved_runways);
         for (;;) {
            elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
            if (elemID < 0 || elemID == XML_OK_EOB) break;

            switch (elemID) {
            case 0:
               rtXmlpMarkLastEventActive (pctxt);

               pdata1
                   = rtxMemAllocType (pctxt, Factbook_record_transportation_airports_with_unpaved_runways_element);

               if (pdata1 == NULL)
                  return LOG_RTERR (pctxt, RTERR_NOMEM);

               asn1Init_Factbook_record_transportation_airports_with_unpaved_runways_element (
                  pdata1);

               stat = XmlDec_Factbook_record_transportation_airports_with_unpaved_runways_element 
                  (pctxt, pdata1);
               if (stat != 0) return LOG_RTERR (pctxt, stat);

               rtxDListAppend (pctxt, &pvalue->airports_with_unpaved_runways
                  , (void*)pdata1);
               break;

            }
         }

         if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
            stat = 0;
         }
         else return LOG_RTERR (pctxt, elemID);
         }

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 9: { /* heliports */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->heliports);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_military                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_military (OSCTXT* pctxt, 
   Factbook_record_military *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode military_branches */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->military_branches, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode military_age */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->military_age, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode military_availability */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->military_availability, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode fit_for_military_service */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->fit_for_military_service, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode reaching_military_age_annually */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->reaching_military_age_annually, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode military_expenditure_dollar_figure */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->military_expenditure_dollar_figure, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode military_expenditures_percent_GDP */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->military_expenditures_percent_GDP, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|6):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 7) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_military (OSCTXT* pctxt, 
   Factbook_record_military* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("military_branches"), 17}, 0}, 0 },
      {{{OSUTF8("military_age"), 12}, 0}, 1 },
      {{{OSUTF8("military_availability"), 21}, 0}, 2 },
      {{{OSUTF8("fit_for_military_service"), 24}, 0}, 3 },
      {{{OSUTF8("reaching_military_age_annually"), 30}, 0}, 4 },
      {{{OSUTF8("military_expenditure_dollar_figure"), 34}, 0}, 5 },
      {{{OSUTF8("military_expenditures_percent_GDP"), 33}, 0}, 6 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}
      , {5, 1, -1}, {6, 1, -1}, {7, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 7; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* military_branches */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->military_branches);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* military_age */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->military_age);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* military_availability */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->military_availability);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* fit_for_military_service */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->fit_for_military_service
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* reaching_military_age_annually */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            reaching_military_age_annually);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 5: { /* military_expenditure_dollar_figure */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            military_expenditure_dollar_figure);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 6: { /* military_expenditures_percent_GDP */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->
            military_expenditures_percent_GDP);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record_transnational_disputes_element            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record_transnational_disputes_element (
   OSCTXT* pctxt, Factbook_record_transnational_disputes_element *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode international_disputes */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->international_disputes, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode illicit_drugs */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->illicit_drugs, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record_transnational_disputes_element (OSCTXT* pctxt, 
   Factbook_record_transnational_disputes_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("international_disputes"), 22}, 0}, 0 },
      {{{OSUTF8("illicit_drugs"), 13}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* international_disputes */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->international_disputes);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* illicit_drugs */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->illicit_drugs);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook_record                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook_record (OSCTXT* pctxt, Factbook_record *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode country */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->country, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode introduction */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            { int ilcnt = 0, length;
            if (XD_PEEKTAG (pctxt, 0x80)) {
               stat = xd_Tag1AndLen (pctxt, &length);
               if (stat != 0) return LOG_RTERR (pctxt, stat);
            }
            else return LOG_RTERR (pctxt,
               berErrUnexpTag(pctxt, TM_CTXT|TM_PRIM|0));

            stat = xd_utf8str (pctxt, &pvalue->introduction, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;

            while (ilcnt-- > 0) {
               if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
               else return LOG_RTERR (pctxt, ASN_E_INVLEN);
            }}
         }
         break;

      case 2:
         /* decode geography */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_geography (pctxt, 
               &pvalue->geography, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode people */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_people (pctxt, 
               &pvalue->people, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode government */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_government (pctxt, 
               &pvalue->government, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode economy */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_economy (pctxt, 
               &pvalue->economy, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode communications */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_communications (pctxt, 
               &pvalue->communications, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode transportation */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_transportation (pctxt, 
               &pvalue->transportation, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode military */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_Factbook_record_military (pctxt, 
               &pvalue->military, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 9:
         /* decode transnational_disputes */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            { int ilcnt = 0, length;
            tagging = ASN1IMPL;
            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               Factbook_record_transnational_disputes_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               if (XD_PEEKTAG (pctxt, 0xa0)) {
                  stat = xd_Tag1AndLen (pctxt, &length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);
               }
               else return LOG_RTERR (pctxt,
                  berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->transnational_disputes);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  if (pvalue->transnational_disputes.count >= 1) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

                  rtxDListAllocNodeAndData (pctxt, Factbook_record_transnational_disputes_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_Factbook_record_transnational_disputes_element (pdata2);

                  stat = asn1D_Factbook_record_transnational_disputes_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->transnational_disputes, pnode);
               }

               if (!((pvalue->transnational_disputes.count >= 0 && pvalue->
                  transnational_disputes.count <= 1))) {
                  rtxErrAddStrParm (pctxt, "Factbook_record.transnational_disputes.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->transnational_disputes.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;

            while (ilcnt-- > 0) {
               if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
               else return LOG_RTERR (pctxt, ASN_E_INVLEN);
            }}
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_CONS|9):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 10) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_Factbook_record (OSCTXT* pctxt, Factbook_record* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("country"), 7}, 0}, 0 },
      {{{OSUTF8("introduction"), 12}, 0}, 1 },
      {{{OSUTF8("geography"), 9}, 0}, 2 },
      {{{OSUTF8("people"), 6}, 0}, 3 },
      {{{OSUTF8("government"), 10}, 0}, 4 },
      {{{OSUTF8("economy"), 7}, 0}, 5 },
      {{{OSUTF8("communications"), 14}, 0}, 6 },
      {{{OSUTF8("transportation"), 14}, 0}, 7 },
      {{{OSUTF8("military"), 8}, 0}, 8 },
      {{{OSUTF8("transnational_disputes"), 22}, 0}, 9 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}
      , {5, 1, -1}, {6, 1, -1}, {7, 1, -1}, {8, 1, -1}, {9, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 10; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* country */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->country);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* introduction */
         stat = rtXmlpMatchStartTag (pctxt, OSUTF8("background"), 0);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->introduction);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* geography */
         stat = XmlDec_Factbook_record_geography (pctxt, &pvalue->geography);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* people */
         stat = XmlDec_Factbook_record_people (pctxt, &pvalue->people);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* government */
         stat = XmlDec_Factbook_record_government (pctxt, &pvalue->government
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 5: { /* economy */
         stat = XmlDec_Factbook_record_economy (pctxt, &pvalue->economy);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 6: { /* communications */
         stat = XmlDec_Factbook_record_communications (pctxt, &pvalue->
            communications);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 7: { /* transportation */
         stat = XmlDec_Factbook_record_transportation (pctxt, &pvalue->
            transportation);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 8: { /* military */
         stat = XmlDec_Factbook_record_military (pctxt, &pvalue->military);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 9: { /* transnational_disputes */
         { int elemID;
         Factbook_record_transnational_disputes_element* pdata1;

         static const OSXMLElemIDRec elemtab[] = {
            {{{OSUTF8("international_disputes"), 22}, 0}, 0 }
         } ;

         rtxDListInit (&pvalue->transnational_disputes);
         for (;;) {
            elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
            if (elemID < 0 || elemID == XML_OK_EOB) break;

            switch (elemID) {
            case 0:
               rtXmlpMarkLastEventActive (pctxt);

               pdata1
                   = rtxMemAllocType (pctxt, Factbook_record_transnational_disputes_element);

               if (pdata1 == NULL)
                  return LOG_RTERR (pctxt, RTERR_NOMEM);

               asn1Init_Factbook_record_transnational_disputes_element (pdata1
                  );

               stat = XmlDec_Factbook_record_transnational_disputes_element 
                  (pctxt, pdata1);
               if (stat != 0) return LOG_RTERR (pctxt, stat);

               rtxDListAppend (pctxt, &pvalue->transnational_disputes
                  , (void*)pdata1);
               break;

            }
         }

         if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
            stat = 0;
         }
         else return LOG_RTERR (pctxt, elemID);
         }

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Factbook                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Factbook (OSCTXT* pctxt, Factbook *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   Factbook_record* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, Factbook_record, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_Factbook_record (pdata1);

      stat = asn1D_Factbook_record (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   if (!(pvalue->count >= 1U)) {
      rtxErrAddStrParm (pctxt, "Factbook.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

int XmlDec_Factbook (OSCTXT* pctxt, Factbook* pvalue)
{
   int stat = 0;

   { int elemID;
   Factbook_record* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("record"), 6}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* record */
         pdata1 = rtxMemAllocType (pctxt, Factbook_record);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_Factbook_record (pdata1);

         stat = XmlDec_Factbook_record (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

int XmlDec_Factbook_PDU (OSCTXT* pctxt, Factbook* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_Factbook (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("factbook"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_Factbook (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
