/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "Datastore.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  DataType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DataType (OSCTXT* pctxt, DataType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode stringT */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->stringT, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.stringTPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode integerT */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_integer (pctxt, &pvalue->integerT, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.integerTPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode binaryT */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_octstr (pctxt, &pvalue->binaryT.data, &pvalue->binaryT.numocts, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.binaryTPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode booleanT */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->booleanT, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.booleanTPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_DataType (OSCTXT* pctxt, DataType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("stringT"), 7}, 0}, 0 },
      {{{OSUTF8("integerT"), 8}, 0}, 1 },
      {{{OSUTF8("binaryT"), 7}, 0}, 2 },
      {{{OSUTF8("booleanT"), 8}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* stringT */
         stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->stringT);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.stringTPresent = TRUE;
         break;
      }
      case 1: { /* integerT */
         stat = rtXmlpDecInt (pctxt, &pvalue->integerT);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.integerTPresent = TRUE;
         break;
      }
      case 2: { /* binaryT */
         stat = rtXmlpDecDynBase64Str (pctxt, &pvalue->binaryT);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.binaryTPresent = TRUE;
         break;
      }
      case 3: { /* booleanT */
         stat = rtXmlpDecBool (pctxt, &pvalue->booleanT);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.booleanTPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataStoreType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DataStoreType (OSCTXT* pctxt, DataStoreType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   DataType* pdata1;
   OSRTDListNode* pnode;
   ASN1CCB ccb;

   if (XD_PEEKTAG (pctxt, 0x30)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_UNIV|TM_CONS|16));

   if (XD_PEEKTAG (pctxt, 0xa0)) {
      stat = xd_Tag1AndLen (pctxt, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   else return LOG_RTERR (pctxt,
      berErrUnexpTag(pctxt, TM_CTXT|TM_CONS|0));

   /* decode SEQUENCE OF or SET OF */

   rtxDListInit (pvalue);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      rtxDListAllocNodeAndData (pctxt, DataType, &pnode, &pdata1);

      if (pnode == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_DataType (pdata1);

      stat = asn1D_DataType (pctxt, 
         pdata1, ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      rtxDListAppendNode (pvalue, pnode);
   }

   return (stat);
}

int XmlDec_DataStoreType (OSCTXT* pctxt, DataStoreType* pvalue)
{
   int stat = 0;

   { int elemID;
   DataType* pdata1;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("data"), 4}, 0}, 0 }
   } ;

   rtxDListInit (pvalue);
   for (;;) {
      elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, FALSE);
      if (elemID < 0 || elemID == XML_OK_EOB) break;

      switch (elemID) {
      case 0: /* data */
         pdata1 = rtxMemAllocType (pctxt, DataType);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_DataType (pdata1);

         stat = XmlDec_DataType (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue, (void*)pdata1);
         break;

      }
   }

   if (elemID == RTERR_UNEXPELEM || elemID == XML_OK_EOB) {
      stat = 0;
   }
   else return LOG_RTERR (pctxt, elemID);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataStore                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DataStore (OSCTXT* pctxt, DataStore *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DataStoreType (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_DataStore (OSCTXT* pctxt, DataStore* pvalue)
{
   int stat = 0;

   stat = XmlDec_DataStoreType (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_DataStore_PDU (OSCTXT* pctxt, DataStore* pvalue)
{
   int stat;

   rtXmlpCreateReader (pctxt);

   asn1Init_DataStore (pvalue);

   stat = rtXmlpMatchStartTag (pctxt, OSUTF8("dataStore"), 0);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   stat = XmlDec_DataStore (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlpMatchEndTag (pctxt, -1);
   if (stat < 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
