/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "AVCL.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  NonNegativeScalarType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_NonNegativeScalarType (OSCTXT* pctxt,
   NonNegativeScalarType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_real (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_NonNegativeScalarType (OSCTXT* pctxt, NonNegativeScalarType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncDouble (pctxt, value, elemName, nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AvclMessageType_transportStatus                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AvclMessageType_transportStatus (OSCTXT* pctxt,
   AvclMessageType_transportStatus *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_AvclMessageType_transportStatus (OSCTXT* pctxt, 
   AvclMessageType_transportStatus value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      AvclMessageType_transportStatus_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MetaDataType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MetaDataType (OSCTXT* pctxt,
   MetaDataType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode name */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_utf8str (pctxt, pvalue->name, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode content */

   if (pvalue->m.contentPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->content, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_MetaDataType (OSCTXT* pctxt, MetaDataType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.contentPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" content=\""), 10);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->content, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" name=\""), 7);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->name, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PriorityType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PriorityType (OSCTXT* pctxt,
   PriorityType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_uint8 (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_PriorityType (OSCTXT* pctxt, PriorityType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUInt (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PriorityElementType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PriorityElementType (OSCTXT* pctxt,
   PriorityElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_PriorityType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_PriorityElementType (OSCTXT* pctxt, PriorityElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   stat = XmlEnc_PriorityType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonNegativeIntegerElementType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_NonNegativeIntegerElementType (OSCTXT* pctxt,
   NonNegativeIntegerElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_uint16 (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_NonNegativeIntegerElementType (OSCTXT* pctxt, 
   NonNegativeIntegerElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   stat = rtXmlEncUIntAttr
      (pctxt, pvalue->value, OSUTF8("value"), 5);

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AcknowledgeType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AcknowledgeType (OSCTXT* pctxt,
   AcknowledgeType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 4)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_AcknowledgeType (OSCTXT* pctxt, AcknowledgeType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      AcknowledgeType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AcknowledgeElementType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AcknowledgeElementType (OSCTXT* pctxt,
   AcknowledgeElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   if(pvalue->value < 0 || pvalue->value > 4)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_AcknowledgeType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AcknowledgeElementType (OSCTXT* pctxt, 
   AcknowledgeElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   if(pvalue->value < 0 || pvalue->value > 4)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_AcknowledgeType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AvclMessageHeadType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AvclMessageHeadType (OSCTXT* pctxt,
   AvclMessageHeadType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode acknowledge */

   if (pvalue->m.acknowledgePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_AcknowledgeElementType (pctxt, &pvalue->acknowledge, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode recipient_list */

   pnode2 = pvalue->recipient_list.tail;
   while (0 != pnode2) {
      ll = asn1E_NonNegativeIntegerElementType (pctxt, ((NonNegativeIntegerElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode sender */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
      asn1E_NonNegativeIntegerElementType (pctxt, &pvalue->sender, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode priority */

   if (pvalue->m.priorityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
         asn1E_PriorityElementType (pctxt, &pvalue->priority, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode meta_list */

   pnode2 = pvalue->meta_list.tail;
   while (0 != pnode2) {
      ll = asn1E_MetaDataType (pctxt, ((MetaDataType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AvclMessageHeadType (OSCTXT* pctxt, AvclMessageHeadType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* encode meta_list */

   { OSRTDListNode* pnode = pvalue->meta_list.head;
   while (0 != pnode) {
      stat = XmlEnc_MetaDataType (pctxt, ((MetaDataType*)pnode->data)
         , OSUTF8("meta"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode priority */

   if (pvalue->m.priorityPresent) {
      stat = XmlEnc_PriorityElementType (pctxt, &pvalue->priority
         , OSUTF8("Priority"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode sender */

   stat = XmlEnc_NonNegativeIntegerElementType (pctxt, &pvalue->sender
      , OSUTF8("Sender"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode recipient_list */

   { OSRTDListNode* pnode = pvalue->recipient_list.head;
   while (0 != pnode) {
      stat = XmlEnc_NonNegativeIntegerElementType (pctxt, 
         ((NonNegativeIntegerElementType*)pnode->data)
         , OSUTF8("Recipient"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode acknowledge */

   if (pvalue->m.acknowledgePresent) {
      stat = XmlEnc_AcknowledgeElementType (pctxt, &pvalue->acknowledge
         , OSUTF8("Acknowledge"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LatitudeType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_LatitudeType (OSCTXT* pctxt,
   LatitudeType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_real (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_LatitudeType (OSCTXT* pctxt, LatitudeType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncDouble (pctxt, value, elemName, nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LongitudeType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_LongitudeType (OSCTXT* pctxt,
   LongitudeType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_real (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_LongitudeType (OSCTXT* pctxt, LongitudeType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncDouble (pctxt, value, elemName, nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LatitudeLongitudeElementType                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_LatitudeLongitudeElementType (OSCTXT* pctxt,
   LatitudeLongitudeElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode longitude */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_LongitudeType (pctxt, &pvalue->longitude, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode latitude */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_LatitudeType (pctxt, &pvalue->latitude, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_LatitudeLongitudeElementType (OSCTXT* pctxt, 
   LatitudeLongitudeElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" latitude=\""), 11);

   stat = XmlEnc_LatitudeType (pctxt, pvalue->latitude, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" longitude=\""), 12);

   stat = XmlEnc_LongitudeType (pctxt, pvalue->longitude, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PositiveScalarType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PositiveScalarType (OSCTXT* pctxt,
   PositiveScalarType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_real (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_PositiveScalarType (OSCTXT* pctxt, PositiveScalarType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncDouble (pctxt, value, elemName, nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GeoOriginElementType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_GeoOriginElementType (OSCTXT* pctxt,
   GeoOriginElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode radiusOfInterest */

   if (pvalue->m.radiusOfInterestPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_PositiveScalarType (pctxt, &pvalue->radiusOfInterest, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode longitude */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_LongitudeType (pctxt, &pvalue->longitude, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode latitude */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_LatitudeType (pctxt, &pvalue->latitude, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_GeoOriginElementType (OSCTXT* pctxt, GeoOriginElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" latitude=\""), 11);

   stat = XmlEnc_LatitudeType (pctxt, pvalue->latitude, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" longitude=\""), 12);

   stat = XmlEnc_LongitudeType (pctxt, pvalue->longitude, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.radiusOfInterestPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" radiusOfInterest=\""), 19);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->radiusOfInterest
         , 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LatitudeLongitudeElementType_derivations                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_LatitudeLongitudeElementType_derivations (OSCTXT* pctxt,
   LatitudeLongitudeElementType_derivations *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_LatitudeLongitudeElementType (pctxt, pvalue->u.latitudeLongitudeElementType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_GeoOriginElementType (pctxt, pvalue->u.geoOriginElementType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_LatitudeLongitudeElementType_derivations (OSCTXT* pctxt, 
   LatitudeLongitudeElementType_derivations* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   switch (pvalue->t)
   {
      case 1:
         /* encode latitudeLongitudeElementType */

         stat = XmlEnc_LatitudeLongitudeElementType (pctxt, pvalue->
            u.latitudeLongitudeElementType, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode geoOriginElementType */

         stat = XmlEnc_GeoOriginElementType (pctxt, pvalue->
            u.geoOriginElementType, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  XyElementType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_XyElementType (OSCTXT* pctxt,
   XyElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode y */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_real (pctxt, &pvalue->y, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode x */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_real (pctxt, &pvalue->x, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_XyElementType (OSCTXT* pctxt, XyElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" x=\""), 4);

   stat = rtXmlEncDouble (pctxt, pvalue->x, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" y=\""), 4);

   stat = rtXmlEncDouble (pctxt, pvalue->y, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PointListElements                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PointListElements (OSCTXT* pctxt,
   PointListElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         if (!(pvalue->u.latitudeLongitude_list->count >= 1U)) {
            rtxErrAddStrParm (pctxt, "PointListElements.u.latitudeLongitude_list.count");
            rtxErrAddIntParm (pctxt, (int)pvalue->u.latitudeLongitude_list->count);
            return LOG_RTERR (pctxt, RTERR_CONSVIO);
         }

         pnode2 = pvalue->u.latitudeLongitude_list->tail;
         while (0 != pnode2) {
            ll = asn1E_LatitudeLongitudeElementType_derivations (pctxt, ((LatitudeLongitudeElementType_derivations*)pnode2->data), ASN1EXPL);
            if (ll < 0) return LOG_RTERR (pctxt, ll);
            ll2 += ll;

            pnode2 = pnode2->prev;
         }
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         else { ll1 += ll; ll2 = 0; }
         break;

      case 2:
         if (!(pvalue->u.xYPosition_list->count >= 1U)) {
            rtxErrAddStrParm (pctxt, "PointListElements.u.xYPosition_list.count");
            rtxErrAddIntParm (pctxt, (int)pvalue->u.xYPosition_list->count);
            return LOG_RTERR (pctxt, RTERR_CONSVIO);
         }

         pnode2 = pvalue->u.xYPosition_list->tail;
         while (0 != pnode2) {
            ll = asn1E_XyElementType (pctxt, ((XyElementType*)pnode2->data), ASN1EXPL);
            if (ll < 0) return LOG_RTERR (pctxt, ll);
            ll2 += ll;

            pnode2 = pnode2->prev;
         }
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1, ll2);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         else { ll1 += ll; ll2 = 0; }
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_PointListElements (OSCTXT* pctxt, PointListElements* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode latitudeLongitude_list */

         if (!(pvalue->u.latitudeLongitude_list->count >= 1U)) {
            rtxErrAddStrParm (pctxt, "PointListElements.u.latitudeLongitude_list.count");
            rtxErrAddIntParm (pctxt, (int)pvalue->u.latitudeLongitude_list->
               count);
            return LOG_RTERR (pctxt, RTERR_CONSVIO);
         }

         { OSRTDListNode* pnode = pvalue->u.latitudeLongitude_list->head;
         while (0 != pnode) {
            stat = XmlEnc_LatitudeLongitudeElementType_derivations (pctxt, 
               ((LatitudeLongitudeElementType_derivations*)pnode->data)
               , OSUTF8("LatitudeLongitude"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
            pnode = pnode->next;
         }}

         break;

      case 2:
         /* encode xYPosition_list */

         if (!(pvalue->u.xYPosition_list->count >= 1U)) {
            rtxErrAddStrParm (pctxt, "PointListElements.u.xYPosition_list.count");
            rtxErrAddIntParm (pctxt, (int)pvalue->u.xYPosition_list->count);
            return LOG_RTERR (pctxt, RTERR_CONSVIO);
         }

         { OSRTDListNode* pnode = pvalue->u.xYPosition_list->head;
         while (0 != pnode) {
            stat = XmlEnc_XyElementType (pctxt, ((XyElementType*)pnode->data)
               , OSUTF8("XYPosition"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
            pnode = pnode->next;
         }}

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  WaypointListType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_WaypointListType (OSCTXT* pctxt,
   WaypointListType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_PointListElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_WaypointListType (OSCTXT* pctxt, WaypointListType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_PointListElements (pctxt, &pvalue->choice, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TurnDirectionType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TurnDirectionType (OSCTXT* pctxt,
   TurnDirectionType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_TurnDirectionType (OSCTXT* pctxt, TurnDirectionType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      TurnDirectionType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HeadingType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_HeadingType (OSCTXT* pctxt,
   HeadingType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_real (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_HeadingType (OSCTXT* pctxt, HeadingType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncDouble (pctxt, value, elemName, nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PositiveIntType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PositiveIntType (OSCTXT* pctxt,
   PositiveIntType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if (!(*pvalue >= 0)) {
      rtxErrAddStrParm (pctxt, "PositiveIntType");
      rtxErrAddIntParm (pctxt, *pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   ll = xe_integer (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_PositiveIntType (OSCTXT* pctxt, PositiveIntType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (!(value >= 0)) {
      rtxErrAddStrParm (pctxt, "PositiveIntType");
      rtxErrAddIntParm (pctxt, value);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   stat = rtXmlEncInt (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HorizontalPositionElements                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_HorizontalPositionElements (OSCTXT* pctxt,
   HorizontalPositionElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_LatitudeLongitudeElementType_derivations (pctxt, pvalue->u.latitudeLongitude, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_XyElementType (pctxt, pvalue->u.xYPosition, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_XyElementType (pctxt, pvalue->u.relativeXYPosition, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_HorizontalPositionElements (OSCTXT* pctxt, 
   HorizontalPositionElements* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode latitudeLongitude */

         stat = XmlEnc_LatitudeLongitudeElementType_derivations (pctxt, pvalue
            ->u.latitudeLongitude, OSUTF8("LatitudeLongitude"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode xYPosition */

         stat = XmlEnc_XyElementType (pctxt, pvalue->u.xYPosition
            , OSUTF8("XYPosition"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode relativeXYPosition */

         stat = XmlEnc_XyElementType (pctxt, pvalue->u.relativeXYPosition
            , OSUTF8("RelativeXYPosition"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HorizontalPositionElementType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_HorizontalPositionElementType (OSCTXT* pctxt,
   HorizontalPositionElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_HorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_HorizontalPositionElementType (OSCTXT* pctxt, 
   HorizontalPositionElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_HorizontalPositionElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ParallelTrackType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ParallelTrackType (OSCTXT* pctxt,
   ParallelTrackType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode startPoint */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
      asn1E_HorizontalPositionElementType (pctxt, &pvalue->startPoint, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode trackSpacing */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
      asn1E_PositiveScalarType (pctxt, &pvalue->trackSpacing, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode trackLength */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
      asn1E_PositiveScalarType (pctxt, &pvalue->trackLength, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode trackCount */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
      asn1E_PositiveIntType (pctxt, &pvalue->trackCount, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode orientation */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_HeadingType (pctxt, &pvalue->orientation, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode firstTurn */

   if(pvalue->firstTurn < 0 || pvalue->firstTurn > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      asn1E_TurnDirectionType (pctxt, &pvalue->firstTurn, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ParallelTrackType (OSCTXT* pctxt, ParallelTrackType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" firstTurn=\""), 12);

   if(pvalue->firstTurn < 0 || pvalue->firstTurn > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_TurnDirectionType (pctxt, pvalue->firstTurn, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" orientation=\""), 14);

   stat = XmlEnc_HeadingType (pctxt, pvalue->orientation, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" trackCount=\""), 13);

   stat = XmlEnc_PositiveIntType (pctxt, pvalue->trackCount, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" trackLength=\""), 14);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->trackLength, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" trackSpacing=\""), 15);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->trackSpacing, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode startPoint */

   stat = XmlEnc_HorizontalPositionElementType (pctxt, &pvalue->startPoint
      , OSUTF8("StartPoint"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SectorPatternType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SectorPatternType (OSCTXT* pctxt,
   SectorPatternType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode startPoint */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
      asn1E_HorizontalPositionElementType (pctxt, &pvalue->startPoint, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode sectorSize */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
      asn1E_PositiveScalarType (pctxt, &pvalue->sectorSize, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode sectorCount */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
      asn1E_PositiveIntType (pctxt, &pvalue->sectorCount, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode radius */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      asn1E_PositiveScalarType (pctxt, &pvalue->radius, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode orientation */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_HeadingType (pctxt, &pvalue->orientation, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode firstTurn */

   if(pvalue->firstTurn < 0 || pvalue->firstTurn > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      asn1E_TurnDirectionType (pctxt, &pvalue->firstTurn, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SectorPatternType (OSCTXT* pctxt, SectorPatternType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" firstTurn=\""), 12);

   if(pvalue->firstTurn < 0 || pvalue->firstTurn > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_TurnDirectionType (pctxt, pvalue->firstTurn, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" orientation=\""), 14);

   stat = XmlEnc_HeadingType (pctxt, pvalue->orientation, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" radius=\""), 9);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->radius, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" sectorCount=\""), 14);

   stat = XmlEnc_PositiveIntType (pctxt, pvalue->sectorCount, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" sectorSize=\""), 13);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->sectorSize, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode startPoint */

   stat = XmlEnc_HorizontalPositionElementType (pctxt, &pvalue->startPoint
      , OSUTF8("StartPoint"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExpandingSquareType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ExpandingSquareType (OSCTXT* pctxt,
   ExpandingSquareType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode startPoint */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
      asn1E_HorizontalPositionElementType (pctxt, &pvalue->startPoint, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode turnDirection */

   if(pvalue->turnDirection < 0 || pvalue->turnDirection > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
      asn1E_TurnDirectionType (pctxt, &pvalue->turnDirection, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode trackSpacing */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
      asn1E_PositiveScalarType (pctxt, &pvalue->trackSpacing, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode trackCount */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      asn1E_PositiveIntType (pctxt, &pvalue->trackCount, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode orientation */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_HeadingType (pctxt, &pvalue->orientation, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ExpandingSquareType (OSCTXT* pctxt, ExpandingSquareType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" orientation=\""), 14);

   stat = XmlEnc_HeadingType (pctxt, pvalue->orientation, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" trackCount=\""), 13);

   stat = XmlEnc_PositiveIntType (pctxt, pvalue->trackCount, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" trackSpacing=\""), 15);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->trackSpacing, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" turnDirection=\""), 16);

   if(pvalue->turnDirection < 0 || pvalue->turnDirection > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_TurnDirectionType (pctxt, pvalue->turnDirection, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode startPoint */

   stat = XmlEnc_HorizontalPositionElementType (pctxt, &pvalue->startPoint
      , OSUTF8("StartPoint"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CompositeWaypointElements                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_CompositeWaypointElements (OSCTXT* pctxt,
   CompositeWaypointElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_WaypointListType (pctxt, pvalue->u.waypointList, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_ParallelTrackType (pctxt, pvalue->u.parallelTrack, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_SectorPatternType (pctxt, pvalue->u.sectorPattern, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_ExpandingSquareType (pctxt, pvalue->u.expandingSquare, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_CompositeWaypointElements (OSCTXT* pctxt, 
   CompositeWaypointElements* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode waypointList */

         stat = XmlEnc_WaypointListType (pctxt, pvalue->u.waypointList
            , OSUTF8("WaypointList"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode parallelTrack */

         stat = XmlEnc_ParallelTrackType (pctxt, pvalue->u.parallelTrack
            , OSUTF8("ParallelTrack"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode sectorPattern */

         stat = XmlEnc_SectorPatternType (pctxt, pvalue->u.sectorPattern
            , OSUTF8("SectorPattern"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode expandingSquare */

         stat = XmlEnc_ExpandingSquareType (pctxt, pvalue->u.expandingSquare
            , OSUTF8("ExpandingSquare"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PositiveScalarElementType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PositiveScalarElementType (OSCTXT* pctxt,
   PositiveScalarElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_PositiveScalarType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_PositiveScalarElementType (OSCTXT* pctxt, 
   PositiveScalarElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SpeedElementType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SpeedElementType (OSCTXT* pctxt,
   SpeedElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      asn1E_PositiveScalarType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode speedOverGround */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_boolean (pctxt, &pvalue->speedOverGround, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SpeedElementType (OSCTXT* pctxt, SpeedElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   stat = rtXmlEncBoolAttr (pctxt, pvalue->speedOverGround
      , OSUTF8("speedOverGround"), 15);

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PositiveScalarElementType_derivations                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PositiveScalarElementType_derivations (OSCTXT* pctxt,
   PositiveScalarElementType_derivations *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_PositiveScalarElementType (pctxt, pvalue->u.positiveScalarElementType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_SpeedElementType (pctxt, pvalue->u.speedElementType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_PositiveScalarElementType_derivations (OSCTXT* pctxt, 
   PositiveScalarElementType_derivations* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   switch (pvalue->t)
   {
      case 1:
         /* encode positiveScalarElementType */

         stat = XmlEnc_PositiveScalarElementType (pctxt, pvalue->
            u.positiveScalarElementType, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode speedElementType */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.speedElementType
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DepthTypeElements                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DepthTypeElements (OSCTXT* pctxt,
   DepthTypeElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.depth, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.altitude, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_DepthTypeElements (OSCTXT* pctxt, DepthTypeElements* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode depth */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.depth, OSUTF8("Depth"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode altitude */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.altitude, OSUTF8("Altitude"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TrackModeType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TrackModeType (OSCTXT* pctxt,
   TrackModeType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_TrackModeType (OSCTXT* pctxt, TrackModeType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      TrackModeType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TrackModeElementType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TrackModeElementType (OSCTXT* pctxt,
   TrackModeElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   if(pvalue->value < 0 || pvalue->value > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_TrackModeType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TrackModeElementType (OSCTXT* pctxt, TrackModeElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   if(pvalue->value < 0 || pvalue->value > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_TrackModeType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignedPercentType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SignedPercentType (OSCTXT* pctxt,
   SignedPercentType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_real (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_SignedPercentType (OSCTXT* pctxt, SignedPercentType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncDouble (pctxt, value, elemName, nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignedPercentElementType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SignedPercentElementType (OSCTXT* pctxt,
   SignedPercentElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_SignedPercentType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SignedPercentElementType (OSCTXT* pctxt, 
   SignedPercentElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   stat = XmlEnc_SignedPercentType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetPropellerCommandType_choice                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SetPropellerCommandType_choice (OSCTXT* pctxt,
   SetPropellerCommandType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.portPropeller, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.starboardPropeller, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.centerlinePropeller, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.allPropellers, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_SetPropellerCommandType_choice (OSCTXT* pctxt, 
   SetPropellerCommandType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode portPropeller */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.portPropeller
            , OSUTF8("PortPropeller"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode starboardPropeller */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->
            u.starboardPropeller, OSUTF8("StarboardPropeller"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode centerlinePropeller */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->
            u.centerlinePropeller, OSUTF8("CenterlinePropeller"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode allPropellers */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.allPropellers
            , OSUTF8("AllPropellers"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetPropellerCommandType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SetPropellerCommandType (OSCTXT* pctxt,
   SetPropellerCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_SetPropellerCommandType_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SetPropellerCommandType (OSCTXT* pctxt, 
   SetPropellerCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_SetPropellerCommandType_choice (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvSpeedElements                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvSpeedElements (OSCTXT* pctxt,
   UuvSpeedElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_SetPropellerCommandType (pctxt, pvalue->u.setPower, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeKnots, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeSpeed, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_UuvSpeedElements (OSCTXT* pctxt, UuvSpeedElements* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode setPower */

         stat = XmlEnc_SetPropellerCommandType (pctxt, pvalue->u.setPower
            , OSUTF8("SetPower"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode makeKnots */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeKnots
            , OSUTF8("MakeKnots"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode makeSpeed */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeSpeed
            , OSUTF8("MakeSpeed"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PositiveIntegerElementType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PositiveIntegerElementType (OSCTXT* pctxt,
   PositiveIntegerElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_PositiveIntType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_PositiveIntegerElementType (OSCTXT* pctxt, 
   PositiveIntegerElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   stat = XmlEnc_PositiveIntType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvCompositeWaypointCommandType                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvCompositeWaypointCommandType (OSCTXT* pctxt,
   UuvCompositeWaypointCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->standoff, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode gpsFixes */

   if (pvalue->m.gpsFixesPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_PositiveIntegerElementType (pctxt, &pvalue->gpsFixes, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_2 */

   if (pvalue->m.choice_2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_UuvSpeedElements (pctxt, &pvalue->choice_2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_TrackModeElementType (pctxt, &pvalue->homingMode, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
      asn1E_DepthTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_CompositeWaypointElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvCompositeWaypointCommandType (OSCTXT* pctxt, 
   UuvCompositeWaypointCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_CompositeWaypointElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode choice_1 */

   stat = XmlEnc_DepthTypeElements (pctxt, &pvalue->choice_1, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      stat = XmlEnc_TrackModeElementType (pctxt, &pvalue->homingMode
         , OSUTF8("HomingMode"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_2 */

   if (pvalue->m.choice_2Present) {
      stat = XmlEnc_UuvSpeedElements (pctxt, &pvalue->choice_2, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode gpsFixes */

   if (pvalue->m.gpsFixesPresent) {
      stat = XmlEnc_PositiveIntegerElementType (pctxt, &pvalue->gpsFixes
         , OSUTF8("GpsFixes"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         standoff, OSUTF8("Standoff"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  StringElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_StringElementType (OSCTXT* pctxt,
   StringElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_utf8str (pctxt, pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_StringElementType (OSCTXT* pctxt, StringElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FollowBeaconCommandType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_FollowBeaconCommandType (OSCTXT* pctxt,
   FollowBeaconCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode beacon */

   if (pvalue->m.beaconPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_StringElementType (pctxt, &pvalue->beacon, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_FollowBeaconCommandType (OSCTXT* pctxt, 
   FollowBeaconCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode beacon */

   if (pvalue->m.beaconPresent) {
      stat = XmlEnc_StringElementType (pctxt, &pvalue->beacon
         , OSUTF8("Beacon"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GpsFixCommandType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_GpsFixCommandType (OSCTXT* pctxt,
   GpsFixCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_boolean (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_PositiveScalarType (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_GpsFixCommandType (OSCTXT* pctxt, GpsFixCommandType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeOutPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeOut=\""), 10);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->timeOut, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   stat = rtXmlEncBoolAttr (pctxt, pvalue->value, OSUTF8("value"), 5);

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NoValueElementType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_NoValueElementType (OSCTXT* pctxt,
   NoValueElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_NoValueElementType (OSCTXT* pctxt, NoValueElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HeadingElementType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_HeadingElementType (OSCTXT* pctxt,
   HeadingElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_HeadingType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_HeadingElementType (OSCTXT* pctxt, HeadingElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   stat = XmlEnc_HeadingType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BooleanElementType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_BooleanElementType (OSCTXT* pctxt,
   BooleanElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_boolean (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_BooleanElementType (OSCTXT* pctxt, BooleanElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   stat = rtXmlEncBoolAttr (pctxt, pvalue->value, OSUTF8("value"), 5);

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BooleanElementType_derivations                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_BooleanElementType_derivations (OSCTXT* pctxt,
   BooleanElementType_derivations *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_BooleanElementType (pctxt, pvalue->u.booleanElementType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_GpsFixCommandType (pctxt, pvalue->u.gpsFixCommandType, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_BooleanElementType_derivations (OSCTXT* pctxt, 
   BooleanElementType_derivations* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   switch (pvalue->t)
   {
      case 1:
         /* encode booleanElementType */

         stat = XmlEnc_BooleanElementType (pctxt, pvalue->u.booleanElementType
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode gpsFixCommandType */

         stat = XmlEnc_GpsFixCommandType (pctxt, pvalue->u.gpsFixCommandType
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HoverCommandType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_HoverCommandType (OSCTXT* pctxt,
   HoverCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->standoff, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode obtainGps */

   if (pvalue->m.obtainGpsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_BooleanElementType_derivations (pctxt, &pvalue->obtainGps, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode heading */

   if (pvalue->m.headingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_HeadingElementType (pctxt, &pvalue->heading, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_DepthTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_HorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_HoverCommandType (OSCTXT* pctxt, HoverCommandType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_HorizontalPositionElements (pctxt, &pvalue->choice
         , 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_DepthTypeElements (pctxt, &pvalue->choice_1, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode heading */

   if (pvalue->m.headingPresent) {
      stat = XmlEnc_HeadingElementType (pctxt, &pvalue->heading
         , OSUTF8("Heading"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode obtainGps */

   if (pvalue->m.obtainGpsPresent) {
      stat = XmlEnc_BooleanElementType_derivations (pctxt, &pvalue->obtainGps
         , OSUTF8("ObtainGps"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         standoff, OSUTF8("Standoff"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvLoiterCommandType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvLoiterCommandType (OSCTXT* pctxt,
   UuvLoiterCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode loiterDepth */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
      asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->loiterDepth, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode choice_2 */

   if (pvalue->m.choice_2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_UuvSpeedElements (pctxt, &pvalue->choice_2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_DepthTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_HorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvLoiterCommandType (OSCTXT* pctxt, UuvLoiterCommandType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_HorizontalPositionElements (pctxt, &pvalue->choice
         , 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_DepthTypeElements (pctxt, &pvalue->choice_1, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_2 */

   if (pvalue->m.choice_2Present) {
      stat = XmlEnc_UuvSpeedElements (pctxt, &pvalue->choice_2, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode loiterDepth */

   stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
      loiterDepth, OSUTF8("LoiterDepth"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExitModeElements                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ExitModeElements (OSCTXT* pctxt,
   ExitModeElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_NoValueElementType (pctxt, pvalue->u.normalExit, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_NoValueElementType (pctxt, pvalue->u.missionAbort, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_NoValueElementType (pctxt, pvalue->u.systemAbort, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_NoValueElementType (pctxt, pvalue->u.recallAbort, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_ExitModeElements (OSCTXT* pctxt, ExitModeElements* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode normalExit */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.normalExit
            , OSUTF8("NormalExit"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode missionAbort */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.missionAbort
            , OSUTF8("MissionAbort"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode systemAbort */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.systemAbort
            , OSUTF8("SystemAbort"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode recallAbort */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.recallAbort
            , OSUTF8("RecallAbort"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  QuitCommandType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_QuitCommandType (OSCTXT* pctxt,
   QuitCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_ExitModeElements (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_QuitCommandType (OSCTXT* pctxt, QuitCommandType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_ExitModeElements (pctxt, &pvalue->choice, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ScalarElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ScalarElementType (OSCTXT* pctxt,
   ScalarElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_real (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ScalarElementType (OSCTXT* pctxt, ScalarElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   stat = rtXmlEncDouble (pctxt, pvalue->value, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RecoverCommandType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_RecoverCommandType (OSCTXT* pctxt,
   RecoverCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode heading */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
      asn1E_HeadingElementType (pctxt, &pvalue->heading, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode range */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_ScalarElementType (pctxt, &pvalue->range, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_RecoverCommandType (OSCTXT* pctxt, RecoverCommandType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode range */

   stat = XmlEnc_ScalarElementType (pctxt, &pvalue->range
      , OSUTF8("Range"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode heading */

   stat = XmlEnc_HeadingElementType (pctxt, &pvalue->heading
      , OSUTF8("Heading"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SendMessageCommandType_choice                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SendMessageCommandType_choice (OSCTXT* pctxt,
   SendMessageCommandType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_AvclMessageType (pctxt, (AvclMessageType*)pvalue->u.aVCLMessage, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_SendMessageCommandType_choice (OSCTXT* pctxt, 
   SendMessageCommandType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode aVCLMessage */

         stat = XmlEnc_AvclMessageType (pctxt, pvalue->u.aVCLMessage
            , OSUTF8("AVCLMessage"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SendMessageCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SendMessageCommandType (OSCTXT* pctxt,
   SendMessageCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_SendMessageCommandType_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SendMessageCommandType (OSCTXT* pctxt, 
   SendMessageCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_SendMessageCommandType_choice (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetPlanesCommandType_choice                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SetPlanesCommandType_choice (OSCTXT* pctxt,
   SetPlanesCommandType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.bowPlanes, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.sternPlanes, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.allPlanes, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_SetPlanesCommandType_choice (OSCTXT* pctxt, 
   SetPlanesCommandType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode bowPlanes */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.bowPlanes
            , OSUTF8("BowPlanes"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode sternPlanes */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.sternPlanes
            , OSUTF8("SternPlanes"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode allPlanes */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.allPlanes
            , OSUTF8("AllPlanes"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetPlanesCommandType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SetPlanesCommandType (OSCTXT* pctxt,
   SetPlanesCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_SetPlanesCommandType_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SetPlanesCommandType (OSCTXT* pctxt, SetPlanesCommandType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_SetPlanesCommandType_choice (pctxt, &pvalue->choice
      , OSUTF8(""), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AbsoluteHorizontalPositionElements                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AbsoluteHorizontalPositionElements (OSCTXT* pctxt,
   AbsoluteHorizontalPositionElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_LatitudeLongitudeElementType_derivations (pctxt, pvalue->u.latitudeLongitude, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_XyElementType (pctxt, pvalue->u.xYPosition, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_AbsoluteHorizontalPositionElements (OSCTXT* pctxt, 
   AbsoluteHorizontalPositionElements* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode latitudeLongitude */

         stat = XmlEnc_LatitudeLongitudeElementType_derivations (pctxt, pvalue
            ->u.latitudeLongitude, OSUTF8("LatitudeLongitude"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode xYPosition */

         stat = XmlEnc_XyElementType (pctxt, pvalue->u.xYPosition
            , OSUTF8("XYPosition"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvPositionCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvPositionCommandType (OSCTXT* pctxt,
   UuvPositionCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode depth */

   if (pvalue->m.depthPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->depth, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_AbsoluteHorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvPositionCommandType (OSCTXT* pctxt, 
   UuvPositionCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_AbsoluteHorizontalPositionElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode depth */

   if (pvalue->m.depthPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         depth, OSUTF8("Depth"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetSonarCommandType_choice                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SetSonarCommandType_choice (OSCTXT* pctxt,
   SetSonarCommandType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_NoValueElementType (pctxt, pvalue->u.manual, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_NoValueElementType (pctxt, pvalue->u.scan, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_NoValueElementType (pctxt, pvalue->u.track, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_SetSonarCommandType_choice (OSCTXT* pctxt, 
   SetSonarCommandType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode manual */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.manual
            , OSUTF8("Manual"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode scan */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.scan
            , OSUTF8("Scan"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode track */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.track
            , OSUTF8("Track"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BearingTypeElements                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_BearingTypeElements (OSCTXT* pctxt,
   BearingTypeElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_NoValueElementType (pctxt, pvalue->u.relative, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_NoValueElementType (pctxt, pvalue->u.true_, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_NoValueElementType (pctxt, pvalue->u.magnetic, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_BearingTypeElements (OSCTXT* pctxt, BearingTypeElements* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode relative */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.relative
            , OSUTF8("Relative"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode true_ */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.true_
            , OSUTF8("True"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode magnetic */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.magnetic
            , OSUTF8("Magnetic"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetSonarCommandType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SetSonarCommandType (OSCTXT* pctxt,
   SetSonarCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_BearingTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode elevation */

   if (pvalue->m.elevationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_ScalarElementType (pctxt, &pvalue->elevation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   if (pvalue->m.bearingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_ScalarElementType (pctxt, &pvalue->bearing, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
      asn1E_SetSonarCommandType_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_StringElementType (pctxt, &pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SetSonarCommandType (OSCTXT* pctxt, SetSonarCommandType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode model */

   stat = XmlEnc_StringElementType (pctxt, &pvalue->model
      , OSUTF8("Model"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode choice */

   stat = XmlEnc_SetSonarCommandType_choice (pctxt, &pvalue->choice
      , OSUTF8(""), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode bearing */

   if (pvalue->m.bearingPresent) {
      stat = XmlEnc_ScalarElementType (pctxt, &pvalue->bearing
         , OSUTF8("Bearing"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode elevation */

   if (pvalue->m.elevationPresent) {
      stat = XmlEnc_ScalarElementType (pctxt, &pvalue->elevation
         , OSUTF8("Elevation"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_BearingTypeElements (pctxt, &pvalue->choice_1
         , 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetThrusterCommandType_choice                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SetThrusterCommandType_choice (OSCTXT* pctxt,
   SetThrusterCommandType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.bowLateralThruster, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.sternLateralThruster, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.lateralThrusters, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.bowVerticalThruster, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.sternVerticalThruster, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.verticalThrusters, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_SetThrusterCommandType_choice (OSCTXT* pctxt, 
   SetThrusterCommandType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode bowLateralThruster */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->
            u.bowLateralThruster, OSUTF8("BowLateralThruster"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode sternLateralThruster */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->
            u.sternLateralThruster, OSUTF8("SternLateralThruster"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode lateralThrusters */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->
            u.lateralThrusters, OSUTF8("LateralThrusters"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode bowVerticalThruster */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->
            u.bowVerticalThruster, OSUTF8("BowVerticalThruster"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode sternVerticalThruster */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->
            u.sternVerticalThruster
            , OSUTF8("SternVerticalThruster"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode verticalThrusters */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->
            u.verticalThrusters, OSUTF8("VerticalThrusters"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetThrusterCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SetThrusterCommandType (OSCTXT* pctxt,
   SetThrusterCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_SetThrusterCommandType_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SetThrusterCommandType (OSCTXT* pctxt, 
   SetThrusterCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_SetThrusterCommandType_choice (pctxt, &pvalue->choice
      , OSUTF8(""), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TakeStationCommandType_choice                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TakeStationCommandType_choice (OSCTXT* pctxt,
   TakeStationCommandType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_NoValueElementType (pctxt, pvalue->u.targetSonarScan, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_NoValueElementType (pctxt, pvalue->u.targetEdgeSonarScan, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_TakeStationCommandType_choice (OSCTXT* pctxt, 
   TakeStationCommandType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode targetSonarScan */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.targetSonarScan
            , OSUTF8("TargetSonarScan"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode targetEdgeSonarScan */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.targetEdgeSonarScan
            , OSUTF8("TargetEdgeSonarScan"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TargetElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TargetElementType (OSCTXT* pctxt,
   TargetElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode range */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_real (pctxt, &pvalue->range, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode elevation */

   if (pvalue->m.elevationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_real (pctxt, &pvalue->elevation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TargetElementType (OSCTXT* pctxt, TargetElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.elevationPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" elevation=\""), 12);

      stat = rtXmlEncDouble (pctxt, pvalue->elevation, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" range=\""), 8);

   stat = rtXmlEncDouble (pctxt, pvalue->range, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TakeStationCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TakeStationCommandType (OSCTXT* pctxt,
   TakeStationCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode heading */

   if (pvalue->m.headingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_HeadingElementType (pctxt, &pvalue->heading, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode commandedStation */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
      asn1E_TargetElementType (pctxt, &pvalue->commandedStation, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode targetLocation */

   if (pvalue->m.targetLocationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_TargetElementType (pctxt, &pvalue->targetLocation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_TakeStationCommandType_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TakeStationCommandType (OSCTXT* pctxt, 
   TakeStationCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_TakeStationCommandType_choice (pctxt, &pvalue->choice
      , OSUTF8(""), 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode targetLocation */

   if (pvalue->m.targetLocationPresent) {
      stat = XmlEnc_TargetElementType (pctxt, &pvalue->targetLocation
         , OSUTF8("TargetLocation"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode commandedStation */

   stat = XmlEnc_TargetElementType (pctxt, &pvalue->commandedStation
      , OSUTF8("CommandedStation"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode heading */

   if (pvalue->m.headingPresent) {
      stat = XmlEnc_HeadingElementType (pctxt, &pvalue->heading
         , OSUTF8("Heading"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvWaypointCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvWaypointCommandType (OSCTXT* pctxt,
   UuvWaypointCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->standoff, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode obtainGps */

   if (pvalue->m.obtainGpsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_BooleanElementType_derivations (pctxt, &pvalue->obtainGps, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_2 */

   if (pvalue->m.choice_2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_UuvSpeedElements (pctxt, &pvalue->choice_2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_TrackModeElementType (pctxt, &pvalue->homingMode, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_DepthTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_HorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvWaypointCommandType (OSCTXT* pctxt, 
   UuvWaypointCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_HorizontalPositionElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_DepthTypeElements (pctxt, &pvalue->choice_1, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      stat = XmlEnc_TrackModeElementType (pctxt, &pvalue->homingMode
         , OSUTF8("HomingMode"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_2 */

   if (pvalue->m.choice_2Present) {
      stat = XmlEnc_UuvSpeedElements (pctxt, &pvalue->choice_2, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode obtainGps */

   if (pvalue->m.obtainGpsPresent) {
      stat = XmlEnc_BooleanElementType_derivations (pctxt, &pvalue->obtainGps
         , OSUTF8("ObtainGps"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         standoff, OSUTF8("Standoff"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvScriptCommandsType_element                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvScriptCommandsType_element (OSCTXT* pctxt,
   UuvScriptCommandsType_element *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UuvCompositeWaypointCommandType (pctxt, pvalue->u.compositeWaypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_GpsFixCommandType (pctxt, pvalue->u.gpsFix, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_NoValueElementType (pctxt, pvalue->u.help, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_HoverCommandType (pctxt, pvalue->u.hover, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
            asn1E_UuvLoiterCommandType (pctxt, pvalue->u.loiter, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.makeAltitude, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.makeDepth, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
            asn1E_HeadingElementType (pctxt, pvalue->u.makeHeading, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 10:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeKnots, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 11:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeSpeed, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 12:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
            asn1E_MetaDataType (pctxt, pvalue->u.metaCommand, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 13:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12,
            asn1E_StringElementType (pctxt, pvalue->u.missionScript, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 14:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|13,
            asn1E_StringElementType (pctxt, pvalue->u.missionScriptInline, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 15:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|14,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.moveLateral, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 16:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|15,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.moveRotate, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 17:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|16,
            asn1E_QuitCommandType (pctxt, pvalue->u.quit, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 18:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|17,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.realtime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 19:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|18,
            asn1E_RecoverCommandType (pctxt, pvalue->u.recover, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 20:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|19,
            asn1E_SendMessageCommandType (pctxt, pvalue->u.sendMessage, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 21:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|20,
            asn1E_SetPlanesCommandType (pctxt, pvalue->u.setPlanes, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 22:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|21,
            asn1E_UuvPositionCommandType (pctxt, pvalue->u.setPosition, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 23:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|22,
            asn1E_SetPropellerCommandType (pctxt, pvalue->u.setPower, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 24:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|23,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.setRudder, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 25:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|24,
            asn1E_SetSonarCommandType (pctxt, pvalue->u.setSonar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 26:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|25,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setStandoff, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 27:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|26,
            asn1E_SetThrusterCommandType (pctxt, pvalue->u.setThruster, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 28:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|27,
            asn1E_ScalarElementType (pctxt, pvalue->u.setTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 29:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|28,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setTimeStep, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 30:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|29,
            asn1E_TakeStationCommandType (pctxt, pvalue->u.takeStation, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 31:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|30,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.thrusters, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 32:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|31,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.trace, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 33:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|32,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.wait, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 34:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|33,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.waitUntilTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 35:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|34,
            asn1E_UuvWaypointCommandType (pctxt, pvalue->u.waypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_UuvScriptCommandsType_element (OSCTXT* pctxt, 
   UuvScriptCommandsType_element* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode compositeWaypoint */

         stat = XmlEnc_UuvCompositeWaypointCommandType (pctxt, pvalue->
            u.compositeWaypoint, OSUTF8("CompositeWaypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode followBeacon */

         stat = XmlEnc_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon
            , OSUTF8("FollowBeacon"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode gpsFix */

         stat = XmlEnc_GpsFixCommandType (pctxt, pvalue->u.gpsFix
            , OSUTF8("GpsFix"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode help */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.help
            , OSUTF8("Help"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode hover */

         stat = XmlEnc_HoverCommandType (pctxt, pvalue->u.hover
            , OSUTF8("Hover"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode loiter */

         stat = XmlEnc_UuvLoiterCommandType (pctxt, pvalue->u.loiter
            , OSUTF8("Loiter"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode makeAltitude */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.makeAltitude, OSUTF8("MakeAltitude"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode makeDepth */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.makeDepth, OSUTF8("MakeDepth"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode makeHeading */

         stat = XmlEnc_HeadingElementType (pctxt, pvalue->u.makeHeading
            , OSUTF8("MakeHeading"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 10:
         /* encode makeKnots */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeKnots
            , OSUTF8("MakeKnots"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 11:
         /* encode makeSpeed */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeSpeed
            , OSUTF8("MakeSpeed"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 12:
         /* encode metaCommand */

         stat = XmlEnc_MetaDataType (pctxt, pvalue->u.metaCommand
            , OSUTF8("MetaCommand"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 13:
         /* encode missionScript */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScript
            , OSUTF8("MissionScript"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 14:
         /* encode missionScriptInline */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScriptInline
            , OSUTF8("MissionScriptInline"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 15:
         /* encode moveLateral */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.moveLateral
            , OSUTF8("MoveLateral"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 16:
         /* encode moveRotate */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.moveRotate
            , OSUTF8("MoveRotate"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 17:
         /* encode quit */

         stat = XmlEnc_QuitCommandType (pctxt, pvalue->u.quit
            , OSUTF8("Quit"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 18:
         /* encode realtime */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->
            u.realtime, OSUTF8("Realtime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 19:
         /* encode recover */

         stat = XmlEnc_RecoverCommandType (pctxt, pvalue->u.recover
            , OSUTF8("Recover"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 20:
         /* encode sendMessage */

         stat = XmlEnc_SendMessageCommandType (pctxt, pvalue->u.sendMessage
            , OSUTF8("SendMessage"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 21:
         /* encode setPlanes */

         stat = XmlEnc_SetPlanesCommandType (pctxt, pvalue->u.setPlanes
            , OSUTF8("SetPlanes"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 22:
         /* encode setPosition */

         stat = XmlEnc_UuvPositionCommandType (pctxt, pvalue->u.setPosition
            , OSUTF8("SetPosition"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 23:
         /* encode setPower */

         stat = XmlEnc_SetPropellerCommandType (pctxt, pvalue->u.setPower
            , OSUTF8("SetPower"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 24:
         /* encode setRudder */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.setRudder
            , OSUTF8("SetRudder"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 25:
         /* encode setSonar */

         stat = XmlEnc_SetSonarCommandType (pctxt, pvalue->u.setSonar
            , OSUTF8("SetSonar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 26:
         /* encode setStandoff */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setStandoff, OSUTF8("SetStandoff"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 27:
         /* encode setThruster */

         stat = XmlEnc_SetThrusterCommandType (pctxt, pvalue->u.setThruster
            , OSUTF8("SetThruster"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 28:
         /* encode setTime */

         stat = XmlEnc_ScalarElementType (pctxt, pvalue->u.setTime
            , OSUTF8("SetTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 29:
         /* encode setTimeStep */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setTimeStep, OSUTF8("SetTimeStep"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 30:
         /* encode takeStation */

         stat = XmlEnc_TakeStationCommandType (pctxt, pvalue->u.takeStation
            , OSUTF8("TakeStation"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 31:
         /* encode thrusters */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->
            u.thrusters, OSUTF8("Thrusters"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 32:
         /* encode trace */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->u.trace
            , OSUTF8("Trace"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 33:
         /* encode wait */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.wait, OSUTF8("Wait"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 34:
         /* encode waitUntilTime */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.waitUntilTime, OSUTF8("WaitUntilTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 35:
         /* encode waypoint */

         stat = XmlEnc_UuvWaypointCommandType (pctxt, pvalue->u.waypoint
            , OSUTF8("Waypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvScriptCommandsType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvScriptCommandsType (OSCTXT* pctxt,
   UuvScriptCommandsType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UuvScriptCommandsType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->choice_list.tail;
   while (0 != pnode2) {
      ll = asn1E_UuvScriptCommandsType_element (pctxt, ((UuvScriptCommandsType_element*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvScriptCommandsType (OSCTXT* pctxt, 
   UuvScriptCommandsType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UuvScriptCommandsType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->choice_list.head;
   while (0 != pnode) {
      stat = XmlEnc_UuvScriptCommandsType_element (pctxt, 
         ((UuvScriptCommandsType_element*)pnode->data), 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SpeedTypeElements                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SpeedTypeElements (OSCTXT* pctxt,
   SpeedTypeElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.speed, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.knots, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_SpeedTypeElements (OSCTXT* pctxt, SpeedTypeElements* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode speed */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.speed, OSUTF8("Speed"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode knots */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.knots, OSUTF8("Knots"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvCompositeWaypointCommandType                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvCompositeWaypointCommandType (OSCTXT* pctxt,
   UsvCompositeWaypointCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->standoff, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_SpeedTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_TrackModeElementType (pctxt, &pvalue->homingMode, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_CompositeWaypointElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UsvCompositeWaypointCommandType (OSCTXT* pctxt, 
   UsvCompositeWaypointCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_CompositeWaypointElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      stat = XmlEnc_TrackModeElementType (pctxt, &pvalue->homingMode
         , OSUTF8("HomingMode"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_SpeedTypeElements (pctxt, &pvalue->choice_1, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         standoff, OSUTF8("Standoff"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvLoiterCommandType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvLoiterCommandType (OSCTXT* pctxt,
   UsvLoiterCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_SpeedTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_HorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UsvLoiterCommandType (OSCTXT* pctxt, UsvLoiterCommandType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_HorizontalPositionElements (pctxt, &pvalue->choice
         , 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_SpeedTypeElements (pctxt, &pvalue->choice_1, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvPositionCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvPositionCommandType (OSCTXT* pctxt,
   UsvPositionCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_AbsoluteHorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UsvPositionCommandType (OSCTXT* pctxt, 
   UsvPositionCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_AbsoluteHorizontalPositionElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvWaypointCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvWaypointCommandType (OSCTXT* pctxt,
   UsvWaypointCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->standoff, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_SpeedTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_TrackModeElementType (pctxt, &pvalue->homingMode, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_HorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UsvWaypointCommandType (OSCTXT* pctxt, 
   UsvWaypointCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_HorizontalPositionElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      stat = XmlEnc_TrackModeElementType (pctxt, &pvalue->homingMode
         , OSUTF8("HomingMode"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_SpeedTypeElements (pctxt, &pvalue->choice_1, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         standoff, OSUTF8("Standoff"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvScriptCommandsType_element                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvScriptCommandsType_element (OSCTXT* pctxt,
   UsvScriptCommandsType_element *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UsvCompositeWaypointCommandType (pctxt, pvalue->u.compositeWaypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_NoValueElementType (pctxt, pvalue->u.help, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_UsvLoiterCommandType (pctxt, pvalue->u.loiter, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_HeadingElementType (pctxt, pvalue->u.makeHeading, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeKnots, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeSpeed, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
            asn1E_MetaDataType (pctxt, pvalue->u.metaCommand, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
            asn1E_StringElementType (pctxt, pvalue->u.missionScript, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 10:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
            asn1E_StringElementType (pctxt, pvalue->u.missionScriptInline, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 11:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
            asn1E_QuitCommandType (pctxt, pvalue->u.quit, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 12:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.realtime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 13:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12,
            asn1E_SendMessageCommandType (pctxt, pvalue->u.sendMessage, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 14:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|13,
            asn1E_UsvPositionCommandType (pctxt, pvalue->u.setPosition, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 15:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|14,
            asn1E_SetPropellerCommandType (pctxt, pvalue->u.setPower, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 16:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|15,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.setRudder, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 17:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|16,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setStandoff, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 18:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|17,
            asn1E_ScalarElementType (pctxt, pvalue->u.setTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 19:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|18,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setTimeStep, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 20:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|19,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.trace, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 21:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|20,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.wait, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 22:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|21,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.waitUntilTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 23:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|22,
            asn1E_UsvWaypointCommandType (pctxt, pvalue->u.waypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_UsvScriptCommandsType_element (OSCTXT* pctxt, 
   UsvScriptCommandsType_element* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode compositeWaypoint */

         stat = XmlEnc_UsvCompositeWaypointCommandType (pctxt, pvalue->
            u.compositeWaypoint, OSUTF8("CompositeWaypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode followBeacon */

         stat = XmlEnc_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon
            , OSUTF8("FollowBeacon"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode help */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.help
            , OSUTF8("Help"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode loiter */

         stat = XmlEnc_UsvLoiterCommandType (pctxt, pvalue->u.loiter
            , OSUTF8("Loiter"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode makeHeading */

         stat = XmlEnc_HeadingElementType (pctxt, pvalue->u.makeHeading
            , OSUTF8("MakeHeading"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode makeKnots */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeKnots
            , OSUTF8("MakeKnots"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode makeSpeed */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeSpeed
            , OSUTF8("MakeSpeed"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode metaCommand */

         stat = XmlEnc_MetaDataType (pctxt, pvalue->u.metaCommand
            , OSUTF8("MetaCommand"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode missionScript */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScript
            , OSUTF8("MissionScript"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 10:
         /* encode missionScriptInline */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScriptInline
            , OSUTF8("MissionScriptInline"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 11:
         /* encode quit */

         stat = XmlEnc_QuitCommandType (pctxt, pvalue->u.quit
            , OSUTF8("Quit"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 12:
         /* encode realtime */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->
            u.realtime, OSUTF8("Realtime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 13:
         /* encode sendMessage */

         stat = XmlEnc_SendMessageCommandType (pctxt, pvalue->u.sendMessage
            , OSUTF8("SendMessage"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 14:
         /* encode setPosition */

         stat = XmlEnc_UsvPositionCommandType (pctxt, pvalue->u.setPosition
            , OSUTF8("SetPosition"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 15:
         /* encode setPower */

         stat = XmlEnc_SetPropellerCommandType (pctxt, pvalue->u.setPower
            , OSUTF8("SetPower"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 16:
         /* encode setRudder */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.setRudder
            , OSUTF8("SetRudder"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 17:
         /* encode setStandoff */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setStandoff, OSUTF8("SetStandoff"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 18:
         /* encode setTime */

         stat = XmlEnc_ScalarElementType (pctxt, pvalue->u.setTime
            , OSUTF8("SetTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 19:
         /* encode setTimeStep */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setTimeStep, OSUTF8("SetTimeStep"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 20:
         /* encode trace */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->u.trace
            , OSUTF8("Trace"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 21:
         /* encode wait */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.wait, OSUTF8("Wait"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 22:
         /* encode waitUntilTime */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.waitUntilTime, OSUTF8("WaitUntilTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 23:
         /* encode waypoint */

         stat = XmlEnc_UsvWaypointCommandType (pctxt, pvalue->u.waypoint
            , OSUTF8("Waypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvScriptCommandsType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvScriptCommandsType (OSCTXT* pctxt,
   UsvScriptCommandsType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UsvScriptCommandsType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->choice_list.tail;
   while (0 != pnode2) {
      ll = asn1E_UsvScriptCommandsType_element (pctxt, ((UsvScriptCommandsType_element*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UsvScriptCommandsType (OSCTXT* pctxt, 
   UsvScriptCommandsType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UsvScriptCommandsType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->choice_list.head;
   while (0 != pnode) {
      stat = XmlEnc_UsvScriptCommandsType_element (pctxt, 
         ((UsvScriptCommandsType_element*)pnode->data), 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvCompositeWaypointCommandType                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvCompositeWaypointCommandType (OSCTXT* pctxt,
   UgvCompositeWaypointCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->standoff, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_SpeedTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_TrackModeElementType (pctxt, &pvalue->homingMode, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_CompositeWaypointElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UgvCompositeWaypointCommandType (OSCTXT* pctxt, 
   UgvCompositeWaypointCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_CompositeWaypointElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      stat = XmlEnc_TrackModeElementType (pctxt, &pvalue->homingMode
         , OSUTF8("HomingMode"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_SpeedTypeElements (pctxt, &pvalue->choice_1, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         standoff, OSUTF8("Standoff"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvLoiterCommandType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvLoiterCommandType (OSCTXT* pctxt,
   UgvLoiterCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_SpeedTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_HorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UgvLoiterCommandType (OSCTXT* pctxt, UgvLoiterCommandType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_HorizontalPositionElements (pctxt, &pvalue->choice
         , 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_SpeedTypeElements (pctxt, &pvalue->choice_1, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvPositionCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvPositionCommandType (OSCTXT* pctxt,
   UgvPositionCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_AbsoluteHorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UgvPositionCommandType (OSCTXT* pctxt, 
   UgvPositionCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_AbsoluteHorizontalPositionElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvWaypointCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvWaypointCommandType (OSCTXT* pctxt,
   UgvWaypointCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->standoff, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_TrackModeElementType (pctxt, &pvalue->homingMode, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_SpeedTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_HorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UgvWaypointCommandType (OSCTXT* pctxt, 
   UgvWaypointCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_HorizontalPositionElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_SpeedTypeElements (pctxt, &pvalue->choice_1, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      stat = XmlEnc_TrackModeElementType (pctxt, &pvalue->homingMode
         , OSUTF8("HomingMode"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         standoff, OSUTF8("Standoff"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvScriptCommandsType_element                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvScriptCommandsType_element (OSCTXT* pctxt,
   UgvScriptCommandsType_element *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UgvCompositeWaypointCommandType (pctxt, pvalue->u.compositeWaypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_NoValueElementType (pctxt, pvalue->u.help, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_UgvLoiterCommandType (pctxt, pvalue->u.loiter, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_HeadingElementType (pctxt, pvalue->u.makeHeading, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.makeKnots, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.makeSpeed, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
            asn1E_MetaDataType (pctxt, pvalue->u.metaCommand, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
            asn1E_StringElementType (pctxt, pvalue->u.missionScript, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 10:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
            asn1E_StringElementType (pctxt, pvalue->u.missionScriptInline, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 11:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
            asn1E_QuitCommandType (pctxt, pvalue->u.quit, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 12:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.realtime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 13:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12,
            asn1E_SendMessageCommandType (pctxt, pvalue->u.sendMessage, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 14:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|13,
            asn1E_UgvPositionCommandType (pctxt, pvalue->u.setPosition, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 15:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|14,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setStandoff, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 16:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|15,
            asn1E_ScalarElementType (pctxt, pvalue->u.setTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 17:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|16,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setTimeStep, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 18:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|17,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.trace, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 19:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|18,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.wait, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 20:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|19,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.waitUntilTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 21:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|20,
            asn1E_UgvWaypointCommandType (pctxt, pvalue->u.waypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_UgvScriptCommandsType_element (OSCTXT* pctxt, 
   UgvScriptCommandsType_element* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode compositeWaypoint */

         stat = XmlEnc_UgvCompositeWaypointCommandType (pctxt, pvalue->
            u.compositeWaypoint, OSUTF8("CompositeWaypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode followBeacon */

         stat = XmlEnc_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon
            , OSUTF8("FollowBeacon"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode help */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.help
            , OSUTF8("Help"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode loiter */

         stat = XmlEnc_UgvLoiterCommandType (pctxt, pvalue->u.loiter
            , OSUTF8("Loiter"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode makeHeading */

         stat = XmlEnc_HeadingElementType (pctxt, pvalue->u.makeHeading
            , OSUTF8("MakeHeading"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode makeKnots */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.makeKnots, OSUTF8("MakeKnots"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode makeSpeed */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.makeSpeed, OSUTF8("MakeSpeed"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode metaCommand */

         stat = XmlEnc_MetaDataType (pctxt, pvalue->u.metaCommand
            , OSUTF8("MetaCommand"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode missionScript */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScript
            , OSUTF8("MissionScript"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 10:
         /* encode missionScriptInline */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScriptInline
            , OSUTF8("MissionScriptInline"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 11:
         /* encode quit */

         stat = XmlEnc_QuitCommandType (pctxt, pvalue->u.quit
            , OSUTF8("Quit"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 12:
         /* encode realtime */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->
            u.realtime, OSUTF8("Realtime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 13:
         /* encode sendMessage */

         stat = XmlEnc_SendMessageCommandType (pctxt, pvalue->u.sendMessage
            , OSUTF8("SendMessage"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 14:
         /* encode setPosition */

         stat = XmlEnc_UgvPositionCommandType (pctxt, pvalue->u.setPosition
            , OSUTF8("SetPosition"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 15:
         /* encode setStandoff */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setStandoff, OSUTF8("SetStandoff"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 16:
         /* encode setTime */

         stat = XmlEnc_ScalarElementType (pctxt, pvalue->u.setTime
            , OSUTF8("SetTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 17:
         /* encode setTimeStep */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setTimeStep, OSUTF8("SetTimeStep"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 18:
         /* encode trace */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->u.trace
            , OSUTF8("Trace"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 19:
         /* encode wait */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.wait, OSUTF8("Wait"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 20:
         /* encode waitUntilTime */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.waitUntilTime, OSUTF8("WaitUntilTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 21:
         /* encode waypoint */

         stat = XmlEnc_UgvWaypointCommandType (pctxt, pvalue->u.waypoint
            , OSUTF8("Waypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvScriptCommandsType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvScriptCommandsType (OSCTXT* pctxt,
   UgvScriptCommandsType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UgvScriptCommandsType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->choice_list.tail;
   while (0 != pnode2) {
      ll = asn1E_UgvScriptCommandsType_element (pctxt, ((UgvScriptCommandsType_element*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UgvScriptCommandsType (OSCTXT* pctxt, 
   UgvScriptCommandsType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UgvScriptCommandsType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->choice_list.head;
   while (0 != pnode) {
      stat = XmlEnc_UgvScriptCommandsType_element (pctxt, 
         ((UgvScriptCommandsType_element*)pnode->data), 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AltitudeTypeElements                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AltitudeTypeElements (OSCTXT* pctxt,
   AltitudeTypeElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.aGLAltitude, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.mSLAltitude, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_AltitudeTypeElements (OSCTXT* pctxt, AltitudeTypeElements* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode aGLAltitude */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.aGLAltitude, OSUTF8("AGLAltitude"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode mSLAltitude */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.mSLAltitude, OSUTF8("MSLAltitude"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavCompositeWaypointCommandType                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavCompositeWaypointCommandType (OSCTXT* pctxt,
   UavCompositeWaypointCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->standoff, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_2 */

   if (pvalue->m.choice_2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_SpeedTypeElements (pctxt, &pvalue->choice_2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_TrackModeElementType (pctxt, &pvalue->homingMode, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
      asn1E_AltitudeTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_CompositeWaypointElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavCompositeWaypointCommandType (OSCTXT* pctxt, 
   UavCompositeWaypointCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_CompositeWaypointElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode choice_1 */

   stat = XmlEnc_AltitudeTypeElements (pctxt, &pvalue->choice_1, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      stat = XmlEnc_TrackModeElementType (pctxt, &pvalue->homingMode
         , OSUTF8("HomingMode"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_2 */

   if (pvalue->m.choice_2Present) {
      stat = XmlEnc_SpeedTypeElements (pctxt, &pvalue->choice_2, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         standoff, OSUTF8("Standoff"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavLoiterCommandType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavLoiterCommandType (OSCTXT* pctxt,
   UavLoiterCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode loiterAltitude */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
      asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->loiterAltitude, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode choice_2 */

   if (pvalue->m.choice_2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_AltitudeTypeElements (pctxt, &pvalue->choice_2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_SpeedTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_HorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavLoiterCommandType (OSCTXT* pctxt, UavLoiterCommandType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_HorizontalPositionElements (pctxt, &pvalue->choice
         , 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_SpeedTypeElements (pctxt, &pvalue->choice_1, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_2 */

   if (pvalue->m.choice_2Present) {
      stat = XmlEnc_AltitudeTypeElements (pctxt, &pvalue->choice_2
         , 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode loiterAltitude */

   stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
      loiterAltitude, OSUTF8("LoiterAltitude"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavPositionCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavPositionCommandType (OSCTXT* pctxt,
   UavPositionCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode mSLAltitude */

   if (pvalue->m.mSLAltitudePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_ScalarElementType (pctxt, &pvalue->mSLAltitude, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_AbsoluteHorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavPositionCommandType (OSCTXT* pctxt, 
   UavPositionCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_AbsoluteHorizontalPositionElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode mSLAltitude */

   if (pvalue->m.mSLAltitudePresent) {
      stat = XmlEnc_ScalarElementType (pctxt, &pvalue->mSLAltitude
         , OSUTF8("MSLAltitude"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PercentType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PercentType (OSCTXT* pctxt,
   PercentType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_real (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_PercentType (OSCTXT* pctxt, PercentType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncDouble (pctxt, value, elemName, nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PercentElementType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PercentElementType (OSCTXT* pctxt,
   PercentElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_PercentType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_PercentElementType (OSCTXT* pctxt, PercentElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   stat = XmlEnc_PercentType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavWaypointCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavWaypointCommandType (OSCTXT* pctxt,
   UavWaypointCommandType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->timeOut, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->standoff, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_2 */

   if (pvalue->m.choice_2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_SpeedTypeElements (pctxt, &pvalue->choice_2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_TrackModeElementType (pctxt, &pvalue->homingMode, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_AltitudeTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_HorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavWaypointCommandType (OSCTXT* pctxt, 
   UavWaypointCommandType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_HorizontalPositionElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_AltitudeTypeElements (pctxt, &pvalue->choice_1
         , 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode homingMode */

   if (pvalue->m.homingModePresent) {
      stat = XmlEnc_TrackModeElementType (pctxt, &pvalue->homingMode
         , OSUTF8("HomingMode"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_2 */

   if (pvalue->m.choice_2Present) {
      stat = XmlEnc_SpeedTypeElements (pctxt, &pvalue->choice_2, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode standoff */

   if (pvalue->m.standoffPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         standoff, OSUTF8("Standoff"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode timeOut */

   if (pvalue->m.timeOutPresent) {
      stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->
         timeOut, OSUTF8("TimeOut"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavScriptCommandsType_element                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavScriptCommandsType_element (OSCTXT* pctxt,
   UavScriptCommandsType_element *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UavCompositeWaypointCommandType (pctxt, pvalue->u.compositeWaypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_NoValueElementType (pctxt, pvalue->u.help, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_UavLoiterCommandType (pctxt, pvalue->u.loiter, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.makeAltitudeAGL, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.makeAltitudeMSL, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.makeClimbRate, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
            asn1E_HeadingElementType (pctxt, pvalue->u.makeHeading, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeKnots, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 10:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeSpeed, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 11:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.makeTurnRate, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 12:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
            asn1E_MetaDataType (pctxt, pvalue->u.metaCommand, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 13:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12,
            asn1E_StringElementType (pctxt, pvalue->u.missionScript, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 14:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|13,
            asn1E_StringElementType (pctxt, pvalue->u.missionScriptInline, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 15:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|14,
            asn1E_QuitCommandType (pctxt, pvalue->u.quit, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 16:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|15,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.realtime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 17:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|16,
            asn1E_SendMessageCommandType (pctxt, pvalue->u.sendMessage, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 18:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|17,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.setAileron, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 19:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|18,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.setElevator, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 20:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|19,
            asn1E_UavPositionCommandType (pctxt, pvalue->u.setPosition, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 21:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|20,
            asn1E_PercentElementType (pctxt, pvalue->u.setPower, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 22:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|21,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.setRudder, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 23:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|22,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setStandoff, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 24:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|23,
            asn1E_ScalarElementType (pctxt, pvalue->u.setTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 25:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|24,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setTimeStep, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 26:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|25,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.trace, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 27:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|26,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.wait, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 28:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|27,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.waitUntilTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 29:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|28,
            asn1E_UavWaypointCommandType (pctxt, pvalue->u.waypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_UavScriptCommandsType_element (OSCTXT* pctxt, 
   UavScriptCommandsType_element* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode compositeWaypoint */

         stat = XmlEnc_UavCompositeWaypointCommandType (pctxt, pvalue->
            u.compositeWaypoint, OSUTF8("CompositeWaypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode followBeacon */

         stat = XmlEnc_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon
            , OSUTF8("FollowBeacon"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode help */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.help
            , OSUTF8("Help"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode loiter */

         stat = XmlEnc_UavLoiterCommandType (pctxt, pvalue->u.loiter
            , OSUTF8("Loiter"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode makeAltitudeAGL */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.makeAltitudeAGL, OSUTF8("MakeAltitudeAGL"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode makeAltitudeMSL */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.makeAltitudeMSL, OSUTF8("MakeAltitudeMSL"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode makeClimbRate */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.makeClimbRate
            , OSUTF8("MakeClimbRate"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode makeHeading */

         stat = XmlEnc_HeadingElementType (pctxt, pvalue->u.makeHeading
            , OSUTF8("MakeHeading"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode makeKnots */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeKnots
            , OSUTF8("MakeKnots"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 10:
         /* encode makeSpeed */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeSpeed
            , OSUTF8("MakeSpeed"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 11:
         /* encode makeTurnRate */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.makeTurnRate
            , OSUTF8("MakeTurnRate"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 12:
         /* encode metaCommand */

         stat = XmlEnc_MetaDataType (pctxt, pvalue->u.metaCommand
            , OSUTF8("MetaCommand"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 13:
         /* encode missionScript */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScript
            , OSUTF8("MissionScript"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 14:
         /* encode missionScriptInline */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScriptInline
            , OSUTF8("MissionScriptInline"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 15:
         /* encode quit */

         stat = XmlEnc_QuitCommandType (pctxt, pvalue->u.quit
            , OSUTF8("Quit"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 16:
         /* encode realtime */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->
            u.realtime, OSUTF8("Realtime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 17:
         /* encode sendMessage */

         stat = XmlEnc_SendMessageCommandType (pctxt, pvalue->u.sendMessage
            , OSUTF8("SendMessage"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 18:
         /* encode setAileron */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.setAileron
            , OSUTF8("SetAileron"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 19:
         /* encode setElevator */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.setElevator
            , OSUTF8("SetElevator"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 20:
         /* encode setPosition */

         stat = XmlEnc_UavPositionCommandType (pctxt, pvalue->u.setPosition
            , OSUTF8("SetPosition"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 21:
         /* encode setPower */

         stat = XmlEnc_PercentElementType (pctxt, pvalue->u.setPower
            , OSUTF8("SetPower"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 22:
         /* encode setRudder */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.setRudder
            , OSUTF8("SetRudder"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 23:
         /* encode setStandoff */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setStandoff, OSUTF8("SetStandoff"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 24:
         /* encode setTime */

         stat = XmlEnc_ScalarElementType (pctxt, pvalue->u.setTime
            , OSUTF8("SetTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 25:
         /* encode setTimeStep */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setTimeStep, OSUTF8("SetTimeStep"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 26:
         /* encode trace */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->u.trace
            , OSUTF8("Trace"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 27:
         /* encode wait */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.wait, OSUTF8("Wait"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 28:
         /* encode waitUntilTime */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.waitUntilTime, OSUTF8("WaitUntilTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 29:
         /* encode waypoint */

         stat = XmlEnc_UavWaypointCommandType (pctxt, pvalue->u.waypoint
            , OSUTF8("Waypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavScriptCommandsType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavScriptCommandsType (OSCTXT* pctxt,
   UavScriptCommandsType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UavScriptCommandsType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->choice_list.tail;
   while (0 != pnode2) {
      ll = asn1E_UavScriptCommandsType_element (pctxt, ((UavScriptCommandsType_element*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavScriptCommandsType (OSCTXT* pctxt, 
   UavScriptCommandsType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UavScriptCommandsType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->choice_list.head;
   while (0 != pnode) {
      stat = XmlEnc_UavScriptCommandsType_element (pctxt, 
         ((UavScriptCommandsType_element*)pnode->data), 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AbsoluteHorizontalPositionElementType                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AbsoluteHorizontalPositionElementType (OSCTXT* pctxt,
   AbsoluteHorizontalPositionElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_AbsoluteHorizontalPositionElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AbsoluteHorizontalPositionElementType (OSCTXT* pctxt, 
   AbsoluteHorizontalPositionElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_AbsoluteHorizontalPositionElements (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  WeaponStatusType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_WeaponStatusType (OSCTXT* pctxt,
   WeaponStatusType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_WeaponStatusType (OSCTXT* pctxt, WeaponStatusType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      WeaponStatusType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ActionObjectElementType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ActionObjectElementType (OSCTXT* pctxt,
   ActionObjectElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode name */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_utf8str (pctxt, pvalue->name, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ActionObjectElementType (OSCTXT* pctxt, 
   ActionObjectElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" name=\""), 7);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->name, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AttackElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AttackElementType (OSCTXT* pctxt,
   AttackElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode target_list */

   if (!(pvalue->target_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "AttackElementType.target_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->target_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->target_list.tail;
   while (0 != pnode2) {
      ll = asn1E_ActionObjectElementType (pctxt, ((ActionObjectElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode weaponStatus */

   if(pvalue->weaponStatus < 0 || pvalue->weaponStatus > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
      asn1E_WeaponStatusType (pctxt, &pvalue->weaponStatus, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode singleTarget */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_boolean (pctxt, &pvalue->singleTarget, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode disableOnly */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      xe_boolean (pctxt, &pvalue->disableOnly, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AttackElementType (OSCTXT* pctxt, AttackElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   stat = rtXmlEncBoolAttr (pctxt, pvalue->disableOnly
      , OSUTF8("disableOnly"), 11);

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   stat = rtXmlEncBoolAttr (pctxt, pvalue->singleTarget
      , OSUTF8("singleTarget"), 12);

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" weaponStatus=\""), 15);

   if(pvalue->weaponStatus < 0 || pvalue->weaponStatus > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_WeaponStatusType (pctxt, pvalue->weaponStatus, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode target_list */

   if (!(pvalue->target_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "AttackElementType.target_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->target_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->target_list.head;
   while (0 != pnode) {
      stat = XmlEnc_ActionObjectElementType (pctxt, 
         ((ActionObjectElementType*)pnode->data), OSUTF8("Target"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ContaminantType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ContaminantType (OSCTXT* pctxt,
   ContaminantType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 4)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_ContaminantType (OSCTXT* pctxt, ContaminantType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      ContaminantType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ContaminantElementType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ContaminantElementType (OSCTXT* pctxt,
   ContaminantElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode type */

   if(pvalue->type < 0 || pvalue->type > 4)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_ContaminantType (pctxt, &pvalue->type, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ContaminantElementType (OSCTXT* pctxt, 
   ContaminantElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" type=\""), 7);

   if(pvalue->type < 0 || pvalue->type > 4)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_ContaminantType (pctxt, pvalue->type, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DecontaminateElementType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DecontaminateElementType (OSCTXT* pctxt,
   DecontaminateElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode contaminant_list */

   if (!(pvalue->contaminant_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "DecontaminateElementType.contaminant_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->contaminant_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->contaminant_list.tail;
   while (0 != pnode2) {
      ll = asn1E_ContaminantElementType (pctxt, ((ContaminantElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_DecontaminateElementType (OSCTXT* pctxt, 
   DecontaminateElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode contaminant_list */

   if (!(pvalue->contaminant_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "DecontaminateElementType.contaminant_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->contaminant_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->contaminant_list.head;
   while (0 != pnode) {
      stat = XmlEnc_ContaminantElementType (pctxt, 
         ((ContaminantElementType*)pnode->data)
         , OSUTF8("Contaminant"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DemolishElementType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DemolishElementType (OSCTXT* pctxt,
   DemolishElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode target_list */

   if (!(pvalue->target_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "DemolishElementType.target_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->target_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->target_list.tail;
   while (0 != pnode2) {
      ll = asn1E_ActionObjectElementType (pctxt, ((ActionObjectElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode singleTarget */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_boolean (pctxt, &pvalue->singleTarget, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode permanentDisable */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_boolean (pctxt, &pvalue->permanentDisable, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_DemolishElementType (OSCTXT* pctxt, DemolishElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   stat = rtXmlEncBoolAttr (pctxt, pvalue->permanentDisable
      , OSUTF8("permanentDisable"), 16);

   stat = rtXmlEncBoolAttr (pctxt, pvalue->singleTarget
      , OSUTF8("singleTarget"), 12);

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode target_list */

   if (!(pvalue->target_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "DemolishElementType.target_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->target_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->target_list.head;
   while (0 != pnode) {
      stat = XmlEnc_ActionObjectElementType (pctxt, 
         ((ActionObjectElementType*)pnode->data), OSUTF8("Target"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IlluminatorType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_IlluminatorType (OSCTXT* pctxt,
   IlluminatorType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_IlluminatorType (OSCTXT* pctxt, IlluminatorType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      IlluminatorType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IlluminatorElementType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_IlluminatorElementType (OSCTXT* pctxt,
   IlluminatorElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode illuminatorCharacteristic_list */

   pnode2 = pvalue->illuminatorCharacteristic_list.tail;
   while (0 != pnode2) {
      ll = asn1E_StringElementType (pctxt, ((StringElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode type */

   if(pvalue->type < 0 || pvalue->type > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_IlluminatorType (pctxt, &pvalue->type, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_IlluminatorElementType (OSCTXT* pctxt, 
   IlluminatorElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" type=\""), 7);

   if(pvalue->type < 0 || pvalue->type > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_IlluminatorType (pctxt, pvalue->type, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode illuminatorCharacteristic_list */

   { OSRTDListNode* pnode = pvalue->illuminatorCharacteristic_list.head;
   while (0 != pnode) {
      stat = XmlEnc_StringElementType (pctxt, ((StringElementType*)pnode->data)
         , OSUTF8("IlluminatorCharacteristic"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IlluminateElementType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_IlluminateElementType (OSCTXT* pctxt,
   IlluminateElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode illuminator */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_IlluminatorElementType (pctxt, &pvalue->illuminator, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_IlluminateElementType (OSCTXT* pctxt, 
   IlluminateElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode illuminator */

   stat = XmlEnc_IlluminatorElementType (pctxt, &pvalue->illuminator
      , OSUTF8("Illuminator"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FrequencyRangeElementType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_FrequencyRangeElementType (OSCTXT* pctxt,
   FrequencyRangeElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode minFrequency */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_NonNegativeScalarType (pctxt, &pvalue->minFrequency, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode maxFrequency */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_PositiveScalarType (pctxt, &pvalue->maxFrequency, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_FrequencyRangeElementType (OSCTXT* pctxt, 
   FrequencyRangeElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxFrequency=\""), 15);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxFrequency, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" minFrequency=\""), 15);

   stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->minFrequency, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  JamElementType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_JamElementType (OSCTXT* pctxt,
   JamElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode frequencyRange_list */

   if (!(pvalue->frequencyRange_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "JamElementType.frequencyRange_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->frequencyRange_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->frequencyRange_list.tail;
   while (0 != pnode2) {
      ll = asn1E_FrequencyRangeElementType (pctxt, ((FrequencyRangeElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_JamElementType (OSCTXT* pctxt, JamElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode frequencyRange_list */

   if (!(pvalue->frequencyRange_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "JamElementType.frequencyRange_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->frequencyRange_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->frequencyRange_list.head;
   while (0 != pnode) {
      stat = XmlEnc_FrequencyRangeElementType (pctxt, 
         ((FrequencyRangeElementType*)pnode->data)
         , OSUTF8("FrequencyRange"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MarkerType                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MarkerType (OSCTXT* pctxt,
   MarkerType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_MarkerType (OSCTXT* pctxt, MarkerType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      MarkerType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MarkerElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MarkerElementType (OSCTXT* pctxt,
   MarkerElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode markerCharacteristic_list */

   pnode2 = pvalue->markerCharacteristic_list.tail;
   while (0 != pnode2) {
      ll = asn1E_StringElementType (pctxt, ((StringElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode type */

   if(pvalue->type < 0 || pvalue->type > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_MarkerType (pctxt, &pvalue->type, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_MarkerElementType (OSCTXT* pctxt, MarkerElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" type=\""), 7);

   if(pvalue->type < 0 || pvalue->type > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_MarkerType (pctxt, pvalue->type, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode markerCharacteristic_list */

   { OSRTDListNode* pnode = pvalue->markerCharacteristic_list.head;
   while (0 != pnode) {
      stat = XmlEnc_StringElementType (pctxt, ((StringElementType*)pnode->data)
         , OSUTF8("MarkerCharacteristic"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MarkElementType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MarkElementType (OSCTXT* pctxt,
   MarkElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode target_list */

   if (!(pvalue->target_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "MarkElementType.target_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->target_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->target_list.tail;
   while (0 != pnode2) {
      ll = asn1E_ActionObjectElementType (pctxt, ((ActionObjectElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode marker */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_MarkerElementType (pctxt, &pvalue->marker, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_MarkElementType (OSCTXT* pctxt, MarkElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode marker */

   stat = XmlEnc_MarkerElementType (pctxt, &pvalue->marker
      , OSUTF8("Marker"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode target_list */

   if (!(pvalue->target_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "MarkElementType.target_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->target_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->target_list.head;
   while (0 != pnode) {
      stat = XmlEnc_ActionObjectElementType (pctxt, 
         ((ActionObjectElementType*)pnode->data), OSUTF8("Target"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MonitorTransmissionsElementType                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MonitorTransmissionsElementType (OSCTXT* pctxt,
   MonitorTransmissionsElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode frequencyRange_list */

   pnode2 = pvalue->frequencyRange_list.tail;
   while (0 != pnode2) {
      ll = asn1E_FrequencyRangeElementType (pctxt, ((FrequencyRangeElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_MonitorTransmissionsElementType (OSCTXT* pctxt, 
   MonitorTransmissionsElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode frequencyRange_list */

   { OSRTDListNode* pnode = pvalue->frequencyRange_list.head;
   while (0 != pnode) {
      stat = XmlEnc_FrequencyRangeElementType (pctxt, 
         ((FrequencyRangeElementType*)pnode->data)
         , OSUTF8("FrequencyRange"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PatrolElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PatrolElementType (OSCTXT* pctxt,
   PatrolElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode qualifier_list */

   pnode2 = pvalue->qualifier_list.tail;
   while (0 != pnode2) {
      ll = asn1E_StringElementType (pctxt, ((StringElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_PatrolElementType (OSCTXT* pctxt, PatrolElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode qualifier_list */

   { OSRTDListNode* pnode = pvalue->qualifier_list.head;
   while (0 != pnode) {
      stat = XmlEnc_StringElementType (pctxt, ((StringElementType*)pnode->data)
         , OSUTF8("Qualifier"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RendezvousElementType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_RendezvousElementType (OSCTXT* pctxt,
   RendezvousElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode qualifier_list */

   pnode2 = pvalue->qualifier_list.tail;
   while (0 != pnode2) {
      ll = asn1E_StringElementType (pctxt, ((StringElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode targetVehicleID */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_utf8str (pctxt, pvalue->targetVehicleID, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_RendezvousElementType (OSCTXT* pctxt, 
   RendezvousElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" targetVehicleID=\""), 18);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->targetVehicleID, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode qualifier_list */

   { OSRTDListNode* pnode = pvalue->qualifier_list.head;
   while (0 != pnode) {
      stat = XmlEnc_StringElementType (pctxt, ((StringElementType*)pnode->data)
         , OSUTF8("Qualifier"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SampleEnvironmentElementType                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SampleEnvironmentElementType (OSCTXT* pctxt,
   SampleEnvironmentElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode contaminant_list */

   if (!(pvalue->contaminant_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "SampleEnvironmentElementType.contaminant_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->contaminant_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->contaminant_list.tail;
   while (0 != pnode2) {
      ll = asn1E_ContaminantElementType (pctxt, ((ContaminantElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SampleEnvironmentElementType (OSCTXT* pctxt, 
   SampleEnvironmentElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode contaminant_list */

   if (!(pvalue->contaminant_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "SampleEnvironmentElementType.contaminant_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->contaminant_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->contaminant_list.head;
   while (0 != pnode) {
      stat = XmlEnc_ContaminantElementType (pctxt, 
         ((ContaminantElementType*)pnode->data)
         , OSUTF8("Contaminant"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DatumTypeType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DatumTypeType (OSCTXT* pctxt,
   DatumTypeType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_DatumTypeType (OSCTXT* pctxt, DatumTypeType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      DatumTypeType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SearchElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SearchElementType (OSCTXT* pctxt,
   SearchElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode searchTarget_list */

   pnode2 = pvalue->searchTarget_list.tail;
   while (0 != pnode2) {
      ll = asn1E_ActionObjectElementType (pctxt, ((ActionObjectElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode singleTarget */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_boolean (pctxt, &pvalue->singleTarget, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode requiredPD */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_PercentType (pctxt, &pvalue->requiredPD, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode datumType */

   if(pvalue->datumType < 0 || pvalue->datumType > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_DatumTypeType (pctxt, &pvalue->datumType, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SearchElementType (OSCTXT* pctxt, SearchElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" datumType=\""), 12);

   if(pvalue->datumType < 0 || pvalue->datumType > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_DatumTypeType (pctxt, pvalue->datumType, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" requiredPD=\""), 13);

   stat = XmlEnc_PercentType (pctxt, pvalue->requiredPD, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   stat = rtXmlEncBoolAttr (pctxt, pvalue->singleTarget
      , OSUTF8("singleTarget"), 12);

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode searchTarget_list */

   { OSRTDListNode* pnode = pvalue->searchTarget_list.head;
   while (0 != pnode) {
      stat = XmlEnc_ActionObjectElementType (pctxt, 
         ((ActionObjectElementType*)pnode->data)
         , OSUTF8("SearchTarget"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GoalElements                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_GoalElements (OSCTXT* pctxt,
   GoalElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_AttackElementType (pctxt, pvalue->u.attack, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_DecontaminateElementType (pctxt, pvalue->u.decontaminate, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_DemolishElementType (pctxt, pvalue->u.demolish, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_IlluminateElementType (pctxt, pvalue->u.illuminateArea, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_JamElementType (pctxt, pvalue->u.jam, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
            asn1E_MarkElementType (pctxt, pvalue->u.markTarget, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
            asn1E_MonitorTransmissionsElementType (pctxt, pvalue->u.monitorTransmissions, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
            asn1E_PatrolElementType (pctxt, pvalue->u.patrol, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
            asn1E_RendezvousElementType (pctxt, pvalue->u.rendezvous, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 10:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
            asn1E_NoValueElementType (pctxt, pvalue->u.reposition, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 11:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
            asn1E_SampleEnvironmentElementType (pctxt, pvalue->u.sampleEnvironment, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 12:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
            asn1E_SearchElementType (pctxt, pvalue->u.search, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_GoalElements (OSCTXT* pctxt, GoalElements* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode attack */

         stat = XmlEnc_AttackElementType (pctxt, pvalue->u.attack
            , OSUTF8("Attack"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode decontaminate */

         stat = XmlEnc_DecontaminateElementType (pctxt, pvalue->u.decontaminate
            , OSUTF8("Decontaminate"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode demolish */

         stat = XmlEnc_DemolishElementType (pctxt, pvalue->u.demolish
            , OSUTF8("Demolish"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode illuminateArea */

         stat = XmlEnc_IlluminateElementType (pctxt, pvalue->u.illuminateArea
            , OSUTF8("IlluminateArea"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode jam */

         stat = XmlEnc_JamElementType (pctxt, pvalue->u.jam
            , OSUTF8("Jam"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode markTarget */

         stat = XmlEnc_MarkElementType (pctxt, pvalue->u.markTarget
            , OSUTF8("MarkTarget"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode monitorTransmissions */

         stat = XmlEnc_MonitorTransmissionsElementType (pctxt, pvalue->
            u.monitorTransmissions, OSUTF8("MonitorTransmissions"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode patrol */

         stat = XmlEnc_PatrolElementType (pctxt, pvalue->u.patrol
            , OSUTF8("Patrol"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode rendezvous */

         stat = XmlEnc_RendezvousElementType (pctxt, pvalue->u.rendezvous
            , OSUTF8("Rendezvous"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 10:
         /* encode reposition */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.reposition
            , OSUTF8("Reposition"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 11:
         /* encode sampleEnvironment */

         stat = XmlEnc_SampleEnvironmentElementType (pctxt, pvalue->
            u.sampleEnvironment, OSUTF8("SampleEnvironment"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 12:
         /* encode search */

         stat = XmlEnc_SearchElementType (pctxt, pvalue->u.search
            , OSUTF8("Search"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CircleElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_CircleElementType (OSCTXT* pctxt,
   CircleElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode radius */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
      asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->radius, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode center */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->center, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_CircleElementType (OSCTXT* pctxt, CircleElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode center */

   stat = XmlEnc_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->center
      , OSUTF8("Center"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode radius */

   stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->radius
      , OSUTF8("Radius"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AreaOrientationType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AreaOrientationType (OSCTXT* pctxt,
   AreaOrientationType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_real (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_AreaOrientationType (OSCTXT* pctxt, AreaOrientationType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncDouble (pctxt, value, elemName, nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AreaOrientationElementType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AreaOrientationElementType (OSCTXT* pctxt,
   AreaOrientationElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_AreaOrientationType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AreaOrientationElementType (OSCTXT* pctxt, 
   AreaOrientationElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   stat = XmlEnc_AreaOrientationType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RectangleElementType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_RectangleElementType (OSCTXT* pctxt,
   RectangleElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode orientation */

   if (pvalue->m.orientationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_AreaOrientationElementType (pctxt, &pvalue->orientation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode height */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
      asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->height, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode width */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
      asn1E_PositiveScalarElementType_derivations (pctxt, &pvalue->width, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode northwestCorner */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->northwestCorner, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_RectangleElementType (OSCTXT* pctxt, RectangleElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode northwestCorner */

   stat = XmlEnc_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->
      northwestCorner, OSUTF8("NorthwestCorner"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode width */

   stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->width
      , OSUTF8("Width"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode height */

   stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, &pvalue->height
      , OSUTF8("Height"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode orientation */

   if (pvalue->m.orientationPresent) {
      stat = XmlEnc_AreaOrientationElementType (pctxt, &pvalue->orientation
         , OSUTF8("Orientation"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PolygonElementType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_PolygonElementType (OSCTXT* pctxt,
   PolygonElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_PointListElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_PolygonElementType (OSCTXT* pctxt, PolygonElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_PointListElements (pctxt, &pvalue->choice, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LimitingLineElementType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_LimitingLineElementType (OSCTXT* pctxt,
   LimitingLineElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_PointListElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_LimitingLineElementType (OSCTXT* pctxt, 
   LimitingLineElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_PointListElements (pctxt, &pvalue->choice, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AreaElements                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AreaElements (OSCTXT* pctxt,
   AreaElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_AbsoluteHorizontalPositionElementType (pctxt, pvalue->u.point, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_CircleElementType (pctxt, pvalue->u.circle, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_RectangleElementType (pctxt, pvalue->u.rectangle, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_PolygonElementType (pctxt, pvalue->u.polygon, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_LimitingLineElementType (pctxt, pvalue->u.limitingLine, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_AreaElements (OSCTXT* pctxt, AreaElements* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode point */

         stat = XmlEnc_AbsoluteHorizontalPositionElementType (pctxt, pvalue->
            u.point, OSUTF8("Point"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode circle */

         stat = XmlEnc_CircleElementType (pctxt, pvalue->u.circle
            , OSUTF8("Circle"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode rectangle */

         stat = XmlEnc_RectangleElementType (pctxt, pvalue->u.rectangle
            , OSUTF8("Rectangle"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode polygon */

         stat = XmlEnc_PolygonElementType (pctxt, pvalue->u.polygon
            , OSUTF8("Polygon"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode limitingLine */

         stat = XmlEnc_LimitingLineElementType (pctxt, pvalue->u.limitingLine
            , OSUTF8("LimitingLine"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NumericalBlockElementType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_NumericalBlockElementType (OSCTXT* pctxt,
   NumericalBlockElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode minimum */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_NonNegativeScalarType (pctxt, &pvalue->minimum, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode maximum */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_PositiveScalarType (pctxt, &pvalue->maximum, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_NumericalBlockElementType (OSCTXT* pctxt, 
   NumericalBlockElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" maximum=\""), 10);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maximum, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" minimum=\""), 10);

   stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->minimum, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DepthBlockElements                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DepthBlockElements (OSCTXT* pctxt,
   DepthBlockElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_NumericalBlockElementType (pctxt, pvalue->u.depthBlock, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_NumericalBlockElementType (pctxt, pvalue->u.altitudeBlock, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_NumericalBlockElementType (pctxt, pvalue->u.depthAltitudeBlock, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_DepthBlockElements (OSCTXT* pctxt, DepthBlockElements* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode depthBlock */

         stat = XmlEnc_NumericalBlockElementType (pctxt, pvalue->u.depthBlock
            , OSUTF8("DepthBlock"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode altitudeBlock */

         stat = XmlEnc_NumericalBlockElementType (pctxt, pvalue->
            u.altitudeBlock, OSUTF8("AltitudeBlock"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode depthAltitudeBlock */

         stat = XmlEnc_NumericalBlockElementType (pctxt, pvalue->
            u.depthAltitudeBlock, OSUTF8("DepthAltitudeBlock"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AltitudeBlockElements                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AltitudeBlockElements (OSCTXT* pctxt,
   AltitudeBlockElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_NumericalBlockElementType (pctxt, pvalue->u.aGLAltitudeBlock, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_NumericalBlockElementType (pctxt, pvalue->u.mSLAltitudeBlock, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_NumericalBlockElementType (pctxt, pvalue->u.aGLMSLAltitudeBlock, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_AltitudeBlockElements (OSCTXT* pctxt, 
   AltitudeBlockElements* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode aGLAltitudeBlock */

         stat = XmlEnc_NumericalBlockElementType (pctxt, pvalue->
            u.aGLAltitudeBlock, OSUTF8("AGLAltitudeBlock"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode mSLAltitudeBlock */

         stat = XmlEnc_NumericalBlockElementType (pctxt, pvalue->
            u.mSLAltitudeBlock, OSUTF8("MSLAltitudeBlock"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode aGLMSLAltitudeBlock */

         stat = XmlEnc_NumericalBlockElementType (pctxt, pvalue->
            u.aGLMSLAltitudeBlock, OSUTF8("AGLMSLAltitudeBlock"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VerticalBlockElements                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_VerticalBlockElements (OSCTXT* pctxt,
   VerticalBlockElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_DepthTypeElements (pctxt, pvalue->u.choice, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_AltitudeTypeElements (pctxt, pvalue->u.choice_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_DepthBlockElements (pctxt, pvalue->u.choice_2, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_AltitudeBlockElements (pctxt, pvalue->u.choice_3, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_VerticalBlockElements (OSCTXT* pctxt, 
   VerticalBlockElements* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode choice */

         stat = XmlEnc_DepthTypeElements (pctxt, pvalue->u.choice
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode choice_1 */

         stat = XmlEnc_AltitudeTypeElements (pctxt, pvalue->u.choice_1
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode choice_2 */

         stat = XmlEnc_DepthBlockElements (pctxt, pvalue->u.choice_2
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode choice_3 */

         stat = XmlEnc_AltitudeBlockElements (pctxt, pvalue->u.choice_3
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AreaElementType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AreaElementType (OSCTXT* pctxt,
   AreaElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_VerticalBlockElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_AreaElements (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AreaElementType (OSCTXT* pctxt, AreaElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_AreaElements (pctxt, &pvalue->choice, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_VerticalBlockElements (pctxt, &pvalue->choice_1
         , 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AbsoluteTimingElementType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AbsoluteTimingElementType (OSCTXT* pctxt,
   AbsoluteTimingElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode stop */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_PositiveScalarType (pctxt, &pvalue->stop, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode start */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_NonNegativeScalarType (pctxt, &pvalue->start, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AbsoluteTimingElementType (OSCTXT* pctxt, 
   AbsoluteTimingElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" start=\""), 8);

   stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->start, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" stop=\""), 7);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->stop, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TimingTypeElements                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TimingTypeElements (OSCTXT* pctxt,
   TimingTypeElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.duration, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_AbsoluteTimingElementType (pctxt, pvalue->u.timing, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_TimingTypeElements (OSCTXT* pctxt, TimingTypeElements* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode duration */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.duration, OSUTF8("Duration"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode timing */

         stat = XmlEnc_AbsoluteTimingElementType (pctxt, pvalue->u.timing
            , OSUTF8("Timing"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ReportingCriteriaType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ReportingCriteriaType (OSCTXT* pctxt,
   ReportingCriteriaType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 4)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_ReportingCriteriaType (OSCTXT* pctxt, ReportingCriteriaType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      ReportingCriteriaType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ReportingCriteriaElementType                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ReportingCriteriaElementType (OSCTXT* pctxt,
   ReportingCriteriaElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   if(pvalue->value < 0 || pvalue->value > 4)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      asn1E_ReportingCriteriaType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode periodicity */

   if (pvalue->m.periodicityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_PositiveScalarType (pctxt, &pvalue->periodicity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ReportingCriteriaElementType (OSCTXT* pctxt, 
   ReportingCriteriaElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.periodicityPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" periodicity=\""), 14);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->periodicity, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   if(pvalue->value < 0 || pvalue->value > 4)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_ReportingCriteriaType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AgendaGoalElementType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AgendaGoalElementType (OSCTXT* pctxt,
   AgendaGoalElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode reportingCriteria_list */

   pnode2 = pvalue->reportingCriteria_list.tail;
   while (0 != pnode2) {
      ll = asn1E_ReportingCriteriaElementType (pctxt, ((ReportingCriteriaElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode choice_1 */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
      asn1E_TimingTypeElements (pctxt, &pvalue->choice_1, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode operatingArea */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
      asn1E_AreaElementType (pctxt, &pvalue->operatingArea, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
      asn1E_GoalElements (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode nextOnSucceed */

   if (pvalue->m.nextOnSucceedPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->nextOnSucceed, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode nextOnFail */

   if (pvalue->m.nextOnFailPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->nextOnFail, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode alert */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      xe_boolean (pctxt, &pvalue->alert, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AgendaGoalElementType (OSCTXT* pctxt, 
   AgendaGoalElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   stat = rtXmlEncBoolAttr (pctxt, pvalue->alert, OSUTF8("alert"), 5);

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.nextOnFailPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" nextOnFail=\""), 13);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->nextOnFail, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.nextOnSucceedPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" nextOnSucceed=\""), 16);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->nextOnSucceed, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_GoalElements (pctxt, &pvalue->choice, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode operatingArea */

   stat = XmlEnc_AreaElementType (pctxt, &pvalue->operatingArea
      , OSUTF8("OperatingArea"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode choice_1 */

   stat = XmlEnc_TimingTypeElements (pctxt, &pvalue->choice_1, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode reportingCriteria_list */

   { OSRTDListNode* pnode = pvalue->reportingCriteria_list.head;
   while (0 != pnode) {
      stat = XmlEnc_ReportingCriteriaElementType (pctxt, 
         ((ReportingCriteriaElementType*)pnode->data)
         , OSUTF8("ReportingCriteria"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AgendaGoalListType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AgendaGoalListType (OSCTXT* pctxt,
   AgendaGoalListType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode goal_list */

   if (!(pvalue->goal_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "AgendaGoalListType.goal_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->goal_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->goal_list.tail;
   while (0 != pnode2) {
      ll = asn1E_AgendaGoalElementType (pctxt, ((AgendaGoalElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AgendaGoalListType (OSCTXT* pctxt, AgendaGoalListType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode goal_list */

   if (!(pvalue->goal_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "AgendaGoalListType.goal_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->goal_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->goal_list.head;
   while (0 != pnode) {
      stat = XmlEnc_AgendaGoalElementType (pctxt, 
         ((AgendaGoalElementType*)pnode->data), OSUTF8("Goal"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RouteElementType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_RouteElementType (OSCTXT* pctxt,
   RouteElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_VerticalBlockElements (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_PointListElements (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_RouteElementType (OSCTXT* pctxt, RouteElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_PointListElements (pctxt, &pvalue->choice, 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_VerticalBlockElements (pctxt, &pvalue->choice_1
         , 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AgendaConstraintListType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AgendaConstraintListType (OSCTXT* pctxt,
   AgendaConstraintListType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode egressRouting */

   if (pvalue->m.egressRoutingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_RouteElementType (pctxt, &pvalue->egressRouting, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode avoidArea_list */

   pnode2 = pvalue->avoidArea_list.tail;
   while (0 != pnode2) {
      ll = asn1E_AreaElementType (pctxt, ((AreaElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode ingressRouting */

   if (pvalue->m.ingressRoutingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_RouteElementType (pctxt, &pvalue->ingressRouting, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AgendaConstraintListType (OSCTXT* pctxt, 
   AgendaConstraintListType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode ingressRouting */

   if (pvalue->m.ingressRoutingPresent) {
      stat = XmlEnc_RouteElementType (pctxt, &pvalue->ingressRouting
         , OSUTF8("IngressRouting"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode avoidArea_list */

   { OSRTDListNode* pnode = pvalue->avoidArea_list.head;
   while (0 != pnode) {
      stat = XmlEnc_AreaElementType (pctxt, ((AreaElementType*)pnode->data)
         , OSUTF8("AvoidArea"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   /* encode egressRouting */

   if (pvalue->m.egressRoutingPresent) {
      stat = XmlEnc_RouteElementType (pctxt, &pvalue->egressRouting
         , OSUTF8("EgressRouting"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AgendaMissionElementType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AgendaMissionElementType (OSCTXT* pctxt,
   AgendaMissionElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode constraintList */

   if (pvalue->m.constraintListPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_AgendaConstraintListType (pctxt, &pvalue->constraintList, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode goalList */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
      asn1E_AgendaGoalListType (pctxt, &pvalue->goalList, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode recoveryPosition */

   if (pvalue->m.recoveryPositionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->recoveryPosition, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode launchPosition */

   if (pvalue->m.launchPositionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->launchPosition, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AgendaMissionElementType (OSCTXT* pctxt, 
   AgendaMissionElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode launchPosition */

   if (pvalue->m.launchPositionPresent) {
      stat = XmlEnc_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->
         launchPosition, OSUTF8("LaunchPosition"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode recoveryPosition */

   if (pvalue->m.recoveryPositionPresent) {
      stat = XmlEnc_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->
         recoveryPosition, OSUTF8("RecoveryPosition"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode goalList */

   stat = XmlEnc_AgendaGoalListType (pctxt, &pvalue->goalList
      , OSUTF8("GoalList"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode constraintList */

   if (pvalue->m.constraintListPresent) {
      stat = XmlEnc_AgendaConstraintListType (pctxt, &pvalue->constraintList
         , OSUTF8("ConstraintList"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MissionSpecification                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MissionSpecification (OSCTXT* pctxt,
   MissionSpecification *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UuvScriptCommandsType (pctxt, pvalue->u.uUVCommandScript, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_UsvScriptCommandsType (pctxt, pvalue->u.uSVCommandScript, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_UgvScriptCommandsType (pctxt, pvalue->u.uGVCommandScript, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_UavScriptCommandsType (pctxt, pvalue->u.uAVCommandScript, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_AgendaMissionElementType (pctxt, pvalue->u.agendaMission, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_MissionSpecification (OSCTXT* pctxt, MissionSpecification* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode uUVCommandScript */

         stat = XmlEnc_UuvScriptCommandsType (pctxt, pvalue->u.uUVCommandScript
            , OSUTF8("UUVCommandScript"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode uSVCommandScript */

         stat = XmlEnc_UsvScriptCommandsType (pctxt, pvalue->u.uSVCommandScript
            , OSUTF8("USVCommandScript"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode uGVCommandScript */

         stat = XmlEnc_UgvScriptCommandsType (pctxt, pvalue->u.uGVCommandScript
            , OSUTF8("UGVCommandScript"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode uAVCommandScript */

         stat = XmlEnc_UavScriptCommandsType (pctxt, pvalue->u.uAVCommandScript
            , OSUTF8("UAVCommandScript"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode agendaMission */

         stat = XmlEnc_AgendaMissionElementType (pctxt, pvalue->u.agendaMission
            , OSUTF8("AgendaMission"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InformationRequestType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_InformationRequestType (OSCTXT* pctxt,
   InformationRequestType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 8)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_InformationRequestType (OSCTXT* pctxt, 
   InformationRequestType value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      InformationRequestType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  InformationRequestElementType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_InformationRequestElementType (OSCTXT* pctxt,
   InformationRequestElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode informationType */

   if(pvalue->informationType < 0 || pvalue->informationType > 8)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_InformationRequestType (pctxt, &pvalue->informationType, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_InformationRequestElementType (OSCTXT* pctxt, 
   InformationRequestElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" informationType=\""), 18);

   if(pvalue->informationType < 0 || pvalue->informationType > 8)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_InformationRequestType (pctxt, pvalue->informationType
      , 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VehicleGroupCompositionType                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_VehicleGroupCompositionType (OSCTXT* pctxt,
   VehicleGroupCompositionType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 6)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_VehicleGroupCompositionType (OSCTXT* pctxt, 
   VehicleGroupCompositionType value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      VehicleGroupCompositionType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VehicleGroupCompositionElementType                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_VehicleGroupCompositionElementType (OSCTXT* pctxt,
   VehicleGroupCompositionElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode request */

   if(pvalue->request < 0 || pvalue->request > 6)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_VehicleGroupCompositionType (pctxt, &pvalue->request, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_VehicleGroupCompositionElementType (OSCTXT* pctxt, 
   VehicleGroupCompositionElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" request=\""), 10);

   if(pvalue->request < 0 || pvalue->request > 6)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_VehicleGroupCompositionType (pctxt, pvalue->request, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DimensionsElementType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DimensionsElementType (OSCTXT* pctxt,
   DimensionsElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode width */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_PositiveScalarType (pctxt, &pvalue->width, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode mass */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_PositiveScalarType (pctxt, &pvalue->mass, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode length */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      asn1E_PositiveScalarType (pctxt, &pvalue->length, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode height */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_PositiveScalarType (pctxt, &pvalue->height, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_DimensionsElementType (OSCTXT* pctxt, 
   DimensionsElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" height=\""), 9);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->height, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" length=\""), 9);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->length, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" mass=\""), 7);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->mass, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" width=\""), 8);

   stat = XmlEnc_PositiveScalarType (pctxt, pvalue->width, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvOperatingCharacteristicsElementType                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvOperatingCharacteristicsElementType (OSCTXT* pctxt,
   UuvOperatingCharacteristicsElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode turnRadius */

   if (pvalue->m.turnRadiusPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
         asn1E_PositiveScalarType (pctxt, &pvalue->turnRadius, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode maxYawRate */

   if (pvalue->m.maxYawRatePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         asn1E_PositiveScalarType (pctxt, &pvalue->maxYawRate, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode maxSpeed */

   if (pvalue->m.maxSpeedPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_PositiveScalarType (pctxt, &pvalue->maxSpeed, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode maxPitchRate */

   if (pvalue->m.maxPitchRatePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_PositiveScalarType (pctxt, &pvalue->maxPitchRate, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode maxDepth */

   if (pvalue->m.maxDepthPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_PositiveScalarType (pctxt, &pvalue->maxDepth, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode endurance */

   if (pvalue->m.endurancePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_PositiveScalarType (pctxt, &pvalue->endurance, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode cruiseSpeed */

   if (pvalue->m.cruiseSpeedPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_PositiveScalarType (pctxt, &pvalue->cruiseSpeed, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvOperatingCharacteristicsElementType (OSCTXT* pctxt, 
   UuvOperatingCharacteristicsElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.cruiseSpeedPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" cruiseSpeed=\""), 14);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->cruiseSpeed, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.endurancePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" endurance=\""), 12);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->endurance, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.maxDepthPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxDepth=\""), 11);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxDepth, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.maxPitchRatePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxPitchRate=\""), 15);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxPitchRate, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.maxSpeedPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxSpeed=\""), 11);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxSpeed, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.maxYawRatePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxYawRate=\""), 13);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxYawRate, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.turnRadiusPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" turnRadius=\""), 13);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->turnRadius, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DegreesOfControlElementType                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DegreesOfControlElementType (OSCTXT* pctxt,
   DegreesOfControlElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode yaw */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
      xe_boolean (pctxt, &pvalue->yaw, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode vertical */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
      xe_boolean (pctxt, &pvalue->vertical, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode roll */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
      xe_boolean (pctxt, &pvalue->roll, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode pitch */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_boolean (pctxt, &pvalue->pitch, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode longitudinal */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_boolean (pctxt, &pvalue->longitudinal, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode lateral */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_boolean (pctxt, &pvalue->lateral, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_DegreesOfControlElementType (OSCTXT* pctxt, 
   DegreesOfControlElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   stat = rtXmlEncBoolAttr (pctxt, pvalue->lateral, OSUTF8("lateral"), 7);

   stat = rtXmlEncBoolAttr (pctxt, pvalue->longitudinal
      , OSUTF8("longitudinal"), 12);

   stat = rtXmlEncBoolAttr (pctxt, pvalue->pitch, OSUTF8("pitch"), 5);

   stat = rtXmlEncBoolAttr (pctxt, pvalue->roll, OSUTF8("roll"), 4);

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   stat = rtXmlEncBoolAttr (pctxt, pvalue->vertical, OSUTF8("vertical"), 8);

   stat = rtXmlEncBoolAttr (pctxt, pvalue->yaw, OSUTF8("yaw"), 3);

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvCapabilityType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvCapabilityType (OSCTXT* pctxt,
   UuvCapabilityType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 9)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_UuvCapabilityType (OSCTXT* pctxt, UuvCapabilityType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      UuvCapabilityType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvCapabilityElementType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvCapabilityElementType (OSCTXT* pctxt,
   UuvCapabilityElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   if(pvalue->value < 0 || pvalue->value > 9)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_UuvCapabilityType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvCapabilityElementType (OSCTXT* pctxt, 
   UuvCapabilityElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   if(pvalue->value < 0 || pvalue->value > 9)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_UuvCapabilityType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvCharacteristicsElementType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvCharacteristicsElementType (OSCTXT* pctxt,
   UuvCharacteristicsElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode capability_list */

   pnode2 = pvalue->capability_list.tail;
   while (0 != pnode2) {
      ll = asn1E_UuvCapabilityElementType (pctxt, ((UuvCapabilityElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode degreesOfControl */

   if (pvalue->m.degreesOfControlPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_DegreesOfControlElementType (pctxt, &pvalue->degreesOfControl, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode operatingCharacteristics */

   if (pvalue->m.operatingCharacteristicsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_UuvOperatingCharacteristicsElementType (pctxt, &pvalue->operatingCharacteristics, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode dimensions */

   if (pvalue->m.dimensionsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_DimensionsElementType (pctxt, &pvalue->dimensions, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvCharacteristicsElementType (OSCTXT* pctxt, 
   UuvCharacteristicsElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode dimensions */

   if (pvalue->m.dimensionsPresent) {
      stat = XmlEnc_DimensionsElementType (pctxt, &pvalue->dimensions
         , OSUTF8("Dimensions"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode operatingCharacteristics */

   if (pvalue->m.operatingCharacteristicsPresent) {
      stat = XmlEnc_UuvOperatingCharacteristicsElementType (pctxt, &pvalue->
         operatingCharacteristics
         , OSUTF8("OperatingCharacteristics"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode degreesOfControl */

   if (pvalue->m.degreesOfControlPresent) {
      stat = XmlEnc_DegreesOfControlElementType (pctxt, &pvalue->
         degreesOfControl, OSUTF8("DegreesOfControl"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode capability_list */

   { OSRTDListNode* pnode = pvalue->capability_list.head;
   while (0 != pnode) {
      stat = XmlEnc_UuvCapabilityElementType (pctxt, 
         ((UuvCapabilityElementType*)pnode->data)
         , OSUTF8("Capability"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvOperatingCharacteristicsElementType                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvOperatingCharacteristicsElementType (OSCTXT* pctxt,
   UgvOperatingCharacteristicsElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode wheelBase */

   if (pvalue->m.wheelBasePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|11,
         asn1E_PositiveScalarType (pctxt, &pvalue->wheelBase, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode turnRadius */

   if (pvalue->m.turnRadiusPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
         asn1E_PositiveScalarType (pctxt, &pvalue->turnRadius, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode trackWidth */

   if (pvalue->m.trackWidthPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
         asn1E_PositiveScalarType (pctxt, &pvalue->trackWidth, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode staticRollover */

   if (pvalue->m.staticRolloverPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         asn1E_PositiveScalarType (pctxt, &pvalue->staticRollover, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode staticPitchover */

   if (pvalue->m.staticPitchoverPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_PositiveScalarType (pctxt, &pvalue->staticPitchover, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode maxYawRate */

   if (pvalue->m.maxYawRatePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_PositiveScalarType (pctxt, &pvalue->maxYawRate, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode maxSpeed */

   if (pvalue->m.maxSpeedPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_PositiveScalarType (pctxt, &pvalue->maxSpeed, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode endurance */

   if (pvalue->m.endurancePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_PositiveScalarType (pctxt, &pvalue->endurance, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode cruiseSpeed */

   if (pvalue->m.cruiseSpeedPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_PositiveScalarType (pctxt, &pvalue->cruiseSpeed, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UgvOperatingCharacteristicsElementType (OSCTXT* pctxt, 
   UgvOperatingCharacteristicsElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.cruiseSpeedPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" cruiseSpeed=\""), 14);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->cruiseSpeed, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.endurancePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" endurance=\""), 12);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->endurance, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.maxSpeedPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxSpeed=\""), 11);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxSpeed, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.maxYawRatePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxYawRate=\""), 13);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxYawRate, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.staticPitchoverPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" staticPitchover=\""), 18);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->staticPitchover, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.staticRolloverPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" staticRollover=\""), 17);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->staticRollover, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.trackWidthPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" trackWidth=\""), 13);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->trackWidth, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.turnRadiusPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" turnRadius=\""), 13);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->turnRadius, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.wheelBasePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" wheelBase=\""), 12);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->wheelBase, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvCapabilityType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvCapabilityType (OSCTXT* pctxt,
   UgvCapabilityType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_UgvCapabilityType (OSCTXT* pctxt, UgvCapabilityType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      UgvCapabilityType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvCapabilityElementType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvCapabilityElementType (OSCTXT* pctxt,
   UgvCapabilityElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   if(pvalue->value < 0 || pvalue->value > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_UgvCapabilityType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UgvCapabilityElementType (OSCTXT* pctxt, 
   UgvCapabilityElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   if(pvalue->value < 0 || pvalue->value > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_UgvCapabilityType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvCharacteristicsElementType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvCharacteristicsElementType (OSCTXT* pctxt,
   UgvCharacteristicsElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode capability_list */

   pnode2 = pvalue->capability_list.tail;
   while (0 != pnode2) {
      ll = asn1E_UgvCapabilityElementType (pctxt, ((UgvCapabilityElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode degreesOfControl */

   if (pvalue->m.degreesOfControlPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_DegreesOfControlElementType (pctxt, &pvalue->degreesOfControl, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode operatingCharacteristics */

   if (pvalue->m.operatingCharacteristicsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_UgvOperatingCharacteristicsElementType (pctxt, &pvalue->operatingCharacteristics, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode dimensions */

   if (pvalue->m.dimensionsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_DimensionsElementType (pctxt, &pvalue->dimensions, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UgvCharacteristicsElementType (OSCTXT* pctxt, 
   UgvCharacteristicsElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode dimensions */

   if (pvalue->m.dimensionsPresent) {
      stat = XmlEnc_DimensionsElementType (pctxt, &pvalue->dimensions
         , OSUTF8("Dimensions"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode operatingCharacteristics */

   if (pvalue->m.operatingCharacteristicsPresent) {
      stat = XmlEnc_UgvOperatingCharacteristicsElementType (pctxt, &pvalue->
         operatingCharacteristics
         , OSUTF8("OperatingCharacteristics"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode degreesOfControl */

   if (pvalue->m.degreesOfControlPresent) {
      stat = XmlEnc_DegreesOfControlElementType (pctxt, &pvalue->
         degreesOfControl, OSUTF8("DegreesOfControl"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode capability_list */

   { OSRTDListNode* pnode = pvalue->capability_list.head;
   while (0 != pnode) {
      stat = XmlEnc_UgvCapabilityElementType (pctxt, 
         ((UgvCapabilityElementType*)pnode->data)
         , OSUTF8("Capability"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvOperatingCharacteristicsElementType                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvOperatingCharacteristicsElementType (OSCTXT* pctxt,
   UsvOperatingCharacteristicsElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode turnRadius */

   if (pvalue->m.turnRadiusPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         asn1E_PositiveScalarType (pctxt, &pvalue->turnRadius, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode maxYawRate */

   if (pvalue->m.maxYawRatePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_PositiveScalarType (pctxt, &pvalue->maxYawRate, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode maxSpeed */

   if (pvalue->m.maxSpeedPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_PositiveScalarType (pctxt, &pvalue->maxSpeed, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode endurance */

   if (pvalue->m.endurancePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_PositiveScalarType (pctxt, &pvalue->endurance, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode cruiseSpeed */

   if (pvalue->m.cruiseSpeedPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_PositiveScalarType (pctxt, &pvalue->cruiseSpeed, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UsvOperatingCharacteristicsElementType (OSCTXT* pctxt, 
   UsvOperatingCharacteristicsElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.cruiseSpeedPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" cruiseSpeed=\""), 14);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->cruiseSpeed, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.endurancePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" endurance=\""), 12);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->endurance, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.maxSpeedPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxSpeed=\""), 11);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxSpeed, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.maxYawRatePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxYawRate=\""), 13);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxYawRate, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.turnRadiusPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" turnRadius=\""), 13);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->turnRadius, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvCapabilityType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvCapabilityType (OSCTXT* pctxt,
   UsvCapabilityType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_UsvCapabilityType (OSCTXT* pctxt, UsvCapabilityType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      UsvCapabilityType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvCapabilityElementType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvCapabilityElementType (OSCTXT* pctxt,
   UsvCapabilityElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   if(pvalue->value < 0 || pvalue->value > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_UsvCapabilityType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UsvCapabilityElementType (OSCTXT* pctxt, 
   UsvCapabilityElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   if(pvalue->value < 0 || pvalue->value > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_UsvCapabilityType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvCharacteristicsElementType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvCharacteristicsElementType (OSCTXT* pctxt,
   UsvCharacteristicsElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode capability_list */

   pnode2 = pvalue->capability_list.tail;
   while (0 != pnode2) {
      ll = asn1E_UsvCapabilityElementType (pctxt, ((UsvCapabilityElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode degreesOfControl */

   if (pvalue->m.degreesOfControlPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_DegreesOfControlElementType (pctxt, &pvalue->degreesOfControl, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode operatingCharacteristics */

   if (pvalue->m.operatingCharacteristicsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_UsvOperatingCharacteristicsElementType (pctxt, &pvalue->operatingCharacteristics, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode dimensions */

   if (pvalue->m.dimensionsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_DimensionsElementType (pctxt, &pvalue->dimensions, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UsvCharacteristicsElementType (OSCTXT* pctxt, 
   UsvCharacteristicsElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode dimensions */

   if (pvalue->m.dimensionsPresent) {
      stat = XmlEnc_DimensionsElementType (pctxt, &pvalue->dimensions
         , OSUTF8("Dimensions"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode operatingCharacteristics */

   if (pvalue->m.operatingCharacteristicsPresent) {
      stat = XmlEnc_UsvOperatingCharacteristicsElementType (pctxt, &pvalue->
         operatingCharacteristics
         , OSUTF8("OperatingCharacteristics"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode degreesOfControl */

   if (pvalue->m.degreesOfControlPresent) {
      stat = XmlEnc_DegreesOfControlElementType (pctxt, &pvalue->
         degreesOfControl, OSUTF8("DegreesOfControl"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode capability_list */

   { OSRTDListNode* pnode = pvalue->capability_list.head;
   while (0 != pnode) {
      stat = XmlEnc_UsvCapabilityElementType (pctxt, 
         ((UsvCapabilityElementType*)pnode->data)
         , OSUTF8("Capability"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavOperatingCharacteristicsElementType                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavOperatingCharacteristicsElementType (OSCTXT* pctxt,
   UavOperatingCharacteristicsElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode maxYawRate */

   if (pvalue->m.maxYawRatePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         asn1E_PositiveScalarType (pctxt, &pvalue->maxYawRate, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode maxSpeed */

   if (pvalue->m.maxSpeedPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         asn1E_PositiveScalarType (pctxt, &pvalue->maxSpeed, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode maxRollRate */

   if (pvalue->m.maxRollRatePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_PositiveScalarType (pctxt, &pvalue->maxRollRate, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode maxPitchRate */

   if (pvalue->m.maxPitchRatePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_PositiveScalarType (pctxt, &pvalue->maxPitchRate, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode maxAltitude */

   if (pvalue->m.maxAltitudePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         asn1E_PositiveScalarType (pctxt, &pvalue->maxAltitude, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode endurance */

   if (pvalue->m.endurancePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_PositiveScalarType (pctxt, &pvalue->endurance, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode cruiseSpeed */

   if (pvalue->m.cruiseSpeedPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_PositiveScalarType (pctxt, &pvalue->cruiseSpeed, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavOperatingCharacteristicsElementType (OSCTXT* pctxt, 
   UavOperatingCharacteristicsElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.cruiseSpeedPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" cruiseSpeed=\""), 14);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->cruiseSpeed, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.endurancePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" endurance=\""), 12);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->endurance, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.maxAltitudePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxAltitude=\""), 14);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxAltitude, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.maxPitchRatePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxPitchRate=\""), 15);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxPitchRate, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.maxRollRatePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxRollRate=\""), 14);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxRollRate, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.maxSpeedPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxSpeed=\""), 11);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxSpeed, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.maxYawRatePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" maxYawRate=\""), 13);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->maxYawRate, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavCapabilityType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavCapabilityType (OSCTXT* pctxt,
   UavCapabilityType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 5)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_UavCapabilityType (OSCTXT* pctxt, UavCapabilityType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      UavCapabilityType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavCapabilityElementType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavCapabilityElementType (OSCTXT* pctxt,
   UavCapabilityElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   if(pvalue->value < 0 || pvalue->value > 5)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_UavCapabilityType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavCapabilityElementType (OSCTXT* pctxt, 
   UavCapabilityElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   if(pvalue->value < 0 || pvalue->value > 5)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_UavCapabilityType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavCharacteristicsElementType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavCharacteristicsElementType (OSCTXT* pctxt,
   UavCharacteristicsElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode capability_list */

   pnode2 = pvalue->capability_list.tail;
   while (0 != pnode2) {
      ll = asn1E_UavCapabilityElementType (pctxt, ((UavCapabilityElementType*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode degreesOfControl */

   if (pvalue->m.degreesOfControlPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_DegreesOfControlElementType (pctxt, &pvalue->degreesOfControl, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode operatingCharacteristics */

   if (pvalue->m.operatingCharacteristicsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_UavOperatingCharacteristicsElementType (pctxt, &pvalue->operatingCharacteristics, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode dimensions */

   if (pvalue->m.dimensionsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_DimensionsElementType (pctxt, &pvalue->dimensions, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavCharacteristicsElementType (OSCTXT* pctxt, 
   UavCharacteristicsElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode dimensions */

   if (pvalue->m.dimensionsPresent) {
      stat = XmlEnc_DimensionsElementType (pctxt, &pvalue->dimensions
         , OSUTF8("Dimensions"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode operatingCharacteristics */

   if (pvalue->m.operatingCharacteristicsPresent) {
      stat = XmlEnc_UavOperatingCharacteristicsElementType (pctxt, &pvalue->
         operatingCharacteristics
         , OSUTF8("OperatingCharacteristics"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode degreesOfControl */

   if (pvalue->m.degreesOfControlPresent) {
      stat = XmlEnc_DegreesOfControlElementType (pctxt, &pvalue->
         degreesOfControl, OSUTF8("DegreesOfControl"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode capability_list */

   { OSRTDListNode* pnode = pvalue->capability_list.head;
   while (0 != pnode) {
      stat = XmlEnc_UavCapabilityElementType (pctxt, 
         ((UavCapabilityElementType*)pnode->data)
         , OSUTF8("Capability"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VehicleCharacteristicsGroup                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_VehicleCharacteristicsGroup (OSCTXT* pctxt,
   VehicleCharacteristicsGroup *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UuvCharacteristicsElementType (pctxt, pvalue->u.uUVCharacteristics, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_UgvCharacteristicsElementType (pctxt, pvalue->u.uGVCharacteristics, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_UsvCharacteristicsElementType (pctxt, pvalue->u.uSVCharacteristics, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_UavCharacteristicsElementType (pctxt, pvalue->u.uAVCharacteristics, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_VehicleCharacteristicsGroup (OSCTXT* pctxt, 
   VehicleCharacteristicsGroup* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode uUVCharacteristics */

         stat = XmlEnc_UuvCharacteristicsElementType (pctxt, pvalue->
            u.uUVCharacteristics, OSUTF8("UUVCharacteristics"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode uGVCharacteristics */

         stat = XmlEnc_UgvCharacteristicsElementType (pctxt, pvalue->
            u.uGVCharacteristics, OSUTF8("UGVCharacteristics"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode uSVCharacteristics */

         stat = XmlEnc_UsvCharacteristicsElementType (pctxt, pvalue->
            u.uSVCharacteristics, OSUTF8("USVCharacteristics"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode uAVCharacteristics */

         stat = XmlEnc_UavCharacteristicsElementType (pctxt, pvalue->
            u.uAVCharacteristics, OSUTF8("UAVCharacteristics"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvVerticalPositionElementType                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvVerticalPositionElementType (OSCTXT* pctxt,
   UuvVerticalPositionElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode depth */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      asn1E_NonNegativeScalarType (pctxt, &pvalue->depth, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode altitude */

   if (pvalue->m.altitudePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->altitude, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvVerticalPositionElementType (OSCTXT* pctxt, 
   UuvVerticalPositionElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.altitudePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" altitude=\""), 11);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->altitude, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" depth=\""), 8);

   stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->depth, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OrientationType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_OrientationType (OSCTXT* pctxt,
   OrientationType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = xe_real (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_OrientationType (OSCTXT* pctxt, OrientationType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncDouble (pctxt, value, elemName, nsPrefix, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OrientationElementType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_OrientationElementType (OSCTXT* pctxt,
   OrientationElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode theta */

   if (pvalue->m.thetaPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_OrientationType (pctxt, &pvalue->theta, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode psi */

   if (pvalue->m.psiPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_OrientationType (pctxt, &pvalue->psi, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode phi */

   if (pvalue->m.phiPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_OrientationType (pctxt, &pvalue->phi, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_OrientationElementType (OSCTXT* pctxt, 
   OrientationElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.phiPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" phi=\""), 6);

      stat = XmlEnc_OrientationType (pctxt, pvalue->phi, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.psiPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" psi=\""), 6);

      stat = XmlEnc_OrientationType (pctxt, pvalue->psi, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.thetaPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" theta=\""), 8);

      stat = XmlEnc_OrientationType (pctxt, pvalue->theta, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  WorldCoordinateVelocityElementType                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_WorldCoordinateVelocityElementType (OSCTXT* pctxt,
   WorldCoordinateVelocityElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode zDot */

   if (pvalue->m.zDotPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_real (pctxt, &pvalue->zDot, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode yDot */

   if (pvalue->m.yDotPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_real (pctxt, &pvalue->yDot, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode xDot */

   if (pvalue->m.xDotPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_real (pctxt, &pvalue->xDot, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode thetaDot */

   if (pvalue->m.thetaDotPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_real (pctxt, &pvalue->thetaDot, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode psiDot */

   if (pvalue->m.psiDotPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_real (pctxt, &pvalue->psiDot, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode phiDot */

   if (pvalue->m.phiDotPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_real (pctxt, &pvalue->phiDot, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_WorldCoordinateVelocityElementType (OSCTXT* pctxt, 
   WorldCoordinateVelocityElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.phiDotPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" phiDot=\""), 9);

      stat = rtXmlEncDouble (pctxt, pvalue->phiDot, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.psiDotPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" psiDot=\""), 9);

      stat = rtXmlEncDouble (pctxt, pvalue->psiDot, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.thetaDotPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" thetaDot=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->thetaDot, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.xDotPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" xDot=\""), 7);

      stat = rtXmlEncDouble (pctxt, pvalue->xDot, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.yDotPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" yDot=\""), 7);

      stat = rtXmlEncDouble (pctxt, pvalue->yDot, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.zDotPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" zDot=\""), 7);

      stat = rtXmlEncDouble (pctxt, pvalue->zDot, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BodyCoordinateVelocityElementType                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_BodyCoordinateVelocityElementType (OSCTXT* pctxt,
   BodyCoordinateVelocityElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode w */

   if (pvalue->m.wPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_real (pctxt, &pvalue->w, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode v */

   if (pvalue->m.vPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_real (pctxt, &pvalue->v, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode u */

   if (pvalue->m.uPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_real (pctxt, &pvalue->u, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode r */

   if (pvalue->m.rPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_real (pctxt, &pvalue->r, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode q */

   if (pvalue->m.qPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_real (pctxt, &pvalue->q, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode p */

   if (pvalue->m.pPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_real (pctxt, &pvalue->p, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_BodyCoordinateVelocityElementType (OSCTXT* pctxt, 
   BodyCoordinateVelocityElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.pPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" p=\""), 4);

      stat = rtXmlEncDouble (pctxt, pvalue->p, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.qPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" q=\""), 4);

      stat = rtXmlEncDouble (pctxt, pvalue->q, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.rPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" r=\""), 4);

      stat = rtXmlEncDouble (pctxt, pvalue->r, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.uPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" u=\""), 4);

      stat = rtXmlEncDouble (pctxt, pvalue->u, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.vPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" v=\""), 4);

      stat = rtXmlEncDouble (pctxt, pvalue->v, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.wPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" w=\""), 4);

      stat = rtXmlEncDouble (pctxt, pvalue->w, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DopplerVelocityElementType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DopplerVelocityElementType (OSCTXT* pctxt,
   DopplerVelocityElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode speedThroughMediumV */

   if (pvalue->m.speedThroughMediumVPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_real (pctxt, &pvalue->speedThroughMediumV, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode speedThroughMediumU */

   if (pvalue->m.speedThroughMediumUPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_real (pctxt, &pvalue->speedThroughMediumU, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode speedOverGroundV */

   if (pvalue->m.speedOverGroundVPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_real (pctxt, &pvalue->speedOverGroundV, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode speedOverGroundU */

   if (pvalue->m.speedOverGroundUPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_real (pctxt, &pvalue->speedOverGroundU, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_DopplerVelocityElementType (OSCTXT* pctxt, 
   DopplerVelocityElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.speedOverGroundUPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" speedOverGroundU=\""), 19);

      stat = rtXmlEncDouble (pctxt, pvalue->speedOverGroundU, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.speedOverGroundVPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" speedOverGroundV=\""), 19);

      stat = rtXmlEncDouble (pctxt, pvalue->speedOverGroundV, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.speedThroughMediumUPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" speedThroughMediumU=\""), 22);

      stat = rtXmlEncDouble (pctxt, pvalue->speedThroughMediumU, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.speedThroughMediumVPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" speedThroughMediumV=\""), 22);

      stat = rtXmlEncDouble (pctxt, pvalue->speedThroughMediumV, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvTelemetryElementType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvTelemetryElementType (OSCTXT* pctxt,
   UuvTelemetryElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   int xx2;
   int ll2 = 0;

   /* encode remainingPower */

   if (pvalue->m.remainingPowerPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
         asn1E_PercentElementType (pctxt, &pvalue->remainingPower, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode dopplerVelocity */

   if (pvalue->m.dopplerVelocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
         asn1E_DopplerVelocityElementType (pctxt, &pvalue->dopplerVelocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bodyCoordinateVelocity */

   if (pvalue->m.bodyCoordinateVelocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
         asn1E_BodyCoordinateVelocityElementType (pctxt, &pvalue->bodyCoordinateVelocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode worldCoordinateVelocity */

   if (pvalue->m.worldCoordinateVelocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_WorldCoordinateVelocityElementType (pctxt, &pvalue->worldCoordinateVelocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode orientation */

   if (pvalue->m.orientationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_OrientationElementType (pctxt, &pvalue->orientation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode verticalPosition */

   if (pvalue->m.verticalPositionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_UuvVerticalPositionElementType (pctxt, &pvalue->verticalPosition, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode geographicPosition */

   if (pvalue->m.geographicPositionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->geographicPosition, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode _order */

   for (xx2 = (pvalue->_order.n - 1); xx2 >= 0; xx2--)
   {
      if (!((pvalue->_order.elem[xx2] <= OSUINTCONST(6)))) {
         rtxErrAddStrParm (pctxt, "UuvTelemetryElementType._order.elem[xx2]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx2]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }

      ll = xe_uint8 (pctxt, &pvalue->_order.elem[xx2], ASN1IMPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);

      ll = xe_tag_len (pctxt, TM_UNIV|TM_PRIM|10, ll);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvTelemetryElementType (OSCTXT* pctxt, 
   UuvTelemetryElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode elements in given order */

   { OSUINT32 xx1;
   for (xx1 = 0; xx1 < pvalue->_order.n; xx1++) {
      switch (pvalue->_order.elem[xx1]) {
      case 0:
         /* encode geographicPosition */

         if (pvalue->m.geographicPositionPresent) {
            stat = XmlEnc_AbsoluteHorizontalPositionElementType (pctxt, &pvalue
               ->geographicPosition, OSUTF8("GeographicPosition"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 1:
         /* encode verticalPosition */

         if (pvalue->m.verticalPositionPresent) {
            stat = XmlEnc_UuvVerticalPositionElementType (pctxt, &pvalue->
               verticalPosition, OSUTF8("VerticalPosition"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 2:
         /* encode orientation */

         if (pvalue->m.orientationPresent) {
            stat = XmlEnc_OrientationElementType (pctxt, &pvalue->orientation
               , OSUTF8("Orientation"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 3:
         /* encode worldCoordinateVelocity */

         if (pvalue->m.worldCoordinateVelocityPresent) {
            stat = XmlEnc_WorldCoordinateVelocityElementType (pctxt, &pvalue->
               worldCoordinateVelocity
               , OSUTF8("WorldCoordinateVelocity"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 4:
         /* encode bodyCoordinateVelocity */

         if (pvalue->m.bodyCoordinateVelocityPresent) {
            stat = XmlEnc_BodyCoordinateVelocityElementType (pctxt, &pvalue->
               bodyCoordinateVelocity
               , OSUTF8("BodyCoordinateVelocity"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 5:
         /* encode dopplerVelocity */

         if (pvalue->m.dopplerVelocityPresent) {
            stat = XmlEnc_DopplerVelocityElementType (pctxt, &pvalue->
               dopplerVelocity, OSUTF8("DopplerVelocity"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 6:
         /* encode remainingPower */

         if (pvalue->m.remainingPowerPresent) {
            stat = XmlEnc_PercentElementType (pctxt, &pvalue->remainingPower
               , OSUTF8("RemainingPower"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      default:
         rtxErrAddStrParm (pctxt, "UuvTelemetryElementType._order.elem[xx1]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx1]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }
   }}
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvTelemetryElementType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvTelemetryElementType (OSCTXT* pctxt,
   UsvTelemetryElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   int xx2;
   int ll2 = 0;

   /* encode remainingPower */

   if (pvalue->m.remainingPowerPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
         asn1E_PercentElementType (pctxt, &pvalue->remainingPower, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode dopplerVelocity */

   if (pvalue->m.dopplerVelocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
         asn1E_DopplerVelocityElementType (pctxt, &pvalue->dopplerVelocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bodyCoordinateVelocity */

   if (pvalue->m.bodyCoordinateVelocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_BodyCoordinateVelocityElementType (pctxt, &pvalue->bodyCoordinateVelocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode worldCoordinateVelocity */

   if (pvalue->m.worldCoordinateVelocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_WorldCoordinateVelocityElementType (pctxt, &pvalue->worldCoordinateVelocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode orientation */

   if (pvalue->m.orientationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_OrientationElementType (pctxt, &pvalue->orientation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode geographicPosition */

   if (pvalue->m.geographicPositionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->geographicPosition, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode _order */

   for (xx2 = (pvalue->_order.n - 1); xx2 >= 0; xx2--)
   {
      if (!((pvalue->_order.elem[xx2] <= OSUINTCONST(5)))) {
         rtxErrAddStrParm (pctxt, "UsvTelemetryElementType._order.elem[xx2]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx2]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }

      ll = xe_uint8 (pctxt, &pvalue->_order.elem[xx2], ASN1IMPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);

      ll = xe_tag_len (pctxt, TM_UNIV|TM_PRIM|10, ll);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UsvTelemetryElementType (OSCTXT* pctxt, 
   UsvTelemetryElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode elements in given order */

   { OSUINT32 xx1;
   for (xx1 = 0; xx1 < pvalue->_order.n; xx1++) {
      switch (pvalue->_order.elem[xx1]) {
      case 0:
         /* encode geographicPosition */

         if (pvalue->m.geographicPositionPresent) {
            stat = XmlEnc_AbsoluteHorizontalPositionElementType (pctxt, &pvalue
               ->geographicPosition, OSUTF8("GeographicPosition"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 1:
         /* encode orientation */

         if (pvalue->m.orientationPresent) {
            stat = XmlEnc_OrientationElementType (pctxt, &pvalue->orientation
               , OSUTF8("Orientation"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 2:
         /* encode worldCoordinateVelocity */

         if (pvalue->m.worldCoordinateVelocityPresent) {
            stat = XmlEnc_WorldCoordinateVelocityElementType (pctxt, &pvalue->
               worldCoordinateVelocity
               , OSUTF8("WorldCoordinateVelocity"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 3:
         /* encode bodyCoordinateVelocity */

         if (pvalue->m.bodyCoordinateVelocityPresent) {
            stat = XmlEnc_BodyCoordinateVelocityElementType (pctxt, &pvalue->
               bodyCoordinateVelocity
               , OSUTF8("BodyCoordinateVelocity"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 4:
         /* encode dopplerVelocity */

         if (pvalue->m.dopplerVelocityPresent) {
            stat = XmlEnc_DopplerVelocityElementType (pctxt, &pvalue->
               dopplerVelocity, OSUTF8("DopplerVelocity"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 5:
         /* encode remainingPower */

         if (pvalue->m.remainingPowerPresent) {
            stat = XmlEnc_PercentElementType (pctxt, &pvalue->remainingPower
               , OSUTF8("RemainingPower"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      default:
         rtxErrAddStrParm (pctxt, "UsvTelemetryElementType._order.elem[xx1]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx1]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }
   }}
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvVerticalPositionElementType                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvVerticalPositionElementType (OSCTXT* pctxt,
   UgvVerticalPositionElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode altitudeMSL */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      xe_real (pctxt, &pvalue->altitudeMSL, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UgvVerticalPositionElementType (OSCTXT* pctxt, 
   UgvVerticalPositionElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" altitudeMSL=\""), 14);

   stat = rtXmlEncDouble (pctxt, pvalue->altitudeMSL, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvTelemetryElementType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvTelemetryElementType (OSCTXT* pctxt,
   UgvTelemetryElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   int xx2;
   int ll2 = 0;

   /* encode remainingPower */

   if (pvalue->m.remainingPowerPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
         asn1E_PercentElementType (pctxt, &pvalue->remainingPower, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode dopplerVelocity */

   if (pvalue->m.dopplerVelocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
         asn1E_DopplerVelocityElementType (pctxt, &pvalue->dopplerVelocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bodyCoordinateVelocity */

   if (pvalue->m.bodyCoordinateVelocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
         asn1E_BodyCoordinateVelocityElementType (pctxt, &pvalue->bodyCoordinateVelocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode worldCoordinateVelocity */

   if (pvalue->m.worldCoordinateVelocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_WorldCoordinateVelocityElementType (pctxt, &pvalue->worldCoordinateVelocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode orientation */

   if (pvalue->m.orientationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_OrientationElementType (pctxt, &pvalue->orientation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode altitude */

   if (pvalue->m.altitudePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_UgvVerticalPositionElementType (pctxt, &pvalue->altitude, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode geographicPosition */

   if (pvalue->m.geographicPositionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->geographicPosition, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode _order */

   for (xx2 = (pvalue->_order.n - 1); xx2 >= 0; xx2--)
   {
      if (!((pvalue->_order.elem[xx2] <= OSUINTCONST(6)))) {
         rtxErrAddStrParm (pctxt, "UgvTelemetryElementType._order.elem[xx2]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx2]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }

      ll = xe_uint8 (pctxt, &pvalue->_order.elem[xx2], ASN1IMPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);

      ll = xe_tag_len (pctxt, TM_UNIV|TM_PRIM|10, ll);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UgvTelemetryElementType (OSCTXT* pctxt, 
   UgvTelemetryElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode elements in given order */

   { OSUINT32 xx1;
   for (xx1 = 0; xx1 < pvalue->_order.n; xx1++) {
      switch (pvalue->_order.elem[xx1]) {
      case 0:
         /* encode geographicPosition */

         if (pvalue->m.geographicPositionPresent) {
            stat = XmlEnc_AbsoluteHorizontalPositionElementType (pctxt, &pvalue
               ->geographicPosition, OSUTF8("GeographicPosition"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 1:
         /* encode altitude */

         if (pvalue->m.altitudePresent) {
            stat = XmlEnc_UgvVerticalPositionElementType (pctxt, &pvalue->
               altitude, OSUTF8("Altitude"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 2:
         /* encode orientation */

         if (pvalue->m.orientationPresent) {
            stat = XmlEnc_OrientationElementType (pctxt, &pvalue->orientation
               , OSUTF8("Orientation"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 3:
         /* encode worldCoordinateVelocity */

         if (pvalue->m.worldCoordinateVelocityPresent) {
            stat = XmlEnc_WorldCoordinateVelocityElementType (pctxt, &pvalue->
               worldCoordinateVelocity
               , OSUTF8("WorldCoordinateVelocity"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 4:
         /* encode bodyCoordinateVelocity */

         if (pvalue->m.bodyCoordinateVelocityPresent) {
            stat = XmlEnc_BodyCoordinateVelocityElementType (pctxt, &pvalue->
               bodyCoordinateVelocity
               , OSUTF8("BodyCoordinateVelocity"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 5:
         /* encode dopplerVelocity */

         if (pvalue->m.dopplerVelocityPresent) {
            stat = XmlEnc_DopplerVelocityElementType (pctxt, &pvalue->
               dopplerVelocity, OSUTF8("DopplerVelocity"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 6:
         /* encode remainingPower */

         if (pvalue->m.remainingPowerPresent) {
            stat = XmlEnc_PercentElementType (pctxt, &pvalue->remainingPower
               , OSUTF8("RemainingPower"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      default:
         rtxErrAddStrParm (pctxt, "UgvTelemetryElementType._order.elem[xx1]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx1]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }
   }}
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavVerticalPositionElementType                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavVerticalPositionElementType (OSCTXT* pctxt,
   UavVerticalPositionElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode altitudeMSL */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      xe_real (pctxt, &pvalue->altitudeMSL, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode altitudeAGL */

   if (pvalue->m.altitudeAGLPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_PositiveScalarType (pctxt, &pvalue->altitudeAGL, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavVerticalPositionElementType (OSCTXT* pctxt, 
   UavVerticalPositionElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.altitudeAGLPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" altitudeAGL=\""), 14);

      stat = XmlEnc_PositiveScalarType (pctxt, pvalue->altitudeAGL, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" altitudeMSL=\""), 14);

   stat = rtXmlEncDouble (pctxt, pvalue->altitudeMSL, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavTelemetryElementType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavTelemetryElementType (OSCTXT* pctxt,
   UavTelemetryElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   int xx2;
   int ll2 = 0;

   /* encode remainingPower */

   if (pvalue->m.remainingPowerPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
         asn1E_PercentElementType (pctxt, &pvalue->remainingPower, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode dopplerVelocity */

   if (pvalue->m.dopplerVelocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
         asn1E_DopplerVelocityElementType (pctxt, &pvalue->dopplerVelocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bodyCoordinateVelocity */

   if (pvalue->m.bodyCoordinateVelocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
         asn1E_BodyCoordinateVelocityElementType (pctxt, &pvalue->bodyCoordinateVelocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode worldCoordinateVelocity */

   if (pvalue->m.worldCoordinateVelocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_WorldCoordinateVelocityElementType (pctxt, &pvalue->worldCoordinateVelocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode orientation */

   if (pvalue->m.orientationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_OrientationElementType (pctxt, &pvalue->orientation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode verticalPosition */

   if (pvalue->m.verticalPositionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_UavVerticalPositionElementType (pctxt, &pvalue->verticalPosition, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode geographicPosition */

   if (pvalue->m.geographicPositionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->geographicPosition, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode _order */

   for (xx2 = (pvalue->_order.n - 1); xx2 >= 0; xx2--)
   {
      if (!((pvalue->_order.elem[xx2] <= OSUINTCONST(6)))) {
         rtxErrAddStrParm (pctxt, "UavTelemetryElementType._order.elem[xx2]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx2]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }

      ll = xe_uint8 (pctxt, &pvalue->_order.elem[xx2], ASN1IMPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);

      ll = xe_tag_len (pctxt, TM_UNIV|TM_PRIM|10, ll);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavTelemetryElementType (OSCTXT* pctxt, 
   UavTelemetryElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode elements in given order */

   { OSUINT32 xx1;
   for (xx1 = 0; xx1 < pvalue->_order.n; xx1++) {
      switch (pvalue->_order.elem[xx1]) {
      case 0:
         /* encode geographicPosition */

         if (pvalue->m.geographicPositionPresent) {
            stat = XmlEnc_AbsoluteHorizontalPositionElementType (pctxt, &pvalue
               ->geographicPosition, OSUTF8("GeographicPosition"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 1:
         /* encode verticalPosition */

         if (pvalue->m.verticalPositionPresent) {
            stat = XmlEnc_UavVerticalPositionElementType (pctxt, &pvalue->
               verticalPosition, OSUTF8("VerticalPosition"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 2:
         /* encode orientation */

         if (pvalue->m.orientationPresent) {
            stat = XmlEnc_OrientationElementType (pctxt, &pvalue->orientation
               , OSUTF8("Orientation"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 3:
         /* encode worldCoordinateVelocity */

         if (pvalue->m.worldCoordinateVelocityPresent) {
            stat = XmlEnc_WorldCoordinateVelocityElementType (pctxt, &pvalue->
               worldCoordinateVelocity
               , OSUTF8("WorldCoordinateVelocity"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 4:
         /* encode bodyCoordinateVelocity */

         if (pvalue->m.bodyCoordinateVelocityPresent) {
            stat = XmlEnc_BodyCoordinateVelocityElementType (pctxt, &pvalue->
               bodyCoordinateVelocity
               , OSUTF8("BodyCoordinateVelocity"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 5:
         /* encode dopplerVelocity */

         if (pvalue->m.dopplerVelocityPresent) {
            stat = XmlEnc_DopplerVelocityElementType (pctxt, &pvalue->
               dopplerVelocity, OSUTF8("DopplerVelocity"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 6:
         /* encode remainingPower */

         if (pvalue->m.remainingPowerPresent) {
            stat = XmlEnc_PercentElementType (pctxt, &pvalue->remainingPower
               , OSUTF8("RemainingPower"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      default:
         rtxErrAddStrParm (pctxt, "UavTelemetryElementType._order.elem[xx1]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx1]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }
   }}
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DiscreteTimeResultsElementType_choice                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DiscreteTimeResultsElementType_choice (OSCTXT* pctxt,
   DiscreteTimeResultsElementType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UuvTelemetryElementType (pctxt, pvalue->u.uUVTelemetry, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_UsvTelemetryElementType (pctxt, pvalue->u.uSVTelemetry, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_UgvTelemetryElementType (pctxt, pvalue->u.uGVTelemetry, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_UavTelemetryElementType (pctxt, pvalue->u.uAVTelemetry, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_DiscreteTimeResultsElementType_choice (OSCTXT* pctxt, 
   DiscreteTimeResultsElementType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode uUVTelemetry */

         stat = XmlEnc_UuvTelemetryElementType (pctxt, pvalue->u.uUVTelemetry
            , OSUTF8("UUVTelemetry"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode uSVTelemetry */

         stat = XmlEnc_UsvTelemetryElementType (pctxt, pvalue->u.uSVTelemetry
            , OSUTF8("USVTelemetry"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode uGVTelemetry */

         stat = XmlEnc_UgvTelemetryElementType (pctxt, pvalue->u.uGVTelemetry
            , OSUTF8("UGVTelemetry"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode uAVTelemetry */

         stat = XmlEnc_UavTelemetryElementType (pctxt, pvalue->u.uAVTelemetry
            , OSUTF8("UAVTelemetry"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvPropellersOrderElementType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvPropellersOrderElementType (OSCTXT* pctxt,
   UuvPropellersOrderElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode starboard */

   if (pvalue->m.starboardPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_SignedPercentType (pctxt, &pvalue->starboard, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode port */

   if (pvalue->m.portPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_SignedPercentType (pctxt, &pvalue->port, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode centerline */

   if (pvalue->m.centerlinePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_SignedPercentType (pctxt, &pvalue->centerline, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode all */

   if (pvalue->m.allPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_SignedPercentType (pctxt, &pvalue->all, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvPropellersOrderElementType (OSCTXT* pctxt, 
   UuvPropellersOrderElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.allPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" all=\""), 6);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->all, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.centerlinePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" centerline=\""), 13);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->centerline, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.portPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" port=\""), 7);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->port, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.starboardPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" starboard=\""), 12);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->starboard, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvPlanesOrderElementType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvPlanesOrderElementType (OSCTXT* pctxt,
   UuvPlanesOrderElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode stern */

   if (pvalue->m.sternPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_SignedPercentType (pctxt, &pvalue->stern, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bow */

   if (pvalue->m.bowPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_SignedPercentType (pctxt, &pvalue->bow, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvPlanesOrderElementType (OSCTXT* pctxt, 
   UuvPlanesOrderElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.bowPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" bow=\""), 6);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->bow, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.sternPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" stern=\""), 8);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->stern, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvBodyThrustersOrderElementType                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvBodyThrustersOrderElementType (OSCTXT* pctxt,
   UuvBodyThrustersOrderElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode sternVertical */

   if (pvalue->m.sternVerticalPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_SignedPercentType (pctxt, &pvalue->sternVertical, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode sternLateral */

   if (pvalue->m.sternLateralPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_SignedPercentType (pctxt, &pvalue->sternLateral, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bowVertical */

   if (pvalue->m.bowVerticalPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_SignedPercentType (pctxt, &pvalue->bowVertical, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bowLateral */

   if (pvalue->m.bowLateralPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_SignedPercentType (pctxt, &pvalue->bowLateral, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvBodyThrustersOrderElementType (OSCTXT* pctxt, 
   UuvBodyThrustersOrderElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.bowLateralPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" bowLateral=\""), 13);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->bowLateral, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.bowVerticalPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" bowVertical=\""), 14);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->bowVertical, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.sternLateralPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" sternLateral=\""), 15);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->sternLateral, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.sternVerticalPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" sternVertical=\""), 16);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->sternVertical, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvControlOrdersElementType                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvControlOrdersElementType (OSCTXT* pctxt,
   UuvControlOrdersElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   int xx2;
   int ll2 = 0;

   /* encode bodyThrusters */

   if (pvalue->m.bodyThrustersPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_UuvBodyThrustersOrderElementType (pctxt, &pvalue->bodyThrusters, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode planes */

   if (pvalue->m.planesPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_UuvPlanesOrderElementType (pctxt, &pvalue->planes, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode rudder */

   if (pvalue->m.rudderPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_ScalarElementType (pctxt, &pvalue->rudder, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode propellers */

   if (pvalue->m.propellersPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_UuvPropellersOrderElementType (pctxt, &pvalue->propellers, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode _order */

   for (xx2 = (pvalue->_order.n - 1); xx2 >= 0; xx2--)
   {
      if (!((pvalue->_order.elem[xx2] <= OSUINTCONST(3)))) {
         rtxErrAddStrParm (pctxt, "UuvControlOrdersElementType._order.elem[xx2]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx2]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }

      ll = xe_uint8 (pctxt, &pvalue->_order.elem[xx2], ASN1IMPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);

      ll = xe_tag_len (pctxt, TM_UNIV|TM_PRIM|10, ll);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvControlOrdersElementType (OSCTXT* pctxt, 
   UuvControlOrdersElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode elements in given order */

   { OSUINT32 xx1;
   for (xx1 = 0; xx1 < pvalue->_order.n; xx1++) {
      switch (pvalue->_order.elem[xx1]) {
      case 0:
         /* encode propellers */

         if (pvalue->m.propellersPresent) {
            stat = XmlEnc_UuvPropellersOrderElementType (pctxt, &pvalue->
               propellers, OSUTF8("Propellers"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 1:
         /* encode rudder */

         if (pvalue->m.rudderPresent) {
            stat = XmlEnc_ScalarElementType (pctxt, &pvalue->rudder
               , OSUTF8("Rudder"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 2:
         /* encode planes */

         if (pvalue->m.planesPresent) {
            stat = XmlEnc_UuvPlanesOrderElementType (pctxt, &pvalue->planes
               , OSUTF8("Planes"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 3:
         /* encode bodyThrusters */

         if (pvalue->m.bodyThrustersPresent) {
            stat = XmlEnc_UuvBodyThrustersOrderElementType (pctxt, &pvalue->
               bodyThrusters, OSUTF8("BodyThrusters"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      default:
         rtxErrAddStrParm (pctxt, 
            "UuvControlOrdersElementType._order.elem[xx1]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx1]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }
   }}
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvPropellersOrderElementType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvPropellersOrderElementType (OSCTXT* pctxt,
   UsvPropellersOrderElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode starboard */

   if (pvalue->m.starboardPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_SignedPercentType (pctxt, &pvalue->starboard, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode port */

   if (pvalue->m.portPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_SignedPercentType (pctxt, &pvalue->port, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode centerline */

   if (pvalue->m.centerlinePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_SignedPercentType (pctxt, &pvalue->centerline, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode all */

   if (pvalue->m.allPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         asn1E_SignedPercentType (pctxt, &pvalue->all, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UsvPropellersOrderElementType (OSCTXT* pctxt, 
   UsvPropellersOrderElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.allPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" all=\""), 6);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->all, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.centerlinePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" centerline=\""), 13);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->centerline, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.portPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" port=\""), 7);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->port, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.starboardPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" starboard=\""), 12);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->starboard, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvControlOrdersElementType                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvControlOrdersElementType (OSCTXT* pctxt,
   UsvControlOrdersElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   int xx2;
   int ll2 = 0;

   /* encode rudder */

   if (pvalue->m.rudderPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_SignedPercentElementType (pctxt, &pvalue->rudder, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode propellers */

   if (pvalue->m.propellersPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_UsvPropellersOrderElementType (pctxt, &pvalue->propellers, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode _order */

   for (xx2 = (pvalue->_order.n - 1); xx2 >= 0; xx2--)
   {
      if (!((pvalue->_order.elem[xx2] <= OSUINTCONST(1)))) {
         rtxErrAddStrParm (pctxt, "UsvControlOrdersElementType._order.elem[xx2]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx2]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }

      ll = xe_uint8 (pctxt, &pvalue->_order.elem[xx2], ASN1IMPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);

      ll = xe_tag_len (pctxt, TM_UNIV|TM_PRIM|10, ll);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UsvControlOrdersElementType (OSCTXT* pctxt, 
   UsvControlOrdersElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode elements in given order */

   { OSUINT32 xx1;
   for (xx1 = 0; xx1 < pvalue->_order.n; xx1++) {
      switch (pvalue->_order.elem[xx1]) {
      case 0:
         /* encode propellers */

         if (pvalue->m.propellersPresent) {
            stat = XmlEnc_UsvPropellersOrderElementType (pctxt, &pvalue->
               propellers, OSUTF8("Propellers"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 1:
         /* encode rudder */

         if (pvalue->m.rudderPresent) {
            stat = XmlEnc_SignedPercentElementType (pctxt, &pvalue->rudder
               , OSUTF8("Rudder"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      default:
         rtxErrAddStrParm (pctxt, 
            "UsvControlOrdersElementType._order.elem[xx1]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx1]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }
   }}
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvControlOrdersElementType                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvControlOrdersElementType (OSCTXT* pctxt,
   UgvControlOrdersElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   int xx2;
   int ll2 = 0;

   /* encode placeHolder */

   if (pvalue->m.placeHolderPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_NoValueElementType (pctxt, &pvalue->placeHolder, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode _order */

   for (xx2 = (pvalue->_order.n - 1); xx2 >= 0; xx2--)
   {
      if (!((pvalue->_order.elem[xx2] <= OSUINTCONST(0)))) {
         rtxErrAddStrParm (pctxt, "UgvControlOrdersElementType._order.elem[xx2]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx2]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }

      ll = xe_uint8 (pctxt, &pvalue->_order.elem[xx2], ASN1IMPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);

      ll = xe_tag_len (pctxt, TM_UNIV|TM_PRIM|10, ll);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UgvControlOrdersElementType (OSCTXT* pctxt, 
   UgvControlOrdersElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode elements in given order */

   { OSUINT32 xx1;
   for (xx1 = 0; xx1 < pvalue->_order.n; xx1++) {
      switch (pvalue->_order.elem[xx1]) {
      case 0:
         /* encode placeHolder */

         if (pvalue->m.placeHolderPresent) {
            stat = XmlEnc_NoValueElementType (pctxt, &pvalue->placeHolder
               , OSUTF8("PlaceHolder"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      default:
         rtxErrAddStrParm (pctxt, 
            "UgvControlOrdersElementType._order.elem[xx1]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx1]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }
   }}
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavEnginesOrdersElementType                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavEnginesOrdersElementType (OSCTXT* pctxt,
   UavEnginesOrdersElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode engine2 */

   if (pvalue->m.engine2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         asn1E_SignedPercentType (pctxt, &pvalue->engine2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode engine1 */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_SignedPercentType (pctxt, &pvalue->engine1, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavEnginesOrdersElementType (OSCTXT* pctxt, 
   UavEnginesOrdersElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" engine1=\""), 10);

   stat = XmlEnc_SignedPercentType (pctxt, pvalue->engine1, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.engine2Present) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" engine2=\""), 10);

      stat = XmlEnc_SignedPercentType (pctxt, pvalue->engine2, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavStabilatorOrderElementType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavStabilatorOrderElementType (OSCTXT* pctxt,
   UavStabilatorOrderElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode starboard */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      asn1E_SignedPercentType (pctxt, &pvalue->starboard, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode port */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_SignedPercentType (pctxt, &pvalue->port, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavStabilatorOrderElementType (OSCTXT* pctxt, 
   UavStabilatorOrderElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" port=\""), 7);

   stat = XmlEnc_SignedPercentType (pctxt, pvalue->port, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" starboard=\""), 12);

   stat = XmlEnc_SignedPercentType (pctxt, pvalue->starboard, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FixedWingUAVControlOrders                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_FixedWingUAVControlOrders (OSCTXT* pctxt,
   FixedWingUAVControlOrders *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode elevator */

   if (pvalue->m.elevatorPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_UavStabilatorOrderElementType (pctxt, &pvalue->elevator, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode rudder */

   if (pvalue->m.rudderPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
         asn1E_SignedPercentElementType (pctxt, &pvalue->rudder, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode aileron */

   if (pvalue->m.aileronPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
         asn1E_SignedPercentElementType (pctxt, &pvalue->aileron, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode engines */

   if (pvalue->m.enginesPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_UavEnginesOrdersElementType (pctxt, &pvalue->engines, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_FixedWingUAVControlOrders (OSCTXT* pctxt, 
   FixedWingUAVControlOrders* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* encode engines */

   if (pvalue->m.enginesPresent) {
      stat = XmlEnc_UavEnginesOrdersElementType (pctxt, &pvalue->engines
         , OSUTF8("Engines"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode aileron */

   if (pvalue->m.aileronPresent) {
      stat = XmlEnc_SignedPercentElementType (pctxt, &pvalue->aileron
         , OSUTF8("Aileron"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode rudder */

   if (pvalue->m.rudderPresent) {
      stat = XmlEnc_SignedPercentElementType (pctxt, &pvalue->rudder
         , OSUTF8("Rudder"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode elevator */

   if (pvalue->m.elevatorPresent) {
      stat = XmlEnc_UavStabilatorOrderElementType (pctxt, &pvalue->elevator
         , OSUTF8("Elevator"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavCyclicOrderElementType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavCyclicOrderElementType (OSCTXT* pctxt,
   UavCyclicOrderElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode lateral */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      asn1E_SignedPercentType (pctxt, &pvalue->lateral, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode foreAft */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_SignedPercentType (pctxt, &pvalue->foreAft, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavCyclicOrderElementType (OSCTXT* pctxt, 
   UavCyclicOrderElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" foreAft=\""), 10);

   stat = XmlEnc_SignedPercentType (pctxt, pvalue->foreAft, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" lateral=\""), 10);

   stat = XmlEnc_SignedPercentType (pctxt, pvalue->lateral, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RotaryWingUAVControlOrders                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_RotaryWingUAVControlOrders (OSCTXT* pctxt,
   RotaryWingUAVControlOrders *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode pedals */

   if (pvalue->m.pedalsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
         asn1E_SignedPercentElementType (pctxt, &pvalue->pedals, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode cyclic */

   if (pvalue->m.cyclicPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
         asn1E_UavCyclicOrderElementType (pctxt, &pvalue->cyclic, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode collective */

   if (pvalue->m.collectivePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
         asn1E_SignedPercentElementType (pctxt, &pvalue->collective, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_RotaryWingUAVControlOrders (OSCTXT* pctxt, 
   RotaryWingUAVControlOrders* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* encode collective */

   if (pvalue->m.collectivePresent) {
      stat = XmlEnc_SignedPercentElementType (pctxt, &pvalue->collective
         , OSUTF8("Collective"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode cyclic */

   if (pvalue->m.cyclicPresent) {
      stat = XmlEnc_UavCyclicOrderElementType (pctxt, &pvalue->cyclic
         , OSUTF8("Cyclic"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode pedals */

   if (pvalue->m.pedalsPresent) {
      stat = XmlEnc_SignedPercentElementType (pctxt, &pvalue->pedals
         , OSUTF8("Pedals"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavControlOrdersElementType_choice                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavControlOrdersElementType_choice (OSCTXT* pctxt,
   UavControlOrdersElementType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_FixedWingUAVControlOrders (pctxt, pvalue->u.fixedWingUAVControlOrders, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_RotaryWingUAVControlOrders (pctxt, pvalue->u.rotaryWingUAVControlOrders, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_UavControlOrdersElementType_choice (OSCTXT* pctxt, 
   UavControlOrdersElementType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode fixedWingUAVControlOrders */

         stat = XmlEnc_FixedWingUAVControlOrders (pctxt, pvalue->
            u.fixedWingUAVControlOrders, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode rotaryWingUAVControlOrders */

         stat = XmlEnc_RotaryWingUAVControlOrders (pctxt, pvalue->
            u.rotaryWingUAVControlOrders, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavControlOrdersElementType                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavControlOrdersElementType (OSCTXT* pctxt,
   UavControlOrdersElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_UavControlOrdersElementType_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavControlOrdersElementType (OSCTXT* pctxt, 
   UavControlOrdersElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_UavControlOrdersElementType_choice (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DiscreteTimeResultsElementType_choice_1                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DiscreteTimeResultsElementType_choice_1 (OSCTXT* pctxt,
   DiscreteTimeResultsElementType_choice_1 *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UuvControlOrdersElementType (pctxt, pvalue->u.uUVControlOrder, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_UsvControlOrdersElementType (pctxt, pvalue->u.uSVControlOrder, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_UgvControlOrdersElementType (pctxt, pvalue->u.uGVControlOrder, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_UavControlOrdersElementType (pctxt, pvalue->u.uAVControlOrder, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_DiscreteTimeResultsElementType_choice_1 (OSCTXT* pctxt, 
   DiscreteTimeResultsElementType_choice_1* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode uUVControlOrder */

         stat = XmlEnc_UuvControlOrdersElementType (pctxt, pvalue->
            u.uUVControlOrder, OSUTF8("UUVControlOrder"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode uSVControlOrder */

         stat = XmlEnc_UsvControlOrdersElementType (pctxt, pvalue->
            u.uSVControlOrder, OSUTF8("USVControlOrder"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode uGVControlOrder */

         stat = XmlEnc_UgvControlOrdersElementType (pctxt, pvalue->
            u.uGVControlOrder, OSUTF8("UGVControlOrder"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode uAVControlOrder */

         stat = XmlEnc_UavControlOrdersElementType (pctxt, pvalue->
            u.uAVControlOrder, OSUTF8("UAVControlOrder"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_activeSonar                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_activeSonar (OSCTXT* pctxt,
   SensorElements_activeSonar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode strength */

   if (pvalue->m.strengthPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         xe_real (pctxt, &pvalue->strength, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode range */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
      xe_real (pctxt, &pvalue->range, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode elevation */

   if (pvalue->m.elevationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_real (pctxt, &pvalue->elevation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_activeSonar (OSCTXT* pctxt, 
   SensorElements_activeSonar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.elevationPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" elevation=\""), 12);

      stat = rtXmlEncDouble (pctxt, pvalue->elevation, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" range=\""), 8);

   stat = rtXmlEncDouble (pctxt, pvalue->range, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.strengthPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" strength=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->strength, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_imagingSonar                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_imagingSonar (OSCTXT* pctxt,
   SensorElements_imagingSonar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_imagingSonar (OSCTXT* pctxt, 
   SensorElements_imagingSonar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_blazedArraySonar                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_blazedArraySonar (OSCTXT* pctxt,
   SensorElements_blazedArraySonar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_blazedArraySonar (OSCTXT* pctxt, 
   SensorElements_blazedArraySonar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_syntheticApertureSonar                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_syntheticApertureSonar (OSCTXT* pctxt,
   SensorElements_syntheticApertureSonar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_syntheticApertureSonar (OSCTXT* pctxt, 
   SensorElements_syntheticApertureSonar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_passiveSonar                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_passiveSonar (OSCTXT* pctxt,
   SensorElements_passiveSonar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode strength */

   if (pvalue->m.strengthPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_real (pctxt, &pvalue->strength, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode frequency */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_real (pctxt, &pvalue->frequency, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   if (pvalue->m.bearingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_passiveSonar (OSCTXT* pctxt, 
   SensorElements_passiveSonar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.bearingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

      stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" frequency=\""), 12);

   stat = rtXmlEncDouble (pctxt, pvalue->frequency, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.strengthPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" strength=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->strength, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_radar                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_radar (OSCTXT* pctxt,
   SensorElements_radar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode velocity */

   if (pvalue->m.velocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|14,
         xe_real (pctxt, &pvalue->velocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|13,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode range */

   if (pvalue->m.rangePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|12,
         xe_real (pctxt, &pvalue->range, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|11,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode modeC */

   if (pvalue->m.modeCPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
         xe_integer (pctxt, &pvalue->modeC, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode4 */

   if (pvalue->m.mode4Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
         xe_boolean (pctxt, &pvalue->mode4, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode3 */

   if (pvalue->m.mode3Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         xe_integer (pctxt, &pvalue->mode3, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode2 */

   if (pvalue->m.mode2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         xe_integer (pctxt, &pvalue->mode2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode1 */

   if (pvalue->m.mode1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         xe_integer (pctxt, &pvalue->mode1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode heading */

   if (pvalue->m.headingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_real (pctxt, &pvalue->heading, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode elevation */

   if (pvalue->m.elevationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_real (pctxt, &pvalue->elevation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   if (pvalue->m.bearingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode altitude */

   if (pvalue->m.altitudePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_real (pctxt, &pvalue->altitude, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_radar (OSCTXT* pctxt, SensorElements_radar* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.altitudePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" altitude=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->altitude, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.bearingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

      stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.elevationPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" elevation=\""), 12);

      stat = rtXmlEncDouble (pctxt, pvalue->elevation, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.headingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" heading=\""), 10);

      stat = rtXmlEncDouble (pctxt, pvalue->heading, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mode1Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode1, OSUTF8("mode1"), 5);
   }

   if (pvalue->m.mode2Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode2, OSUTF8("mode2"), 5);
   }

   if (pvalue->m.mode3Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode3, OSUTF8("mode3"), 5);
   }

   if (pvalue->m.mode4Present) {
      stat = rtXmlEncBoolAttr (pctxt, pvalue->mode4, OSUTF8("mode4"), 5);
   }

   if (pvalue->m.modeCPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->modeC, OSUTF8("modeC"), 5);
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.rangePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" range=\""), 8);

      stat = rtXmlEncDouble (pctxt, pvalue->range, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.velocityPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" velocity=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->velocity, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_dopplerRadar                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_dopplerRadar (OSCTXT* pctxt,
   SensorElements_dopplerRadar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode velocity */

   if (pvalue->m.velocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|14,
         xe_real (pctxt, &pvalue->velocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|13,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode range */

   if (pvalue->m.rangePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|12,
         xe_real (pctxt, &pvalue->range, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode model */

   if (pvalue->m.modelPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|11,
         xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode modeC */

   if (pvalue->m.modeCPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
         xe_integer (pctxt, &pvalue->modeC, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode4 */

   if (pvalue->m.mode4Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
         xe_boolean (pctxt, &pvalue->mode4, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode3 */

   if (pvalue->m.mode3Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         xe_integer (pctxt, &pvalue->mode3, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode2 */

   if (pvalue->m.mode2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         xe_integer (pctxt, &pvalue->mode2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode1 */

   if (pvalue->m.mode1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         xe_integer (pctxt, &pvalue->mode1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode heading */

   if (pvalue->m.headingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_real (pctxt, &pvalue->heading, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode elevation */

   if (pvalue->m.elevationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_real (pctxt, &pvalue->elevation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   if (pvalue->m.bearingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode altitude */

   if (pvalue->m.altitudePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_real (pctxt, &pvalue->altitude, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_dopplerRadar (OSCTXT* pctxt, 
   SensorElements_dopplerRadar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.altitudePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" altitude=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->altitude, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.bearingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

      stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.elevationPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" elevation=\""), 12);

      stat = rtXmlEncDouble (pctxt, pvalue->elevation, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.headingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" heading=\""), 10);

      stat = rtXmlEncDouble (pctxt, pvalue->heading, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mode1Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode1, OSUTF8("mode1"), 5);
   }

   if (pvalue->m.mode2Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode2, OSUTF8("mode2"), 5);
   }

   if (pvalue->m.mode3Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode3, OSUTF8("mode3"), 5);
   }

   if (pvalue->m.mode4Present) {
      stat = rtXmlEncBoolAttr (pctxt, pvalue->mode4, OSUTF8("mode4"), 5);
   }

   if (pvalue->m.modeCPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->modeC, OSUTF8("modeC"), 5);
   }

   if (pvalue->m.modelPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.rangePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" range=\""), 8);

      stat = rtXmlEncDouble (pctxt, pvalue->range, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.velocityPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" velocity=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->velocity, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_syntheticApertureRadar                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_syntheticApertureRadar (OSCTXT* pctxt,
   SensorElements_syntheticApertureRadar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode velocity */

   if (pvalue->m.velocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|14,
         xe_real (pctxt, &pvalue->velocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|13,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode range */

   if (pvalue->m.rangePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|12,
         xe_real (pctxt, &pvalue->range, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|11,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode modeC */

   if (pvalue->m.modeCPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
         xe_integer (pctxt, &pvalue->modeC, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode4 */

   if (pvalue->m.mode4Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
         xe_boolean (pctxt, &pvalue->mode4, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode3 */

   if (pvalue->m.mode3Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         xe_integer (pctxt, &pvalue->mode3, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode2 */

   if (pvalue->m.mode2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         xe_integer (pctxt, &pvalue->mode2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode1 */

   if (pvalue->m.mode1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         xe_integer (pctxt, &pvalue->mode1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode heading */

   if (pvalue->m.headingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_real (pctxt, &pvalue->heading, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode elevation */

   if (pvalue->m.elevationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_real (pctxt, &pvalue->elevation, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   if (pvalue->m.bearingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode altitude */

   if (pvalue->m.altitudePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_real (pctxt, &pvalue->altitude, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_syntheticApertureRadar (OSCTXT* pctxt, 
   SensorElements_syntheticApertureRadar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.altitudePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" altitude=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->altitude, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.bearingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

      stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.elevationPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" elevation=\""), 12);

      stat = rtXmlEncDouble (pctxt, pvalue->elevation, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.headingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" heading=\""), 10);

      stat = rtXmlEncDouble (pctxt, pvalue->heading, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mode1Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode1, OSUTF8("mode1"), 5);
   }

   if (pvalue->m.mode2Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode2, OSUTF8("mode2"), 5);
   }

   if (pvalue->m.mode3Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode3, OSUTF8("mode3"), 5);
   }

   if (pvalue->m.mode4Present) {
      stat = rtXmlEncBoolAttr (pctxt, pvalue->mode4, OSUTF8("mode4"), 5);
   }

   if (pvalue->m.modeCPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->modeC, OSUTF8("modeC"), 5);
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.rangePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" range=\""), 8);

      stat = rtXmlEncDouble (pctxt, pvalue->range, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.velocityPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" velocity=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->velocity, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_trackWhileScanRadar_track                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_trackWhileScanRadar_track (OSCTXT* pctxt,
   SensorElements_trackWhileScanRadar_track *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode velocity */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
      xe_real (pctxt, &pvalue->velocity, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode trackID */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
      xe_utf8str (pctxt, pvalue->trackID, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode range */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
      xe_real (pctxt, &pvalue->range, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode modeC */

   if (pvalue->m.modeCPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         xe_integer (pctxt, &pvalue->modeC, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode4 */

   if (pvalue->m.mode4Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         xe_boolean (pctxt, &pvalue->mode4, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode3 */

   if (pvalue->m.mode3Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_integer (pctxt, &pvalue->mode3, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode2 */

   if (pvalue->m.mode2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_integer (pctxt, &pvalue->mode2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode1 */

   if (pvalue->m.mode1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_integer (pctxt, &pvalue->mode1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode heading */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_real (pctxt, &pvalue->heading, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode bearing */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode altitude */

   if (pvalue->m.altitudePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_real (pctxt, &pvalue->altitude, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_trackWhileScanRadar_track (OSCTXT* pctxt, 
   SensorElements_trackWhileScanRadar_track* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.altitudePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" altitude=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->altitude, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" heading=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->heading, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.mode1Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode1, OSUTF8("mode1"), 5);
   }

   if (pvalue->m.mode2Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode2, OSUTF8("mode2"), 5);
   }

   if (pvalue->m.mode3Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode3, OSUTF8("mode3"), 5);
   }

   if (pvalue->m.mode4Present) {
      stat = rtXmlEncBoolAttr (pctxt, pvalue->mode4, OSUTF8("mode4"), 5);
   }

   if (pvalue->m.modeCPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->modeC, OSUTF8("modeC"), 5);
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" range=\""), 8);

   stat = rtXmlEncDouble (pctxt, pvalue->range, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" trackID=\""), 10);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->trackID, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" velocity=\""), 11);

   stat = rtXmlEncDouble (pctxt, pvalue->velocity, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_trackWhileScanRadar                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_trackWhileScanRadar (OSCTXT* pctxt,
   SensorElements_trackWhileScanRadar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode track_list */

   if (!(pvalue->track_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "SensorElements_trackWhileScanRadar.track_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->track_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->track_list.tail;
   while (0 != pnode2) {
      ll = asn1E_SensorElements_trackWhileScanRadar_track (pctxt, ((SensorElements_trackWhileScanRadar_track*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_trackWhileScanRadar (OSCTXT* pctxt, 
   SensorElements_trackWhileScanRadar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode track_list */

   if (!(pvalue->track_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "SensorElements_trackWhileScanRadar.track_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->track_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->track_list.head;
   while (0 != pnode) {
      stat = XmlEnc_SensorElements_trackWhileScanRadar_track (pctxt, 
         ((SensorElements_trackWhileScanRadar_track*)pnode->data)
         , OSUTF8("Track"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_earlyWarningRadar                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_earlyWarningRadar (OSCTXT* pctxt,
   SensorElements_earlyWarningRadar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode velocity */

   if (pvalue->m.velocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|13,
         xe_real (pctxt, &pvalue->velocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|12,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode range */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|11,
      xe_real (pctxt, &pvalue->range, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode modeC */

   if (pvalue->m.modeCPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
         xe_integer (pctxt, &pvalue->modeC, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode4 */

   if (pvalue->m.mode4Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         xe_boolean (pctxt, &pvalue->mode4, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode3 */

   if (pvalue->m.mode3Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         xe_integer (pctxt, &pvalue->mode3, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode2 */

   if (pvalue->m.mode2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         xe_integer (pctxt, &pvalue->mode2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode1 */

   if (pvalue->m.mode1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_integer (pctxt, &pvalue->mode1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode heading */

   if (pvalue->m.headingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_real (pctxt, &pvalue->heading, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode altitude */

   if (pvalue->m.altitudePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_real (pctxt, &pvalue->altitude, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_earlyWarningRadar (OSCTXT* pctxt, 
   SensorElements_earlyWarningRadar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.altitudePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" altitude=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->altitude, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.headingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" heading=\""), 10);

      stat = rtXmlEncDouble (pctxt, pvalue->heading, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mode1Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode1, OSUTF8("mode1"), 5);
   }

   if (pvalue->m.mode2Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode2, OSUTF8("mode2"), 5);
   }

   if (pvalue->m.mode3Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode3, OSUTF8("mode3"), 5);
   }

   if (pvalue->m.mode4Present) {
      stat = rtXmlEncBoolAttr (pctxt, pvalue->mode4, OSUTF8("mode4"), 5);
   }

   if (pvalue->m.modeCPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->modeC, OSUTF8("modeC"), 5);
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" range=\""), 8);

   stat = rtXmlEncDouble (pctxt, pvalue->range, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.velocityPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" velocity=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->velocity, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_acquisitionRadar                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_acquisitionRadar (OSCTXT* pctxt,
   SensorElements_acquisitionRadar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode velocity */

   if (pvalue->m.velocityPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|13,
         xe_real (pctxt, &pvalue->velocity, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|12,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode range */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|11,
      xe_real (pctxt, &pvalue->range, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode modeC */

   if (pvalue->m.modeCPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
         xe_integer (pctxt, &pvalue->modeC, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode4 */

   if (pvalue->m.mode4Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         xe_boolean (pctxt, &pvalue->mode4, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode3 */

   if (pvalue->m.mode3Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         xe_integer (pctxt, &pvalue->mode3, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode2 */

   if (pvalue->m.mode2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         xe_integer (pctxt, &pvalue->mode2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode1 */

   if (pvalue->m.mode1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_integer (pctxt, &pvalue->mode1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode heading */

   if (pvalue->m.headingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_real (pctxt, &pvalue->heading, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode altitude */

   if (pvalue->m.altitudePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_real (pctxt, &pvalue->altitude, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_acquisitionRadar (OSCTXT* pctxt, 
   SensorElements_acquisitionRadar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.altitudePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" altitude=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->altitude, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.headingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" heading=\""), 10);

      stat = rtXmlEncDouble (pctxt, pvalue->heading, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mode1Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode1, OSUTF8("mode1"), 5);
   }

   if (pvalue->m.mode2Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode2, OSUTF8("mode2"), 5);
   }

   if (pvalue->m.mode3Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode3, OSUTF8("mode3"), 5);
   }

   if (pvalue->m.mode4Present) {
      stat = rtXmlEncBoolAttr (pctxt, pvalue->mode4, OSUTF8("mode4"), 5);
   }

   if (pvalue->m.modeCPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->modeC, OSUTF8("modeC"), 5);
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" range=\""), 8);

   stat = rtXmlEncDouble (pctxt, pvalue->range, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.velocityPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" velocity=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->velocity, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_trackingRadar                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_trackingRadar (OSCTXT* pctxt,
   SensorElements_trackingRadar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode velocity */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|13,
      xe_real (pctxt, &pvalue->velocity, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|12,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode range */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|11,
      xe_real (pctxt, &pvalue->range, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode modeC */

   if (pvalue->m.modeCPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
         xe_integer (pctxt, &pvalue->modeC, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode4 */

   if (pvalue->m.mode4Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         xe_boolean (pctxt, &pvalue->mode4, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode3 */

   if (pvalue->m.mode3Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         xe_integer (pctxt, &pvalue->mode3, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode2 */

   if (pvalue->m.mode2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         xe_integer (pctxt, &pvalue->mode2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode1 */

   if (pvalue->m.mode1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_integer (pctxt, &pvalue->mode1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode heading */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_real (pctxt, &pvalue->heading, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode altitude */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      xe_real (pctxt, &pvalue->altitude, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_trackingRadar (OSCTXT* pctxt, 
   SensorElements_trackingRadar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" altitude=\""), 11);

   stat = rtXmlEncDouble (pctxt, pvalue->altitude, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" heading=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->heading, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mode1Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode1, OSUTF8("mode1"), 5);
   }

   if (pvalue->m.mode2Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode2, OSUTF8("mode2"), 5);
   }

   if (pvalue->m.mode3Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode3, OSUTF8("mode3"), 5);
   }

   if (pvalue->m.mode4Present) {
      stat = rtXmlEncBoolAttr (pctxt, pvalue->mode4, OSUTF8("mode4"), 5);
   }

   if (pvalue->m.modeCPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->modeC, OSUTF8("modeC"), 5);
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" range=\""), 8);

   stat = rtXmlEncDouble (pctxt, pvalue->range, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" velocity=\""), 11);

   stat = rtXmlEncDouble (pctxt, pvalue->velocity, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_fireControlRadar                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_fireControlRadar (OSCTXT* pctxt,
   SensorElements_fireControlRadar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode velocity */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|13,
      xe_real (pctxt, &pvalue->velocity, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|12,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode range */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|11,
      xe_real (pctxt, &pvalue->range, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode modeC */

   if (pvalue->m.modeCPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
         xe_integer (pctxt, &pvalue->modeC, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode4 */

   if (pvalue->m.mode4Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         xe_boolean (pctxt, &pvalue->mode4, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode3 */

   if (pvalue->m.mode3Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         xe_integer (pctxt, &pvalue->mode3, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode2 */

   if (pvalue->m.mode2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         xe_integer (pctxt, &pvalue->mode2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode1 */

   if (pvalue->m.mode1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_integer (pctxt, &pvalue->mode1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode heading */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_real (pctxt, &pvalue->heading, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
      xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode altitude */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      xe_real (pctxt, &pvalue->altitude, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_fireControlRadar (OSCTXT* pctxt, 
   SensorElements_fireControlRadar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" altitude=\""), 11);

   stat = rtXmlEncDouble (pctxt, pvalue->altitude, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" heading=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->heading, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mode1Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode1, OSUTF8("mode1"), 5);
   }

   if (pvalue->m.mode2Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode2, OSUTF8("mode2"), 5);
   }

   if (pvalue->m.mode3Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode3, OSUTF8("mode3"), 5);
   }

   if (pvalue->m.mode4Present) {
      stat = rtXmlEncBoolAttr (pctxt, pvalue->mode4, OSUTF8("mode4"), 5);
   }

   if (pvalue->m.modeCPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->modeC, OSUTF8("modeC"), 5);
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" range=\""), 8);

   stat = rtXmlEncDouble (pctxt, pvalue->range, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" velocity=\""), 11);

   stat = rtXmlEncDouble (pctxt, pvalue->velocity, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_surfaceSearchRadar                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_surfaceSearchRadar (OSCTXT* pctxt,
   SensorElements_surfaceSearchRadar *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode velocity */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|12,
      xe_real (pctxt, &pvalue->velocity, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|11,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode range */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|10,
      xe_real (pctxt, &pvalue->range, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|9,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode modeC */

   if (pvalue->m.modeCPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|8,
         xe_integer (pctxt, &pvalue->modeC, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode4 */

   if (pvalue->m.mode4Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
         xe_boolean (pctxt, &pvalue->mode4, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode3 */

   if (pvalue->m.mode3Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         xe_integer (pctxt, &pvalue->mode3, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode2 */

   if (pvalue->m.mode2Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_integer (pctxt, &pvalue->mode2, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode mode1 */

   if (pvalue->m.mode1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
         xe_integer (pctxt, &pvalue->mode1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode heading */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_real (pctxt, &pvalue->heading, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_surfaceSearchRadar (OSCTXT* pctxt, 
   SensorElements_surfaceSearchRadar* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" heading=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->heading, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.mode1Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode1, OSUTF8("mode1"), 5);
   }

   if (pvalue->m.mode2Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode2, OSUTF8("mode2"), 5);
   }

   if (pvalue->m.mode3Present) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->mode3, OSUTF8("mode3"), 5);
   }

   if (pvalue->m.mode4Present) {
      stat = rtXmlEncBoolAttr (pctxt, pvalue->mode4, OSUTF8("mode4"), 5);
   }

   if (pvalue->m.modeCPresent) {
      stat = rtXmlEncIntAttr
         (pctxt, pvalue->modeC, OSUTF8("modeC"), 5);
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" range=\""), 8);

   stat = rtXmlEncDouble (pctxt, pvalue->range, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" velocity=\""), 11);

   stat = rtXmlEncDouble (pctxt, pvalue->velocity, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_eSM                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_eSM (OSCTXT* pctxt,
   SensorElements_eSM *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode strength */

   if (pvalue->m.strengthPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_real (pctxt, &pvalue->strength, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode frequency */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_real (pctxt, &pvalue->frequency, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   if (pvalue->m.bearingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_eSM (OSCTXT* pctxt, SensorElements_eSM* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.bearingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

      stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" frequency=\""), 12);

   stat = rtXmlEncDouble (pctxt, pvalue->frequency, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.strengthPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" strength=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->strength, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_passiveSoundDetection                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_passiveSoundDetection (OSCTXT* pctxt,
   SensorElements_passiveSoundDetection *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode strength */

   if (pvalue->m.strengthPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_real (pctxt, &pvalue->strength, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode frequency */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_real (pctxt, &pvalue->frequency, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode bearing */

   if (pvalue->m.bearingPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_real (pctxt, &pvalue->bearing, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_passiveSoundDetection (OSCTXT* pctxt, 
   SensorElements_passiveSoundDetection* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.bearingPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" bearing=\""), 10);

      stat = rtXmlEncDouble (pctxt, pvalue->bearing, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" frequency=\""), 12);

   stat = rtXmlEncDouble (pctxt, pvalue->frequency, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.strengthPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" strength=\""), 11);

      stat = rtXmlEncDouble (pctxt, pvalue->strength, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_chemicalBiologicalRadiologicalDetection    */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_chemicalBiologicalRadiologicalDetection (OSCTXT* pctxt,
   SensorElements_chemicalBiologicalRadiologicalDetection *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode substance */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_utf8str (pctxt, pvalue->substance, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode magnitude */

   if (pvalue->m.magnitudePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_real (pctxt, &pvalue->magnitude, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_chemicalBiologicalRadiologicalDetection 
   (OSCTXT* pctxt, 
   SensorElements_chemicalBiologicalRadiologicalDetection* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.magnitudePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" magnitude=\""), 12);

      stat = rtXmlEncDouble (pctxt, pvalue->magnitude, 0, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" substance=\""), 12);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->substance, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_video                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_video (OSCTXT* pctxt,
   SensorElements_video *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_video (OSCTXT* pctxt, SensorElements_video* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_fLIR                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_fLIR (OSCTXT* pctxt,
   SensorElements_fLIR *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_fLIR (OSCTXT* pctxt, SensorElements_fLIR* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements_motionSensor                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements_motionSensor (OSCTXT* pctxt,
   SensorElements_motionSensor *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode model */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_utf8str (pctxt, pvalue->model, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElements_motionSensor (OSCTXT* pctxt, 
   SensorElements_motionSensor* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" model=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->model, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElements                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElements (OSCTXT* pctxt,
   SensorElements *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_SensorElements_activeSonar (pctxt, pvalue->u.activeSonar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_SensorElements_imagingSonar (pctxt, pvalue->u.imagingSonar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_SensorElements_blazedArraySonar (pctxt, pvalue->u.blazedArraySonar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_SensorElements_syntheticApertureSonar (pctxt, pvalue->u.syntheticApertureSonar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_SensorElements_passiveSonar (pctxt, pvalue->u.passiveSonar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
            asn1E_SensorElements_radar (pctxt, pvalue->u.radar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
            asn1E_SensorElements_dopplerRadar (pctxt, pvalue->u.dopplerRadar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
            asn1E_SensorElements_syntheticApertureRadar (pctxt, pvalue->u.syntheticApertureRadar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
            asn1E_SensorElements_trackWhileScanRadar (pctxt, pvalue->u.trackWhileScanRadar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 10:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
            asn1E_SensorElements_earlyWarningRadar (pctxt, pvalue->u.earlyWarningRadar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 11:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
            asn1E_SensorElements_acquisitionRadar (pctxt, pvalue->u.acquisitionRadar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 12:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
            asn1E_SensorElements_trackingRadar (pctxt, pvalue->u.trackingRadar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 13:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12,
            asn1E_SensorElements_fireControlRadar (pctxt, pvalue->u.fireControlRadar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 14:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|13,
            asn1E_SensorElements_surfaceSearchRadar (pctxt, pvalue->u.surfaceSearchRadar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 15:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|14,
            asn1E_SensorElements_eSM (pctxt, pvalue->u.eSM, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 16:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|15,
            asn1E_SensorElements_passiveSoundDetection (pctxt, pvalue->u.passiveSoundDetection, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 17:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|16,
            asn1E_SensorElements_chemicalBiologicalRadiologicalDetection (pctxt, pvalue->u.chemicalBiologicalRadiologicalDetection, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 18:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|17,
            asn1E_SensorElements_video (pctxt, pvalue->u.video, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 19:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|18,
            asn1E_SensorElements_fLIR (pctxt, pvalue->u.fLIR, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 20:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|19,
            asn1E_SensorElements_motionSensor (pctxt, pvalue->u.motionSensor, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_SensorElements (OSCTXT* pctxt, SensorElements* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode activeSonar */

         stat = XmlEnc_SensorElements_activeSonar (pctxt, pvalue->u.activeSonar
            , OSUTF8("ActiveSonar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode imagingSonar */

         stat = XmlEnc_SensorElements_imagingSonar (pctxt, pvalue->
            u.imagingSonar, OSUTF8("ImagingSonar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode blazedArraySonar */

         stat = XmlEnc_SensorElements_blazedArraySonar (pctxt, pvalue->
            u.blazedArraySonar, OSUTF8("BlazedArraySonar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode syntheticApertureSonar */

         stat = XmlEnc_SensorElements_syntheticApertureSonar (pctxt, pvalue->
            u.syntheticApertureSonar
            , OSUTF8("SyntheticApertureSonar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode passiveSonar */

         stat = XmlEnc_SensorElements_passiveSonar (pctxt, pvalue->
            u.passiveSonar, OSUTF8("PassiveSonar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode radar */

         stat = XmlEnc_SensorElements_radar (pctxt, pvalue->u.radar
            , OSUTF8("Radar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode dopplerRadar */

         stat = XmlEnc_SensorElements_dopplerRadar (pctxt, pvalue->
            u.dopplerRadar, OSUTF8("DopplerRadar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode syntheticApertureRadar */

         stat = XmlEnc_SensorElements_syntheticApertureRadar (pctxt, pvalue->
            u.syntheticApertureRadar
            , OSUTF8("SyntheticApertureRadar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode trackWhileScanRadar */

         stat = XmlEnc_SensorElements_trackWhileScanRadar (pctxt, pvalue->
            u.trackWhileScanRadar, OSUTF8("TrackWhileScanRadar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 10:
         /* encode earlyWarningRadar */

         stat = XmlEnc_SensorElements_earlyWarningRadar (pctxt, pvalue->
            u.earlyWarningRadar, OSUTF8("EarlyWarningRadar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 11:
         /* encode acquisitionRadar */

         stat = XmlEnc_SensorElements_acquisitionRadar (pctxt, pvalue->
            u.acquisitionRadar, OSUTF8("AcquisitionRadar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 12:
         /* encode trackingRadar */

         stat = XmlEnc_SensorElements_trackingRadar (pctxt, pvalue->
            u.trackingRadar, OSUTF8("TrackingRadar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 13:
         /* encode fireControlRadar */

         stat = XmlEnc_SensorElements_fireControlRadar (pctxt, pvalue->
            u.fireControlRadar, OSUTF8("FireControlRadar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 14:
         /* encode surfaceSearchRadar */

         stat = XmlEnc_SensorElements_surfaceSearchRadar (pctxt, pvalue->
            u.surfaceSearchRadar, OSUTF8("SurfaceSearchRadar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 15:
         /* encode eSM */

         stat = XmlEnc_SensorElements_eSM (pctxt, pvalue->u.eSM
            , OSUTF8("ESM"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 16:
         /* encode passiveSoundDetection */

         stat = XmlEnc_SensorElements_passiveSoundDetection (pctxt, pvalue->
            u.passiveSoundDetection
            , OSUTF8("PassiveSoundDetection"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 17:
         /* encode chemicalBiologicalRadiologicalDetection */

         stat = XmlEnc_SensorElements_chemicalBiologicalRadiologicalDetection (pctxt
            , pvalue->u.chemicalBiologicalRadiologicalDetection
            , OSUTF8("ChemicalBiologicalRadiologicalDetection"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 18:
         /* encode video */

         stat = XmlEnc_SensorElements_video (pctxt, pvalue->u.video
            , OSUTF8("Video"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 19:
         /* encode fLIR */

         stat = XmlEnc_SensorElements_fLIR (pctxt, pvalue->u.fLIR
            , OSUTF8("FLIR"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 20:
         /* encode motionSensor */

         stat = XmlEnc_SensorElements_motionSensor (pctxt, pvalue->
            u.motionSensor, OSUTF8("MotionSensor"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SensorElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_SensorElementType (OSCTXT* pctxt,
   SensorElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "SensorElementType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->choice_list.tail;
   while (0 != pnode2) {
      ll = asn1E_SensorElements (pctxt, ((SensorElements*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_SensorElementType (OSCTXT* pctxt, SensorElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "SensorElementType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->choice_list.head;
   while (0 != pnode) {
      stat = XmlEnc_SensorElements (pctxt, ((SensorElements*)pnode->data)
         , 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  WeaponElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_WeaponElementType (OSCTXT* pctxt,
   WeaponElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_WeaponElementType (OSCTXT* pctxt, WeaponElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DiscreteTimeResultsElementType                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DiscreteTimeResultsElementType (OSCTXT* pctxt,
   DiscreteTimeResultsElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode weapon */

   if (pvalue->m.weaponPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_WeaponElementType (pctxt, &pvalue->weapon, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode sensor */

   if (pvalue->m.sensorPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_SensorElementType (pctxt, &pvalue->sensor, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_DiscreteTimeResultsElementType_choice_1 (pctxt, &pvalue->choice_1, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_DiscreteTimeResultsElementType_choice (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_DiscreteTimeResultsElementType (OSCTXT* pctxt, 
   DiscreteTimeResultsElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_DiscreteTimeResultsElementType_choice (pctxt, &pvalue->
         choice, OSUTF8(""), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_1 */

   if (pvalue->m.choice_1Present) {
      stat = XmlEnc_DiscreteTimeResultsElementType_choice_1 (pctxt, &pvalue->
         choice_1, OSUTF8(""), 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode sensor */

   if (pvalue->m.sensorPresent) {
      stat = XmlEnc_SensorElementType (pctxt, &pvalue->sensor
         , OSUTF8("Sensor"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode weapon */

   if (pvalue->m.weaponPresent) {
      stat = XmlEnc_WeaponElementType (pctxt, &pvalue->weapon
         , OSUTF8("Weapon"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvLoggableEventType_element                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvLoggableEventType_element (OSCTXT* pctxt,
   UuvLoggableEventType_element *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UuvCompositeWaypointCommandType (pctxt, pvalue->u.compositeWaypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_GpsFixCommandType (pctxt, pvalue->u.gpsFix, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_NoValueElementType (pctxt, pvalue->u.help, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_HoverCommandType (pctxt, pvalue->u.hover, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
            asn1E_UuvLoiterCommandType (pctxt, pvalue->u.loiter, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.makeAltitude, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.makeDepth, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
            asn1E_HeadingElementType (pctxt, pvalue->u.makeHeading, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 10:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeKnots, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 11:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeSpeed, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 12:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
            asn1E_MetaDataType (pctxt, pvalue->u.metaCommand, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 13:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12,
            asn1E_StringElementType (pctxt, pvalue->u.missionScript, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 14:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|13,
            asn1E_StringElementType (pctxt, pvalue->u.missionScriptInline, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 15:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|14,
            asn1E_ScalarElementType (pctxt, pvalue->u.moveLateral, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 16:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|15,
            asn1E_ScalarElementType (pctxt, pvalue->u.moveRotate, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 17:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|16,
            asn1E_QuitCommandType (pctxt, pvalue->u.quit, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 18:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|17,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.realtime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 19:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|18,
            asn1E_RecoverCommandType (pctxt, pvalue->u.recover, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 20:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|19,
            asn1E_SendMessageCommandType (pctxt, pvalue->u.sendMessage, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 21:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|20,
            asn1E_SetPlanesCommandType (pctxt, pvalue->u.setPlanes, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 22:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|21,
            asn1E_UuvPositionCommandType (pctxt, pvalue->u.setPosition, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 23:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|22,
            asn1E_SetPropellerCommandType (pctxt, pvalue->u.setPower, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 24:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|23,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.setRudder, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 25:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|24,
            asn1E_SetSonarCommandType (pctxt, pvalue->u.setSonar, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 26:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|25,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setStandoff, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 27:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|26,
            asn1E_SetThrusterCommandType (pctxt, pvalue->u.setThruster, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 28:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|27,
            asn1E_ScalarElementType (pctxt, pvalue->u.setTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 29:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|28,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setTimeStep, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 30:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|29,
            asn1E_TakeStationCommandType (pctxt, pvalue->u.takeStation, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 31:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|30,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.thrusters, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 32:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|31,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.trace, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 33:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|32,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.wait, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 34:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|33,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.waitUntilTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 35:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|34,
            asn1E_UuvWaypointCommandType (pctxt, pvalue->u.waypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 36:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|35,
            asn1E_AvclMessageType (pctxt, (AvclMessageType*)pvalue->u.aVCLMessage, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_UuvLoggableEventType_element (OSCTXT* pctxt, 
   UuvLoggableEventType_element* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode compositeWaypoint */

         stat = XmlEnc_UuvCompositeWaypointCommandType (pctxt, pvalue->
            u.compositeWaypoint, OSUTF8("CompositeWaypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode followBeacon */

         stat = XmlEnc_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon
            , OSUTF8("FollowBeacon"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode gpsFix */

         stat = XmlEnc_GpsFixCommandType (pctxt, pvalue->u.gpsFix
            , OSUTF8("GpsFix"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode help */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.help
            , OSUTF8("Help"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode hover */

         stat = XmlEnc_HoverCommandType (pctxt, pvalue->u.hover
            , OSUTF8("Hover"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode loiter */

         stat = XmlEnc_UuvLoiterCommandType (pctxt, pvalue->u.loiter
            , OSUTF8("Loiter"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode makeAltitude */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.makeAltitude, OSUTF8("MakeAltitude"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode makeDepth */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.makeDepth, OSUTF8("MakeDepth"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode makeHeading */

         stat = XmlEnc_HeadingElementType (pctxt, pvalue->u.makeHeading
            , OSUTF8("MakeHeading"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 10:
         /* encode makeKnots */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeKnots
            , OSUTF8("MakeKnots"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 11:
         /* encode makeSpeed */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeSpeed
            , OSUTF8("MakeSpeed"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 12:
         /* encode metaCommand */

         stat = XmlEnc_MetaDataType (pctxt, pvalue->u.metaCommand
            , OSUTF8("MetaCommand"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 13:
         /* encode missionScript */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScript
            , OSUTF8("MissionScript"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 14:
         /* encode missionScriptInline */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScriptInline
            , OSUTF8("MissionScriptInline"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 15:
         /* encode moveLateral */

         stat = XmlEnc_ScalarElementType (pctxt, pvalue->u.moveLateral
            , OSUTF8("MoveLateral"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 16:
         /* encode moveRotate */

         stat = XmlEnc_ScalarElementType (pctxt, pvalue->u.moveRotate
            , OSUTF8("MoveRotate"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 17:
         /* encode quit */

         stat = XmlEnc_QuitCommandType (pctxt, pvalue->u.quit
            , OSUTF8("Quit"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 18:
         /* encode realtime */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->
            u.realtime, OSUTF8("Realtime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 19:
         /* encode recover */

         stat = XmlEnc_RecoverCommandType (pctxt, pvalue->u.recover
            , OSUTF8("Recover"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 20:
         /* encode sendMessage */

         stat = XmlEnc_SendMessageCommandType (pctxt, pvalue->u.sendMessage
            , OSUTF8("SendMessage"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 21:
         /* encode setPlanes */

         stat = XmlEnc_SetPlanesCommandType (pctxt, pvalue->u.setPlanes
            , OSUTF8("SetPlanes"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 22:
         /* encode setPosition */

         stat = XmlEnc_UuvPositionCommandType (pctxt, pvalue->u.setPosition
            , OSUTF8("SetPosition"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 23:
         /* encode setPower */

         stat = XmlEnc_SetPropellerCommandType (pctxt, pvalue->u.setPower
            , OSUTF8("SetPower"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 24:
         /* encode setRudder */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.setRudder
            , OSUTF8("SetRudder"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 25:
         /* encode setSonar */

         stat = XmlEnc_SetSonarCommandType (pctxt, pvalue->u.setSonar
            , OSUTF8("SetSonar"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 26:
         /* encode setStandoff */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setStandoff, OSUTF8("SetStandoff"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 27:
         /* encode setThruster */

         stat = XmlEnc_SetThrusterCommandType (pctxt, pvalue->u.setThruster
            , OSUTF8("SetThruster"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 28:
         /* encode setTime */

         stat = XmlEnc_ScalarElementType (pctxt, pvalue->u.setTime
            , OSUTF8("SetTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 29:
         /* encode setTimeStep */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setTimeStep, OSUTF8("SetTimeStep"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 30:
         /* encode takeStation */

         stat = XmlEnc_TakeStationCommandType (pctxt, pvalue->u.takeStation
            , OSUTF8("TakeStation"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 31:
         /* encode thrusters */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->
            u.thrusters, OSUTF8("Thrusters"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 32:
         /* encode trace */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->u.trace
            , OSUTF8("Trace"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 33:
         /* encode wait */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.wait, OSUTF8("Wait"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 34:
         /* encode waitUntilTime */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.waitUntilTime, OSUTF8("WaitUntilTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 35:
         /* encode waypoint */

         stat = XmlEnc_UuvWaypointCommandType (pctxt, pvalue->u.waypoint
            , OSUTF8("Waypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 36:
         /* encode aVCLMessage */

         stat = XmlEnc_AvclMessageType (pctxt, pvalue->u.aVCLMessage
            , OSUTF8("AVCLMessage"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvLoggableEventType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UuvLoggableEventType (OSCTXT* pctxt,
   UuvLoggableEventType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UuvLoggableEventType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->choice_list.tail;
   while (0 != pnode2) {
      ll = asn1E_UuvLoggableEventType_element (pctxt, ((UuvLoggableEventType_element*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UuvLoggableEventType (OSCTXT* pctxt, UuvLoggableEventType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UuvLoggableEventType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->choice_list.head;
   while (0 != pnode) {
      stat = XmlEnc_UuvLoggableEventType_element (pctxt, 
         ((UuvLoggableEventType_element*)pnode->data), 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvLoggableEventType_element                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvLoggableEventType_element (OSCTXT* pctxt,
   UgvLoggableEventType_element *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UgvCompositeWaypointCommandType (pctxt, pvalue->u.compositeWaypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_NoValueElementType (pctxt, pvalue->u.help, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_UgvLoiterCommandType (pctxt, pvalue->u.loiter, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_HeadingElementType (pctxt, pvalue->u.makeHeading, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.makeSpeed, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
            asn1E_MetaDataType (pctxt, pvalue->u.metaCommand, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
            asn1E_StringElementType (pctxt, pvalue->u.missionScript, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
            asn1E_StringElementType (pctxt, pvalue->u.missionScriptInline, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
            asn1E_QuitCommandType (pctxt, pvalue->u.quit, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 10:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.realtime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 11:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
            asn1E_SendMessageCommandType (pctxt, pvalue->u.sendMessage, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 12:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
            asn1E_UgvPositionCommandType (pctxt, pvalue->u.setPosition, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 13:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setStandoff, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 14:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|13,
            asn1E_ScalarElementType (pctxt, pvalue->u.setTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 15:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|14,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setTimeStep, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 16:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|15,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.trace, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 17:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|16,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.wait, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 18:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|17,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.waitUntilTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 19:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|18,
            asn1E_UgvWaypointCommandType (pctxt, pvalue->u.waypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 20:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|19,
            asn1E_AvclMessageType (pctxt, (AvclMessageType*)pvalue->u.aVCLMessage, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_UgvLoggableEventType_element (OSCTXT* pctxt, 
   UgvLoggableEventType_element* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode compositeWaypoint */

         stat = XmlEnc_UgvCompositeWaypointCommandType (pctxt, pvalue->
            u.compositeWaypoint, OSUTF8("CompositeWaypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode help */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.help
            , OSUTF8("Help"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode loiter */

         stat = XmlEnc_UgvLoiterCommandType (pctxt, pvalue->u.loiter
            , OSUTF8("Loiter"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode makeHeading */

         stat = XmlEnc_HeadingElementType (pctxt, pvalue->u.makeHeading
            , OSUTF8("MakeHeading"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode makeSpeed */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.makeSpeed, OSUTF8("MakeSpeed"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode metaCommand */

         stat = XmlEnc_MetaDataType (pctxt, pvalue->u.metaCommand
            , OSUTF8("MetaCommand"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode missionScript */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScript
            , OSUTF8("MissionScript"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode missionScriptInline */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScriptInline
            , OSUTF8("MissionScriptInline"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode quit */

         stat = XmlEnc_QuitCommandType (pctxt, pvalue->u.quit
            , OSUTF8("Quit"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 10:
         /* encode realtime */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->
            u.realtime, OSUTF8("Realtime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 11:
         /* encode sendMessage */

         stat = XmlEnc_SendMessageCommandType (pctxt, pvalue->u.sendMessage
            , OSUTF8("SendMessage"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 12:
         /* encode setPosition */

         stat = XmlEnc_UgvPositionCommandType (pctxt, pvalue->u.setPosition
            , OSUTF8("SetPosition"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 13:
         /* encode setStandoff */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setStandoff, OSUTF8("SetStandoff"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 14:
         /* encode setTime */

         stat = XmlEnc_ScalarElementType (pctxt, pvalue->u.setTime
            , OSUTF8("SetTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 15:
         /* encode setTimeStep */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setTimeStep, OSUTF8("SetTimeStep"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 16:
         /* encode trace */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->u.trace
            , OSUTF8("Trace"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 17:
         /* encode wait */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.wait, OSUTF8("Wait"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 18:
         /* encode waitUntilTime */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.waitUntilTime, OSUTF8("WaitUntilTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 19:
         /* encode waypoint */

         stat = XmlEnc_UgvWaypointCommandType (pctxt, pvalue->u.waypoint
            , OSUTF8("Waypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 20:
         /* encode aVCLMessage */

         stat = XmlEnc_AvclMessageType (pctxt, pvalue->u.aVCLMessage
            , OSUTF8("AVCLMessage"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvLoggableEventType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UgvLoggableEventType (OSCTXT* pctxt,
   UgvLoggableEventType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UgvLoggableEventType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->choice_list.tail;
   while (0 != pnode2) {
      ll = asn1E_UgvLoggableEventType_element (pctxt, ((UgvLoggableEventType_element*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UgvLoggableEventType (OSCTXT* pctxt, UgvLoggableEventType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UgvLoggableEventType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->choice_list.head;
   while (0 != pnode) {
      stat = XmlEnc_UgvLoggableEventType_element (pctxt, 
         ((UgvLoggableEventType_element*)pnode->data), 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvLoggableEventType_element                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvLoggableEventType_element (OSCTXT* pctxt,
   UsvLoggableEventType_element *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UsvCompositeWaypointCommandType (pctxt, pvalue->u.compositeWaypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_NoValueElementType (pctxt, pvalue->u.help, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_UsvLoiterCommandType (pctxt, pvalue->u.loiter, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_HeadingElementType (pctxt, pvalue->u.makeHeading, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeKnots, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeSpeed, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
            asn1E_MetaDataType (pctxt, pvalue->u.metaCommand, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
            asn1E_StringElementType (pctxt, pvalue->u.missionScript, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
            asn1E_StringElementType (pctxt, pvalue->u.missionScriptInline, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 10:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
            asn1E_QuitCommandType (pctxt, pvalue->u.quit, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 11:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.realtime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 12:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
            asn1E_SendMessageCommandType (pctxt, pvalue->u.sendMessage, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 13:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12,
            asn1E_UsvPositionCommandType (pctxt, pvalue->u.setPosition, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 14:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|13,
            asn1E_SetPropellerCommandType (pctxt, pvalue->u.setPower, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 15:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|14,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.setRudder, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 16:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|15,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setStandoff, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 17:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|16,
            asn1E_ScalarElementType (pctxt, pvalue->u.setTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 18:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|17,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setTimeStep, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 19:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|18,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.trace, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 20:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|19,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.wait, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 21:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|20,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.waitUntilTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 22:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|21,
            asn1E_UsvWaypointCommandType (pctxt, pvalue->u.waypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 23:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|22,
            asn1E_AvclMessageType (pctxt, (AvclMessageType*)pvalue->u.aVCLMessage, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_UsvLoggableEventType_element (OSCTXT* pctxt, 
   UsvLoggableEventType_element* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode compositeWaypoint */

         stat = XmlEnc_UsvCompositeWaypointCommandType (pctxt, pvalue->
            u.compositeWaypoint, OSUTF8("CompositeWaypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode help */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.help
            , OSUTF8("Help"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode loiter */

         stat = XmlEnc_UsvLoiterCommandType (pctxt, pvalue->u.loiter
            , OSUTF8("Loiter"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode makeHeading */

         stat = XmlEnc_HeadingElementType (pctxt, pvalue->u.makeHeading
            , OSUTF8("MakeHeading"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode makeKnots */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeKnots
            , OSUTF8("MakeKnots"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode makeSpeed */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeSpeed
            , OSUTF8("MakeSpeed"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode metaCommand */

         stat = XmlEnc_MetaDataType (pctxt, pvalue->u.metaCommand
            , OSUTF8("MetaCommand"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode missionScript */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScript
            , OSUTF8("MissionScript"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode missionScriptInline */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScriptInline
            , OSUTF8("MissionScriptInline"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 10:
         /* encode quit */

         stat = XmlEnc_QuitCommandType (pctxt, pvalue->u.quit
            , OSUTF8("Quit"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 11:
         /* encode realtime */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->
            u.realtime, OSUTF8("Realtime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 12:
         /* encode sendMessage */

         stat = XmlEnc_SendMessageCommandType (pctxt, pvalue->u.sendMessage
            , OSUTF8("SendMessage"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 13:
         /* encode setPosition */

         stat = XmlEnc_UsvPositionCommandType (pctxt, pvalue->u.setPosition
            , OSUTF8("SetPosition"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 14:
         /* encode setPower */

         stat = XmlEnc_SetPropellerCommandType (pctxt, pvalue->u.setPower
            , OSUTF8("SetPower"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 15:
         /* encode setRudder */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.setRudder
            , OSUTF8("SetRudder"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 16:
         /* encode setStandoff */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setStandoff, OSUTF8("SetStandoff"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 17:
         /* encode setTime */

         stat = XmlEnc_ScalarElementType (pctxt, pvalue->u.setTime
            , OSUTF8("SetTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 18:
         /* encode setTimeStep */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setTimeStep, OSUTF8("SetTimeStep"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 19:
         /* encode trace */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->u.trace
            , OSUTF8("Trace"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 20:
         /* encode wait */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.wait, OSUTF8("Wait"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 21:
         /* encode waitUntilTime */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.waitUntilTime, OSUTF8("WaitUntilTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 22:
         /* encode waypoint */

         stat = XmlEnc_UsvWaypointCommandType (pctxt, pvalue->u.waypoint
            , OSUTF8("Waypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 23:
         /* encode aVCLMessage */

         stat = XmlEnc_AvclMessageType (pctxt, pvalue->u.aVCLMessage
            , OSUTF8("AVCLMessage"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvLoggableEventType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UsvLoggableEventType (OSCTXT* pctxt,
   UsvLoggableEventType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UsvLoggableEventType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->choice_list.tail;
   while (0 != pnode2) {
      ll = asn1E_UsvLoggableEventType_element (pctxt, ((UsvLoggableEventType_element*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UsvLoggableEventType (OSCTXT* pctxt, UsvLoggableEventType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UsvLoggableEventType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->choice_list.head;
   while (0 != pnode) {
      stat = XmlEnc_UsvLoggableEventType_element (pctxt, 
         ((UsvLoggableEventType_element*)pnode->data), 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavLoggableEventType_element                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavLoggableEventType_element (OSCTXT* pctxt,
   UavLoggableEventType_element *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UavCompositeWaypointCommandType (pctxt, pvalue->u.compositeWaypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_NoValueElementType (pctxt, pvalue->u.help, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_UavLoiterCommandType (pctxt, pvalue->u.loiter, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.makeAltitudeAGL, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.makeAltitudeMSL, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.makeClimbRate, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
            asn1E_HeadingElementType (pctxt, pvalue->u.makeHeading, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeKnots, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
            asn1E_SpeedElementType (pctxt, pvalue->u.makeSpeed, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 10:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.makeTurnRate, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 11:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
            asn1E_MetaDataType (pctxt, pvalue->u.metaCommand, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 12:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|11,
            asn1E_StringElementType (pctxt, pvalue->u.missionScript, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 13:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|12,
            asn1E_StringElementType (pctxt, pvalue->u.missionScriptInline, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 14:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|13,
            asn1E_QuitCommandType (pctxt, pvalue->u.quit, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 15:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|14,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.realtime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 16:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|15,
            asn1E_SendMessageCommandType (pctxt, pvalue->u.sendMessage, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 17:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|16,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.setAileron, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 18:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|17,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.setElevator, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 19:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|18,
            asn1E_UavPositionCommandType (pctxt, pvalue->u.setPosition, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 20:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|19,
            asn1E_PercentElementType (pctxt, pvalue->u.setPower, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 21:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|20,
            asn1E_SignedPercentElementType (pctxt, pvalue->u.setRudder, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 22:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|21,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setStandoff, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 23:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|22,
            asn1E_ScalarElementType (pctxt, pvalue->u.setTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 24:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|23,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.setTimeStep, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 25:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|24,
            asn1E_BooleanElementType_derivations (pctxt, pvalue->u.trace, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 26:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|25,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.wait, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 27:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|26,
            asn1E_PositiveScalarElementType_derivations (pctxt, pvalue->u.waitUntilTime, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 28:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|27,
            asn1E_UavWaypointCommandType (pctxt, pvalue->u.waypoint, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 29:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|28,
            asn1E_AvclMessageType (pctxt, (AvclMessageType*)pvalue->u.aVCLMessage, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_UavLoggableEventType_element (OSCTXT* pctxt, 
   UavLoggableEventType_element* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode compositeWaypoint */

         stat = XmlEnc_UavCompositeWaypointCommandType (pctxt, pvalue->
            u.compositeWaypoint, OSUTF8("CompositeWaypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode help */

         stat = XmlEnc_NoValueElementType (pctxt, pvalue->u.help
            , OSUTF8("Help"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode loiter */

         stat = XmlEnc_UavLoiterCommandType (pctxt, pvalue->u.loiter
            , OSUTF8("Loiter"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode makeAltitudeAGL */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.makeAltitudeAGL, OSUTF8("MakeAltitudeAGL"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode makeAltitudeMSL */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.makeAltitudeMSL, OSUTF8("MakeAltitudeMSL"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode makeClimbRate */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.makeClimbRate
            , OSUTF8("MakeClimbRate"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode makeHeading */

         stat = XmlEnc_HeadingElementType (pctxt, pvalue->u.makeHeading
            , OSUTF8("MakeHeading"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode makeKnots */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeKnots
            , OSUTF8("MakeKnots"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode makeSpeed */

         stat = XmlEnc_SpeedElementType (pctxt, pvalue->u.makeSpeed
            , OSUTF8("MakeSpeed"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 10:
         /* encode makeTurnRate */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.makeTurnRate
            , OSUTF8("MakeTurnRate"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 11:
         /* encode metaCommand */

         stat = XmlEnc_MetaDataType (pctxt, pvalue->u.metaCommand
            , OSUTF8("MetaCommand"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 12:
         /* encode missionScript */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScript
            , OSUTF8("MissionScript"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 13:
         /* encode missionScriptInline */

         stat = XmlEnc_StringElementType (pctxt, pvalue->u.missionScriptInline
            , OSUTF8("MissionScriptInline"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 14:
         /* encode quit */

         stat = XmlEnc_QuitCommandType (pctxt, pvalue->u.quit
            , OSUTF8("Quit"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 15:
         /* encode realtime */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->
            u.realtime, OSUTF8("Realtime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 16:
         /* encode sendMessage */

         stat = XmlEnc_SendMessageCommandType (pctxt, pvalue->u.sendMessage
            , OSUTF8("SendMessage"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 17:
         /* encode setAileron */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.setAileron
            , OSUTF8("SetAileron"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 18:
         /* encode setElevator */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.setElevator
            , OSUTF8("SetElevator"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 19:
         /* encode setPosition */

         stat = XmlEnc_UavPositionCommandType (pctxt, pvalue->u.setPosition
            , OSUTF8("SetPosition"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 20:
         /* encode setPower */

         stat = XmlEnc_PercentElementType (pctxt, pvalue->u.setPower
            , OSUTF8("SetPower"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 21:
         /* encode setRudder */

         stat = XmlEnc_SignedPercentElementType (pctxt, pvalue->u.setRudder
            , OSUTF8("SetRudder"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 22:
         /* encode setStandoff */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setStandoff, OSUTF8("SetStandoff"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 23:
         /* encode setTime */

         stat = XmlEnc_ScalarElementType (pctxt, pvalue->u.setTime
            , OSUTF8("SetTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 24:
         /* encode setTimeStep */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.setTimeStep, OSUTF8("SetTimeStep"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 25:
         /* encode trace */

         stat = XmlEnc_BooleanElementType_derivations (pctxt, pvalue->u.trace
            , OSUTF8("Trace"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 26:
         /* encode wait */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.wait, OSUTF8("Wait"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 27:
         /* encode waitUntilTime */

         stat = XmlEnc_PositiveScalarElementType_derivations (pctxt, pvalue->
            u.waitUntilTime, OSUTF8("WaitUntilTime"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 28:
         /* encode waypoint */

         stat = XmlEnc_UavWaypointCommandType (pctxt, pvalue->u.waypoint
            , OSUTF8("Waypoint"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 29:
         /* encode aVCLMessage */

         stat = XmlEnc_AvclMessageType (pctxt, pvalue->u.aVCLMessage
            , OSUTF8("AVCLMessage"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavLoggableEventType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UavLoggableEventType (OSCTXT* pctxt,
   UavLoggableEventType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UavLoggableEventType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode2 = pvalue->choice_list.tail;
   while (0 != pnode2) {
      ll = asn1E_UavLoggableEventType_element (pctxt, ((UavLoggableEventType_element*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UavLoggableEventType (OSCTXT* pctxt, UavLoggableEventType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice_list */

   if (!(pvalue->choice_list.count >= 1U)) {
      rtxErrAddStrParm (pctxt, "UavLoggableEventType.choice_list.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   { OSRTDListNode* pnode = pvalue->choice_list.head;
   while (0 != pnode) {
      stat = XmlEnc_UavLoggableEventType_element (pctxt, 
         ((UavLoggableEventType_element*)pnode->data), 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LoggableEvent                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_LoggableEvent (OSCTXT* pctxt,
   LoggableEvent *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UuvLoggableEventType (pctxt, pvalue->u.uUVEvent, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_UgvLoggableEventType (pctxt, pvalue->u.uGVEvent, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_UsvLoggableEventType (pctxt, pvalue->u.uSVEvent, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_UavLoggableEventType (pctxt, pvalue->u.uAVEvent, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_LoggableEvent (OSCTXT* pctxt, LoggableEvent* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode uUVEvent */

         stat = XmlEnc_UuvLoggableEventType (pctxt, pvalue->u.uUVEvent
            , OSUTF8("UUVEvent"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode uGVEvent */

         stat = XmlEnc_UgvLoggableEventType (pctxt, pvalue->u.uGVEvent
            , OSUTF8("UGVEvent"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode uSVEvent */

         stat = XmlEnc_UsvLoggableEventType (pctxt, pvalue->u.uSVEvent
            , OSUTF8("USVEvent"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode uAVEvent */

         stat = XmlEnc_UavLoggableEventType (pctxt, pvalue->u.uAVEvent
            , OSUTF8("UAVEvent"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MessageBodyContent_sensorDataReport                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MessageBodyContent_sensorDataReport (OSCTXT* pctxt,
   MessageBodyContent_sensorDataReport *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         if (!(pvalue->u.choice_list->count >= 1U)) {
            rtxErrAddStrParm (pctxt, "MessageBodyContent_sensorDataReport.u.choice_list.count");
            rtxErrAddIntParm (pctxt, (int)pvalue->u.choice_list->count);
            return LOG_RTERR (pctxt, RTERR_CONSVIO);
         }

         pnode2 = pvalue->u.choice_list->tail;
         while (0 != pnode2) {
            ll = asn1E_SensorElements (pctxt, ((SensorElements*)pnode2->data), ASN1EXPL);
            if (ll < 0) return LOG_RTERR (pctxt, ll);
            ll2 += ll;

            pnode2 = pnode2->prev;
         }
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         else { ll1 += ll; ll2 = 0; }
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_MessageBodyContent_sensorDataReport (OSCTXT* pctxt, 
   MessageBodyContent_sensorDataReport* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode choice_list */

         if (!(pvalue->u.choice_list->count >= 1U)) {
            rtxErrAddStrParm (pctxt, "MessageBodyContent_sensorDataReport.u.choice_list.count");
            rtxErrAddIntParm (pctxt, (int)pvalue->u.choice_list->count);
            return LOG_RTERR (pctxt, RTERR_CONSVIO);
         }

         { OSRTDListNode* pnode = pvalue->u.choice_list->head;
         while (0 != pnode) {
            stat = XmlEnc_SensorElements (pctxt, ((SensorElements*)pnode->data)
               , 0, nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
            pnode = pnode->next;
         }}

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MessageBodyContent                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MessageBodyContent (OSCTXT* pctxt,
   MessageBodyContent *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_MissionSpecification (pctxt, pvalue->u.choice, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_UuvScriptCommandsType (pctxt, pvalue->u.uUVCommand, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_UgvScriptCommandsType (pctxt, pvalue->u.uGVCommand, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_UsvScriptCommandsType (pctxt, pvalue->u.uSVCommand, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 5:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
            asn1E_UavScriptCommandsType (pctxt, pvalue->u.uAVCommand, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 6:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
            asn1E_InformationRequestElementType (pctxt, pvalue->u.informationRequest, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 7:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
            asn1E_VehicleGroupCompositionElementType (pctxt, pvalue->u.groupMaintenance, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 8:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
            asn1E_VehicleCharacteristicsGroup (pctxt, pvalue->u.choice_1, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 9:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
            asn1E_DiscreteTimeResultsElementType (pctxt, pvalue->u.vehicleState, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 10:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|9,
            asn1E_LoggableEvent (pctxt, pvalue->u.choice_2, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 11:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|10,
            asn1E_MessageBodyContent_sensorDataReport (pctxt, pvalue->u.sensorDataReport, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_MessageBodyContent (OSCTXT* pctxt, MessageBodyContent* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode choice */

         stat = XmlEnc_MissionSpecification (pctxt, pvalue->u.choice
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode uUVCommand */

         stat = XmlEnc_UuvScriptCommandsType (pctxt, pvalue->u.uUVCommand
            , OSUTF8("UUVCommand"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode uGVCommand */

         stat = XmlEnc_UgvScriptCommandsType (pctxt, pvalue->u.uGVCommand
            , OSUTF8("UGVCommand"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode uSVCommand */

         stat = XmlEnc_UsvScriptCommandsType (pctxt, pvalue->u.uSVCommand
            , OSUTF8("USVCommand"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 5:
         /* encode uAVCommand */

         stat = XmlEnc_UavScriptCommandsType (pctxt, pvalue->u.uAVCommand
            , OSUTF8("UAVCommand"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 6:
         /* encode informationRequest */

         stat = XmlEnc_InformationRequestElementType (pctxt, pvalue->
            u.informationRequest, OSUTF8("InformationRequest"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 7:
         /* encode groupMaintenance */

         stat = XmlEnc_VehicleGroupCompositionElementType (pctxt, pvalue->
            u.groupMaintenance, OSUTF8("GroupMaintenance"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 8:
         /* encode choice_1 */

         stat = XmlEnc_VehicleCharacteristicsGroup (pctxt, pvalue->u.choice_1
            , 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 9:
         /* encode vehicleState */

         stat = XmlEnc_DiscreteTimeResultsElementType (pctxt, pvalue->
            u.vehicleState, OSUTF8("VehicleState"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 10:
         /* encode choice_2 */

         stat = XmlEnc_LoggableEvent (pctxt, pvalue->u.choice_2, 0, nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 11:
         /* encode sensorDataReport */

         stat = XmlEnc_MessageBodyContent_sensorDataReport (pctxt, pvalue->
            u.sensorDataReport, OSUTF8("SensorDataReport"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AvclMessageBodyType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AvclMessageBodyType (OSCTXT* pctxt,
   AvclMessageBodyType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = asn1E_MessageBodyContent (pctxt, pvalue, ASN1IMPL);
   if (ll < 0) return LOG_RTERR (pctxt, ll);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll);
   if (ll < 0) return LOG_RTERR (pctxt, ll);

   if (tagging == ASN1EXPL) {
      ll = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
   }
   ll0 += ll;

   return (ll0);
}

int XmlEnc_AvclMessageBodyType (OSCTXT* pctxt, AvclMessageBodyType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = XmlEnc_MessageBodyContent (pctxt, pvalue, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AvclMessageType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AvclMessageType (OSCTXT* pctxt,
   AvclMessageType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode body */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
      asn1E_AvclMessageBodyType (pctxt, &pvalue->body, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode head */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
      asn1E_AvclMessageHeadType (pctxt, &pvalue->head, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode version */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_utf8str (pctxt, pvalue->version, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode transportStatus */

   if (pvalue->m.transportStatusPresent) {
      if(pvalue->transportStatus < 0 || pvalue->transportStatus > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_AvclMessageType_transportStatus (pctxt, &pvalue->transportStatus, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AvclMessageType (OSCTXT* pctxt, AvclMessageType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   if (pvalue->m.transportStatusPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" transportStatus=\""), 18);

      if(pvalue->transportStatus < 0 || pvalue->transportStatus > 2)
         return LOG_RTERR (pctxt, RTERR_INVENUM);

      stat = XmlEnc_AvclMessageType_transportStatus (pctxt, pvalue->
         transportStatus, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" version=\""), 10);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->version, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode head */

   stat = XmlEnc_AvclMessageHeadType (pctxt, &pvalue->head
      , OSUTF8("head"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode body */

   stat = XmlEnc_AvclMessageBodyType (pctxt, &pvalue->body
      , OSUTF8("body"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AVCLMessage                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AVCLMessage (OSCTXT* pctxt,
   AVCLMessage *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   ll = asn1E_AvclMessageType (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_AVCLMessage (OSCTXT* pctxt, AVCLMessage* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = XmlEnc_AvclMessageType (pctxt, pvalue, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CalendarDaysType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_CalendarDaysType (OSCTXT* pctxt,
   CalendarDaysType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if (!((*pvalue <= OSUINTCONST(31)))) {
      rtxErrAddStrParm (pctxt, "CalendarDaysType");
      rtxErrAddIntParm (pctxt, (int)*pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   ll = xe_uint8 (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_CalendarDaysType (OSCTXT* pctxt, CalendarDaysType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (!((value <= OSUINTCONST(31)))) {
      rtxErrAddStrParm (pctxt, "CalendarDaysType");
      rtxErrAddIntParm (pctxt, (int)value);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   stat = rtXmlEncUInt (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MonthsType                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MonthsType (OSCTXT* pctxt,
   MonthsType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if(*pvalue < 0 || *pvalue > 11)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_enum (pctxt, (OSINT32*)pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_MonthsType (OSCTXT* pctxt, MonthsType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   stat = rtXmlEncUTF8Str (pctxt,
      MonthsType_ToString (value), elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ClockHoursType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ClockHoursType (OSCTXT* pctxt,
   ClockHoursType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if (!((*pvalue <= OSUINTCONST(23)))) {
      rtxErrAddStrParm (pctxt, "ClockHoursType");
      rtxErrAddIntParm (pctxt, (int)*pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   ll = xe_uint8 (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_ClockHoursType (OSCTXT* pctxt, ClockHoursType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (!((value <= OSUINTCONST(23)))) {
      rtxErrAddStrParm (pctxt, "ClockHoursType");
      rtxErrAddIntParm (pctxt, (int)value);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   stat = rtXmlEncUInt (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ClockMinutesOrSecondsType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ClockMinutesOrSecondsType (OSCTXT* pctxt,
   ClockMinutesOrSecondsType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if (!((*pvalue <= OSUINTCONST(59)))) {
      rtxErrAddStrParm (pctxt, "ClockMinutesOrSecondsType");
      rtxErrAddIntParm (pctxt, (int)*pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   ll = xe_uint8 (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_ClockMinutesOrSecondsType (OSCTXT* pctxt, 
   ClockMinutesOrSecondsType value, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (!((value <= OSUINTCONST(59)))) {
      rtxErrAddStrParm (pctxt, "ClockMinutesOrSecondsType");
      rtxErrAddIntParm (pctxt, (int)value);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   stat = rtXmlEncUInt (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TimeZoneType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TimeZoneType (OSCTXT* pctxt,
   TimeZoneType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if (!((*pvalue >= OSINTCONST(-12) && *pvalue <= OSINTCONST(12)))) {
      rtxErrAddStrParm (pctxt, "TimeZoneType");
      rtxErrAddIntParm (pctxt, (int)*pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   ll = xe_int8 (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_TimeZoneType (OSCTXT* pctxt, TimeZoneType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (!((value >= OSINTCONST(-12) && value <= OSINTCONST(12)))) {
      rtxErrAddStrParm (pctxt, "TimeZoneType");
      rtxErrAddIntParm (pctxt, (int)value);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   stat = rtXmlEncInt (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonNegativeIntType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_NonNegativeIntType (OSCTXT* pctxt,
   NonNegativeIntType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;

   if (!(*pvalue >= 0)) {
      rtxErrAddStrParm (pctxt, "NonNegativeIntType");
      rtxErrAddIntParm (pctxt, *pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   ll = xe_integer (pctxt, pvalue, tagging);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll0 += ll;

   return (ll0);
}

int XmlEnc_NonNegativeIntType (OSCTXT* pctxt, NonNegativeIntType value, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (!(value >= 0)) {
      rtxErrAddStrParm (pctxt, "NonNegativeIntType");
      rtxErrAddIntParm (pctxt, value);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   stat = rtXmlEncInt (pctxt, value, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AvclHeadType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AvclHeadType (OSCTXT* pctxt,
   AvclHeadType *pvalue, ASN1TagType tagging)
{
   OSRTDListNode* pnode1;
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   pnode1 = pvalue->tail;
   while (0 != pnode1) {
      ll = asn1E_MetaDataType (pctxt, ((MetaDataType*)pnode1->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;

      pnode1 = pnode1->prev;
   }
   ll1 = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll1);
   if (ll1 < 0) return LOG_RTERR (pctxt, ll1);

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AvclHeadType (OSCTXT* pctxt, AvclHeadType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (elemName != 0) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { OSRTDListNode* pnode = pvalue->head;
   while (0 != pnode) {
      stat = XmlEnc_MetaDataType (pctxt, ((MetaDataType*)pnode->data)
         , OSUTF8("meta"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnitsOfMeasureElementType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_UnitsOfMeasureElementType (OSCTXT* pctxt,
   UnitsOfMeasureElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode time_ */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
      xe_utf8str (pctxt, pvalue->time_, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode mass */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_utf8str (pctxt, pvalue->mass, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode distance */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      xe_utf8str (pctxt, pvalue->distance, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode angle */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      xe_utf8str (pctxt, pvalue->angle, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_UnitsOfMeasureElementType (OSCTXT* pctxt, 
   UnitsOfMeasureElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" angle=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->angle, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" distance=\""), 11);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->distance, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" mass=\""), 7);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->mass, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" time=\""), 7);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->time_, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConfigurationElementType_choice                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ConfigurationElementType_choice (OSCTXT* pctxt,
   ConfigurationElementType_choice *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UuvCharacteristicsElementType (pctxt, pvalue->u.unmannedUnderwaterVehicle, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_UsvCharacteristicsElementType (pctxt, pvalue->u.unmannedSurfaceVehicle, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_UgvCharacteristicsElementType (pctxt, pvalue->u.unmannedGroundVehicle, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_UavCharacteristicsElementType (pctxt, pvalue->u.unmannedAerialVehicle, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_ConfigurationElementType_choice (OSCTXT* pctxt, 
   ConfigurationElementType_choice* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode unmannedUnderwaterVehicle */

         stat = XmlEnc_UuvCharacteristicsElementType (pctxt, pvalue->
            u.unmannedUnderwaterVehicle
            , OSUTF8("UnmannedUnderwaterVehicle"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode unmannedSurfaceVehicle */

         stat = XmlEnc_UsvCharacteristicsElementType (pctxt, pvalue->
            u.unmannedSurfaceVehicle
            , OSUTF8("UnmannedSurfaceVehicle"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode unmannedGroundVehicle */

         stat = XmlEnc_UgvCharacteristicsElementType (pctxt, pvalue->
            u.unmannedGroundVehicle
            , OSUTF8("UnmannedGroundVehicle"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode unmannedAerialVehicle */

         stat = XmlEnc_UavCharacteristicsElementType (pctxt, pvalue->
            u.unmannedAerialVehicle
            , OSUTF8("UnmannedAerialVehicle"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConfigurationElementType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_ConfigurationElementType (OSCTXT* pctxt,
   ConfigurationElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_ConfigurationElementType_choice (pctxt, &pvalue->choice, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_ConfigurationElementType (OSCTXT* pctxt, 
   ConfigurationElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice */

   stat = XmlEnc_ConfigurationElementType_choice (pctxt, &pvalue->choice
      , 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MissionPreparationElementType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MissionPreparationElementType (OSCTXT* pctxt,
   MissionPreparationElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode choice */

   if (pvalue->m.choicePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|6,
         asn1E_MissionSpecification (pctxt, &pvalue->choice, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode configuration */

   if (pvalue->m.configurationPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|5,
         asn1E_ConfigurationElementType (pctxt, &pvalue->configuration, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode geoOrigin */

   if (pvalue->m.geoOriginPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4,
         asn1E_GeoOriginElementType (pctxt, &pvalue->geoOrigin, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode unitsOfMeasure */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
      asn1E_UnitsOfMeasureElementType (pctxt, &pvalue->unitsOfMeasure, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_MissionPreparationElementType (OSCTXT* pctxt, 
   MissionPreparationElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode unitsOfMeasure */

   stat = XmlEnc_UnitsOfMeasureElementType (pctxt, &pvalue->unitsOfMeasure
      , OSUTF8("UnitsOfMeasure"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   /* encode geoOrigin */

   if (pvalue->m.geoOriginPresent) {
      stat = XmlEnc_GeoOriginElementType (pctxt, &pvalue->geoOrigin
         , OSUTF8("GeoOrigin"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode configuration */

   if (pvalue->m.configurationPresent) {
      stat = XmlEnc_ConfigurationElementType (pctxt, &pvalue->configuration
         , OSUTF8("Configuration"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice */

   if (pvalue->m.choicePresent) {
      stat = XmlEnc_MissionSpecification (pctxt, &pvalue->choice
         , 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EventLogElementType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_EventLogElementType (OSCTXT* pctxt,
   EventLogElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode choice_list */

   pnode2 = pvalue->choice_list.tail;
   while (0 != pnode2) {
      ll = asn1E_LoggableEvent (pctxt, ((LoggableEvent*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_EventLogElementType (OSCTXT* pctxt, EventLogElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode choice_list */

   { OSRTDListNode* pnode = pvalue->choice_list.head;
   while (0 != pnode) {
      stat = XmlEnc_LoggableEvent (pctxt, ((LoggableEvent*)pnode->data)
         , 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DateTimeGroupElementType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_DateTimeGroupElementType (OSCTXT* pctxt,
   DateTimeGroupElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode year */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|7,
      asn1E_PositiveIntType (pctxt, &pvalue->year, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeZone */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
      asn1E_TimeZoneType (pctxt, &pvalue->timeZone, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode second */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
      asn1E_ClockMinutesOrSecondsType (pctxt, &pvalue->second, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode month */

   if(pvalue->month < 0 || pvalue->month > 11)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      asn1E_MonthsType (pctxt, &pvalue->month, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode minute */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_ClockMinutesOrSecondsType (pctxt, &pvalue->minute, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode hour */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
      asn1E_ClockHoursType (pctxt, &pvalue->hour, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode day */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
      asn1E_CalendarDaysType (pctxt, &pvalue->day, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_DateTimeGroupElementType (OSCTXT* pctxt, 
   DateTimeGroupElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" day=\""), 6);

   stat = XmlEnc_CalendarDaysType (pctxt, pvalue->day, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" hour=\""), 7);

   stat = XmlEnc_ClockHoursType (pctxt, pvalue->hour, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" minute=\""), 9);

   stat = XmlEnc_ClockMinutesOrSecondsType (pctxt, pvalue->minute, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" month=\""), 8);

   if(pvalue->month < 0 || pvalue->month > 11)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   stat = XmlEnc_MonthsType (pctxt, pvalue->month, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" second=\""), 9);

   stat = XmlEnc_ClockMinutesOrSecondsType (pctxt, pvalue->second, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeZone=\""), 11);

   stat = XmlEnc_TimeZoneType (pctxt, pvalue->timeZone, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" year=\""), 7);

   stat = XmlEnc_PositiveIntType (pctxt, pvalue->year, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MissionResultsElementType_element                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MissionResultsElementType_element (OSCTXT* pctxt,
   MissionResultsElementType_element *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_DiscreteTimeResultsElementType (pctxt, pvalue->u.sampledResults, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_MissionResultsElementType_element (OSCTXT* pctxt, 
   MissionResultsElementType_element* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode sampledResults */

         stat = XmlEnc_DiscreteTimeResultsElementType (pctxt, pvalue->
            u.sampledResults, OSUTF8("SampledResults"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MissionResultsElementType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_MissionResultsElementType (OSCTXT* pctxt,
   MissionResultsElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   OSRTDListNode* pnode2;
   int ll2 = 0;

   /* encode choice_list */

   pnode2 = pvalue->choice_list.tail;
   while (0 != pnode2) {
      ll = asn1E_MissionResultsElementType_element (pctxt, ((MissionResultsElementType_element*)pnode2->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;

      pnode2 = pnode2->prev;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|4, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   /* encode missionStartTime */

   if (pvalue->m.missionStartTimePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_DateTimeGroupElementType (pctxt, &pvalue->missionStartTime, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_MissionResultsElementType (OSCTXT* pctxt, 
   MissionResultsElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode missionStartTime */

   if (pvalue->m.missionStartTimePresent) {
      stat = XmlEnc_DateTimeGroupElementType (pctxt, &pvalue->missionStartTime
         , OSUTF8("MissionStartTime"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode choice_list */

   { OSRTDListNode* pnode = pvalue->choice_list.head;
   while (0 != pnode) {
      stat = XmlEnc_MissionResultsElementType_element (pctxt, 
         ((MissionResultsElementType_element*)pnode->data), 0, nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AvclBodyType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AvclBodyType (OSCTXT* pctxt,
   AvclBodyType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;
   int xx2;
   int ll2 = 0;

   /* encode missionResults */

   if (pvalue->m.missionResultsPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
         asn1E_MissionResultsElementType (pctxt, &pvalue->missionResults, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode eventLog */

   if (pvalue->m.eventLogPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
         asn1E_EventLogElementType (pctxt, &pvalue->eventLog, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode missionPreparation */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
      asn1E_MissionPreparationElementType (pctxt, &pvalue->missionPreparation, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode _order */

   for (xx2 = (pvalue->_order.n - 1); xx2 >= 0; xx2--)
   {
      if (!((pvalue->_order.elem[xx2] <= OSUINTCONST(2)))) {
         rtxErrAddStrParm (pctxt, "AvclBodyType._order.elem[xx2]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx2]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }

      ll = xe_uint8 (pctxt, &pvalue->_order.elem[xx2], ASN1IMPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);

      ll = xe_tag_len (pctxt, TM_UNIV|TM_PRIM|10, ll);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll2 += ll;
   }
   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll2);
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   else { ll1 += ll; ll2 = 0; }

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AvclBodyType (OSCTXT* pctxt, AvclBodyType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* encode elements in given order */

   { OSUINT32 xx1;
   for (xx1 = 0; xx1 < pvalue->_order.n; xx1++) {
      switch (pvalue->_order.elem[xx1]) {
      case 0:
         /* encode missionPreparation */

         stat = XmlEnc_MissionPreparationElementType (pctxt, &pvalue->
            missionPreparation, OSUTF8("MissionPreparation"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 1:
         /* encode eventLog */

         if (pvalue->m.eventLogPresent) {
            stat = XmlEnc_EventLogElementType (pctxt, &pvalue->eventLog
               , OSUTF8("EventLog"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      case 2:
         /* encode missionResults */

         if (pvalue->m.missionResultsPresent) {
            stat = XmlEnc_MissionResultsElementType (pctxt, &pvalue->
               missionResults, OSUTF8("MissionResults"), nsPrefix);
            if (stat != 0) return LOG_RTERR (pctxt, stat);
         }
         break;

      default:
         rtxErrAddStrParm (pctxt, "AvclBodyType._order.elem[xx1]");
         rtxErrAddIntParm (pctxt, (int)pvalue->_order.elem[xx1]);
         return LOG_RTERR (pctxt, RTERR_CONSVIO);
      }
   }}
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AVCL                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AVCL (OSCTXT* pctxt,
   AVCL *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode body */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
      asn1E_AvclBodyType (pctxt, &pvalue->body, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode head */

   if (pvalue->m.headPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_AvclHeadType (pctxt, &pvalue->head, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode version */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
      xe_real (pctxt, &pvalue->version, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode vehicleType */

   if (pvalue->m.vehicleTypePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_utf8str (pctxt, pvalue->vehicleType, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode vehicleID */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_uint16 (pctxt, &pvalue->vehicleID, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode date */

   if (pvalue->m.datePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_charstr (pctxt, pvalue->date, ASN1IMPL, TM_UNIV|TM_PRIM|26));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AVCL (OSCTXT* pctxt, AVCL* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.datePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" date=\""), 7);

      stat = rtXmlEncUTF8Str (pctxt, (const OSUTF8CHAR*)pvalue->date, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   stat = rtXmlEncUIntAttr
      (pctxt, pvalue->vehicleID, OSUTF8("vehicleID"), 9);

   if (pvalue->m.vehicleTypePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" vehicleType=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->vehicleType, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" version=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->version, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode head */

   if (pvalue->m.headPresent) {
      stat = XmlEnc_AvclHeadType (pctxt, &pvalue->head
         , OSUTF8("head"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode body */

   stat = XmlEnc_AvclBodyType (pctxt, &pvalue->body
      , OSUTF8("body"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AvclMessageListBodyType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AvclMessageListBodyType (OSCTXT* pctxt,
   AvclMessageListBodyType *pvalue, ASN1TagType tagging)
{
   OSRTDListNode* pnode1;
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   if (!(pvalue->count >= 1U)) {
      rtxErrAddStrParm (pctxt, "AvclMessageListBodyType.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   pnode1 = pvalue->tail;
   while (0 != pnode1) {
      ll = asn1E_AvclMessageType (pctxt, ((AvclMessageType*)pnode1->data), ASN1EXPL);
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;

      pnode1 = pnode1->prev;
   }
   ll1 = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0, ll1);
   if (ll1 < 0) return LOG_RTERR (pctxt, ll1);

   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AvclMessageListBodyType (OSCTXT* pctxt, 
   AvclMessageListBodyType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (!(pvalue->count >= 1U)) {
      rtxErrAddStrParm (pctxt, "AvclMessageListBodyType.count");
      rtxErrAddIntParm (pctxt, (int)pvalue->count);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   if (elemName != 0) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   { OSRTDListNode* pnode = pvalue->head;
   while (0 != pnode) {
      stat = XmlEnc_AvclMessageType (pctxt, ((AvclMessageType*)pnode->data)
         , OSUTF8("AVCLMessage"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
      pnode = pnode->next;
   }}
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AVCLMessageList                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_AVCLMessageList (OSCTXT* pctxt,
   AVCLMessageList *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode body */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|8,
      asn1E_AvclMessageListBodyType (pctxt, &pvalue->body, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode head */

   if (pvalue->m.headPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|7,
         asn1E_AvclHeadType (pctxt, &pvalue->head, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode version */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|6,
      xe_real (pctxt, &pvalue->version, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode vehicleType */

   if (pvalue->m.vehicleTypePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|5,
         xe_utf8str (pctxt, pvalue->vehicleType, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode vehicleID */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|4,
      xe_uint16 (pctxt, &pvalue->vehicleID, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode date */

   if (pvalue->m.datePresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_charstr (pctxt, pvalue->date, ASN1IMPL, TM_UNIV|TM_PRIM|26));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_AVCLMessageList (OSCTXT* pctxt, AVCLMessageList* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.datePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" date=\""), 7);

      stat = rtXmlEncUTF8Str (pctxt, (const OSUTF8CHAR*)pvalue->date, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   stat = rtXmlEncUIntAttr
      (pctxt, pvalue->vehicleID, OSUTF8("vehicleID"), 9);

   if (pvalue->m.vehicleTypePresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" vehicleType=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->vehicleType, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" version=\""), 10);

   stat = rtXmlEncDouble (pctxt, pvalue->version, 0, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   /* encode head */

   if (pvalue->m.headPresent) {
      stat = XmlEnc_AvclHeadType (pctxt, &pvalue->head
         , OSUTF8("head"), nsPrefix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }
   /* encode body */

   stat = XmlEnc_AvclMessageListBodyType (pctxt, &pvalue->body
      , OSUTF8("body"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonNegativeScalarElementType                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_NonNegativeScalarElementType (OSCTXT* pctxt,
   NonNegativeScalarElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      asn1E_NonNegativeScalarType (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_NonNegativeScalarElementType (OSCTXT* pctxt, 
   NonNegativeScalarElementType* pvalue, const OSUTF8CHAR* elemName, 
   const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IntegerElementType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_IntegerElementType (OSCTXT* pctxt,
   IntegerElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_integer (pctxt, &pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_IntegerElementType (OSCTXT* pctxt, IntegerElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   stat = rtXmlEncIntAttr
      (pctxt, pvalue->value, OSUTF8("value"), 5);

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TokenElementType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TokenElementType (OSCTXT* pctxt,
   TokenElementType *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   /* encode value */

   ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|3,
      xe_utf8str (pctxt, pvalue->value, ASN1IMPL));
   if (ll < 0) return LOG_RTERR (pctxt, ll);
   ll1 += ll;

   /* encode timeStamp */

   if (pvalue->m.timeStampPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|2,
         asn1E_NonNegativeScalarType (pctxt, &pvalue->timeStamp, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode id */

   if (pvalue->m.idPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|1,
         xe_utf8str (pctxt, pvalue->id, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   /* encode description */

   if (pvalue->m.descriptionPresent) {
      ll = xe_tag_len (pctxt, TM_CTXT|TM_PRIM|0,
         xe_utf8str (pctxt, pvalue->description, ASN1IMPL));
      if (ll < 0) return LOG_RTERR (pctxt, ll);
      ll1 += ll;
   }
   ll0 += ll1;

   if (tagging == ASN1EXPL)
      ll0 = xe_tag_len (pctxt, TM_UNIV|TM_CONS|16, ll0);

   return (ll0);
}

int XmlEnc_TokenElementType (OSCTXT* pctxt, TokenElementType* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, FALSE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* add attributes */

   if (pvalue->m.descriptionPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" description=\""), 14);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->description, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.idPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" id=\""), 5);

      stat = rtXmlEncUTF8Str (pctxt, pvalue->id, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '\"');
   }

   if (pvalue->m.timeStampPresent) {
      OSRTSAFEMEMCPY (pctxt, OSUTF8(" timeStamp=\""), 12);

      stat = XmlEnc_NonNegativeScalarType (pctxt, pvalue->timeStamp, 0, 0);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      OSRTSAFEPUTCHAR (pctxt, '"');
   }

   OSRTSAFEMEMCPY (pctxt, OSUTF8(" value=\""), 8);

   stat = rtXmlEncUTF8Str (pctxt, pvalue->value, 0, 0);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   OSRTSAFEPUTCHAR (pctxt, '\"');

   OSRTSAFEPUTCHAR (pctxt, '>');
   pctxt->flags &= ~OSTERMSTART;
   pctxt->state = OSXMLSTART;

   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TelemetryElement                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1E_TelemetryElement (OSCTXT* pctxt,
   TelemetryElement *pvalue, ASN1TagType tagging)
{
   int ll;
   int ll0 = 0;
   int ll1 = 0;

   ll0 = 0;
   switch (pvalue->t)
   {
      case 1:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|0,
            asn1E_UuvTelemetryElementType (pctxt, pvalue->u.uUVTelemetry, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 2:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|1,
            asn1E_UsvTelemetryElementType (pctxt, pvalue->u.uSVTelemetry, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 3:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|2,
            asn1E_UgvTelemetryElementType (pctxt, pvalue->u.uGVTelemetry, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      case 4:
         ll = xe_tag_len (pctxt, TM_CTXT|TM_CONS|3,
            asn1E_UavTelemetryElementType (pctxt, pvalue->u.uAVTelemetry, ASN1IMPL));
         if (ll < 0) return LOG_RTERR (pctxt, ll);
         ll1 += ll;
         break;

      default:
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }
   ll0 += ll1;

   return (ll0);
}

int XmlEnc_TelemetryElement (OSCTXT* pctxt, TelemetryElement* pvalue, 
   const OSUTF8CHAR* elemName, const OSUTF8CHAR* nsPrefix)
{
   int stat = 0;

   if (0 != elemName) {
      stat = rtXmlEncStartElement (pctxt, elemName, nsPrefix, TRUE);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   switch (pvalue->t)
   {
      case 1:
         /* encode uUVTelemetry */

         stat = XmlEnc_UuvTelemetryElementType (pctxt, pvalue->u.uUVTelemetry
            , OSUTF8("UUVTelemetry"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 2:
         /* encode uSVTelemetry */

         stat = XmlEnc_UsvTelemetryElementType (pctxt, pvalue->u.uSVTelemetry
            , OSUTF8("USVTelemetry"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 3:
         /* encode uGVTelemetry */

         stat = XmlEnc_UgvTelemetryElementType (pctxt, pvalue->u.uGVTelemetry
            , OSUTF8("UGVTelemetry"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      case 4:
         /* encode uAVTelemetry */

         stat = XmlEnc_UavTelemetryElementType (pctxt, pvalue->u.uAVTelemetry
            , OSUTF8("UAVTelemetry"), nsPrefix);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;

      default: {
         char buf[40];
         os_snprintf (buf, 40, "%d", pvalue->t);
         return LOG_RTERRNEW1 (pctxt, RTERR_INVOPT, 
            rtxErrAddStrParm (pctxt, buf));
      }
   }
   stat = rtXmlEncEndElement (pctxt, elemName, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlEnc_AVCLMessage_PDU (OSCTXT* pctxt, AVCLMessage* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("jaxb"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb"), FALSE);

   rtXmlNSSetNamespace (pctxt, OSUTF8("xjc"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb/xjc"), FALSE);

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("AVCLMessage"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_AVCLMessage (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("AVCLMessage"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_NonNegativeIntType_PDU (OSCTXT* pctxt, NonNegativeIntType value)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("jaxb"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb"), FALSE);

   rtXmlNSSetNamespace (pctxt, OSUTF8("xjc"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb/xjc"), FALSE);

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("nonNegativeIntType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_NonNegativeIntType (pctxt, value, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("nonNegativeIntType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_AVCL_PDU (OSCTXT* pctxt, AVCL* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("jaxb"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb"), FALSE);

   rtXmlNSSetNamespace (pctxt, OSUTF8("xjc"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb/xjc"), FALSE);

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("AVCL"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_AVCL (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("AVCL"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_AVCLMessageList_PDU (OSCTXT* pctxt, AVCLMessageList* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("jaxb"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb"), FALSE);

   rtXmlNSSetNamespace (pctxt, OSUTF8("xjc"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb/xjc"), FALSE);

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("AVCLMessageList"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_AVCLMessageList (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("AVCLMessageList"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_NonNegativeScalarElementType_PDU (OSCTXT* pctxt, NonNegativeScalarElementType* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("jaxb"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb"), FALSE);

   rtXmlNSSetNamespace (pctxt, OSUTF8("xjc"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb/xjc"), FALSE);

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("nonNegativeScalarElementType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_NonNegativeScalarElementType (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("nonNegativeScalarElementType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_IntegerElementType_PDU (OSCTXT* pctxt, IntegerElementType* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("jaxb"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb"), FALSE);

   rtXmlNSSetNamespace (pctxt, OSUTF8("xjc"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb/xjc"), FALSE);

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("integerElementType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_IntegerElementType (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("integerElementType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_TokenElementType_PDU (OSCTXT* pctxt, TokenElementType* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("jaxb"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb"), FALSE);

   rtXmlNSSetNamespace (pctxt, OSUTF8("xjc"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb/xjc"), FALSE);

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("tokenElementType"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_TokenElementType (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("tokenElementType"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
int XmlEnc_TelemetryElement_PDU (OSCTXT* pctxt, TelemetryElement* pvalue)
{
   int stat;
   const OSUTF8CHAR* nsPrefix = 0;

   rtXmlNSSetNamespace (pctxt, OSUTF8("jaxb"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb"), FALSE);

   rtXmlNSSetNamespace (pctxt, OSUTF8("xjc"), 
      OSUTF8("http://java.sun.com/xml/ns/jaxb/xjc"), FALSE);

   stat = rtXmlEncStartDocument (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncStartElement (pctxt, OSUTF8("telemetryElement"), nsPrefix, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncNSAttrs (pctxt);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncXSIAttrs (pctxt, FALSE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = XmlEnc_TelemetryElement (pctxt, pvalue, 0, nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = rtXmlEncEndElement (pctxt, OSUTF8("telemetryElement"), nsPrefix);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return stat;
}
