/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0B, Date: 18-Oct-2006.
 */
#include "AVCL.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  NonNegativeScalarType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NonNegativeScalarType (OSCTXT* pctxt, 
   NonNegativeScalarType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_NonNegativeScalarType (OSCTXT* pctxt, NonNegativeScalarType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDouble (pctxt, pvalue, -1, -1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AvclMessageType_transportStatus                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AvclMessageType_transportStatus (OSCTXT* pctxt, 
   AvclMessageType_transportStatus *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_AvclMessageType_transportStatus (OSCTXT* pctxt, 
   AvclMessageType_transportStatus* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = AvclMessageType_transportStatus_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MetaDataType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MetaDataType (OSCTXT* pctxt, MetaDataType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode content */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->content, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.contentPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_MetaDataType (OSCTXT* pctxt, MetaDataType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("content"), 7}, 0 },
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("name"), 4}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* content */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->content);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.contentPresent = TRUE;
            break;

         case 1: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 2: /* name */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "MetaDataType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "MetaDataType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PriorityType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PriorityType (OSCTXT* pctxt, PriorityType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_uint8 (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_PriorityType (OSCTXT* pctxt, PriorityType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecUInt8 (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PriorityElementType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PriorityElementType (OSCTXT* pctxt, 
   PriorityElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PriorityType (pctxt, 
               &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_PriorityElementType (OSCTXT* pctxt, PriorityElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* value */
            stat = XmlDec_PriorityType (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "PriorityElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "PriorityElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonNegativeIntegerElementType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NonNegativeIntegerElementType (OSCTXT* pctxt, 
   NonNegativeIntegerElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_uint16 (pctxt, &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_NonNegativeIntegerElementType (OSCTXT* pctxt, 
   NonNegativeIntegerElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* value */
            stat = rtXmlpDecUInt16 (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "NonNegativeIntegerElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "NonNegativeIntegerElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AcknowledgeType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AcknowledgeType (OSCTXT* pctxt, AcknowledgeType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 4)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_AcknowledgeType (OSCTXT* pctxt, AcknowledgeType* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = AcknowledgeType_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AcknowledgeElementType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AcknowledgeElementType (OSCTXT* pctxt, 
   AcknowledgeElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AcknowledgeType (pctxt, 
               &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AcknowledgeElementType (OSCTXT* pctxt, 
   AcknowledgeElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* value */
            stat = XmlDec_AcknowledgeType (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "AcknowledgeElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "AcknowledgeElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AvclMessageHeadType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AvclMessageHeadType (OSCTXT* pctxt, 
   AvclMessageHeadType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode meta_list */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               MetaDataType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->meta_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, MetaDataType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_MetaDataType (pdata2);

                  stat = asn1D_MetaDataType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->meta_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode priority */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PriorityElementType (pctxt, 
               &pvalue->priority, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.priorityPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 2:
         /* decode sender */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeIntegerElementType (pctxt, 
               &pvalue->sender, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode recipient_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               NonNegativeIntegerElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->recipient_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, NonNegativeIntegerElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_NonNegativeIntegerElementType (pdata2);

                  stat = asn1D_NonNegativeIntegerElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->recipient_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode acknowledge */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AcknowledgeElementType (pctxt, 
               &pvalue->acknowledge, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.acknowledgePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AvclMessageHeadType (OSCTXT* pctxt, AvclMessageHeadType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("meta"), 4}, 0}, 0 },
      {{{OSUTF8("Priority"), 8}, 0}, 1 },
      {{{OSUTF8("Sender"), 6}, 0}, 2 },
      {{{OSUTF8("Recipient"), 9}, 0}, 3 },
      {{{OSUTF8("Acknowledge"), 11}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}, {3, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         MetaDataType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, MetaDataType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_MetaDataType (pdata1);

            stat = XmlDec_MetaDataType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->meta_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 1: { /* Priority */
         stat = XmlDec_PriorityElementType (pctxt, &pvalue->priority);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.priorityPresent = TRUE;
         break;
      }
      case 2: { /* Sender */
         stat = XmlDec_NonNegativeIntegerElementType (pctxt, &pvalue->sender);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: {
         NonNegativeIntegerElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, NonNegativeIntegerElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_NonNegativeIntegerElementType (pdata1);

            stat = XmlDec_NonNegativeIntegerElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->recipient_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 3, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 4: { /* Acknowledge */
         stat = XmlDec_AcknowledgeElementType (pctxt, &pvalue->acknowledge);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.acknowledgePresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LatitudeType                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LatitudeType (OSCTXT* pctxt, LatitudeType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_LatitudeType (OSCTXT* pctxt, LatitudeType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDouble (pctxt, pvalue, -1, -1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LongitudeType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LongitudeType (OSCTXT* pctxt, LongitudeType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_LongitudeType (OSCTXT* pctxt, LongitudeType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDouble (pctxt, pvalue, -1, -1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LatitudeLongitudeElementType                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LatitudeLongitudeElementType (OSCTXT* pctxt, 
   LatitudeLongitudeElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode latitude */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_LatitudeType (pctxt, 
               &pvalue->latitude, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode longitude */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_LongitudeType (pctxt, 
               &pvalue->longitude, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_LatitudeLongitudeElementType (OSCTXT* pctxt, 
   LatitudeLongitudeElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("latitude"), 8}, 0 },
         { {OSUTF8("longitude"), 9}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* latitude */
            stat = XmlDec_LatitudeType (pctxt, &pvalue->latitude);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 3: /* longitude */
            stat = XmlDec_LongitudeType (pctxt, &pvalue->longitude);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 4: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "LatitudeLongitudeElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "LatitudeLongitudeElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PositiveScalarType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PositiveScalarType (OSCTXT* pctxt, 
   PositiveScalarType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_PositiveScalarType (OSCTXT* pctxt, PositiveScalarType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDouble (pctxt, pvalue, -1, -1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GeoOriginElementType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_GeoOriginElementType (OSCTXT* pctxt, 
   GeoOriginElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode latitude */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_LatitudeType (pctxt, 
               &pvalue->latitude, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode longitude */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_LongitudeType (pctxt, 
               &pvalue->longitude, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode radiusOfInterest */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarType (pctxt, 
               &pvalue->radiusOfInterest, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.radiusOfInterestPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_PRIM|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_GeoOriginElementType (OSCTXT* pctxt, GeoOriginElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("latitude"), 8}, 0 },
         { {OSUTF8("longitude"), 9}, 0 },
         { {OSUTF8("radiusOfInterest"), 16}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 6, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* latitude */
            stat = XmlDec_LatitudeType (pctxt, &pvalue->latitude);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 3: /* longitude */
            stat = XmlDec_LongitudeType (pctxt, &pvalue->longitude);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 4: /* radiusOfInterest */
            stat = XmlDec_PositiveScalarType (pctxt, &pvalue->radiusOfInterest
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.radiusOfInterestPresent = TRUE;
            break;

         case 5: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "GeoOriginElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "GeoOriginElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LatitudeLongitudeElementType_derivations                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LatitudeLongitudeElementType_derivations (OSCTXT* pctxt, 
   LatitudeLongitudeElementType_derivations *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.latitudeLongitudeElementType
             = rtxMemAllocType (pctxt, LatitudeLongitudeElementType);

         if (pvalue->u.latitudeLongitudeElementType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_LatitudeLongitudeElementType (pvalue->u.latitudeLongitudeElementType);
         stat = asn1D_LatitudeLongitudeElementType (pctxt, 
            pvalue->u.latitudeLongitudeElementType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.geoOriginElementType
             = rtxMemAllocType (pctxt, GeoOriginElementType);

         if (pvalue->u.geoOriginElementType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_GeoOriginElementType (pvalue->u.geoOriginElementType);
         stat = asn1D_GeoOriginElementType (pctxt, 
            pvalue->u.geoOriginElementType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_LatitudeLongitudeElementType_derivations (OSCTXT* pctxt, 
   LatitudeLongitudeElementType_derivations* pvalue)
{
   const OSUTF8CHAR* xsiType = 0;
   int stat = 0;

   /* decode xsi:type attribute */
   if (rtXmlpHasAttributes (pctxt)) {
      OSUINT32 i, nAttrs = 0;
      OSXMLNameFragments attrName;

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) == 0 &&
             rtXmlpDecXSITypeAttr (pctxt, &attrName, &xsiType) == 0) break;
      }
   }

   /* decode content */
   if (!OS_ISEMPTY (xsiType)) {
      xsiType = rtXmlDecQName (pctxt, xsiType, 0);
   }
   if (OS_ISEMPTY (xsiType)) {
      pvalue->t = 1;
      pvalue->u.latitudeLongitudeElementType
          = rtxMemAllocType (pctxt, LatitudeLongitudeElementType);

      if (pvalue->u.latitudeLongitudeElementType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_LatitudeLongitudeElementType (pvalue->
         u.latitudeLongitudeElementType);

      stat = XmlDec_LatitudeLongitudeElementType (pctxt, pvalue->
         u.latitudeLongitudeElementType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("LatitudeLongitudeElementType")))
   {
      pvalue->t = 1;
      pvalue->u.latitudeLongitudeElementType
          = rtxMemAllocType (pctxt, LatitudeLongitudeElementType);

      if (pvalue->u.latitudeLongitudeElementType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_LatitudeLongitudeElementType (pvalue->
         u.latitudeLongitudeElementType);

      stat = XmlDec_LatitudeLongitudeElementType (pctxt, pvalue->
         u.latitudeLongitudeElementType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("GeoOriginElementType")))
   {
      pvalue->t = 2;
      pvalue->u.geoOriginElementType
          = rtxMemAllocType (pctxt, GeoOriginElementType);

      if (pvalue->u.geoOriginElementType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_GeoOriginElementType (pvalue->u.geoOriginElementType);

      stat = XmlDec_GeoOriginElementType (pctxt, pvalue->u.geoOriginElementType
         );
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  XyElementType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XyElementType (OSCTXT* pctxt, XyElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode x */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->x, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode y */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->y, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_XyElementType (OSCTXT* pctxt, XyElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("x"), 1}, 0 },
         { {OSUTF8("y"), 1}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* x */
            stat = rtXmlpDecDouble (pctxt, &pvalue->x, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 4: /* y */
            stat = rtXmlpDecDouble (pctxt, &pvalue->y, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "XyElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "XyElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PointListElements                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PointListElements (OSCTXT* pctxt, PointListElements *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.latitudeLongitude_list
             = rtxMemAllocType (pctxt, OSRTDList);

         if (pvalue->u.latitudeLongitude_list == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         rtxDListFastInit (pvalue->u.latitudeLongitude_list);
         /* decode inline SEQUENCE OF type */
         {
            int stat = 0;
            LatitudeLongitudeElementType_derivations* pdata2;
            OSRTDListNode* pnode;
            ASN1CCB ccb;

            /* decode SEQUENCE OF or SET OF */

            rtxDListInit (pvalue->u.latitudeLongitude_list);

            ccb.len = length;
            ccb.ptr = OSRTBUFPTR(pctxt);

            while (!XD_CHKEND (pctxt, &ccb))
            {
               rtxDListAllocNodeAndData (pctxt, LatitudeLongitudeElementType_derivations, &pnode, &pdata2);

               if (pnode == NULL)
                  return LOG_RTERR (pctxt, RTERR_NOMEM);

               asn1Init_LatitudeLongitudeElementType_derivations (pdata2);

               stat = asn1D_LatitudeLongitudeElementType_derivations (pctxt, 
                  pdata2, ASN1EXPL, length);
               if (stat != 0) return LOG_RTERR (pctxt, stat);

               rtxDListAppendNode (pvalue->u.latitudeLongitude_list, pnode);
            }

            if (!(pvalue->u.latitudeLongitude_list->count >= 1U)) {
               rtxErrAddStrParm (pctxt, "PointListElements.u.latitudeLongitude_list.count");
               rtxErrAddIntParm (pctxt, (int)pvalue->u.latitudeLongitude_list->count);
               return LOG_RTERR (pctxt, RTERR_CONSVIO);
            }

         }
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.xYPosition_list = rtxMemAllocType (pctxt, OSRTDList);

         if (pvalue->u.xYPosition_list == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         rtxDListFastInit (pvalue->u.xYPosition_list);
         /* decode inline SEQUENCE OF type */
         {
            int stat = 0;
            XyElementType* pdata2;
            OSRTDListNode* pnode;
            ASN1CCB ccb;

            /* decode SEQUENCE OF or SET OF */

            rtxDListInit (pvalue->u.xYPosition_list);

            ccb.len = length;
            ccb.ptr = OSRTBUFPTR(pctxt);

            while (!XD_CHKEND (pctxt, &ccb))
            {
               rtxDListAllocNodeAndData (pctxt, XyElementType, &pnode, &pdata2);

               if (pnode == NULL)
                  return LOG_RTERR (pctxt, RTERR_NOMEM);

               asn1Init_XyElementType (pdata2);

               stat = asn1D_XyElementType (pctxt, 
                  pdata2, ASN1EXPL, length);
               if (stat != 0) return LOG_RTERR (pctxt, stat);

               rtxDListAppendNode (pvalue->u.xYPosition_list, pnode);
            }

            if (!(pvalue->u.xYPosition_list->count >= 1U)) {
               rtxErrAddStrParm (pctxt, "PointListElements.u.xYPosition_list.count");
               rtxErrAddIntParm (pctxt, (int)pvalue->u.xYPosition_list->count);
               return LOG_RTERR (pctxt, RTERR_CONSVIO);
            }

         }
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_PointListElements (OSCTXT* pctxt, PointListElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 1 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: {
      LatitudeLongitudeElementType_derivations* pdata1;

      pvalue->u.latitudeLongitude_list = rtxMemAllocType (pctxt, OSRTDList);
      rtxDListInit (pvalue->u.latitudeLongitude_list);

      do {
         pdata1
             = rtxMemAllocType (pctxt, LatitudeLongitudeElementType_derivations);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_LatitudeLongitudeElementType_derivations (pdata1);

         stat = XmlDec_LatitudeLongitudeElementType_derivations (pctxt, pdata1
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue->u.latitudeLongitude_list
            , (void*)pdata1);

         stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
         if (stat < 0 && stat != RTERR_UNEXPELEM)
            return LOG_RTERR (pctxt, stat);
      }
      while (stat == 0);

      rtXmlpMarkLastEventActive (pctxt);
      stat = 0;
      break;
   }
   case 1: {
      XyElementType* pdata1;

      pvalue->u.xYPosition_list = rtxMemAllocType (pctxt, OSRTDList);
      rtxDListInit (pvalue->u.xYPosition_list);

      do {
         pdata1 = rtxMemAllocType (pctxt, XyElementType);

         if (pdata1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_XyElementType (pdata1);

         stat = XmlDec_XyElementType (pctxt, pdata1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         rtxDListAppend (pctxt, pvalue->u.xYPosition_list, (void*)pdata1);

         stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
         if (stat < 0 && stat != RTERR_UNEXPELEM)
            return LOG_RTERR (pctxt, stat);
      }
      while (stat == 1);

      rtXmlpMarkLastEventActive (pctxt);
      stat = 0;
      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  WaypointListType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_WaypointListType (OSCTXT* pctxt, WaypointListType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PointListElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_WaypointListType (OSCTXT* pctxt, WaypointListType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "WaypointListType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "WaypointListType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_PointListElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TurnDirectionType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TurnDirectionType (OSCTXT* pctxt, TurnDirectionType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 3)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_TurnDirectionType (OSCTXT* pctxt, TurnDirectionType* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = TurnDirectionType_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HeadingType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_HeadingType (OSCTXT* pctxt, HeadingType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_HeadingType (OSCTXT* pctxt, HeadingType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDouble (pctxt, pvalue, -1, -1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PositiveIntType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PositiveIntType (OSCTXT* pctxt, PositiveIntType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_integer (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue >= 0)) {
      rtxErrAddStrParm (pctxt, "PositiveIntType");
      rtxErrAddIntParm (pctxt, *pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

int XmlDec_PositiveIntType (OSCTXT* pctxt, PositiveIntType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecInt (pctxt, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue >= 0)) {
      rtxErrAddStrParm (pctxt, "PositiveIntType");
      rtxErrAddIntParm (pctxt, *pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HorizontalPositionElements                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_HorizontalPositionElements (OSCTXT* pctxt, 
   HorizontalPositionElements *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.latitudeLongitude
             = rtxMemAllocType (pctxt, LatitudeLongitudeElementType_derivations);

         if (pvalue->u.latitudeLongitude == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_LatitudeLongitudeElementType_derivations (pvalue->u.latitudeLongitude);
         stat = asn1D_LatitudeLongitudeElementType_derivations (pctxt, 
            pvalue->u.latitudeLongitude, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.xYPosition = rtxMemAllocType (pctxt, XyElementType);

         if (pvalue->u.xYPosition == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_XyElementType (pvalue->u.xYPosition);
         stat = asn1D_XyElementType (pctxt, 
            pvalue->u.xYPosition, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.relativeXYPosition
             = rtxMemAllocType (pctxt, XyElementType);

         if (pvalue->u.relativeXYPosition == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_XyElementType (pvalue->u.relativeXYPosition);
         stat = asn1D_XyElementType (pctxt, 
            pvalue->u.relativeXYPosition, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_HorizontalPositionElements (OSCTXT* pctxt, 
   HorizontalPositionElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 1 },
      {{{OSUTF8("RelativeXYPosition"), 18}, 0}, 2 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 3, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* LatitudeLongitude */
      pvalue->u.latitudeLongitude
          = rtxMemAllocType (pctxt, LatitudeLongitudeElementType_derivations);

      if (pvalue->u.latitudeLongitude == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_LatitudeLongitudeElementType_derivations (pvalue->
         u.latitudeLongitude);

      stat = XmlDec_LatitudeLongitudeElementType_derivations (pctxt, pvalue->
         u.latitudeLongitude);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* XYPosition */
      pvalue->u.xYPosition = rtxMemAllocType (pctxt, XyElementType);

      if (pvalue->u.xYPosition == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_XyElementType (pvalue->u.xYPosition);

      stat = XmlDec_XyElementType (pctxt, pvalue->u.xYPosition);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* RelativeXYPosition */
      pvalue->u.relativeXYPosition = rtxMemAllocType (pctxt, XyElementType);

      if (pvalue->u.relativeXYPosition == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_XyElementType (pvalue->u.relativeXYPosition);

      stat = XmlDec_XyElementType (pctxt, pvalue->u.relativeXYPosition);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HorizontalPositionElementType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_HorizontalPositionElementType (OSCTXT* pctxt, 
   HorizontalPositionElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_HorizontalPositionElementType (OSCTXT* pctxt, 
   HorizontalPositionElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "HorizontalPositionElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "HorizontalPositionElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 },
      {{{OSUTF8("RelativeXYPosition"), 18}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}, {3, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_HorizontalPositionElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ParallelTrackType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ParallelTrackType (OSCTXT* pctxt, ParallelTrackType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode firstTurn */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TurnDirectionType (pctxt, 
               &pvalue->firstTurn, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode orientation */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HeadingType (pctxt, 
               &pvalue->orientation, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode trackCount */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveIntType (pctxt, 
               &pvalue->trackCount, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode trackLength */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarType (pctxt, 
               &pvalue->trackLength, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode trackSpacing */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarType (pctxt, 
               &pvalue->trackSpacing, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode startPoint */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HorizontalPositionElementType (pctxt, 
               &pvalue->startPoint, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|8):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 6) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_ParallelTrackType (OSCTXT* pctxt, ParallelTrackType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("firstTurn"), 9}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("orientation"), 11}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("trackCount"), 10}, 0 },
         { {OSUTF8("trackLength"), 11}, 0 },
         { {OSUTF8("trackSpacing"), 12}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 8, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* firstTurn */
            stat = XmlDec_TurnDirectionType (pctxt, &pvalue->firstTurn);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 2: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 3: /* orientation */
            stat = XmlDec_HeadingType (pctxt, &pvalue->orientation);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 4: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 5: /* trackCount */
            stat = XmlDec_PositiveIntType (pctxt, &pvalue->trackCount);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 6: /* trackLength */
            stat = XmlDec_PositiveScalarType (pctxt, &pvalue->trackLength);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 7: /* trackSpacing */
            stat = XmlDec_PositiveScalarType (pctxt, &pvalue->trackSpacing);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "ParallelTrackType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "ParallelTrackType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("StartPoint"), 10}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* StartPoint */
         stat = XmlDec_HorizontalPositionElementType (pctxt, &pvalue->
            startPoint);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SectorPatternType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SectorPatternType (OSCTXT* pctxt, SectorPatternType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode firstTurn */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TurnDirectionType (pctxt, 
               &pvalue->firstTurn, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 2:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode orientation */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HeadingType (pctxt, 
               &pvalue->orientation, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode radius */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarType (pctxt, 
               &pvalue->radius, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode sectorCount */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveIntType (pctxt, 
               &pvalue->sectorCount, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode sectorSize */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarType (pctxt, 
               &pvalue->sectorSize, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 8:
         /* decode startPoint */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HorizontalPositionElementType (pctxt, 
               &pvalue->startPoint, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_PRIM|7):
         case (TM_CTXT|TM_CONS|8):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 6) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SectorPatternType (OSCTXT* pctxt, SectorPatternType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("firstTurn"), 9}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("orientation"), 11}, 0 },
         { {OSUTF8("radius"), 6}, 0 },
         { {OSUTF8("sectorCount"), 11}, 0 },
         { {OSUTF8("sectorSize"), 10}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 8, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* firstTurn */
            stat = XmlDec_TurnDirectionType (pctxt, &pvalue->firstTurn);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 2: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 3: /* orientation */
            stat = XmlDec_HeadingType (pctxt, &pvalue->orientation);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 4: /* radius */
            stat = XmlDec_PositiveScalarType (pctxt, &pvalue->radius);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 5: /* sectorCount */
            stat = XmlDec_PositiveIntType (pctxt, &pvalue->sectorCount);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 6: /* sectorSize */
            stat = XmlDec_PositiveScalarType (pctxt, &pvalue->sectorSize);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 7: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SectorPatternType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SectorPatternType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("StartPoint"), 10}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* StartPoint */
         stat = XmlDec_HorizontalPositionElementType (pctxt, &pvalue->
            startPoint);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExpandingSquareType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ExpandingSquareType (OSCTXT* pctxt, 
   ExpandingSquareType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode orientation */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HeadingType (pctxt, 
               &pvalue->orientation, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode trackCount */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveIntType (pctxt, 
               &pvalue->trackCount, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode trackSpacing */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarType (pctxt, 
               &pvalue->trackSpacing, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode turnDirection */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TurnDirectionType (pctxt, 
               &pvalue->turnDirection, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode startPoint */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HorizontalPositionElementType (pctxt, 
               &pvalue->startPoint, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_PRIM|6):
         case (TM_CTXT|TM_CONS|7):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 5) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_ExpandingSquareType (OSCTXT* pctxt, ExpandingSquareType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("orientation"), 11}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("trackCount"), 10}, 0 },
         { {OSUTF8("trackSpacing"), 12}, 0 },
         { {OSUTF8("turnDirection"), 13}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 7, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* orientation */
            stat = XmlDec_HeadingType (pctxt, &pvalue->orientation);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 3: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 4: /* trackCount */
            stat = XmlDec_PositiveIntType (pctxt, &pvalue->trackCount);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 5: /* trackSpacing */
            stat = XmlDec_PositiveScalarType (pctxt, &pvalue->trackSpacing);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 6: /* turnDirection */
            stat = XmlDec_TurnDirectionType (pctxt, &pvalue->turnDirection);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "ExpandingSquareType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "ExpandingSquareType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("StartPoint"), 10}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* StartPoint */
         stat = XmlDec_HorizontalPositionElementType (pctxt, &pvalue->
            startPoint);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CompositeWaypointElements                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CompositeWaypointElements (OSCTXT* pctxt, 
   CompositeWaypointElements *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.waypointList = rtxMemAllocType (pctxt, WaypointListType);

         if (pvalue->u.waypointList == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_WaypointListType (pvalue->u.waypointList);
         stat = asn1D_WaypointListType (pctxt, 
            pvalue->u.waypointList, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.parallelTrack = rtxMemAllocType (pctxt, ParallelTrackType);

         if (pvalue->u.parallelTrack == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_ParallelTrackType (pvalue->u.parallelTrack);
         stat = asn1D_ParallelTrackType (pctxt, 
            pvalue->u.parallelTrack, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.sectorPattern = rtxMemAllocType (pctxt, SectorPatternType);

         if (pvalue->u.sectorPattern == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SectorPatternType (pvalue->u.sectorPattern);
         stat = asn1D_SectorPatternType (pctxt, 
            pvalue->u.sectorPattern, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.expandingSquare
             = rtxMemAllocType (pctxt, ExpandingSquareType);

         if (pvalue->u.expandingSquare == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_ExpandingSquareType (pvalue->u.expandingSquare);
         stat = asn1D_ExpandingSquareType (pctxt, 
            pvalue->u.expandingSquare, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_CompositeWaypointElements (OSCTXT* pctxt, 
   CompositeWaypointElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("WaypointList"), 12}, 0}, 0 },
      {{{OSUTF8("ParallelTrack"), 13}, 0}, 1 },
      {{{OSUTF8("SectorPattern"), 13}, 0}, 2 },
      {{{OSUTF8("ExpandingSquare"), 15}, 0}, 3 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 4, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* WaypointList */
      pvalue->u.waypointList = rtxMemAllocType (pctxt, WaypointListType);

      if (pvalue->u.waypointList == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_WaypointListType (pvalue->u.waypointList);

      stat = XmlDec_WaypointListType (pctxt, pvalue->u.waypointList);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* ParallelTrack */
      pvalue->u.parallelTrack = rtxMemAllocType (pctxt, ParallelTrackType);

      if (pvalue->u.parallelTrack == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_ParallelTrackType (pvalue->u.parallelTrack);

      stat = XmlDec_ParallelTrackType (pctxt, pvalue->u.parallelTrack);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* SectorPattern */
      pvalue->u.sectorPattern = rtxMemAllocType (pctxt, SectorPatternType);

      if (pvalue->u.sectorPattern == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SectorPatternType (pvalue->u.sectorPattern);

      stat = XmlDec_SectorPatternType (pctxt, pvalue->u.sectorPattern);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* ExpandingSquare */
      pvalue->u.expandingSquare
          = rtxMemAllocType (pctxt, ExpandingSquareType);

      if (pvalue->u.expandingSquare == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_ExpandingSquareType (pvalue->u.expandingSquare);

      stat = XmlDec_ExpandingSquareType (pctxt, pvalue->u.expandingSquare);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PositiveScalarElementType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PositiveScalarElementType (OSCTXT* pctxt, 
   PositiveScalarElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarType (pctxt, 
               &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_PositiveScalarElementType (OSCTXT* pctxt, 
   PositiveScalarElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* value */
            stat = XmlDec_PositiveScalarType (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "PositiveScalarElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "PositiveScalarElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SpeedElementType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SpeedElementType (OSCTXT* pctxt, SpeedElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   pvalue->speedOverGround = FALSE;

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode speedOverGround */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->speedOverGround, ASN1IMPL, length);
            if (stat == 0) {
            }
         }
         break;

      case 3:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarType (pctxt, 
               &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SpeedElementType (OSCTXT* pctxt, SpeedElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("speedOverGround"), 15}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* speedOverGround */
            stat = rtXmlpDecBool (pctxt, &pvalue->speedOverGround);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 3: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 4: /* value */
            stat = XmlDec_PositiveScalarType (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SpeedElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SpeedElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PositiveScalarElementType_derivations                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PositiveScalarElementType_derivations (OSCTXT* pctxt, 
   PositiveScalarElementType_derivations *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.positiveScalarElementType
             = rtxMemAllocType (pctxt, PositiveScalarElementType);

         if (pvalue->u.positiveScalarElementType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType (pvalue->u.positiveScalarElementType);
         stat = asn1D_PositiveScalarElementType (pctxt, 
            pvalue->u.positiveScalarElementType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.speedElementType
             = rtxMemAllocType (pctxt, SpeedElementType);

         if (pvalue->u.speedElementType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SpeedElementType (pvalue->u.speedElementType);
         stat = asn1D_SpeedElementType (pctxt, 
            pvalue->u.speedElementType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_PositiveScalarElementType_derivations (OSCTXT* pctxt, 
   PositiveScalarElementType_derivations* pvalue)
{
   const OSUTF8CHAR* xsiType = 0;
   int stat = 0;

   /* decode xsi:type attribute */
   if (rtXmlpHasAttributes (pctxt)) {
      OSUINT32 i, nAttrs = 0;
      OSXMLNameFragments attrName;

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) == 0 &&
             rtXmlpDecXSITypeAttr (pctxt, &attrName, &xsiType) == 0) break;
      }
   }

   /* decode content */
   if (!OS_ISEMPTY (xsiType)) {
      xsiType = rtXmlDecQName (pctxt, xsiType, 0);
   }
   if (OS_ISEMPTY (xsiType)) {
      pvalue->t = 1;
      pvalue->u.positiveScalarElementType
          = rtxMemAllocType (pctxt, PositiveScalarElementType);

      if (pvalue->u.positiveScalarElementType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType (pvalue->u.positiveScalarElementType
         );

      stat = XmlDec_PositiveScalarElementType (pctxt, pvalue->
         u.positiveScalarElementType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("PositiveScalarElementType")))
   {
      pvalue->t = 1;
      pvalue->u.positiveScalarElementType
          = rtxMemAllocType (pctxt, PositiveScalarElementType);

      if (pvalue->u.positiveScalarElementType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType (pvalue->u.positiveScalarElementType
         );

      stat = XmlDec_PositiveScalarElementType (pctxt, pvalue->
         u.positiveScalarElementType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("SpeedElementType")))
   {
      pvalue->t = 2;
      pvalue->u.speedElementType = rtxMemAllocType (pctxt, SpeedElementType);

      if (pvalue->u.speedElementType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SpeedElementType (pvalue->u.speedElementType);

      stat = XmlDec_SpeedElementType (pctxt, pvalue->u.speedElementType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DepthTypeElements                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DepthTypeElements (OSCTXT* pctxt, DepthTypeElements *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.depth
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.depth == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.depth);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.depth, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.altitude
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.altitude == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.altitude);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.altitude, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_DepthTypeElements (OSCTXT* pctxt, DepthTypeElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Depth"), 5}, 0}, 0 },
      {{{OSUTF8("Altitude"), 8}, 0}, 1 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* Depth */
      pvalue->u.depth
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.depth == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.depth);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.depth);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* Altitude */
      pvalue->u.altitude
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.altitude == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.altitude);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.altitude);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TrackModeType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TrackModeType (OSCTXT* pctxt, TrackModeType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_TrackModeType (OSCTXT* pctxt, TrackModeType* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = TrackModeType_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TrackModeElementType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TrackModeElementType (OSCTXT* pctxt, 
   TrackModeElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TrackModeType (pctxt, 
               &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_TrackModeElementType (OSCTXT* pctxt, TrackModeElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* value */
            stat = XmlDec_TrackModeType (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "TrackModeElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "TrackModeElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignedPercentType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignedPercentType (OSCTXT* pctxt, SignedPercentType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_SignedPercentType (OSCTXT* pctxt, SignedPercentType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDouble (pctxt, pvalue, -1, -1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SignedPercentElementType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SignedPercentElementType (OSCTXT* pctxt, 
   SignedPercentElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SignedPercentType (pctxt, 
               &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SignedPercentElementType (OSCTXT* pctxt, 
   SignedPercentElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* value */
            stat = XmlDec_SignedPercentType (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SignedPercentElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SignedPercentElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetPropellerCommandType_choice                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SetPropellerCommandType_choice (OSCTXT* pctxt, 
   SetPropellerCommandType_choice *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.portPropeller
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.portPropeller == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.portPropeller);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.portPropeller, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.starboardPropeller
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.starboardPropeller == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.starboardPropeller);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.starboardPropeller, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.centerlinePropeller
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.centerlinePropeller == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.centerlinePropeller);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.centerlinePropeller, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.allPropellers
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.allPropellers == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.allPropellers);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.allPropellers, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_SetPropellerCommandType_choice (OSCTXT* pctxt, 
   SetPropellerCommandType_choice* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("PortPropeller"), 13}, 0}, 0 },
      {{{OSUTF8("StarboardPropeller"), 18}, 0}, 1 },
      {{{OSUTF8("CenterlinePropeller"), 19}, 0}, 2 },
      {{{OSUTF8("AllPropellers"), 13}, 0}, 3 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 4, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* PortPropeller */
      pvalue->u.portPropeller
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.portPropeller == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.portPropeller);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.portPropeller);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* StarboardPropeller */
      pvalue->u.starboardPropeller
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.starboardPropeller == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.starboardPropeller);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->
         u.starboardPropeller);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* CenterlinePropeller */
      pvalue->u.centerlinePropeller
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.centerlinePropeller == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.centerlinePropeller);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->
         u.centerlinePropeller);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* AllPropellers */
      pvalue->u.allPropellers
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.allPropellers == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.allPropellers);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.allPropellers);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetPropellerCommandType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SetPropellerCommandType (OSCTXT* pctxt, 
   SetPropellerCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SetPropellerCommandType_choice (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SetPropellerCommandType (OSCTXT* pctxt, 
   SetPropellerCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SetPropellerCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SetPropellerCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("PortPropeller"), 13}, 0}, 0 },
      {{{OSUTF8("StarboardPropeller"), 18}, 0}, 0 },
      {{{OSUTF8("CenterlinePropeller"), 19}, 0}, 0 },
      {{{OSUTF8("AllPropellers"), 13}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}, {4, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_SetPropellerCommandType_choice (pctxt, &pvalue->choice
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvSpeedElements                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UuvSpeedElements (OSCTXT* pctxt, UuvSpeedElements *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.setPower
             = rtxMemAllocType (pctxt, SetPropellerCommandType);

         if (pvalue->u.setPower == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SetPropellerCommandType (pvalue->u.setPower);
         stat = asn1D_SetPropellerCommandType (pctxt, 
            pvalue->u.setPower, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.makeKnots = rtxMemAllocType (pctxt, SpeedElementType);

         if (pvalue->u.makeKnots == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SpeedElementType (pvalue->u.makeKnots);
         stat = asn1D_SpeedElementType (pctxt, 
            pvalue->u.makeKnots, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.makeSpeed = rtxMemAllocType (pctxt, SpeedElementType);

         if (pvalue->u.makeSpeed == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SpeedElementType (pvalue->u.makeSpeed);
         stat = asn1D_SpeedElementType (pctxt, 
            pvalue->u.makeSpeed, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_UuvSpeedElements (OSCTXT* pctxt, UuvSpeedElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("SetPower"), 8}, 0}, 0 },
      {{{OSUTF8("MakeKnots"), 9}, 0}, 1 },
      {{{OSUTF8("MakeSpeed"), 9}, 0}, 2 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 3, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* SetPower */
      pvalue->u.setPower = rtxMemAllocType (pctxt, SetPropellerCommandType);

      if (pvalue->u.setPower == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SetPropellerCommandType (pvalue->u.setPower);

      stat = XmlDec_SetPropellerCommandType (pctxt, pvalue->u.setPower);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* MakeKnots */
      pvalue->u.makeKnots = rtxMemAllocType (pctxt, SpeedElementType);

      if (pvalue->u.makeKnots == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SpeedElementType (pvalue->u.makeKnots);

      stat = XmlDec_SpeedElementType (pctxt, pvalue->u.makeKnots);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* MakeSpeed */
      pvalue->u.makeSpeed = rtxMemAllocType (pctxt, SpeedElementType);

      if (pvalue->u.makeSpeed == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SpeedElementType (pvalue->u.makeSpeed);

      stat = XmlDec_SpeedElementType (pctxt, pvalue->u.makeSpeed);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PositiveIntegerElementType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PositiveIntegerElementType (OSCTXT* pctxt, 
   PositiveIntegerElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveIntType (pctxt, 
               &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_PositiveIntegerElementType (OSCTXT* pctxt, 
   PositiveIntegerElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* value */
            stat = XmlDec_PositiveIntType (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "PositiveIntegerElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "PositiveIntegerElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvCompositeWaypointCommandType                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UuvCompositeWaypointCommandType (OSCTXT* pctxt, 
   UuvCompositeWaypointCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CompositeWaypointElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DepthTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode homingMode */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TrackModeElementType (pctxt, 
               &pvalue->homingMode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.homingModePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode choice_2 */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UuvSpeedElements (pctxt, 
               &pvalue->choice_2, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_2Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode gpsFixes */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveIntegerElementType (pctxt, 
               &pvalue->gpsFixes, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.gpsFixesPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 8:
         /* decode standoff */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->standoff, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.standoffPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 9:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_CONS|9):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UuvCompositeWaypointCommandType (OSCTXT* pctxt, 
   UuvCompositeWaypointCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UuvCompositeWaypointCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UuvCompositeWaypointCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("WaypointList"), 12}, 0}, 0 },
      {{{OSUTF8("ParallelTrack"), 13}, 0}, 0 },
      {{{OSUTF8("SectorPattern"), 13}, 0}, 0 },
      {{{OSUTF8("ExpandingSquare"), 15}, 0}, 0 },
      {{{OSUTF8("Depth"), 5}, 0}, 1 },
      {{{OSUTF8("Altitude"), 8}, 0}, 1 },
      {{{OSUTF8("HomingMode"), 10}, 0}, 2 },
      {{{OSUTF8("SetPower"), 8}, 0}, 3 },
      {{{OSUTF8("MakeKnots"), 9}, 0}, 3 },
      {{{OSUTF8("MakeSpeed"), 9}, 0}, 3 },
      {{{OSUTF8("GpsFixes"), 8}, 0}, 4 },
      {{{OSUTF8("Standoff"), 8}, 0}, 5 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 6 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}, {4, 2, -1}, {6, 7, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 7; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_CompositeWaypointElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_DepthTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* HomingMode */
         stat = XmlDec_TrackModeElementType (pctxt, &pvalue->homingMode);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.homingModePresent = TRUE;
         break;
      }
      case 3: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_UuvSpeedElements (pctxt, &pvalue->choice_2);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_2Present = TRUE;
         break;
      }
      case 4: { /* GpsFixes */
         stat = XmlDec_PositiveIntegerElementType (pctxt, &pvalue->gpsFixes);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.gpsFixesPresent = TRUE;
         break;
      }
      case 5: { /* Standoff */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            standoff);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.standoffPresent = TRUE;
         break;
      }
      case 6: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  StringElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_StringElementType (OSCTXT* pctxt, StringElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_StringElementType (OSCTXT* pctxt, StringElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* value */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "StringElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "StringElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FollowBeaconCommandType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_FollowBeaconCommandType (OSCTXT* pctxt, 
   FollowBeaconCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode beacon */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_StringElementType (pctxt, 
               &pvalue->beacon, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.beaconPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_FollowBeaconCommandType (OSCTXT* pctxt, 
   FollowBeaconCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "FollowBeaconCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "FollowBeaconCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Beacon"), 6}, 0}, 0 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Beacon */
         stat = XmlDec_StringElementType (pctxt, &pvalue->beacon);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.beaconPresent = TRUE;
         break;
      }
      case 1: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GpsFixCommandType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_GpsFixCommandType (OSCTXT* pctxt, GpsFixCommandType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarType (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_GpsFixCommandType (OSCTXT* pctxt, GpsFixCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeOut"), 7}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeOut */
            stat = XmlDec_PositiveScalarType (pctxt, &pvalue->timeOut);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeOutPresent = TRUE;
            break;

         case 3: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 4: /* value */
            stat = rtXmlpDecBool (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "GpsFixCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "GpsFixCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NoValueElementType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NoValueElementType (OSCTXT* pctxt, 
   NoValueElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_NoValueElementType (OSCTXT* pctxt, NoValueElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "NoValueElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "NoValueElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HeadingElementType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_HeadingElementType (OSCTXT* pctxt, 
   HeadingElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HeadingType (pctxt, 
               &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_HeadingElementType (OSCTXT* pctxt, HeadingElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* value */
            stat = XmlDec_HeadingType (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "HeadingElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "HeadingElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BooleanElementType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_BooleanElementType (OSCTXT* pctxt, 
   BooleanElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_BooleanElementType (OSCTXT* pctxt, BooleanElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* value */
            stat = rtXmlpDecBool (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "BooleanElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "BooleanElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BooleanElementType_derivations                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_BooleanElementType_derivations (OSCTXT* pctxt, 
   BooleanElementType_derivations *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.booleanElementType
             = rtxMemAllocType (pctxt, BooleanElementType);

         if (pvalue->u.booleanElementType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_BooleanElementType (pvalue->u.booleanElementType);
         stat = asn1D_BooleanElementType (pctxt, 
            pvalue->u.booleanElementType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.gpsFixCommandType
             = rtxMemAllocType (pctxt, GpsFixCommandType);

         if (pvalue->u.gpsFixCommandType == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_GpsFixCommandType (pvalue->u.gpsFixCommandType);
         stat = asn1D_GpsFixCommandType (pctxt, 
            pvalue->u.gpsFixCommandType, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_BooleanElementType_derivations (OSCTXT* pctxt, 
   BooleanElementType_derivations* pvalue)
{
   const OSUTF8CHAR* xsiType = 0;
   int stat = 0;

   /* decode xsi:type attribute */
   if (rtXmlpHasAttributes (pctxt)) {
      OSUINT32 i, nAttrs = 0;
      OSXMLNameFragments attrName;

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) == 0 &&
             rtXmlpDecXSITypeAttr (pctxt, &attrName, &xsiType) == 0) break;
      }
   }

   /* decode content */
   if (!OS_ISEMPTY (xsiType)) {
      xsiType = rtXmlDecQName (pctxt, xsiType, 0);
   }
   if (OS_ISEMPTY (xsiType)) {
      pvalue->t = 1;
      pvalue->u.booleanElementType
          = rtxMemAllocType (pctxt, BooleanElementType);

      if (pvalue->u.booleanElementType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_BooleanElementType (pvalue->u.booleanElementType);

      stat = XmlDec_BooleanElementType (pctxt, pvalue->u.booleanElementType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("BooleanElementType")))
   {
      pvalue->t = 1;
      pvalue->u.booleanElementType
          = rtxMemAllocType (pctxt, BooleanElementType);

      if (pvalue->u.booleanElementType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_BooleanElementType (pvalue->u.booleanElementType);

      stat = XmlDec_BooleanElementType (pctxt, pvalue->u.booleanElementType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }
   else if (rtxUTF8StrEqual (xsiType, OSUTF8("GpsFixCommandType")))
   {
      pvalue->t = 2;
      pvalue->u.gpsFixCommandType
          = rtxMemAllocType (pctxt, GpsFixCommandType);

      if (pvalue->u.gpsFixCommandType == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_GpsFixCommandType (pvalue->u.gpsFixCommandType);

      stat = XmlDec_GpsFixCommandType (pctxt, pvalue->u.gpsFixCommandType);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HoverCommandType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_HoverCommandType (OSCTXT* pctxt, HoverCommandType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choicePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DepthTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode heading */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HeadingElementType (pctxt, 
               &pvalue->heading, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.headingPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode obtainGps */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_BooleanElementType_derivations (pctxt, 
               &pvalue->obtainGps, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.obtainGpsPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode standoff */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->standoff, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.standoffPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 8:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_HoverCommandType (OSCTXT* pctxt, HoverCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "HoverCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "HoverCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 },
      {{{OSUTF8("RelativeXYPosition"), 18}, 0}, 0 },
      {{{OSUTF8("Depth"), 5}, 0}, 1 },
      {{{OSUTF8("Altitude"), 8}, 0}, 1 },
      {{{OSUTF8("Heading"), 7}, 0}, 2 },
      {{{OSUTF8("ObtainGps"), 9}, 0}, 3 },
      {{{OSUTF8("Standoff"), 8}, 0}, 4 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 5 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 9, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 6; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_HorizontalPositionElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choicePresent = TRUE;
         break;
      }
      case 1: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_DepthTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      case 2: { /* Heading */
         stat = XmlDec_HeadingElementType (pctxt, &pvalue->heading);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.headingPresent = TRUE;
         break;
      }
      case 3: { /* ObtainGps */
         stat = XmlDec_BooleanElementType_derivations (pctxt, &pvalue->
            obtainGps);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.obtainGpsPresent = TRUE;
         break;
      }
      case 4: { /* Standoff */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            standoff);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.standoffPresent = TRUE;
         break;
      }
      case 5: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvLoiterCommandType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UuvLoiterCommandType (OSCTXT* pctxt, 
   UuvLoiterCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choicePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DepthTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode choice_2 */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UuvSpeedElements (pctxt, 
               &pvalue->choice_2, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_2Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode loiterDepth */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->loiterDepth, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UuvLoiterCommandType (OSCTXT* pctxt, UuvLoiterCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UuvLoiterCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UuvLoiterCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 },
      {{{OSUTF8("RelativeXYPosition"), 18}, 0}, 0 },
      {{{OSUTF8("Depth"), 5}, 0}, 1 },
      {{{OSUTF8("Altitude"), 8}, 0}, 1 },
      {{{OSUTF8("SetPower"), 8}, 0}, 2 },
      {{{OSUTF8("MakeKnots"), 9}, 0}, 2 },
      {{{OSUTF8("MakeSpeed"), 9}, 0}, 2 },
      {{{OSUTF8("LoiterDepth"), 11}, 0}, 3 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 9, -1}, {9, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_HorizontalPositionElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choicePresent = TRUE;
         break;
      }
      case 1: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_DepthTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      case 2: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_UuvSpeedElements (pctxt, &pvalue->choice_2);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_2Present = TRUE;
         break;
      }
      case 3: { /* LoiterDepth */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            loiterDepth);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ExitModeElements                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ExitModeElements (OSCTXT* pctxt, ExitModeElements *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.normalExit = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.normalExit == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.normalExit);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.normalExit, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.missionAbort = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.missionAbort == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.missionAbort);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.missionAbort, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.systemAbort = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.systemAbort == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.systemAbort);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.systemAbort, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.recallAbort = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.recallAbort == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.recallAbort);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.recallAbort, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_ExitModeElements (OSCTXT* pctxt, ExitModeElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("NormalExit"), 10}, 0}, 0 },
      {{{OSUTF8("MissionAbort"), 12}, 0}, 1 },
      {{{OSUTF8("SystemAbort"), 11}, 0}, 2 },
      {{{OSUTF8("RecallAbort"), 11}, 0}, 3 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 4, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* NormalExit */
      pvalue->u.normalExit = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.normalExit == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.normalExit);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.normalExit);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* MissionAbort */
      pvalue->u.missionAbort = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.missionAbort == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.missionAbort);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.missionAbort);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* SystemAbort */
      pvalue->u.systemAbort = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.systemAbort == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.systemAbort);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.systemAbort);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* RecallAbort */
      pvalue->u.recallAbort = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.recallAbort == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.recallAbort);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.recallAbort);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  QuitCommandType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_QuitCommandType (OSCTXT* pctxt, QuitCommandType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ExitModeElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choicePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_QuitCommandType (OSCTXT* pctxt, QuitCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "QuitCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "QuitCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("NormalExit"), 10}, 0}, 0 },
      {{{OSUTF8("MissionAbort"), 12}, 0}, 0 },
      {{{OSUTF8("SystemAbort"), 11}, 0}, 0 },
      {{{OSUTF8("RecallAbort"), 11}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_ExitModeElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choicePresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ScalarElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ScalarElementType (OSCTXT* pctxt, ScalarElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_ScalarElementType (OSCTXT* pctxt, ScalarElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* value */
            stat = rtXmlpDecDouble (pctxt, &pvalue->value, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "ScalarElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "ScalarElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RecoverCommandType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RecoverCommandType (OSCTXT* pctxt, 
   RecoverCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode range */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ScalarElementType (pctxt, 
               &pvalue->range, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode heading */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HeadingElementType (pctxt, 
               &pvalue->heading, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_RecoverCommandType (OSCTXT* pctxt, RecoverCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "RecoverCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "RecoverCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Range"), 5}, 0}, 0 },
      {{{OSUTF8("Heading"), 7}, 0}, 1 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Range */
         stat = XmlDec_ScalarElementType (pctxt, &pvalue->range);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* Heading */
         stat = XmlDec_HeadingElementType (pctxt, &pvalue->heading);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SendMessageCommandType_choice                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SendMessageCommandType_choice (OSCTXT* pctxt, 
   SendMessageCommandType_choice *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.aVCLMessage = rtxMemAllocType (pctxt, AvclMessageType);

         if (pvalue->u.aVCLMessage == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_AvclMessageType ((AvclMessageType*)pvalue->u.aVCLMessage);
         stat = asn1D_AvclMessageType (pctxt, 
            (AvclMessageType*)pvalue->u.aVCLMessage, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_SendMessageCommandType_choice (OSCTXT* pctxt, 
   SendMessageCommandType_choice* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("AVCLMessage"), 11}, 0}, 0 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 1, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* AVCLMessage */
      pvalue->u.aVCLMessage = rtxMemAllocType (pctxt, AvclMessageType);

      if (pvalue->u.aVCLMessage == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_AvclMessageType ((AvclMessageType*)pvalue->u.aVCLMessage);

      stat = XmlDec_AvclMessageType (pctxt, pvalue->u.aVCLMessage);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SendMessageCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SendMessageCommandType (OSCTXT* pctxt, 
   SendMessageCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SendMessageCommandType_choice (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SendMessageCommandType (OSCTXT* pctxt, 
   SendMessageCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SendMessageCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SendMessageCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("AVCLMessage"), 11}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_SendMessageCommandType_choice (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetPlanesCommandType_choice                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SetPlanesCommandType_choice (OSCTXT* pctxt, 
   SetPlanesCommandType_choice *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.bowPlanes
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.bowPlanes == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.bowPlanes);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.bowPlanes, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.sternPlanes
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.sternPlanes == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.sternPlanes);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.sternPlanes, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.allPlanes
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.allPlanes == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.allPlanes);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.allPlanes, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_SetPlanesCommandType_choice (OSCTXT* pctxt, 
   SetPlanesCommandType_choice* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("BowPlanes"), 9}, 0}, 0 },
      {{{OSUTF8("SternPlanes"), 11}, 0}, 1 },
      {{{OSUTF8("AllPlanes"), 9}, 0}, 2 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 3, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* BowPlanes */
      pvalue->u.bowPlanes = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.bowPlanes == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.bowPlanes);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.bowPlanes);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* SternPlanes */
      pvalue->u.sternPlanes
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.sternPlanes == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.sternPlanes);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.sternPlanes);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* AllPlanes */
      pvalue->u.allPlanes = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.allPlanes == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.allPlanes);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.allPlanes);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetPlanesCommandType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SetPlanesCommandType (OSCTXT* pctxt, 
   SetPlanesCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SetPlanesCommandType_choice (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SetPlanesCommandType (OSCTXT* pctxt, SetPlanesCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SetPlanesCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SetPlanesCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("BowPlanes"), 9}, 0}, 0 },
      {{{OSUTF8("SternPlanes"), 11}, 0}, 0 },
      {{{OSUTF8("AllPlanes"), 9}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}, {3, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /*  */
         stat = XmlDec_SetPlanesCommandType_choice (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AbsoluteHorizontalPositionElements                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AbsoluteHorizontalPositionElements (OSCTXT* pctxt, 
   AbsoluteHorizontalPositionElements *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.latitudeLongitude
             = rtxMemAllocType (pctxt, LatitudeLongitudeElementType_derivations);

         if (pvalue->u.latitudeLongitude == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_LatitudeLongitudeElementType_derivations (pvalue->u.latitudeLongitude);
         stat = asn1D_LatitudeLongitudeElementType_derivations (pctxt, 
            pvalue->u.latitudeLongitude, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.xYPosition = rtxMemAllocType (pctxt, XyElementType);

         if (pvalue->u.xYPosition == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_XyElementType (pvalue->u.xYPosition);
         stat = asn1D_XyElementType (pctxt, 
            pvalue->u.xYPosition, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_AbsoluteHorizontalPositionElements (OSCTXT* pctxt, 
   AbsoluteHorizontalPositionElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 1 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* LatitudeLongitude */
      pvalue->u.latitudeLongitude
          = rtxMemAllocType (pctxt, LatitudeLongitudeElementType_derivations);

      if (pvalue->u.latitudeLongitude == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_LatitudeLongitudeElementType_derivations (pvalue->
         u.latitudeLongitude);

      stat = XmlDec_LatitudeLongitudeElementType_derivations (pctxt, pvalue->
         u.latitudeLongitude);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* XYPosition */
      pvalue->u.xYPosition = rtxMemAllocType (pctxt, XyElementType);

      if (pvalue->u.xYPosition == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_XyElementType (pvalue->u.xYPosition);

      stat = XmlDec_XyElementType (pctxt, pvalue->u.xYPosition);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvPositionCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UuvPositionCommandType (OSCTXT* pctxt, 
   UuvPositionCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AbsoluteHorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode depth */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->depth, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.depthPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UuvPositionCommandType (OSCTXT* pctxt, 
   UuvPositionCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UuvPositionCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UuvPositionCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 },
      {{{OSUTF8("Depth"), 5}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_AbsoluteHorizontalPositionElements (pctxt, &pvalue->
            choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* Depth */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            depth);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.depthPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetSonarCommandType_choice                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SetSonarCommandType_choice (OSCTXT* pctxt, 
   SetSonarCommandType_choice *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.manual = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.manual == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.manual);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.manual, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.scan = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.scan == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.scan);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.scan, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.track = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.track == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.track);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.track, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_SetSonarCommandType_choice (OSCTXT* pctxt, 
   SetSonarCommandType_choice* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Manual"), 6}, 0}, 0 },
      {{{OSUTF8("Scan"), 4}, 0}, 1 },
      {{{OSUTF8("Track"), 5}, 0}, 2 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 3, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* Manual */
      pvalue->u.manual = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.manual == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.manual);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.manual);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* Scan */
      pvalue->u.scan = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.scan == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.scan);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.scan);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* Track */
      pvalue->u.track = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.track == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.track);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.track);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BearingTypeElements                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_BearingTypeElements (OSCTXT* pctxt, 
   BearingTypeElements *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.relative = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.relative == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.relative);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.relative, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.true_ = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.true_ == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.true_);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.true_, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.magnetic = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.magnetic == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.magnetic);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.magnetic, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_BearingTypeElements (OSCTXT* pctxt, BearingTypeElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Relative"), 8}, 0}, 0 },
      {{{OSUTF8("True"), 4}, 0}, 1 },
      {{{OSUTF8("Magnetic"), 8}, 0}, 2 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 3, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* Relative */
      pvalue->u.relative = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.relative == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.relative);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.relative);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* True */
      pvalue->u.true_ = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.true_ == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.true_);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.true_);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* Magnetic */
      pvalue->u.magnetic = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.magnetic == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.magnetic);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.magnetic);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetSonarCommandType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SetSonarCommandType (OSCTXT* pctxt, 
   SetSonarCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode model */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_StringElementType (pctxt, 
               &pvalue->model, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SetSonarCommandType_choice (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode bearing */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ScalarElementType (pctxt, 
               &pvalue->bearing, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.bearingPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode elevation */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ScalarElementType (pctxt, 
               &pvalue->elevation, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.elevationPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_BearingTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SetSonarCommandType (OSCTXT* pctxt, SetSonarCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SetSonarCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SetSonarCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Model"), 5}, 0}, 0 },
      {{{OSUTF8("Manual"), 6}, 0}, 1 },
      {{{OSUTF8("Scan"), 4}, 0}, 1 },
      {{{OSUTF8("Track"), 5}, 0}, 1 },
      {{{OSUTF8("Bearing"), 7}, 0}, 2 },
      {{{OSUTF8("Elevation"), 9}, 0}, 3 },
      {{{OSUTF8("Relative"), 8}, 0}, 4 },
      {{{OSUTF8("True"), 4}, 0}, 4 },
      {{{OSUTF8("Magnetic"), 8}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 3, -1}, {4, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Model */
         stat = XmlDec_StringElementType (pctxt, &pvalue->model);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /*  */
         stat = XmlDec_SetSonarCommandType_choice (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* Bearing */
         stat = XmlDec_ScalarElementType (pctxt, &pvalue->bearing);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.bearingPresent = TRUE;
         break;
      }
      case 3: { /* Elevation */
         stat = XmlDec_ScalarElementType (pctxt, &pvalue->elevation);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.elevationPresent = TRUE;
         break;
      }
      case 4: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_BearingTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetThrusterCommandType_choice                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SetThrusterCommandType_choice (OSCTXT* pctxt, 
   SetThrusterCommandType_choice *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.bowLateralThruster
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.bowLateralThruster == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.bowLateralThruster);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.bowLateralThruster, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.sternLateralThruster
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.sternLateralThruster == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.sternLateralThruster);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.sternLateralThruster, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.lateralThrusters
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.lateralThrusters == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.lateralThrusters);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.lateralThrusters, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.bowVerticalThruster
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.bowVerticalThruster == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.bowVerticalThruster);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.bowVerticalThruster, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_CONS|4):
         pvalue->u.sternVerticalThruster
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.sternVerticalThruster == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.sternVerticalThruster);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.sternVerticalThruster, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_CONS|5):
         pvalue->u.verticalThrusters
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.verticalThrusters == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.verticalThrusters);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.verticalThrusters, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_SetThrusterCommandType_choice (OSCTXT* pctxt, 
   SetThrusterCommandType_choice* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("BowLateralThruster"), 18}, 0}, 0 },
      {{{OSUTF8("SternLateralThruster"), 20}, 0}, 1 },
      {{{OSUTF8("LateralThrusters"), 16}, 0}, 2 },
      {{{OSUTF8("BowVerticalThruster"), 19}, 0}, 3 },
      {{{OSUTF8("SternVerticalThruster"), 21}, 0}, 4 },
      {{{OSUTF8("VerticalThrusters"), 17}, 0}, 5 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 6, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* BowLateralThruster */
      pvalue->u.bowLateralThruster
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.bowLateralThruster == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.bowLateralThruster);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->
         u.bowLateralThruster);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* SternLateralThruster */
      pvalue->u.sternLateralThruster
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.sternLateralThruster == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.sternLateralThruster);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->
         u.sternLateralThruster);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* LateralThrusters */
      pvalue->u.lateralThrusters
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.lateralThrusters == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.lateralThrusters);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.lateralThrusters
         );
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* BowVerticalThruster */
      pvalue->u.bowVerticalThruster
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.bowVerticalThruster == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.bowVerticalThruster);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->
         u.bowVerticalThruster);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 4: { /* SternVerticalThruster */
      pvalue->u.sternVerticalThruster
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.sternVerticalThruster == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.sternVerticalThruster);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->
         u.sternVerticalThruster);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 5: { /* VerticalThrusters */
      pvalue->u.verticalThrusters
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.verticalThrusters == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.verticalThrusters);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->
         u.verticalThrusters);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SetThrusterCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SetThrusterCommandType (OSCTXT* pctxt, 
   SetThrusterCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SetThrusterCommandType_choice (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SetThrusterCommandType (OSCTXT* pctxt, 
   SetThrusterCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SetThrusterCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SetThrusterCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("BowLateralThruster"), 18}, 0}, 0 },
      {{{OSUTF8("SternLateralThruster"), 20}, 0}, 0 },
      {{{OSUTF8("LateralThrusters"), 16}, 0}, 0 },
      {{{OSUTF8("BowVerticalThruster"), 19}, 0}, 0 },
      {{{OSUTF8("SternVerticalThruster"), 21}, 0}, 0 },
      {{{OSUTF8("VerticalThrusters"), 17}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 6, -1}, {6, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /*  */
         stat = XmlDec_SetThrusterCommandType_choice (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TakeStationCommandType_choice                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TakeStationCommandType_choice (OSCTXT* pctxt, 
   TakeStationCommandType_choice *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.targetSonarScan
             = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.targetSonarScan == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.targetSonarScan);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.targetSonarScan, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.targetEdgeSonarScan
             = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.targetEdgeSonarScan == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.targetEdgeSonarScan);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.targetEdgeSonarScan, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_TakeStationCommandType_choice (OSCTXT* pctxt, 
   TakeStationCommandType_choice* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("TargetSonarScan"), 15}, 0}, 0 },
      {{{OSUTF8("TargetEdgeSonarScan"), 19}, 0}, 1 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* TargetSonarScan */
      pvalue->u.targetSonarScan = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.targetSonarScan == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.targetSonarScan);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.targetSonarScan);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* TargetEdgeSonarScan */
      pvalue->u.targetEdgeSonarScan
          = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.targetEdgeSonarScan == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.targetEdgeSonarScan);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.targetEdgeSonarScan);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TargetElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TargetElementType (OSCTXT* pctxt, TargetElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode bearing */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->bearing, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode elevation */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->elevation, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.elevationPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode range */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_real (pctxt, &pvalue->range, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_PRIM|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_TargetElementType (OSCTXT* pctxt, TargetElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("bearing"), 7}, 0 },
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("elevation"), 9}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("range"), 5}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 6, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* bearing */
            stat = rtXmlpDecDouble (pctxt, &pvalue->bearing, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 2: /* elevation */
            stat = rtXmlpDecDouble (pctxt, &pvalue->elevation, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.elevationPresent = TRUE;
            break;

         case 3: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 4: /* range */
            stat = rtXmlpDecDouble (pctxt, &pvalue->range, -1, -1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 5: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "TargetElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "TargetElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TakeStationCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TakeStationCommandType (OSCTXT* pctxt, 
   TakeStationCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TakeStationCommandType_choice (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode targetLocation */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TargetElementType (pctxt, 
               &pvalue->targetLocation, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.targetLocationPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode commandedStation */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TargetElementType (pctxt, 
               &pvalue->commandedStation, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode heading */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HeadingElementType (pctxt, 
               &pvalue->heading, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.headingPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_TakeStationCommandType (OSCTXT* pctxt, 
   TakeStationCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "TakeStationCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "TakeStationCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("TargetSonarScan"), 15}, 0}, 0 },
      {{{OSUTF8("TargetEdgeSonarScan"), 19}, 0}, 0 },
      {{{OSUTF8("TargetLocation"), 14}, 0}, 1 },
      {{{OSUTF8("CommandedStation"), 16}, 0}, 2 },
      {{{OSUTF8("Heading"), 7}, 0}, 3 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 2, -1}, {4, 2, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /*  */
         stat = XmlDec_TakeStationCommandType_choice (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* TargetLocation */
         stat = XmlDec_TargetElementType (pctxt, &pvalue->targetLocation);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.targetLocationPresent = TRUE;
         break;
      }
      case 2: { /* CommandedStation */
         stat = XmlDec_TargetElementType (pctxt, &pvalue->commandedStation);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* Heading */
         stat = XmlDec_HeadingElementType (pctxt, &pvalue->heading);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.headingPresent = TRUE;
         break;
      }
      case 4: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvWaypointCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UuvWaypointCommandType (OSCTXT* pctxt, 
   UuvWaypointCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DepthTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode homingMode */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TrackModeElementType (pctxt, 
               &pvalue->homingMode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.homingModePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode choice_2 */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_UuvSpeedElements (pctxt, 
               &pvalue->choice_2, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_2Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode obtainGps */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_BooleanElementType_derivations (pctxt, 
               &pvalue->obtainGps, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.obtainGpsPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 8:
         /* decode standoff */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->standoff, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.standoffPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 9:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_CONS|9):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UuvWaypointCommandType (OSCTXT* pctxt, 
   UuvWaypointCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UuvWaypointCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UuvWaypointCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 },
      {{{OSUTF8("RelativeXYPosition"), 18}, 0}, 0 },
      {{{OSUTF8("Depth"), 5}, 0}, 1 },
      {{{OSUTF8("Altitude"), 8}, 0}, 1 },
      {{{OSUTF8("HomingMode"), 10}, 0}, 2 },
      {{{OSUTF8("SetPower"), 8}, 0}, 3 },
      {{{OSUTF8("MakeKnots"), 9}, 0}, 3 },
      {{{OSUTF8("MakeSpeed"), 9}, 0}, 3 },
      {{{OSUTF8("ObtainGps"), 9}, 0}, 4 },
      {{{OSUTF8("Standoff"), 8}, 0}, 5 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 6 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}, {3, 9, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 7; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_HorizontalPositionElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_DepthTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      case 2: { /* HomingMode */
         stat = XmlDec_TrackModeElementType (pctxt, &pvalue->homingMode);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.homingModePresent = TRUE;
         break;
      }
      case 3: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_UuvSpeedElements (pctxt, &pvalue->choice_2);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_2Present = TRUE;
         break;
      }
      case 4: { /* ObtainGps */
         stat = XmlDec_BooleanElementType_derivations (pctxt, &pvalue->
            obtainGps);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.obtainGpsPresent = TRUE;
         break;
      }
      case 5: { /* Standoff */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            standoff);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.standoffPresent = TRUE;
         break;
      }
      case 6: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvScriptCommandsType_element                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UuvScriptCommandsType_element (OSCTXT* pctxt, 
   UuvScriptCommandsType_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.compositeWaypoint
             = rtxMemAllocType (pctxt, UuvCompositeWaypointCommandType);

         if (pvalue->u.compositeWaypoint == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UuvCompositeWaypointCommandType (pvalue->u.compositeWaypoint);
         stat = asn1D_UuvCompositeWaypointCommandType (pctxt, 
            pvalue->u.compositeWaypoint, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.followBeacon
             = rtxMemAllocType (pctxt, FollowBeaconCommandType);

         if (pvalue->u.followBeacon == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_FollowBeaconCommandType (pvalue->u.followBeacon);
         stat = asn1D_FollowBeaconCommandType (pctxt, 
            pvalue->u.followBeacon, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.gpsFix = rtxMemAllocType (pctxt, GpsFixCommandType);

         if (pvalue->u.gpsFix == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_GpsFixCommandType (pvalue->u.gpsFix);
         stat = asn1D_GpsFixCommandType (pctxt, 
            pvalue->u.gpsFix, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.help = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.help == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.help);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.help, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_CONS|4):
         pvalue->u.hover = rtxMemAllocType (pctxt, HoverCommandType);

         if (pvalue->u.hover == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_HoverCommandType (pvalue->u.hover);
         stat = asn1D_HoverCommandType (pctxt, 
            pvalue->u.hover, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_CONS|5):
         pvalue->u.loiter = rtxMemAllocType (pctxt, UuvLoiterCommandType);

         if (pvalue->u.loiter == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UuvLoiterCommandType (pvalue->u.loiter);
         stat = asn1D_UuvLoiterCommandType (pctxt, 
            pvalue->u.loiter, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_CONS|6):
         pvalue->u.makeAltitude
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.makeAltitude == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.makeAltitude);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.makeAltitude, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_CONS|7):
         pvalue->u.makeDepth
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.makeDepth == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.makeDepth);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.makeDepth, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_CONS|8):
         pvalue->u.makeHeading = rtxMemAllocType (pctxt, HeadingElementType);

         if (pvalue->u.makeHeading == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_HeadingElementType (pvalue->u.makeHeading);
         stat = asn1D_HeadingElementType (pctxt, 
            pvalue->u.makeHeading, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      case (TM_CTXT|TM_CONS|9):
         pvalue->u.makeKnots = rtxMemAllocType (pctxt, SpeedElementType);

         if (pvalue->u.makeKnots == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SpeedElementType (pvalue->u.makeKnots);
         stat = asn1D_SpeedElementType (pctxt, 
            pvalue->u.makeKnots, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 10;
         break;

      case (TM_CTXT|TM_CONS|10):
         pvalue->u.makeSpeed = rtxMemAllocType (pctxt, SpeedElementType);

         if (pvalue->u.makeSpeed == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SpeedElementType (pvalue->u.makeSpeed);
         stat = asn1D_SpeedElementType (pctxt, 
            pvalue->u.makeSpeed, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 11;
         break;

      case (TM_CTXT|TM_CONS|11):
         pvalue->u.metaCommand = rtxMemAllocType (pctxt, MetaDataType);

         if (pvalue->u.metaCommand == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_MetaDataType (pvalue->u.metaCommand);
         stat = asn1D_MetaDataType (pctxt, 
            pvalue->u.metaCommand, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 12;
         break;

      case (TM_CTXT|TM_CONS|12):
         pvalue->u.missionScript = rtxMemAllocType (pctxt, StringElementType);

         if (pvalue->u.missionScript == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_StringElementType (pvalue->u.missionScript);
         stat = asn1D_StringElementType (pctxt, 
            pvalue->u.missionScript, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 13;
         break;

      case (TM_CTXT|TM_CONS|13):
         pvalue->u.missionScriptInline
             = rtxMemAllocType (pctxt, StringElementType);

         if (pvalue->u.missionScriptInline == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_StringElementType (pvalue->u.missionScriptInline);
         stat = asn1D_StringElementType (pctxt, 
            pvalue->u.missionScriptInline, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 14;
         break;

      case (TM_CTXT|TM_CONS|14):
         pvalue->u.moveLateral
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.moveLateral == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.moveLateral);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.moveLateral, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 15;
         break;

      case (TM_CTXT|TM_CONS|15):
         pvalue->u.moveRotate
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.moveRotate == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.moveRotate);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.moveRotate, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 16;
         break;

      case (TM_CTXT|TM_CONS|16):
         pvalue->u.quit = rtxMemAllocType (pctxt, QuitCommandType);

         if (pvalue->u.quit == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_QuitCommandType (pvalue->u.quit);
         stat = asn1D_QuitCommandType (pctxt, 
            pvalue->u.quit, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 17;
         break;

      case (TM_CTXT|TM_CONS|17):
         pvalue->u.realtime
             = rtxMemAllocType (pctxt, BooleanElementType_derivations);

         if (pvalue->u.realtime == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_BooleanElementType_derivations (pvalue->u.realtime);
         stat = asn1D_BooleanElementType_derivations (pctxt, 
            pvalue->u.realtime, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 18;
         break;

      case (TM_CTXT|TM_CONS|18):
         pvalue->u.recover = rtxMemAllocType (pctxt, RecoverCommandType);

         if (pvalue->u.recover == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_RecoverCommandType (pvalue->u.recover);
         stat = asn1D_RecoverCommandType (pctxt, 
            pvalue->u.recover, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 19;
         break;

      case (TM_CTXT|TM_CONS|19):
         pvalue->u.sendMessage
             = rtxMemAllocType (pctxt, SendMessageCommandType);

         if (pvalue->u.sendMessage == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SendMessageCommandType (pvalue->u.sendMessage);
         stat = asn1D_SendMessageCommandType (pctxt, 
            pvalue->u.sendMessage, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 20;
         break;

      case (TM_CTXT|TM_CONS|20):
         pvalue->u.setPlanes = rtxMemAllocType (pctxt, SetPlanesCommandType);

         if (pvalue->u.setPlanes == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SetPlanesCommandType (pvalue->u.setPlanes);
         stat = asn1D_SetPlanesCommandType (pctxt, 
            pvalue->u.setPlanes, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 21;
         break;

      case (TM_CTXT|TM_CONS|21):
         pvalue->u.setPosition
             = rtxMemAllocType (pctxt, UuvPositionCommandType);

         if (pvalue->u.setPosition == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UuvPositionCommandType (pvalue->u.setPosition);
         stat = asn1D_UuvPositionCommandType (pctxt, 
            pvalue->u.setPosition, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 22;
         break;

      case (TM_CTXT|TM_CONS|22):
         pvalue->u.setPower
             = rtxMemAllocType (pctxt, SetPropellerCommandType);

         if (pvalue->u.setPower == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SetPropellerCommandType (pvalue->u.setPower);
         stat = asn1D_SetPropellerCommandType (pctxt, 
            pvalue->u.setPower, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 23;
         break;

      case (TM_CTXT|TM_CONS|23):
         pvalue->u.setRudder
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.setRudder == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.setRudder);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.setRudder, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 24;
         break;

      case (TM_CTXT|TM_CONS|24):
         pvalue->u.setSonar = rtxMemAllocType (pctxt, SetSonarCommandType);

         if (pvalue->u.setSonar == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SetSonarCommandType (pvalue->u.setSonar);
         stat = asn1D_SetSonarCommandType (pctxt, 
            pvalue->u.setSonar, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 25;
         break;

      case (TM_CTXT|TM_CONS|25):
         pvalue->u.setStandoff
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.setStandoff == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.setStandoff);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.setStandoff, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 26;
         break;

      case (TM_CTXT|TM_CONS|26):
         pvalue->u.setThruster
             = rtxMemAllocType (pctxt, SetThrusterCommandType);

         if (pvalue->u.setThruster == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SetThrusterCommandType (pvalue->u.setThruster);
         stat = asn1D_SetThrusterCommandType (pctxt, 
            pvalue->u.setThruster, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 27;
         break;

      case (TM_CTXT|TM_CONS|27):
         pvalue->u.setTime = rtxMemAllocType (pctxt, ScalarElementType);

         if (pvalue->u.setTime == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_ScalarElementType (pvalue->u.setTime);
         stat = asn1D_ScalarElementType (pctxt, 
            pvalue->u.setTime, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 28;
         break;

      case (TM_CTXT|TM_CONS|28):
         pvalue->u.setTimeStep
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.setTimeStep == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.setTimeStep);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.setTimeStep, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 29;
         break;

      case (TM_CTXT|TM_CONS|29):
         pvalue->u.takeStation
             = rtxMemAllocType (pctxt, TakeStationCommandType);

         if (pvalue->u.takeStation == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_TakeStationCommandType (pvalue->u.takeStation);
         stat = asn1D_TakeStationCommandType (pctxt, 
            pvalue->u.takeStation, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 30;
         break;

      case (TM_CTXT|TM_CONS|30):
         pvalue->u.thrusters
             = rtxMemAllocType (pctxt, BooleanElementType_derivations);

         if (pvalue->u.thrusters == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_BooleanElementType_derivations (pvalue->u.thrusters);
         stat = asn1D_BooleanElementType_derivations (pctxt, 
            pvalue->u.thrusters, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 31;
         break;

      case (TM_CTXT|TM_CONS|31):
         pvalue->u.trace
             = rtxMemAllocType (pctxt, BooleanElementType_derivations);

         if (pvalue->u.trace == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_BooleanElementType_derivations (pvalue->u.trace);
         stat = asn1D_BooleanElementType_derivations (pctxt, 
            pvalue->u.trace, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 32;
         break;

      case (TM_CTXT|TM_CONS|32):
         pvalue->u.wait
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.wait == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.wait);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.wait, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 33;
         break;

      case (TM_CTXT|TM_CONS|33):
         pvalue->u.waitUntilTime
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.waitUntilTime == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.waitUntilTime);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.waitUntilTime, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 34;
         break;

      case (TM_CTXT|TM_CONS|34):
         pvalue->u.waypoint = rtxMemAllocType (pctxt, UuvWaypointCommandType);

         if (pvalue->u.waypoint == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UuvWaypointCommandType (pvalue->u.waypoint);
         stat = asn1D_UuvWaypointCommandType (pctxt, 
            pvalue->u.waypoint, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 35;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_UuvScriptCommandsType_element (OSCTXT* pctxt, 
   UuvScriptCommandsType_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("CompositeWaypoint"), 17}, 0}, 0 },
      {{{OSUTF8("FollowBeacon"), 12}, 0}, 1 },
      {{{OSUTF8("GpsFix"), 6}, 0}, 2 },
      {{{OSUTF8("Help"), 4}, 0}, 3 },
      {{{OSUTF8("Hover"), 5}, 0}, 4 },
      {{{OSUTF8("Loiter"), 6}, 0}, 5 },
      {{{OSUTF8("MakeAltitude"), 12}, 0}, 6 },
      {{{OSUTF8("MakeDepth"), 9}, 0}, 7 },
      {{{OSUTF8("MakeHeading"), 11}, 0}, 8 },
      {{{OSUTF8("MakeKnots"), 9}, 0}, 9 },
      {{{OSUTF8("MakeSpeed"), 9}, 0}, 10 },
      {{{OSUTF8("MetaCommand"), 11}, 0}, 11 },
      {{{OSUTF8("MissionScript"), 13}, 0}, 12 },
      {{{OSUTF8("MissionScriptInline"), 19}, 0}, 13 },
      {{{OSUTF8("MoveLateral"), 11}, 0}, 14 },
      {{{OSUTF8("MoveRotate"), 10}, 0}, 15 },
      {{{OSUTF8("Quit"), 4}, 0}, 16 },
      {{{OSUTF8("Realtime"), 8}, 0}, 17 },
      {{{OSUTF8("Recover"), 7}, 0}, 18 },
      {{{OSUTF8("SendMessage"), 11}, 0}, 19 },
      {{{OSUTF8("SetPlanes"), 9}, 0}, 20 },
      {{{OSUTF8("SetPosition"), 11}, 0}, 21 },
      {{{OSUTF8("SetPower"), 8}, 0}, 22 },
      {{{OSUTF8("SetRudder"), 9}, 0}, 23 },
      {{{OSUTF8("SetSonar"), 8}, 0}, 24 },
      {{{OSUTF8("SetStandoff"), 11}, 0}, 25 },
      {{{OSUTF8("SetThruster"), 11}, 0}, 26 },
      {{{OSUTF8("SetTime"), 7}, 0}, 27 },
      {{{OSUTF8("SetTimeStep"), 11}, 0}, 28 },
      {{{OSUTF8("TakeStation"), 11}, 0}, 29 },
      {{{OSUTF8("Thrusters"), 9}, 0}, 30 },
      {{{OSUTF8("Trace"), 5}, 0}, 31 },
      {{{OSUTF8("Wait"), 4}, 0}, 32 },
      {{{OSUTF8("WaitUntilTime"), 13}, 0}, 33 },
      {{{OSUTF8("Waypoint"), 8}, 0}, 34 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 35, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* CompositeWaypoint */
      pvalue->u.compositeWaypoint
          = rtxMemAllocType (pctxt, UuvCompositeWaypointCommandType);

      if (pvalue->u.compositeWaypoint == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UuvCompositeWaypointCommandType (pvalue->u.compositeWaypoint);

      stat = XmlDec_UuvCompositeWaypointCommandType (pctxt, pvalue->
         u.compositeWaypoint);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* FollowBeacon */
      pvalue->u.followBeacon
          = rtxMemAllocType (pctxt, FollowBeaconCommandType);

      if (pvalue->u.followBeacon == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_FollowBeaconCommandType (pvalue->u.followBeacon);

      stat = XmlDec_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* GpsFix */
      pvalue->u.gpsFix = rtxMemAllocType (pctxt, GpsFixCommandType);

      if (pvalue->u.gpsFix == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_GpsFixCommandType (pvalue->u.gpsFix);

      stat = XmlDec_GpsFixCommandType (pctxt, pvalue->u.gpsFix);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* Help */
      pvalue->u.help = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.help == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.help);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.help);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 4: { /* Hover */
      pvalue->u.hover = rtxMemAllocType (pctxt, HoverCommandType);

      if (pvalue->u.hover == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_HoverCommandType (pvalue->u.hover);

      stat = XmlDec_HoverCommandType (pctxt, pvalue->u.hover);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 5: { /* Loiter */
      pvalue->u.loiter = rtxMemAllocType (pctxt, UuvLoiterCommandType);

      if (pvalue->u.loiter == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UuvLoiterCommandType (pvalue->u.loiter);

      stat = XmlDec_UuvLoiterCommandType (pctxt, pvalue->u.loiter);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 6: { /* MakeAltitude */
      pvalue->u.makeAltitude
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.makeAltitude == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.makeAltitude);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.makeAltitude);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 7: { /* MakeDepth */
      pvalue->u.makeDepth
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.makeDepth == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.makeDepth);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.makeDepth);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 8: { /* MakeHeading */
      pvalue->u.makeHeading = rtxMemAllocType (pctxt, HeadingElementType);

      if (pvalue->u.makeHeading == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_HeadingElementType (pvalue->u.makeHeading);

      stat = XmlDec_HeadingElementType (pctxt, pvalue->u.makeHeading);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 9: { /* MakeKnots */
      pvalue->u.makeKnots = rtxMemAllocType (pctxt, SpeedElementType);

      if (pvalue->u.makeKnots == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SpeedElementType (pvalue->u.makeKnots);

      stat = XmlDec_SpeedElementType (pctxt, pvalue->u.makeKnots);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 10: { /* MakeSpeed */
      pvalue->u.makeSpeed = rtxMemAllocType (pctxt, SpeedElementType);

      if (pvalue->u.makeSpeed == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SpeedElementType (pvalue->u.makeSpeed);

      stat = XmlDec_SpeedElementType (pctxt, pvalue->u.makeSpeed);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 11: { /* MetaCommand */
      pvalue->u.metaCommand = rtxMemAllocType (pctxt, MetaDataType);

      if (pvalue->u.metaCommand == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_MetaDataType (pvalue->u.metaCommand);

      stat = XmlDec_MetaDataType (pctxt, pvalue->u.metaCommand);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 12: { /* MissionScript */
      pvalue->u.missionScript = rtxMemAllocType (pctxt, StringElementType);

      if (pvalue->u.missionScript == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_StringElementType (pvalue->u.missionScript);

      stat = XmlDec_StringElementType (pctxt, pvalue->u.missionScript);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 13: { /* MissionScriptInline */
      pvalue->u.missionScriptInline
          = rtxMemAllocType (pctxt, StringElementType);

      if (pvalue->u.missionScriptInline == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_StringElementType (pvalue->u.missionScriptInline);

      stat = XmlDec_StringElementType (pctxt, pvalue->u.missionScriptInline);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 14: { /* MoveLateral */
      pvalue->u.moveLateral
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.moveLateral == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.moveLateral);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.moveLateral);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 15: { /* MoveRotate */
      pvalue->u.moveRotate
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.moveRotate == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.moveRotate);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.moveRotate);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 16: { /* Quit */
      pvalue->u.quit = rtxMemAllocType (pctxt, QuitCommandType);

      if (pvalue->u.quit == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_QuitCommandType (pvalue->u.quit);

      stat = XmlDec_QuitCommandType (pctxt, pvalue->u.quit);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 17: { /* Realtime */
      pvalue->u.realtime
          = rtxMemAllocType (pctxt, BooleanElementType_derivations);

      if (pvalue->u.realtime == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_BooleanElementType_derivations (pvalue->u.realtime);

      stat = XmlDec_BooleanElementType_derivations (pctxt, pvalue->u.realtime
         );
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 18: { /* Recover */
      pvalue->u.recover = rtxMemAllocType (pctxt, RecoverCommandType);

      if (pvalue->u.recover == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_RecoverCommandType (pvalue->u.recover);

      stat = XmlDec_RecoverCommandType (pctxt, pvalue->u.recover);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 19: { /* SendMessage */
      pvalue->u.sendMessage = rtxMemAllocType (pctxt, SendMessageCommandType);

      if (pvalue->u.sendMessage == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SendMessageCommandType (pvalue->u.sendMessage);

      stat = XmlDec_SendMessageCommandType (pctxt, pvalue->u.sendMessage);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 20: { /* SetPlanes */
      pvalue->u.setPlanes = rtxMemAllocType (pctxt, SetPlanesCommandType);

      if (pvalue->u.setPlanes == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SetPlanesCommandType (pvalue->u.setPlanes);

      stat = XmlDec_SetPlanesCommandType (pctxt, pvalue->u.setPlanes);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 21: { /* SetPosition */
      pvalue->u.setPosition = rtxMemAllocType (pctxt, UuvPositionCommandType);

      if (pvalue->u.setPosition == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UuvPositionCommandType (pvalue->u.setPosition);

      stat = XmlDec_UuvPositionCommandType (pctxt, pvalue->u.setPosition);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 22: { /* SetPower */
      pvalue->u.setPower = rtxMemAllocType (pctxt, SetPropellerCommandType);

      if (pvalue->u.setPower == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SetPropellerCommandType (pvalue->u.setPower);

      stat = XmlDec_SetPropellerCommandType (pctxt, pvalue->u.setPower);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 23: { /* SetRudder */
      pvalue->u.setRudder = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.setRudder == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.setRudder);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.setRudder);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 24: { /* SetSonar */
      pvalue->u.setSonar = rtxMemAllocType (pctxt, SetSonarCommandType);

      if (pvalue->u.setSonar == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SetSonarCommandType (pvalue->u.setSonar);

      stat = XmlDec_SetSonarCommandType (pctxt, pvalue->u.setSonar);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 25: { /* SetStandoff */
      pvalue->u.setStandoff
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.setStandoff == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.setStandoff);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.setStandoff);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 26: { /* SetThruster */
      pvalue->u.setThruster = rtxMemAllocType (pctxt, SetThrusterCommandType);

      if (pvalue->u.setThruster == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SetThrusterCommandType (pvalue->u.setThruster);

      stat = XmlDec_SetThrusterCommandType (pctxt, pvalue->u.setThruster);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 27: { /* SetTime */
      pvalue->u.setTime = rtxMemAllocType (pctxt, ScalarElementType);

      if (pvalue->u.setTime == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_ScalarElementType (pvalue->u.setTime);

      stat = XmlDec_ScalarElementType (pctxt, pvalue->u.setTime);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 28: { /* SetTimeStep */
      pvalue->u.setTimeStep
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.setTimeStep == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.setTimeStep);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.setTimeStep);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 29: { /* TakeStation */
      pvalue->u.takeStation = rtxMemAllocType (pctxt, TakeStationCommandType);

      if (pvalue->u.takeStation == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_TakeStationCommandType (pvalue->u.takeStation);

      stat = XmlDec_TakeStationCommandType (pctxt, pvalue->u.takeStation);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 30: { /* Thrusters */
      pvalue->u.thrusters
          = rtxMemAllocType (pctxt, BooleanElementType_derivations);

      if (pvalue->u.thrusters == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_BooleanElementType_derivations (pvalue->u.thrusters);

      stat = XmlDec_BooleanElementType_derivations (pctxt, pvalue->u.thrusters
         );
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 31: { /* Trace */
      pvalue->u.trace
          = rtxMemAllocType (pctxt, BooleanElementType_derivations);

      if (pvalue->u.trace == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_BooleanElementType_derivations (pvalue->u.trace);

      stat = XmlDec_BooleanElementType_derivations (pctxt, pvalue->u.trace);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 32: { /* Wait */
      pvalue->u.wait
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.wait == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.wait);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.wait);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 33: { /* WaitUntilTime */
      pvalue->u.waitUntilTime
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.waitUntilTime == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.waitUntilTime
         );

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.waitUntilTime);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 34: { /* Waypoint */
      pvalue->u.waypoint = rtxMemAllocType (pctxt, UuvWaypointCommandType);

      if (pvalue->u.waypoint == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UuvWaypointCommandType (pvalue->u.waypoint);

      stat = XmlDec_UuvWaypointCommandType (pctxt, pvalue->u.waypoint);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UuvScriptCommandsType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UuvScriptCommandsType (OSCTXT* pctxt, 
   UuvScriptCommandsType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               UuvScriptCommandsType_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->choice_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, UuvScriptCommandsType_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_UuvScriptCommandsType_element (pdata2);

                  stat = asn1D_UuvScriptCommandsType_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->choice_list, pnode);
               }

               if (!(pvalue->choice_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "UuvScriptCommandsType.choice_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UuvScriptCommandsType (OSCTXT* pctxt, UuvScriptCommandsType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UuvScriptCommandsType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UuvScriptCommandsType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("CompositeWaypoint"), 17}, 0}, 0 },
      {{{OSUTF8("FollowBeacon"), 12}, 0}, 0 },
      {{{OSUTF8("GpsFix"), 6}, 0}, 0 },
      {{{OSUTF8("Help"), 4}, 0}, 0 },
      {{{OSUTF8("Hover"), 5}, 0}, 0 },
      {{{OSUTF8("Loiter"), 6}, 0}, 0 },
      {{{OSUTF8("MakeAltitude"), 12}, 0}, 0 },
      {{{OSUTF8("MakeDepth"), 9}, 0}, 0 },
      {{{OSUTF8("MakeHeading"), 11}, 0}, 0 },
      {{{OSUTF8("MakeKnots"), 9}, 0}, 0 },
      {{{OSUTF8("MakeSpeed"), 9}, 0}, 0 },
      {{{OSUTF8("MetaCommand"), 11}, 0}, 0 },
      {{{OSUTF8("MissionScript"), 13}, 0}, 0 },
      {{{OSUTF8("MissionScriptInline"), 19}, 0}, 0 },
      {{{OSUTF8("MoveLateral"), 11}, 0}, 0 },
      {{{OSUTF8("MoveRotate"), 10}, 0}, 0 },
      {{{OSUTF8("Quit"), 4}, 0}, 0 },
      {{{OSUTF8("Realtime"), 8}, 0}, 0 },
      {{{OSUTF8("Recover"), 7}, 0}, 0 },
      {{{OSUTF8("SendMessage"), 11}, 0}, 0 },
      {{{OSUTF8("SetPlanes"), 9}, 0}, 0 },
      {{{OSUTF8("SetPosition"), 11}, 0}, 0 },
      {{{OSUTF8("SetPower"), 8}, 0}, 0 },
      {{{OSUTF8("SetRudder"), 9}, 0}, 0 },
      {{{OSUTF8("SetSonar"), 8}, 0}, 0 },
      {{{OSUTF8("SetStandoff"), 11}, 0}, 0 },
      {{{OSUTF8("SetThruster"), 11}, 0}, 0 },
      {{{OSUTF8("SetTime"), 7}, 0}, 0 },
      {{{OSUTF8("SetTimeStep"), 11}, 0}, 0 },
      {{{OSUTF8("TakeStation"), 11}, 0}, 0 },
      {{{OSUTF8("Thrusters"), 9}, 0}, 0 },
      {{{OSUTF8("Trace"), 5}, 0}, 0 },
      {{{OSUTF8("Wait"), 4}, 0}, 0 },
      {{{OSUTF8("WaitUntilTime"), 13}, 0}, 0 },
      {{{OSUTF8("Waypoint"), 8}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 35, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         UuvScriptCommandsType_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, UuvScriptCommandsType_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_UuvScriptCommandsType_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_UuvScriptCommandsType_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->choice_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 35, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SpeedTypeElements                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SpeedTypeElements (OSCTXT* pctxt, SpeedTypeElements *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.speed
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.speed == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.speed);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.speed, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.knots
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.knots == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.knots);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.knots, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_SpeedTypeElements (OSCTXT* pctxt, SpeedTypeElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Speed"), 5}, 0}, 0 },
      {{{OSUTF8("Knots"), 5}, 0}, 1 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* Speed */
      pvalue->u.speed
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.speed == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.speed);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.speed);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* Knots */
      pvalue->u.knots
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.knots == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.knots);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.knots);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvCompositeWaypointCommandType                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UsvCompositeWaypointCommandType (OSCTXT* pctxt, 
   UsvCompositeWaypointCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CompositeWaypointElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode homingMode */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TrackModeElementType (pctxt, 
               &pvalue->homingMode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.homingModePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SpeedTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode standoff */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->standoff, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.standoffPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UsvCompositeWaypointCommandType (OSCTXT* pctxt, 
   UsvCompositeWaypointCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UsvCompositeWaypointCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UsvCompositeWaypointCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("WaypointList"), 12}, 0}, 0 },
      {{{OSUTF8("ParallelTrack"), 13}, 0}, 0 },
      {{{OSUTF8("SectorPattern"), 13}, 0}, 0 },
      {{{OSUTF8("ExpandingSquare"), 15}, 0}, 0 },
      {{{OSUTF8("HomingMode"), 10}, 0}, 1 },
      {{{OSUTF8("Speed"), 5}, 0}, 2 },
      {{{OSUTF8("Knots"), 5}, 0}, 2 },
      {{{OSUTF8("Standoff"), 8}, 0}, 3 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}, {4, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_CompositeWaypointElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* HomingMode */
         stat = XmlDec_TrackModeElementType (pctxt, &pvalue->homingMode);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.homingModePresent = TRUE;
         break;
      }
      case 2: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_SpeedTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      case 3: { /* Standoff */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            standoff);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.standoffPresent = TRUE;
         break;
      }
      case 4: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvLoiterCommandType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UsvLoiterCommandType (OSCTXT* pctxt, 
   UsvLoiterCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choicePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SpeedTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UsvLoiterCommandType (OSCTXT* pctxt, UsvLoiterCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UsvLoiterCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UsvLoiterCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 },
      {{{OSUTF8("RelativeXYPosition"), 18}, 0}, 0 },
      {{{OSUTF8("Speed"), 5}, 0}, 1 },
      {{{OSUTF8("Knots"), 5}, 0}, 1 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 6, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_HorizontalPositionElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choicePresent = TRUE;
         break;
      }
      case 1: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_SpeedTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      case 2: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvPositionCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UsvPositionCommandType (OSCTXT* pctxt, 
   UsvPositionCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AbsoluteHorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UsvPositionCommandType (OSCTXT* pctxt, 
   UsvPositionCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UsvPositionCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UsvPositionCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_AbsoluteHorizontalPositionElements (pctxt, &pvalue->
            choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvWaypointCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UsvWaypointCommandType (OSCTXT* pctxt, 
   UsvWaypointCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode homingMode */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TrackModeElementType (pctxt, 
               &pvalue->homingMode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.homingModePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SpeedTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode standoff */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->standoff, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.standoffPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UsvWaypointCommandType (OSCTXT* pctxt, 
   UsvWaypointCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UsvWaypointCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UsvWaypointCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 },
      {{{OSUTF8("RelativeXYPosition"), 18}, 0}, 0 },
      {{{OSUTF8("HomingMode"), 10}, 0}, 1 },
      {{{OSUTF8("Speed"), 5}, 0}, 2 },
      {{{OSUTF8("Knots"), 5}, 0}, 2 },
      {{{OSUTF8("Standoff"), 8}, 0}, 3 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}, {3, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_HorizontalPositionElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* HomingMode */
         stat = XmlDec_TrackModeElementType (pctxt, &pvalue->homingMode);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.homingModePresent = TRUE;
         break;
      }
      case 2: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_SpeedTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      case 3: { /* Standoff */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            standoff);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.standoffPresent = TRUE;
         break;
      }
      case 4: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvScriptCommandsType_element                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UsvScriptCommandsType_element (OSCTXT* pctxt, 
   UsvScriptCommandsType_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.compositeWaypoint
             = rtxMemAllocType (pctxt, UsvCompositeWaypointCommandType);

         if (pvalue->u.compositeWaypoint == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UsvCompositeWaypointCommandType (pvalue->u.compositeWaypoint);
         stat = asn1D_UsvCompositeWaypointCommandType (pctxt, 
            pvalue->u.compositeWaypoint, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.followBeacon
             = rtxMemAllocType (pctxt, FollowBeaconCommandType);

         if (pvalue->u.followBeacon == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_FollowBeaconCommandType (pvalue->u.followBeacon);
         stat = asn1D_FollowBeaconCommandType (pctxt, 
            pvalue->u.followBeacon, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.help = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.help == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.help);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.help, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.loiter = rtxMemAllocType (pctxt, UsvLoiterCommandType);

         if (pvalue->u.loiter == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UsvLoiterCommandType (pvalue->u.loiter);
         stat = asn1D_UsvLoiterCommandType (pctxt, 
            pvalue->u.loiter, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_CONS|4):
         pvalue->u.makeHeading = rtxMemAllocType (pctxt, HeadingElementType);

         if (pvalue->u.makeHeading == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_HeadingElementType (pvalue->u.makeHeading);
         stat = asn1D_HeadingElementType (pctxt, 
            pvalue->u.makeHeading, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_CONS|5):
         pvalue->u.makeKnots = rtxMemAllocType (pctxt, SpeedElementType);

         if (pvalue->u.makeKnots == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SpeedElementType (pvalue->u.makeKnots);
         stat = asn1D_SpeedElementType (pctxt, 
            pvalue->u.makeKnots, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_CONS|6):
         pvalue->u.makeSpeed = rtxMemAllocType (pctxt, SpeedElementType);

         if (pvalue->u.makeSpeed == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SpeedElementType (pvalue->u.makeSpeed);
         stat = asn1D_SpeedElementType (pctxt, 
            pvalue->u.makeSpeed, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_CONS|7):
         pvalue->u.metaCommand = rtxMemAllocType (pctxt, MetaDataType);

         if (pvalue->u.metaCommand == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_MetaDataType (pvalue->u.metaCommand);
         stat = asn1D_MetaDataType (pctxt, 
            pvalue->u.metaCommand, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_CONS|8):
         pvalue->u.missionScript = rtxMemAllocType (pctxt, StringElementType);

         if (pvalue->u.missionScript == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_StringElementType (pvalue->u.missionScript);
         stat = asn1D_StringElementType (pctxt, 
            pvalue->u.missionScript, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      case (TM_CTXT|TM_CONS|9):
         pvalue->u.missionScriptInline
             = rtxMemAllocType (pctxt, StringElementType);

         if (pvalue->u.missionScriptInline == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_StringElementType (pvalue->u.missionScriptInline);
         stat = asn1D_StringElementType (pctxt, 
            pvalue->u.missionScriptInline, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 10;
         break;

      case (TM_CTXT|TM_CONS|10):
         pvalue->u.quit = rtxMemAllocType (pctxt, QuitCommandType);

         if (pvalue->u.quit == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_QuitCommandType (pvalue->u.quit);
         stat = asn1D_QuitCommandType (pctxt, 
            pvalue->u.quit, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 11;
         break;

      case (TM_CTXT|TM_CONS|11):
         pvalue->u.realtime
             = rtxMemAllocType (pctxt, BooleanElementType_derivations);

         if (pvalue->u.realtime == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_BooleanElementType_derivations (pvalue->u.realtime);
         stat = asn1D_BooleanElementType_derivations (pctxt, 
            pvalue->u.realtime, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 12;
         break;

      case (TM_CTXT|TM_CONS|12):
         pvalue->u.sendMessage
             = rtxMemAllocType (pctxt, SendMessageCommandType);

         if (pvalue->u.sendMessage == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SendMessageCommandType (pvalue->u.sendMessage);
         stat = asn1D_SendMessageCommandType (pctxt, 
            pvalue->u.sendMessage, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 13;
         break;

      case (TM_CTXT|TM_CONS|13):
         pvalue->u.setPosition
             = rtxMemAllocType (pctxt, UsvPositionCommandType);

         if (pvalue->u.setPosition == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UsvPositionCommandType (pvalue->u.setPosition);
         stat = asn1D_UsvPositionCommandType (pctxt, 
            pvalue->u.setPosition, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 14;
         break;

      case (TM_CTXT|TM_CONS|14):
         pvalue->u.setPower
             = rtxMemAllocType (pctxt, SetPropellerCommandType);

         if (pvalue->u.setPower == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SetPropellerCommandType (pvalue->u.setPower);
         stat = asn1D_SetPropellerCommandType (pctxt, 
            pvalue->u.setPower, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 15;
         break;

      case (TM_CTXT|TM_CONS|15):
         pvalue->u.setRudder
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.setRudder == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.setRudder);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.setRudder, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 16;
         break;

      case (TM_CTXT|TM_CONS|16):
         pvalue->u.setStandoff
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.setStandoff == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.setStandoff);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.setStandoff, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 17;
         break;

      case (TM_CTXT|TM_CONS|17):
         pvalue->u.setTime = rtxMemAllocType (pctxt, ScalarElementType);

         if (pvalue->u.setTime == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_ScalarElementType (pvalue->u.setTime);
         stat = asn1D_ScalarElementType (pctxt, 
            pvalue->u.setTime, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 18;
         break;

      case (TM_CTXT|TM_CONS|18):
         pvalue->u.setTimeStep
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.setTimeStep == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.setTimeStep);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.setTimeStep, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 19;
         break;

      case (TM_CTXT|TM_CONS|19):
         pvalue->u.trace
             = rtxMemAllocType (pctxt, BooleanElementType_derivations);

         if (pvalue->u.trace == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_BooleanElementType_derivations (pvalue->u.trace);
         stat = asn1D_BooleanElementType_derivations (pctxt, 
            pvalue->u.trace, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 20;
         break;

      case (TM_CTXT|TM_CONS|20):
         pvalue->u.wait
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.wait == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.wait);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.wait, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 21;
         break;

      case (TM_CTXT|TM_CONS|21):
         pvalue->u.waitUntilTime
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.waitUntilTime == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.waitUntilTime);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.waitUntilTime, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 22;
         break;

      case (TM_CTXT|TM_CONS|22):
         pvalue->u.waypoint = rtxMemAllocType (pctxt, UsvWaypointCommandType);

         if (pvalue->u.waypoint == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UsvWaypointCommandType (pvalue->u.waypoint);
         stat = asn1D_UsvWaypointCommandType (pctxt, 
            pvalue->u.waypoint, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 23;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_UsvScriptCommandsType_element (OSCTXT* pctxt, 
   UsvScriptCommandsType_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("CompositeWaypoint"), 17}, 0}, 0 },
      {{{OSUTF8("FollowBeacon"), 12}, 0}, 1 },
      {{{OSUTF8("Help"), 4}, 0}, 2 },
      {{{OSUTF8("Loiter"), 6}, 0}, 3 },
      {{{OSUTF8("MakeHeading"), 11}, 0}, 4 },
      {{{OSUTF8("MakeKnots"), 9}, 0}, 5 },
      {{{OSUTF8("MakeSpeed"), 9}, 0}, 6 },
      {{{OSUTF8("MetaCommand"), 11}, 0}, 7 },
      {{{OSUTF8("MissionScript"), 13}, 0}, 8 },
      {{{OSUTF8("MissionScriptInline"), 19}, 0}, 9 },
      {{{OSUTF8("Quit"), 4}, 0}, 10 },
      {{{OSUTF8("Realtime"), 8}, 0}, 11 },
      {{{OSUTF8("SendMessage"), 11}, 0}, 12 },
      {{{OSUTF8("SetPosition"), 11}, 0}, 13 },
      {{{OSUTF8("SetPower"), 8}, 0}, 14 },
      {{{OSUTF8("SetRudder"), 9}, 0}, 15 },
      {{{OSUTF8("SetStandoff"), 11}, 0}, 16 },
      {{{OSUTF8("SetTime"), 7}, 0}, 17 },
      {{{OSUTF8("SetTimeStep"), 11}, 0}, 18 },
      {{{OSUTF8("Trace"), 5}, 0}, 19 },
      {{{OSUTF8("Wait"), 4}, 0}, 20 },
      {{{OSUTF8("WaitUntilTime"), 13}, 0}, 21 },
      {{{OSUTF8("Waypoint"), 8}, 0}, 22 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 23, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* CompositeWaypoint */
      pvalue->u.compositeWaypoint
          = rtxMemAllocType (pctxt, UsvCompositeWaypointCommandType);

      if (pvalue->u.compositeWaypoint == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UsvCompositeWaypointCommandType (pvalue->u.compositeWaypoint);

      stat = XmlDec_UsvCompositeWaypointCommandType (pctxt, pvalue->
         u.compositeWaypoint);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* FollowBeacon */
      pvalue->u.followBeacon
          = rtxMemAllocType (pctxt, FollowBeaconCommandType);

      if (pvalue->u.followBeacon == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_FollowBeaconCommandType (pvalue->u.followBeacon);

      stat = XmlDec_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* Help */
      pvalue->u.help = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.help == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.help);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.help);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* Loiter */
      pvalue->u.loiter = rtxMemAllocType (pctxt, UsvLoiterCommandType);

      if (pvalue->u.loiter == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UsvLoiterCommandType (pvalue->u.loiter);

      stat = XmlDec_UsvLoiterCommandType (pctxt, pvalue->u.loiter);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 4: { /* MakeHeading */
      pvalue->u.makeHeading = rtxMemAllocType (pctxt, HeadingElementType);

      if (pvalue->u.makeHeading == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_HeadingElementType (pvalue->u.makeHeading);

      stat = XmlDec_HeadingElementType (pctxt, pvalue->u.makeHeading);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 5: { /* MakeKnots */
      pvalue->u.makeKnots = rtxMemAllocType (pctxt, SpeedElementType);

      if (pvalue->u.makeKnots == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SpeedElementType (pvalue->u.makeKnots);

      stat = XmlDec_SpeedElementType (pctxt, pvalue->u.makeKnots);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 6: { /* MakeSpeed */
      pvalue->u.makeSpeed = rtxMemAllocType (pctxt, SpeedElementType);

      if (pvalue->u.makeSpeed == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SpeedElementType (pvalue->u.makeSpeed);

      stat = XmlDec_SpeedElementType (pctxt, pvalue->u.makeSpeed);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 7: { /* MetaCommand */
      pvalue->u.metaCommand = rtxMemAllocType (pctxt, MetaDataType);

      if (pvalue->u.metaCommand == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_MetaDataType (pvalue->u.metaCommand);

      stat = XmlDec_MetaDataType (pctxt, pvalue->u.metaCommand);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 8: { /* MissionScript */
      pvalue->u.missionScript = rtxMemAllocType (pctxt, StringElementType);

      if (pvalue->u.missionScript == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_StringElementType (pvalue->u.missionScript);

      stat = XmlDec_StringElementType (pctxt, pvalue->u.missionScript);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 9: { /* MissionScriptInline */
      pvalue->u.missionScriptInline
          = rtxMemAllocType (pctxt, StringElementType);

      if (pvalue->u.missionScriptInline == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_StringElementType (pvalue->u.missionScriptInline);

      stat = XmlDec_StringElementType (pctxt, pvalue->u.missionScriptInline);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 10: { /* Quit */
      pvalue->u.quit = rtxMemAllocType (pctxt, QuitCommandType);

      if (pvalue->u.quit == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_QuitCommandType (pvalue->u.quit);

      stat = XmlDec_QuitCommandType (pctxt, pvalue->u.quit);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 11: { /* Realtime */
      pvalue->u.realtime
          = rtxMemAllocType (pctxt, BooleanElementType_derivations);

      if (pvalue->u.realtime == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_BooleanElementType_derivations (pvalue->u.realtime);

      stat = XmlDec_BooleanElementType_derivations (pctxt, pvalue->u.realtime
         );
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 12: { /* SendMessage */
      pvalue->u.sendMessage = rtxMemAllocType (pctxt, SendMessageCommandType);

      if (pvalue->u.sendMessage == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SendMessageCommandType (pvalue->u.sendMessage);

      stat = XmlDec_SendMessageCommandType (pctxt, pvalue->u.sendMessage);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 13: { /* SetPosition */
      pvalue->u.setPosition = rtxMemAllocType (pctxt, UsvPositionCommandType);

      if (pvalue->u.setPosition == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UsvPositionCommandType (pvalue->u.setPosition);

      stat = XmlDec_UsvPositionCommandType (pctxt, pvalue->u.setPosition);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 14: { /* SetPower */
      pvalue->u.setPower = rtxMemAllocType (pctxt, SetPropellerCommandType);

      if (pvalue->u.setPower == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SetPropellerCommandType (pvalue->u.setPower);

      stat = XmlDec_SetPropellerCommandType (pctxt, pvalue->u.setPower);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 15: { /* SetRudder */
      pvalue->u.setRudder = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.setRudder == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.setRudder);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.setRudder);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 16: { /* SetStandoff */
      pvalue->u.setStandoff
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.setStandoff == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.setStandoff);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.setStandoff);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 17: { /* SetTime */
      pvalue->u.setTime = rtxMemAllocType (pctxt, ScalarElementType);

      if (pvalue->u.setTime == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_ScalarElementType (pvalue->u.setTime);

      stat = XmlDec_ScalarElementType (pctxt, pvalue->u.setTime);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 18: { /* SetTimeStep */
      pvalue->u.setTimeStep
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.setTimeStep == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.setTimeStep);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.setTimeStep);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 19: { /* Trace */
      pvalue->u.trace
          = rtxMemAllocType (pctxt, BooleanElementType_derivations);

      if (pvalue->u.trace == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_BooleanElementType_derivations (pvalue->u.trace);

      stat = XmlDec_BooleanElementType_derivations (pctxt, pvalue->u.trace);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 20: { /* Wait */
      pvalue->u.wait
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.wait == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.wait);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.wait);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 21: { /* WaitUntilTime */
      pvalue->u.waitUntilTime
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.waitUntilTime == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.waitUntilTime
         );

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.waitUntilTime);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 22: { /* Waypoint */
      pvalue->u.waypoint = rtxMemAllocType (pctxt, UsvWaypointCommandType);

      if (pvalue->u.waypoint == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UsvWaypointCommandType (pvalue->u.waypoint);

      stat = XmlDec_UsvWaypointCommandType (pctxt, pvalue->u.waypoint);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UsvScriptCommandsType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UsvScriptCommandsType (OSCTXT* pctxt, 
   UsvScriptCommandsType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               UsvScriptCommandsType_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->choice_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, UsvScriptCommandsType_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_UsvScriptCommandsType_element (pdata2);

                  stat = asn1D_UsvScriptCommandsType_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->choice_list, pnode);
               }

               if (!(pvalue->choice_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "UsvScriptCommandsType.choice_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UsvScriptCommandsType (OSCTXT* pctxt, UsvScriptCommandsType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UsvScriptCommandsType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UsvScriptCommandsType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("CompositeWaypoint"), 17}, 0}, 0 },
      {{{OSUTF8("FollowBeacon"), 12}, 0}, 0 },
      {{{OSUTF8("Help"), 4}, 0}, 0 },
      {{{OSUTF8("Loiter"), 6}, 0}, 0 },
      {{{OSUTF8("MakeHeading"), 11}, 0}, 0 },
      {{{OSUTF8("MakeKnots"), 9}, 0}, 0 },
      {{{OSUTF8("MakeSpeed"), 9}, 0}, 0 },
      {{{OSUTF8("MetaCommand"), 11}, 0}, 0 },
      {{{OSUTF8("MissionScript"), 13}, 0}, 0 },
      {{{OSUTF8("MissionScriptInline"), 19}, 0}, 0 },
      {{{OSUTF8("Quit"), 4}, 0}, 0 },
      {{{OSUTF8("Realtime"), 8}, 0}, 0 },
      {{{OSUTF8("SendMessage"), 11}, 0}, 0 },
      {{{OSUTF8("SetPosition"), 11}, 0}, 0 },
      {{{OSUTF8("SetPower"), 8}, 0}, 0 },
      {{{OSUTF8("SetRudder"), 9}, 0}, 0 },
      {{{OSUTF8("SetStandoff"), 11}, 0}, 0 },
      {{{OSUTF8("SetTime"), 7}, 0}, 0 },
      {{{OSUTF8("SetTimeStep"), 11}, 0}, 0 },
      {{{OSUTF8("Trace"), 5}, 0}, 0 },
      {{{OSUTF8("Wait"), 4}, 0}, 0 },
      {{{OSUTF8("WaitUntilTime"), 13}, 0}, 0 },
      {{{OSUTF8("Waypoint"), 8}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 23, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         UsvScriptCommandsType_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, UsvScriptCommandsType_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_UsvScriptCommandsType_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_UsvScriptCommandsType_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->choice_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 23, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvCompositeWaypointCommandType                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UgvCompositeWaypointCommandType (OSCTXT* pctxt, 
   UgvCompositeWaypointCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CompositeWaypointElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode homingMode */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TrackModeElementType (pctxt, 
               &pvalue->homingMode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.homingModePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SpeedTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode standoff */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->standoff, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.standoffPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UgvCompositeWaypointCommandType (OSCTXT* pctxt, 
   UgvCompositeWaypointCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UgvCompositeWaypointCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UgvCompositeWaypointCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("WaypointList"), 12}, 0}, 0 },
      {{{OSUTF8("ParallelTrack"), 13}, 0}, 0 },
      {{{OSUTF8("SectorPattern"), 13}, 0}, 0 },
      {{{OSUTF8("ExpandingSquare"), 15}, 0}, 0 },
      {{{OSUTF8("HomingMode"), 10}, 0}, 1 },
      {{{OSUTF8("Speed"), 5}, 0}, 2 },
      {{{OSUTF8("Knots"), 5}, 0}, 2 },
      {{{OSUTF8("Standoff"), 8}, 0}, 3 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}, {4, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_CompositeWaypointElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* HomingMode */
         stat = XmlDec_TrackModeElementType (pctxt, &pvalue->homingMode);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.homingModePresent = TRUE;
         break;
      }
      case 2: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_SpeedTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      case 3: { /* Standoff */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            standoff);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.standoffPresent = TRUE;
         break;
      }
      case 4: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvLoiterCommandType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UgvLoiterCommandType (OSCTXT* pctxt, 
   UgvLoiterCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choicePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SpeedTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UgvLoiterCommandType (OSCTXT* pctxt, UgvLoiterCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UgvLoiterCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UgvLoiterCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 },
      {{{OSUTF8("RelativeXYPosition"), 18}, 0}, 0 },
      {{{OSUTF8("Speed"), 5}, 0}, 1 },
      {{{OSUTF8("Knots"), 5}, 0}, 1 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 6, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_HorizontalPositionElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choicePresent = TRUE;
         break;
      }
      case 1: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_SpeedTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      case 2: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvPositionCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UgvPositionCommandType (OSCTXT* pctxt, 
   UgvPositionCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AbsoluteHorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UgvPositionCommandType (OSCTXT* pctxt, 
   UgvPositionCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UgvPositionCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UgvPositionCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_AbsoluteHorizontalPositionElements (pctxt, &pvalue->
            choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvWaypointCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UgvWaypointCommandType (OSCTXT* pctxt, 
   UgvWaypointCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SpeedTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode homingMode */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TrackModeElementType (pctxt, 
               &pvalue->homingMode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.homingModePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode standoff */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->standoff, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.standoffPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UgvWaypointCommandType (OSCTXT* pctxt, 
   UgvWaypointCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UgvWaypointCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UgvWaypointCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 },
      {{{OSUTF8("RelativeXYPosition"), 18}, 0}, 0 },
      {{{OSUTF8("Speed"), 5}, 0}, 1 },
      {{{OSUTF8("Knots"), 5}, 0}, 1 },
      {{{OSUTF8("HomingMode"), 10}, 0}, 2 },
      {{{OSUTF8("Standoff"), 8}, 0}, 3 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}, {3, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_HorizontalPositionElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_SpeedTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      case 2: { /* HomingMode */
         stat = XmlDec_TrackModeElementType (pctxt, &pvalue->homingMode);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.homingModePresent = TRUE;
         break;
      }
      case 3: { /* Standoff */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            standoff);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.standoffPresent = TRUE;
         break;
      }
      case 4: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvScriptCommandsType_element                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UgvScriptCommandsType_element (OSCTXT* pctxt, 
   UgvScriptCommandsType_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.compositeWaypoint
             = rtxMemAllocType (pctxt, UgvCompositeWaypointCommandType);

         if (pvalue->u.compositeWaypoint == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UgvCompositeWaypointCommandType (pvalue->u.compositeWaypoint);
         stat = asn1D_UgvCompositeWaypointCommandType (pctxt, 
            pvalue->u.compositeWaypoint, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.followBeacon
             = rtxMemAllocType (pctxt, FollowBeaconCommandType);

         if (pvalue->u.followBeacon == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_FollowBeaconCommandType (pvalue->u.followBeacon);
         stat = asn1D_FollowBeaconCommandType (pctxt, 
            pvalue->u.followBeacon, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.help = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.help == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.help);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.help, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.loiter = rtxMemAllocType (pctxt, UgvLoiterCommandType);

         if (pvalue->u.loiter == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UgvLoiterCommandType (pvalue->u.loiter);
         stat = asn1D_UgvLoiterCommandType (pctxt, 
            pvalue->u.loiter, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_CONS|4):
         pvalue->u.makeHeading = rtxMemAllocType (pctxt, HeadingElementType);

         if (pvalue->u.makeHeading == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_HeadingElementType (pvalue->u.makeHeading);
         stat = asn1D_HeadingElementType (pctxt, 
            pvalue->u.makeHeading, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_CONS|5):
         pvalue->u.makeKnots
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.makeKnots == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.makeKnots);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.makeKnots, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_CONS|6):
         pvalue->u.makeSpeed
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.makeSpeed == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.makeSpeed);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.makeSpeed, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_CONS|7):
         pvalue->u.metaCommand = rtxMemAllocType (pctxt, MetaDataType);

         if (pvalue->u.metaCommand == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_MetaDataType (pvalue->u.metaCommand);
         stat = asn1D_MetaDataType (pctxt, 
            pvalue->u.metaCommand, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_CONS|8):
         pvalue->u.missionScript = rtxMemAllocType (pctxt, StringElementType);

         if (pvalue->u.missionScript == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_StringElementType (pvalue->u.missionScript);
         stat = asn1D_StringElementType (pctxt, 
            pvalue->u.missionScript, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      case (TM_CTXT|TM_CONS|9):
         pvalue->u.missionScriptInline
             = rtxMemAllocType (pctxt, StringElementType);

         if (pvalue->u.missionScriptInline == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_StringElementType (pvalue->u.missionScriptInline);
         stat = asn1D_StringElementType (pctxt, 
            pvalue->u.missionScriptInline, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 10;
         break;

      case (TM_CTXT|TM_CONS|10):
         pvalue->u.quit = rtxMemAllocType (pctxt, QuitCommandType);

         if (pvalue->u.quit == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_QuitCommandType (pvalue->u.quit);
         stat = asn1D_QuitCommandType (pctxt, 
            pvalue->u.quit, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 11;
         break;

      case (TM_CTXT|TM_CONS|11):
         pvalue->u.realtime
             = rtxMemAllocType (pctxt, BooleanElementType_derivations);

         if (pvalue->u.realtime == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_BooleanElementType_derivations (pvalue->u.realtime);
         stat = asn1D_BooleanElementType_derivations (pctxt, 
            pvalue->u.realtime, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 12;
         break;

      case (TM_CTXT|TM_CONS|12):
         pvalue->u.sendMessage
             = rtxMemAllocType (pctxt, SendMessageCommandType);

         if (pvalue->u.sendMessage == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SendMessageCommandType (pvalue->u.sendMessage);
         stat = asn1D_SendMessageCommandType (pctxt, 
            pvalue->u.sendMessage, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 13;
         break;

      case (TM_CTXT|TM_CONS|13):
         pvalue->u.setPosition
             = rtxMemAllocType (pctxt, UgvPositionCommandType);

         if (pvalue->u.setPosition == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UgvPositionCommandType (pvalue->u.setPosition);
         stat = asn1D_UgvPositionCommandType (pctxt, 
            pvalue->u.setPosition, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 14;
         break;

      case (TM_CTXT|TM_CONS|14):
         pvalue->u.setStandoff
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.setStandoff == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.setStandoff);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.setStandoff, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 15;
         break;

      case (TM_CTXT|TM_CONS|15):
         pvalue->u.setTime = rtxMemAllocType (pctxt, ScalarElementType);

         if (pvalue->u.setTime == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_ScalarElementType (pvalue->u.setTime);
         stat = asn1D_ScalarElementType (pctxt, 
            pvalue->u.setTime, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 16;
         break;

      case (TM_CTXT|TM_CONS|16):
         pvalue->u.setTimeStep
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.setTimeStep == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.setTimeStep);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.setTimeStep, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 17;
         break;

      case (TM_CTXT|TM_CONS|17):
         pvalue->u.trace
             = rtxMemAllocType (pctxt, BooleanElementType_derivations);

         if (pvalue->u.trace == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_BooleanElementType_derivations (pvalue->u.trace);
         stat = asn1D_BooleanElementType_derivations (pctxt, 
            pvalue->u.trace, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 18;
         break;

      case (TM_CTXT|TM_CONS|18):
         pvalue->u.wait
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.wait == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.wait);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.wait, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 19;
         break;

      case (TM_CTXT|TM_CONS|19):
         pvalue->u.waitUntilTime
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.waitUntilTime == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.waitUntilTime);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.waitUntilTime, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 20;
         break;

      case (TM_CTXT|TM_CONS|20):
         pvalue->u.waypoint = rtxMemAllocType (pctxt, UgvWaypointCommandType);

         if (pvalue->u.waypoint == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UgvWaypointCommandType (pvalue->u.waypoint);
         stat = asn1D_UgvWaypointCommandType (pctxt, 
            pvalue->u.waypoint, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 21;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_UgvScriptCommandsType_element (OSCTXT* pctxt, 
   UgvScriptCommandsType_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("CompositeWaypoint"), 17}, 0}, 0 },
      {{{OSUTF8("FollowBeacon"), 12}, 0}, 1 },
      {{{OSUTF8("Help"), 4}, 0}, 2 },
      {{{OSUTF8("Loiter"), 6}, 0}, 3 },
      {{{OSUTF8("MakeHeading"), 11}, 0}, 4 },
      {{{OSUTF8("MakeKnots"), 9}, 0}, 5 },
      {{{OSUTF8("MakeSpeed"), 9}, 0}, 6 },
      {{{OSUTF8("MetaCommand"), 11}, 0}, 7 },
      {{{OSUTF8("MissionScript"), 13}, 0}, 8 },
      {{{OSUTF8("MissionScriptInline"), 19}, 0}, 9 },
      {{{OSUTF8("Quit"), 4}, 0}, 10 },
      {{{OSUTF8("Realtime"), 8}, 0}, 11 },
      {{{OSUTF8("SendMessage"), 11}, 0}, 12 },
      {{{OSUTF8("SetPosition"), 11}, 0}, 13 },
      {{{OSUTF8("SetStandoff"), 11}, 0}, 14 },
      {{{OSUTF8("SetTime"), 7}, 0}, 15 },
      {{{OSUTF8("SetTimeStep"), 11}, 0}, 16 },
      {{{OSUTF8("Trace"), 5}, 0}, 17 },
      {{{OSUTF8("Wait"), 4}, 0}, 18 },
      {{{OSUTF8("WaitUntilTime"), 13}, 0}, 19 },
      {{{OSUTF8("Waypoint"), 8}, 0}, 20 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 21, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* CompositeWaypoint */
      pvalue->u.compositeWaypoint
          = rtxMemAllocType (pctxt, UgvCompositeWaypointCommandType);

      if (pvalue->u.compositeWaypoint == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UgvCompositeWaypointCommandType (pvalue->u.compositeWaypoint);

      stat = XmlDec_UgvCompositeWaypointCommandType (pctxt, pvalue->
         u.compositeWaypoint);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* FollowBeacon */
      pvalue->u.followBeacon
          = rtxMemAllocType (pctxt, FollowBeaconCommandType);

      if (pvalue->u.followBeacon == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_FollowBeaconCommandType (pvalue->u.followBeacon);

      stat = XmlDec_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* Help */
      pvalue->u.help = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.help == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.help);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.help);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* Loiter */
      pvalue->u.loiter = rtxMemAllocType (pctxt, UgvLoiterCommandType);

      if (pvalue->u.loiter == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UgvLoiterCommandType (pvalue->u.loiter);

      stat = XmlDec_UgvLoiterCommandType (pctxt, pvalue->u.loiter);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 4: { /* MakeHeading */
      pvalue->u.makeHeading = rtxMemAllocType (pctxt, HeadingElementType);

      if (pvalue->u.makeHeading == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_HeadingElementType (pvalue->u.makeHeading);

      stat = XmlDec_HeadingElementType (pctxt, pvalue->u.makeHeading);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 5: { /* MakeKnots */
      pvalue->u.makeKnots
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.makeKnots == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.makeKnots);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.makeKnots);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 6: { /* MakeSpeed */
      pvalue->u.makeSpeed
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.makeSpeed == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.makeSpeed);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.makeSpeed);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 7: { /* MetaCommand */
      pvalue->u.metaCommand = rtxMemAllocType (pctxt, MetaDataType);

      if (pvalue->u.metaCommand == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_MetaDataType (pvalue->u.metaCommand);

      stat = XmlDec_MetaDataType (pctxt, pvalue->u.metaCommand);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 8: { /* MissionScript */
      pvalue->u.missionScript = rtxMemAllocType (pctxt, StringElementType);

      if (pvalue->u.missionScript == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_StringElementType (pvalue->u.missionScript);

      stat = XmlDec_StringElementType (pctxt, pvalue->u.missionScript);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 9: { /* MissionScriptInline */
      pvalue->u.missionScriptInline
          = rtxMemAllocType (pctxt, StringElementType);

      if (pvalue->u.missionScriptInline == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_StringElementType (pvalue->u.missionScriptInline);

      stat = XmlDec_StringElementType (pctxt, pvalue->u.missionScriptInline);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 10: { /* Quit */
      pvalue->u.quit = rtxMemAllocType (pctxt, QuitCommandType);

      if (pvalue->u.quit == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_QuitCommandType (pvalue->u.quit);

      stat = XmlDec_QuitCommandType (pctxt, pvalue->u.quit);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 11: { /* Realtime */
      pvalue->u.realtime
          = rtxMemAllocType (pctxt, BooleanElementType_derivations);

      if (pvalue->u.realtime == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_BooleanElementType_derivations (pvalue->u.realtime);

      stat = XmlDec_BooleanElementType_derivations (pctxt, pvalue->u.realtime
         );
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 12: { /* SendMessage */
      pvalue->u.sendMessage = rtxMemAllocType (pctxt, SendMessageCommandType);

      if (pvalue->u.sendMessage == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SendMessageCommandType (pvalue->u.sendMessage);

      stat = XmlDec_SendMessageCommandType (pctxt, pvalue->u.sendMessage);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 13: { /* SetPosition */
      pvalue->u.setPosition = rtxMemAllocType (pctxt, UgvPositionCommandType);

      if (pvalue->u.setPosition == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UgvPositionCommandType (pvalue->u.setPosition);

      stat = XmlDec_UgvPositionCommandType (pctxt, pvalue->u.setPosition);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 14: { /* SetStandoff */
      pvalue->u.setStandoff
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.setStandoff == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.setStandoff);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.setStandoff);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 15: { /* SetTime */
      pvalue->u.setTime = rtxMemAllocType (pctxt, ScalarElementType);

      if (pvalue->u.setTime == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_ScalarElementType (pvalue->u.setTime);

      stat = XmlDec_ScalarElementType (pctxt, pvalue->u.setTime);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 16: { /* SetTimeStep */
      pvalue->u.setTimeStep
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.setTimeStep == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.setTimeStep);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.setTimeStep);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 17: { /* Trace */
      pvalue->u.trace
          = rtxMemAllocType (pctxt, BooleanElementType_derivations);

      if (pvalue->u.trace == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_BooleanElementType_derivations (pvalue->u.trace);

      stat = XmlDec_BooleanElementType_derivations (pctxt, pvalue->u.trace);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 18: { /* Wait */
      pvalue->u.wait
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.wait == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.wait);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.wait);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 19: { /* WaitUntilTime */
      pvalue->u.waitUntilTime
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.waitUntilTime == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.waitUntilTime
         );

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.waitUntilTime);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 20: { /* Waypoint */
      pvalue->u.waypoint = rtxMemAllocType (pctxt, UgvWaypointCommandType);

      if (pvalue->u.waypoint == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UgvWaypointCommandType (pvalue->u.waypoint);

      stat = XmlDec_UgvWaypointCommandType (pctxt, pvalue->u.waypoint);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UgvScriptCommandsType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UgvScriptCommandsType (OSCTXT* pctxt, 
   UgvScriptCommandsType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               UgvScriptCommandsType_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->choice_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, UgvScriptCommandsType_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_UgvScriptCommandsType_element (pdata2);

                  stat = asn1D_UgvScriptCommandsType_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->choice_list, pnode);
               }

               if (!(pvalue->choice_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "UgvScriptCommandsType.choice_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UgvScriptCommandsType (OSCTXT* pctxt, UgvScriptCommandsType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UgvScriptCommandsType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UgvScriptCommandsType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("CompositeWaypoint"), 17}, 0}, 0 },
      {{{OSUTF8("FollowBeacon"), 12}, 0}, 0 },
      {{{OSUTF8("Help"), 4}, 0}, 0 },
      {{{OSUTF8("Loiter"), 6}, 0}, 0 },
      {{{OSUTF8("MakeHeading"), 11}, 0}, 0 },
      {{{OSUTF8("MakeKnots"), 9}, 0}, 0 },
      {{{OSUTF8("MakeSpeed"), 9}, 0}, 0 },
      {{{OSUTF8("MetaCommand"), 11}, 0}, 0 },
      {{{OSUTF8("MissionScript"), 13}, 0}, 0 },
      {{{OSUTF8("MissionScriptInline"), 19}, 0}, 0 },
      {{{OSUTF8("Quit"), 4}, 0}, 0 },
      {{{OSUTF8("Realtime"), 8}, 0}, 0 },
      {{{OSUTF8("SendMessage"), 11}, 0}, 0 },
      {{{OSUTF8("SetPosition"), 11}, 0}, 0 },
      {{{OSUTF8("SetStandoff"), 11}, 0}, 0 },
      {{{OSUTF8("SetTime"), 7}, 0}, 0 },
      {{{OSUTF8("SetTimeStep"), 11}, 0}, 0 },
      {{{OSUTF8("Trace"), 5}, 0}, 0 },
      {{{OSUTF8("Wait"), 4}, 0}, 0 },
      {{{OSUTF8("WaitUntilTime"), 13}, 0}, 0 },
      {{{OSUTF8("Waypoint"), 8}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 21, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         UgvScriptCommandsType_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, UgvScriptCommandsType_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_UgvScriptCommandsType_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_UgvScriptCommandsType_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->choice_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 21, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AltitudeTypeElements                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AltitudeTypeElements (OSCTXT* pctxt, 
   AltitudeTypeElements *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.aGLAltitude
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.aGLAltitude == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.aGLAltitude);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.aGLAltitude, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.mSLAltitude
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.mSLAltitude == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.mSLAltitude);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.mSLAltitude, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_AltitudeTypeElements (OSCTXT* pctxt, AltitudeTypeElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("AGLAltitude"), 11}, 0}, 0 },
      {{{OSUTF8("MSLAltitude"), 11}, 0}, 1 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* AGLAltitude */
      pvalue->u.aGLAltitude
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.aGLAltitude == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.aGLAltitude);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.aGLAltitude);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* MSLAltitude */
      pvalue->u.mSLAltitude
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.mSLAltitude == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.mSLAltitude);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.mSLAltitude);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavCompositeWaypointCommandType                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UavCompositeWaypointCommandType (OSCTXT* pctxt, 
   UavCompositeWaypointCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_CompositeWaypointElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AltitudeTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode homingMode */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TrackModeElementType (pctxt, 
               &pvalue->homingMode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.homingModePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode choice_2 */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SpeedTypeElements (pctxt, 
               &pvalue->choice_2, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_2Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode standoff */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->standoff, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.standoffPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 8:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UavCompositeWaypointCommandType (OSCTXT* pctxt, 
   UavCompositeWaypointCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UavCompositeWaypointCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UavCompositeWaypointCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("WaypointList"), 12}, 0}, 0 },
      {{{OSUTF8("ParallelTrack"), 13}, 0}, 0 },
      {{{OSUTF8("SectorPattern"), 13}, 0}, 0 },
      {{{OSUTF8("ExpandingSquare"), 15}, 0}, 0 },
      {{{OSUTF8("AGLAltitude"), 11}, 0}, 1 },
      {{{OSUTF8("MSLAltitude"), 11}, 0}, 1 },
      {{{OSUTF8("HomingMode"), 10}, 0}, 2 },
      {{{OSUTF8("Speed"), 5}, 0}, 3 },
      {{{OSUTF8("Knots"), 5}, 0}, 3 },
      {{{OSUTF8("Standoff"), 8}, 0}, 4 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 5 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 4, -1}, {4, 2, -1}, {6, 5, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 6; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_CompositeWaypointElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_AltitudeTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* HomingMode */
         stat = XmlDec_TrackModeElementType (pctxt, &pvalue->homingMode);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.homingModePresent = TRUE;
         break;
      }
      case 3: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_SpeedTypeElements (pctxt, &pvalue->choice_2);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_2Present = TRUE;
         break;
      }
      case 4: { /* Standoff */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            standoff);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.standoffPresent = TRUE;
         break;
      }
      case 5: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavLoiterCommandType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UavLoiterCommandType (OSCTXT* pctxt, 
   UavLoiterCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choicePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SpeedTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode choice_2 */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AltitudeTypeElements (pctxt, 
               &pvalue->choice_2, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_2Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode loiterAltitude */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->loiterAltitude, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UavLoiterCommandType (OSCTXT* pctxt, UavLoiterCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UavLoiterCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UavLoiterCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 },
      {{{OSUTF8("RelativeXYPosition"), 18}, 0}, 0 },
      {{{OSUTF8("Speed"), 5}, 0}, 1 },
      {{{OSUTF8("Knots"), 5}, 0}, 1 },
      {{{OSUTF8("AGLAltitude"), 11}, 0}, 2 },
      {{{OSUTF8("MSLAltitude"), 11}, 0}, 2 },
      {{{OSUTF8("LoiterAltitude"), 14}, 0}, 3 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 4 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 8, -1}, {8, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 5; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_HorizontalPositionElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choicePresent = TRUE;
         break;
      }
      case 1: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_SpeedTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      case 2: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_AltitudeTypeElements (pctxt, &pvalue->choice_2);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_2Present = TRUE;
         break;
      }
      case 3: { /* LoiterAltitude */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            loiterAltitude);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 4: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavPositionCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UavPositionCommandType (OSCTXT* pctxt, 
   UavPositionCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AbsoluteHorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode mSLAltitude */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ScalarElementType (pctxt, 
               &pvalue->mSLAltitude, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.mSLAltitudePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UavPositionCommandType (OSCTXT* pctxt, 
   UavPositionCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UavPositionCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UavPositionCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 },
      {{{OSUTF8("MSLAltitude"), 11}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_AbsoluteHorizontalPositionElements (pctxt, &pvalue->
            choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* MSLAltitude */
         stat = XmlDec_ScalarElementType (pctxt, &pvalue->mSLAltitude);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.mSLAltitudePresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PercentType                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PercentType (OSCTXT* pctxt, PercentType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_PercentType (OSCTXT* pctxt, PercentType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDouble (pctxt, pvalue, -1, -1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PercentElementType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PercentElementType (OSCTXT* pctxt, 
   PercentElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PercentType (pctxt, 
               &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_PercentElementType (OSCTXT* pctxt, PercentElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* value */
            stat = XmlDec_PercentType (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "PercentElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "PercentElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavWaypointCommandType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UavWaypointCommandType (OSCTXT* pctxt, 
   UavWaypointCommandType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_HorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AltitudeTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode homingMode */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TrackModeElementType (pctxt, 
               &pvalue->homingMode, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.homingModePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 6:
         /* decode choice_2 */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_SpeedTypeElements (pctxt, 
               &pvalue->choice_2, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_2Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 7:
         /* decode standoff */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->standoff, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.standoffPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 8:
         /* decode timeOut */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->timeOut, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeOutPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UavWaypointCommandType (OSCTXT* pctxt, 
   UavWaypointCommandType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UavWaypointCommandType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UavWaypointCommandType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 },
      {{{OSUTF8("RelativeXYPosition"), 18}, 0}, 0 },
      {{{OSUTF8("AGLAltitude"), 11}, 0}, 1 },
      {{{OSUTF8("MSLAltitude"), 11}, 0}, 1 },
      {{{OSUTF8("HomingMode"), 10}, 0}, 2 },
      {{{OSUTF8("Speed"), 5}, 0}, 3 },
      {{{OSUTF8("Knots"), 5}, 0}, 3 },
      {{{OSUTF8("Standoff"), 8}, 0}, 4 },
      {{{OSUTF8("TimeOut"), 7}, 0}, 5 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}, {3, 7, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 6; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_HorizontalPositionElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_AltitudeTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      case 2: { /* HomingMode */
         stat = XmlDec_TrackModeElementType (pctxt, &pvalue->homingMode);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.homingModePresent = TRUE;
         break;
      }
      case 3: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_SpeedTypeElements (pctxt, &pvalue->choice_2);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_2Present = TRUE;
         break;
      }
      case 4: { /* Standoff */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            standoff);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.standoffPresent = TRUE;
         break;
      }
      case 5: { /* TimeOut */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            timeOut);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.timeOutPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavScriptCommandsType_element                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UavScriptCommandsType_element (OSCTXT* pctxt, 
   UavScriptCommandsType_element *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.compositeWaypoint
             = rtxMemAllocType (pctxt, UavCompositeWaypointCommandType);

         if (pvalue->u.compositeWaypoint == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UavCompositeWaypointCommandType (pvalue->u.compositeWaypoint);
         stat = asn1D_UavCompositeWaypointCommandType (pctxt, 
            pvalue->u.compositeWaypoint, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.followBeacon
             = rtxMemAllocType (pctxt, FollowBeaconCommandType);

         if (pvalue->u.followBeacon == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_FollowBeaconCommandType (pvalue->u.followBeacon);
         stat = asn1D_FollowBeaconCommandType (pctxt, 
            pvalue->u.followBeacon, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.help = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.help == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.help);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.help, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.loiter = rtxMemAllocType (pctxt, UavLoiterCommandType);

         if (pvalue->u.loiter == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UavLoiterCommandType (pvalue->u.loiter);
         stat = asn1D_UavLoiterCommandType (pctxt, 
            pvalue->u.loiter, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_CONS|4):
         pvalue->u.makeAltitudeAGL
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.makeAltitudeAGL == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.makeAltitudeAGL);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.makeAltitudeAGL, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_CONS|5):
         pvalue->u.makeAltitudeMSL
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.makeAltitudeMSL == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.makeAltitudeMSL);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.makeAltitudeMSL, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_CONS|6):
         pvalue->u.makeClimbRate
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.makeClimbRate == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.makeClimbRate);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.makeClimbRate, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_CONS|7):
         pvalue->u.makeHeading = rtxMemAllocType (pctxt, HeadingElementType);

         if (pvalue->u.makeHeading == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_HeadingElementType (pvalue->u.makeHeading);
         stat = asn1D_HeadingElementType (pctxt, 
            pvalue->u.makeHeading, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_CONS|8):
         pvalue->u.makeKnots = rtxMemAllocType (pctxt, SpeedElementType);

         if (pvalue->u.makeKnots == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SpeedElementType (pvalue->u.makeKnots);
         stat = asn1D_SpeedElementType (pctxt, 
            pvalue->u.makeKnots, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      case (TM_CTXT|TM_CONS|9):
         pvalue->u.makeSpeed = rtxMemAllocType (pctxt, SpeedElementType);

         if (pvalue->u.makeSpeed == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SpeedElementType (pvalue->u.makeSpeed);
         stat = asn1D_SpeedElementType (pctxt, 
            pvalue->u.makeSpeed, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 10;
         break;

      case (TM_CTXT|TM_CONS|10):
         pvalue->u.makeTurnRate
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.makeTurnRate == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.makeTurnRate);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.makeTurnRate, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 11;
         break;

      case (TM_CTXT|TM_CONS|11):
         pvalue->u.metaCommand = rtxMemAllocType (pctxt, MetaDataType);

         if (pvalue->u.metaCommand == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_MetaDataType (pvalue->u.metaCommand);
         stat = asn1D_MetaDataType (pctxt, 
            pvalue->u.metaCommand, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 12;
         break;

      case (TM_CTXT|TM_CONS|12):
         pvalue->u.missionScript = rtxMemAllocType (pctxt, StringElementType);

         if (pvalue->u.missionScript == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_StringElementType (pvalue->u.missionScript);
         stat = asn1D_StringElementType (pctxt, 
            pvalue->u.missionScript, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 13;
         break;

      case (TM_CTXT|TM_CONS|13):
         pvalue->u.missionScriptInline
             = rtxMemAllocType (pctxt, StringElementType);

         if (pvalue->u.missionScriptInline == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_StringElementType (pvalue->u.missionScriptInline);
         stat = asn1D_StringElementType (pctxt, 
            pvalue->u.missionScriptInline, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 14;
         break;

      case (TM_CTXT|TM_CONS|14):
         pvalue->u.quit = rtxMemAllocType (pctxt, QuitCommandType);

         if (pvalue->u.quit == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_QuitCommandType (pvalue->u.quit);
         stat = asn1D_QuitCommandType (pctxt, 
            pvalue->u.quit, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 15;
         break;

      case (TM_CTXT|TM_CONS|15):
         pvalue->u.realtime
             = rtxMemAllocType (pctxt, BooleanElementType_derivations);

         if (pvalue->u.realtime == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_BooleanElementType_derivations (pvalue->u.realtime);
         stat = asn1D_BooleanElementType_derivations (pctxt, 
            pvalue->u.realtime, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 16;
         break;

      case (TM_CTXT|TM_CONS|16):
         pvalue->u.sendMessage
             = rtxMemAllocType (pctxt, SendMessageCommandType);

         if (pvalue->u.sendMessage == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SendMessageCommandType (pvalue->u.sendMessage);
         stat = asn1D_SendMessageCommandType (pctxt, 
            pvalue->u.sendMessage, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 17;
         break;

      case (TM_CTXT|TM_CONS|17):
         pvalue->u.setAileron
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.setAileron == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.setAileron);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.setAileron, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 18;
         break;

      case (TM_CTXT|TM_CONS|18):
         pvalue->u.setElevator
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.setElevator == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.setElevator);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.setElevator, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 19;
         break;

      case (TM_CTXT|TM_CONS|19):
         pvalue->u.setPosition
             = rtxMemAllocType (pctxt, UavPositionCommandType);

         if (pvalue->u.setPosition == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UavPositionCommandType (pvalue->u.setPosition);
         stat = asn1D_UavPositionCommandType (pctxt, 
            pvalue->u.setPosition, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 20;
         break;

      case (TM_CTXT|TM_CONS|20):
         pvalue->u.setPower = rtxMemAllocType (pctxt, PercentElementType);

         if (pvalue->u.setPower == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PercentElementType (pvalue->u.setPower);
         stat = asn1D_PercentElementType (pctxt, 
            pvalue->u.setPower, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 21;
         break;

      case (TM_CTXT|TM_CONS|21):
         pvalue->u.setRudder
             = rtxMemAllocType (pctxt, SignedPercentElementType);

         if (pvalue->u.setRudder == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SignedPercentElementType (pvalue->u.setRudder);
         stat = asn1D_SignedPercentElementType (pctxt, 
            pvalue->u.setRudder, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 22;
         break;

      case (TM_CTXT|TM_CONS|22):
         pvalue->u.setStandoff
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.setStandoff == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.setStandoff);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.setStandoff, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 23;
         break;

      case (TM_CTXT|TM_CONS|23):
         pvalue->u.setTime = rtxMemAllocType (pctxt, ScalarElementType);

         if (pvalue->u.setTime == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_ScalarElementType (pvalue->u.setTime);
         stat = asn1D_ScalarElementType (pctxt, 
            pvalue->u.setTime, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 24;
         break;

      case (TM_CTXT|TM_CONS|24):
         pvalue->u.setTimeStep
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.setTimeStep == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.setTimeStep);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.setTimeStep, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 25;
         break;

      case (TM_CTXT|TM_CONS|25):
         pvalue->u.trace
             = rtxMemAllocType (pctxt, BooleanElementType_derivations);

         if (pvalue->u.trace == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_BooleanElementType_derivations (pvalue->u.trace);
         stat = asn1D_BooleanElementType_derivations (pctxt, 
            pvalue->u.trace, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 26;
         break;

      case (TM_CTXT|TM_CONS|26):
         pvalue->u.wait
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.wait == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.wait);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.wait, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 27;
         break;

      case (TM_CTXT|TM_CONS|27):
         pvalue->u.waitUntilTime
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.waitUntilTime == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.waitUntilTime);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.waitUntilTime, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 28;
         break;

      case (TM_CTXT|TM_CONS|28):
         pvalue->u.waypoint = rtxMemAllocType (pctxt, UavWaypointCommandType);

         if (pvalue->u.waypoint == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_UavWaypointCommandType (pvalue->u.waypoint);
         stat = asn1D_UavWaypointCommandType (pctxt, 
            pvalue->u.waypoint, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 29;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_UavScriptCommandsType_element (OSCTXT* pctxt, 
   UavScriptCommandsType_element* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("CompositeWaypoint"), 17}, 0}, 0 },
      {{{OSUTF8("FollowBeacon"), 12}, 0}, 1 },
      {{{OSUTF8("Help"), 4}, 0}, 2 },
      {{{OSUTF8("Loiter"), 6}, 0}, 3 },
      {{{OSUTF8("MakeAltitudeAGL"), 15}, 0}, 4 },
      {{{OSUTF8("MakeAltitudeMSL"), 15}, 0}, 5 },
      {{{OSUTF8("MakeClimbRate"), 13}, 0}, 6 },
      {{{OSUTF8("MakeHeading"), 11}, 0}, 7 },
      {{{OSUTF8("MakeKnots"), 9}, 0}, 8 },
      {{{OSUTF8("MakeSpeed"), 9}, 0}, 9 },
      {{{OSUTF8("MakeTurnRate"), 12}, 0}, 10 },
      {{{OSUTF8("MetaCommand"), 11}, 0}, 11 },
      {{{OSUTF8("MissionScript"), 13}, 0}, 12 },
      {{{OSUTF8("MissionScriptInline"), 19}, 0}, 13 },
      {{{OSUTF8("Quit"), 4}, 0}, 14 },
      {{{OSUTF8("Realtime"), 8}, 0}, 15 },
      {{{OSUTF8("SendMessage"), 11}, 0}, 16 },
      {{{OSUTF8("SetAileron"), 10}, 0}, 17 },
      {{{OSUTF8("SetElevator"), 11}, 0}, 18 },
      {{{OSUTF8("SetPosition"), 11}, 0}, 19 },
      {{{OSUTF8("SetPower"), 8}, 0}, 20 },
      {{{OSUTF8("SetRudder"), 9}, 0}, 21 },
      {{{OSUTF8("SetStandoff"), 11}, 0}, 22 },
      {{{OSUTF8("SetTime"), 7}, 0}, 23 },
      {{{OSUTF8("SetTimeStep"), 11}, 0}, 24 },
      {{{OSUTF8("Trace"), 5}, 0}, 25 },
      {{{OSUTF8("Wait"), 4}, 0}, 26 },
      {{{OSUTF8("WaitUntilTime"), 13}, 0}, 27 },
      {{{OSUTF8("Waypoint"), 8}, 0}, 28 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 29, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* CompositeWaypoint */
      pvalue->u.compositeWaypoint
          = rtxMemAllocType (pctxt, UavCompositeWaypointCommandType);

      if (pvalue->u.compositeWaypoint == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UavCompositeWaypointCommandType (pvalue->u.compositeWaypoint);

      stat = XmlDec_UavCompositeWaypointCommandType (pctxt, pvalue->
         u.compositeWaypoint);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* FollowBeacon */
      pvalue->u.followBeacon
          = rtxMemAllocType (pctxt, FollowBeaconCommandType);

      if (pvalue->u.followBeacon == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_FollowBeaconCommandType (pvalue->u.followBeacon);

      stat = XmlDec_FollowBeaconCommandType (pctxt, pvalue->u.followBeacon);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* Help */
      pvalue->u.help = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.help == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.help);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.help);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* Loiter */
      pvalue->u.loiter = rtxMemAllocType (pctxt, UavLoiterCommandType);

      if (pvalue->u.loiter == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UavLoiterCommandType (pvalue->u.loiter);

      stat = XmlDec_UavLoiterCommandType (pctxt, pvalue->u.loiter);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 4: { /* MakeAltitudeAGL */
      pvalue->u.makeAltitudeAGL
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.makeAltitudeAGL == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.makeAltitudeAGL
         );

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.makeAltitudeAGL);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 5: { /* MakeAltitudeMSL */
      pvalue->u.makeAltitudeMSL
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.makeAltitudeMSL == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.makeAltitudeMSL
         );

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.makeAltitudeMSL);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 6: { /* MakeClimbRate */
      pvalue->u.makeClimbRate
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.makeClimbRate == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.makeClimbRate);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.makeClimbRate);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 7: { /* MakeHeading */
      pvalue->u.makeHeading = rtxMemAllocType (pctxt, HeadingElementType);

      if (pvalue->u.makeHeading == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_HeadingElementType (pvalue->u.makeHeading);

      stat = XmlDec_HeadingElementType (pctxt, pvalue->u.makeHeading);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 8: { /* MakeKnots */
      pvalue->u.makeKnots = rtxMemAllocType (pctxt, SpeedElementType);

      if (pvalue->u.makeKnots == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SpeedElementType (pvalue->u.makeKnots);

      stat = XmlDec_SpeedElementType (pctxt, pvalue->u.makeKnots);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 9: { /* MakeSpeed */
      pvalue->u.makeSpeed = rtxMemAllocType (pctxt, SpeedElementType);

      if (pvalue->u.makeSpeed == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SpeedElementType (pvalue->u.makeSpeed);

      stat = XmlDec_SpeedElementType (pctxt, pvalue->u.makeSpeed);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 10: { /* MakeTurnRate */
      pvalue->u.makeTurnRate
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.makeTurnRate == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.makeTurnRate);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.makeTurnRate);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 11: { /* MetaCommand */
      pvalue->u.metaCommand = rtxMemAllocType (pctxt, MetaDataType);

      if (pvalue->u.metaCommand == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_MetaDataType (pvalue->u.metaCommand);

      stat = XmlDec_MetaDataType (pctxt, pvalue->u.metaCommand);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 12: { /* MissionScript */
      pvalue->u.missionScript = rtxMemAllocType (pctxt, StringElementType);

      if (pvalue->u.missionScript == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_StringElementType (pvalue->u.missionScript);

      stat = XmlDec_StringElementType (pctxt, pvalue->u.missionScript);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 13: { /* MissionScriptInline */
      pvalue->u.missionScriptInline
          = rtxMemAllocType (pctxt, StringElementType);

      if (pvalue->u.missionScriptInline == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_StringElementType (pvalue->u.missionScriptInline);

      stat = XmlDec_StringElementType (pctxt, pvalue->u.missionScriptInline);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 14: { /* Quit */
      pvalue->u.quit = rtxMemAllocType (pctxt, QuitCommandType);

      if (pvalue->u.quit == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_QuitCommandType (pvalue->u.quit);

      stat = XmlDec_QuitCommandType (pctxt, pvalue->u.quit);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 15: { /* Realtime */
      pvalue->u.realtime
          = rtxMemAllocType (pctxt, BooleanElementType_derivations);

      if (pvalue->u.realtime == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_BooleanElementType_derivations (pvalue->u.realtime);

      stat = XmlDec_BooleanElementType_derivations (pctxt, pvalue->u.realtime
         );
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 16: { /* SendMessage */
      pvalue->u.sendMessage = rtxMemAllocType (pctxt, SendMessageCommandType);

      if (pvalue->u.sendMessage == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SendMessageCommandType (pvalue->u.sendMessage);

      stat = XmlDec_SendMessageCommandType (pctxt, pvalue->u.sendMessage);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 17: { /* SetAileron */
      pvalue->u.setAileron
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.setAileron == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.setAileron);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.setAileron);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 18: { /* SetElevator */
      pvalue->u.setElevator
          = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.setElevator == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.setElevator);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.setElevator);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 19: { /* SetPosition */
      pvalue->u.setPosition = rtxMemAllocType (pctxt, UavPositionCommandType);

      if (pvalue->u.setPosition == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UavPositionCommandType (pvalue->u.setPosition);

      stat = XmlDec_UavPositionCommandType (pctxt, pvalue->u.setPosition);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 20: { /* SetPower */
      pvalue->u.setPower = rtxMemAllocType (pctxt, PercentElementType);

      if (pvalue->u.setPower == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PercentElementType (pvalue->u.setPower);

      stat = XmlDec_PercentElementType (pctxt, pvalue->u.setPower);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 21: { /* SetRudder */
      pvalue->u.setRudder = rtxMemAllocType (pctxt, SignedPercentElementType);

      if (pvalue->u.setRudder == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SignedPercentElementType (pvalue->u.setRudder);

      stat = XmlDec_SignedPercentElementType (pctxt, pvalue->u.setRudder);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 22: { /* SetStandoff */
      pvalue->u.setStandoff
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.setStandoff == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.setStandoff);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.setStandoff);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 23: { /* SetTime */
      pvalue->u.setTime = rtxMemAllocType (pctxt, ScalarElementType);

      if (pvalue->u.setTime == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_ScalarElementType (pvalue->u.setTime);

      stat = XmlDec_ScalarElementType (pctxt, pvalue->u.setTime);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 24: { /* SetTimeStep */
      pvalue->u.setTimeStep
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.setTimeStep == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.setTimeStep);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.setTimeStep);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 25: { /* Trace */
      pvalue->u.trace
          = rtxMemAllocType (pctxt, BooleanElementType_derivations);

      if (pvalue->u.trace == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_BooleanElementType_derivations (pvalue->u.trace);

      stat = XmlDec_BooleanElementType_derivations (pctxt, pvalue->u.trace);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 26: { /* Wait */
      pvalue->u.wait
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.wait == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.wait);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.wait);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 27: { /* WaitUntilTime */
      pvalue->u.waitUntilTime
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.waitUntilTime == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.waitUntilTime
         );

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.waitUntilTime);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 28: { /* Waypoint */
      pvalue->u.waypoint = rtxMemAllocType (pctxt, UavWaypointCommandType);

      if (pvalue->u.waypoint == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_UavWaypointCommandType (pvalue->u.waypoint);

      stat = XmlDec_UavWaypointCommandType (pctxt, pvalue->u.waypoint);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UavScriptCommandsType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UavScriptCommandsType (OSCTXT* pctxt, 
   UavScriptCommandsType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               UavScriptCommandsType_element* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->choice_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, UavScriptCommandsType_element, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_UavScriptCommandsType_element (pdata2);

                  stat = asn1D_UavScriptCommandsType_element (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->choice_list, pnode);
               }

               if (!(pvalue->choice_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "UavScriptCommandsType.choice_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->choice_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_UavScriptCommandsType (OSCTXT* pctxt, UavScriptCommandsType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "UavScriptCommandsType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "UavScriptCommandsType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("CompositeWaypoint"), 17}, 0}, 0 },
      {{{OSUTF8("FollowBeacon"), 12}, 0}, 0 },
      {{{OSUTF8("Help"), 4}, 0}, 0 },
      {{{OSUTF8("Loiter"), 6}, 0}, 0 },
      {{{OSUTF8("MakeAltitudeAGL"), 15}, 0}, 0 },
      {{{OSUTF8("MakeAltitudeMSL"), 15}, 0}, 0 },
      {{{OSUTF8("MakeClimbRate"), 13}, 0}, 0 },
      {{{OSUTF8("MakeHeading"), 11}, 0}, 0 },
      {{{OSUTF8("MakeKnots"), 9}, 0}, 0 },
      {{{OSUTF8("MakeSpeed"), 9}, 0}, 0 },
      {{{OSUTF8("MakeTurnRate"), 12}, 0}, 0 },
      {{{OSUTF8("MetaCommand"), 11}, 0}, 0 },
      {{{OSUTF8("MissionScript"), 13}, 0}, 0 },
      {{{OSUTF8("MissionScriptInline"), 19}, 0}, 0 },
      {{{OSUTF8("Quit"), 4}, 0}, 0 },
      {{{OSUTF8("Realtime"), 8}, 0}, 0 },
      {{{OSUTF8("SendMessage"), 11}, 0}, 0 },
      {{{OSUTF8("SetAileron"), 10}, 0}, 0 },
      {{{OSUTF8("SetElevator"), 11}, 0}, 0 },
      {{{OSUTF8("SetPosition"), 11}, 0}, 0 },
      {{{OSUTF8("SetPower"), 8}, 0}, 0 },
      {{{OSUTF8("SetRudder"), 9}, 0}, 0 },
      {{{OSUTF8("SetStandoff"), 11}, 0}, 0 },
      {{{OSUTF8("SetTime"), 7}, 0}, 0 },
      {{{OSUTF8("SetTimeStep"), 11}, 0}, 0 },
      {{{OSUTF8("Trace"), 5}, 0}, 0 },
      {{{OSUTF8("Wait"), 4}, 0}, 0 },
      {{{OSUTF8("WaitUntilTime"), 13}, 0}, 0 },
      {{{OSUTF8("Waypoint"), 8}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 29, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         UavScriptCommandsType_element* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, UavScriptCommandsType_element);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_UavScriptCommandsType_element (pdata1);

            rtXmlpMarkLastEventActive (pctxt);

            stat = XmlDec_UavScriptCommandsType_element (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->choice_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 29, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AbsoluteHorizontalPositionElementType                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AbsoluteHorizontalPositionElementType (OSCTXT* pctxt, 
   AbsoluteHorizontalPositionElementType *pvalue, ASN1TagType tagging, 
   int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AbsoluteHorizontalPositionElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AbsoluteHorizontalPositionElementType (OSCTXT* pctxt, 
   AbsoluteHorizontalPositionElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "AbsoluteHorizontalPositionElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "AbsoluteHorizontalPositionElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_AbsoluteHorizontalPositionElements (pctxt, &pvalue->
            choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  WeaponStatusType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_WeaponStatusType (OSCTXT* pctxt, WeaponStatusType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 2)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_WeaponStatusType (OSCTXT* pctxt, WeaponStatusType* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = WeaponStatusType_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ActionObjectElementType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ActionObjectElementType (OSCTXT* pctxt, 
   ActionObjectElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_ActionObjectElementType (OSCTXT* pctxt, 
   ActionObjectElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("name"), 4}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* name */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->name);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 3: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "ActionObjectElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "ActionObjectElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AttackElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AttackElementType (OSCTXT* pctxt, AttackElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   pvalue->disableOnly = FALSE;
   pvalue->singleTarget = FALSE;

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode disableOnly */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->disableOnly, ASN1IMPL, length);
            if (stat == 0) {
            }
         }
         break;

      case 2:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode singleTarget */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->singleTarget, ASN1IMPL, length);
            if (stat == 0) {
            }
         }
         break;

      case 4:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode weaponStatus */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_WeaponStatusType (pctxt, 
               &pvalue->weaponStatus, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode target_list */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ActionObjectElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->target_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ActionObjectElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ActionObjectElementType (pdata2);

                  stat = asn1D_ActionObjectElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->target_list, pnode);
               }

               if (!(pvalue->target_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "AttackElementType.target_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->target_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|6):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AttackElementType (OSCTXT* pctxt, AttackElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("disableOnly"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("singleTarget"), 12}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("weaponStatus"), 12}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 6, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* disableOnly */
            stat = rtXmlpDecBool (pctxt, &pvalue->disableOnly);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 2: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 3: /* singleTarget */
            stat = rtXmlpDecBool (pctxt, &pvalue->singleTarget);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 4: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 5: /* weaponStatus */
            stat = XmlDec_WeaponStatusType (pctxt, &pvalue->weaponStatus);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "AttackElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "AttackElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Target"), 6}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         ActionObjectElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ActionObjectElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ActionObjectElementType (pdata1);

            stat = XmlDec_ActionObjectElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->target_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ContaminantType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ContaminantType (OSCTXT* pctxt, ContaminantType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 4)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_ContaminantType (OSCTXT* pctxt, ContaminantType* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = ContaminantType_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ContaminantElementType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ContaminantElementType (OSCTXT* pctxt, 
   ContaminantElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode type */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ContaminantType (pctxt, 
               &pvalue->type, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_ContaminantElementType (OSCTXT* pctxt, 
   ContaminantElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("type"), 4}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* type */
            stat = XmlDec_ContaminantType (pctxt, &pvalue->type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "ContaminantElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "ContaminantElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DecontaminateElementType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DecontaminateElementType (OSCTXT* pctxt, 
   DecontaminateElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode contaminant_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ContaminantElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->contaminant_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ContaminantElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ContaminantElementType (pdata2);

                  stat = asn1D_ContaminantElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->contaminant_list, pnode);
               }

               if (!(pvalue->contaminant_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "DecontaminateElementType.contaminant_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->contaminant_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_DecontaminateElementType (OSCTXT* pctxt, 
   DecontaminateElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "DecontaminateElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "DecontaminateElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Contaminant"), 11}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         ContaminantElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ContaminantElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ContaminantElementType (pdata1);

            stat = XmlDec_ContaminantElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->contaminant_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DemolishElementType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DemolishElementType (OSCTXT* pctxt, 
   DemolishElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   pvalue->permanentDisable = TRUE;
   pvalue->singleTarget = FALSE;

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode permanentDisable */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->permanentDisable, ASN1IMPL, length);
            if (stat == 0) {
            }
         }
         break;

      case 3:
         /* decode singleTarget */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->singleTarget, ASN1IMPL, length);
            if (stat == 0) {
            }
         }
         break;

      case 4:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode target_list */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ActionObjectElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->target_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ActionObjectElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ActionObjectElementType (pdata2);

                  stat = asn1D_ActionObjectElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->target_list, pnode);
               }

               if (!(pvalue->target_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "DemolishElementType.target_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->target_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_DemolishElementType (OSCTXT* pctxt, DemolishElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("permanentDisable"), 16}, 0 },
         { {OSUTF8("singleTarget"), 12}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* permanentDisable */
            stat = rtXmlpDecBool (pctxt, &pvalue->permanentDisable);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 3: /* singleTarget */
            stat = rtXmlpDecBool (pctxt, &pvalue->singleTarget);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 4: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "DemolishElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "DemolishElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Target"), 6}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         ActionObjectElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ActionObjectElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ActionObjectElementType (pdata1);

            stat = XmlDec_ActionObjectElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->target_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IlluminatorType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_IlluminatorType (OSCTXT* pctxt, IlluminatorType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_IlluminatorType (OSCTXT* pctxt, IlluminatorType* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = IlluminatorType_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IlluminatorElementType                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_IlluminatorElementType (OSCTXT* pctxt, 
   IlluminatorElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode type */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_IlluminatorType (pctxt, 
               &pvalue->type, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode illuminatorCharacteristic_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               StringElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->illuminatorCharacteristic_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, StringElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_StringElementType (pdata2);

                  stat = asn1D_StringElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->illuminatorCharacteristic_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_IlluminatorElementType (OSCTXT* pctxt, 
   IlluminatorElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("type"), 4}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* type */
            stat = XmlDec_IlluminatorType (pctxt, &pvalue->type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "IlluminatorElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "IlluminatorElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("IlluminatorCharacteristic"), 25}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         StringElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, StringElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_StringElementType (pdata1);

            stat = XmlDec_StringElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->illuminatorCharacteristic_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IlluminateElementType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_IlluminateElementType (OSCTXT* pctxt, 
   IlluminateElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode illuminator */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_IlluminatorElementType (pctxt, 
               &pvalue->illuminator, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_IlluminateElementType (OSCTXT* pctxt, IlluminateElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "IlluminateElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "IlluminateElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Illuminator"), 11}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Illuminator */
         stat = XmlDec_IlluminatorElementType (pctxt, &pvalue->illuminator);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FrequencyRangeElementType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_FrequencyRangeElementType (OSCTXT* pctxt, 
   FrequencyRangeElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode maxFrequency */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarType (pctxt, 
               &pvalue->maxFrequency, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode minFrequency */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->minFrequency, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_FrequencyRangeElementType (OSCTXT* pctxt, 
   FrequencyRangeElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("maxFrequency"), 12}, 0 },
         { {OSUTF8("minFrequency"), 12}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* maxFrequency */
            stat = XmlDec_PositiveScalarType (pctxt, &pvalue->maxFrequency);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 3: /* minFrequency */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->minFrequency
               );
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 4: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "FrequencyRangeElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "FrequencyRangeElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  JamElementType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_JamElementType (OSCTXT* pctxt, JamElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode frequencyRange_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               FrequencyRangeElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->frequencyRange_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, FrequencyRangeElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_FrequencyRangeElementType (pdata2);

                  stat = asn1D_FrequencyRangeElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->frequencyRange_list, pnode);
               }

               if (!(pvalue->frequencyRange_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "JamElementType.frequencyRange_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->frequencyRange_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_JamElementType (OSCTXT* pctxt, JamElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "JamElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "JamElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("FrequencyRange"), 14}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         FrequencyRangeElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, FrequencyRangeElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_FrequencyRangeElementType (pdata1);

            stat = XmlDec_FrequencyRangeElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->frequencyRange_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MarkerType                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MarkerType (OSCTXT* pctxt, MarkerType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_MarkerType (OSCTXT* pctxt, MarkerType* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = MarkerType_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MarkerElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MarkerElementType (OSCTXT* pctxt, MarkerElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode type */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_MarkerType (pctxt, 
               &pvalue->type, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode markerCharacteristic_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               StringElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->markerCharacteristic_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, StringElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_StringElementType (pdata2);

                  stat = asn1D_StringElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->markerCharacteristic_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_MarkerElementType (OSCTXT* pctxt, MarkerElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("type"), 4}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 3: /* type */
            stat = XmlDec_MarkerType (pctxt, &pvalue->type);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "MarkerElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "MarkerElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("MarkerCharacteristic"), 20}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         StringElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, StringElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_StringElementType (pdata1);

            stat = XmlDec_StringElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->markerCharacteristic_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MarkElementType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MarkElementType (OSCTXT* pctxt, MarkElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode marker */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_MarkerElementType (pctxt, 
               &pvalue->marker, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode target_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ActionObjectElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->target_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ActionObjectElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ActionObjectElementType (pdata2);

                  stat = asn1D_ActionObjectElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->target_list, pnode);
               }

               if (!(pvalue->target_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "MarkElementType.target_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->target_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_MarkElementType (OSCTXT* pctxt, MarkElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "MarkElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "MarkElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Marker"), 6}, 0}, 0 },
      {{{OSUTF8("Target"), 6}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Marker */
         stat = XmlDec_MarkerElementType (pctxt, &pvalue->marker);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: {
         ActionObjectElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ActionObjectElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ActionObjectElementType (pdata1);

            stat = XmlDec_ActionObjectElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->target_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MonitorTransmissionsElementType                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MonitorTransmissionsElementType (OSCTXT* pctxt, 
   MonitorTransmissionsElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode frequencyRange_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               FrequencyRangeElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->frequencyRange_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, FrequencyRangeElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_FrequencyRangeElementType (pdata2);

                  stat = asn1D_FrequencyRangeElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->frequencyRange_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_MonitorTransmissionsElementType (OSCTXT* pctxt, 
   MonitorTransmissionsElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "MonitorTransmissionsElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "MonitorTransmissionsElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("FrequencyRange"), 14}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         FrequencyRangeElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, FrequencyRangeElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_FrequencyRangeElementType (pdata1);

            stat = XmlDec_FrequencyRangeElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->frequencyRange_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PatrolElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PatrolElementType (OSCTXT* pctxt, PatrolElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode qualifier_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               StringElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->qualifier_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, StringElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_StringElementType (pdata2);

                  stat = asn1D_StringElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->qualifier_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_PatrolElementType (OSCTXT* pctxt, PatrolElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "PatrolElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "PatrolElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Qualifier"), 9}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         StringElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, StringElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_StringElementType (pdata1);

            stat = XmlDec_StringElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->qualifier_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RendezvousElementType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RendezvousElementType (OSCTXT* pctxt, 
   RendezvousElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode targetVehicleID */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->targetVehicleID, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode qualifier_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               StringElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->qualifier_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, StringElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_StringElementType (pdata2);

                  stat = asn1D_StringElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->qualifier_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_RendezvousElementType (OSCTXT* pctxt, RendezvousElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("targetVehicleID"), 15}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 4, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* targetVehicleID */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->targetVehicleID);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 3: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "RendezvousElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "RendezvousElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Qualifier"), 9}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         StringElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, StringElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_StringElementType (pdata1);

            stat = XmlDec_StringElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->qualifier_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SampleEnvironmentElementType                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SampleEnvironmentElementType (OSCTXT* pctxt, 
   SampleEnvironmentElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode contaminant_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ContaminantElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->contaminant_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ContaminantElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ContaminantElementType (pdata2);

                  stat = asn1D_ContaminantElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->contaminant_list, pnode);
               }

               if (!(pvalue->contaminant_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "SampleEnvironmentElementType.contaminant_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->contaminant_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SampleEnvironmentElementType (OSCTXT* pctxt, 
   SampleEnvironmentElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SampleEnvironmentElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SampleEnvironmentElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Contaminant"), 11}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         ContaminantElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ContaminantElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ContaminantElementType (pdata1);

            stat = XmlDec_ContaminantElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->contaminant_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DatumTypeType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DatumTypeType (OSCTXT* pctxt, DatumTypeType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 1)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_DatumTypeType (OSCTXT* pctxt, DatumTypeType* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = DatumTypeType_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SearchElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_SearchElementType (OSCTXT* pctxt, SearchElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   pvalue->singleTarget = FALSE;

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode datumType */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_DatumTypeType (pctxt, 
               &pvalue->datumType, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 1:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode requiredPD */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PercentType (pctxt, 
               &pvalue->requiredPD, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode singleTarget */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->singleTarget, ASN1IMPL, length);
            if (stat == 0) {
            }
         }
         break;

      case 5:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode searchTarget_list */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ActionObjectElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->searchTarget_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ActionObjectElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ActionObjectElementType (pdata2);

                  stat = asn1D_ActionObjectElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->searchTarget_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|6):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_SearchElementType (OSCTXT* pctxt, SearchElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("datumType"), 9}, 0 },
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("requiredPD"), 10}, 0 },
         { {OSUTF8("singleTarget"), 12}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 6, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* datumType */
            stat = XmlDec_DatumTypeType (pctxt, &pvalue->datumType);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 2: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 3: /* requiredPD */
            stat = XmlDec_PercentType (pctxt, &pvalue->requiredPD);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 4: /* singleTarget */
            stat = rtXmlpDecBool (pctxt, &pvalue->singleTarget);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 5: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "SearchElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "SearchElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("SearchTarget"), 12}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         ActionObjectElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ActionObjectElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ActionObjectElementType (pdata1);

            stat = XmlDec_ActionObjectElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->searchTarget_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GoalElements                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_GoalElements (OSCTXT* pctxt, GoalElements *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.attack = rtxMemAllocType (pctxt, AttackElementType);

         if (pvalue->u.attack == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_AttackElementType (pvalue->u.attack);
         stat = asn1D_AttackElementType (pctxt, 
            pvalue->u.attack, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.decontaminate
             = rtxMemAllocType (pctxt, DecontaminateElementType);

         if (pvalue->u.decontaminate == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_DecontaminateElementType (pvalue->u.decontaminate);
         stat = asn1D_DecontaminateElementType (pctxt, 
            pvalue->u.decontaminate, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.demolish = rtxMemAllocType (pctxt, DemolishElementType);

         if (pvalue->u.demolish == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_DemolishElementType (pvalue->u.demolish);
         stat = asn1D_DemolishElementType (pctxt, 
            pvalue->u.demolish, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.illuminateArea
             = rtxMemAllocType (pctxt, IlluminateElementType);

         if (pvalue->u.illuminateArea == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_IlluminateElementType (pvalue->u.illuminateArea);
         stat = asn1D_IlluminateElementType (pctxt, 
            pvalue->u.illuminateArea, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_CONS|4):
         pvalue->u.jam = rtxMemAllocType (pctxt, JamElementType);

         if (pvalue->u.jam == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_JamElementType (pvalue->u.jam);
         stat = asn1D_JamElementType (pctxt, 
            pvalue->u.jam, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      case (TM_CTXT|TM_CONS|5):
         pvalue->u.markTarget = rtxMemAllocType (pctxt, MarkElementType);

         if (pvalue->u.markTarget == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_MarkElementType (pvalue->u.markTarget);
         stat = asn1D_MarkElementType (pctxt, 
            pvalue->u.markTarget, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 6;
         break;

      case (TM_CTXT|TM_CONS|6):
         pvalue->u.monitorTransmissions
             = rtxMemAllocType (pctxt, MonitorTransmissionsElementType);

         if (pvalue->u.monitorTransmissions == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_MonitorTransmissionsElementType (pvalue->u.monitorTransmissions);
         stat = asn1D_MonitorTransmissionsElementType (pctxt, 
            pvalue->u.monitorTransmissions, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 7;
         break;

      case (TM_CTXT|TM_CONS|7):
         pvalue->u.patrol = rtxMemAllocType (pctxt, PatrolElementType);

         if (pvalue->u.patrol == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PatrolElementType (pvalue->u.patrol);
         stat = asn1D_PatrolElementType (pctxt, 
            pvalue->u.patrol, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 8;
         break;

      case (TM_CTXT|TM_CONS|8):
         pvalue->u.rendezvous
             = rtxMemAllocType (pctxt, RendezvousElementType);

         if (pvalue->u.rendezvous == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_RendezvousElementType (pvalue->u.rendezvous);
         stat = asn1D_RendezvousElementType (pctxt, 
            pvalue->u.rendezvous, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 9;
         break;

      case (TM_CTXT|TM_CONS|9):
         pvalue->u.reposition = rtxMemAllocType (pctxt, NoValueElementType);

         if (pvalue->u.reposition == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NoValueElementType (pvalue->u.reposition);
         stat = asn1D_NoValueElementType (pctxt, 
            pvalue->u.reposition, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 10;
         break;

      case (TM_CTXT|TM_CONS|10):
         pvalue->u.sampleEnvironment
             = rtxMemAllocType (pctxt, SampleEnvironmentElementType);

         if (pvalue->u.sampleEnvironment == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SampleEnvironmentElementType (pvalue->u.sampleEnvironment);
         stat = asn1D_SampleEnvironmentElementType (pctxt, 
            pvalue->u.sampleEnvironment, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 11;
         break;

      case (TM_CTXT|TM_CONS|11):
         pvalue->u.search = rtxMemAllocType (pctxt, SearchElementType);

         if (pvalue->u.search == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_SearchElementType (pvalue->u.search);
         stat = asn1D_SearchElementType (pctxt, 
            pvalue->u.search, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 12;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_GoalElements (OSCTXT* pctxt, GoalElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Attack"), 6}, 0}, 0 },
      {{{OSUTF8("Decontaminate"), 13}, 0}, 1 },
      {{{OSUTF8("Demolish"), 8}, 0}, 2 },
      {{{OSUTF8("IlluminateArea"), 14}, 0}, 3 },
      {{{OSUTF8("Jam"), 3}, 0}, 4 },
      {{{OSUTF8("MarkTarget"), 10}, 0}, 5 },
      {{{OSUTF8("MonitorTransmissions"), 20}, 0}, 6 },
      {{{OSUTF8("Patrol"), 6}, 0}, 7 },
      {{{OSUTF8("Rendezvous"), 10}, 0}, 8 },
      {{{OSUTF8("Reposition"), 10}, 0}, 9 },
      {{{OSUTF8("SampleEnvironment"), 17}, 0}, 10 },
      {{{OSUTF8("Search"), 6}, 0}, 11 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 12, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* Attack */
      pvalue->u.attack = rtxMemAllocType (pctxt, AttackElementType);

      if (pvalue->u.attack == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_AttackElementType (pvalue->u.attack);

      stat = XmlDec_AttackElementType (pctxt, pvalue->u.attack);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* Decontaminate */
      pvalue->u.decontaminate
          = rtxMemAllocType (pctxt, DecontaminateElementType);

      if (pvalue->u.decontaminate == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_DecontaminateElementType (pvalue->u.decontaminate);

      stat = XmlDec_DecontaminateElementType (pctxt, pvalue->u.decontaminate);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* Demolish */
      pvalue->u.demolish = rtxMemAllocType (pctxt, DemolishElementType);

      if (pvalue->u.demolish == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_DemolishElementType (pvalue->u.demolish);

      stat = XmlDec_DemolishElementType (pctxt, pvalue->u.demolish);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* IlluminateArea */
      pvalue->u.illuminateArea
          = rtxMemAllocType (pctxt, IlluminateElementType);

      if (pvalue->u.illuminateArea == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_IlluminateElementType (pvalue->u.illuminateArea);

      stat = XmlDec_IlluminateElementType (pctxt, pvalue->u.illuminateArea);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 4: { /* Jam */
      pvalue->u.jam = rtxMemAllocType (pctxt, JamElementType);

      if (pvalue->u.jam == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_JamElementType (pvalue->u.jam);

      stat = XmlDec_JamElementType (pctxt, pvalue->u.jam);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 5: { /* MarkTarget */
      pvalue->u.markTarget = rtxMemAllocType (pctxt, MarkElementType);

      if (pvalue->u.markTarget == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_MarkElementType (pvalue->u.markTarget);

      stat = XmlDec_MarkElementType (pctxt, pvalue->u.markTarget);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 6: { /* MonitorTransmissions */
      pvalue->u.monitorTransmissions
          = rtxMemAllocType (pctxt, MonitorTransmissionsElementType);

      if (pvalue->u.monitorTransmissions == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_MonitorTransmissionsElementType (pvalue->u.monitorTransmissions
         );

      stat = XmlDec_MonitorTransmissionsElementType (pctxt, pvalue->
         u.monitorTransmissions);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 7: { /* Patrol */
      pvalue->u.patrol = rtxMemAllocType (pctxt, PatrolElementType);

      if (pvalue->u.patrol == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PatrolElementType (pvalue->u.patrol);

      stat = XmlDec_PatrolElementType (pctxt, pvalue->u.patrol);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 8: { /* Rendezvous */
      pvalue->u.rendezvous = rtxMemAllocType (pctxt, RendezvousElementType);

      if (pvalue->u.rendezvous == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_RendezvousElementType (pvalue->u.rendezvous);

      stat = XmlDec_RendezvousElementType (pctxt, pvalue->u.rendezvous);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 9: { /* Reposition */
      pvalue->u.reposition = rtxMemAllocType (pctxt, NoValueElementType);

      if (pvalue->u.reposition == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NoValueElementType (pvalue->u.reposition);

      stat = XmlDec_NoValueElementType (pctxt, pvalue->u.reposition);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 10: { /* SampleEnvironment */
      pvalue->u.sampleEnvironment
          = rtxMemAllocType (pctxt, SampleEnvironmentElementType);

      if (pvalue->u.sampleEnvironment == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SampleEnvironmentElementType (pvalue->u.sampleEnvironment);

      stat = XmlDec_SampleEnvironmentElementType (pctxt, pvalue->
         u.sampleEnvironment);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 11: { /* Search */
      pvalue->u.search = rtxMemAllocType (pctxt, SearchElementType);

      if (pvalue->u.search == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_SearchElementType (pvalue->u.search);

      stat = XmlDec_SearchElementType (pctxt, pvalue->u.search);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CircleElementType                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_CircleElementType (OSCTXT* pctxt, CircleElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode center */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AbsoluteHorizontalPositionElementType (pctxt, 
               &pvalue->center, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode radius */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->radius, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_CircleElementType (OSCTXT* pctxt, CircleElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "CircleElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "CircleElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Center"), 6}, 0}, 0 },
      {{{OSUTF8("Radius"), 6}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* Center */
         stat = XmlDec_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->
            center);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* Radius */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            radius);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AreaOrientationType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AreaOrientationType (OSCTXT* pctxt, 
   AreaOrientationType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

int XmlDec_AreaOrientationType (OSCTXT* pctxt, AreaOrientationType* pvalue)
{
   int stat = 0;

   stat = rtXmlpDecDouble (pctxt, pvalue, -1, -1);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AreaOrientationElementType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AreaOrientationElementType (OSCTXT* pctxt, 
   AreaOrientationElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AreaOrientationType (pctxt, 
               &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AreaOrientationElementType (OSCTXT* pctxt, 
   AreaOrientationElementType* pvalue)
{
   int stat = 0;

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 1, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* value */
            stat = XmlDec_AreaOrientationType (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "AreaOrientationElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "AreaOrientationElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RectangleElementType                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RectangleElementType (OSCTXT* pctxt, 
   RectangleElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode northwestCorner */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AbsoluteHorizontalPositionElementType (pctxt, 
               &pvalue->northwestCorner, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode width */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->width, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode height */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
               &pvalue->height, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode orientation */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AreaOrientationElementType (pctxt, 
               &pvalue->orientation, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.orientationPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_RectangleElementType (OSCTXT* pctxt, RectangleElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "RectangleElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "RectangleElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("NorthwestCorner"), 15}, 0}, 0 },
      {{{OSUTF8("Width"), 5}, 0}, 1 },
      {{{OSUTF8("Height"), 6}, 0}, 2 },
      {{{OSUTF8("Orientation"), 11}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* NorthwestCorner */
         stat = XmlDec_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->
            northwestCorner);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* Width */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            width);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: { /* Height */
         stat = XmlDec_PositiveScalarElementType_derivations (pctxt, &pvalue->
            height);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: { /* Orientation */
         stat = XmlDec_AreaOrientationElementType (pctxt, &pvalue->orientation
            );
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.orientationPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PolygonElementType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PolygonElementType (OSCTXT* pctxt, 
   PolygonElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PointListElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_PolygonElementType (OSCTXT* pctxt, PolygonElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "PolygonElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "PolygonElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_PointListElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LimitingLineElementType                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_LimitingLineElementType (OSCTXT* pctxt, 
   LimitingLineElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PointListElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_LimitingLineElementType (OSCTXT* pctxt, 
   LimitingLineElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "LimitingLineElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "LimitingLineElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 2, -1}, {2, 0, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_PointListElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AreaElements                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AreaElements (OSCTXT* pctxt, AreaElements *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.point
             = rtxMemAllocType (pctxt, AbsoluteHorizontalPositionElementType);

         if (pvalue->u.point == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_AbsoluteHorizontalPositionElementType (pvalue->u.point);
         stat = asn1D_AbsoluteHorizontalPositionElementType (pctxt, 
            pvalue->u.point, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.circle = rtxMemAllocType (pctxt, CircleElementType);

         if (pvalue->u.circle == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_CircleElementType (pvalue->u.circle);
         stat = asn1D_CircleElementType (pctxt, 
            pvalue->u.circle, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.rectangle = rtxMemAllocType (pctxt, RectangleElementType);

         if (pvalue->u.rectangle == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_RectangleElementType (pvalue->u.rectangle);
         stat = asn1D_RectangleElementType (pctxt, 
            pvalue->u.rectangle, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.polygon = rtxMemAllocType (pctxt, PolygonElementType);

         if (pvalue->u.polygon == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PolygonElementType (pvalue->u.polygon);
         stat = asn1D_PolygonElementType (pctxt, 
            pvalue->u.polygon, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      case (TM_CTXT|TM_CONS|4):
         pvalue->u.limitingLine
             = rtxMemAllocType (pctxt, LimitingLineElementType);

         if (pvalue->u.limitingLine == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_LimitingLineElementType (pvalue->u.limitingLine);
         stat = asn1D_LimitingLineElementType (pctxt, 
            pvalue->u.limitingLine, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 5;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_AreaElements (OSCTXT* pctxt, AreaElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Point"), 5}, 0}, 0 },
      {{{OSUTF8("Circle"), 6}, 0}, 1 },
      {{{OSUTF8("Rectangle"), 9}, 0}, 2 },
      {{{OSUTF8("Polygon"), 7}, 0}, 3 },
      {{{OSUTF8("LimitingLine"), 12}, 0}, 4 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 5, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* Point */
      pvalue->u.point
          = rtxMemAllocType (pctxt, AbsoluteHorizontalPositionElementType);

      if (pvalue->u.point == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_AbsoluteHorizontalPositionElementType (pvalue->u.point);

      stat = XmlDec_AbsoluteHorizontalPositionElementType (pctxt, pvalue->
         u.point);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* Circle */
      pvalue->u.circle = rtxMemAllocType (pctxt, CircleElementType);

      if (pvalue->u.circle == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_CircleElementType (pvalue->u.circle);

      stat = XmlDec_CircleElementType (pctxt, pvalue->u.circle);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* Rectangle */
      pvalue->u.rectangle = rtxMemAllocType (pctxt, RectangleElementType);

      if (pvalue->u.rectangle == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_RectangleElementType (pvalue->u.rectangle);

      stat = XmlDec_RectangleElementType (pctxt, pvalue->u.rectangle);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: { /* Polygon */
      pvalue->u.polygon = rtxMemAllocType (pctxt, PolygonElementType);

      if (pvalue->u.polygon == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PolygonElementType (pvalue->u.polygon);

      stat = XmlDec_PolygonElementType (pctxt, pvalue->u.polygon);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 4: { /* LimitingLine */
      pvalue->u.limitingLine
          = rtxMemAllocType (pctxt, LimitingLineElementType);

      if (pvalue->u.limitingLine == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_LimitingLineElementType (pvalue->u.limitingLine);

      stat = XmlDec_LimitingLineElementType (pctxt, pvalue->u.limitingLine);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NumericalBlockElementType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NumericalBlockElementType (OSCTXT* pctxt, 
   NumericalBlockElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode maximum */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarType (pctxt, 
               &pvalue->maximum, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode minimum */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->minimum, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_NumericalBlockElementType (OSCTXT* pctxt, 
   NumericalBlockElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("maximum"), 7}, 0 },
         { {OSUTF8("minimum"), 7}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* maximum */
            stat = XmlDec_PositiveScalarType (pctxt, &pvalue->maximum);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 3: /* minimum */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->minimum);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 4: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "NumericalBlockElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "NumericalBlockElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DepthBlockElements                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DepthBlockElements (OSCTXT* pctxt, 
   DepthBlockElements *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.depthBlock
             = rtxMemAllocType (pctxt, NumericalBlockElementType);

         if (pvalue->u.depthBlock == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NumericalBlockElementType (pvalue->u.depthBlock);
         stat = asn1D_NumericalBlockElementType (pctxt, 
            pvalue->u.depthBlock, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.altitudeBlock
             = rtxMemAllocType (pctxt, NumericalBlockElementType);

         if (pvalue->u.altitudeBlock == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NumericalBlockElementType (pvalue->u.altitudeBlock);
         stat = asn1D_NumericalBlockElementType (pctxt, 
            pvalue->u.altitudeBlock, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.depthAltitudeBlock
             = rtxMemAllocType (pctxt, NumericalBlockElementType);

         if (pvalue->u.depthAltitudeBlock == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NumericalBlockElementType (pvalue->u.depthAltitudeBlock);
         stat = asn1D_NumericalBlockElementType (pctxt, 
            pvalue->u.depthAltitudeBlock, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_DepthBlockElements (OSCTXT* pctxt, DepthBlockElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("DepthBlock"), 10}, 0}, 0 },
      {{{OSUTF8("AltitudeBlock"), 13}, 0}, 1 },
      {{{OSUTF8("DepthAltitudeBlock"), 18}, 0}, 2 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 3, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* DepthBlock */
      pvalue->u.depthBlock
          = rtxMemAllocType (pctxt, NumericalBlockElementType);

      if (pvalue->u.depthBlock == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NumericalBlockElementType (pvalue->u.depthBlock);

      stat = XmlDec_NumericalBlockElementType (pctxt, pvalue->u.depthBlock);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* AltitudeBlock */
      pvalue->u.altitudeBlock
          = rtxMemAllocType (pctxt, NumericalBlockElementType);

      if (pvalue->u.altitudeBlock == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NumericalBlockElementType (pvalue->u.altitudeBlock);

      stat = XmlDec_NumericalBlockElementType (pctxt, pvalue->u.altitudeBlock
         );
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* DepthAltitudeBlock */
      pvalue->u.depthAltitudeBlock
          = rtxMemAllocType (pctxt, NumericalBlockElementType);

      if (pvalue->u.depthAltitudeBlock == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NumericalBlockElementType (pvalue->u.depthAltitudeBlock);

      stat = XmlDec_NumericalBlockElementType (pctxt, pvalue->
         u.depthAltitudeBlock);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AltitudeBlockElements                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AltitudeBlockElements (OSCTXT* pctxt, 
   AltitudeBlockElements *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.aGLAltitudeBlock
             = rtxMemAllocType (pctxt, NumericalBlockElementType);

         if (pvalue->u.aGLAltitudeBlock == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NumericalBlockElementType (pvalue->u.aGLAltitudeBlock);
         stat = asn1D_NumericalBlockElementType (pctxt, 
            pvalue->u.aGLAltitudeBlock, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.mSLAltitudeBlock
             = rtxMemAllocType (pctxt, NumericalBlockElementType);

         if (pvalue->u.mSLAltitudeBlock == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NumericalBlockElementType (pvalue->u.mSLAltitudeBlock);
         stat = asn1D_NumericalBlockElementType (pctxt, 
            pvalue->u.mSLAltitudeBlock, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.aGLMSLAltitudeBlock
             = rtxMemAllocType (pctxt, NumericalBlockElementType);

         if (pvalue->u.aGLMSLAltitudeBlock == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_NumericalBlockElementType (pvalue->u.aGLMSLAltitudeBlock);
         stat = asn1D_NumericalBlockElementType (pctxt, 
            pvalue->u.aGLMSLAltitudeBlock, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_AltitudeBlockElements (OSCTXT* pctxt, AltitudeBlockElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("AGLAltitudeBlock"), 16}, 0}, 0 },
      {{{OSUTF8("MSLAltitudeBlock"), 16}, 0}, 1 },
      {{{OSUTF8("AGLMSLAltitudeBlock"), 19}, 0}, 2 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 3, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* AGLAltitudeBlock */
      pvalue->u.aGLAltitudeBlock
          = rtxMemAllocType (pctxt, NumericalBlockElementType);

      if (pvalue->u.aGLAltitudeBlock == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NumericalBlockElementType (pvalue->u.aGLAltitudeBlock);

      stat = XmlDec_NumericalBlockElementType (pctxt, pvalue->
         u.aGLAltitudeBlock);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* MSLAltitudeBlock */
      pvalue->u.mSLAltitudeBlock
          = rtxMemAllocType (pctxt, NumericalBlockElementType);

      if (pvalue->u.mSLAltitudeBlock == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NumericalBlockElementType (pvalue->u.mSLAltitudeBlock);

      stat = XmlDec_NumericalBlockElementType (pctxt, pvalue->
         u.mSLAltitudeBlock);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: { /* AGLMSLAltitudeBlock */
      pvalue->u.aGLMSLAltitudeBlock
          = rtxMemAllocType (pctxt, NumericalBlockElementType);

      if (pvalue->u.aGLMSLAltitudeBlock == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_NumericalBlockElementType (pvalue->u.aGLMSLAltitudeBlock);

      stat = XmlDec_NumericalBlockElementType (pctxt, pvalue->
         u.aGLMSLAltitudeBlock);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VerticalBlockElements                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_VerticalBlockElements (OSCTXT* pctxt, 
   VerticalBlockElements *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.choice = rtxMemAllocType (pctxt, DepthTypeElements);

         if (pvalue->u.choice == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_DepthTypeElements (pvalue->u.choice);
         stat = asn1D_DepthTypeElements (pctxt, 
            pvalue->u.choice, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.choice_1 = rtxMemAllocType (pctxt, AltitudeTypeElements);

         if (pvalue->u.choice_1 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_AltitudeTypeElements (pvalue->u.choice_1);
         stat = asn1D_AltitudeTypeElements (pctxt, 
            pvalue->u.choice_1, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      case (TM_CTXT|TM_CONS|2):
         pvalue->u.choice_2 = rtxMemAllocType (pctxt, DepthBlockElements);

         if (pvalue->u.choice_2 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_DepthBlockElements (pvalue->u.choice_2);
         stat = asn1D_DepthBlockElements (pctxt, 
            pvalue->u.choice_2, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 3;
         break;

      case (TM_CTXT|TM_CONS|3):
         pvalue->u.choice_3 = rtxMemAllocType (pctxt, AltitudeBlockElements);

         if (pvalue->u.choice_3 == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_AltitudeBlockElements (pvalue->u.choice_3);
         stat = asn1D_AltitudeBlockElements (pctxt, 
            pvalue->u.choice_3, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 4;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_VerticalBlockElements (OSCTXT* pctxt, VerticalBlockElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Depth"), 5}, 0}, 0 },
      {{{OSUTF8("Altitude"), 8}, 0}, 0 },
      {{{OSUTF8("AGLAltitude"), 11}, 0}, 1 },
      {{{OSUTF8("MSLAltitude"), 11}, 0}, 1 },
      {{{OSUTF8("DepthBlock"), 10}, 0}, 2 },
      {{{OSUTF8("AltitudeBlock"), 13}, 0}, 2 },
      {{{OSUTF8("DepthAltitudeBlock"), 18}, 0}, 2 },
      {{{OSUTF8("AGLAltitudeBlock"), 16}, 0}, 3 },
      {{{OSUTF8("MSLAltitudeBlock"), 16}, 0}, 3 },
      {{{OSUTF8("AGLMSLAltitudeBlock"), 19}, 0}, 3 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 10, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: {
      rtXmlpMarkLastEventActive (pctxt);

      pvalue->u.choice = rtxMemAllocType (pctxt, DepthTypeElements);

      if (pvalue->u.choice == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_DepthTypeElements (pvalue->u.choice);

      stat = XmlDec_DepthTypeElements (pctxt, pvalue->u.choice);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: {
      rtXmlpMarkLastEventActive (pctxt);

      pvalue->u.choice_1 = rtxMemAllocType (pctxt, AltitudeTypeElements);

      if (pvalue->u.choice_1 == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_AltitudeTypeElements (pvalue->u.choice_1);

      stat = XmlDec_AltitudeTypeElements (pctxt, pvalue->u.choice_1);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 2: {
      rtXmlpMarkLastEventActive (pctxt);

      pvalue->u.choice_2 = rtxMemAllocType (pctxt, DepthBlockElements);

      if (pvalue->u.choice_2 == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_DepthBlockElements (pvalue->u.choice_2);

      stat = XmlDec_DepthBlockElements (pctxt, pvalue->u.choice_2);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 3: {
      rtXmlpMarkLastEventActive (pctxt);

      pvalue->u.choice_3 = rtxMemAllocType (pctxt, AltitudeBlockElements);

      if (pvalue->u.choice_3 == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_AltitudeBlockElements (pvalue->u.choice_3);

      stat = XmlDec_AltitudeBlockElements (pctxt, pvalue->u.choice_3);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AreaElementType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AreaElementType (OSCTXT* pctxt, AreaElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AreaElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choicePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_VerticalBlockElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AreaElementType (OSCTXT* pctxt, AreaElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "AreaElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "AreaElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Point"), 5}, 0}, 0 },
      {{{OSUTF8("Circle"), 6}, 0}, 0 },
      {{{OSUTF8("Rectangle"), 9}, 0}, 0 },
      {{{OSUTF8("Polygon"), 7}, 0}, 0 },
      {{{OSUTF8("LimitingLine"), 12}, 0}, 0 },
      {{{OSUTF8("Depth"), 5}, 0}, 1 },
      {{{OSUTF8("Altitude"), 8}, 0}, 1 },
      {{{OSUTF8("AGLAltitude"), 11}, 0}, 1 },
      {{{OSUTF8("MSLAltitude"), 11}, 0}, 1 },
      {{{OSUTF8("DepthBlock"), 10}, 0}, 1 },
      {{{OSUTF8("AltitudeBlock"), 13}, 0}, 1 },
      {{{OSUTF8("DepthAltitudeBlock"), 18}, 0}, 1 },
      {{{OSUTF8("AGLAltitudeBlock"), 16}, 0}, 1 },
      {{{OSUTF8("MSLAltitudeBlock"), 16}, 0}, 1 },
      {{{OSUTF8("AGLMSLAltitudeBlock"), 19}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 15, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_AreaElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choicePresent = TRUE;
         break;
      }
      case 1: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_VerticalBlockElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AbsoluteTimingElementType                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AbsoluteTimingElementType (OSCTXT* pctxt, 
   AbsoluteTimingElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode start */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->start, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode stop */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarType (pctxt, 
               &pvalue->stop, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 4:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 2) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AbsoluteTimingElementType (OSCTXT* pctxt, 
   AbsoluteTimingElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("start"), 5}, 0 },
         { {OSUTF8("stop"), 4}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* start */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->start);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 3: /* stop */
            stat = XmlDec_PositiveScalarType (pctxt, &pvalue->stop);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 4: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "AbsoluteTimingElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "AbsoluteTimingElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TimingTypeElements                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TimingTypeElements (OSCTXT* pctxt, 
   TimingTypeElements *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1TAG ctag;
   ASN1CCB ccb;

   /* decode CHOICE */

   stat = xd_tag_len (pctxt, &ctag, &length, XM_ADVANCE);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   switch (ctag)
   {
      case (TM_CTXT|TM_CONS|0):
         pvalue->u.duration
             = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

         if (pvalue->u.duration == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_PositiveScalarElementType_derivations (pvalue->u.duration);
         stat = asn1D_PositiveScalarElementType_derivations (pctxt, 
            pvalue->u.duration, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 1;
         break;

      case (TM_CTXT|TM_CONS|1):
         pvalue->u.timing
             = rtxMemAllocType (pctxt, AbsoluteTimingElementType);

         if (pvalue->u.timing == NULL)
            return LOG_RTERR (pctxt, RTERR_NOMEM);

         asn1Init_AbsoluteTimingElementType (pvalue->u.timing);
         stat = asn1D_AbsoluteTimingElementType (pctxt, 
            pvalue->u.timing, ASN1IMPL, length);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->t = 2;
         break;

      default:
         xu_addTagErrParm (pctxt, ctag);
         return LOG_RTERR (pctxt, RTERR_INVOPT);
   }

   if (ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }

   return (stat);
}

int XmlDec_TimingTypeElements (OSCTXT* pctxt, TimingTypeElements* pvalue)
{
   int stat = 0;

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Duration"), 8}, 0}, 0 },
      {{{OSUTF8("Timing"), 6}, 0}, 1 }
   } ;
   pvalue->t = 0;
   elemID = rtXmlpGetNextElemID (pctxt, elemtab, 2, -1, TRUE);
   if (elemID < 0) return LOG_RTERR (pctxt, elemID);

   switch (elemID) {
   case 0: { /* Duration */
      pvalue->u.duration
          = rtxMemAllocType (pctxt, PositiveScalarElementType_derivations);

      if (pvalue->u.duration == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_PositiveScalarElementType_derivations (pvalue->u.duration);

      stat = XmlDec_PositiveScalarElementType_derivations (pctxt, pvalue->
         u.duration);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   case 1: { /* Timing */
      pvalue->u.timing = rtxMemAllocType (pctxt, AbsoluteTimingElementType);

      if (pvalue->u.timing == NULL)
         return LOG_RTERR (pctxt, RTERR_NOMEM);

      asn1Init_AbsoluteTimingElementType (pvalue->u.timing);

      stat = XmlDec_AbsoluteTimingElementType (pctxt, pvalue->u.timing);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      stat = rtXmlpMatchEndTag (pctxt, -1);
      if (stat < 0) return LOG_RTERR (pctxt, stat);

      break;
   }
   }
   if (elemID == XML_OK_EOB) return LOG_RTERR (pctxt, RTERR_INVOPT);
   else pvalue->t = elemID + 1;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ReportingCriteriaType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ReportingCriteriaType (OSCTXT* pctxt, 
   ReportingCriteriaType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_enum (pctxt, (OSINT32*)pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if(*pvalue < 0 || *pvalue > 4)
      return LOG_RTERR (pctxt, RTERR_INVENUM);

   return (stat);
}

int XmlDec_ReportingCriteriaType (OSCTXT* pctxt, ReportingCriteriaType* pvalue)
{
   int stat = 0;

   { const OSUTF8CHAR* strval;
   stat = rtXmlpDecDynUTF8Str (pctxt, &strval);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   stat = ReportingCriteriaType_ToEnum (pctxt, strval, pvalue);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   rtxMemFreePtr (pctxt, (void*)strval);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ReportingCriteriaElementType                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ReportingCriteriaElementType (OSCTXT* pctxt, 
   ReportingCriteriaElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode periodicity */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PositiveScalarType (pctxt, 
               &pvalue->periodicity, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.periodicityPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode value */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_ReportingCriteriaType (pctxt, 
               &pvalue->value, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_PRIM|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_ReportingCriteriaElementType (OSCTXT* pctxt, 
   ReportingCriteriaElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("periodicity"), 11}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 },
         { {OSUTF8("value"), 5}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 5, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* periodicity */
            stat = XmlDec_PositiveScalarType (pctxt, &pvalue->periodicity);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.periodicityPresent = TRUE;
            break;

         case 3: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         case 4: /* value */
            stat = XmlDec_ReportingCriteriaType (pctxt, &pvalue->value);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "ReportingCriteriaElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "ReportingCriteriaElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AgendaGoalElementType                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AgendaGoalElementType (OSCTXT* pctxt, 
   AgendaGoalElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   pvalue->alert = FALSE;

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode alert */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_boolean (pctxt, &pvalue->alert, ASN1IMPL, length);
            if (stat == 0) {
            }
         }
         break;

      case 1:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 3:
         /* decode nextOnFail */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->nextOnFail, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.nextOnFailPresent = TRUE;
            }
         }
         break;

      case 4:
         /* decode nextOnSucceed */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->nextOnSucceed, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.nextOnSucceedPresent = TRUE;
            }
         }
         break;

      case 5:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 6:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_GoalElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 7:
         /* decode operatingArea */
         if (XD_PEEKTAG (pctxt, 0x87)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AreaElementType (pctxt, 
               &pvalue->operatingArea, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 8:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x88)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_TimingTypeElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 9:
         /* decode reportingCriteria_list */
         if (XD_PEEKTAG (pctxt, 0x89)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               ReportingCriteriaElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->reportingCriteria_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, ReportingCriteriaElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_ReportingCriteriaElementType (pdata2);

                  stat = asn1D_ReportingCriteriaElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->reportingCriteria_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|2):
         case (TM_CTXT|TM_PRIM|3):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_PRIM|4):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_PRIM|5):
         case (TM_CTXT|TM_CONS|6):
         case (TM_CTXT|TM_CONS|7):
         case (TM_CTXT|TM_CONS|8):
         case (TM_CTXT|TM_CONS|9):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 5) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AgendaGoalElementType (OSCTXT* pctxt, AgendaGoalElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("alert"), 5}, 0 },
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("nextOnFail"), 10}, 0 },
         { {OSUTF8("nextOnSucceed"), 13}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 6, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* alert */
            stat = rtXmlpDecBool (pctxt, &pvalue->alert);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 1: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 2: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            break;

         case 3: /* nextOnFail */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->nextOnFail);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.nextOnFailPresent = TRUE;
            break;

         case 4: /* nextOnSucceed */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->nextOnSucceed);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.nextOnSucceedPresent = TRUE;
            break;

         case 5: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "AgendaGoalElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "AgendaGoalElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Attack"), 6}, 0}, 0 },
      {{{OSUTF8("Decontaminate"), 13}, 0}, 0 },
      {{{OSUTF8("Demolish"), 8}, 0}, 0 },
      {{{OSUTF8("IlluminateArea"), 14}, 0}, 0 },
      {{{OSUTF8("Jam"), 3}, 0}, 0 },
      {{{OSUTF8("MarkTarget"), 10}, 0}, 0 },
      {{{OSUTF8("MonitorTransmissions"), 20}, 0}, 0 },
      {{{OSUTF8("Patrol"), 6}, 0}, 0 },
      {{{OSUTF8("Rendezvous"), 10}, 0}, 0 },
      {{{OSUTF8("Reposition"), 10}, 0}, 0 },
      {{{OSUTF8("SampleEnvironment"), 17}, 0}, 0 },
      {{{OSUTF8("Search"), 6}, 0}, 0 },
      {{{OSUTF8("OperatingArea"), 13}, 0}, 1 },
      {{{OSUTF8("Duration"), 8}, 0}, 2 },
      {{{OSUTF8("Timing"), 6}, 0}, 2 },
      {{{OSUTF8("ReportingCriteria"), 17}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 12, -1}, {12, 1, -1}, {13, 2, -1}, {15, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_GoalElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 1: { /* OperatingArea */
         stat = XmlDec_AreaElementType (pctxt, &pvalue->operatingArea);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 2: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_TimingTypeElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         break;
      }
      case 3: {
         ReportingCriteriaElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, ReportingCriteriaElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_ReportingCriteriaElementType (pdata1);

            stat = XmlDec_ReportingCriteriaElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->reportingCriteria_list
               , (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 15, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 3);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AgendaGoalListType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AgendaGoalListType (OSCTXT* pctxt, 
   AgendaGoalListType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode goal_list */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               AgendaGoalElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->goal_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, AgendaGoalElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_AgendaGoalElementType (pdata2);

                  stat = asn1D_AgendaGoalElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->goal_list, pnode);
               }

               if (!(pvalue->goal_list.count >= 1U)) {
                  rtxErrAddStrParm (pctxt, "AgendaGoalListType.goal_list.count");
                  rtxErrAddIntParm (pctxt, (int)pvalue->goal_list.count);
                  return LOG_RTERR (pctxt, RTERR_CONSVIO);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AgendaGoalListType (OSCTXT* pctxt, AgendaGoalListType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "AgendaGoalListType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "AgendaGoalListType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("Goal"), 4}, 0}, 0 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 1; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         AgendaGoalElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, AgendaGoalElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_AgendaGoalElementType (pdata1);

            stat = XmlDec_AgendaGoalElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->goal_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 0, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 0);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RouteElementType                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_RouteElementType (OSCTXT* pctxt, RouteElementType *pvalue, 
   ASN1TagType tagging, int length)
{
   int stat = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode choice */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_PointListElements (pctxt, 
               &pvalue->choice, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choicePresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode choice_1 */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_VerticalBlockElements (pctxt, 
               &pvalue->choice_1, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.choice_1Present = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_RouteElementType (OSCTXT* pctxt, RouteElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "RouteElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "RouteElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LatitudeLongitude"), 17}, 0}, 0 },
      {{{OSUTF8("XYPosition"), 10}, 0}, 0 },
      {{{OSUTF8("Depth"), 5}, 0}, 1 },
      {{{OSUTF8("Altitude"), 8}, 0}, 1 },
      {{{OSUTF8("AGLAltitude"), 11}, 0}, 1 },
      {{{OSUTF8("MSLAltitude"), 11}, 0}, 1 },
      {{{OSUTF8("DepthBlock"), 10}, 0}, 1 },
      {{{OSUTF8("AltitudeBlock"), 13}, 0}, 1 },
      {{{OSUTF8("DepthAltitudeBlock"), 18}, 0}, 1 },
      {{{OSUTF8("AGLAltitudeBlock"), 16}, 0}, 1 },
      {{{OSUTF8("MSLAltitudeBlock"), 16}, 0}, 1 },
      {{{OSUTF8("AGLMSLAltitudeBlock"), 19}, 0}, 1 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 12, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 2; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_PointListElements (pctxt, &pvalue->choice);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choicePresent = TRUE;
         break;
      }
      case 1: {
         rtXmlpMarkLastEventActive (pctxt);

         stat = XmlDec_VerticalBlockElements (pctxt, &pvalue->choice_1);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.choice_1Present = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AgendaConstraintListType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AgendaConstraintListType (OSCTXT* pctxt, 
   AgendaConstraintListType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode ingressRouting */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_RouteElementType (pctxt, 
               &pvalue->ingressRouting, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.ingressRoutingPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode avoidArea_list */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            /* decode inline SEQUENCE OF type */
            {
               int stat = 0;
               AreaElementType* pdata2;
               OSRTDListNode* pnode;
               ASN1CCB ccb;

               /* decode SEQUENCE OF or SET OF */

               rtxDListInit (&pvalue->avoidArea_list);

               ccb.len = length;
               ccb.ptr = OSRTBUFPTR(pctxt);

               while (!XD_CHKEND (pctxt, &ccb))
               {
                  rtxDListAllocNodeAndData (pctxt, AreaElementType, &pnode, &pdata2);

                  if (pnode == NULL)
                     return LOG_RTERR (pctxt, RTERR_NOMEM);

                  asn1Init_AreaElementType (pdata2);

                  stat = asn1D_AreaElementType (pctxt, 
                     pdata2, ASN1EXPL, length);
                  if (stat != 0) return LOG_RTERR (pctxt, stat);

                  rtxDListAppendNode (&pvalue->avoidArea_list, pnode);
               }

            }
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 5:
         /* decode egressRouting */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_RouteElementType (pctxt, 
               &pvalue->egressRouting, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.egressRoutingPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AgendaConstraintListType (OSCTXT* pctxt, 
   AgendaConstraintListType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "AgendaConstraintListType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "AgendaConstraintListType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("IngressRouting"), 14}, 0}, 0 },
      {{{OSUTF8("AvoidArea"), 9}, 0}, 1 },
      {{{OSUTF8("EgressRouting"), 13}, 0}, 2 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 3; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* IngressRouting */
         stat = XmlDec_RouteElementType (pctxt, &pvalue->ingressRouting);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.ingressRoutingPresent = TRUE;
         break;
      }
      case 1: {
         AreaElementType* pdata1;
         do {
            pdata1 = rtxMemAllocType (pctxt, AreaElementType);

            if (pdata1 == NULL)
               return LOG_RTERR (pctxt, RTERR_NOMEM);

            asn1Init_AreaElementType (pdata1);

            stat = XmlDec_AreaElementType (pctxt, pdata1);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = rtXmlpMatchEndTag (pctxt, -1);
            if (stat < 0) return LOG_RTERR (pctxt, stat);

            rtxDListAppend (pctxt, &pvalue->avoidArea_list, (void*)pdata1);

            stat = rtXmlpGetNextElemID (pctxt, elemtab + 1, 1, -1, FALSE);
            if (stat < 0 && stat != RTERR_UNEXPELEM)
               return LOG_RTERR (pctxt, stat);
         }
         while (stat == 1);

         rtXmlpMarkLastEventActive (pctxt);
         stat = 0;
         break;
      }
      case 2: { /* EgressRouting */
         stat = XmlDec_RouteElementType (pctxt, &pvalue->egressRouting);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.egressRoutingPresent = TRUE;
         break;
      }
      }
      i = elemID;
   }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AgendaMissionElementType                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AgendaMissionElementType (OSCTXT* pctxt, 
   AgendaMissionElementType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode description */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->description, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.descriptionPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode id */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = xd_utf8str (pctxt, &pvalue->id, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.idPresent = TRUE;
            }
         }
         break;

      case 2:
         /* decode timeStamp */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NonNegativeScalarType (pctxt, 
               &pvalue->timeStamp, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.timeStampPresent = TRUE;
            }
         }
         break;

      case 3:
         /* decode launchPosition */
         if (XD_PEEKTAG (pctxt, 0x83)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AbsoluteHorizontalPositionElementType (pctxt, 
               &pvalue->launchPosition, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.launchPositionPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 4:
         /* decode recoveryPosition */
         if (XD_PEEKTAG (pctxt, 0x84)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AbsoluteHorizontalPositionElementType (pctxt, 
               &pvalue->recoveryPosition, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.recoveryPositionPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      case 5:
         /* decode goalList */
         if (XD_PEEKTAG (pctxt, 0x85)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AgendaGoalListType (pctxt, 
               &pvalue->goalList, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

            reqcnt++;
         }
         break;

      case 6:
         /* decode constraintList */
         if (XD_PEEKTAG (pctxt, 0x86)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AgendaConstraintListType (pctxt, 
               &pvalue->constraintList, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.constraintListPresent = TRUE;
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
         }
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_PRIM|2):
         case (TM_CTXT|TM_CONS|3):
         case (TM_CTXT|TM_CONS|4):
         case (TM_CTXT|TM_CONS|5):
         case (TM_CTXT|TM_CONS|6):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

int XmlDec_AgendaMissionElementType (OSCTXT* pctxt, 
   AgendaMissionElementType* pvalue)
{
   int stat = 0;

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode attributes */
   if (rtXmlpHasAttributes (pctxt)) {
      static const OSXMLAttrDescr attrNames[] = {
         { {OSUTF8("description"), 11}, 0 },
         { {OSUTF8("id"), 2}, 0 },
         { {OSUTF8("timeStamp"), 9}, 0 }
      } ;
      OSUINT32 attrPresent[1];
      size_t i, nAttrs = 0;
      OSXMLNameFragments attrName;
      int tabidx;

      memset (attrPresent, 0, sizeof(attrPresent));

      stat = rtXmlpGetAttributeCount (pctxt);
      if (stat < 0) return LOG_RTERR (pctxt, stat);
      else nAttrs = (size_t)stat;

      for (i = 0; i < nAttrs; i++) {
         if (rtXmlpSelectAttribute (pctxt, &attrName, i) != 0) continue;
         tabidx = rtXmlpGetAttributeID (pctxt, 
            &attrName.mLocalName, 3, attrNames, attrPresent);

         switch (tabidx) {
         case 0: /* description */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->description);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.descriptionPresent = TRUE;
            break;

         case 1: /* id */
            stat = rtXmlpDecDynUTF8Str (pctxt, &pvalue->id);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.idPresent = TRUE;
            break;

         case 2: /* timeStamp */
            stat = XmlDec_NonNegativeScalarType (pctxt, &pvalue->timeStamp);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            pvalue->m.timeStampPresent = TRUE;
            break;

         default:
            stat = rtXmlpDecXSIAttr (pctxt, &attrName);
            if (stat != 0) {
               rtxErrAddStrParm (pctxt, "AgendaMissionElementType");
               rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
                  attrName.mQName.length);
               LOG_RTERRNEW (pctxt, RTERR_INVATTR);
               stat = 0;
            }
         }
         if (stat < 0) {
            rtxErrAddStrParm (pctxt, "AgendaMissionElementType");
            rtxErrAddStrnParm (pctxt, (const char*)attrName.mQName.value, 
               attrName.mQName.length);
            LOG_RTERRNEW (pctxt, RTERR_DECATTRFAIL);
            stat = 0;
         }
      }
   }

   { int elemID;

   static const OSXMLElemIDRec elemtab[] = {
      {{{OSUTF8("LaunchPosition"), 14}, 0}, 0 },
      {{{OSUTF8("RecoveryPosition"), 16}, 0}, 1 },
      {{{OSUTF8("GoalList"), 8}, 0}, 2 },
      {{{OSUTF8("ConstraintList"), 14}, 0}, 3 }
   } ;
   static const struct {
      int row;
      int num;
      int anyCase;
   } groupDesc[] = { {0, 3, -1}, {3, 1, -1}};

   int group = 0;
   int i;
   for (i = 0; i < 4; i++) {
      int fromrow = groupDesc[group].row;
      int rows = groupDesc[group].num;
      int anyCase = groupDesc[group].anyCase;

      elemID = rtXmlpGetNextElemID (pctxt, 
         elemtab + fromrow, rows, -1, FALSE);
      if (elemID == RTERR_UNEXPELEM && anyCase >= 0 && i == anyCase)
         elemID = anyCase;
      else if (elemID < 0) return LOG_RTERR (pctxt, elemID);
      else if (elemID == XML_OK_EOB) break;
      else if (elemID == elemtab[fromrow + rows - 1].id) group++;

      switch (elemID) {
      case 0: { /* LaunchPosition */
         stat = XmlDec_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->
            launchPosition);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.launchPositionPresent = TRUE;
         break;
      }
      case 1: { /* RecoveryPosition */
         stat = XmlDec_AbsoluteHorizontalPositionElementType (pctxt, &pvalue->
            recoveryPosition);
         if (stat != 0) return LOG_RTERR (pctxt, stat);

         stat = rtXmlpMatchEndTag (pctxt, -1);
         if (stat < 0) return LOG_RTERR (pctxt, stat);

         pvalue->m.recoveryPositionPresent = TRUE;
         break;
      }
      cas