/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xmlr.tdm;

import fc.fp.syxaw.util.Log;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.XmlReader;
import fc.fp.util.xas.XmlWriter;
import fc.fp.util.xmlr.IdAddressableRefTree;
import fc.fp.util.xmlr.NodeNotFoundException;
import fc.fp.util.xmlr.RefTree;
import fc.fp.util.xmlr.RefTreeImpl;
import fc.fp.util.xmlr.RefTreeNode;
import fc.fp.util.xmlr.RefTreeNodeImpl;
import fc.fp.util.xmlr.RefTrees;
import fc.fp.util.xmlr.XasSerialization;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import tdm.lib.DiffAlgorithm;

public class Diff
implements RefTree {
    public static final String DIFF_NS = "http://www.hiit.fi/fc/xml/tdm/diff";
    public static final String DIFF_COPY_TAG = "copy";
    public static final String DIFF_INS_TAG = "insert";
    public static final String DIFF_ROOT_TAG = "diff";
    public static final String DIFF_CPYSRC_ATTR = "src";
    public static final String DIFF_CPYDST_ATTR = "dst";
    public static final String DIFF_CPYRUN_ATTR = "run";
    public static final String DIFF_ROOTOP_ATTR = "op";
    public static final String DIFF_ROOTOP_INS = "insert";
    protected RefTreeNode root = null;
    private static final String NO_SUCCESSOR = "NO_SUCC";

    protected Diff() {
    }

    public static Diff encode(IdAddressableRefTree base, RefTree refTree) throws IOException {
        Diff d;
        Diff diff = d = new Diff();
        diff.getClass();
        diff.new RefTreeDiffer(base, null).runDiff(refTree.getRoot());
        return d;
    }

    public static Diff encode(RefTree refTree, SequenceTester st) throws IOException {
        Diff d;
        Diff diff = d = new Diff();
        diff.getClass();
        diff.new RefTreeDiffer(null, st).runDiff(refTree.getRoot());
        return d;
    }

    public RefTree decode(IdAddressableRefTree base) throws IOException {
        Object c = this.getRoot().getContent();
        RefTreeNode rtroot = null;
        if (c instanceof DiffOperation && ((DiffOperation)c).getOperation() == 2) {
            Iterator insTree = this.getRoot().getChildIterator();
            if (!insTree.hasNext()) {
                throw new DiffFormatException("Diff encodes empty XML document");
            }
            RefTreeNode diffRoot = (RefTreeNode)insTree.next();
            if (diffRoot.getContent() instanceof DiffOperation) {
                DiffOperation ro = (DiffOperation)diffRoot.getContent();
                if (ro.getOperation() != 3 || ro.getRun() != 1L) {
                    throw new DiffFormatException("Invalid diff operation at XPath /0/0: ");
                }
                diffRoot = new RefTreeNodeImpl(null, ro.getSource(), true, null);
            }
            rtroot = new DelayedRefTreeNode(diffRoot, base);
        } else if (c instanceof DiffOperation && ((DiffOperation)c).getOperation() == 1) {
            rtroot = new RefTreeNodeImpl(null, ((DiffOperation)c).getSource(), true, null);
        } else {
            throw new DiffFormatException("Invalid diff root tag");
        }
        return new RefTreeImpl(rtroot);
    }

    public void writeDiff(XmlWriter wr, XasSerialization.ContentWriter cw) throws IOException {
        XasSerialization.writeTree(this, wr, new DiffContentWriter(cw));
    }

    public static void writeDiff(Diff d, XmlWriter wr, XasSerialization.ContentWriter cw) throws IOException {
        d.writeDiff(wr, new DiffContentWriter(cw));
    }

    public static Diff readDiff(XmlReader rd, XasSerialization.ContentReader cf, String baseRootId) throws IOException {
        Diff d = new Diff();
        RefTree t = XasSerialization.readTree(rd, new DiffContentReader(cf, baseRootId));
        d.root = t.getRoot();
        return d;
    }

    public RefTreeNode getRoot() {
        return this.root;
    }

    protected static String ensureSuccessor(String baseId, Map succcessors, IdAddressableRefTree base) {
        String NO_PREDECESSOR = "NO_PRED";
        String succ = (String)succcessors.get(baseId);
        try {
            if (succ == null) {
                String pid = base.getParent(baseId);
                String prev = "NO_PRED";
                Iterator i = base.childIterator(pid);
                while (i.hasNext()) {
                    String nid = (String)i.next();
                    if (prev != "NO_PRED") {
                        succcessors.put(prev, nid);
                    }
                    prev = nid;
                }
                succcessors.put(prev, NO_SUCCESSOR);
                succ = (String)succcessors.get(baseId);
                if (succ == null) {
                    Log.log("Broken parent/child relationship", 0);
                }
            }
        }
        catch (NodeNotFoundException x) {
            Log.log("Broken reftree", 2, x);
        }
        return succ;
    }

    protected static class CopySequenceIterator
    implements Iterator {
        protected Map successors = new HashMap();
        String id;
        long left;
        DelayedRefTreeNode parent;

        public CopySequenceIterator(DiffOperation op, DelayedRefTreeNode parent, IdAddressableRefTree baseTree) {
            if (op.getOperation() != 1 && op.getOperation() != 3) {
                throw new IllegalStateException("No inserts should be seen here");
            }
            this.id = op.getSource();
            Diff.ensureSuccessor(this.id, this.successors, baseTree);
            long l = this.left = op.getRun() != null ? op.getRun() : 1L;
            if (this.left < 1L) {
                Log.log("CS iter should never map to <1 elems!", 0);
            }
            this.parent = parent;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.left > 0L;
        }

        public Object next() {
            if (this.left <= 0L || this.id == Diff.NO_SUCCESSOR) {
                throw new NoSuchElementException();
            }
            String current = this.id;
            this.id = (String)this.successors.get(this.id);
            --this.left;
            return new RefTreeNodeImpl(this.parent, current, true, null);
        }
    }

    protected static class DelayedRefTreeNode
    implements RefTreeNode {
        final RefTreeNode node;
        final IdAddressableRefTree base;

        public DelayedRefTreeNode(RefTreeNode node, IdAddressableRefTree base) {
            this.node = node;
            this.base = base;
        }

        public Iterator getChildIterator() {
            final Iterator baseIterator = this.node.getChildIterator();
            return new Iterator(){
                Iterator copySequenceIterator = null;

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return this.copySequenceIterator != null && this.copySequenceIterator.hasNext() || baseIterator.hasNext();
                }

                public Object next() {
                    RefTreeNode next;
                    if (this.copySequenceIterator != null) {
                        if (this.copySequenceIterator.hasNext()) {
                            return this.copySequenceIterator.next();
                        }
                        this.copySequenceIterator = null;
                    }
                    if ((next = (RefTreeNode)baseIterator.next()).getContent() instanceof DiffOperation) {
                        if (next.getChildIterator().hasNext()) {
                            throw new IllegalStateException("diffops may not have children inthis version of the algo");
                        }
                        this.copySequenceIterator = new CopySequenceIterator((DiffOperation)next.getContent(), DelayedRefTreeNode.this, DelayedRefTreeNode.this.base);
                        return this.copySequenceIterator.next();
                    }
                    return new DelayedRefTreeNode(next, DelayedRefTreeNode.this.base);
                }
            };
        }

        public Object getContent() {
            return this.node.getContent();
        }

        public String getId() {
            return this.node.getId();
        }

        public RefTreeNode getParent() {
            RefTreeNode n = this.node.getParent();
            return n != null ? new DelayedRefTreeNode(n, this.base) : null;
        }

        public boolean isNodeRef() {
            return this.node.isNodeRef();
        }

        public boolean isReference() {
            return this.node.isReference();
        }

        public boolean isTreeRef() {
            return this.node.isTreeRef();
        }
    }

    protected static class DiffOperation
    implements RefTrees.IdentifiableContent {
        public static final int ROOT_COPY = 1;
        public static final int ROOT_INSERT = 2;
        public static final int COPY = 3;
        public static final int INSERT = 4;
        private int operation;
        private String source;
        private String destination;
        private String id;
        private Long run;

        protected DiffOperation(int aOperation, String aSource, String aDestination, Long aRun, String aid) {
            this.operation = aOperation;
            this.source = aSource;
            this.destination = aDestination;
            this.run = aRun;
            this.id = aid;
        }

        public int getOperation() {
            return this.operation;
        }

        public String getSource() {
            return this.source;
        }

        public String getDestination() {
            return this.destination;
        }

        public Long getRun() {
            return this.run;
        }

        public String getId() {
            return this.id;
        }
    }

    public static interface SequenceTester {
        public boolean inSequence(RefTreeNode var1, RefTreeNode var2);
    }

    public static class DiffFormatException
    extends IOException {
        public DiffFormatException(String msg) {
            super(msg);
        }
    }

    protected static class DiffContentReader
    implements XasSerialization.ContentReader {
        private static String rootId;
        private XasSerialization.ContentReader next;
        private RefTrees.IdentifiableContent diffTag = null;

        public DiffContentReader(XasSerialization.ContentReader aNext, String rootId) {
            this.next = aNext;
            DiffContentReader.rootId = rootId;
        }

        public RefTrees.IdentifiableContent startContent(XmlReader r) throws IOException {
            EventSequence es = r.currentDelimiter(Diff.DIFF_NS, Diff.DIFF_COPY_TAG);
            if (es != null) {
                String src = null;
                String dst = null;
                Long run = null;
                Enumeration en = es.events();
                while (en.hasMoreElements()) {
                    Event e = (Event)en.nextElement();
                    if (3 != e.getType()) continue;
                    if (Diff.DIFF_CPYSRC_ATTR.equals(e.getName())) {
                        src = e.getValue().toString();
                        continue;
                    }
                    if (Diff.DIFF_CPYDST_ATTR.equals(e.getName())) {
                        dst = e.getValue().toString();
                        continue;
                    }
                    if (Diff.DIFF_CPYRUN_ATTR.equals(e.getName())) {
                        try {
                            run = new Long(e.getValue().toString());
                            continue;
                        }
                        catch (NumberFormatException x) {
                            throw new DiffFormatException("Non-numeric run: " + e.getValue());
                        }
                    }
                    throw new DiffFormatException("Unknown attribute: " + e.getName());
                }
                this.diffTag = new DiffOperation(3, src, dst, run, src);
                return this.diffTag;
            }
            es = r.currentElement(Diff.DIFF_NS, "insert");
            if (es != null) {
                throw new DiffFormatException("Diffs with inserts cannot be decoded to reftrees");
            }
            es = r.currentDelimiter(Diff.DIFF_NS, Diff.DIFF_ROOT_TAG);
            if (es != null) {
                boolean rootIsIns = false;
                Enumeration en = es.events();
                while (en.hasMoreElements()) {
                    Event e = (Event)en.nextElement();
                    if (3 != e.getType() || !Diff.DIFF_ROOTOP_ATTR.equals(e.getName())) continue;
                    if (!"insert".equals(e.getValue())) {
                        throw new DiffFormatException("Unknown root operation " + e.getValue());
                    }
                    rootIsIns = true;
                }
                DiffOperation c = new DiffOperation(rootIsIns ? 2 : 1, rootId, null, null, rootId);
                this.diffTag = !rootIsIns ? c : null;
                return c;
            }
            this.diffTag = null;
            return this.next.startContent(r);
        }

        public void finishContent(Object c, XmlReader r) throws IOException {
            if (c instanceof DiffOperation) {
                Event e;
                String tag = null;
                switch (((DiffOperation)c).getOperation()) {
                    case 1: 
                    case 2: {
                        tag = Diff.DIFF_ROOT_TAG;
                        break;
                    }
                    case 3: {
                        tag = Diff.DIFF_COPY_TAG;
                        break;
                    }
                    case 4: {
                        tag = "insert";
                        break;
                    }
                    default: {
                        Log.log("Unknown diffop", 0);
                    }
                }
                EventSequence es = r.currentDelimiter(Diff.DIFF_NS, tag);
                Event event = e = es != null ? es.get(0) : null;
                if (es == null || e.getType() != 4) {
                    throw new DiffFormatException("Expected closing tag </" + tag + ">");
                }
            } else {
                this.next.finishContent(c, r);
            }
        }
    }

    protected static class DiffContentWriter
    implements XasSerialization.ContentWriter {
        XasSerialization.ContentWriter wr;

        public DiffContentWriter(XasSerialization.ContentWriter writer) {
            this.wr = writer;
        }

        public void startObject(Object o, XmlWriter writer) throws IOException {
            if (!(o instanceof DiffOperation)) {
                this.wr.startObject(o, writer);
                return;
            }
            DiffOperation op = (DiffOperation)o;
            switch (op.getOperation()) {
                case 1: 
                case 2: {
                    writer.addEvent(Event.createNamespacePrefix(Diff.DIFF_NS, Diff.DIFF_ROOT_TAG));
                    writer.addEvent(Event.createStartElement(Diff.DIFF_NS, Diff.DIFF_ROOT_TAG));
                    if (op.getOperation() != 2) break;
                    writer.addEvent(Event.createAttribute("", Diff.DIFF_ROOTOP_ATTR, "insert"));
                    break;
                }
                case 3: {
                    writer.addEvent(Event.createStartElement(Diff.DIFF_NS, Diff.DIFF_COPY_TAG));
                    this.addAttributes(op, writer);
                    break;
                }
                case 4: {
                    writer.addEvent(Event.createStartElement(Diff.DIFF_NS, "insert"));
                    this.addAttributes(op, writer);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown diffop: " + op.getOperation());
                }
            }
        }

        public void finishObject(Object o, XmlWriter writer) throws IOException {
            if (!(o instanceof DiffOperation)) {
                this.wr.finishObject(o, writer);
                return;
            }
            DiffOperation op = (DiffOperation)o;
            switch (op.getOperation()) {
                case 1: 
                case 2: {
                    writer.addEvent(Event.createEndElement(Diff.DIFF_NS, Diff.DIFF_ROOT_TAG));
                    break;
                }
                case 3: {
                    writer.addEvent(Event.createEndElement(Diff.DIFF_NS, Diff.DIFF_COPY_TAG));
                    break;
                }
                case 4: {
                    writer.addEvent(Event.createEndElement(Diff.DIFF_NS, "insert"));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown diffop: " + op.getOperation());
                }
            }
        }

        protected void addAttributes(DiffOperation op, XmlWriter w) throws IOException {
            if (op.getDestination() != null) {
                w.addEvent(Event.createAttribute("", Diff.DIFF_CPYDST_ATTR, op.getDestination()));
            }
            if (op.getSource() != null) {
                w.addEvent(Event.createAttribute("", Diff.DIFF_CPYSRC_ATTR, op.getSource()));
            }
            if (op.getRun() != null) {
                w.addEvent(Event.createAttribute("", Diff.DIFF_CPYRUN_ATTR, op.getRun().toString()));
            }
        }
    }

    protected class RefTreeDiffer
    extends DiffAlgorithm {
        private RefTreeNodeImpl currentNode = null;
        private IdAddressableRefTree base;
        private SequenceTester st;
        private Map successors = new HashMap();

        public RefTreeDiffer(IdAddressableRefTree base, SequenceTester st) {
            if (base != null && st != null) {
                Log.log("Either must be null", 0);
            }
            this.base = base;
            this.st = st;
        }

        public void runDiff(RefTreeNode root) throws IOException {
            this.diff(root);
        }

        protected List getStopNodes(Object changeNode) {
            RefTreeNode n = (RefTreeNode)changeNode;
            ArrayList<Object> l = null;
            if (n.isTreeRef()) {
                l = Collections.EMPTY_LIST;
            } else {
                l = new ArrayList<Object>(1);
                l.add(changeNode);
            }
            return l;
        }

        protected Object lookupBase(Object changeNode) {
            RefTreeNode n = (RefTreeNode)changeNode;
            String id = n.getId();
            return n.isTreeRef() ? changeNode : null;
        }

        protected void content(Object node, boolean start) {
            RefTreeNodeImpl n = null;
            if (node instanceof DiffAlgorithm.DiffOperation) {
                DiffAlgorithm.DiffOperation op = (DiffAlgorithm.DiffOperation)node;
                DiffOperation c = new DiffOperation(op.getOperation(), this.identify(op.getSource()), this.identify(op.getDestination()), op.getRun(), this.identify(op.getSource()));
                n = new RefTreeNodeImpl(this.currentNode, c.getId(), false, c);
            } else {
                n = new RefTreeNodeImpl((RefTreeNode)this.currentNode, ((RefTreeNode)node).getId(), (RefTreeNode)node);
            }
            if (start) {
                if (this.currentNode != null) {
                    this.currentNode.addChild(n);
                } else {
                    Diff.this.root = n;
                }
            }
            this.currentNode = start ? n : (RefTreeNodeImpl)this.currentNode.getParent();
        }

        protected Iterator getChildIterator(Object changeNode) {
            return ((RefTreeNode)changeNode).getChildIterator();
        }

        protected boolean appends(Object baseTailO, Object baseNextO) {
            RefTreeNode baseTail = (RefTreeNode)baseTailO;
            RefTreeNode baseNext = (RefTreeNode)baseNextO;
            if (this.st != null) {
                return this.st.inSequence(baseTail, baseNext);
            }
            String baseId = baseTail.getId();
            String succ = Diff.ensureSuccessor(baseId, this.successors, this.base);
            return succ != Diff.NO_SUCCESSOR && succ.equals(baseNext.getId());
        }

        protected String identify(Object node) {
            if (node == DiffAlgorithm.DiffOperation.NO_VALUE) {
                return null;
            }
            if (!(node instanceof RefTreeNode)) {
                Log.log("Errorneous node class", 0);
                return "ERROR:" + node.toString();
            }
            return ((RefTreeNode)node).getId();
        }
    }
}

