/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xmlr;

import fc.fp.syxaw.util.Log;
import fc.fp.util.xas.DataEventSequence;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.EventStream;
import fc.fp.util.xas.TypedXmlParser;
import fc.fp.util.xas.TypedXmlSerializer;
import fc.fp.util.xas.XasUtil;
import fc.fp.util.xas.XmlReader;
import fc.fp.util.xas.XmlWriter;
import fc.fp.util.xmlr.RefTree;
import fc.fp.util.xmlr.RefTreeImpl;
import fc.fp.util.xmlr.RefTreeNode;
import fc.fp.util.xmlr.RefTreeNodeImpl;
import fc.fp.util.xmlr.RefTrees;
import fc.fp.util.xmlr.ReferenceEvent;
import fc.fp.util.xmlr.ReferenceEventSequence;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import org.xmlpull.v1.XmlSerializer;

public class XasSerialization {
    public static final EventSequence DEFAULT_PREAMBLE;
    private static final ContentCodec GENERIC_CODEC;

    public static ContentCodec getGenericCodec() {
        return GENERIC_CODEC;
    }

    public static RefTree readTree(XmlReader rd, ContentReader cf) throws IOException {
        boolean wholeDocument = true;
        Event e = rd.advance();
        if (e != null && e.getType() != 0) {
            wholeDocument = false;
            rd.backup();
        }
        RefTreeNodeImpl root = XasSerialization.readTree(rd, cf, null);
        if (wholeDocument && ((e = rd.advance()) == null || e.getType() != 1)) {
            throw new IOException("Expected to find end-of-document");
        }
        return new RefTreeImpl(root);
    }

    public static XmlReader getTreeReader(TypedXmlParser pr) throws IOException {
        return new XmlReader(XasSerialization.getDocumentSequence(new EventStream(pr)));
    }

    public static XmlWriter getTreeWriter(TypedXmlSerializer sz) throws IOException {
        return new XmlWriter(XasSerialization.getDocumentSerializer(sz));
    }

    protected static RefTreeNodeImpl readTree(XmlReader rd, ContentReader cf, RefTreeNode parent) throws IOException {
        Event e = rd.advance();
        RefTreeNodeImpl root = null;
        int ccount = 0;
        while (e.getType() == 5) {
            ++ccount;
            e = rd.advance();
        }
        if (e.getType() == 2 || e.getType() == ReferenceEvent.START_REF_NODE) {
            boolean isNodeRef = e.getType() == ReferenceEvent.START_REF_NODE;
            RefTrees.IdentifiableContent content = null;
            String id = null;
            if (isNodeRef) {
                if (ccount > 0) {
                    throw new IOException("Text content before node reference " + ((ReferenceEvent)e).getTarget());
                }
                ReferenceEvent re = (ReferenceEvent)e;
                if (re.getTargetType() != 0) {
                    Log.log("Target type != id not implemented", 0);
                }
                id = re.getTarget();
            } else {
                rd.backup(ccount + 1);
                content = cf.startContent(rd);
                id = content.getId();
            }
            root = new RefTreeNodeImpl(parent, id, false, isNodeRef ? null : content);
            RefTreeNodeImpl child = null;
            while ((child = XasSerialization.readTree(rd, cf, root)) != null) {
                root.addChild(child);
            }
            if (isNodeRef) {
                e = rd.advance();
                if (e.getType() != ReferenceEvent.END_REF_NODE) {
                    throw new IOException("Expected </ref:node>");
                }
            } else {
                cf.finishContent(content, rd);
            }
        } else {
            if (e.getType() == ReferenceEvent.REF_TREE) {
                ReferenceEvent re = (ReferenceEvent)e;
                if (re.getTargetType() != 0) {
                    Log.log("Target type != id not implemented", 0);
                }
                return new RefTreeNodeImpl(parent, re.getTarget(), true, null);
            }
            rd.backup(ccount + 1);
        }
        return root;
    }

    public static void writeTree(RefTree tree, XmlWriter wr, ContentWriter cw) throws IOException {
        XasSerialization.writeTree(tree.getRoot(), cw, wr);
    }

    protected static void writeTree(RefTreeNode n, ContentWriter sz, XmlWriter es) throws IOException {
        if (!n.isReference()) {
            sz.startObject(n.getContent(), es);
        } else if (n.isNodeRef()) {
            es.addEvent(ReferenceEvent.createNodeReference(0, n.getId()));
        } else {
            es.addEvent(ReferenceEvent.createTreeReference(0, n.getId()));
            return;
        }
        Iterator i = n.getChildIterator();
        while (i.hasNext()) {
            XasSerialization.writeTree((RefTreeNode)i.next(), sz, es);
        }
        if (!n.isReference()) {
            sz.finishObject(n.getContent(), es);
        } else {
            es.addEvent(ReferenceEvent.createEndNodeReference());
        }
    }

    public static DocumentSerializer getDocumentSerializer(TypedXmlSerializer ser) {
        return ser instanceof DocumentSerializer ? (DocumentSerializer)ser : new DocumentSerializer(ser, DEFAULT_PREAMBLE);
    }

    public static ReferenceEventSequence getDocumentSequence(EventSequence source) {
        return XasSerialization.getDocumentSequence(source, true);
    }

    public static ReferenceEventSequence getDocumentSequence(EventSequence source, boolean trimWhitespace) {
        return new ReferenceEventSequence(new DataEventSequence(source, trimWhitespace, true));
    }

    static {
        EventList es = new EventList();
        es.add(Event.createNamespacePrefix("http://www.hiit.fi/fc/xml/ref", "ref"));
        es.add(Event.createNamespacePrefix("http://www.hiit.fi/fc/xml/tdm/diff", "diff"));
        DEFAULT_PREAMBLE = es;
        GENERIC_CODEC = new GenericContentCodec();
    }

    public static class TextContentCodec
    implements ContentCodec {
        public RefTrees.IdentifiableContent startContent(XmlReader r) {
            int start = r.getCurrentPosition();
            while (r.getCurrentEvent().getType() == 5) {
                r.advance();
            }
            r.currentDelimiter();
            while (r.getCurrentEvent().getType() == 5) {
                r.advance();
            }
            return new GenericContent(r.getEventSequence().subSequence(start, r.getCurrentPosition()));
        }

        public void finishContent(Object c, XmlReader r) {
            EventSequence es;
            int start = r.getCurrentPosition();
            while (r.getCurrentEvent().getType() == 5) {
                r.advance();
            }
            int startelem = r.getCurrentPosition();
            if (c instanceof GenericContent) {
                es = r.currentDelimiter();
                if (startelem > start) {
                    es = r.getEventSequence().subSequence(start, r.getCurrentPosition());
                }
            } else {
                throw new IllegalArgumentException("Object is wrong class");
            }
            ((GenericContent)c).setTail(es);
        }

        public void startObject(Object o, XmlWriter writer) throws IOException {
            if (!(o instanceof GenericContent)) {
                throw new IOException("Codec requires GenericContent object");
            }
            writer.addEvents(((GenericContent)o).getHead());
        }

        public void finishObject(Object o, XmlWriter writer) throws IOException {
            if (!(o instanceof GenericContent)) {
                throw new IOException("Codec requires GenericContent object");
            }
            writer.addEvents(((GenericContent)o).getTail());
        }
    }

    public static class GenericContentCodec
    implements ContentCodec {
        public RefTrees.IdentifiableContent startContent(XmlReader r) {
            EventSequence es = r.currentDelimiter();
            return new GenericContent(es);
        }

        public void finishContent(Object c, XmlReader r) {
            if (!(c instanceof GenericContent)) {
                throw new IllegalArgumentException("Object is wrong class");
            }
            EventSequence es = r.currentDelimiter();
            ((GenericContent)c).setTail(es);
        }

        public void startObject(Object o, XmlWriter writer) throws IOException {
            if (!(o instanceof GenericContent)) {
                throw new IOException("Codec requires GenericContent object");
            }
            writer.addEvents(((GenericContent)o).getHead());
        }

        public void finishObject(Object o, XmlWriter writer) throws IOException {
            if (!(o instanceof GenericContent)) {
                throw new IOException("Codec requires GenericContent object");
            }
            writer.addEvents(((GenericContent)o).getTail());
        }
    }

    public static class GenericContent
    implements RefTrees.IdentifiableContent {
        EventSequence head;
        EventSequence tail = null;
        String id;
        private static long idGen = 0L;

        public GenericContent(EventSequence es) {
            String id = null;
            Enumeration en = es.events();
            while (en.hasMoreElements() && id == null) {
                Event e = (Event)en.nextElement();
                if (e.getType() != 3 || !"id".equals(e.getName())) continue;
                id = e.getValue().toString();
            }
            this.head = es;
            this.id = id == null ? String.valueOf(idGen++) : id;
        }

        public GenericContent(EventSequence es, String id) {
            this.id = id != null ? id : String.valueOf(idGen++);
            this.head = es;
        }

        public String getId() {
            return this.id;
        }

        public EventSequence getHead() {
            return this.head;
        }

        public void setTail(EventSequence tail) {
            this.tail = tail;
        }

        public EventSequence getTail() {
            return this.tail;
        }

        public EventSequence getSequence() {
            EventList es = new EventList();
            es.addAll(this.getHead());
            es.addAll(this.getTail());
            return es;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GenericContent)) {
                return false;
            }
            GenericContent c = (GenericContent)o;
            return this.head.equals(c.head) && (this.tail == this.tail || this.tail != null && this.tail.equals(c.tail));
        }
    }

    public static interface ContentCodec
    extends ContentReader,
    ContentWriter {
    }

    public static interface ContentWriter {
        public void startObject(Object var1, XmlWriter var2) throws IOException;

        public void finishObject(Object var1, XmlWriter var2) throws IOException;
    }

    public static interface ContentReader {
        public RefTrees.IdentifiableContent startContent(XmlReader var1) throws IOException;

        public void finishContent(Object var1, XmlReader var2) throws IOException;
    }

    public static class DocumentSerializer
    implements TypedXmlSerializer {
        private EventSequence preamble = null;
        private TypedXmlSerializer s = null;
        private boolean documentEnded = false;
        private static final String DOCUMENT_HAS_ENDED = "The root tag has been closed";

        public DocumentSerializer(TypedXmlSerializer ser, EventSequence preamble) {
            this.s = ser;
            this.preamble = preamble;
        }

        public void setFeature(String string, boolean boolean1) {
            this.s.setFeature(string, boolean1);
        }

        public boolean getFeature(String string) {
            return this.s.getFeature(string);
        }

        public void setProperty(String string, Object object) {
            this.s.setProperty(string, object);
        }

        public Object getProperty(String string) {
            return this.s.getProperty(string);
        }

        public void setOutput(OutputStream outputStream, String string) throws IOException {
            this.s.setOutput(outputStream, string);
        }

        public void setOutput(Writer writer) throws IOException {
            this.s.setOutput(writer);
        }

        public void startDocument(String string, Boolean boolean1) {
        }

        public void endDocument() {
        }

        public void setPrefix(String string, String string1) throws IOException {
            this.s.setPrefix(string, string1);
        }

        public String getPrefix(String string, boolean boolean1) {
            return this.s.getPrefix(string, boolean1);
        }

        public int getDepth() {
            return this.s.getDepth();
        }

        public String getNamespace() {
            return this.s.getNamespace();
        }

        public String getName() {
            return this.s.getName();
        }

        public XmlSerializer startTag(String string, String string1) throws IOException {
            if (this.documentEnded) {
                throw new IllegalStateException(DOCUMENT_HAS_ENDED);
            }
            if (this.s.getDepth() <= 0) {
                XasUtil.outputEvent(Event.createStartDocument(), this.s);
                if (this.preamble != null) {
                    XasUtil.outputSequence(this.preamble, this.s);
                }
                this.preamble = null;
            }
            this.s.startTag(string, string1);
            return this;
        }

        public XmlSerializer attribute(String string, String string1, String string2) throws IOException {
            if (this.documentEnded) {
                throw new IllegalStateException(DOCUMENT_HAS_ENDED);
            }
            this.s.attribute(string, string1, string2);
            return this;
        }

        public XmlSerializer endTag(String string, String string1) throws IOException {
            if (this.documentEnded) {
                throw new IllegalStateException(DOCUMENT_HAS_ENDED);
            }
            this.s.endTag(string, string1);
            if (this.s.getDepth() == 0) {
                XasUtil.outputEvent(Event.createEndDocument(), this.s);
                this.documentEnded = true;
            }
            return this;
        }

        public XmlSerializer text(String string) throws IOException {
            if (this.documentEnded) {
                throw new IllegalStateException(DOCUMENT_HAS_ENDED);
            }
            this.s.text(string);
            return this;
        }

        public XmlSerializer text(char[] charArray, int int1, int int2) throws IOException {
            if (this.documentEnded) {
                throw new IllegalStateException(DOCUMENT_HAS_ENDED);
            }
            this.s.text(charArray, int1, int2);
            return this;
        }

        public void cdsect(String string) throws IOException {
            if (this.documentEnded) {
                throw new IllegalStateException(DOCUMENT_HAS_ENDED);
            }
            this.s.cdsect(string);
        }

        public void entityRef(String string) throws IOException {
            if (this.documentEnded) {
                throw new IllegalStateException(DOCUMENT_HAS_ENDED);
            }
            this.s.entityRef(string);
        }

        public void processingInstruction(String string) throws IOException {
            if (this.documentEnded) {
                throw new IllegalStateException(DOCUMENT_HAS_ENDED);
            }
            this.s.processingInstruction(string);
        }

        public void comment(String string) throws IOException {
            if (this.documentEnded) {
                throw new IllegalStateException(DOCUMENT_HAS_ENDED);
            }
            this.s.comment(string);
        }

        public void docdecl(String string) throws IOException {
            if (this.documentEnded) {
                throw new IllegalStateException(DOCUMENT_HAS_ENDED);
            }
            this.s.docdecl(string);
        }

        public void ignorableWhitespace(String string) throws IOException {
            if (this.documentEnded) {
                throw new IllegalStateException(DOCUMENT_HAS_ENDED);
            }
            this.s.ignorableWhitespace(string);
        }

        public void flush() throws IOException {
            this.s.flush();
        }

        public TypedXmlSerializer typedContent(Object content, String namespace, String name) throws IOException {
            if (this.documentEnded) {
                throw new IllegalStateException(DOCUMENT_HAS_ENDED);
            }
            this.s.typedContent(content, namespace, name);
            return this;
        }

        public TypedXmlSerializer typedAttribute(String namespace, String name, Object value) throws IOException {
            if (this.documentEnded) {
                throw new IllegalStateException(DOCUMENT_HAS_ENDED);
            }
            this.s.typedAttribute(namespace, name, value);
            return this;
        }
    }
}

