/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xmlr;

import fc.fp.syxaw.util.Log;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.XmlReader;
import java.util.Enumeration;

public class ReferenceEvent
extends Event {
    public static final int TT_ID = 0;
    public static final int TT_PATH = 1;
    public static final int TT_TARGET = 2;
    private String target = null;
    private int targetType = -1;
    public static final String REF_NS = "http://www.hiit.fi/fc/xml/ref";
    public static final String REF_ATT_NS = "";
    public static final String REF_TAG_TREE = "tree";
    public static final String REF_TAG_NODE = "node";
    public static final String REF_ATT_ID = "id";
    public static final String REF_ATT_PATH = "path";
    public static final String REF_ATT_TARGET = "target";
    private static final String[] ATTNAME_NY_METHOD = new String[]{"id", "path", "target"};
    public static final int REF_TREE = 0x43000000 | "http://www.hiit.fi/fc/xml/ref/REF_TREE".hashCode() & 0xFFFFFF;
    public static final int START_REF_NODE = 0x43000000 | "http://www.hiit.fi/fc/xml/ref/START_REF_NODE".hashCode() & 0xFFFFFF;
    public static final int END_REF_NODE = 0x43000000 | "http://www.hiit.fi/fc/xml/ref/END_REF_NODE".hashCode() & 0xFFFFFF;

    protected ReferenceEvent(int type, String namespace, String name, Object value) {
        super(type, namespace, name, value);
    }

    private static ReferenceEvent createReference(int type, RefTarget t, EventSequence s) {
        ReferenceEvent e = new ReferenceEvent(type, null, null, s);
        if (t != null) {
            e.target = t.target;
            e.targetType = t.targetType;
        }
        return e;
    }

    public EventSequence encode() {
        return (EventSequence)this.getValue();
    }

    public static ReferenceEvent createTreeReference(String target) {
        return ReferenceEvent.createTreeReference(0, target);
    }

    public static ReferenceEvent createTreeReference(int method, String target) {
        EventList es = new EventList();
        es.add(Event.createStartElement(REF_NS, REF_TAG_TREE));
        es.add(Event.createAttribute(REF_ATT_NS, ATTNAME_NY_METHOD[method], target));
        es.add(Event.createEndElement(REF_NS, REF_TAG_TREE));
        return ReferenceEvent.createReference(REF_TREE, new RefTarget(method, target), es);
    }

    public static ReferenceEvent createNodeReference(String target) {
        return ReferenceEvent.createNodeReference(0, target);
    }

    public static ReferenceEvent createNodeReference(int method, String target) {
        EventList es = new EventList();
        es.add(Event.createStartElement(REF_NS, REF_TAG_NODE));
        es.add(Event.createAttribute(REF_ATT_NS, ATTNAME_NY_METHOD[method], target));
        return ReferenceEvent.createReference(START_REF_NODE, new RefTarget(method, target), es);
    }

    public static ReferenceEvent createEndNodeReference() {
        EventList es = new EventList();
        es.add(Event.createEndElement(REF_NS, REF_TAG_NODE));
        return ReferenceEvent.createReference(END_REF_NODE, null, es);
    }

    public static Event decode(XmlReader events) {
        Event e = events.advance();
        return ReferenceEvent.decode(e, events);
    }

    public static Event decode(Event e, XmlReader events) {
        if (e != null && REF_NS.equals(e.getNamespace())) {
            if (e.getType() == 2 && REF_TAG_TREE.equals(e.getName())) {
                events.backup();
                EventSequence tagEvents = events.currentDelimiter();
                RefTarget t = ReferenceEvent.decodeTarget(tagEvents);
                return ReferenceEvent.createReference(REF_TREE, t, tagEvents);
            }
            if (e.getType() == 2 && REF_TAG_NODE.equals(e.getName())) {
                events.backup();
                EventSequence tagEvents = events.currentDelimiter();
                RefTarget t = ReferenceEvent.decodeTarget(tagEvents);
                return ReferenceEvent.createReference(START_REF_NODE, t, tagEvents);
            }
            if (e.getType() == 4 && REF_TAG_NODE.equals(e.getName())) {
                events.backup();
                EventSequence tagEvents = events.currentDelimiter();
                return ReferenceEvent.createReference(END_REF_NODE, null, tagEvents);
            }
            if (e.getType() == 4 && REF_TAG_TREE.equals(e.getName())) {
                return ReferenceEvent.decode(events);
            }
            Log.log("Unknown tag in XMLR namespace", 3);
            return null;
        }
        return e;
    }

    public String getTarget() {
        return this.target;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public String toString() {
        if (this.getType() == REF_TREE) {
            return "EX({REF_TREE}" + this.target + ")";
        }
        if (this.getType() == START_REF_NODE) {
            return "EX({START_REF_NODE}" + this.target + ")";
        }
        if (this.getType() == END_REF_NODE) {
            return "EX({END_REF_NODE})";
        }
        return super.toString();
    }

    private static RefTarget decodeTarget(EventSequence s) {
        RefTarget t = new RefTarget();
        Enumeration en = s.events();
        while (en.hasMoreElements()) {
            Event e = (Event)en.nextElement();
            if (e.getType() != 3) continue;
            t.target = (String)e.getValue();
            if (REF_ATT_ID.equals(e.getName()) && t.targetType < 0) {
                t.targetType = 0;
                continue;
            }
            if (REF_ATT_PATH.equals(e.getName()) && t.targetType < 1) {
                t.targetType = 1;
                continue;
            }
            if (!REF_ATT_TARGET.equals(e.getName()) || t.targetType >= 2) continue;
            t.targetType = 2;
        }
        return t;
    }

    private static class RefTarget {
        String target;
        int targetType;

        public RefTarget() {
            this.target = null;
            this.targetType = -1;
        }

        public RefTarget(int type, String tgt) {
            this.target = tgt;
            this.targetType = type;
        }
    }
}

