/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xmlr;

import fc.fp.syxaw.util.Log;
import fc.fp.util.xmlr.ChangeTree;
import fc.fp.util.xmlr.IdAddressableRefTree;
import fc.fp.util.xmlr.IdAddressableRefTreeImpl;
import fc.fp.util.xmlr.MutableRefTree;
import fc.fp.util.xmlr.NodeNotFoundException;
import fc.fp.util.xmlr.RefTree;
import fc.fp.util.xmlr.RefTreeImpl;
import fc.fp.util.xmlr.RefTreeNode;
import fc.fp.util.xmlr.RefTreeNodeImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RefTrees {
    public static final Set INFINITE_SET = new InfiniteSet();
    public static final Iterator IDENTICAL_CHILDLIST = new IdenticalChildListIterator(null);

    private RefTrees() {
    }

    public static RefTree expandRefs(RefTree tree, Set allowedRefs, Set allowedContent, IdAddressableRefTree backingTree) throws NodeNotFoundException {
        RefTreeNodeImpl root = RefTrees.expandRefs(tree.getRoot(), allowedRefs, allowedContent, backingTree, null, false);
        return new RefTreeImpl(root);
    }

    protected static RefTreeNodeImpl expandRefs(RefTreeNode root, Set allowedRefs, Set allowedContent, IdAddressableRefTree backingTree, RefTreeNode parent, boolean inBacking) throws NodeNotFoundException {
        RefTreeNodeImpl newRoot = null;
        if (allowedRefs.contains(root.getId())) {
            newRoot = new RefTreeNodeImpl(parent, root.getId(), true, null);
        } else if ((root.isReference() || inBacking) && allowedContent.contains(root.getId())) {
            newRoot = new RefTreeNodeImpl(parent, root.getId(), false, null);
        } else {
            Object content = null;
            if (root.isReference()) {
                RefTreeNode backingNode = backingTree.getNode(root.getId());
                if (backingNode == null) {
                    throw new NodeNotFoundException("Can't expand reference to", root.getId());
                }
                content = backingNode.getContent();
            } else {
                content = root.getContent();
            }
            newRoot = new RefTreeNodeImpl(parent, root.getId(), false, content);
        }
        if (!newRoot.isTreeRef()) {
            Iterator i;
            Iterator iterator = i = root.isTreeRef() ? backingTree.getNode(root.getId()).getChildIterator() : root.getChildIterator();
            while (i.hasNext()) {
                RefTreeNodeImpl child = RefTrees.expandRefs((RefTreeNode)i.next(), allowedRefs, allowedContent, backingTree, newRoot, root.isTreeRef());
                newRoot.addChild(child);
            }
        }
        return newRoot;
    }

    public static Set[] normalize(IdAddressableRefTree backingTree, RefTree[] trees, Set expandedContents) throws NodeNotFoundException {
        HashMap commonRefs = new HashMap();
        HashSet innerNodes = new HashSet();
        for (int iTree = 0; iTree < trees.length; ++iTree) {
            Log.log("Adding tree " + trees[iTree], 5);
            RefTrees.addTreeRefs(backingTree, trees[iTree].getRoot(), commonRefs, innerNodes, trees[iTree], expandedContents);
        }
        Set[] refset = new HashSet[trees.length];
        for (int iTree = 0; iTree < trees.length; ++iTree) {
            refset[iTree] = new HashSet();
        }
        for (Map.Entry e : commonRefs.entrySet()) {
            String id = (String)e.getKey();
            Set usedIn = (Set)e.getValue();
            for (int iTree = 0; iTree < trees.length; ++iTree) {
                if (!usedIn.contains(trees[iTree])) continue;
                refset[iTree].add(id);
            }
        }
        return refset;
    }

    public static Set[] normalize(IdAddressableRefTree backingTree, RefTree[] trees) throws NodeNotFoundException {
        return RefTrees.normalize(backingTree, trees, null);
    }

    protected static void addTreeRefs(IdAddressableRefTree backingTree, RefTreeNode root, Map commonRefs, Set innerNodes, RefTree treeTag, Set expandedContents) throws NodeNotFoundException {
        if (root.isReference() || backingTree.contains(root.getId())) {
            RefTrees.addTreeRef(backingTree, root, commonRefs, innerNodes, treeTag);
        }
        if (expandedContents != null && !root.isReference()) {
            expandedContents.add(root.getId());
        }
        Iterator i = root.getChildIterator();
        while (i.hasNext()) {
            RefTrees.addTreeRefs(backingTree, (RefTreeNode)i.next(), commonRefs, innerNodes, treeTag, expandedContents);
        }
    }

    protected static void downscan(RefTreeNode node, Map refLeaves, Set refInnerNodes, Set tagSet) {
        String id = node.getId();
        if (refInnerNodes.contains(id)) {
            Iterator i = node.getChildIterator();
            while (i.hasNext()) {
                RefTreeNode child = (RefTreeNode)i.next();
                if (!refInnerNodes.contains(child.getId()) && !refLeaves.containsKey(child.getId())) {
                    refLeaves.put(child.getId(), tagSet);
                    continue;
                }
                RefTrees.downscan(child, refLeaves, refInnerNodes, tagSet);
            }
        } else if (refLeaves.containsKey(id)) {
            ((Set)refLeaves.get(id)).addAll(tagSet);
        }
    }

    protected static void prohibit(String id, Map treeRefs, Set inner, IdAddressableRefTree bt) throws NodeNotFoundException {
        if (id == null || inner.contains(id) || bt.getNode(id) == null) {
            return;
        }
        RefTrees.prohibit(bt.getParent(id), treeRefs, inner, bt);
        HashSet tags = (HashSet)treeRefs.remove(id);
        if (tags == null) {
            tags = new HashSet();
        }
        Iterator i = bt.childIterator(id);
        while (i.hasNext()) {
            String cid = (String)i.next();
            if (treeRefs.containsKey(cid)) {
                ((Set)treeRefs.get(cid)).addAll(tags);
                continue;
            }
            HashSet tags2 = new HashSet();
            tags2.addAll(tags);
            treeRefs.put(cid, tags2);
        }
        inner.add(id);
    }

    protected static void addRefToRefset(String id, RefTree treeTag, Map treeRefs, Set inner, IdAddressableRefTree bt) throws NodeNotFoundException {
        RefTrees.prohibit(bt.getParent(id), treeRefs, inner, bt);
        if (treeRefs.containsKey(id)) {
            ((Set)treeRefs.get(id)).add(treeTag);
        } else {
            HashSet<RefTree> tags = new HashSet<RefTree>();
            tags.add(treeTag);
            treeRefs.put(id, tags);
        }
    }

    protected static void addTreeRef(IdAddressableRefTree backingTree, RefTreeNode node, Map refLeaves, Set refInnerNodes, RefTree treeTag) throws NodeNotFoundException {
        String id = node.getId();
        if (node.isTreeRef() && refInnerNodes.contains(id)) {
            HashSet<RefTree> tagSet = new HashSet<RefTree>();
            tagSet.add(treeTag);
            RefTrees.downscan(backingTree.getNode(id), refLeaves, refInnerNodes, tagSet);
            return;
        }
        if (node.isTreeRef()) {
            RefTrees.addRefToRefset(id, treeTag, refLeaves, refInnerNodes, backingTree);
        } else {
            RefTrees.prohibit(id, refLeaves, refInnerNodes, backingTree);
        }
        for (RefTreeNode scan = node.getParent(); scan != null; scan = scan.getParent()) {
            RefTrees.prohibit(scan.getId(), refLeaves, refInnerNodes, backingTree);
        }
    }

    public static void apply(RefTree source, MutableRefTree target) throws NodeNotFoundException {
        RefTrees.apply(source, target, null, RefTrees.getIdentityIdMap());
    }

    public static void apply(RefTree source, MutableRefTree target, Set delRoots) throws NodeNotFoundException {
        RefTrees.apply(source, target, delRoots, RefTrees.getIdentityIdMap());
    }

    public static void apply(RefTree source, MutableRefTree target, Set delRoots, IdMap idMap) throws NodeNotFoundException {
        Set deletia = delRoots == null ? new HashSet() : delRoots;
        RefTrees.apply(source, target, source.getRoot(), deletia, idMap);
        if (delRoots == null) {
            Iterator i = deletia.iterator();
            while (i.hasNext()) {
                target.delete((String)i.next());
            }
        }
    }

    protected static void apply(RefTree newTree, MutableRefTree target, RefTreeNode currentNewNode, Set delRoots, IdMap newToThis) throws NodeNotFoundException {
        String currentLocationN = currentNewNode.getId();
        String currentLocationT = newToThis.getDestId(currentNewNode);
        if (currentNewNode.isTreeRef()) {
            return;
        }
        if (!currentNewNode.isReference()) {
            target.update(currentLocationT, currentNewNode.getContent());
        }
        HashMap<String, RefTreeNode> newNodeChildren = new HashMap<String, RefTreeNode>();
        Iterator i = currentNewNode.getChildIterator();
        if (i == IDENTICAL_CHILDLIST) {
            return;
        }
        while (i.hasNext()) {
            RefTreeNode child = (RefTreeNode)i.next();
            newNodeChildren.put(child.getId(), child);
        }
        HashSet<String> visitedChildren = new HashSet<String>();
        RefTreeNode current = target.getNode(currentLocationT);
        Iterator i2 = current.getChildIterator();
        while (i2.hasNext()) {
            RefTreeNode cchild = (RefTreeNode)i2.next();
            String childSrcId = newToThis.getSrcId(cchild);
            if (!newNodeChildren.containsKey(childSrcId)) {
                delRoots.add(cchild.getId());
                continue;
            }
            visitedChildren.add(childSrcId);
        }
        for (RefTreeNode newNode : newNodeChildren.values()) {
            String oldLocation;
            String newIdT = newToThis.getDestId(newNode);
            if (visitedChildren.contains(newNode.getId())) continue;
            String string = oldLocation = target.contains(newIdT) ? target.getParent(newIdT) : null;
            if (oldLocation == null) {
                if (newNode.isReference()) {
                    throw new NodeNotFoundException(newNode.getId());
                }
                target.insert(currentLocationT, newIdT, newNode.getContent());
                continue;
            }
            if (!oldLocation.equals(currentLocationT)) {
                if (delRoots.contains(newIdT)) {
                    delRoots.remove(newIdT);
                }
                target.move(newIdT, currentLocationT);
                continue;
            }
            Log.log("Should not get here (node should be in visitedChildren)oldloc=" + oldLocation + ", newloc=" + currentLocationT + ",newIdN=" + newNode.getId() + ", visitedNodes=" + visitedChildren, 2);
        }
        i2 = newNodeChildren.values().iterator();
        while (i2.hasNext()) {
            RefTrees.apply(newTree, target, (RefTreeNode)i2.next(), delRoots, newToThis);
        }
    }

    public static IdMap getIdentityIdMap() {
        return IdentityIdMap.getInstance();
    }

    public static IdAddressableRefTree getRefTree(RefTree t) {
        return RefTrees.getRefTree(t.getRoot().getId());
    }

    public static IdAddressableRefTree getRefTree(String rootId) {
        return RefTrees.getAddressableTree(new RefTreeImpl(new RefTreeNodeImpl(null, rootId, true, null)));
    }

    public static MutableRefTree getMutableTree(RefTree t) {
        return t instanceof MutableRefTree ? (MutableRefTree)t : new ChangeTree(RefTrees.getAddressableTree(t));
    }

    public static IdAddressableRefTree getAddressableTree(RefTree t) {
        class AddressableTree
        extends IdAddressableRefTreeImpl {
            private Map index = new HashMap();
            private RefTree t;

            public AddressableTree(RefTree t) {
                this.t = t;
                this.init(t.getRoot());
            }

            public RefTreeNode getNode(String id) {
                return (RefTreeNode)this.index.get(id);
            }

            public RefTreeNode getRoot() {
                return this.t.getRoot();
            }

            private void init(RefTreeNode root) {
                if (this.index.put(root.getId(), root) != null) {
                    Log.log("Duplicate id " + root.getId(), 0);
                }
                Iterator i = root.getChildIterator();
                while (i.hasNext()) {
                    this.init((RefTreeNode)i.next());
                }
            }
        }
        return t instanceof IdAddressableRefTree ? (IdAddressableRefTree)t : new AddressableTree(t);
    }

    public static Set getComplement(Set s) {
        return new ComplementSet(s);
    }

    public static RefTree combine(RefTree aRb, RefTree bRc, final IdAddressableRefTree c) throws NodeNotFoundException {
        final IdAddressableRefTree bRcAddr = RefTrees.getAddressableTree(bRc);
        Set[] allowedTrees = RefTrees.normalize(c, new RefTree[]{aRb, bRcAddr});
        return RefTrees.expandRefs(aRb, allowedTrees[0], new BaseSet(){

            public boolean contains(Object o) {
                return RefTrees.isReferenced((String)o, bRcAddr, c);
            }
        }, c);
    }

    private static boolean isReferenced(String id, IdAddressableRefTree t, IdAddressableRefTree backingTree) {
        boolean checkRoot = true;
        for (RefTreeNode parent = backingTree.getNode(id); parent != null; parent = parent.getParent()) {
            RefTreeNode n = t.getNode(parent.getId());
            if (n != null && (n.isTreeRef() || checkRoot && n.isNodeRef())) {
                return true;
            }
            checkRoot = false;
        }
        return false;
    }

    private static class ComplementSet
    extends BaseSet {
        Set s;

        public ComplementSet(Set s) {
            this.s = s;
        }

        public boolean contains(Object o) {
            return !this.s.contains(o);
        }
    }

    private static class InfiniteSet
    extends BaseSet {
        public boolean contains(Object o) {
            return true;
        }
    }

    private static abstract class BaseSet
    implements Set {
        UnsupportedOperationException NO_OP = new UnsupportedOperationException("Infinite sets do not support this operation");

        public int size() {
            return Integer.MAX_VALUE;
        }

        public void clear() {
            throw this.NO_OP;
        }

        public boolean isEmpty() {
            return false;
        }

        public Object[] toArray() {
            throw this.NO_OP;
        }

        public boolean add(Object o) {
            throw this.NO_OP;
        }

        public abstract boolean contains(Object var1);

        public boolean equals(Object o) {
            return false;
        }

        public boolean remove(Object o) {
            throw this.NO_OP;
        }

        public boolean addAll(Collection c) {
            throw this.NO_OP;
        }

        public boolean containsAll(Collection c) {
            throw this.NO_OP;
        }

        public boolean removeAll(Collection c) {
            throw this.NO_OP;
        }

        public boolean retainAll(Collection c) {
            throw this.NO_OP;
        }

        public Iterator iterator() {
            throw this.NO_OP;
        }

        public Object[] toArray(Object[] a) {
            throw this.NO_OP;
        }
    }

    public static class IdenticalChildListIterator
    implements Iterator {
        private static final String MISSING_ITER = "Full child list not available.";
        private Iterator fullListIterator;

        public IdenticalChildListIterator(Iterator realListIterator) {
            this.fullListIterator = realListIterator;
        }

        public void remove() {
            if (this.fullListIterator == null) {
                throw new UnsupportedOperationException(MISSING_ITER);
            }
            this.fullListIterator.remove();
        }

        public boolean hasNext() {
            if (this.fullListIterator == null) {
                throw new UnsupportedOperationException(MISSING_ITER);
            }
            return this.fullListIterator.hasNext();
        }

        public Object next() {
            if (this.fullListIterator == null) {
                throw new UnsupportedOperationException(MISSING_ITER);
            }
            return this.fullListIterator.next();
        }
    }

    public static interface IdentifiableContent {
        public String getId();
    }

    private static final class IdentityIdMap
    extends IdMap {
        private static IdMap map = new IdentityIdMap();

        private IdentityIdMap() {
        }

        public static IdMap getInstance() {
            return map;
        }

        public final String getDestId(String srcId, RefTreeNode src) throws NodeNotFoundException {
            return srcId;
        }

        public final String getSrcId(String dstId, RefTreeNode dest) throws NodeNotFoundException {
            return dstId;
        }
    }

    public static abstract class IdMap {
        public abstract String getDestId(String var1, RefTreeNode var2) throws NodeNotFoundException;

        public abstract String getSrcId(String var1, RefTreeNode var2) throws NodeNotFoundException;

        public final String getDestId(String srcId) throws NodeNotFoundException {
            return this.getDestId(srcId, null);
        }

        public final String getSrcId(String dstId) throws NodeNotFoundException {
            return this.getSrcId(dstId, null);
        }

        public final String getDestId(RefTreeNode src) throws NodeNotFoundException {
            return this.getDestId(src.getId(), src);
        }

        public final String getSrcId(RefTreeNode dest) throws NodeNotFoundException {
            return this.getSrcId(dest.getId(), dest);
        }
    }
}

