/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xmlr;

import fc.fp.util.Util;
import fc.fp.util.xmlr.RefTreeNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class RefTreeNodeImpl
implements RefTreeNode {
    private Object content = null;
    private String id;
    private RefTreeNode parent;
    private boolean isTreeRef = false;
    LinkedList children = null;

    public RefTreeNodeImpl(RefTreeNode parent, String id, RefTreeNode values) {
        this(parent, id, values.isTreeRef(), values.getContent());
    }

    public RefTreeNodeImpl(RefTreeNode parent, String id, Object content) {
        this(parent, id, false, content);
        if (content == null) {
            throw new IllegalArgumentException();
        }
    }

    public RefTreeNodeImpl(RefTreeNode parent, String id, boolean isTreeRef, Object content) {
        this.id = id;
        this.parent = parent;
        this.isTreeRef = isTreeRef;
        this.content = content;
    }

    public Iterator getChildIterator() {
        return this.children == null ? Collections.EMPTY_LIST.iterator() : this.children.iterator();
    }

    public Object getContent() {
        return this.content;
    }

    public String getId() {
        return this.id;
    }

    public RefTreeNode getParent() {
        return this.parent;
    }

    public boolean isNodeRef() {
        return this.content == null && !this.isTreeRef;
    }

    public boolean isReference() {
        return this.content == null;
    }

    public boolean isTreeRef() {
        return this.content == null && this.isTreeRef;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public void setTreeRef(boolean treeRef) {
        this.isTreeRef = treeRef;
    }

    public void setParent(RefTreeNode parent) {
        this.parent = parent;
    }

    public void addChild(RefTreeNodeImpl n) {
        this.ensureChildList();
        this.children.add(n);
        n.setParent(this);
    }

    public boolean removeChild(RefTreeNodeImpl n) {
        this.ensureChildList();
        if (this.children.remove(n)) {
            n.setParent(null);
            return true;
        }
        return false;
    }

    public RefTreeNodeImpl firstChild() {
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        return (RefTreeNodeImpl)this.children.getFirst();
    }

    public RefTreeNodeImpl lastChild() {
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        return (RefTreeNodeImpl)this.children.getLast();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RefTreeNode)) {
            return false;
        }
        RefTreeNode n = (RefTreeNode)obj;
        return Util.equals(n.getId(), this.id) && n.isNodeRef() == this.isNodeRef() && n.isTreeRef() == this.isTreeRef() && Util.equals(n.getContent(), this.getContent());
    }

    protected final void ensureChildList() {
        if (this.children == null) {
            this.children = new LinkedList();
        }
    }
}

