/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xmlr;

import fc.fp.syxaw.util.Log;
import fc.fp.syxaw.util.Util;
import fc.fp.util.xmlr.IdAddressableRefTree;
import fc.fp.util.xmlr.IdAddressableRefTreeImpl;
import fc.fp.util.xmlr.MutableRefTree;
import fc.fp.util.xmlr.MutableRefTreeImpl;
import fc.fp.util.xmlr.NodeNotFoundException;
import fc.fp.util.xmlr.RefTreeNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ChangeTree
extends MutableRefTreeImpl {
    private Map nodeById = new HashMap();
    private Set delRoots = new HashSet();
    private Node refRoot = null;
    private IdAddressableRefTree refTree = null;
    private long changeCount = 0L;
    private IdAddressableRefTree backingTree;
    private MutableRefTree changeTarget;

    public ChangeTree(IdAddressableRefTree backingTree) {
        this(backingTree, null);
    }

    public ChangeTree(IdAddressableRefTree backingTree, MutableRefTree changeTarget) {
        this.backingTree = backingTree;
        this.changeTarget = changeTarget;
        this.reset();
    }

    public IdAddressableRefTree getChangeTree() {
        return this.refTree;
    }

    public void reset() {
        String rootId = this.backingTree.getRoot().getId();
        this.delRoots.clear();
        this.refRoot = new Node(rootId, null, null, true, false);
        this.refTree = new IdAddressableRefTreeImpl(){

            public RefTreeNode getRoot() {
                return new ProxyNode(ChangeTree.this.refRoot, false);
            }

            public RefTreeNode getNode(String id) {
                return ChangeTree.this.getNode(id, false);
            }
        };
        this.nodeById.clear();
        this.nodeById.put(rootId, this.refRoot);
        this.changeCount = 0L;
    }

    public RefTreeNode getRoot() {
        return new ProxyNode(this.refRoot, true);
    }

    public RefTreeNode getNode(String id) {
        return this.getNode(id, true);
    }

    protected RefTreeNode getNode(String id, boolean transparent) {
        RefTreeNode n = this.findNode(id);
        if (n == null) {
            n = this.backingTree.getNode(id);
        }
        if (n != null) {
            n = new ProxyNode(n, transparent);
        }
        return n != null && !this.isDeleted(n) ? n : null;
    }

    protected boolean isDeleted(RefTreeNode n) {
        if (n == null) {
            return false;
        }
        if (this.delRoots.contains(n.getId())) {
            return true;
        }
        return this.isDeleted(n.getParent());
    }

    public void delete(String id) throws NodeNotFoundException {
        RefTreeNode m = this.getNode(id);
        if (m == null) {
            throw new NodeNotFoundException(id);
        }
        RefTreeNode p = m.getParent();
        if (p == null) {
            throw new IllegalArgumentException("Cannot delete root");
        }
        this.taint(p.getId(), null, true);
        Node n = this.findNode(id);
        if (((Node)n.getParent()).children.remove(id) == null) {
            Log.log("Parent/child inconsistency", 0);
        }
        this.nodeById.remove(id);
        this.delRoots.add(id);
        ++this.changeCount;
        if (this.changeTarget != null) {
            this.changeTarget.delete(id);
        }
    }

    public void insert(String parentId, long pos, String newId, Object content) throws NodeNotFoundException {
        this.taint(parentId, null, true);
        Node n = this.findNode(parentId);
        Node newNode = new Node(newId, n, content, false, false);
        newNode.children = ChangeTree.childListFactory();
        n.children.put(newId, newNode);
        this.nodeById.put(newId, newNode);
        ++this.changeCount;
        if (this.changeTarget != null) {
            this.changeTarget.insert(parentId, pos, newId, content);
        }
    }

    public void move(String nodeId, String parentId, long pos) throws NodeNotFoundException {
        this.verifyMove(nodeId, parentId);
        this.taint(parentId, null, true);
        Node n = this.findNode(nodeId);
        Node p = this.findNode(parentId);
        if (n == null) {
            n = new Node(nodeId, p, null, true, false);
            String origParentId = this.backingTree.getNode(nodeId).getParent().getId();
            this.taint(origParentId, null, true);
            Node origParent = this.findNode(origParentId);
            origParent.children.remove(nodeId);
        } else {
            ((Node)n.getParent()).children.remove(nodeId);
            n.parent = p;
        }
        p.children.put(nodeId, n);
        this.nodeById.put(nodeId, n);
        ++this.changeCount;
        if (this.changeTarget != null) {
            this.changeTarget.move(nodeId, parentId, pos);
        }
    }

    public boolean update(String nodeId, Object content) throws NodeNotFoundException {
        Object oldContent = this.getNode(nodeId).getContent();
        if (content.equals(oldContent)) {
            return false;
        }
        this.taint(nodeId, content, true);
        ++this.changeCount;
        if (this.changeTarget != null) {
            this.changeTarget.update(nodeId, content);
        }
        return true;
    }

    protected void verifyMove(String id, String newParent) {
        if (Util.equals(id, newParent)) {
            throw new IllegalArgumentException("Moving node to be child of its own subtree");
        }
        if (newParent != null) {
            try {
                this.verifyMove(id, this.getParent(newParent));
            }
            catch (NodeNotFoundException ex) {
                Log.log("Broken tree", 0);
            }
        }
    }

    protected Node findNode(String id) {
        return (Node)this.nodeById.get(id);
    }

    protected RefTreeNode taint(String id, Object content, boolean expandChildren) throws NodeNotFoundException {
        Node n = this.findNode(id);
        if (n == null) {
            this.taint(this.backingTree.getParent(id), null, true);
            n = this.findNode(id);
            if (n == null) {
                Log.log("The node " + id + " should exist now.", 0);
            }
        }
        if (expandChildren && n.isTreeRef) {
            n.expandChildren(this.backingTree, id, this.nodeById);
        }
        if (content != null) {
            n.expandContent(content);
        }
        return n;
    }

    public boolean hasChanges() {
        return this.changeCount > 0L;
    }

    private static Map childListFactory() {
        return new TreeMap(Util.STRINGS_BY_LENGTH);
    }

    private class ProxyNode
    implements RefTreeNode {
        private RefTreeNode n;
        private boolean transparent;

        public ProxyNode(RefTreeNode n, boolean transparent) {
            if (n == null) {
                Log.log("Can't proxy null", 0);
            }
            this.n = n;
            this.transparent = transparent;
        }

        public String getId() {
            return this.n.getId();
        }

        public RefTreeNode getParent() {
            RefTreeNode p = ChangeTree.this.findNode(this.n.getId());
            p = p != null ? p.getParent() : this.n.getParent();
            return p != null ? new ProxyNode(p, this.transparent) : null;
        }

        public Object getContent() {
            Object content = this.n.getContent();
            if (this.n instanceof Node && !((Node)this.n).contentExpanded() && this.transparent) {
                RefTreeNode n2 = ChangeTree.this.backingTree.getNode(this.n.getId());
                return n2 != null ? n2.getContent() : null;
            }
            return content;
        }

        public Iterator getChildIterator() {
            final Iterator niter = this.n instanceof Node && this.transparent && !((Node)this.n).childrenExpanded() ? ChangeTree.this.backingTree.getNode(this.n.getId()).getChildIterator() : this.n.getChildIterator();
            return new Iterator(){

                public void remove() {
                    niter.remove();
                }

                public boolean hasNext() {
                    return niter.hasNext();
                }

                public Object next() {
                    ProxyNode p = new ProxyNode((RefTreeNode)niter.next(), ProxyNode.this.transparent);
                    return p;
                }
            };
        }

        public boolean isReference() {
            return this.isTreeRef() || this.isNodeRef();
        }

        public boolean isTreeRef() {
            if (this.transparent) {
                RefTreeNode n2 = ChangeTree.this.backingTree.getNode(this.n.getId());
                return n2 != null ? n2.isTreeRef() : this.n.isTreeRef();
            }
            if (!this.n.isTreeRef() ^ ((Node)this.n).childrenExpanded()) {
                Log.log("treeref/child discrepancy", 0);
            }
            return this.n.isTreeRef();
        }

        public boolean isNodeRef() {
            if (this.transparent) {
                RefTreeNode n2 = ChangeTree.this.backingTree.getNode(this.n.getId());
                return n2 != null ? n2.isNodeRef() : this.n.isNodeRef();
            }
            if (this.n.isNodeRef() ^ this.n.getContent() == null && !this.n.isTreeRef()) {
                Log.log("ref/content discrepancy; nr=" + this.n.isNodeRef() + " cnt", 0, this.n.getContent());
            }
            return this.n.isNodeRef();
        }
    }

    private class Node
    implements RefTreeNode {
        private String id;
        private RefTreeNode parent;
        private Object content;
        private Map children = null;
        private boolean isTreeRef;
        private boolean isNodeRef;

        public Node(String id, RefTreeNode parent, Object content, boolean isTreeRef, boolean isNodeRef) {
            if (content == null && !isTreeRef && !isNodeRef) {
                Log.log("null content when not ref not supported", 0);
            }
            this.id = id;
            this.parent = parent;
            this.content = content;
            this.isTreeRef = isTreeRef;
            this.isNodeRef = isNodeRef;
        }

        public String getId() {
            return this.id;
        }

        public RefTreeNode getParent() {
            return this.parent;
        }

        public Object getContent() {
            return this.content;
        }

        public int getChildCount() {
            if (this.children == null && this.isNodeRef) {
                Log.log("A nodref should always have an expanded chlist", 0);
            }
            return this.children == null ? 0 : this.children.size();
        }

        public boolean isReference() {
            return this.isTreeRef || this.isNodeRef;
        }

        public boolean isTreeRef() {
            return this.isTreeRef;
        }

        public boolean isNodeRef() {
            return this.isNodeRef;
        }

        public Iterator getChildIterator() {
            if (this.children == null && this.isNodeRef) {
                Log.log("A nodref should always have an expanded chlist", 0);
            }
            return this.children != null ? this.children.values().iterator() : Collections.EMPTY_LIST.iterator();
        }

        boolean contentExpanded() {
            return this.content != null;
        }

        boolean childrenExpanded() {
            return this.children != null;
        }

        private void expandContent(Object content) {
            this.content = content;
            this.isNodeRef = false;
        }

        private void expandChildren(IdAddressableRefTree target, String id, Map nodeById) throws NodeNotFoundException {
            this.children = ChangeTree.childListFactory();
            Iterator i = target.childIterator(id);
            while (i.hasNext()) {
                String cid = (String)i.next();
                Node child = new Node(cid, this, null, true, false);
                this.children.put(cid, child);
                nodeById.put(cid, child);
            }
            this.isNodeRef = this.isTreeRef;
            this.isTreeRef = false;
        }
    }
}

