/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas.codec;

import fc.fp.util.Util;
import fc.fp.util.xas.ChainedContentEncoder;
import fc.fp.util.xas.ContentCodecFactory;
import fc.fp.util.xas.ContentEncoder;
import fc.fp.util.xas.Qname;
import fc.fp.util.xas.TypedXmlSerializer;
import fc.fp.util.xas.XmlWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class HashtableEncoder
extends ChainedContentEncoder {
    public HashtableEncoder(ContentEncoder chain) {
        this.chain = chain;
    }

    public boolean encode(Object o, String namespace, String name, TypedXmlSerializer ser) throws IOException {
        boolean result = false;
        if (Util.equals(namespace, "http://www.hiit.fi/fuego/fc/xas") && Util.equals(name, "hashtable")) {
            if (o instanceof Hashtable) {
                this.putTypeAttribute(namespace, name, ser);
                Hashtable h = (Hashtable)o;
                XmlWriter xw = new XmlWriter(ser);
                Enumeration e = h.keys();
                while (e.hasMoreElements()) {
                    Object k = e.nextElement();
                    Object v = h.get(k);
                    Qname kname = ContentCodecFactory.getXmlName(k.getClass());
                    if (kname == null) {
                        throw new IOException("Unknown type of object " + k);
                    }
                    xw.typedElement("http://www.hiit.fi/fuego/fc/xas", "key", kname.getNamespace(), kname.getName(), k);
                    Qname vname = ContentCodecFactory.getXmlName(v.getClass());
                    if (vname != null) {
                        xw.typedElement("http://www.hiit.fi/fuego/fc/xas", "value", vname.getNamespace(), vname.getName(), v);
                        continue;
                    }
                    throw new IOException("Unknown type of object " + v);
                }
                result = true;
            }
        } else if (this.chain != null) {
            result = this.chain.encode(o, namespace, name, ser);
        }
        return result;
    }
}

