/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.TypedXmlSerializer;
import fc.fp.util.xas.XasUtil;
import java.io.IOException;

public class XmlWriter {
    private TypedXmlSerializer current;

    public XmlWriter(TypedXmlSerializer ser) {
        this.current = ser;
    }

    public XmlWriter addEvent(Event event) throws IOException {
        XasUtil.outputEvent(event, this.current);
        return this;
    }

    public XmlWriter addEvents(EventSequence es) throws IOException {
        XasUtil.outputSequence(es, this.current);
        return this;
    }

    public XmlWriter emptyElement(String namespace, String name) throws IOException {
        return this.emptyElement(namespace, name, (EventSequence)null);
    }

    public XmlWriter emptyElement(String namespace, String name, Event attribute) throws IOException {
        EventList attributes = null;
        if (attribute != null) {
            attributes = new EventList();
            attributes.add(attribute);
        }
        return this.emptyElement(namespace, name, attributes);
    }

    public XmlWriter emptyElement(String namespace, String name, EventSequence attributes) throws IOException {
        return this.simpleElement(namespace, name, null, attributes);
    }

    public XmlWriter simpleElement(String namespace, String name, String content) throws IOException {
        return this.simpleElement(namespace, name, content, (EventSequence)null);
    }

    public XmlWriter simpleElement(String namespace, String name, String content, Event attribute) throws IOException {
        EventList attributes = null;
        if (attribute != null) {
            attributes = new EventList();
            attributes.add(attribute);
        }
        return this.simpleElement(namespace, name, content, attributes);
    }

    public XmlWriter simpleElement(String namespace, String name, String content, EventSequence attributes) throws IOException {
        this.current.startTag(namespace, name);
        if (attributes != null) {
            XasUtil.outputSequence(attributes, this.current);
        }
        if (content != null) {
            this.current.text(content);
        }
        this.current.endTag(namespace, name);
        return this;
    }

    public XmlWriter typedElement(String namespace, String name, String typeNamespace, String typeName, Object content) throws IOException {
        return this.typedElement(namespace, name, typeNamespace, typeName, content, (EventSequence)null);
    }

    public XmlWriter typedElement(String namespace, String name, String typeNamespace, String typeName, Object content, Event attribute) throws IOException {
        EventList attributes = null;
        if (attribute != null) {
            attributes = new EventList();
            attributes.add(attribute);
        }
        return this.typedElement(namespace, name, typeNamespace, typeName, content, attributes);
    }

    public XmlWriter typedElement(String namespace, String name, String typeNamespace, String typeName, Object content, EventSequence attributes) throws IOException {
        this.current.startTag(namespace, name);
        if (attributes != null) {
            XasUtil.outputSequence(attributes, this.current);
        }
        if (content != null) {
            this.current.typedContent(content, typeNamespace, typeName);
        }
        this.current.endTag(namespace, name);
        return this;
    }

    public XmlWriter complexElement(String namespace, String name, EventSequence content) throws IOException {
        return this.complexElement(namespace, name, content, (EventSequence)null);
    }

    public XmlWriter complexElement(String namespace, String name, EventSequence content, Event attribute) throws IOException {
        EventList attributes = null;
        if (attribute != null) {
            attributes = new EventList();
            attributes.add(attribute);
        }
        return this.complexElement(namespace, name, content, attributes);
    }

    public XmlWriter complexElement(String namespace, String name, EventSequence content, EventSequence attributes) throws IOException {
        this.current.startTag(namespace, name);
        if (attributes != null) {
            XasUtil.outputSequence(attributes, this.current);
        }
        if (content != null) {
            XasUtil.outputSequence(content, this.current);
        }
        this.current.endTag(namespace, name);
        return this;
    }

    public void flush() throws IOException {
        this.current.flush();
    }
}

