/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.Base64;
import fc.fp.util.xas.ContentEncoder;
import fc.fp.util.xas.TypedXmlSerializer;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;

public class XmlSchemaContentEncoder
implements ContentEncoder {
    public boolean encode(Object o, String namespace, String name, TypedXmlSerializer ser) throws IOException {
        boolean result = false;
        if ("http://www.w3.org/2001/XMLSchema".equals(namespace)) {
            String output = null;
            if (name != null) {
                Object b;
                if (name.equals("boolean")) {
                    b = (Boolean)o;
                    if (b != null) {
                        output = ((Boolean)b).booleanValue() ? "true" : "false";
                    }
                } else if (name.equals("int")) {
                    Integer i = (Integer)o;
                    if (i != null) {
                        output = i.toString();
                    }
                } else if (name.equals("string")) {
                    output = (String)o;
                } else if (name.equals("dateTime")) {
                    Calendar c = (Calendar)o;
                    if (c != null) {
                        c.setTimeZone(TimeZone.getTimeZone("GMT"));
                        StringBuffer buf = new StringBuffer();
                        int n = c.get(1);
                        if (n < 0) {
                            buf.append('-');
                            n = -n;
                        }
                        if (n < 1000) {
                            buf.append('0');
                        }
                        if (n < 100) {
                            buf.append('0');
                        }
                        if (n < 10) {
                            buf.append('0');
                        }
                        buf.append(n);
                        buf.append('-');
                        n = c.get(2) + 1;
                        if (n < 10) {
                            buf.append('0');
                        }
                        buf.append(n);
                        buf.append('-');
                        n = c.get(5);
                        if (n < 10) {
                            buf.append('0');
                        }
                        buf.append(n);
                        buf.append('T');
                        n = c.get(11);
                        if (n < 10) {
                            buf.append('0');
                        }
                        buf.append(n);
                        buf.append(':');
                        n = c.get(12);
                        if (n < 10) {
                            buf.append('0');
                        }
                        buf.append(n);
                        buf.append(':');
                        n = c.get(13);
                        if (n < 10) {
                            buf.append('0');
                        }
                        buf.append(n);
                        buf.append(".");
                        n = c.get(14);
                        if (n < 100) {
                            buf.append('0');
                        }
                        if (n < 10) {
                            buf.append('0');
                        }
                        buf.append(n);
                        output = buf.toString();
                    }
                } else if (name.equals("hexBinary") || name.equals("base64Binary")) {
                    b = (byte[])o;
                    if (b != null) {
                        output = new String(Base64.encode((byte[])b));
                    }
                } else if (name.equals("long")) {
                    Long l = (Long)o;
                    if (l != null) {
                        output = l.toString();
                    }
                } else if (name.equals("short")) {
                    Short s = (Short)o;
                    if (s != null) {
                        output = s.toString();
                    }
                } else if (name.equals("byte") && (b = (Byte)o) != null) {
                    output = ((Byte)b).toString();
                }
            }
            if (output != null) {
                String prefix = ser.getPrefix(namespace, false);
                ser.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", prefix + ":" + name);
                ser.text(output);
                result = true;
            }
        }
        return result;
    }
}

