/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.Base64;
import fc.fp.util.xas.ContentDecoder;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.XmlReader;
import java.util.Calendar;
import java.util.TimeZone;

public class XmlSchemaContentDecoder
extends ContentDecoder {
    private static int getTwoInt(String string, int index, char last) {
        int i = index + 2;
        if (last != '$') {
            i = string.indexOf(last, index);
        }
        if (i - index == 2) {
            return Integer.parseInt(string.substring(index, i));
        }
        throw new NumberFormatException(string + ":" + index + ":" + last);
    }

    public Object decode(String typeNs, String typeName, XmlReader reader, EventList attributes) {
        Object result = null;
        if ("http://www.w3.org/2001/XMLSchema".equals(typeNs) && typeName != null) {
            Event ev = reader.advance();
            if (ev != null && ev.getType() == 5) {
                String content = (String)ev.getValue();
                if (content != null) {
                    if (typeName.equals("boolean")) {
                        if (content.equals("true") || content.equals("1")) {
                            result = new Boolean(true);
                        } else if (content.equals("false") || content.equals("0")) {
                            result = new Boolean(false);
                        }
                    } else if (typeName.equals("int")) {
                        if (content.charAt(0) == '+') {
                            content = content.substring(1);
                        }
                        result = new Integer(Integer.parseInt(content));
                    } else if (typeName.equals("string")) {
                        result = content;
                    } else if (typeName.equals("dateTime")) {
                        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                        int i = content.indexOf(45);
                        if (i > 0) {
                            int year = Integer.parseInt(content.substring(0, i++));
                            int month = XmlSchemaContentDecoder.getTwoInt(content, i, '-');
                            int day = XmlSchemaContentDecoder.getTwoInt(content, i += 3, 'T');
                            int hour = XmlSchemaContentDecoder.getTwoInt(content, i += 3, ':');
                            int minute = XmlSchemaContentDecoder.getTwoInt(content, i += 3, ':');
                            int second = XmlSchemaContentDecoder.getTwoInt(content, i += 3, '$');
                            int ms = 0;
                            if (content.length() > (i += 2) && content.charAt(i) == '.') {
                                int j;
                                for (j = ++i; j < content.length() && Character.isDigit(content.charAt(j)); ++j) {
                                }
                                ms = Integer.parseInt(content.substring(i, j));
                            }
                            c.set(1, year);
                            c.set(2, month - 1);
                            c.set(5, day);
                            c.set(11, hour);
                            c.set(12, minute);
                            c.set(13, second);
                            c.set(14, ms);
                        }
                        result = c;
                    } else if (typeName.equals("hexBinary") || typeName.equals("base64Binary")) {
                        result = Base64.decode(content.toCharArray());
                    } else if (typeName.equals("long")) {
                        if (content.charAt(0) == '+') {
                            content = content.substring(1);
                        }
                        result = new Long(Long.parseLong(content));
                    } else if (typeName.equals("short")) {
                        if (content.charAt(0) == '+') {
                            content = content.substring(1);
                        }
                        result = new Short(Short.parseShort(content));
                    } else if (typeName.equals("byte")) {
                        if (content.charAt(0) == '+') {
                            content = content.substring(1);
                        }
                        result = new Byte(Byte.parseByte(content));
                    }
                }
            } else {
                reader.backup();
            }
        }
        return result;
    }
}

