/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.Util;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventSequence;

public class XmlReader {
    private EventSequence es;
    private int index = 0;

    private void skipNamespaces() {
        Event ev = this.es.get(this.index);
        while (ev != null && ev.getType() == 7) {
            ++this.index;
            ev = this.es.get(this.index);
        }
    }

    public XmlReader(EventSequence es) {
        this.es = es;
    }

    public boolean isFinished() {
        return this.es.get(this.index) == null;
    }

    public Event getCurrentEvent() {
        return this.es.get(this.index);
    }

    public EventSequence getEventSequence() {
        return this.es;
    }

    public Event advance() {
        if (!this.isFinished()) {
            return this.es.get(this.index++);
        }
        return null;
    }

    public void backup() {
        this.backup(1);
    }

    public void backup(int amount) {
        if (amount >= 1 && this.index >= amount) {
            this.index -= amount;
        }
    }

    public int getCurrentPosition() {
        return this.index;
    }

    public void setCurrentPosition(int pos) {
        this.index = pos;
    }

    public void reset(EventSequence es) {
        this.es = es;
        this.index = 0;
    }

    public boolean skipElement() {
        boolean result = false;
        int i = this.index;
        Event current = this.es.get(this.index);
        if (current != null && current.getType() == 2) {
            Event ev;
            int depth = 1;
            while (depth > 0 && (ev = this.es.get(++this.index)) != null) {
                if (ev.getType() == 2) {
                    ++depth;
                    continue;
                }
                if (ev.getType() != 4) continue;
                --depth;
            }
            if (depth == 0) {
                ++this.index;
                result = true;
            }
        }
        return result;
    }

    public boolean skipElement(String namespace, String name) {
        boolean result = false;
        Event current = this.es.get(this.index);
        if (Util.equals(current.getNamespace(), namespace) && Util.equals(current.getName(), name)) {
            result = this.skipElement();
        }
        return result;
    }

    public String simpleContent(String namespace, String name) {
        String result = null;
        int i = this.index;
        Event ev = this.es.get(i);
        while (ev.getType() == 7) {
            ev = this.es.get(++i);
        }
        if (ev.getType() == 2 && Util.equals(ev.getNamespace(), namespace) && Util.equals(ev.getName(), name)) {
            while ((ev = this.es.get(++i)).getType() == 3) {
            }
            if (ev.getType() == 5) {
                StringBuffer buffer = new StringBuffer((String)ev.getValue());
                ev = this.es.get(++i);
                while (ev.getType() == 5) {
                    buffer.append((String)ev.getValue());
                    ev = this.es.get(++i);
                }
                if (ev.getType() == 4 && Util.equals(ev.getNamespace(), namespace) && Util.equals(ev.getName(), name)) {
                    result = buffer.toString();
                    this.index = i + 1;
                }
            }
        }
        return result;
    }

    public Object typedContent(String namespace, String name, String typeNs, String typeName) {
        Object result = null;
        int i = this.index;
        Event ev = this.es.get(i);
        while (ev.getType() == 7) {
            ev = this.es.get(++i);
        }
        if (ev.getType() == 2 && Util.equals(ev.getNamespace(), namespace) && Util.equals(ev.getName(), name)) {
            while ((ev = this.es.get(++i)).getType() == 3) {
            }
            if (ev.getType() == 6 && Util.equals(ev.getNamespace(), typeNs) && Util.equals(ev.getName(), typeName)) {
                Object value = ev.getValue();
                if ((ev = this.es.get(++i)).getType() == 4 && Util.equals(ev.getNamespace(), namespace) && Util.equals(ev.getName(), name)) {
                    result = value;
                    this.index = i + 1;
                }
            }
        }
        return result;
    }

    public EventSequence completeContent(String namespace, String name) {
        EventSequence result = null;
        int i = this.index;
        Event ev = this.es.get(i);
        while (ev.getType() == 7) {
            ev = this.es.get(++i);
        }
        if (ev.getType() == 2 && Util.equals(ev.getNamespace(), namespace) && Util.equals(ev.getName(), name)) {
            while ((ev = this.es.get(++i)).getType() == 3) {
            }
            int j = i - 1;
            int depth = 0;
            while (depth >= 0 && (ev = this.es.get(++j)) != null) {
                if (ev.getType() == 2) {
                    ++depth;
                    continue;
                }
                if (ev.getType() != 4) continue;
                --depth;
            }
            if (ev != null && ev.getType() == 4) {
                result = this.es.subSequence(i, j);
                this.index = j + 1;
            }
        }
        return result;
    }

    public EventSequence currentElement() {
        EventSequence result = null;
        int init = this.index;
        this.skipNamespaces();
        int i = this.index;
        if (this.skipElement()) {
            result = this.es.subSequence(i, this.index);
        }
        if (result == null) {
            this.index = init;
        }
        return result;
    }

    public EventSequence currentDelimiter() {
        return this.currentDelimiter(null, null, true);
    }

    public EventSequence currentDelimiter(String namespace, String name) {
        return this.currentDelimiter(namespace, name, false);
    }

    protected EventSequence currentDelimiter(String namespace, String name, boolean ignoreName) {
        boolean nameMatch;
        EventSequence result = null;
        int i = this.index;
        this.skipNamespaces();
        Event current = this.es.get(i);
        if (current == null) {
            return null;
        }
        boolean bl = nameMatch = ignoreName || Util.equals(current.getNamespace(), namespace) && Util.equals(current.getName(), name);
        if (current.getType() == 2 && nameMatch) {
            while ((current = this.es.get(++i)) != null && current.getType() == 3) {
            }
            result = this.es.subSequence(this.index, i);
            this.index = i;
        } else if (current.getType() == 4 && nameMatch) {
            result = this.es.subSequence(this.index, this.index + 1);
            ++this.index;
        }
        return result;
    }

    public EventSequence currentElement(String namespace, String name) {
        EventSequence result = null;
        int init = this.index;
        this.skipNamespaces();
        int i = this.index;
        if (this.skipElement(namespace, name)) {
            result = this.es.subSequence(i, this.index);
        }
        if (result == null) {
            this.index = init;
        }
        return result;
    }

    public EventSequence nextElement(String namespace, String name) {
        EventSequence result = null;
        int i = this.index;
        Event current = this.es.get(this.index);
        while (current != null && current.getType() != 4) {
            if (current.getType() == 2) {
                if (Util.equals(current.getNamespace(), namespace) && Util.equals(current.getName(), name)) break;
                this.skipElement();
            } else {
                ++this.index;
            }
            current = this.es.get(this.index);
        }
        if (current != null) {
            result = this.currentElement(namespace, name);
        }
        if (result == null) {
            this.index = i;
        }
        return result;
    }

    public EventSequence nextInsideElement(String namespace, String name) {
        EventSequence result = null;
        int i = this.index;
        int depth = 0;
        Event current = null;
        while (depth >= 0 && (current = this.es.get(this.index)) != null) {
            if (current.getType() == 2) {
                if (Util.equals(current.getNamespace(), namespace) && Util.equals(current.getName(), name)) break;
                ++depth;
            } else if (current.getType() == 4) {
                --depth;
            }
            ++this.index;
        }
        if (depth >= 0 && current != null) {
            result = this.currentElement(namespace, name);
        }
        if (result == null) {
            this.index = i;
        }
        return result;
    }

    public String toString() {
        return "XmlReader(" + this.index + ")" + this.es.toString();
    }
}

