/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.xas.CodecFactory;
import fc.fp.util.xas.CodecIndustry;
import fc.fp.util.xas.ContentCodecFactory;
import fc.fp.util.xas.ContentDecoder;
import fc.fp.util.xas.ContentEncoder;
import fc.fp.util.xas.DefaultXmlParser;
import fc.fp.util.xas.DefaultXmlSerializer;
import fc.fp.util.xas.TypedXmlParser;
import fc.fp.util.xas.TypedXmlSerializer;
import java.util.Enumeration;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParserException;

public class XmlCodecFactory
implements CodecFactory {
    private static XmlCodecFactory factory = new XmlCodecFactory();
    private Vector factories = null;

    private XmlCodecFactory() {
        CodecIndustry.registerFactory("text/xml", this);
        CodecIndustry.registerFactory("application/soap+xml", this);
    }

    public static XmlCodecFactory getInstance() {
        return factory;
    }

    public TypedXmlParser getNewDecoder(Object token) {
        DefaultXmlParser result = new DefaultXmlParser();
        if (this.factories != null && this.factories.size() > 0) {
            ContentDecoder dec = (ContentDecoder)result.getProperty("http://www.hiit.fi/fuego/fc/xas/typed-codec");
            Enumeration e = this.factories.elements();
            while (e.hasMoreElements()) {
                ContentCodecFactory fac = (ContentCodecFactory)e.nextElement();
                dec = fac.getChainedDecoder(dec);
            }
            try {
                result.setProperty("http://www.hiit.fi/fuego/fc/xas/typed-codec", dec);
            }
            catch (XmlPullParserException ex) {
                // empty catch block
            }
        }
        return result;
    }

    public TypedXmlSerializer getNewEncoder(Object token) {
        DefaultXmlSerializer result = new DefaultXmlSerializer();
        if (this.factories != null && this.factories.size() > 0) {
            ContentEncoder enc = (ContentEncoder)result.getProperty("http://www.hiit.fi/fuego/fc/xas/typed-codec");
            Enumeration e = this.factories.elements();
            while (e.hasMoreElements()) {
                ContentCodecFactory fac = (ContentCodecFactory)e.nextElement();
                enc = fac.getChainedEncoder(enc);
            }
            result.setProperty("http://www.hiit.fi/fuego/fc/xas/typed-codec", enc);
        }
        return result;
    }

    public void resetOutState(Object token) {
    }

    public void resetInState(Object token) {
    }

    public void installContentFactories(Vector list) {
        this.factories = list;
    }
}

