/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.Util;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.TypedXmlSerializer;
import java.io.IOException;
import java.util.Enumeration;

public class XasUtil {
    public static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XAS_NAMESPACE = "http://www.hiit.fi/fuego/fc/xas";
    public static final String PROPERTY_CONTENT_CODEC = "http://www.hiit.fi/fuego/fc/xas/typed-codec";

    private XasUtil() {
    }

    public static void outputEvent(Event ev, TypedXmlSerializer ser) throws IOException {
        switch (ev.getType()) {
            case 0: {
                ser.startDocument(null, null);
                break;
            }
            case 1: {
                ser.endDocument();
                break;
            }
            case 2: {
                ser.startTag(ev.getNamespace(), ev.getName());
                break;
            }
            case 3: {
                ser.attribute(ev.getNamespace(), ev.getName(), (String)ev.getValue());
                break;
            }
            case 4: {
                ser.endTag(ev.getNamespace(), ev.getName());
                break;
            }
            case 5: {
                ser.text((String)ev.getValue());
                break;
            }
            case 6: {
                ser.typedContent(ev.getValue(), ev.getNamespace(), ev.getName());
                break;
            }
            case 7: {
                ser.setPrefix((String)ev.getValue(), ev.getNamespace());
                break;
            }
            case 8: {
                ser.comment((String)ev.getValue());
                break;
            }
            case 9: {
                ser.processingInstruction((String)ev.getValue());
                break;
            }
            case 10: {
                ser.entityRef(ev.getName());
                break;
            }
            default: {
                if ((ev.getType() & 0xFF000000) == 0x43000000) {
                    EventSequence es = (EventSequence)ev.getValue();
                    if (es == null) break;
                    XasUtil.outputSequence(es, ser);
                    break;
                }
                throw new IOException("Unrecognized Event type " + ev.getType());
            }
        }
    }

    public static void outputSequence(EventSequence es, TypedXmlSerializer ser) throws IOException {
        Enumeration e = es.events();
        while (e.hasMoreElements()) {
            Event ev = (Event)e.nextElement();
            XasUtil.outputEvent(ev, ser);
        }
    }

    public static boolean sequenceEquals(EventSequence es1, EventSequence es2) {
        boolean result = true;
        if (es1 == null) {
            if (es2 != null) {
                result = false;
            }
        } else if (es2 == null) {
            result = false;
        } else {
            Enumeration i = es1.events();
            Enumeration j = es2.events();
            while (result && i.hasMoreElements() && j.hasMoreElements()) {
                result = result && Util.equals(i.nextElement(), j.nextElement());
            }
            if (result && (i.hasMoreElements() || j.hasMoreElements())) {
                result = false;
            }
        }
        return result;
    }

    public static int sequenceHashCode(EventSequence es) {
        int result = 0;
        if (es != null) {
            Enumeration e = es.events();
            while (e.hasMoreElements()) {
                result = 31 * result + Util.hashCode(e.nextElement());
            }
        }
        return result;
    }
}

