/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.Base64;
import fc.fp.util.MagicInputStream;
import fc.fp.util.Util;
import fc.fp.util.xas.CodecFactory;
import fc.fp.util.xas.CodecIndustry;
import fc.fp.util.xas.DefaultXmlParser;
import fc.fp.util.xas.DefaultXmlSerializer;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.Qname;
import fc.fp.util.xas.TypedXmlParser;
import fc.fp.util.xas.TypedXmlSerializer;
import fc.fp.util.xas.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Stack;
import java.util.TimeZone;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.xmlpull.v1.XmlPullParserException;

public class XasExtUtil {
    private static final String LIST_NAMESPACE = "http://www.hiit.fi/fuego/fc/list-type";
    private static final String[] XSD_RESTRICTION_TYPES = new String[]{"boolean", "int", "integer", "normalizedString", "string", "token", "date", "dateTime", "base64Binary", "long", "short", "byte", "float", "double", "decimal"};
    private static final String[] INVOICE_TYPE_MAP = new String[]{"AmountType", "decimal", "CodeType", "token", "DateTimeType", "dateTime", "DateType", "date", "IdentifierType", "normalizedString", "NumericType", "decimal", "QuantityType", "decimal"};
    private static final String INVOICE_TYPE_NAMESPACE = "urn:oasis:names:tc:ubl:CommonLeafTypes:1.0:0.65";
    private static final Float minusZeroFloat = Float.valueOf(Float.parseFloat("-0.0"));
    private static final Float plusZeroFloat = Float.valueOf(Float.parseFloat("0.0"));
    private static final Double minusZeroDouble = Double.parseDouble("-0.0");
    private static final Double plusZeroDouble = Double.parseDouble("0.0");

    private XasExtUtil() {
    }

    private static String searchPrefix(String namespace, Stack nss) {
        for (int i = nss.size() - 1; i >= 0; --i) {
            EventList el = (EventList)nss.elementAt(i);
            for (int j = 0; j < el.size(); ++j) {
                Event ev = el.get(j);
                if (!Util.equals(namespace, ev.getNamespace())) continue;
                return (String)ev.getValue();
            }
        }
        return null;
    }

    private static Node readerToDom(Document doc, XmlReader xr, Stack nss) {
        Node result = null;
        Event ev = xr.getCurrentEvent();
        EventList pms = new EventList();
        switch (ev.getType()) {
            case 0: {
                Node node;
                xr.advance();
                while ((node = XasExtUtil.readerToDom(doc, xr)) != null) {
                    doc.appendChild(node);
                }
                result = doc;
                break;
            }
            case 1: {
                xr.advance();
                break;
            }
            case 7: {
                do {
                    pms.add(xr.advance());
                } while ((ev = xr.getCurrentEvent()).getType() == 7);
            }
            case 2: {
                Node node;
                nss.push(pms);
                String ns = ev.getNamespace();
                String name = ev.getName();
                String prefix = XasExtUtil.searchPrefix(ns, nss);
                if (prefix != null) {
                    name = prefix + ":" + name;
                }
                Element elem = doc.createElementNS(ns, name);
                Enumeration e = pms.events();
                while (e.hasMoreElements()) {
                    ev = (Event)e.nextElement();
                    elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + ev.getValue(), ev.getNamespace());
                }
                xr.advance();
                while ((ev = xr.getCurrentEvent()).getType() == 3) {
                    ns = ev.getNamespace();
                    name = ev.getName();
                    prefix = XasExtUtil.searchPrefix(ns, nss);
                    if (prefix != null) {
                        name = prefix + ":" + name;
                    }
                    elem.setAttributeNS(ns, name, (String)ev.getValue());
                    xr.advance();
                }
                while ((node = XasExtUtil.readerToDom(doc, xr, nss)) != null) {
                    elem.appendChild(node);
                }
                nss.pop();
                result = elem;
                break;
            }
            case 4: {
                xr.advance();
                break;
            }
            case 5: {
                result = doc.createTextNode((String)ev.getValue());
                xr.advance();
                break;
            }
            case 8: {
                result = doc.createComment((String)ev.getValue());
                xr.advance();
                break;
            }
            case 9: {
                String target = (String)ev.getValue();
                String data = null;
                int i = target.indexOf(32);
                if (i >= 0) {
                    data = target.substring(i + 1);
                    target = target.substring(0, i);
                }
                result = doc.createProcessingInstruction(target, data);
                xr.advance();
                break;
            }
            case 10: {
                result = doc.createEntityReference(ev.getName());
                xr.advance();
                break;
            }
            default: {
                if ((ev.getType() & 0xFF000000) == 0x43000000) {
                    EventSequence es = (EventSequence)ev.getValue();
                    if (es == null) break;
                    result = XasExtUtil.sequenceToDom(doc, es);
                    break;
                }
                throw new IllegalArgumentException("Unhandled event type: " + ev.getType());
            }
        }
        return result;
    }

    public static Node readerToDom(Document doc, XmlReader xr) {
        return XasExtUtil.readerToDom(doc, xr, new Stack());
    }

    public static Node sequenceToDom(Document doc, EventSequence es) {
        XmlReader reader = new XmlReader(es);
        return XasExtUtil.readerToDom(doc, reader);
    }

    private static int getTwoInt(String string, int index, char last) {
        int i = index + 2;
        if (last != '$') {
            i = string.indexOf(last, index);
        }
        if (i - index == 2) {
            return Integer.parseInt(string.substring(index, i));
        }
        throw new NumberFormatException(string + ":" + index + ":" + last);
    }

    private static String mapNamespace(TypeInfo ti) {
        for (String type : XSD_RESTRICTION_TYPES) {
            if (!ti.isDerivedFrom("http://www.w3.org/2001/XMLSchema", type, 1)) continue;
            return "http://www.w3.org/2001/XMLSchema";
        }
        if (Util.equals(ti.getTypeNamespace(), INVOICE_TYPE_NAMESPACE)) {
            for (int i = 0; i < INVOICE_TYPE_MAP.length; i += 2) {
                if (!INVOICE_TYPE_MAP[i].equals(ti.getTypeName())) continue;
                return "http://www.w3.org/2001/XMLSchema";
            }
        }
        if (ti.isDerivedFrom("http://www.w3.org/2001/XMLSchema", "base64Binary", 2)) {
            return "http://www.w3.org/2001/XMLSchema";
        }
        if (ti.getTypeNamespace() == null && Util.equals(ti.getTypeName(), "xcrdtype")) {
            return LIST_NAMESPACE;
        }
        return ti.getTypeNamespace();
    }

    private static String mapName(TypeInfo ti) {
        for (String type : XSD_RESTRICTION_TYPES) {
            if (!ti.isDerivedFrom("http://www.w3.org/2001/XMLSchema", type, 1)) continue;
            return type;
        }
        if (Util.equals(ti.getTypeNamespace(), INVOICE_TYPE_NAMESPACE)) {
            for (int i = 0; i < INVOICE_TYPE_MAP.length; i += 2) {
                if (!INVOICE_TYPE_MAP[i].equals(ti.getTypeName())) continue;
                return INVOICE_TYPE_MAP[i + 1];
            }
        }
        if (ti.isDerivedFrom("http://www.w3.org/2001/XMLSchema", "base64Binary", 2)) {
            return "base64Binary";
        }
        if (ti.getTypeNamespace() == null && Util.equals(ti.getTypeName(), "xcrdtype")) {
            return "decimal";
        }
        return ti.getTypeName();
    }

    private static Object decodeXml(Node n, String typeNs, String typeName, String content) {
        Object result = null;
        String trimmed = content.trim();
        if (Util.equals(typeNs, "http://www.w3.org/2001/XMLSchema")) {
            try {
                if (typeName.equals("boolean")) {
                    if (trimmed.equals("true") || trimmed.equals("1")) {
                        result = new Boolean(true);
                    } else if (trimmed.equals("false") || trimmed.equals("0")) {
                        result = new Boolean(false);
                    }
                } else if (typeName.equals("int")) {
                    if (trimmed.charAt(0) == '+') {
                        trimmed = trimmed.substring(1);
                    }
                    result = new Integer(Integer.parseInt(trimmed));
                } else if (typeName.equals("integer")) {
                    if (trimmed.charAt(0) == '+') {
                        trimmed = trimmed.substring(1);
                    }
                    result = new BigInteger(trimmed);
                } else if (typeName.equals("string")) {
                    result = content;
                } else if (typeName.equals("normalizedString")) {
                    result = content.replaceAll("\\n", " ");
                } else if (typeName.equals("token")) {
                    result = trimmed.replaceAll("\\s{2,}", " ");
                } else if (typeName.equals("date")) {
                    Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                    int i = trimmed.indexOf(45);
                    if (i > 0) {
                        int year = Integer.parseInt(trimmed.substring(0, i++));
                        int month = XasExtUtil.getTwoInt(trimmed, i, '-');
                        int day = XasExtUtil.getTwoInt(trimmed, i += 3, '$');
                        c.set(1, year);
                        c.set(2, month - 1);
                        c.set(5, day);
                        c.set(11, 0);
                        c.set(12, 0);
                        c.set(13, 0);
                        c.set(14, 0);
                        result = c;
                    }
                } else if (typeName.equals("dateTime")) {
                    Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                    int i = trimmed.indexOf(45);
                    if (i > 0) {
                        int year = Integer.parseInt(trimmed.substring(0, i++));
                        int month = XasExtUtil.getTwoInt(trimmed, i, '-');
                        int day = XasExtUtil.getTwoInt(trimmed, i += 3, 'T');
                        int hour = XasExtUtil.getTwoInt(trimmed, i += 3, ':');
                        int minute = XasExtUtil.getTwoInt(trimmed, i += 3, ':');
                        int second = XasExtUtil.getTwoInt(trimmed, i += 3, '$');
                        int ms = 0;
                        if (trimmed.length() > (i += 2) && trimmed.charAt(i) == '.') {
                            int j;
                            for (j = ++i; j < trimmed.length() && Character.isDigit(trimmed.charAt(j)); ++j) {
                                if (j >= i + 3) continue;
                                ms = 10 * ms + Character.digit(trimmed.charAt(j), 10);
                            }
                            for (int k = j; k < i + 3; ++k) {
                                ms *= 10;
                            }
                            i = j;
                        }
                        c.set(1, year);
                        c.set(2, month - 1);
                        c.set(5, day);
                        c.set(11, hour);
                        c.set(12, minute);
                        c.set(13, second);
                        c.set(14, ms);
                        if (trimmed.length() > i) {
                            char ch = trimmed.charAt(i);
                            if (ch == 'Z') {
                                if (++i < trimmed.length()) {
                                    throw new IllegalArgumentException("Extraneous trailing content in <" + trimmed + ">");
                                }
                            } else {
                                int hh = XasExtUtil.getTwoInt(trimmed, ++i, ':');
                                int mm = XasExtUtil.getTwoInt(trimmed, i += 3, '$');
                                if ((i += 2) < trimmed.length()) {
                                    throw new IllegalArgumentException("Extraneous trailing content in <" + trimmed + ">");
                                }
                                if (ch == '-') {
                                    hh = -hh;
                                    mm = -mm;
                                }
                                c.add(11, hh);
                                c.add(12, mm);
                            }
                        }
                        result = c;
                    }
                } else if (typeName.equals("base64Binary")) {
                    result = Base64.decode(trimmed.toCharArray());
                } else if (typeName.equals("long")) {
                    if (trimmed.charAt(0) == '+') {
                        trimmed = trimmed.substring(1);
                    }
                    result = new Long(Long.parseLong(trimmed));
                } else if (typeName.equals("short")) {
                    if (trimmed.charAt(0) == '+') {
                        trimmed = trimmed.substring(1);
                    }
                    result = new Short(Short.parseShort(trimmed));
                } else if (typeName.equals("byte")) {
                    if (trimmed.charAt(0) == '+') {
                        trimmed = trimmed.substring(1);
                    }
                    result = new Byte(Byte.parseByte(trimmed));
                } else if (typeName.equals("float")) {
                    Float f = Float.valueOf(Float.parseFloat(trimmed));
                    if (f.equals(minusZeroFloat)) {
                        f = plusZeroFloat;
                    }
                    result = f;
                } else if (typeName.equals("double")) {
                    Double d = Double.parseDouble(trimmed);
                    if (d.equals(minusZeroDouble)) {
                        d = plusZeroDouble;
                    }
                    result = d;
                } else if (typeName.equals("decimal")) {
                    BigDecimal bd = new BigDecimal(trimmed).stripTrailingZeros();
                    if (bd.compareTo(BigDecimal.ZERO) == 0) {
                        bd = BigDecimal.ZERO;
                    }
                    result = bd;
                } else if (typeName.equals("QName")) {
                    String namespace;
                    String localName = trimmed;
                    String prefix = null;
                    int index = localName.indexOf(58);
                    if (index > 0) {
                        prefix = localName.substring(0, index);
                        localName = localName.substring(index + 1);
                    }
                    if ((namespace = n.lookupNamespaceURI(prefix)) == null) {
                        namespace = "";
                    }
                    result = new Qname(namespace, localName);
                }
            }
            catch (NumberFormatException ex) {
                result = trimmed;
            }
        } else if (Util.equals(typeNs, LIST_NAMESPACE)) {
            String[] components = trimmed.split("\\s+");
            ArrayList<Object> list = new ArrayList<Object>(components.length);
            for (String s : components) {
                Object o = XasExtUtil.decodeXml(n, "http://www.w3.org/2001/XMLSchema", typeName, s);
                if (o == null) {
                    return null;
                }
                list.add(o);
            }
            result = list;
        }
        return result;
    }

    public static EventSequence domToSequence(Node n) {
        return XasExtUtil.domToSequence(n, null, null, true, true);
    }

    public static EventSequence domToSequence(Node n, boolean preservePrefix, boolean decodeTypes) {
        return XasExtUtil.domToSequence(n, null, null, preservePrefix, decodeTypes);
    }

    public static EventSequence domToSequence(Node n, String typeNs, String typeName, boolean preservePrefix, boolean decodeTypes) {
        EventList el = new EventList();
        switch (n.getNodeType()) {
            case 9: {
                el.add(Event.createStartDocument());
                NodeList nodes = n.getChildNodes();
                if (nodes != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        el.addAll(XasExtUtil.domToSequence(nodes.item(i), preservePrefix, decodeTypes));
                    }
                }
                el.add(Event.createEndDocument());
                break;
            }
            case 10: {
                DocumentType node = (DocumentType)n;
                String name = node.getName();
                String publicId = node.getPublicId();
                String systemId = node.getSystemId();
                StringBuffer text = new StringBuffer(" " + name + " ");
                if (publicId != null) {
                    text.append("PUBLIC " + publicId + " " + systemId);
                } else {
                    text.append("SYSTEM " + systemId);
                }
                el.add(Event.createDoctypeDeclaration(text.toString()));
                break;
            }
            case 1: {
                String ns;
                EventList pms = new EventList();
                EventList atts = new EventList();
                NamedNodeMap attMap = n.getAttributes();
                for (int i = 0; i < attMap.getLength(); ++i) {
                    Object o;
                    Attr att = (Attr)attMap.item(i);
                    String name = att.getNodeName();
                    if (name.startsWith("xmlns:")) {
                        pms.add(Event.createNamespacePrefix(att.getValue(), name.substring(6)));
                        continue;
                    }
                    if (name.equals("xmlns")) {
                        pms.add(Event.createNamespacePrefix(att.getValue(), ""));
                        continue;
                    }
                    String ans = att.getNamespaceURI();
                    if (ans == null) {
                        ans = "";
                    }
                    TypeInfo ti = att.getSchemaTypeInfo();
                    if (decodeTypes && ti != null) {
                        o = XasExtUtil.decodeXml(att, XasExtUtil.mapNamespace(ti), XasExtUtil.mapName(ti), att.getValue());
                        if (o != null) {
                            atts.add(Event.createTypedAttribute(ans, att.getLocalName(), o));
                            continue;
                        }
                        atts.add(Event.createAttribute(ans, att.getLocalName(), att.getValue()));
                        continue;
                    }
                    if (decodeTypes && ans.equals("http://www.w3.org/2001/XMLSchema-instance") && att.getLocalName().equals("type")) {
                        o = XasExtUtil.decodeXml(att, "http://www.w3.org/2001/XMLSchema", "QName", att.getValue());
                        if (o != null) {
                            atts.add(Event.createTypedAttribute(ans, att.getLocalName(), o));
                            continue;
                        }
                        atts.add(Event.createAttribute(ans, att.getLocalName(), att.getValue()));
                        continue;
                    }
                    atts.add(Event.createAttribute(ans, att.getLocalName(), att.getValue()));
                }
                if (preservePrefix) {
                    el.addAll(pms);
                }
                if ((ns = n.getNamespaceURI()) == null) {
                    ns = "";
                }
                el.add(Event.createStartElement(ns, n.getLocalName()));
                el.addAll(atts);
                NodeList children = n.getChildNodes();
                if (children != null) {
                    TypeInfo ti = ((Element)n).getSchemaTypeInfo();
                    for (int i = 0; i < children.getLength(); ++i) {
                        if (decodeTypes && ti != null) {
                            el.addAll(XasExtUtil.domToSequence(children.item(i), XasExtUtil.mapNamespace(ti), XasExtUtil.mapName(ti), preservePrefix, decodeTypes));
                            continue;
                        }
                        el.addAll(XasExtUtil.domToSequence(children.item(i), preservePrefix, decodeTypes));
                    }
                }
                el.add(Event.createEndElement(ns, n.getLocalName()));
                break;
            }
            case 3: 
            case 4: {
                if (decodeTypes && typeNs != null && typeName != null) {
                    Object o = XasExtUtil.decodeXml(n, typeNs, typeName, n.getNodeValue());
                    if (o != null) {
                        el.add(Event.createTypedContent(typeNs, typeName, o));
                        break;
                    }
                    el.add(Event.createContent(n.getNodeValue()));
                    break;
                }
                el.add(Event.createContent(n.getNodeValue()));
                break;
            }
            case 5: {
                el.add(Event.createEntityReference(n.getNodeName()));
                break;
            }
            case 7: {
                el.add(Event.createProcessingInstruction(n.getNodeName() + " " + n.getNodeValue()));
                break;
            }
            case 8: {
                el.add(Event.createComment(n.getNodeValue()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled node type: " + n.getNodeType());
            }
        }
        return el;
    }

    public static TypedXmlParser getParser(InputStream in, String enc) throws IOException {
        return XasExtUtil.getParser(new AggressiveXmlIdentifier(in), enc);
    }

    public static TypedXmlParser getParser(MagicInputStream in, String enc) throws IOException {
        String type = in.getMimeType();
        if (type == null) {
            return null;
        }
        CodecFactory cf = CodecIndustry.getFactory(type);
        if (cf == null) {
            return null;
        }
        TypedXmlParser p = cf.getNewDecoder(new Object());
        try {
            boolean isBinary = !(p instanceof DefaultXmlParser);
            p.setInput(in, isBinary ? p.getInputEncoding() : enc);
        }
        catch (XmlPullParserException ex) {
            IOException iox = new IOException("XmlPullParserException " + (Object)((Object)ex));
            throw iox;
        }
        return p;
    }

    public static TypedXmlSerializer getSerializer(OutputStream out, String enc) throws IOException {
        return XasExtUtil.getSerializer(out, "application/x-ebu+item", enc);
    }

    public static TypedXmlSerializer getSerializer(OutputStream out, String mimeType, String enc) throws IOException {
        CodecFactory cf = CodecIndustry.getFactory(mimeType);
        if (cf == null) {
            return null;
        }
        TypedXmlSerializer ser = cf.getNewEncoder(new Object());
        boolean isBinary = !(ser instanceof DefaultXmlSerializer);
        ser.setOutput(out, isBinary ? "ISO-8859-1" : enc);
        if (!isBinary) {
            ser.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        }
        return ser;
    }

    public static class AggressiveXmlIdentifier
    extends XebuXmlIdentifier {
        public AggressiveXmlIdentifier(InputStream in) throws IOException {
            super(in);
        }

        protected String identify(byte[] magic, int len) {
            String type = super.identify(magic, len);
            if (type == null) {
                String ms = new String(magic, 0, len).trim();
                type = ms.startsWith("<") && ms.length() > 1 && Character.isLetter(ms.charAt(1)) ? "text/xml" : null;
            }
            return type;
        }
    }

    public static class XebuXmlIdentifier
    extends MagicInputStream {
        public XebuXmlIdentifier(InputStream in) throws IOException {
            super(in);
        }

        protected String identify(byte[] magic, int len) {
            String[] SUBTYPES = new String[]{"none", "item", null, "data", "elem", "elit", null, "elid"};
            String ms = new String(magic, 0, len);
            if (len == 4 && ms.toLowerCase().startsWith("<?xm")) {
                return "text/xml";
            }
            if (len < 1) {
                return null;
            }
            if ((magic[0] & 0xF) == 1) {
                int subtype = ((magic[0] & 0x20) != 0 ? 4 : 0) + ((magic[0] & 0x40) != 0 ? 2 : 0) + ((magic[0] & 0x80) != 0 ? 1 : 0);
                return SUBTYPES[subtype] == null ? null : "application/x-ebu+" + SUBTYPES[subtype];
            }
            return null;
        }
    }
}

