/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.Util;
import fc.fp.util.xas.ContentDecoder;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.XasUtil;
import fc.fp.util.xas.XmlReader;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class TypedEventStream
implements EventSequence {
    private XmlReader reader;
    private EventSequence es;
    private ContentDecoder decoder;
    private EventList el = new EventList();
    private int depth = 0;
    private boolean insideStart = false;
    private String nextNamespace = null;
    private String nextName = null;
    private EventList currentAttributes = new EventList();
    private Event cachedEvent = null;
    private Event typeAttribute = null;
    private String[] namespaceStack = new String[8];
    private int[] namespaceCounts = new int[4];

    private void dumpStack() {
        int i;
        System.out.println("Depth:  " + this.depth);
        System.out.print("Counts: [");
        for (i = 0; i < this.namespaceCounts.length; ++i) {
            if (i > 0) {
                System.out.print(", ");
            }
            System.out.print(this.namespaceCounts[i]);
        }
        System.out.println("]");
        System.out.print("Stack: [");
        for (i = 0; i < this.namespaceStack.length; ++i) {
            if (i > 0) {
                System.out.print(",");
            }
            System.out.print(this.namespaceStack[i]);
        }
        System.out.println("]");
    }

    private String getNamespace(String prefix) {
        for (int i = 2 * (this.namespaceCounts[this.depth] - 1); i >= 0; i -= 2) {
            if (!Util.equals(prefix, this.namespaceStack[i + 1])) continue;
            return this.namespaceStack[i];
        }
        return this.decoder.mapNamespace(prefix);
    }

    private void namespacePrefix(String namespace, String prefix) {
        int current = this.namespaceCounts[this.depth + 1];
        this.namespaceStack = Util.ensureCapacity(this.namespaceStack, 2 * (current + 1));
        this.namespaceStack[2 * current] = namespace;
        this.namespaceStack[2 * current + 1] = prefix;
        int n = this.depth + 1;
        this.namespaceCounts[n] = this.namespaceCounts[n] + 1;
        this.decoder.insertPrefixMapping(namespace, prefix);
    }

    private Event scrollEvent() {
        Event ev = this.reader.advance();
        if (ev != null) {
            if (ev.getType() == 2) {
                ++this.depth;
            } else if (ev.getType() == 4) {
                --this.depth;
            }
        }
        return ev;
    }

    private Event postDecodeProcess(Event ev) {
        if (!this.currentAttributes.isEmpty()) {
            this.cachedEvent = ev;
            ev = this.currentAttributes.remove(0);
        } else if (ev.getType() == 2) {
            this.insideStart = true;
            this.namespaceCounts = Util.ensureCapacity(this.namespaceCounts, this.depth + 2);
            this.namespaceCounts[this.depth + 1] = this.namespaceCounts[this.depth];
        } else {
            this.insideStart = false;
        }
        return ev;
    }

    private Event nextEvent() {
        Event ev = null;
        if (this.cachedEvent != null) {
            if (!this.currentAttributes.isEmpty()) {
                ev = this.currentAttributes.remove(0);
            } else {
                Event result = this.cachedEvent;
                this.cachedEvent = null;
                ev = this.postDecodeProcess(result);
            }
        } else {
            ev = this.scrollEvent();
            if (ev != null) {
                if (ev.getType() == 7) {
                    this.namespacePrefix(ev.getNamespace(), (String)ev.getValue());
                }
                if (ev.getType() == 3) {
                    if (Util.equals(ev.getNamespace(), "http://www.w3.org/2001/XMLSchema-instance") && Util.equals(ev.getName(), "type")) {
                        String type = (String)ev.getValue();
                        int i = type.indexOf(58);
                        String typePrefix = type.substring(0, i);
                        this.nextName = type.substring(i + 1);
                        this.nextNamespace = this.getNamespace(typePrefix);
                        this.typeAttribute = ev;
                    } else {
                        this.currentAttributes.add(ev);
                    }
                    ev = this.nextEvent();
                } else if (this.insideStart && this.nextName != null) {
                    this.reader.backup();
                    int savedDepth = this.depth;
                    Object value = null;
                    if (ev.getType() == 6) {
                        this.nextNamespace = ev.getNamespace();
                        this.nextName = ev.getName();
                        value = ev.getValue();
                        this.reader.advance();
                    } else {
                        value = this.decoder.decode(this.nextNamespace, this.nextName, this.reader, this.currentAttributes);
                    }
                    if (value != null) {
                        this.typeAttribute = null;
                        Event tmp = Event.createTypedContent(this.nextNamespace, this.nextName, value);
                        if (this.currentAttributes.isEmpty()) {
                            ev = tmp;
                        } else {
                            this.cachedEvent = tmp;
                            ev = this.currentAttributes.remove(0);
                        }
                    } else {
                        this.currentAttributes.add(this.typeAttribute);
                        ev = this.postDecodeProcess(ev);
                        this.reader.advance();
                    }
                    this.nextNamespace = null;
                    this.nextName = null;
                    this.insideStart = false;
                } else if (ev.getType() != 7) {
                    ev = this.postDecodeProcess(ev);
                }
            }
        }
        return ev;
    }

    private boolean fillUntil(int index) {
        Event ev;
        boolean read = false;
        while ((index < 0 || this.el.getLargestActiveIndex() < index) && (ev = this.nextEvent()) != null) {
            read = true;
            this.el.add(ev);
        }
        if (read) {
            while (this.reader.getCurrentPosition() <= this.es.getLargestActiveIndex() && (ev = this.nextEvent()) != null) {
                this.el.add(ev);
            }
            if (this.reader.getCurrentPosition() > this.es.getLargestActiveIndex()) {
                this.es.forget();
            }
        }
        return this.el.getLargestActiveIndex() >= index;
    }

    public TypedEventStream(EventSequence es, ContentDecoder decoder) {
        this.es = es;
        this.reader = new XmlReader(es);
        this.decoder = decoder;
    }

    public void reset(EventSequence es, ContentDecoder decoder) {
        this.es = es;
        this.reader.reset(es);
        this.decoder = decoder;
        this.el.reset();
        this.currentAttributes.clear();
    }

    public Event get(int index) {
        this.fillUntil(index);
        return this.el.get(index);
    }

    public EventSequence subSequence(int from, int to) {
        this.fillUntil(to - 1);
        return this.el.subSequence(from, to);
    }

    public Enumeration events() {
        return new EventEnumerator();
    }

    public void forgetUntil(int index) {
        this.el.forgetUntil(index);
    }

    public void forget() {
        this.el.forget();
    }

    public int getSmallestActiveIndex() {
        return this.el.getSmallestActiveIndex();
    }

    public int getLargestActiveIndex() {
        return this.el.getLargestActiveIndex();
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof EventSequence) {
            result = XasUtil.sequenceEquals(this, (EventSequence)o);
        }
        return result;
    }

    public int hashCode() {
        return XasUtil.sequenceHashCode(this);
    }

    public String toString() {
        this.fillUntil(-1);
        return this.el.toString();
    }

    private class EventEnumerator
    implements Enumeration {
        private int index = 0;

        private EventEnumerator() {
        }

        public boolean hasMoreElements() {
            return TypedEventStream.this.el.getLargestActiveIndex() >= this.index || TypedEventStream.this.fillUntil(this.index);
        }

        public Object nextElement() {
            if (TypedEventStream.this.fillUntil(this.index)) {
                return TypedEventStream.this.el.get(this.index++);
            }
            throw new NoSuchElementException("EventStream exhausted");
        }
    }
}

