/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.XasUtil;
import fc.fp.util.xas.XmlReader;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class TransformedEventStream
implements EventSequence {
    private XmlReader xr;
    private EventSequence es;
    private EventList el = new EventList();
    protected boolean inProgress = true;

    private boolean fillUntil(int index) {
        Event ev;
        boolean read = false;
        while (this.inProgress && (index < 0 || this.el.getLargestActiveIndex() < index) && (ev = this.xr.advance()) != null) {
            read = true;
            this.transform(ev, this.el, this.xr);
        }
        if (read) {
            while (this.xr.getCurrentPosition() <= this.es.getLargestActiveIndex() && (ev = this.xr.advance()) != null) {
                this.transform(ev, this.el, this.xr);
            }
            if (this.xr.getCurrentPosition() > this.es.getLargestActiveIndex()) {
                this.es.forget();
            }
        }
        return this.el.getLargestActiveIndex() >= index;
    }

    protected void transform(Event ev, EventList el, XmlReader xr) {
        el.add(ev);
    }

    public TransformedEventStream(EventSequence es) {
        this.es = es;
        this.xr = new XmlReader(es);
    }

    public void reset(EventSequence es) {
        this.es = es;
        this.xr.reset(es);
        this.el.reset();
    }

    public Event get(int index) {
        this.fillUntil(index);
        return this.el.get(index);
    }

    public EventSequence subSequence(int from, int to) {
        this.fillUntil(to - 1);
        return this.el.subSequence(from, to);
    }

    public Enumeration events() {
        return new EventEnumerator();
    }

    public void forgetUntil(int index) {
        this.el.forgetUntil(index);
    }

    public void forget() {
        this.el.forget();
    }

    public int getSmallestActiveIndex() {
        return this.el.getSmallestActiveIndex();
    }

    public int getLargestActiveIndex() {
        return this.el.getLargestActiveIndex();
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof EventSequence) {
            result = XasUtil.sequenceEquals(this, (EventSequence)o);
        }
        return result;
    }

    public int hashCode() {
        return XasUtil.sequenceHashCode(this);
    }

    public String toString() {
        this.fillUntil(-1);
        return this.el.toString();
    }

    private class EventEnumerator
    implements Enumeration {
        private int index = 0;

        private EventEnumerator() {
        }

        public boolean hasMoreElements() {
            return TransformedEventStream.this.el.getLargestActiveIndex() >= this.index || TransformedEventStream.this.fillUntil(this.index);
        }

        public Object nextElement() {
            if (TransformedEventStream.this.fillUntil(this.index)) {
                return TransformedEventStream.this.el.get(this.index++);
            }
            throw new NoSuchElementException("EventStream exhausted");
        }
    }
}

