/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.xas.Qname;
import fc.fp.util.xas.TypedXmlSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class SaxWriter
implements ContentHandler,
DTDHandler,
LexicalHandler,
DeclHandler {
    protected TypedXmlSerializer target;
    private Map<String, String> prefixes = new HashMap<String, String>();

    public SaxWriter(TypedXmlSerializer target) {
        this(target, null);
    }

    public SaxWriter(TypedXmlSerializer target, OutputStream os) {
        this.target = target;
        if (os != null) {
            try {
                target.setOutput(os, "ISO-8859-1");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        if (this.target != null) {
            try {
                this.target.startDocument("ISO-8859-1", null);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }

    public void endDocument() throws SAXException {
        if (this.target != null) {
            try {
                this.target.endDocument();
                this.target.flush();
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix == null) {
            prefix = "";
        }
        this.prefixes.put(prefix, uri);
        if (this.target != null) {
            try {
                this.target.setPrefix(prefix, uri);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.prefixes.remove(prefix);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.target != null) {
            try {
                if (localName == null || localName.equals("")) {
                    String uri;
                    namespaceURI = "";
                    int index = qName.indexOf(58);
                    if (index >= 0) {
                        uri = this.prefixes.get(qName.substring(0, index));
                        if (uri != null) {
                            namespaceURI = uri;
                        }
                        localName = qName.substring(index + 1);
                    } else {
                        uri = this.prefixes.get("");
                        if (uri != null) {
                            namespaceURI = uri;
                        }
                        localName = qName;
                    }
                }
                this.target.startTag(namespaceURI, localName);
                if (attributes != null) {
                    int length = attributes.getLength();
                    for (int i = 0; i < length; ++i) {
                        String localAttName = attributes.getLocalName(i);
                        String attUri = attributes.getURI(i);
                        String attQName = attributes.getQName(i);
                        if (localAttName == null || localAttName.length() == 0) {
                            attUri = "";
                            int index = attQName.indexOf(58);
                            if (index >= 0) {
                                String uri = this.prefixes.get(attQName.substring(0, index));
                                if (uri != null) {
                                    attUri = uri;
                                }
                                localAttName = attQName.substring(index + 1);
                            } else {
                                localAttName = attQName;
                            }
                        }
                        if (attUri.equals("http://www.w3.org/2001/XMLSchema-instance") && localAttName.equals("type")) {
                            String namespace;
                            String value = attributes.getValue(i).trim();
                            String prefix = "";
                            int index = value.indexOf(58);
                            if (index > 0) {
                                prefix = value.substring(0, index);
                                value = value.substring(index + 1);
                            }
                            if ((namespace = this.prefixes.get(prefix)) == null) {
                                namespace = "";
                            }
                            this.target.typedAttribute(attUri, localAttName, new Qname(namespace, value));
                            continue;
                        }
                        this.target.attribute(attUri, localAttName, attributes.getValue(i));
                    }
                }
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.target != null) {
            try {
                if (localName == null || localName.equals("")) {
                    namespaceURI = "";
                    int index = qName.indexOf(58);
                    if (index >= 0) {
                        String uri = this.prefixes.get(qName.substring(0, index));
                        if (uri != null) {
                            namespaceURI = uri;
                        }
                        localName = qName.substring(index + 1);
                    } else {
                        String uri = this.prefixes.get("");
                        if (uri != null) {
                            namespaceURI = uri;
                        }
                        localName = qName;
                    }
                }
                this.target.endTag(namespaceURI, localName);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.target != null) {
            try {
                this.target.text(ch, start, length);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.target != null) {
            try {
                this.target.text(ch, start, length);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.target != null) {
            try {
                this.target.processingInstruction(target + " " + data);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.target != null) {
            try {
                this.target.entityRef(name);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.target != null) {
            try {
                this.target.comment(new String(ch, start, length));
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.target != null) {
            try {
                StringBuilder s = new StringBuilder(" ");
                s.append(name);
                if (publicId != null) {
                    s.append(" PUBLIC ");
                    s.append(publicId);
                    s.append(" ");
                    s.append(systemId);
                } else if (systemId != null) {
                    s.append(" SYSTEM ");
                    s.append(systemId);
                }
                this.target.docdecl(s.toString());
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }

    public void startEntity(String name) throws SAXException {
    }

    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
    }

    public void elementDecl(String name, String model) throws SAXException {
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
    }
}

