/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SaxReader
implements XMLReader {
    private static Log log = LogFactory.getLog((String)SaxReader.class.getName());
    private static final String NS_URI = "http://xml.org/sax/features/namespaces";
    private static final String NSPRE_URI = "http://xml.org/sax/features/namespace-prefixes";
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private XmlPullParser parser;
    private Map prefixMapping = new HashMap();

    public SaxReader(XmlPullParser parser) {
        this.parser = parser;
        try {
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        }
        catch (XmlPullParserException ex) {
            ex.printStackTrace();
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.contentHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.dtdHandler = handler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException();
        }
        this.entityResolver = resolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.errorHandler = handler;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException {
        if (NS_URI.equals(name)) {
            return true;
        }
        if (NSPRE_URI.equals(name)) {
            return false;
        }
        throw new SAXNotRecognizedException("Feature " + name + " not recognized");
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NS_URI.equals(name)) {
            if (!value) {
                throw new SAXNotSupportedException("Feature " + name + " may not be set to false");
            }
        } else if (NSPRE_URI.equals(name)) {
            if (value) {
                throw new SAXNotSupportedException("Feature " + name + " may not be set to true");
            }
        } else {
            throw new SAXNotRecognizedException("Feature " + name + " not recognized");
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException {
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    public void parse(InputSource input) throws IOException, SAXException {
        InputStream stream = input.getByteStream();
        if (stream == null) {
            throw new SAXException("Must have an InputStream to parse");
        }
        try {
            Stack nsStack = new Stack();
            ArrayList<String> nsCurrent = new ArrayList<String>();
            this.parser.setInput(stream, "ISO-8859-1");
            int[] textParams = new int[2];
            int eventType = this.parser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 0: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"START_DOCUMENT");
                        }
                        if (this.contentHandler == null) break;
                        this.contentHandler.startDocument();
                        break;
                    }
                    case 2: {
                        String prefix;
                        int nsStart = this.parser.getNamespaceCount(this.parser.getDepth() - 1);
                        int nsEnd = this.parser.getNamespaceCount(this.parser.getDepth());
                        for (int i = nsStart; i < nsEnd; ++i) {
                            prefix = this.parser.getNamespacePrefix(i);
                            String uri = this.parser.getNamespaceUri(i);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("PM(" + prefix + ", " + uri + ")"));
                            }
                            if (this.contentHandler != null) {
                                this.contentHandler.startPrefixMapping(prefix, uri);
                            }
                            this.prefixMapping.put(uri, prefix);
                            nsCurrent.add(uri);
                        }
                        String namespace = this.parser.getNamespace();
                        String localName = this.parser.getName();
                        AttributesImpl atts = new AttributesImpl();
                        int attLen = this.parser.getAttributeCount();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("START_TAG(" + namespace + ", " + localName + ", " + attLen + ")"));
                        }
                        for (int i = 0; i < attLen; ++i) {
                            String aNamespace = this.parser.getAttributeNamespace(i);
                            String aName = this.parser.getAttributeName(i);
                            String aValue = this.parser.getAttributeValue(i);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("A(" + aNamespace + ", " + aName + ", " + aValue + ")"));
                            }
                            String aqName = aName;
                            String aPrefix = (String)this.prefixMapping.get(aNamespace);
                            if (aPrefix != null && aPrefix.length() > 0) {
                                aqName = aPrefix + ":" + aName;
                            }
                            atts.addAttribute(aNamespace, aName, aqName, this.parser.getAttributeType(i), aValue);
                        }
                        String qName = localName;
                        String prefix2 = (String)this.prefixMapping.get(namespace);
                        if (prefix2 != null && prefix2.length() > 0) {
                            qName = prefix2 + ":" + localName;
                        }
                        if (this.contentHandler != null) {
                            this.contentHandler.startElement(namespace, localName, qName, atts);
                        }
                        nsStack.push(nsCurrent);
                        nsCurrent = new ArrayList();
                        break;
                    }
                    case 3: {
                        String namespace = this.parser.getNamespace();
                        String localName = this.parser.getName();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("END_TAG(" + namespace + ", " + localName + ")"));
                        }
                        String qName = localName;
                        String prefix = (String)this.prefixMapping.get(namespace);
                        if (prefix != null && prefix.length() > 0) {
                            qName = prefix + ":" + localName;
                        }
                        if (this.contentHandler != null) {
                            this.contentHandler.endElement(namespace, localName, qName);
                        }
                        List current = (List)nsStack.pop();
                        for (String uri : current) {
                            prefix = (String)this.prefixMapping.remove(uri);
                            if (this.contentHandler == null) continue;
                            this.contentHandler.endPrefixMapping(prefix);
                        }
                        break;
                    }
                    case 4: {
                        char[] ch = this.parser.getTextCharacters(textParams);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("TEXT(" + new String(ch, textParams[0], textParams[1]) + ")"));
                        }
                        if (this.contentHandler == null) break;
                        this.contentHandler.characters(ch, textParams[0], textParams[1]);
                        break;
                    }
                    case 8: {
                        String target = this.parser.getText();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("PI(" + target + ")"));
                        }
                        if (this.contentHandler == null) break;
                        String data = null;
                        int i = target.indexOf(32);
                        if (i >= 0) {
                            data = target.substring(i + 1);
                            target = target.substring(0, i);
                        }
                        this.contentHandler.processingInstruction(target, data);
                        break;
                    }
                    case 6: {
                        String name = this.parser.getName();
                        if (this.contentHandler == null) break;
                        if (name.charAt(0) == '#') {
                            char[] ch = this.parser.getTextCharacters(textParams);
                            this.contentHandler.characters(ch, textParams[0], textParams[1]);
                            break;
                        }
                        this.contentHandler.skippedEntity(name);
                        break;
                    }
                }
                eventType = this.parser.nextToken();
            }
        }
        catch (XmlPullParserException ex) {
            throw new SAXException((Exception)((Object)ex));
        }
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }
}

