/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.SaxReader;
import fc.fp.util.xas.XmlReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SaxBridge {
    private static Log log = LogFactory.getLog((String)SaxReader.class.getName());
    protected EventSequence es;

    public SaxBridge(EventSequence source) {
        this.es = source;
    }

    public static void output(EventSequence es, ContentHandler contentHandler) throws SAXException, IOException {
        new SaxBridge(es).output(contentHandler);
    }

    public void output(ContentHandler contentHandler) throws SAXException, IOException {
        if (this.es == null) {
            throw new SAXException("Must have an EventSequence to output");
        }
        HashMap<String, String> prefixMapping = new HashMap<String, String>();
        XmlReader r = new XmlReader(this.es);
        int[] textParams = new int[2];
        Event e = r.advance();
        while (e != null && e.getType() != 1) {
            int eventType = e.getType();
            switch (eventType) {
                case 0: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"START_DOCUMENT");
                    }
                    if (contentHandler == null) break;
                    contentHandler.startDocument();
                    break;
                }
                case 7: {
                    String prefix = e.getValue().toString();
                    String uri = e.getNamespace();
                    contentHandler.startPrefixMapping(prefix, uri);
                    prefixMapping.put(uri, prefix);
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("PM(" + e.getNamespace() + ", " + e.getValue() + ")"));
                    break;
                }
                case 2: {
                    String namespace = e.getNamespace();
                    String localName = e.getName();
                    String prefix = (String)prefixMapping.get(namespace);
                    AttributesImpl atts = new AttributesImpl();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("START_TAG(" + namespace + ", " + localName + ")"));
                    }
                    Event e2 = null;
                    while ((e2 = r.advance()) != null) {
                        if (e2.getType() == 3) {
                            atts.addAttribute(this.makeNameSpace(prefixMapping, e2.getNamespace(), e2.getName()), this.makeName(prefixMapping, e2.getNamespace(), e2.getName()), this.makeQName(prefixMapping, e2.getNamespace(), e2.getName()), "CDATA", e2.getValue().toString());
                            continue;
                        }
                        if (e2.getType() == 8) continue;
                    }
                    r.backup();
                    if (contentHandler == null) break;
                    contentHandler.startElement(this.makeNameSpace(prefixMapping, namespace, localName), this.makeName(prefixMapping, namespace, localName), this.makeQName(prefixMapping, namespace, localName), atts);
                    break;
                }
                case 4: {
                    String namespace = e.getNamespace();
                    String localName = e.getName();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("END_TAG(" + namespace + ", " + localName + ")"));
                    }
                    if (contentHandler == null) break;
                    contentHandler.endElement(this.makeNameSpace(prefixMapping, namespace, localName), this.makeName(prefixMapping, namespace, localName), this.makeQName(prefixMapping, namespace, localName));
                    break;
                }
                case 5: {
                    char[] ch = e.getValue().toString().toCharArray();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("TEXT(" + new String(ch, textParams[0], textParams[1]) + ")"));
                    }
                    if (contentHandler == null) break;
                    contentHandler.characters(ch, 0, ch.length);
                    break;
                }
            }
            e = r.advance();
        }
        if (contentHandler != null) {
            contentHandler.endDocument();
        }
    }

    protected String makeNameSpace(Map prefixes, String nameSpace, String localName) {
        return nameSpace;
    }

    protected String makeName(Map prefixes, String nameSpace, String localName) {
        return localName;
    }

    protected String makeQName(Map prefixes, String nameSpace, String localName) {
        String prefix = (String)prefixes.get(nameSpace);
        if (prefix != null && prefix.length() > 0) {
            return prefix + ":" + localName;
        }
        return localName;
    }
}

