/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventSequence;
import java.util.Enumeration;

public class ForgetfulEventStream
implements EventSequence {
    private EventSequence es;
    private int low;
    private int high;
    public static final int DEFAULT_LOW = 16;
    public static final int DEFAULT_HIGH = 64;

    private void checkForForget() {
        if (this.es.getLargestActiveIndex() - this.es.getSmallestActiveIndex() >= this.high) {
            this.es.forgetUntil(this.es.getLargestActiveIndex() - this.low + 1);
        }
    }

    public ForgetfulEventStream(EventSequence es) {
        this(es, 16, 64);
    }

    public ForgetfulEventStream(EventSequence es, int low, int high) {
        if (low > high) {
            throw new IllegalArgumentException("Must have low <= high, got low=" + low + ",high=" + high);
        }
        this.es = es;
        this.low = low;
        this.high = high;
    }

    public Event get(int index) {
        Event result = this.es.get(index);
        this.checkForForget();
        return result;
    }

    public EventSequence subSequence(int from, int to) {
        EventSequence result = this.es.subSequence(from, to);
        this.checkForForget();
        return result;
    }

    public Enumeration events() {
        return this.es.events();
    }

    public void forgetUntil(int index) {
        this.es.forgetUntil(index);
    }

    public void forget() {
        this.es.forget();
    }

    public int getSmallestActiveIndex() {
        return this.es.getSmallestActiveIndex();
    }

    public int getLargestActiveIndex() {
        return this.es.getLargestActiveIndex();
    }
}

