/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.Util;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.TypedXmlParser;
import fc.fp.util.xas.XasUtil;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParserException;

public class EventStream
implements EventSequence {
    private Vector current;
    private TypedXmlParser source;
    private boolean inProgress = true;
    private int smallestIndex = 0;

    private void dumpState() {
        System.out.println("First index: " + this.smallestIndex);
        System.out.println("Event list: " + this.current);
    }

    private int toPrivate(int index) {
        return index - this.smallestIndex;
    }

    private int fromPrivate(int index) {
        return index + this.smallestIndex;
    }

    private Event entityToEvent(String name) {
        String text = null;
        if (name.charAt(0) == '#') {
            text = this.source.getText();
        } else if (Util.equals(name, "lt")) {
            text = "<";
        } else if (Util.equals(name, "gt")) {
            text = ">";
        } else if (Util.equals(name, "amp")) {
            text = "&";
        } else if (Util.equals(name, "apos")) {
            text = "'";
        } else if (Util.equals(name, "quot")) {
            text = "\"";
        }
        if (text != null) {
            return Event.createContent(text);
        }
        return Event.createEntityReference(name);
    }

    private boolean getNextEvent() {
        boolean result = false;
        if (this.inProgress) {
            try {
                int eventType = this.source.getEventType();
                switch (eventType) {
                    case 0: {
                        this.current.addElement(Event.createStartDocument());
                        break;
                    }
                    case 1: {
                        this.current.addElement(Event.createEndDocument());
                        this.inProgress = false;
                        break;
                    }
                    case 2: {
                        int nsStart = this.source.getNamespaceCount(this.source.getDepth() - 1);
                        int nsEnd = this.source.getNamespaceCount(this.source.getDepth());
                        for (int i = nsStart; i < nsEnd; ++i) {
                            String prefix = this.source.getNamespacePrefix(i);
                            String uri = this.source.getNamespaceUri(i);
                            this.current.addElement(Event.createNamespacePrefix(uri, prefix));
                        }
                        this.current.addElement(Event.createStartElement(this.source.getNamespace(), this.source.getName()));
                        int atts = this.source.getAttributeCount();
                        for (int i = 0; i < atts; ++i) {
                            this.current.addElement(Event.createAttribute(this.source.getAttributeNamespace(i), this.source.getAttributeName(i), this.source.getAttributeValue(i)));
                        }
                        break;
                    }
                    case 3: {
                        this.current.addElement(Event.createEndElement(this.source.getNamespace(), this.source.getName()));
                        break;
                    }
                    case 4: {
                        this.current.addElement(Event.createContent(this.source.getText()));
                        break;
                    }
                    case 15: {
                        this.current.addElement(Event.createTypedContent(this.source.getNamespace(), this.source.getName(), this.source.getObject()));
                        break;
                    }
                    case 9: {
                        this.current.addElement(Event.createComment(this.source.getText()));
                        break;
                    }
                    case 8: {
                        this.current.addElement(Event.createProcessingInstruction(this.source.getText()));
                        break;
                    }
                    case 6: {
                        String name = this.source.getName();
                        this.current.addElement(this.entityToEvent(name));
                    }
                }
                this.source.nextToken();
                result = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.inProgress = false;
            }
        }
        return result;
    }

    private boolean fillUntil(int index) {
        while (this.inProgress && (index < 0 || this.current.size() <= this.toPrivate(index))) {
            this.getNextEvent();
        }
        return this.current.size() > this.toPrivate(index);
    }

    public EventStream(TypedXmlParser source) {
        this.source = source;
        try {
            source.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        }
        catch (XmlPullParserException ex) {
            ex.printStackTrace();
        }
        this.current = new Vector();
    }

    public void reset(TypedXmlParser source) {
        this.source = source;
        try {
            source.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        }
        catch (XmlPullParserException ex) {
            ex.printStackTrace();
        }
        this.current.removeAllElements();
        this.inProgress = true;
        this.smallestIndex = 0;
    }

    public Event get(int index) {
        if (this.fillUntil(index)) {
            return (Event)this.current.elementAt(this.toPrivate(index));
        }
        return null;
    }

    public EventSequence subSequence(int from, int to) {
        this.fillUntil(to - 1);
        EventList result = new EventList();
        for (int i = from; i < to; ++i) {
            result.add((Event)this.current.elementAt(this.toPrivate(i)));
        }
        return result;
    }

    public Enumeration events() {
        return new EventEnumerator();
    }

    public void forgetUntil(int index) {
        int large = this.toPrivate(index);
        if (large == this.current.size()) {
            this.forget();
        } else if (index >= this.smallestIndex && large < this.current.size()) {
            int size = this.current.size() - large;
            Vector result = new Vector(size);
            for (int i = 0; i < size; ++i) {
                result.addElement(this.current.elementAt(i + index));
            }
            this.current = result;
            this.smallestIndex = index;
        } else {
            throw new IllegalArgumentException("Index " + index + " out of range");
        }
    }

    public void forget() {
        this.smallestIndex += this.current.size();
        this.current.removeAllElements();
    }

    public int getSmallestActiveIndex() {
        return this.fromPrivate(0);
    }

    public int getLargestActiveIndex() {
        return this.fromPrivate(this.current.size() - 1);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof EventSequence) {
            result = XasUtil.sequenceEquals(this, (EventSequence)o);
        }
        return result;
    }

    public int hashCode() {
        return XasUtil.sequenceHashCode(this);
    }

    public String toString() {
        this.fillUntil(-1);
        return this.current.toString();
    }

    private class EventEnumerator
    implements Enumeration {
        private int index = 0;

        private EventEnumerator() {
        }

        public boolean hasMoreElements() {
            return EventStream.this.current.size() > EventStream.this.toPrivate(this.index) || EventStream.this.fillUntil(this.index);
        }

        public Object nextElement() {
            if (EventStream.this.fillUntil(this.index)) {
                return EventStream.this.current.elementAt(EventStream.this.toPrivate(this.index++));
            }
            throw new NoSuchElementException("EventStream exhausted");
        }
    }
}

