/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.Util;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.TypedXmlSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.xmlpull.v1.XmlSerializer;

public class EventSerializer
implements TypedXmlSerializer {
    private EventList current = new EventList();
    private int depth = 0;
    private String[] elementStack = new String[12];

    public EventSequence getCurrentSequence() {
        return this.current;
    }

    public void setFeature(String name, boolean state) {
        throw new IllegalStateException("Feature " + name + " not supported");
    }

    public boolean getFeature(String name) {
        return false;
    }

    public void setProperty(String name, Object value) {
        throw new IllegalStateException("Property " + name + " not supported");
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setOutput(OutputStream os, String encoding) {
    }

    public void setOutput(Writer writer) {
    }

    public void startDocument(String encoding, Boolean standalone) {
        this.current.add(Event.createStartDocument());
    }

    public void endDocument() {
        this.current.add(Event.createEndDocument());
    }

    public void setPrefix(String prefix, String namespace) {
        this.current.add(Event.createNamespacePrefix(namespace, prefix));
    }

    public String getPrefix(String namespace, boolean generatePrefix) {
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getNamespace() {
        if (this.depth == 0) {
            return null;
        }
        return this.elementStack[2 * (this.depth - 1)];
    }

    public String getName() {
        if (this.depth == 0) {
            return null;
        }
        return this.elementStack[2 * this.depth - 1];
    }

    public XmlSerializer startTag(String namespace, String name) {
        this.elementStack = Util.ensureCapacity(this.elementStack, 2 * (this.depth + 1));
        this.elementStack[2 * this.depth] = namespace;
        this.elementStack[2 * this.depth + 1] = name;
        ++this.depth;
        this.current.add(Event.createStartElement(namespace, name));
        return this;
    }

    public XmlSerializer attribute(String namespace, String name, String value) {
        this.current.add(Event.createAttribute(namespace, name, value));
        return this;
    }

    public XmlSerializer endTag(String namespace, String name) {
        if (this.depth <= 0) {
            throw new IllegalStateException("End tag {" + namespace + "}" + name + " without start tag");
        }
        --this.depth;
        this.current.add(Event.createEndElement(namespace, name));
        return this;
    }

    public XmlSerializer text(String text) {
        this.current.add(Event.createContent(text));
        return this;
    }

    public XmlSerializer text(char[] ch, int start, int length) {
        return this.text(new String(ch, start, length));
    }

    public TypedXmlSerializer typedContent(Object content, String namespace, String name) {
        this.current.add(Event.createTypedContent(namespace, name, content));
        return this;
    }

    public void cdsect(String data) {
        this.text(data);
    }

    public void entityRef(String text) {
        this.current.add(Event.createEntityReference(text));
    }

    public void processingInstruction(String text) {
        this.current.add(Event.createProcessingInstruction(text));
    }

    public void comment(String text) {
        this.current.add(Event.createComment(text));
    }

    public void docdecl(String text) {
        this.current.add(Event.createDoctypeDeclaration(text));
    }

    public void ignorableWhitespace(String text) {
        this.text(text);
    }

    public void flush() {
    }

    public String toString() {
        return this.current.toString();
    }

    public TypedXmlSerializer typedAttribute(String namespace, String name, Object value) throws IOException {
        this.current.add(Event.createTypedAttribute(namespace, name, value));
        return this;
    }
}

