/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.XasUtil;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class EventList
implements EventSequence {
    private Vector current = new Vector();
    private int smallestIndex = 0;

    private int toPrivate(int index) {
        return index - this.smallestIndex;
    }

    private int fromPrivate(int index) {
        return index + this.smallestIndex;
    }

    private boolean coalesceNext(int index) {
        boolean result = false;
        if (index < this.current.size() - 1) {
            Event curr = (Event)this.current.elementAt(index);
            Event next = (Event)this.current.elementAt(index + 1);
            if (curr.getType() == 5 && next.getType() == 5) {
                Event ev = Event.createContent((String)curr.getValue() + (String)next.getValue());
                this.current.removeElementAt(index + 1);
                this.current.setElementAt(ev, index);
                result = true;
            }
        }
        return result;
    }

    public int size() {
        return this.current.size();
    }

    public boolean isEmpty() {
        return this.current.isEmpty();
    }

    public void clear() {
        this.current.removeAllElements();
    }

    public void reset() {
        this.current.removeAllElements();
        this.smallestIndex = 0;
    }

    public void add(Event ev) {
        this.add(this.fromPrivate(this.current.size()), ev);
    }

    public void add(int index, Event ev) {
        Event prev;
        int prevType;
        int i = this.toPrivate(index);
        if (i < 0 || i > this.current.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range");
        }
        if (ev.getType() == 3 && i > 0 && (prevType = (prev = (Event)this.current.elementAt(i - 1)).getType()) != 2 && prevType != 3 && prevType != 12) {
            throw new IllegalArgumentException("ATTR not allowed after type " + prevType);
        }
        this.current.insertElementAt(ev, i);
    }

    public void addAll(EventSequence es) {
        Enumeration e = es.events();
        while (e.hasMoreElements()) {
            Event ev = (Event)e.nextElement();
            this.add(ev);
        }
    }

    public Event remove(int index) {
        index = this.toPrivate(index);
        Event result = (Event)this.current.elementAt(index);
        this.current.removeElementAt(index);
        return result;
    }

    public Event get(int index) {
        if ((index = this.toPrivate(index)) >= 0 && index < this.current.size()) {
            return (Event)this.current.elementAt(index);
        }
        return null;
    }

    public EventSequence subSequence(int from) {
        return this.subSequence(from, this.current.size());
    }

    public EventSequence subSequence(int from, int to) {
        int f = this.toPrivate(from);
        int t = this.toPrivate(to);
        if (f < 0 || t > this.current.size()) {
            throw new IllegalArgumentException("Out of range: from=" + from + ", to=" + to);
        }
        return new SubSequence(from, to);
    }

    public Enumeration events() {
        return new ListEnumerator(this, this.getSmallestActiveIndex(), this.getLargestActiveIndex() + 1);
    }

    public void forgetUntil(int index) {
        int large = this.toPrivate(index);
        if (index == this.smallestIndex) {
            return;
        }
        if (large == this.current.size()) {
            this.forget();
        } else if (index > this.smallestIndex && large < this.current.size()) {
            int size = this.current.size() - large;
            Vector result = new Vector(size);
            for (int i = 0; i < size; ++i) {
                result.addElement(this.current.elementAt(i + index));
            }
            this.current = result;
            this.smallestIndex = index;
        } else {
            throw new IllegalArgumentException("Index " + index + " out of range");
        }
    }

    public void forget() {
        this.smallestIndex += this.current.size();
        this.current.removeAllElements();
    }

    public int getSmallestActiveIndex() {
        return this.fromPrivate(0);
    }

    public int getLargestActiveIndex() {
        return this.fromPrivate(this.current.size() - 1);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof EventSequence) {
            result = XasUtil.sequenceEquals(this, (EventSequence)o);
        }
        return result;
    }

    public int hashCode() {
        return XasUtil.sequenceHashCode(this);
    }

    public String toString() {
        return this.current.toString();
    }

    private static class ListEnumerator
    implements Enumeration {
        private EventSequence seq;
        private int index;
        private int high;

        public ListEnumerator(EventSequence seq, int low, int high) {
            this.seq = seq;
            this.index = low;
            this.high = high;
        }

        public boolean hasMoreElements() {
            return this.index < this.high;
        }

        public Object nextElement() {
            if (this.index < this.high) {
                return this.seq.get(this.index++);
            }
            throw new NoSuchElementException("List exhausted");
        }
    }

    private class SubSequence
    implements EventSequence {
        private EventList parent;
        private int originalLow;
        private int high;
        private int low;

        private boolean check(int index) {
            int value = this.translate(index);
            return value >= this.low && value < this.high;
        }

        private int translate(int index) {
            return index + this.originalLow;
        }

        public SubSequence(int low, int high) {
            this.parent = EventList.this;
            this.originalLow = this.low = low;
            this.high = high;
        }

        public Event get(int index) {
            if (!this.check(index)) {
                return null;
            }
            return this.parent.get(this.translate(index));
        }

        public EventSequence subSequence(int from, int to) {
            if (!this.check(from) || !this.check(to - 1)) {
                throw new IllegalArgumentException("Out of range: from=" + from + ",to=" + to);
            }
            return this.parent.subSequence(this.translate(from), this.translate(to));
        }

        public Enumeration events() {
            return new ListEnumerator(this.parent, this.low, this.high);
        }

        public void forgetUntil(int index) {
            this.low = index;
        }

        public void forget() {
            this.low = this.high;
        }

        public int getSmallestActiveIndex() {
            return this.low;
        }

        public int getLargestActiveIndex() {
            return this.high - 1;
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o instanceof EventSequence) {
                result = XasUtil.sequenceEquals(this, (EventSequence)o);
            }
            return result;
        }

        public int hashCode() {
            return XasUtil.sequenceHashCode(this);
        }

        public String toString() {
            Vector<Event> result = new Vector<Event>(this.high - this.low);
            for (int i = 0; i < this.high - this.low; ++i) {
                result.addElement(this.get(i));
            }
            return result.toString();
        }
    }
}

