/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.Util;
import java.util.Arrays;

public class Event {
    int hashCode = 0;
    private int type;
    private String namespace;
    private String name;
    private Object value;
    public static final int START_DOCUMENT = 0;
    public static final int END_DOCUMENT = 1;
    public static final int START_ELEMENT = 2;
    public static final int ATTRIBUTE = 3;
    public static final int END_ELEMENT = 4;
    public static final int CONTENT = 5;
    public static final int TYPED_CONTENT = 6;
    public static final int NAMESPACE_PREFIX = 7;
    public static final int COMMENT = 8;
    public static final int PROCESSING_INSTRUCTION = 9;
    public static final int ENTITY_REFERENCE = 10;
    public static final int DOCTYPE_DECL = 11;
    public static final int TYPED_ATTRIBUTE = 12;
    public static final int FLAG_BITMASK = -16777216;
    public static final int TYPE_EXTENSION_FLAG = 0x43000000;

    protected Event(int type, String namespace, String name, Object value) {
        this.type = type;
        this.namespace = namespace;
        this.name = name;
        this.value = value;
    }

    public static Event createStartDocument() {
        return new Event(0, null, null, null);
    }

    public static Event createEndDocument() {
        return new Event(1, null, null, null);
    }

    public static Event createStartElement(String namespace, String name) {
        return new Event(2, namespace, name, null);
    }

    public static Event createAttribute(String namespace, String name, String value) {
        return new Event(3, namespace, name, value);
    }

    public static Event createTypedAttribute(String namespace, String name, Object value) {
        return new Event(12, namespace, name, value);
    }

    public static Event createEndElement(String namespace, String name) {
        return new Event(4, namespace, name, null);
    }

    public static Event createContent(String text) {
        return new Event(5, null, null, text);
    }

    public static Event createTypedContent(String namespace, String name, Object value) {
        return new Event(6, namespace, name, value);
    }

    public static Event createNamespacePrefix(String namespace, String value) {
        if (value == null) {
            value = "";
        }
        return new Event(7, namespace, null, value);
    }

    public static Event createComment(String text) {
        return new Event(8, null, null, text);
    }

    public static Event createProcessingInstruction(String text) {
        return new Event(9, null, null, text);
    }

    public static Event createEntityReference(String name) {
        return new Event(10, null, name, null);
    }

    public static Event createDoctypeDeclaration(String content) {
        return new Event(11, null, null, content);
    }

    public final int getType() {
        return this.type;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final String getName() {
        return this.name;
    }

    public final Object getValue() {
        return this.value;
    }

    private static boolean equalsValue(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        if (v1 instanceof byte[] && v2 instanceof byte[]) {
            return Arrays.equals((byte[])v1, (byte[])v2);
        }
        return v1.equals(v2);
    }

    private boolean componentEquals(Event e) {
        return Util.equals(this.namespace, e.namespace) && Util.equals(this.name, e.name) && Event.equalsValue(this.value, e.value);
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof Event) {
            Event e = (Event)o;
            if (this.type == e.type) {
                equal = this.componentEquals(e);
            } else if (this.type == 3 && e.type == 12 || this.type == 12 && e.type == 3) {
                equal = this.componentEquals(e);
            }
        }
        return equal;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            int realType = this.type == 12 ? 3 : this.type;
            this.hashCode = realType ^ (this.namespace == null ? 0 : this.namespace.hashCode()) ^ (this.name == null ? 0 : this.name.hashCode());
            this.hashCode = this.value instanceof byte[] ? (this.hashCode ^= Arrays.hashCode((byte[])this.value)) : (this.hashCode ^= this.value == null ? 0 : this.value.hashCode());
        }
        return this.hashCode;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "SD()";
            }
            case 1: {
                return "ED()";
            }
            case 2: {
                return "SE({" + this.namespace + "}" + this.name + ")";
            }
            case 3: {
                return "A({" + this.namespace + "}" + this.name + "=" + this.value + ")";
            }
            case 12: {
                return "TA({" + this.namespace + "}" + this.name + "=" + this.value + ")";
            }
            case 4: {
                return "EE({" + this.namespace + "}" + this.name + ")";
            }
            case 5: {
                return "C(" + this.value + ")";
            }
            case 6: {
                return "TC([{" + this.namespace + "}" + this.name + "]" + String.valueOf(this.value) + ")";
            }
            case 7: {
                return "NP(" + this.namespace + "=" + this.value + ")";
            }
            case 8: {
                return "CM(" + this.value + ")";
            }
            case 9: {
                return "PI(" + this.value + ")";
            }
            case 10: {
                return "ER(" + this.name + ")";
            }
            case 11: {
                return "DTD(" + this.value + ")";
            }
        }
        return "UE()";
    }
}

