/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.TransformedEventStream;
import fc.fp.util.xas.XmlReader;
import java.util.Enumeration;

public class DataEventSequence
extends TransformedEventStream {
    protected boolean normalizeWhitespace = true;
    protected boolean stripDocumentStartEnd = false;
    protected EventList preamble = new EventList();

    public DataEventSequence(EventSequence in) {
        super(in);
        Event e;
        Enumeration en = in.events();
        while (en.hasMoreElements() && (e = (Event)en.nextElement()).getType() != 2) {
            if (e.getType() == 0) continue;
            this.preamble.add(e);
        }
    }

    public DataEventSequence(EventSequence in, boolean normalizeWhitespace, boolean stripDocumentStartEnd) {
        this(in);
        this.normalizeWhitespace = normalizeWhitespace;
        this.stripDocumentStartEnd = stripDocumentStartEnd;
    }

    public EventSequence getPreamble() {
        return this.preamble;
    }

    protected void transform(Event ev, EventList el, XmlReader xr) {
        if (ev.getType() == 8) {
            return;
        }
        if (ev.getType() == 5 && this.normalizeWhitespace && this.isWhiteSpace((String)ev.getValue())) {
            return;
        }
        if (ev.getType() == 9) {
            return;
        }
        if (ev.getType() == 7) {
            return;
        }
        if ((ev.getType() == 0 || ev.getType() == 1) && this.stripDocumentStartEnd) {
            return;
        }
        el.add(ev);
    }

    protected final boolean isWhiteSpace(String s) {
        int pos;
        int len = s.length();
        if (len == 0) {
            return true;
        }
        char ch = s.charAt(pos);
        for (pos = 0; pos < len; ++pos) {
            if (s.charAt(pos) <= ' ' || Character.isWhitespace(s.charAt(pos))) continue;
            return false;
        }
        return true;
    }
}

