/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.Util;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.XmlReader;
import java.util.Hashtable;

public abstract class ContentDecoder {
    private Hashtable prefixMapping;
    private ContentDecoder root;

    protected ContentDecoder() {
        this(new Hashtable());
    }

    protected ContentDecoder(Hashtable prefixMapping) {
        this.prefixMapping = prefixMapping;
        this.root = this;
    }

    public abstract Object decode(String var1, String var2, XmlReader var3, EventList var4);

    protected Object expect(String elementNs, String elementName, XmlReader reader) {
        Object result = null;
        int pos = reader.getCurrentPosition();
        Event ev = reader.advance();
        if (ev != null && ev.getType() == 2 && Util.equals(ev.getNamespace(), elementNs) && Util.equals(ev.getName(), elementName)) {
            ev = reader.advance();
            String typeNs = null;
            String typeName = null;
            EventList attributes = null;
            while (ev != null && ev.getType() == 3) {
                if (Util.equals(ev.getNamespace(), "http://www.w3.org/2001/XMLSchema-instance") && Util.equals(ev.getName(), "type")) {
                    String type = (String)ev.getValue();
                    int i = type.indexOf(58);
                    String typePrefix = type.substring(0, i);
                    typeName = type.substring(i + 1);
                    typeNs = this.mapNamespace(typePrefix);
                } else {
                    if (attributes == null) {
                        attributes = new EventList();
                    }
                    attributes.add(ev);
                }
                ev = reader.advance();
            }
            if (ev != null && ev.getType() == 6) {
                result = ev.getValue();
            } else {
                reader.backup();
                if (typeNs != null && typeName != null) {
                    result = this.root.decode(typeNs, typeName, reader, attributes);
                }
            }
            reader.advance();
        }
        if (result == null) {
            reader.setCurrentPosition(pos);
        }
        return result;
    }

    public void insertPrefixMapping(String namespace, String prefix) {
        this.prefixMapping.put(prefix, namespace);
    }

    public void deletePrefixMapping(String prefix) {
        this.prefixMapping.remove(prefix);
    }

    public String mapNamespace(String prefix) {
        return (String)this.prefixMapping.get(prefix);
    }

    public void setRoot(ContentDecoder root) {
        this.root = root;
    }

    public String toString() {
        return this.getClass().toString() + "(" + this.prefixMapping + ")";
    }
}

