/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.xas.ContentDecoder;
import fc.fp.util.xas.ContentEncoder;
import fc.fp.util.xas.Qname;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ContentCodecFactory {
    private static Hashtable typeMappings = new Hashtable();
    private static Vector namespaces = new Vector();

    protected static void addNamespace(String namespace, String prefix) {
        namespaces.addElement(new Qname(namespace, prefix));
    }

    public static Qname getXmlName(Class cls) {
        Qname pair = (Qname)typeMappings.get(cls);
        if (pair == null) {
            Enumeration en = typeMappings.keys();
            while (en.hasMoreElements()) {
                Class cl = (Class)en.nextElement();
                if (!cl.isAssignableFrom(cls)) continue;
                pair = (Qname)typeMappings.get(cl);
                break;
            }
        }
        return pair;
    }

    public static void addTypeMapping(Class cls, Qname name) {
        typeMappings.put(cls, name);
    }

    public static Vector getNamespaces() {
        return namespaces;
    }

    public void register() {
    }

    public abstract ContentEncoder getChainedEncoder(ContentEncoder var1);

    public abstract ContentDecoder getChainedDecoder(ContentDecoder var1);

    static {
        try {
            typeMappings.put(Class.forName("java.lang.Boolean"), new Qname("http://www.w3.org/2001/XMLSchema", "boolean"));
            typeMappings.put(Class.forName("java.lang.Integer"), new Qname("http://www.w3.org/2001/XMLSchema", "int"));
            typeMappings.put(Class.forName("java.lang.String"), new Qname("http://www.w3.org/2001/XMLSchema", "string"));
            typeMappings.put(Class.forName("java.util.Calendar"), new Qname("http://www.w3.org/2001/XMLSchema", "dateTime"));
            typeMappings.put(Class.forName("[B"), new Qname("http://www.w3.org/2001/XMLSchema", "base64Binary"));
            typeMappings.put(Class.forName("java.lang.Long"), new Qname("http://www.w3.org/2001/XMLSchema", "long"));
            typeMappings.put(Class.forName("java.lang.Short"), new Qname("http://www.w3.org/2001/XMLSchema", "short"));
            typeMappings.put(Class.forName("java.lang.Byte"), new Qname("http://www.w3.org/2001/XMLSchema", "byte"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

