/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util.xas;

import fc.fp.util.xas.CodecFactory;
import fc.fp.util.xas.ContentCodecFactory;
import fc.fp.util.xas.codec.DefaultCodecFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CodecIndustry {
    private static final String CONFIG_KEY = "xas.factories";
    private static final String CONFIG_FILE = "xas.factories";
    private static Map factories;
    private static Set existFactories;
    private static Vector codecFactories;
    private static Vector names;

    private CodecIndustry() {
    }

    public static void registerFactory(String type, CodecFactory factory) {
        if (factory == null) {
            factories.remove(type);
        } else {
            factories.put(type, factory);
            factory.installContentFactories(codecFactories);
        }
    }

    public static CodecFactory getFactory(String type) {
        return (CodecFactory)factories.get(type);
    }

    public static void registerContentFactory(ContentCodecFactory factory) {
        if (!existFactories.contains(factory.getClass())) {
            existFactories.add(factory.getClass());
            codecFactories.add(factory);
            factory.register();
        }
    }

    public static Set availableTypes() {
        return factories.keySet();
    }

    static {
        URL url;
        block12: {
            factories = new HashMap();
            existFactories = new HashSet();
            codecFactories = new Vector();
            names = new Vector();
            CodecIndustry.registerContentFactory(new DefaultCodecFactory());
            try {
                Class.forName("fc.fp.util.xas.XmlCodecFactory");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            String resource = System.getProperty("xas.factories", "xas.factories");
            url = null;
            try {
                url = new URL(resource);
            }
            catch (MalformedURLException e) {
                ClassLoader loader = CodecIndustry.class.getClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                if ((url = loader.getResource(resource)) != null) break block12;
                url = ClassLoader.getSystemResource(resource);
            }
        }
        if (url != null) {
            try {
                InputStream stream = url.openStream();
                if (stream != null) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                    while ((line = reader.readLine()) != null) {
                        try {
                            Class.forName(line);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

