/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util;

public final class Util {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Util() {
    }

    public static String toHex(byte b) {
        return new Character(hexDigits[(b & 0xF0) >> 4]).toString() + hexDigits[b & 0xF];
    }

    public static boolean isPrintable(byte b) {
        return b >= 32 && b < 127;
    }

    public static String toPrintable(byte[] buffer, int offset, int length) {
        StringBuffer value = new StringBuffer();
        for (int i = offset; i < offset + length; ++i) {
            if (Util.isPrintable(buffer[i])) {
                value.append((char)buffer[i]);
                continue;
            }
            value.append("%" + Util.toHex(buffer[i]));
        }
        return value.toString();
    }

    public static String toPrintable(byte[] buffer) {
        return Util.toPrintable(buffer, 0, buffer.length);
    }

    public static String toPrintable(String string) {
        return Util.toPrintable(string.getBytes());
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    public static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        int n2;
        int n1;
        boolean result = false;
        if (s1 == null) {
            result = s2 == null;
        } else if (s2 != null && (n1 = s1.length()) == (n2 = s2.length())) {
            char c2;
            char c1;
            int i;
            for (i = 0; i < n1 && ((c1 = s1.charAt(i)) == (c2 = s2.charAt(i)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))); ++i) {
            }
            if (i == n1) {
                result = true;
            }
        }
        return result;
    }

    public static Object[] ensureCapacity(Object[] array, int needed) {
        if (array.length >= needed) {
            return array;
        }
        Object[] newArray = new Object[needed + 16];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static String[] ensureCapacity(String[] array, int needed) {
        if (array.length >= needed) {
            return array;
        }
        String[] newArray = new String[needed + 16];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static int[] ensureCapacity(int[] array, int needed) {
        if (array.length >= needed) {
            return array;
        }
        int[] newArray = new int[needed + 16];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static int[] ensureCapacityMultiply(int[] array, int multiplier, int needed) {
        if (array.length >= (needed *= multiplier)) {
            return array;
        }
        int[] newArray = new int[needed + 16 * multiplier];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }
}

